-- --------------------------------------------------------
-- Sunucu:                       localhost
-- Sunucu sürümü:                10.4.32-MariaDB - mariadb.org binary distribution
-- Sunucu İşletim Sistemi:       Win64
-- HeidiSQL Sürüm:               12.11.0.7065
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

-- tablo yapısı dökülüyor vts_database.migrations
CREATE TABLE IF NOT EXISTS `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- vts_database.migrations: ~2 rows (yaklaşık) tablosu için veriler indiriliyor
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(1, '2025_10_08_000001_fix_vts_users_columns', 1),
	(2, '2025_10_09_000001_fix_vts_sessions_table', 2);

-- tablo yapısı dökülüyor vts_database.vts_cache
CREATE TABLE IF NOT EXISTS `vts_cache` (
  `key` varchar(200) NOT NULL,
  `value` mediumtext NOT NULL,
  `expiration` int(11) NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- vts_database.vts_cache: 0 rows tablosu için veriler indiriliyor
/*!40000 ALTER TABLE `vts_cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `vts_cache` ENABLE KEYS */;

-- tablo yapısı dökülüyor vts_database.vts_categories
CREATE TABLE IF NOT EXISTS `vts_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sid` int(11) NOT NULL COMMENT 'Store ID',
  `mid` int(11) NOT NULL COMMENT 'Member ID',
  `ord` int(2) NOT NULL DEFAULT 0 COMMENT 'order',
  `name` varchar(255) NOT NULL COMMENT 'name',
  `pcnt` int(5) NOT NULL DEFAULT 0 COMMENT 'product count',
  `sts` int(1) NOT NULL DEFAULT 0 COMMENT 'status ID',
  `extra_data_json` longtext NOT NULL COMMENT 'Extra data JSON (not currently used)',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_by` varchar(255) NOT NULL DEFAULT '',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_by` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- vts_database.vts_categories: 2 rows tablosu için veriler indiriliyor
/*!40000 ALTER TABLE `vts_categories` DISABLE KEYS */;
INSERT INTO `vts_categories` (`id`, `sid`, `mid`, `ord`, `name`, `pcnt`, `sts`, `extra_data_json`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES
	(20, 0, 3, 5, 'Categoty 2', 0, 1, '', '2025-10-06 20:56:03', '', '2025-10-07 21:04:02', '3'),
	(21, 2, 3, 1, 'Categoty 1', 0, 1, '', '2025-10-06 21:07:09', '3', '2025-10-07 21:03:57', '3');
/*!40000 ALTER TABLE `vts_categories` ENABLE KEYS */;

-- tablo yapısı dökülüyor vts_database.vts_category_devices
CREATE TABLE IF NOT EXISTS `vts_category_devices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Category ID reference',
  `device_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Device ID reference',
  `created_at` timestamp NULL DEFAULT NULL COMMENT 'Assignment creation time',
  `created_by` int(11) NOT NULL DEFAULT 0 COMMENT 'User ID who created the assignment',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- vts_database.vts_category_devices: 1 rows tablosu için veriler indiriliyor
/*!40000 ALTER TABLE `vts_category_devices` DISABLE KEYS */;
INSERT INTO `vts_category_devices` (`id`, `category_id`, `device_id`, `created_at`, `created_by`) VALUES
	(7, 20, 1, '2025-10-07 20:57:52', 3),
	(9, 21, 38, '2025-10-09 09:42:17', 3),
	(10, 20, 38, '2025-10-09 09:42:20', 3);
/*!40000 ALTER TABLE `vts_category_devices` ENABLE KEYS */;

-- tablo yapısı dökülüyor vts_database.vts_devices
CREATE TABLE IF NOT EXISTS `vts_devices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sid` int(11) NOT NULL DEFAULT 0 COMMENT 'store id',
  `mid` int(11) NOT NULL DEFAULT 0 COMMENT 'member id',
  `did` varchar(17) DEFAULT '0' COMMENT 'cihaz id',
  `gsm` varchar(17) DEFAULT '0' COMMENT 'gsm number',
  `imei` varchar(20) DEFAULT '0' COMMENT 'device IMEI',
  `sts` varchar(255) NOT NULL DEFAULT '0' COMMENT 'Status: [0]Depoda Pasif[1]Depoda Aktif[2]Musteride Aktif[3]Musteride Pasif[4]Teslim Alindi[5]Silindi',
  `is_engine_blocked` int(11) DEFAULT 0 COMMENT 'Engine block status: 0=No, 1=Yes',
  `ord` int(11) NOT NULL DEFAULT 0 COMMENT 'Order',
  `nm` varchar(255) NOT NULL COMMENT 'Name',
  `typ` int(11) DEFAULT NULL COMMENT 'Cihaz marka/model',
  `own` int(11) DEFAULT 0 COMMENT 'Kira/Satış Edinme',
  `category_ids_json` varchar(255) DEFAULT '["0"]' COMMENT 'Category IDs JSON array',
  `usr` varchar(255) DEFAULT NULL COMMENT 'Cihaza tanimli kullanicilar',
  `ga` varchar(255) DEFAULT NULL COMMENT 'Genel Alarmlar',
  `sens` varchar(255) DEFAULT NULL COMMENT 'sensor info',
  `extra_data_json` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'Extra settings JSON' CHECK (json_valid(`extra_data_json`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_by` varchar(255) NOT NULL DEFAULT '',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_by` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_vts_devices_mid_sts` (`mid`,`sts`)
) ENGINE=MyISAM AUTO_INCREMENT=62 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- vts_database.vts_devices: 2 rows tablosu için veriler indiriliyor
/*!40000 ALTER TABLE `vts_devices` DISABLE KEYS */;
INSERT INTO `vts_devices` (`id`, `sid`, `mid`, `did`, `gsm`, `imei`, `sts`, `is_engine_blocked`, `ord`, `nm`, `typ`, `own`, `category_ids_json`, `usr`, `ga`, `sens`, `extra_data_json`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES
	(1, 2, 3, 'aebcc2b375a24f3f0', '5314293928', '86135903567855412', '3', 0, 0, 'Vehicle 1', 14, 1, '["0"]', '[]', '', NULL, '{"id":"1","nm":"Vehicle 1","plt":"34ABC123","drvr":"Driver Name","lt":"8","lttl":"13","icon":"convertible.png","cats":["0"],"fuel_type":"diesel"}', '2025-07-02 07:31:00', '', '2025-10-07 21:05:27', ''),
	(38, 2, 3, '352016703347070', '5389571933', '352016703347070', '3', 0, 0, 'FMB920', 3, 2, '["0"]', '[]', '', NULL, '{"id":"38","nm":"FMB920","plt":"","drvr":"","lt":8,"lttl":"","cats":["0"],"fuel_type":"gasoline"}', '2025-07-02 07:31:00', '', '2025-07-04 03:16:52', '');
/*!40000 ALTER TABLE `vts_devices` ENABLE KEYS */;

-- tablo yapısı dökülüyor vts_database.vts_device_alarms
CREATE TABLE IF NOT EXISTS `vts_device_alarms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL COMMENT 'Member ID',
  `did` varchar(50) NOT NULL DEFAULT '' COMMENT 'device_Werd63 ID',
  `aid` int(11) NOT NULL COMMENT 'Alarm Form ID',
  `sts` int(11) NOT NULL COMMENT 'Status 1 Active/ 0 Pasif',
  `sid` int(11) NOT NULL DEFAULT 0 COMMENT 'Send Notıfıcatıon Status 1 send / 0 not',
  `settings_json` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'Settings JSON' CHECK (json_valid(`settings_json`)),
  `send_datetime` datetime NOT NULL DEFAULT current_timestamp() COMMENT 'Last notitification send datetime',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_by` varchar(255) NOT NULL DEFAULT '',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_by` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- vts_database.vts_device_alarms: 29 rows tablosu için veriler indiriliyor
/*!40000 ALTER TABLE `vts_device_alarms` DISABLE KEYS */;
INSERT INTO `vts_device_alarms` (`id`, `mid`, `did`, `aid`, `sts`, `sid`, `settings_json`, `send_datetime`, `created_at`, `created_by`, `updated_at`, `updated_by`) VALUES
	(3, 3, 'aebcc2b375a24f3f0', 301, 1, 0, '{"status_id_301":"1","inspection_date":"2025-10-01","device_id":"aebcc2b375a24f3f0","alarm_form_id":"301"}', '2021-04-15 00:00:00', '2025-06-18 03:59:43', '', '2025-10-07 21:04:25', '3'),
	(4, 3, 'aebcc2b375a24f3f0', 302, 0, 0, '{"password":"123456","status_id_302":"0","device_id":"aebcc2b375a24f3f0","alarm_form_id":"302"}', '2021-04-17 00:00:00', '2025-06-18 03:59:43', '', '2025-06-28 07:26:07', '3'),
	(5, 3, 'aebcc2b375a24f3f0', 303, 1, 1, '{"id":"5","did":"aebcc2b375a24f3f0","gaid":"303","sts":"1","wd0":"wd0","wd0hs":"11","wd0ms":"00","wd0he":"16","wd0me":"00","wd1":"wd1","wd1hs":"11","wd1ms":"00","wd1he":"12","wd1me":"00","wd2":"wd2","wd2hs":"11","wd2ms":"00","wd2he":"15","wd2me":"00","wd3":"wd3","wd3hs":"07","wd3ms":"00","wd3he":"11","wd3me":"00","wd4":"wd4","wd4hs":"07","wd4ms":"00","wd4he":"10","wd4me":"00","wd5hs":"00","wd5ms":"00","wd5he":"00","wd5me":"00","wd6hs":"00","wd6ms":"00","wd6he":"00","wd6me":"00","bld":"1"}', '2022-03-10 00:00:00', '2025-06-18 03:59:43', '', '2025-06-18 03:59:43', ''),
	(6, 28, 'a065da1caf236bea1', 302, 1, 0, '{"id":"6","did":"a065da1caf236bea1","gaid":"302","sts":"1","km":"37590","ckm":"10000","gsm":"5382344216","email":"abdulkadirozhim1@gmail.com"}', '2021-09-30 00:00:00', '2025-06-18 03:59:43', '', '2025-06-18 03:59:43', ''),
	(7, 28, 'ec3ac072d8407615f', 302, 1, 1, '{"id":"","did":"ec3ac072d8407615f","gaid":"302","sts":"1","km":"212186","ckm":"10000","gsm":"5382344216","email":"abdulkadirozhim1@gmail.com"}', '2021-09-30 00:00:00', '2025-06-18 03:59:43', '', '2025-06-18 03:59:43', ''),
	(8, 28, '66854ecc5d992c090', 302, 0, 0, '{"id":"8","did":"66854ecc5d992c090","gaid":"302","sts":"1","km":"36725","ckm":"10000","gsm":"","email":""}', '2021-10-08 00:00:00', '2025-06-18 03:59:43', '', '2025-06-18 03:59:43', ''),
	(9, 18, 'a1a58402fabc488f0', 303, 1, 1, '{"id":"9","did":"a1a58402fabc488f0","gaid":"303","sts":"1","wd0":"wd0","wd0hs":"08","wd0ms":"00","wd0he":"15","wd0me":"00","wd1":"wd1","wd1hs":"08","wd1ms":"00","wd1he":"15","wd1me":"00","wd2":"wd2","wd2hs":"08","wd2ms":"00","wd2he":"15","wd2me":"00","wd3":"wd3","wd3hs":"08","wd3ms":"00","wd3he":"15","wd3me":"00","wd4":"wd4","wd4hs":"08","wd4ms":"00","wd4he":"15","wd4me":"00","wd5":"wd5","wd5hs":"08","wd5ms":"00","wd5he":"15","wd5me":"00","wd6":"wd6","wd6hs":"08","wd6ms":"00","wd6he":"12","wd6me":"00","bld":"1"}', '2022-03-09 00:00:00', '2025-06-18 03:59:43', '', '2025-06-18 03:59:43', ''),
	(10, 18, '44fe033664dac2621', 303, 1, 1, '{"id":"","did":"44fe033664dac2621","gaid":"303","sts":"1","wd0":"wd0","wd0hs":"08","wd0ms":"00","wd0he":"15","wd0me":"00","wd1":"wd1","wd1hs":"08","wd1ms":"00","wd1he":"15","wd1me":"00","wd2":"wd2","wd2hs":"08","wd2ms":"00","wd2he":"15","wd2me":"00","wd3":"wd3","wd3hs":"08","wd3ms":"00","wd3he":"15","wd3me":"00","wd4":"wd4","wd4hs":"08","wd4ms":"00","wd4he":"15","wd4me":"00","wd5":"wd5","wd5hs":"08","wd5ms":"00","wd5he":"15","wd5me":"00","wd6":"wd6","wd6hs":"08","wd6ms":"00","wd6he":"15","wd6me":"00","bld":"1"}', '2022-03-10 00:00:00', '2025-06-18 03:59:43', '', '2025-06-18 03:59:43', ''),
	(11, 21, '4c72eb3d775e77e3b', 302, 1, 0, '{"id":"","did":"4c72eb3d775e77e3b","gaid":"302","km":"54596","ckm":"60000","gsm":"05323138047","email":"ferit@tamguvenlik.com.tr"}', '2022-02-11 00:00:00', '2025-06-18 03:59:43', '', '2025-06-18 03:59:43', ''),
	(12, 21, '4c72eb3d775e77e3b', 303, 1, 1, '{"id":"12","did":"4c72eb3d775e77e3b","gaid":"303","sts":"1","wd0":"wd0","wd0hs":"08","wd0ms":"00","wd0he":"20","wd0me":"00","wd1":"wd1","wd1hs":"08","wd1ms":"00","wd1he":"20","wd1me":"00","wd2":"wd2","wd2hs":"08","wd2ms":"00","wd2he":"20","wd2me":"00","wd3":"wd3","wd3hs":"08","wd3ms":"00","wd3he":"20","wd3me":"00","wd4":"wd4","wd4hs":"08","wd4ms":"00","wd4he":"20","wd4me":"00","wd5":"wd5","wd5hs":"08","wd5ms":"00","wd5he":"16","wd5me":"00","wd6hs":"00","wd6ms":"00","wd6he":"00","wd6me":"00","bld":"1"}', '2022-03-09 00:00:00', '2025-06-18 03:59:43', '', '2025-06-18 03:59:43', ''),
	(13, 21, '7d8fbc41b40287e28', 302, 1, 0, '{"id":"13","did":"7d8fbc41b40287e28","gaid":"302","sts":"1","km":"201110","ckm":"1000","gsm":"05323138047","email":"atilla@tamguvenlik.com.tr"}', '2022-02-14 00:00:00', '2025-06-18 03:59:43', '', '2025-06-18 03:59:43', ''),
	(14, 21, '7d8fbc41b40287e28', 301, 1, 0, '{"status_id_301":"1","inspection_date":"2025-11-07","device_id":"7d8fbc41b40287e28","alarm_form_id":"301"}', '2022-02-14 00:00:00', '2025-06-18 03:59:43', '', '2025-07-07 05:02:22', '21'),
	(15, 21, '7d8fbc41b40287e28', 303, 1, 1, '{"id":"15","did":"7d8fbc41b40287e28","gaid":"303","sts":"1","wd0":"wd0","wd0hs":"08","wd0ms":"00","wd0he":"19","wd0me":"00","wd1":"wd1","wd1hs":"08","wd1ms":"00","wd1he":"19","wd1me":"00","wd2":"wd2","wd2hs":"08","wd2ms":"00","wd2he":"19","wd2me":"00","wd3":"wd3","wd3hs":"08","wd3ms":"00","wd3he":"19","wd3me":"00","wd4":"wd4","wd4hs":"08","wd4ms":"00","wd4he":"19","wd4me":"00","wd5hs":"16","wd5ms":"00","wd5he":"08","wd5me":"00","wd6hs":"00","wd6ms":"00","wd6he":"23","wd6me":"59","bld":"1"}', '2022-02-28 00:00:00', '2025-06-18 03:59:43', '', '2025-06-18 03:59:43', ''),
	(16, 21, '9d67f34c0d92da9e7', 303, 1, 1, '{"id":"16","did":"9d67f34c0d92da9e7","gaid":"303","sts":"1","wd0":"wd0","wd0hs":"08","wd0ms":"00","wd0he":"19","wd0me":"00","wd1":"wd1","wd1hs":"08","wd1ms":"00","wd1he":"19","wd1me":"00","wd2":"wd2","wd2hs":"08","wd2ms":"00","wd2he":"19","wd2me":"00","wd3":"wd3","wd3hs":"08","wd3ms":"00","wd3he":"19","wd3me":"00","wd4":"wd4","wd4hs":"08","wd4ms":"00","wd4he":"19","wd4me":"00","wd5":"wd5","wd5hs":"08","wd5ms":"00","wd5he":"16","wd5me":"00","wd6hs":"00","wd6ms":"00","wd6he":"00","wd6me":"01","bld":"1"}', '2022-03-09 00:00:00', '2025-06-18 03:59:43', '', '2025-06-18 03:59:43', ''),
	(18, 24, '032e93a231e56cb72', 302, 0, 1, '{"id":"","did":"032e93a231e56cb72","gaid":"302","sts":"1","km":"310000","ckm":"450000","gsm":"5427300543","email":"guroltopcu@gmail.com"}', '2022-02-22 00:00:00', '2025-06-18 03:59:43', '', '2025-06-18 03:59:43', ''),
	(19, 24, '032e93a231e56cb72', 303, 1, 0, '{"id":"","did":"032e93a231e56cb72","gaid":"303","wd0":"wd0","wd0hs":"08","wd0ms":"00","wd0he":"19","wd0me":"00","wd1":"wd1","wd1hs":"08","wd1ms":"00","wd1he":"19","wd1me":"00","wd2":"wd2","wd2hs":"08","wd2ms":"00","wd2he":"19","wd2me":"00","wd3":"wd3","wd3hs":"08","wd3ms":"00","wd3he":"19","wd3me":"00","wd4":"wd4","wd4hs":"08","wd4ms":"00","wd4he":"19","wd4me":"00","wd5hs":"00","wd5ms":"00","wd5he":"00","wd5me":"00","wd6hs":"00","wd6ms":"00","wd6he":"00","wd6me":"00","bld":"1"}', '2022-02-22 00:00:00', '2025-06-18 03:59:43', '', '2025-06-18 03:59:43', ''),
	(20, 40, '0190b4dcbd63bd3fe', 303, 1, 1, '{"id":"20","did":"0190b4dcbd63bd3fe","gaid":"303","sts":"1","wd0":"wd0","wd0hs":"08","wd0ms":"00","wd0he":"20","wd0me":"00","wd1":"wd1","wd1hs":"08","wd1ms":"00","wd1he":"20","wd1me":"00","wd2":"wd2","wd2hs":"08","wd2ms":"00","wd2he":"20","wd2me":"00","wd3":"wd3","wd3hs":"08","wd3ms":"00","wd3he":"20","wd3me":"00","wd4":"wd4","wd4hs":"08","wd4ms":"00","wd4he":"20","wd4me":"00","wd5":"wd5","wd5hs":"08","wd5ms":"00","wd5he":"16","wd5me":"00","wd6hs":"00","wd6ms":"00","wd6he":"00","wd6me":"00","bld":"1"}', '2022-03-10 00:00:00', '2025-06-18 03:59:43', '', '2025-06-18 03:59:43', ''),
	(21, 40, '3da51418ae7c6a801', 303, 1, 1, '{"id":"","did":"3da51418ae7c6a801","gaid":"303","sts":"1","wd0":"wd0","wd0hs":"08","wd0ms":"00","wd0he":"19","wd0me":"30","wd1":"wd1","wd1hs":"08","wd1ms":"00","wd1he":"19","wd1me":"30","wd2":"wd2","wd2hs":"08","wd2ms":"00","wd2he":"19","wd2me":"30","wd3":"wd3","wd3hs":"08","wd3ms":"00","wd3he":"19","wd3me":"30","wd4":"wd4","wd4hs":"08","wd4ms":"00","wd4he":"19","wd4me":"30","wd5":"wd5","wd5hs":"08","wd5ms":"00","wd5he":"19","wd5me":"30","wd6hs":"00","wd6ms":"00","wd6he":"00","wd6me":"00","bld":"1"}', '2022-03-08 00:00:00', '2025-06-18 03:59:43', '', '2025-06-18 03:59:43', ''),
	(22, 26, '3fbf7cc900977c0a7', 303, 1, 1, '{"id":"22","did":"3fbf7cc900977c0a7","gaid":"303","sts":"1","wd0":"wd0","wd0hs":"07","wd0ms":"00","wd0he":"20","wd0me":"00","wd1":"wd1","wd1hs":"07","wd1ms":"00","wd1he":"20","wd1me":"00","wd2":"wd2","wd2hs":"07","wd2ms":"00","wd2he":"20","wd2me":"00","wd3":"wd3","wd3hs":"07","wd3ms":"00","wd3he":"20","wd3me":"00","wd4":"wd4","wd4hs":"07","wd4ms":"00","wd4he":"20","wd4me":"00","wd5hs":"00","wd5ms":"00","wd5he":"00","wd5me":"00","wd6hs":"00","wd6ms":"00","wd6he":"00","wd6me":"00","bld":"1"}', '2022-03-09 00:00:00', '2025-06-18 03:59:43', '', '2025-06-18 03:59:43', ''),
	(23, 3, 'aebcc2b375a24f3f0', 304, 1, 0, '{"status_id_304":"1","speed_limit":"90","device_id":"aebcc2b375a24f3f0","alarm_form_id":"304"}', '2025-06-28 17:01:51', '2025-06-28 04:01:51', '3', '2025-07-01 07:09:53', '3'),
	(24, 3, 'aebcc2b375a24f3f0', 305, 1, 0, '{"status_id_305":"1","device_id":"aebcc2b375a24f3f0","alarm_form_id":"305"}', '2025-06-28 20:29:06', '2025-06-28 07:29:06', '3', '2025-06-28 07:39:38', '3'),
	(25, 3, 'aebcc2b375a24f3f0', 306, 0, 0, '{"status_id_306":"0","maintenance_km_date":"","maintenance_km":"","device_id":"aebcc2b375a24f3f0","alarm_form_id":"306"}', '2025-06-28 20:42:47', '2025-06-28 07:42:47', '3', '2025-10-07 01:21:33', '3'),
	(26, 3, 'aebcc2b375a24f3f0', 307, 1, 0, '{"status_id_307":"1","start_time_1":"09:00","end_time_1":"18:00","start_time_2":"09:00","end_time_2":"18:00","start_time_3":"09:00","end_time_3":"18:00","start_time_4":"09:00","end_time_4":"18:00","start_time_5":"09:00","end_time_5":"18:00","start_time_6":"","end_time_6":"","start_time_7":"","end_time_7":"","device_id":"aebcc2b375a24f3f0","alarm_form_id":"307"}', '2025-06-28 20:56:43', '2025-06-28 07:56:42', '3', '2025-10-07 00:06:49', '3'),
	(27, 21, '7d8fbc41b40287e28', 307, 0, 0, '{"status_id_307":"0","start_time_1":"09:00","end_time_1":"18:00","start_time_2":"09:00","end_time_2":"18:00","start_time_3":"09:00","end_time_3":"18:00","start_time_4":"09:00","end_time_4":"18:00","start_time_5":"09:00","end_time_5":"18:00","start_time_6":"","end_time_6":"","start_time_7":"","end_time_7":"","device_id":"7d8fbc41b40287e28","alarm_form_id":"307"}', '2025-06-29 00:17:21', '2025-06-28 11:17:20', '21', '2025-06-28 11:17:37', '21'),
	(28, 21, 'a1a58402fabc488f0', 307, 0, 0, '{"status_id_307":"0","start_time_1":"","end_time_1":"","start_time_2":"","end_time_2":"","start_time_3":"","end_time_3":"","start_time_4":"","end_time_4":"","start_time_5":"","end_time_5":"","start_time_6":"","end_time_6":"","start_time_7":"","end_time_7":"","device_id":"a1a58402fabc488f0","alarm_form_id":"307"}', '2025-07-02 20:43:58', '2025-07-02 07:43:57', '21', '2025-07-02 07:43:58', '21'),
	(29, 21, '7d8fbc41b40287e28', 304, 0, 0, '{"status_id_304":"0","speed_limit":"50","device_id":"7d8fbc41b40287e28","alarm_form_id":"304"}', '2025-07-06 21:51:37', '2025-07-06 08:51:36', '21', '2025-07-06 08:51:54', '21'),
	(30, 21, '7d8fbc41b40287e28', 306, 0, 0, '{"status_id_306":"0","maintenance_km_date":"2025-05-01","maintenance_km":"10000","device_id":"7d8fbc41b40287e28","alarm_form_id":"306"}', '2025-07-07 19:09:49', '2025-07-07 06:09:48', '21', '2025-07-07 07:37:56', '21'),
	(31, 21, '44fe033664dac2621', 305, 0, 0, '{"status_id_305":"0","p1":"11","p2":"11","device_id":"44fe033664dac2621","alarm_form_id":"305"}', '2025-07-09 15:53:24', '2025-07-09 02:53:23', '21', '2025-07-09 02:53:26', '21'),
	(32, 21, '44fe033664dac2621', 307, 0, 0, '{"status_id_307":"0","start_time_1":"","end_time_1":"","start_time_2":"","end_time_2":"","start_time_3":"","end_time_3":"","start_time_4":"","end_time_4":"","start_time_5":"","end_time_5":"","start_time_6":"","end_time_6":"","start_time_7":"","end_time_7":"","device_id":"44fe033664dac2621","alarm_form_id":"307"}', '2025-07-10 15:52:40', '2025-07-10 02:52:40', '21', '2025-07-10 02:52:42', '21');
/*!40000 ALTER TABLE `vts_device_alarms` ENABLE KEYS */;

-- tablo yapısı dökülüyor vts_database.vts_device_logs
CREATE TABLE IF NOT EXISTS `vts_device_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(50) DEFAULT NULL COMMENT 'IP adres',
  `did` varchar(50) DEFAULT NULL COMMENT 'device ID',
  `latitude` decimal(10,6) DEFAULT NULL COMMENT 'Latitude',
  `longitude` decimal(10,6) DEFAULT NULL COMMENT 'Longitude',
  `coord` point DEFAULT NULL COMMENT 'Coordinate ',
  `notification_sent` varchar(50) NOT NULL DEFAULT '0' COMMENT 'Notification sent status',
  `log_data_json` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'JSON log data',
  `log_datetime` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT 'Log datetime',
  `dt` timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'Db datetime',
  PRIMARY KEY (`id`),
  KEY `idx_vts_device_logs_did_id` (`did`,`id`),
  KEY `idx_vts_device_logs_did_log_datetime` (`did`,`log_datetime`)
) ENGINE=MyISAM AUTO_INCREMENT=2493 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- vts_database.vts_device_logs: 859 rows tablosu için veriler indiriliyor
/*!40000 ALTER TABLE `vts_device_logs` DISABLE KEYS */;
INSERT INTO `vts_device_logs` (`id`, `ip`, `did`, `latitude`, `longitude`, `coord`, `notification_sent`, `log_data_json`, `log_datetime`, `dt`) VALUES
	(2, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"19:44:16","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":79,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 19:44:16"}', '2025-08-24 16:44:16', '2025-08-24 17:07:50'),
	(3, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"19:59:44","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":97,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 19:59:44"}', '2025-08-24 16:59:44', '2025-08-24 17:07:51'),
	(19, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"00:06:18","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":223,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 00:06:18"}', '2025-08-23 21:06:18', '2025-08-24 21:06:19'),
	(20, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"00:21:42","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":25,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 00:21:42"}', '2025-08-23 21:21:42', '2025-08-24 21:21:44'),
	(21, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"00:37:07","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":258,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 00:37:07"}', '2025-08-23 21:37:07', '2025-08-24 21:37:08'),
	(22, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"00:52:30","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":183,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 00:52:30"}', '2025-08-23 21:52:30', '2025-08-24 21:52:31'),
	(23, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"01:07:54","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":2,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 01:07:54"}', '2025-08-23 22:07:54', '2025-08-24 22:07:55'),
	(24, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"01:23:18","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":187,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 01:23:18"}', '2025-08-23 22:23:18', '2025-08-24 22:23:19'),
	(25, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"01:38:42","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":258,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 01:38:42"}', '2025-08-23 22:38:42', '2025-08-24 22:38:43'),
	(26, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"01:54:06","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":244,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 01:54:06"}', '2025-08-23 22:54:06', '2025-08-24 22:54:08'),
	(27, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"02:09:30","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":26,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 02:09:30"}', '2025-08-23 23:09:30', '2025-08-24 23:09:32'),
	(28, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"02:24:55","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":320,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 02:24:55"}', '2025-08-23 23:24:55', '2025-08-24 23:24:56'),
	(29, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"02:40:19","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":168,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 02:40:19"}', '2025-08-23 23:40:19', '2025-08-24 23:40:20'),
	(30, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"02:55:42","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":232,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 02:55:42"}', '2025-08-23 23:55:42', '2025-08-24 23:55:44'),
	(152, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.647822, 29.284070, _binary 0x00000000010100000054c6bfcfb8483d40cf914bd2eb524440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"18.08.2025","sat":"08:59:17","ind":4,"enl":"40.6478217","boy":"029.284070","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":54.171,"mes":47337.8,"yon":207,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-18 08:59:17"}', '2025-08-18 05:59:17', '2025-08-25 05:59:18'),
	(1638, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"20:07:48","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":332,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 20:07:48"}', '2025-08-24 17:07:48', '2025-08-24 17:07:49'),
	(1639, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"20:15:10","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":236,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 20:15:10"}', '2025-08-24 17:15:10', '2025-08-24 17:15:11'),
	(1640, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"20:30:35","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":57,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 20:30:35"}', '2025-08-24 17:30:35', '2025-08-24 17:30:36'),
	(1641, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"20:45:59","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":123,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 20:45:59"}', '2025-08-24 17:45:59', '2025-08-24 17:46:00'),
	(1642, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"21:01:23","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":341,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 21:01:23"}', '2025-08-24 18:01:23', '2025-08-24 18:01:24'),
	(1643, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"21:16:47","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":170,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 21:16:47"}', '2025-08-24 18:16:47', '2025-08-24 18:16:49'),
	(1644, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"21:32:12","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":93,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 21:32:12"}', '2025-08-24 18:32:12', '2025-08-24 18:32:14'),
	(1645, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"21:47:37","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":193,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 21:47:37"}', '2025-08-24 18:47:37', '2025-08-24 18:47:39'),
	(1646, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"22:03:02","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":347,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 22:03:02"}', '2025-08-24 19:03:02', '2025-08-24 19:03:03'),
	(1647, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"22:18:27","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":271,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 22:18:27"}', '2025-08-24 19:18:27', '2025-08-24 19:18:28'),
	(1648, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"22:33:52","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":173,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 22:33:52"}', '2025-08-24 19:33:52', '2025-08-24 19:33:53'),
	(1649, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"22:49:17","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":47,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 22:49:17"}', '2025-08-24 19:49:17', '2025-08-24 19:49:18'),
	(1650, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"23:04:41","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":218,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 23:04:41"}', '2025-08-24 20:04:41', '2025-08-24 20:04:42'),
	(1651, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"23:20:05","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":289,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 23:20:05"}', '2025-08-24 20:20:05', '2025-08-24 20:20:07'),
	(1652, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"23:35:30","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":165,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 23:35:30"}', '2025-08-24 20:35:30', '2025-08-24 20:35:31'),
	(1653, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"24.08.2025","sat":"23:50:54","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":222,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-24 23:50:54"}', '2025-08-24 20:50:54', '2025-08-24 20:50:55'),
	(1654, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.950772, 29.304868, _binary 0x000000000101000000d09849d40b4e3d402dbb16e3b2794440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:00:07","ind":0,"enl":"40.9507717","boy":"029.304868","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":121.58380000000001,"mes":47547,"yon":302,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:00:07"}', '2025-08-24 21:00:07', '2025-08-25 21:00:11'),
	(1655, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.953125, 29.298606, _binary 0x000000000101000000ae635c71714c3d4000000000007a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:00:25","ind":0,"enl":"40.9531250","boy":"029.298606","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":117.12048000000001,"mes":47547.4,"yon":296,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:00:25"}', '2025-08-24 21:00:25', '2025-08-25 21:00:29'),
	(1656, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.955673, 29.293135, _binary 0x0000000001010000001e5036e50a4b3d408894b080537a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:00:41","ind":0,"enl":"40.9556733","boy":"029.293135","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":124.56552000000002,"mes":47548,"yon":305,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:00:41"}', '2025-08-24 21:00:41', '2025-08-25 21:00:43'),
	(1657, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.958793, 29.287315, _binary 0x00000000010100000076a6d0798d493d40dd8f25bdb97a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:00:58","ind":0,"enl":"40.9587933","boy":"029.287315","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":128.58436000000003,"mes":47548.6,"yon":299,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:00:58"}', '2025-08-24 21:00:58', '2025-08-25 21:00:59'),
	(1658, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.961062, 29.281395, _binary 0x0000000001010000000742b28009483d401678dd11047b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:01:14","ind":0,"enl":"40.9610617","boy":"029.281395","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":123.65804,"mes":47549.2,"yon":300,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:01:14"}', '2025-08-24 21:01:14', '2025-08-25 21:01:16'),
	(1659, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.964172, 29.275825, _binary 0x000000000101000000516b9a779c463d40479d6ffa697b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:01:31","ind":0,"enl":"40.9641717","boy":"029.275825","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":122.232,"mes":47549.6,"yon":313,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:01:31"}', '2025-08-24 21:01:31', '2025-08-25 21:01:37'),
	(1660, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.967872, 29.271276, _binary 0x00000000010100000090300c5872453d40aa1c4938e37b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:01:48","ind":0,"enl":"40.9678717","boy":"029.271276","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":116.28708,"mes":47550.2,"yon":314,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:01:48"}', '2025-08-24 21:01:48', '2025-08-25 21:01:51'),
	(1661, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.970628, 29.265580, _binary 0x000000000101000000c078060dfd433d403a89528c3d7c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:02:06","ind":0,"enl":"40.9706283","boy":"029.265580","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":116.10188000000001,"mes":47550.8,"yon":292,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:02:06"}', '2025-08-24 21:02:06', '2025-08-25 21:02:07'),
	(1662, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.971703, 29.259448, _binary 0x0000000001010000003a03232f6b423d40287513c6607c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:02:24","ind":0,"enl":"40.9717033","boy":"029.259448","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":101.35996,"mes":47551.4,"yon":278,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:02:24"}', '2025-08-24 21:02:24', '2025-08-25 21:02:26'),
	(1663, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.973270, 29.253011, _binary 0x0000000001010000003c873254c5403d40c616821c947c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:02:45","ind":0,"enl":"40.9732700","boy":"029.253011","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":102.6008,"mes":47551.8,"yon":297,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:02:45"}', '2025-08-24 21:02:45', '2025-08-25 21:02:46'),
	(1664, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.975352, 29.247195, _binary 0x00000000010100000017bce82b483f3d408bcc1253d87c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:03:03","ind":0,"enl":"40.9753517","boy":"029.247195","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":109.76804000000001,"mes":47552.4,"yon":287,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:03:03"}', '2025-08-24 21:03:03', '2025-08-25 21:03:05'),
	(1665, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.975920, 29.240535, _binary 0x0000000001010000001a8ba6b3933d3d4094c151f2ea7c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:03:21","ind":0,"enl":"40.9759200","boy":"029.240535","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":106.78632,"mes":47553,"yon":268,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:03:21"}', '2025-08-24 21:03:21', '2025-08-25 21:03:22'),
	(1666, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.975842, 29.236628, _binary 0x000000000101000000615111a7933c3d4059c97d61e87c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:03:34","ind":0,"enl":"40.9758417","boy":"029.236628","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":78.59888,"mes":47553.2,"yon":270,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:03:34"}', '2025-08-24 21:03:34', '2025-08-25 21:03:36'),
	(1667, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.975845, 29.236095, _binary 0x000000000101000000c6bfcfb8703c3d40897b2c7de87c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:03:36","ind":0,"enl":"40.9758450","boy":"029.236095","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":83.1548,"mes":47553.3,"yon":271,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:03:36"}', '2025-08-24 21:03:36', '2025-08-25 21:03:38'),
	(1668, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.976208, 29.231453, _binary 0x000000000101000000a38ff980403b3d40b94ac164f47c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:03:52","ind":0,"enl":"40.9762083","boy":"029.231453","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.22856,"mes":47553.7,"yon":281,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:03:52"}', '2025-08-24 21:03:52', '2025-08-25 21:03:53'),
	(1669, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.976752, 29.228525, _binary 0x0000000001010000008351499d803a3d40fde71f33067d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:04:04","ind":0,"enl":"40.9767517","boy":"029.228525","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":81.22872000000001,"mes":47553.9,"yon":286,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:04:04"}', '2025-08-24 21:04:04', '2025-08-25 21:04:08'),
	(1670, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.978610, 29.222333, _binary 0x00000000010100000052d2c3d0ea383d40f0c4ac17437d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:04:26","ind":0,"enl":"40.9786100","boy":"029.222333","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":102.48968,"mes":47554.5,"yon":297,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:04:26"}', '2025-08-24 21:04:26', '2025-08-25 21:04:27'),
	(1671, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.980957, 29.216780, _binary 0x000000000101000000486de2e47e373d4063a538fd8f7d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:04:45","ind":0,"enl":"40.9809567","boy":"029.216780","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":88.97008,"mes":47555.1,"yon":296,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:04:45"}', '2025-08-24 21:04:45', '2025-08-25 21:04:52'),
	(1672, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.982318, 29.210886, _binary 0x0000000001010000002b2ff99ffc353d409461269bbc7d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:05:07","ind":0,"enl":"40.9823183","boy":"029.210886","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":78.65444000000001,"mes":47555.5,"yon":277,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:05:07"}', '2025-08-24 21:05:07', '2025-08-25 21:05:09'),
	(1673, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.982672, 29.206445, _binary 0x000000000101000000376c5b94d9343d40341aaf2fc87d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:05:26","ind":0,"enl":"40.9826717","boy":"029.206445","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":81.22872000000001,"mes":47555.9,"yon":280,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:05:26"}', '2025-08-24 21:05:26', '2025-08-25 21:05:29'),
	(1674, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.984398, 29.200243, _binary 0x000000000101000000c040102043333d40775e74c3007e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:05:47","ind":0,"enl":"40.9843983","boy":"029.200243","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":96.52624,"mes":47556.5,"yon":301,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:05:47"}', '2025-08-24 21:05:47', '2025-08-25 21:05:50'),
	(1675, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.987765, 29.195010, _binary 0x0000000001010000009964e42cec313d40159161156f7e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:06:09","ind":0,"enl":"40.9877650","boy":"029.195010","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":99.8228,"mes":47557,"yon":311,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:06:09"}', '2025-08-24 21:06:09', '2025-08-25 21:06:16'),
	(1676, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.990138, 29.189260, _binary 0x000000000101000000e370e65773303d402e8210dabc7e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:06:28","ind":0,"enl":"40.9901383","boy":"029.189260","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":111.82376000000001,"mes":47557.5,"yon":284,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:06:28"}', '2025-08-24 21:06:28', '2025-08-25 21:06:30'),
	(1677, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.990512, 29.182400, _binary 0x00000000010100000058ca32c4b12e3d4016e75e16c97e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:06:47","ind":0,"enl":"40.9905117","boy":"029.182400","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":107.19376000000001,"mes":47558.1,"yon":270,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:06:47"}', '2025-08-24 21:06:47', '2025-08-25 21:06:54'),
	(1678, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.991198, 29.176126, _binary 0x000000000101000000adf9f197162d3d40e72cfd95df7e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:07:05","ind":0,"enl":"40.9911983","boy":"029.176126","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":103.73052,"mes":47558.7,"yon":285,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:07:05"}', '2025-08-24 21:07:05', '2025-08-25 21:07:07'),
	(1679, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.993048, 29.169776, _binary 0x0000000001010000004ca59f70762b3d4098ece9341c7f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:07:25","ind":0,"enl":"40.9930483","boy":"029.169776","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":103.45272,"mes":47559.2,"yon":292,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:07:25"}', '2025-08-24 21:07:25', '2025-08-25 21:07:26'),
	(1680, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.994527, 29.163466, _binary 0x000000000101000000080264e8d8293d40d9bfa1a64c7f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:07:43","ind":0,"enl":"40.9945267","boy":"029.163466","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":118.39836000000001,"mes":47559.7,"yon":278,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:07:43"}', '2025-08-24 21:07:43', '2025-08-25 21:07:46'),
	(1681, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.994723, 29.156463, _binary 0x000000000101000000b7088cf50d283d40db08d517537f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:08:01","ind":0,"enl":"40.9947233","boy":"029.156463","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":117.28716,"mes":47560.3,"yon":270,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:08:01"}', '2025-08-24 21:08:01', '2025-08-25 21:08:02'),
	(1682, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.994972, 29.149810, _binary 0x0000000001010000001f9dbaf259263d4007f98f3b5b7f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:08:19","ind":0,"enl":"40.9949717","boy":"029.149810","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":113.47204,"mes":47560.9,"yon":277,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:08:19"}', '2025-08-24 21:08:19', '2025-08-25 21:08:21'),
	(1683, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.996098, 29.142991, _binary 0x000000000101000000519fe40e9b243d40f40c2b26807f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:08:37","ind":0,"enl":"40.9960983","boy":"029.142991","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":117.63904000000001,"mes":47561.4,"yon":284,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:08:37"}', '2025-08-24 21:08:37', '2025-08-25 21:08:38'),
	(1684, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.997102, 29.136556, _binary 0x00000000010100000094128255f5223d409c244c07a17f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:08:54","ind":0,"enl":"40.9971017","boy":"029.136556","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":118.17612000000001,"mes":47562,"yon":274,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:08:54"}', '2025-08-24 21:08:54', '2025-08-25 21:08:56'),
	(1685, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.996827, 29.129928, _binary 0x000000000101000000aed51ef642213d40ca236e04987f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:09:12","ind":0,"enl":"40.9968267","boy":"029.129928","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":105.8418,"mes":47562.5,"yon":261,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:09:12"}', '2025-08-24 21:09:12', '2025-08-25 21:09:14'),
	(1686, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.995903, 29.122941, _binary 0x0000000001010000006956b60f791f3d403fbd63c2797f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:09:32","ind":0,"enl":"40.9959033","boy":"029.122941","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":109.30504,"mes":47563.1,"yon":263,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:09:32"}', '2025-08-24 21:09:32', '2025-08-25 21:09:34'),
	(1687, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.995958, 29.116508, _binary 0x000000000101000000edb8e177d31d3d400257c38f7b7f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:09:50","ind":0,"enl":"40.9959583","boy":"029.116508","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":107.58268000000001,"mes":47563.6,"yon":280,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:09:50"}', '2025-08-24 21:09:50', '2025-08-25 21:09:52'),
	(1688, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.997908, 29.110355, _binary 0x00000000010100000038f3ab39401c3d4017748c75bb7f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:10:09","ind":0,"enl":"40.9979083","boy":"029.110355","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":97.35964,"mes":47564.1,"yon":303,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:10:09"}', '2025-08-24 21:10:09', '2025-08-25 21:10:14'),
	(1689, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 41.001090, 29.105681, _binary 0x000000000101000000ffcef6e80d1b3d40232d95b723804440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:10:30","ind":0,"enl":"41.0010900","boy":"029.105681","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":93.58156000000001,"mes":47564.7,"yon":315,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:10:30"}', '2025-08-24 21:10:30', '2025-08-25 21:10:32'),
	(1690, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 41.004783, 29.101046, _binary 0x00000000010100000041649126de193d4092883abd9c804440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:10:51","ind":0,"enl":"41.0047833","boy":"029.101046","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":98.17452,"mes":47565.3,"yon":315,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:10:51"}', '2025-08-24 21:10:51', '2025-08-25 21:10:53'),
	(1691, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 41.007835, 29.096223, _binary 0x0000000001010000007d1f0e12a2183d40d061bebc00814440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:11:11","ind":0,"enl":"41.0078350","boy":"029.096223","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":93.3408,"mes":47565.7,"yon":302,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:11:11"}', '2025-08-24 21:11:11', '2025-08-25 21:11:13'),
	(1692, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 41.009592, 29.090061, _binary 0x00000000010100000022a5d93c0e173d4012e8024d3a814440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:11:33","ind":0,"enl":"41.0095917","boy":"029.090061","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":85.2846,"mes":47566.3,"yon":277,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:11:33"}', '2025-08-24 21:11:33', '2025-08-25 21:11:40'),
	(1693, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 41.009073, 29.083631, _binary 0x00000000010100000089ee59d768153d4026625b5029814440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:11:56","ind":0,"enl":"41.0090733","boy":"029.083631","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":84.93272,"mes":47566.8,"yon":252,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:11:56"}', '2025-08-24 21:11:56', '2025-08-25 21:11:57'),
	(1694, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 41.008087, 29.080841, _binary 0x0000000001010000000a2debfeb1143d402b0428fc08814440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:12:07","ind":0,"enl":"41.0080867","boy":"029.080841","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.04336,"mes":47567.1,"yon":240,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:12:07"}', '2025-08-24 21:12:07', '2025-08-25 21:12:15'),
	(1695, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 41.007987, 29.080605, _binary 0x000000000101000000e2e47e87a2143d40c7a64bb505814440, '0', '{"device_model":"Ortem","p":"0","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:12:08","ind":0,"enl":"41.0079867","boy":"029.080605","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":81.7658,"mes":47567.1,"yon":240,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:12:08"}', '2025-08-24 21:12:08', '2025-08-25 21:12:16'),
	(1696, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 41.005895, 29.073975, _binary 0x000000000101000000bbb88d06f0123d40df1ad82ac1804440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:12:34","ind":0,"enl":"41.0058950","boy":"029.073975","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":82.56216,"mes":47567.7,"yon":259,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:12:34"}', '2025-08-24 21:12:34', '2025-08-25 21:12:36'),
	(1697, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 41.006120, 29.067706, _binary 0x00000000010100000034be2f2e55113d40ffec478ac8804440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:12:57","ind":0,"enl":"41.0061200","boy":"029.067706","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":86.43284000000001,"mes":47568.3,"yon":289,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:12:57"}', '2025-08-24 21:12:57', '2025-08-25 21:12:59'),
	(1698, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 41.006740, 29.065935, _binary 0x00000000010100000069a9bc1de1103d409bc937dbdc804440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:13:04","ind":0,"enl":"41.0067400","boy":"029.065935","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.04344,"mes":47568.4,"yon":303,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:13:04"}', '2025-08-24 21:13:04', '2025-08-25 21:13:05'),
	(1699, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 41.010495, 29.062235, _binary 0x000000000101000000a4aa09a2ee0f3d40c1e270e657814440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:13:31","ind":0,"enl":"41.0104950","boy":"029.062235","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":54.893280000000004,"mes":47568.9,"yon":335,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:13:31"}', '2025-08-24 21:13:31', '2025-08-25 21:13:33'),
	(1700, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 41.009078, 29.061075, _binary 0x0000000001010000006b9a779ca20f3d4038cd4c7a29814440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:14:18","ind":0,"enl":"41.0090783","boy":"029.061075","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":45.170280000000005,"mes":47569.4,"yon":153,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:14:18"}', '2025-08-24 21:14:18', '2025-08-25 21:14:19'),
	(1701, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 41.004540, 29.059746, _binary 0x0000000001010000001b118c834b0f3d400dc347c494804440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:14:50","ind":0,"enl":"41.0045400","boy":"029.059746","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":71.80204,"mes":47569.9,"yon":199,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:14:50"}', '2025-08-24 21:14:50', '2025-08-25 21:14:55'),
	(1702, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 41.000008, 29.057483, _binary 0x0000000001010000007313b534b70e3d40411da04500804440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:15:18","ind":4,"enl":"41.0000083","boy":"029.057483","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":76.41352,"mes":47570.5,"yon":208,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:15:18"}', '2025-08-24 21:15:18', '2025-08-25 21:15:19'),
	(1703, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.999088, 29.056615, _binary 0x0000000001010000008a7615527e0e3d407a281b20e27f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:15:22","ind":0,"enl":"40.9990883","boy":"029.056615","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.8398,"mes":47570.6,"yon":220,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:15:22"}', '2025-08-24 21:15:22', '2025-08-25 21:15:24'),
	(1704, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.998068, 29.055261, _binary 0x00000000010100000088bebb95250e3d4050d6b9b3c07f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:15:29","ind":0,"enl":"40.9980683","boy":"029.055261","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.89528,"mes":47570.7,"yon":229,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:15:29"}', '2025-08-24 21:15:29', '2025-08-25 21:15:31'),
	(1705, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.997943, 29.055050, _binary 0x00000000010100000012a5bdc1170e3d409461269bbc7f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:15:30","ind":0,"enl":"40.9979433","boy":"029.055050","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.17308,"mes":47570.7,"yon":229,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:15:30"}', '2025-08-24 21:15:30', '2025-08-25 21:15:32'),
	(1706, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.994840, 29.050331, _binary 0x00000000010100000098f90e7ee20c3d405760c8ea567f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:15:51","ind":0,"enl":"40.9948400","boy":"029.050331","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":90.3776,"mes":47571.3,"yon":230,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:15:51"}', '2025-08-24 21:15:51', '2025-08-25 21:15:54'),
	(1707, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.993685, 29.046381, _binary 0x000000000101000000e1270ea0df0b3d404cc3f011317f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:16:06","ind":0,"enl":"40.9936850","boy":"029.046381","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.33968000000002,"mes":47571.6,"yon":256,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:16:06"}', '2025-08-24 21:16:06', '2025-08-25 21:16:07'),
	(1708, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.991058, 29.041163, _binary 0x00000000010100000025ce8aa8890a3d40f57695ffda7e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:16:31","ind":0,"enl":"40.9910583","boy":"029.041163","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":77.35804,"mes":47572.1,"yon":233,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:16:31"}', '2025-08-24 21:16:31', '2025-08-25 21:16:34'),
	(1709, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.990700, 29.036201, _binary 0x0000000001010000001e15ff7744093d40d712f241cf7e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:17:02","ind":0,"enl":"40.9907000","boy":"029.036201","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":35.669520000000006,"mes":47572.7,"yon":326,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:17:02"}', '2025-08-24 21:17:02', '2025-08-25 21:17:04'),
	(1710, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.994493, 29.032896, _binary 0x000000000101000000522b4cdf6b083d40aacb738e4b7f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:17:55","ind":0,"enl":"40.9944933","boy":"029.032896","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":13.871480000000002,"mes":47573.1,"yon":347,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:17:55"}', '2025-08-24 21:17:55', '2025-08-25 21:17:56'),
	(1711, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.993308, 29.032203, _binary 0x00000000010100000045d5af743e083d4035acf3b9247f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:18:57","ind":0,"enl":"40.9933083","boy":"029.032203","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47573.4,"yon":236,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 00:18:57"}', '2025-08-24 21:18:57', '2025-08-25 21:18:59'),
	(1712, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992882, 29.031985, _binary 0x0000000001010000006af6402b30083d4000265fbf167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:19:58","ind":0,"enl":"40.9928817","boy":"029.031985","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":3.3891600000000004,"mes":47573.5,"yon":147,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 00:19:58"}', '2025-08-24 21:19:58', '2025-08-25 21:20:00'),
	(1713, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992882, 29.031985, _binary 0x0000000001010000006af6402b30083d4000265fbf167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:20:39","ind":0,"enl":"40.9928817","boy":"029.031985","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":2.18536,"mes":47573.5,"yon":45,"A":"13","Sensor":"","drx":1,"ignition":1,"datetime":"2025-08-25 00:20:39"}', '2025-08-24 21:20:39', '2025-08-25 21:20:41'),
	(1714, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:36:05","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":59,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 00:36:05"}', '2025-08-24 21:36:05', '2025-08-25 21:36:07'),
	(1715, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:51:30","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":88,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 00:51:30"}', '2025-08-24 21:51:30', '2025-08-25 21:51:31'),
	(1716, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"00:59:54","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":177,"A":"4","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 00:59:54"}', '2025-08-24 21:59:54', '2025-08-25 21:59:56'),
	(1717, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"01:15:18","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":327,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 01:15:18"}', '2025-08-24 22:15:18', '2025-08-25 22:15:20'),
	(1718, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"01:30:43","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":159,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 01:30:43"}', '2025-08-24 22:30:43', '2025-08-25 22:30:44'),
	(1719, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"01:46:07","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":222,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 01:46:07"}', '2025-08-24 22:46:07', '2025-08-25 22:46:09'),
	(1720, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"02:01:32","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":209,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 02:01:32"}', '2025-08-24 23:01:32', '2025-08-25 23:01:33'),
	(1721, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"02:16:56","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":313,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 02:16:56"}', '2025-08-24 23:16:56', '2025-08-25 23:16:58'),
	(1722, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.552675, 29.350798, _binary 0x0000000001010000009180d1e5cd593d408d28ed0dbe464440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"02:26:06","ind":4,"enl":"40.5526750","boy":"029.350798","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":81.45096,"mes":47490.4,"yon":5,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 02:26:06"}', '2025-08-24 23:26:06', '2025-08-25 20:26:08'),
	(1723, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.552675, 29.350798, _binary 0x0000000001010000009180d1e5cd593d408d28ed0dbe464440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"02:26:30","ind":4,"enl":"40.5526750","boy":"029.350798","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":81.45096,"mes":47490.8,"yon":5,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 02:26:30"}', '2025-08-24 23:26:30', '2025-08-25 20:26:32'),
	(1724, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.552675, 29.350798, _binary 0x0000000001010000009180d1e5cd593d408d28ed0dbe464440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"02:26:54","ind":4,"enl":"40.5526750","boy":"029.350798","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":81.45096,"mes":47491.4,"yon":5,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 02:26:54"}', '2025-08-24 23:26:54', '2025-08-25 20:26:57'),
	(1725, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.552675, 29.350798, _binary 0x0000000001010000009180d1e5cd593d408d28ed0dbe464440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"02:27:19","ind":4,"enl":"40.5526750","boy":"029.350798","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":81.45096,"mes":47492,"yon":5,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 02:27:19"}', '2025-08-24 23:27:19', '2025-08-25 20:27:21'),
	(1726, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.552675, 29.350798, _binary 0x0000000001010000009180d1e5cd593d408d28ed0dbe464440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"02:27:44","ind":4,"enl":"40.5526750","boy":"029.350798","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":81.45096,"mes":47492.5,"yon":5,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 02:27:44"}', '2025-08-24 23:27:44', '2025-08-25 20:27:46'),
	(1727, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.552675, 29.350798, _binary 0x0000000001010000009180d1e5cd593d408d28ed0dbe464440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"02:28:09","ind":4,"enl":"40.5526750","boy":"029.350798","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":91.80364,"mes":47493,"yon":20,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 02:28:09"}', '2025-08-24 23:28:09', '2025-08-25 20:28:10'),
	(1728, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.552675, 29.350798, _binary 0x0000000001010000009180d1e5cd593d408d28ed0dbe464440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"02:28:09","ind":4,"enl":"40.5526750","boy":"029.350798","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":91.80364,"mes":47493,"yon":20,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 02:28:09"}', '2025-08-24 23:28:09', '2025-08-25 20:28:10'),
	(1729, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"02:32:21","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":24,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 02:32:21"}', '2025-08-24 23:32:21', '2025-08-25 23:32:22'),
	(1730, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"02:47:45","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":65,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 02:47:45"}', '2025-08-24 23:47:45', '2025-08-25 23:47:47'),
	(1731, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"03:11:06","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":175,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 03:11:06"}', '2025-08-25 00:11:06', '2025-08-25 00:11:07'),
	(1732, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"03:26:30","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":302,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 03:26:30"}', '2025-08-25 00:26:30', '2025-08-25 00:26:31'),
	(1733, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"03:41:54","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":58,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 03:41:54"}', '2025-08-25 00:41:54', '2025-08-25 00:41:55'),
	(1734, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"03:57:18","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":112,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 03:57:18"}', '2025-08-25 00:57:18', '2025-08-25 00:57:19'),
	(1735, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"04:12:42","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":288,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 04:12:42"}', '2025-08-25 01:12:42', '2025-08-25 01:12:43'),
	(1736, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"04:28:06","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":71,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 04:28:06"}', '2025-08-25 01:28:06', '2025-08-25 01:28:07'),
	(1737, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"04:43:30","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":291,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 04:43:30"}', '2025-08-25 01:43:30', '2025-08-25 01:43:31'),
	(1738, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"04:58:54","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":301,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 04:58:54"}', '2025-08-25 01:58:54', '2025-08-25 01:58:55'),
	(1739, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"05:14:18","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":158,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 05:14:18"}', '2025-08-25 02:14:18', '2025-08-25 02:14:19'),
	(1740, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"05:29:42","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":152,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 05:29:42"}', '2025-08-25 02:29:42', '2025-08-25 02:29:43'),
	(1741, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"05:45:06","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":162,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 05:45:06"}', '2025-08-25 02:45:06', '2025-08-25 02:45:07'),
	(1742, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"06:00:30","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":326,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 06:00:30"}', '2025-08-25 03:00:30', '2025-08-25 03:00:31'),
	(1743, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"06:15:54","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":186,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 06:15:54"}', '2025-08-25 03:15:54', '2025-08-25 03:15:55'),
	(1744, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"06:31:18","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":120,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 06:31:18"}', '2025-08-25 03:31:18', '2025-08-25 03:31:20'),
	(1745, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"06:46:43","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":105,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 06:46:43"}', '2025-08-25 03:46:43', '2025-08-25 03:46:44'),
	(1746, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:02:08","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":188,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 07:02:08"}', '2025-08-25 04:02:08', '2025-08-25 04:02:09'),
	(1747, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:17:32","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":138,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 07:17:32"}', '2025-08-25 04:17:32', '2025-08-25 04:17:33'),
	(1748, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992363, 29.031100, _binary 0x000000000101000000d5e76a2bf6073d4015a0b7c2057f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:19:33","ind":0,"enl":"40.9923633","boy":"029.031100","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":334,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 07:19:33"}', '2025-08-25 04:19:33', '2025-08-25 04:19:35'),
	(1749, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992332, 29.031200, _binary 0x0000000001010000009ca223b9fc073d405d24a3b9047f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:20:35","ind":0,"enl":"40.9923317","boy":"029.031200","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47309,"yon":351,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 07:20:35"}', '2025-08-25 04:20:35', '2025-08-25 04:20:36'),
	(1750, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.993263, 29.030503, _binary 0x0000000001010000000d6e6b0bcf073d4095e87640237f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:21:36","ind":0,"enl":"40.9932633","boy":"029.030503","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47309.1,"yon":322,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 07:21:36"}', '2025-08-25 04:21:36', '2025-08-25 04:21:38'),
	(1751, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.993263, 29.030503, _binary 0x0000000001010000000d6e6b0bcf073d4095e87640237f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:22:38","ind":0,"enl":"40.9932633","boy":"029.030503","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47309.2,"yon":357,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 07:22:38"}', '2025-08-25 04:22:38', '2025-08-25 04:22:39'),
	(1752, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.993263, 29.030503, _binary 0x0000000001010000000d6e6b0bcf073d4095e87640237f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:23:40","ind":0,"enl":"40.9932633","boy":"029.030503","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":2.0927599999999997,"mes":47309.2,"yon":20,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:23:40"}', '2025-08-25 04:23:40', '2025-08-25 04:23:41'),
	(1753, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.993620, 29.030976, _binary 0x000000000101000000fdf50a0bee073d406553aef02e7f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:24:41","ind":0,"enl":"40.9936200","boy":"029.030976","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":12.85288,"mes":47309.2,"yon":40,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:24:41"}', '2025-08-25 04:24:41', '2025-08-25 04:24:43'),
	(1754, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992003, 29.035090, _binary 0x000000000101000000a96a82a8fb083d401583d1f6f97e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:25:28","ind":0,"enl":"40.9920033","boy":"029.035090","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":61.541959999999996,"mes":47309.8,"yon":137,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:25:28"}', '2025-08-25 04:25:28', '2025-08-25 04:25:40'),
	(1755, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.988992, 29.037500, _binary 0x0000000001010000009a99999999093d40fac1af47977e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:26:03","ind":0,"enl":"40.9889917","boy":"029.037500","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":59.3566,"mes":47310.3,"yon":64,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:26:03"}', '2025-08-25 04:26:03', '2025-08-25 04:26:06'),
	(1756, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.992073, 29.043261, _binary 0x00000000010100000038312427130b3d400e5e0542fc7e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:26:31","ind":0,"enl":"40.9920733","boy":"029.043261","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":76.37648,"mes":47310.8,"yon":52,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:26:31"}', '2025-08-25 04:26:31', '2025-08-25 04:26:33'),
	(1757, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.993598, 29.047273, _binary 0x000000000101000000dbfb54151a0c3d403ceea53a2e7f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:26:49","ind":0,"enl":"40.9935983","boy":"029.047273","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":81.56208000000001,"mes":47311.2,"yon":75,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:26:49"}', '2025-08-25 04:26:49', '2025-08-25 04:26:54'),
	(1758, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.993755, 29.048038, _binary 0x0000000001010000001af7e6374c0c3d40459e245d337f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:26:52","ind":0,"enl":"40.9937550","boy":"029.048038","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.11744,"mes":47311.3,"yon":75,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:26:52"}', '2025-08-25 04:26:52', '2025-08-25 04:26:54'),
	(1759, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.994292, 29.049730, _binary 0x0000000001010000004da1f31abb0c3d4095174ff3447f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:26:59","ind":0,"enl":"40.9942917","boy":"029.049730","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.78424,"mes":47311.4,"yon":60,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:26:59"}', '2025-08-25 04:26:59', '2025-08-25 04:27:06'),
	(1760, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.994388, 29.049970, _binary 0x000000000101000000f7c77bd5ca0c3d403403a61d487f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:27:00","ind":0,"enl":"40.9943883","boy":"029.049970","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":78.13588,"mes":47311.4,"yon":58,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:27:00"}', '2025-08-25 04:27:00', '2025-08-25 04:27:07'),
	(1761, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.995007, 29.050950, _binary 0x00000000010100000030bb270f0b0d3d4083e629615c7f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:27:05","ind":0,"enl":"40.9950067","boy":"029.050950","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.26568,"mes":47311.5,"yon":49,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:27:05"}', '2025-08-25 04:27:05', '2025-08-25 04:27:07'),
	(1762, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.995800, 29.052153, _binary 0x000000000101000000676325e6590d3d40acadd85f767f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:27:11","ind":0,"enl":"40.9958000","boy":"029.052153","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.173,"mes":47311.7,"yon":51,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:27:11"}', '2025-08-25 04:27:11', '2025-08-25 04:27:20'),
	(1763, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.996827, 29.057771, _binary 0x0000000001010000003fa88b14ca0e3d40ca236e04987f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:27:45","ind":0,"enl":"40.9968267","boy":"029.057771","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":63.208760000000005,"mes":47312.2,"yon":75,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:27:45"}', '2025-08-25 04:27:45', '2025-08-25 04:27:47'),
	(1764, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.995927, 29.063846, _binary 0x000000000101000000fdfa213658103d404adbae867a7f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:28:16","ind":0,"enl":"40.9959267","boy":"029.063846","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":79.21004,"mes":47312.7,"yon":115,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:28:16"}', '2025-08-25 04:28:16', '2025-08-25 04:28:18'),
	(1765, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.995835, 29.064088, _binary 0x000000000101000000e910381268103d40289b7285777f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:28:17","ind":0,"enl":"40.9958350","boy":"029.064088","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":81.56208000000001,"mes":47312.8,"yon":115,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:28:17"}', '2025-08-25 04:28:17', '2025-08-25 04:28:19'),
	(1766, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.994187, 29.068345, _binary 0x0000000001010000005ad8d30e7f113d40204f8182417f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:28:33","ind":0,"enl":"40.9941867","boy":"029.068345","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.4508,"mes":47313.2,"yon":117,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:28:33"}', '2025-08-25 04:28:33', '2025-08-25 04:28:35'),
	(1767, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.993602, 29.069955, _binary 0x00000000010100000012312592e8113d4000602b572e7f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:28:40","ind":0,"enl":"40.9936017","boy":"029.069955","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":81.45096,"mes":47313.3,"yon":119,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:28:40"}', '2025-08-25 04:28:40', '2025-08-25 04:28:42'),
	(1768, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.993417, 29.070418, _binary 0x000000000101000000bb0cffe906123d406ee64647287f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:28:42","ind":0,"enl":"40.9934167","boy":"029.070418","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.02492000000001,"mes":47313.4,"yon":120,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:28:42"}', '2025-08-25 04:28:42', '2025-08-25 04:28:43'),
	(1769, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.991553, 29.075663, _binary 0x0000000001010000006a847ea65e133d40d5def137eb7e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:29:06","ind":0,"enl":"40.9915533","boy":"029.075663","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":81.63616,"mes":47313.9,"yon":114,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:29:06"}', '2025-08-25 04:29:06', '2025-08-25 04:29:07'),
	(1770, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.989460, 29.081375, _binary 0x00000000010100000046b6f3fdd4143d409f5912a0a67e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:29:27","ind":0,"enl":"40.9894600","boy":"029.081375","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":91.72956,"mes":47314.3,"yon":117,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:29:27"}', '2025-08-25 04:29:27', '2025-08-25 04:29:29'),
	(1771, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.987030, 29.087198, _binary 0x000000000101000000d046ae9b52163d40df15c1ff567e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:29:50","ind":0,"enl":"40.9870300","boy":"029.087198","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":84.8216,"mes":47314.9,"yon":122,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:29:50"}', '2025-08-25 04:29:50', '2025-08-25 04:30:08'),
	(1772, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.983817, 29.092261, _binary 0x0000000001010000003eb2b96a9e173d401be1a3b4ed7d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:30:14","ind":0,"enl":"40.9838167","boy":"029.092261","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":84.91420000000001,"mes":47315.5,"yon":136,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:30:14"}', '2025-08-25 04:30:14', '2025-08-25 04:30:16'),
	(1773, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.982910, 29.093336, _binary 0x0000000001010000001a8a3bdee4173d40a774b0fecf7d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:30:20","ind":0,"enl":"40.9829100","boy":"029.093336","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.78416,"mes":47315.6,"yon":139,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:30:20"}', '2025-08-25 04:30:20', '2025-08-25 04:30:26'),
	(1774, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.982750, 29.093515, _binary 0x00000000010100000079af5a99f0173d406f1283c0ca7d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:30:21","ind":0,"enl":"40.9827500","boy":"029.093515","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":85.04384,"mes":47315.6,"yon":140,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:30:21"}', '2025-08-25 04:30:21', '2025-08-25 04:30:27'),
	(1775, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.981127, 29.095103, _binary 0x00000000010100000062c092ab58183d40bfdd488f957d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:30:31","ind":0,"enl":"40.9811267","boy":"029.095103","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":74.09852,"mes":47315.8,"yon":147,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:30:31"}', '2025-08-25 04:30:31', '2025-08-25 04:30:32'),
	(1776, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.980647, 29.095495, _binary 0x00000000010100000078ee3d5c72183d4015b7c0d4857d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:30:34","ind":0,"enl":"40.9806467","boy":"029.095495","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":81.5806,"mes":47315.9,"yon":149,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:30:34"}', '2025-08-25 04:30:34', '2025-08-25 04:30:35'),
	(1777, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.980313, 29.095771, _binary 0x000000000101000000bce7c07284183d40bbaafde77a7d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:30:36","ind":0,"enl":"40.9803133","boy":"029.095771","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":77.33952,"mes":47315.9,"yon":148,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:30:36"}', '2025-08-25 04:30:36', '2025-08-25 04:30:38'),
	(1778, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.980110, 29.095928, _binary 0x0000000001010000004cc5c6bc8e183d40c53d963e747d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:30:37","ind":0,"enl":"40.9801100","boy":"029.095928","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.89536,"mes":47315.9,"yon":149,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:30:37"}', '2025-08-25 04:30:37', '2025-08-25 04:30:39'),
	(1779, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.975428, 29.098933, _binary 0x000000000101000000c37e4fac53193d40e30ba4d5da7c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:31:00","ind":0,"enl":"40.9754283","boy":"029.098933","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":96.54476000000001,"mes":47316.5,"yon":158,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:31:00"}', '2025-08-25 04:31:00', '2025-08-25 04:31:03'),
	(1780, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.970902, 29.101508, _binary 0x0000000001010000004948a46dfc193d40be90c481467c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:31:21","ind":0,"enl":"40.9709017","boy":"029.101508","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":89.63680000000001,"mes":47317.1,"yon":155,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:31:21"}', '2025-08-25 04:31:21', '2025-08-25 04:31:23'),
	(1781, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.966240, 29.104198, _binary 0x000000000101000000014f5ab8ac1a3d40240b98c0ad7b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:31:42","ind":0,"enl":"40.9662400","boy":"029.104198","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":95.11872000000001,"mes":47317.6,"yon":152,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:31:42"}', '2025-08-25 04:31:42', '2025-08-25 04:31:44'),
	(1782, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.963492, 29.106430, _binary 0x000000000101000000335019ff3e1b3d40d5bb2eb2537b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:31:56","ind":0,"enl":"40.9634917","boy":"029.106430","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":77.58028,"mes":47318,"yon":144,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:31:56"}', '2025-08-25 04:31:56', '2025-08-25 04:32:00'),
	(1783, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.959828, 29.110388, _binary 0x000000000101000000f0de5163421c3d403c235ba7db7a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:32:28","ind":0,"enl":"40.9598283","boy":"029.110388","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":58.893600000000006,"mes":47318.5,"yon":140,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:32:28"}', '2025-08-25 04:32:28', '2025-08-25 04:32:30'),
	(1784, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.956155, 29.114343, _binary 0x000000000101000000cb863595451d3d4015747b49637a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:33:04","ind":0,"enl":"40.9561550","boy":"029.114343","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":55.44888,"mes":47319.1,"yon":140,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:33:04"}', '2025-08-25 04:33:04', '2025-08-25 04:33:05'),
	(1785, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.952493, 29.118355, _binary 0x0000000001010000006e5166834c1e3d405e94ea4ceb794440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:33:56","ind":0,"enl":"40.9524933","boy":"029.118355","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":40.29952000000001,"mes":47319.5,"yon":138,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:33:56"}', '2025-08-25 04:33:56', '2025-08-25 04:33:57'),
	(1786, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.949037, 29.122558, _binary 0x000000000101000000f9dc09f65f1f3d40159ada087a794440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:34:35","ind":0,"enl":"40.9490367","boy":"029.122558","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":49.41136,"mes":47320.1,"yon":137,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:34:35"}', '2025-08-25 04:34:35', '2025-08-25 04:34:36'),
	(1787, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.945568, 29.126915, _binary 0x000000000101000000315f5e807d203d403151ce6108794440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:35:10","ind":0,"enl":"40.9455683","boy":"029.126915","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":65.39412,"mes":47320.6,"yon":135,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:35:10"}', '2025-08-25 04:35:10', '2025-08-25 04:35:11'),
	(1788, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.941938, 29.131350, _binary 0x00000000010100000061545227a0213d40c7ac286f91784440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:35:36","ind":0,"enl":"40.9419383","boy":"029.131350","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":76.09868000000002,"mes":47321.1,"yon":136,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:35:36"}', '2025-08-25 04:35:36', '2025-08-25 04:35:38'),
	(1789, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.938507, 29.135535, _binary 0x0000000001010000009f76f86bb2223d40d7c9cffc20784440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:36:11","ind":0,"enl":"40.9385067","boy":"029.135535","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":41.929280000000006,"mes":47321.6,"yon":137,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:36:11"}', '2025-08-25 04:36:11', '2025-08-25 04:36:13'),
	(1790, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.935292, 29.139493, _binary 0x0000000001010000005c0531d0b5233d4031dc6fa3b7774440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:37:13","ind":0,"enl":"40.9352917","boy":"029.139493","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":57.967600000000004,"mes":47322.1,"yon":136,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:37:13"}', '2025-08-25 04:37:13', '2025-08-25 04:37:14'),
	(1791, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.931953, 29.143615, _binary 0x0000000001010000000d37e0f3c3243d401c73e83e4a774440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:37:57","ind":0,"enl":"40.9319533","boy":"029.143615","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":45.29992000000001,"mes":47322.7,"yon":139,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:37:57"}', '2025-08-25 04:37:57', '2025-08-25 04:38:01'),
	(1792, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.928608, 29.147773, _binary 0x000000000101000000583b8a73d4253d40a7a503a3dc764440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:38:43","ind":0,"enl":"40.9286083","boy":"029.147773","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":25.35388,"mes":47323.1,"yon":135,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:38:43"}', '2025-08-25 04:38:43', '2025-08-25 04:38:45'),
	(1793, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.925228, 29.152065, _binary 0x000000000101000000c2dd59bbed263d40b6ea84e16d764440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:39:36","ind":0,"enl":"40.9252283","boy":"029.152065","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":35.96584000000001,"mes":47323.7,"yon":129,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:39:36"}', '2025-08-25 04:39:36', '2025-08-25 04:39:37'),
	(1794, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.923172, 29.157466, _binary 0x000000000101000000603b18b14f283d40de0b827d2a764440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:40:23","ind":0,"enl":"40.9231717","boy":"029.157466","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":55.24516,"mes":47324.2,"yon":110,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:40:23"}', '2025-08-25 04:40:23', '2025-08-25 04:40:24'),
	(1795, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.921333, 29.163551, _binary 0x000000000101000000643a747ade293d409e1be43fee754440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:40:54","ind":0,"enl":"40.9213333","boy":"029.163551","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":67.63504,"mes":47324.7,"yon":111,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:40:54"}', '2025-08-25 04:40:54', '2025-08-25 04:40:55'),
	(1796, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.919787, 29.168535, _binary 0x0000000001010000003a3b191c252b3d40dce51192bb754440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:41:17","ind":0,"enl":"40.9197867","boy":"029.168535","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":82.1362,"mes":47325.2,"yon":112,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:41:17"}', '2025-08-25 04:41:17', '2025-08-25 04:41:19'),
	(1797, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.917942, 29.174568, _binary 0x0000000001010000009aed0a7db02c3d403c91161d7f754440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:41:40","ind":0,"enl":"40.9179417","boy":"029.174568","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":88.85896,"mes":47325.7,"yon":112,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:41:40"}', '2025-08-25 04:41:40', '2025-08-25 04:41:48'),
	(1798, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.916028, 29.180638, _binary 0x000000000101000000336abe4a3e2e3d40f15a536a40754440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:42:03","ind":0,"enl":"40.9160283","boy":"029.180638","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":84.32156,"mes":47326.2,"yon":112,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:42:03"}', '2025-08-25 04:42:03', '2025-08-25 04:42:04'),
	(1799, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.914167, 29.186618, _binary 0x0000000001010000004dd87e32c62f3d40cfcb176a03754440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:42:25","ind":0,"enl":"40.9141667","boy":"029.186618","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":85.63648,"mes":47326.8,"yon":112,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:42:25"}', '2025-08-25 04:42:25', '2025-08-25 04:42:27'),
	(1800, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.912248, 29.192840, _binary 0x000000000101000000535c55f65d313d40722a638dc4744440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:42:49","ind":0,"enl":"40.9122483","boy":"029.192840","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":86.54396,"mes":47327.3,"yon":112,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:42:49"}', '2025-08-25 04:42:49', '2025-08-25 04:42:57'),
	(1801, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.912032, 29.193585, _binary 0x00000000010100000004ff5bc98e313d4028356a74bd744440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:42:52","ind":0,"enl":"40.9120317","boy":"029.193585","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.93232,"mes":47327.4,"yon":112,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:42:52"}', '2025-08-25 04:42:52', '2025-08-25 04:42:57'),
	(1802, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.910135, 29.199511, _binary 0x0000000001010000003831242713333d40f4f8bd4d7f744440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:43:22","ind":0,"enl":"40.9101350","boy":"029.199511","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":67.135,"mes":47327.9,"yon":112,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:43:22"}', '2025-08-25 04:43:22', '2025-08-25 04:43:23'),
	(1803, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.908355, 29.204985, _binary 0x000000000101000000aa2b9fe579343d403c1405fa44744440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:44:15","ind":0,"enl":"40.9083550","boy":"029.204985","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":41.37368,"mes":47328.4,"yon":111,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:44:15"}', '2025-08-25 04:44:15', '2025-08-25 04:44:17'),
	(1804, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.905668, 29.209330, _binary 0x0000000001010000005a12a0a696353d4010c358f0ec734440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:44:52","ind":0,"enl":"40.9056683","boy":"029.209330","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":45.42956,"mes":47328.9,"yon":160,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:44:52"}', '2025-08-25 04:44:52', '2025-08-25 04:45:00'),
	(1805, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.901635, 29.207398, _binary 0x0000000001010000007d410b0918353d40e8f692c668734440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:45:26","ind":0,"enl":"40.9016350","boy":"029.207398","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":81.37688,"mes":47329.5,"yon":208,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:45:26"}', '2025-08-25 04:45:26', '2025-08-25 04:45:28'),
	(1806, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.901282, 29.207120, _binary 0x000000000101000000f758fad005353d40dcfde0325d734440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:45:28","ind":0,"enl":"40.9012817","boy":"029.207120","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":78.58036,"mes":47329.5,"yon":211,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:45:28"}', '2025-08-25 04:45:28', '2025-08-25 04:45:30'),
	(1807, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.897490, 29.206466, _binary 0x00000000010100000066bcadf4da343d40573ecbf3e0724440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:46:30","ind":0,"enl":"40.8974900","boy":"029.206466","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":35.2806,"mes":47329.9,"yon":178,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:46:30"}', '2025-08-25 04:46:30', '2025-08-25 04:46:32'),
	(1808, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.892918, 29.206896, _binary 0x00000000010100000058ace122f7343d40fd3f98254b724440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:47:14","ind":0,"enl":"40.8929183","boy":"029.206896","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":48.44832,"mes":47330.4,"yon":175,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:47:14"}', '2025-08-25 04:47:14', '2025-08-25 04:47:16'),
	(1809, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.890478, 29.207138, _binary 0x00000000010100000044c2f7fe06353d401a266431fb714440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:48:16","ind":0,"enl":"40.8904783","boy":"029.207138","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47330.8,"yon":184,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 07:48:16"}', '2025-08-25 04:48:16', '2025-08-25 04:48:17'),
	(1810, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.890372, 29.207151, _binary 0x0000000001010000006d5512d907353d4058642ab3f7714440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:49:18","ind":0,"enl":"40.8903717","boy":"029.207151","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":3.1484,"mes":47330.8,"yon":189,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:49:18"}', '2025-08-25 04:49:18', '2025-08-25 04:49:19'),
	(1811, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.885818, 29.207958, _binary 0x0000000001010000000bf148bc3c353d4062597a7e62714440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:50:08","ind":0,"enl":"40.8858183","boy":"029.207958","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":48.11496,"mes":47331.2,"yon":158,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:50:08"}', '2025-08-25 04:50:08', '2025-08-25 04:50:10'),
	(1812, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.881978, 29.209823, _binary 0x000000000101000000d8f2caf5b6353d400e2439aae4704440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:50:41","ind":0,"enl":"40.8819783","boy":"029.209823","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":49.207640000000005,"mes":47331.8,"yon":94,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:50:41"}', '2025-08-25 04:50:41', '2025-08-25 04:50:42'),
	(1813, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.879253, 29.214963, _binary 0x0000000001010000009dd9aed007373d403633445f8b704440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:51:11","ind":0,"enl":"40.8792533","boy":"029.214963","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":56.63416,"mes":47332.3,"yon":135,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:51:11"}', '2025-08-25 04:51:11', '2025-08-25 04:51:12'),
	(1814, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.877162, 29.220245, _binary 0x000000000101000000861bf0f961383d40e266a7d546704440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:51:43","ind":0,"enl":"40.8771617","boy":"029.220245","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":68.20916,"mes":47332.8,"yon":95,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:51:43"}', '2025-08-25 04:51:43', '2025-08-25 04:51:46'),
	(1815, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.873963, 29.224771, _binary 0x000000000101000000d7169e978a393d40beb38707de6f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:52:11","ind":0,"enl":"40.8739633","boy":"029.224771","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":67.6906,"mes":47333.4,"yon":147,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:52:11"}', '2025-08-25 04:52:11', '2025-08-25 04:52:12'),
	(1816, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.870973, 29.229216, _binary 0x0000000001010000004eb857e6ad3a3d403898970d7c6f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:52:40","ind":0,"enl":"40.8709733","boy":"029.229216","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":50.20772,"mes":47333.9,"yon":91,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:52:40"}', '2025-08-25 04:52:40', '2025-08-25 04:52:43'),
	(1817, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.872135, 29.233261, _binary 0x000000000101000000a86e2efeb63b3d403659a31ea26f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:53:42","ind":0,"enl":"40.8721350","boy":"029.233261","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":34.576840000000004,"mes":47334.2,"yon":46,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:53:42"}', '2025-08-25 04:53:42', '2025-08-25 04:53:43'),
	(1818, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.874758, 29.234551, _binary 0x0000000001010000007d3eca880b3c3d40c9337914f86f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:54:44","ind":0,"enl":"40.8747583","boy":"029.234551","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":14.241880000000002,"mes":47334.6,"yon":47,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:54:44"}', '2025-08-25 04:54:44', '2025-08-25 04:54:45'),
	(1819, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.874780, 29.234583, _binary 0x0000000001010000009432a9a10d3c3d40f29881caf86f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:55:45","ind":0,"enl":"40.8747800","boy":"029.234583","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47334.6,"yon":50,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 07:55:45"}', '2025-08-25 04:55:45', '2025-08-25 04:55:47'),
	(1820, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.874780, 29.234583, _binary 0x0000000001010000009432a9a10d3c3d40f29881caf86f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:56:22","ind":0,"enl":"40.8747800","boy":"029.234583","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47334.6,"yon":50,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 07:56:22"}', '2025-08-25 04:56:22', '2025-08-25 04:56:24'),
	(1821, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.874817, 29.234636, _binary 0x000000000101000000d976da1a113c3d40503f5efef96f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:57:33","ind":0,"enl":"40.8748167","boy":"029.234636","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47334.6,"yon":50,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 07:57:33"}', '2025-08-25 04:57:33', '2025-08-25 04:57:35'),
	(1822, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.874805, 29.234633, _binary 0x000000000101000000f78f85e8103c3d404bb0389cf96f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:58:35","ind":0,"enl":"40.8748050","boy":"029.234633","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47334.6,"yon":50,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 07:58:35"}', '2025-08-25 04:58:35', '2025-08-25 04:58:37'),
	(1823, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.874833, 29.235898, _binary 0x0000000001010000001a31b3cf633c3d40d3799e89fa6f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"07:59:37","ind":0,"enl":"40.8748333","boy":"029.235898","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":12.704720000000002,"mes":47334.7,"yon":100,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 07:59:37"}', '2025-08-25 04:59:37', '2025-08-25 04:59:38'),
	(1824, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.874295, 29.236383, _binary 0x0000000001010000009354a698833c3d40350708e6e86f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:00:39","ind":0,"enl":"40.8742950","boy":"029.236383","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47334.8,"yon":169,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 08:00:39"}', '2025-08-25 05:00:39', '2025-08-25 05:00:40'),
	(1825, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.874168, 29.236228, _binary 0x00000000010100000045662e70793c3d4097d931bfe46f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:01:41","ind":0,"enl":"40.8741683","boy":"029.236228","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47334.8,"yon":191,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 08:01:41"}', '2025-08-25 05:01:41', '2025-08-25 05:01:42'),
	(1826, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.874168, 29.236228, _binary 0x00000000010100000045662e70793c3d4097d931bfe46f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:01:43","ind":0,"enl":"40.8741683","boy":"029.236228","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47334.8,"yon":191,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 08:01:43"}', '2025-08-25 05:01:43', '2025-08-25 05:01:45'),
	(1827, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.873018, 29.237733, _binary 0x000000000101000000122ee411dc3c3d409ea74b10bf6f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:03:47","ind":0,"enl":"40.8730183","boy":"029.237733","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47334.8,"yon":119,"A":"61","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 08:03:47"}', '2025-08-25 05:03:47', '2025-08-25 05:03:48'),
	(1828, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.830238, 29.246086, _binary 0x000000000101000000e200fa7dff3e3d407d31a53f456a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:13:24","ind":0,"enl":"40.8302383","boy":"029.246086","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":37.29928,"mes":47334.8,"yon":177,"A":"","Sensor":"","drx":1,"ignition":1,"datetime":"2025-08-25 08:13:24"}', '2025-08-25 05:13:24', '2025-08-25 05:13:26'),
	(1829, '77.67.141.109:26270', 'aebcc2b375a24f3f0', 40.811768, 29.245898, _binary 0x000000000101000000dd26dc2bf33e3d40fa360e06e8674440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:16:56","ind":0,"enl":"40.8117683","boy":"029.245898","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47334.8,"yon":180,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 08:16:56"}', '2025-08-25 05:16:56', '2025-08-25 05:17:58'),
	(1830, '31.143.217.244:49295', 'aebcc2b375a24f3f0', 40.807118, 29.246011, _binary 0x000000000101000000cd74af93fa3e3d40664007a74f674440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:18:02","ind":0,"enl":"40.8071183","boy":"029.246011","drm":[1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0],"hiz":44.96656,"mes":47334.8,"yon":180,"A":"","Sensor":"","drx":1,"ignition":1,"datetime":"2025-08-25 08:18:02"}', '2025-08-25 05:18:02', '2025-08-25 05:18:43'),
	(1831, '31.143.217.244:49295', 'aebcc2b375a24f3f0', 40.804040, 29.245960, _binary 0x000000000101000000c91f0c3cf73e3d40825660c8ea664440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:18:40","ind":0,"enl":"40.8040400","boy":"029.245960","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47334.8,"yon":180,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 08:18:40"}', '2025-08-25 05:18:40', '2025-08-25 05:18:42'),
	(1832, '31.141.92.251:45759', 'aebcc2b375a24f3f0', 40.734432, 29.261485, _binary 0x000000000101000000026553aef0423d40a652a2db015e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:32:51","ind":0,"enl":"40.7344317","boy":"029.261485","drm":[1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0],"hiz":38.37344,"mes":47334.8,"yon":165,"A":"","Sensor":"","drx":1,"ignition":1,"datetime":"2025-08-25 08:32:51"}', '2025-08-25 05:32:51', '2025-08-25 05:36:33'),
	(1833, '31.141.92.251:45759', 'aebcc2b375a24f3f0', 40.715918, 29.266935, _binary 0x000000000101000000632827da55443d40d08dfa35a35b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:36:30","ind":0,"enl":"40.7159183","boy":"029.266935","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47334.8,"yon":167,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 08:36:30"}', '2025-08-25 05:36:30', '2025-08-25 05:36:32'),
	(1834, '31.141.92.251:45759', 'aebcc2b375a24f3f0', 40.700433, 29.271205, _binary 0x000000000101000000fd82ddb06d453d40c24362cca7594440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:39:48","ind":0,"enl":"40.7004333","boy":"029.271205","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47334.8,"yon":171,"A":"4","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 08:39:48"}', '2025-08-25 05:39:48', '2025-08-25 05:39:50'),
	(1835, '31.141.92.251:45759', 'aebcc2b375a24f3f0', 40.691143, 29.273001, _binary 0x0000000001010000007ac6be64e3453d40bd2c376277584440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:41:45","ind":0,"enl":"40.6911433","boy":"029.273001","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47334.8,"yon":166,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 08:41:45"}', '2025-08-25 05:41:45', '2025-08-25 05:43:23'),
	(1836, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.681968, 29.275476, _binary 0x00000000010100000039d55a9885463d4051b4bcbc4a574440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:43:30","ind":0,"enl":"40.6819683","boy":"029.275476","drm":[1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47334.8,"yon":171,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 08:43:30"}', '2025-08-25 05:43:30', '2025-08-25 05:44:07'),
	(1837, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.678848, 29.276170, _binary 0x000000000101000000e622be13b3463d40fcb84780e4564440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:44:04","ind":0,"enl":"40.6788483","boy":"029.276170","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47334.8,"yon":171,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 08:44:04"}', '2025-08-25 05:44:04', '2025-08-25 05:44:06'),
	(1838, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.671257, 29.277435, _binary 0x00000000010100000009c4ebfa05473d4046dc52bdeb554440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:45:33","ind":0,"enl":"40.6712567","boy":"029.277435","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47334.8,"yon":171,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 08:45:33"}', '2025-08-25 05:45:33', '2025-08-25 05:45:35'),
	(1839, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.666263, 29.278430, _binary 0x000000000101000000ac39403047473d403403a61d48554440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:46:34","ind":0,"enl":"40.6662633","boy":"029.278430","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":26.42804,"mes":47335.4,"yon":177,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 08:46:34"}', '2025-08-25 05:46:34', '2025-08-25 05:46:36'),
	(1840, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.663360, 29.279070, _binary 0x000000000101000000734bab2171473d40bebc00fbe8544440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:47:36","ind":0,"enl":"40.6633600","boy":"029.279070","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":12.29728,"mes":47335.6,"yon":178,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 08:47:36"}', '2025-08-25 05:47:36', '2025-08-25 05:47:37'),
	(1841, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.661905, 29.279091, _binary 0x000000000101000000a29bfd8172473d408907944db9544440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:48:37","ind":0,"enl":"40.6619050","boy":"029.279091","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":6.40792,"mes":47335.8,"yon":196,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 08:48:37"}', '2025-08-25 05:48:37', '2025-08-25 05:48:39'),
	(1842, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.661192, 29.278918, _binary 0x0000000001010000000744882b67473d407ef1fbeda1544440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:49:39","ind":0,"enl":"40.6611917","boy":"029.278918","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":1.9816400000000003,"mes":47336,"yon":201,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 08:49:39"}', '2025-08-25 05:49:39', '2025-08-25 05:49:40'),
	(1843, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.661192, 29.278918, _binary 0x0000000001010000000744882b67473d407ef1fbeda1544440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:50:41","ind":0,"enl":"40.6611917","boy":"029.278918","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47336,"yon":47,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 08:50:41"}', '2025-08-25 05:50:41', '2025-08-25 05:50:42'),
	(1844, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.661098, 29.278925, _binary 0x0000000001010000006c09f9a067473d4079f87cde9e544440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:51:42","ind":0,"enl":"40.6610983","boy":"029.278925","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47336,"yon":164,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 08:51:42"}', '2025-08-25 05:51:42', '2025-08-25 05:51:44'),
	(1845, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.660842, 29.278953, _binary 0x000000000101000000001fbc7669473d40a1aaf87596544440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:52:44","ind":0,"enl":"40.6608417","boy":"029.278953","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":1.8705200000000002,"mes":47336,"yon":168,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 08:52:44"}', '2025-08-25 05:52:44', '2025-08-25 05:52:46'),
	(1846, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.660300, 29.278803, _binary 0x000000000101000000d50627a25f473d403fc6dcb584544440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:53:46","ind":0,"enl":"40.6603000","boy":"029.278803","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":9.13036,"mes":47336.1,"yon":212,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 08:53:46"}', '2025-08-25 05:53:46', '2025-08-25 05:53:47'),
	(1847, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.659470, 29.278070, _binary 0x000000000101000000acff73982f473d40b858518369544440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:54:45","ind":4,"enl":"40.6594700","boy":"029.278070","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47336.2,"yon":182,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 08:54:45"}', '2025-08-25 05:54:45', '2025-08-25 05:54:50'),
	(1848, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.657058, 29.282913, _binary 0x000000000101000000fe9c82fc6c483d405e08837c1a544440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:55:49","ind":0,"enl":"40.6570583","boy":"029.282913","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":39.94764,"mes":47336.7,"yon":142,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 08:55:49"}', '2025-08-25 05:55:49', '2025-08-25 05:55:50'),
	(1849, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.655980, 29.283553, _binary 0x000000000101000000c5aeeded96483d40406a1327f7534440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:56:51","ind":0,"enl":"40.6559800","boy":"029.283553","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":14.093720000000001,"mes":47336.8,"yon":170,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 08:56:51"}', '2025-08-25 05:56:51', '2025-08-25 05:56:52'),
	(1850, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.655757, 29.283640, _binary 0x00000000010100000062d68ba19c483d400251e6d5ef534440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:57:52","ind":0,"enl":"40.6557567","boy":"029.283640","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47336.8,"yon":324,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 08:57:52"}', '2025-08-25 05:57:52', '2025-08-25 05:57:54'),
	(1851, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.651377, 29.285858, _binary 0x000000000101000000cb4c69fd2d493d402ef0cb4f60534440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:58:43","ind":0,"enl":"40.6513767","boy":"029.285858","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":49.96696,"mes":47337.4,"yon":180,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 08:58:43"}', '2025-08-25 05:58:43', '2025-08-25 05:58:45'),
	(1852, '176.238.4.21:7995', 'aebcc2b375a24f3f0', 0.000000, 0.000000, _binary 0x00000000010100000000000000000000000000000000000000, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:59:42","ind":8,"enl":"00.0000000","boy":"000.000000","drm":[1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":0,"A":"77","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 08:59:42"}', '2025-08-25 05:59:42', '2025-08-25 15:53:52'),
	(1853, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.642068, 29.280316, _binary 0x000000000101000000a88b14cac2473d402f26474b2f524440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"08:59:50","ind":0,"enl":"40.6420683","boy":"029.280316","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":68.59808,"mes":47338.4,"yon":206,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 08:59:50"}', '2025-08-25 05:59:50', '2025-08-25 05:59:51'),
	(1854, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.637787, 29.277520, _binary 0x00000000010100000065fcfb8c0b473d4071299dfea2514440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:00:18","ind":0,"enl":"40.6377867","boy":"029.277520","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":73.87628000000001,"mes":47338.9,"yon":206,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:00:18"}', '2025-08-25 06:00:18', '2025-08-25 06:00:20'),
	(1855, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.635143, 29.275811, _binary 0x00000000010100000087e0b88c9b463d4003e32a604c514440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:00:33","ind":0,"enl":"40.6351433","boy":"029.275811","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":86.80324,"mes":47339.2,"yon":207,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:00:33"}', '2025-08-25 06:00:33', '2025-08-25 06:00:35'),
	(1856, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.631813, 29.273598, _binary 0x0000000001010000004240be840a463d40c3561a42df504440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:00:50","ind":0,"enl":"40.6318133","boy":"029.273598","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":77.04320000000001,"mes":47339.7,"yon":207,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:00:50"}', '2025-08-25 06:00:50', '2025-08-25 06:00:51'),
	(1857, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.627070, 29.271756, _binary 0x000000000101000000e57d1ccd91453d40c0266bd443504440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:01:17","ind":0,"enl":"40.6270700","boy":"029.271756","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":73.78368,"mes":47340.1,"yon":193,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:01:17"}', '2025-08-25 06:01:17', '2025-08-25 06:01:19'),
	(1858, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.622333, 29.270723, _binary 0x00000000010100000067463f1a4e453d401b5b199ea84f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:01:42","ind":0,"enl":"40.6223333","boy":"029.270723","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.22864,"mes":47340.7,"yon":175,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:01:42"}', '2025-08-25 06:01:42', '2025-08-25 06:01:44'),
	(1859, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.621937, 29.270775, _binary 0x0000000001010000000c93a98251453d4051572d9f9b4f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:01:44","ind":0,"enl":"40.6219367","boy":"029.270775","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.00640000000001,"mes":47340.7,"yon":172,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:01:44"}', '2025-08-25 06:01:44', '2025-08-25 06:01:45'),
	(1860, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.621937, 29.270775, _binary 0x0000000001010000000c93a98251453d4051572d9f9b4f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:01:44","ind":0,"enl":"40.6219367","boy":"029.270775","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":80.00640000000001,"mes":47340.7,"yon":172,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:01:44"}', '2025-08-25 06:01:44', '2025-08-25 06:01:46'),
	(1861, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.621742, 29.270806, _binary 0x000000000101000000828fc18a53453d409c07663b954f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:01:45","ind":0,"enl":"40.6217417","boy":"029.270806","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.17308,"mes":47340.7,"yon":171,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:01:45"}', '2025-08-25 06:01:45', '2025-08-25 06:01:47'),
	(1862, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.621547, 29.270843, _binary 0x000000000101000000bc5983f755453d40e7b79ed78e4f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:01:46","ind":0,"enl":"40.6215467","boy":"029.270843","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":78.09884000000001,"mes":47340.7,"yon":171,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:01:46"}', '2025-08-25 06:01:46', '2025-08-25 06:01:47'),
	(1863, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.617355, 29.272121, _binary 0x000000000101000000088ecbb8a9453d40d482177d054f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:02:09","ind":0,"enl":"40.6173550","boy":"029.272121","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.63608,"mes":47341.3,"yon":165,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:02:09"}', '2025-08-25 06:02:09', '2025-08-25 06:02:11'),
	(1864, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.612350, 29.272638, _binary 0x00000000010100000098a59d9acb453d4051da1b7c614e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:02:32","ind":0,"enl":"40.6123500","boy":"029.272638","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":91.674,"mes":47341.8,"yon":182,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:02:32"}', '2025-08-25 06:02:32', '2025-08-25 06:02:34'),
	(1865, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.607535, 29.271451, _binary 0x0000000001010000006c770fd07d453d407216f6b4c34d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:02:52","ind":0,"enl":"40.6075350","boy":"029.271451","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":100.50804000000001,"mes":47342.3,"yon":192,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:02:52"}', '2025-08-25 06:02:52', '2025-08-25 06:02:54'),
	(1866, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.602573, 29.270703, _binary 0x000000000101000000d9edb3ca4c453d40ae78341f214d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:03:14","ind":0,"enl":"40.6025733","boy":"029.270703","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":95.84100000000001,"mes":47342.9,"yon":164,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:03:14"}', '2025-08-25 06:03:14', '2025-08-25 06:03:15'),
	(1867, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.599947, 29.271933, _binary 0x00000000010100000003b4ad669d453d40ebebaf0dcb4c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:03:26","ind":0,"enl":"40.5999467","boy":"029.271933","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":78.3396,"mes":47343.1,"yon":162,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:03:26"}', '2025-08-25 06:03:26', '2025-08-25 06:03:28'),
	(1868, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.597385, 29.276953, _binary 0x00000000010100000072874d64e6463d407c0f971c774c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:03:54","ind":0,"enl":"40.5973850","boy":"029.276953","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":67.06092000000001,"mes":47343.7,"yon":136,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:03:54"}', '2025-08-25 06:03:54', '2025-08-25 06:03:56'),
	(1869, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.596262, 29.278198, _binary 0x00000000010100000007d0effb37473d40beadaa4d524c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:04:02","ind":0,"enl":"40.5962617","boy":"029.278198","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.59904000000002,"mes":47343.8,"yon":139,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:04:02"}', '2025-08-25 06:04:02', '2025-08-25 06:04:04'),
	(1870, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.592408, 29.282673, _binary 0x0000000001010000005376fa415d483d4082300109d44b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:04:24","ind":0,"enl":"40.5924083","boy":"029.282673","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":98.67456000000001,"mes":47344.4,"yon":136,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:04:24"}', '2025-08-25 06:04:24', '2025-08-25 06:04:26'),
	(1871, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.590358, 29.285161, _binary 0x0000000001010000003b18b14f00493d4009b65bdc904b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:04:36","ind":0,"enl":"40.5903583","boy":"029.285161","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":77.19136,"mes":47344.8,"yon":136,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:04:36"}', '2025-08-25 06:04:36', '2025-08-25 06:04:39'),
	(1872, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.588310, 29.290601, _binary 0x000000000101000000552fbfd3644a3d4073f4f8bd4d4b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:05:03","ind":0,"enl":"40.5883100","boy":"029.290601","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":72.02428,"mes":47345.2,"yon":164,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:05:03"}', '2025-08-25 06:05:03', '2025-08-25 06:05:05'),
	(1873, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.586062, 29.291111, _binary 0x00000000010100000080812040864a3d401678dd11044b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:05:15","ind":0,"enl":"40.5860617","boy":"029.291111","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":84.39564,"mes":47345.6,"yon":147,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:05:15"}', '2025-08-25 06:05:15', '2025-08-25 06:05:17'),
	(1874, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.581747, 29.292581, _binary 0x000000000101000000546ea296e64a3d40288705ad764a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:05:36","ind":0,"enl":"40.5817467","boy":"029.292581","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":77.76548000000001,"mes":47346,"yon":192,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:05:36"}', '2025-08-25 06:05:36', '2025-08-25 06:05:37'),
	(1875, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.580020, 29.293135, _binary 0x0000000001010000001e5036e50a4b3d40518369183e4a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:05:46","ind":0,"enl":"40.5800200","boy":"029.293135","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":82.98812000000001,"mes":47346.3,"yon":141,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:05:46"}', '2025-08-25 06:05:46', '2025-08-25 06:06:20'),
	(1876, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.575480, 29.295100, _binary 0x000000000101000000b30c71ac8b4b3d4044c02154a9494440, '0', '{"device_model":"Ortem","p":"0","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:06:09","ind":0,"enl":"40.5754800","boy":"029.295100","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":85.91428,"mes":47346.7,"yon":189,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:06:09"}', '2025-08-25 06:06:09', '2025-08-25 06:06:20'),
	(1877, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.573445, 29.294618, _binary 0x0000000001010000001cd0d2156c4b3d40018750a566494440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:06:19","ind":0,"enl":"40.5734450","boy":"029.294618","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":83.74744,"mes":47347,"yon":191,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:06:19"}', '2025-08-25 06:06:19', '2025-08-25 06:06:21'),
	(1878, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.568310, 29.295398, _binary 0x000000000101000000c64d0d349f4b3d40b0fecf61be484440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:06:40","ind":0,"enl":"40.5683100","boy":"029.295398","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":108.69388000000001,"mes":47347.5,"yon":152,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:06:40"}', '2025-08-25 06:06:40', '2025-08-25 06:06:41'),
	(1879, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.565080, 29.300111, _binary 0x0000000001010000007c2b1213d44c3d40d5cf9b8a54484440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:07:00","ind":0,"enl":"40.5650800","boy":"029.300111","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":95.32244,"mes":47348.1,"yon":115,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:07:00"}', '2025-08-25 06:07:00', '2025-08-25 06:07:02'),
	(1880, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.564613, 29.301445, _binary 0x000000000101000000f08ae07f2b4d3d407d31a53f45484440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:07:05","ind":0,"enl":"40.5646133","boy":"029.301445","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.98788,"mes":47348.2,"yon":115,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:07:05"}', '2025-08-25 06:07:05', '2025-08-25 06:07:07'),
	(1881, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.562145, 29.303076, _binary 0x000000000101000000d7338463964d3d40124e0b5ef4474440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:07:22","ind":0,"enl":"40.5621450","boy":"029.303076","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":82.74736,"mes":47348.6,"yon":194,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:07:22"}', '2025-08-25 06:07:22', '2025-08-25 06:07:24'),
	(1882, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.557478, 29.303930, _binary 0x000000000101000000f645425bce4d3d40665ded725b474440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:07:45","ind":0,"enl":"40.5574783","boy":"029.303930","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":82.43252,"mes":47349,"yon":149,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:07:45"}', '2025-08-25 06:07:45', '2025-08-25 06:07:46'),
	(1883, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.557302, 29.304065, _binary 0x000000000101000000b6db2e34d74d3d40aac07fa955474440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:07:46","ind":0,"enl":"40.5573017","boy":"029.304065","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.89528,"mes":47349.2,"yon":150,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:07:46"}', '2025-08-25 06:07:46', '2025-08-25 06:07:47'),
	(1884, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.553987, 29.304550, _binary 0x0000000001010000002eff21fdf64d3d40a1754309e9464440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:08:05","ind":0,"enl":"40.5539867","boy":"029.304550","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.80276,"mes":47349.5,"yon":151,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:08:05"}', '2025-08-25 06:08:05', '2025-08-25 06:08:07'),
	(1885, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.549552, 29.306278, _binary 0x000000000101000000fa7b293c684e3d40097bc9b557464440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:08:28","ind":0,"enl":"40.5495517","boy":"029.306278","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":88.80340000000001,"mes":47350.1,"yon":205,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:08:28"}', '2025-08-25 06:08:28', '2025-08-25 06:08:29'),
	(1886, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.548020, 29.305400, _binary 0x000000000101000000ca32c4b12e4e3d40e7c6f48425464440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:08:36","ind":0,"enl":"40.5480200","boy":"029.305400","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.65452,"mes":47350.2,"yon":199,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:08:36"}', '2025-08-25 06:08:36', '2025-08-25 06:08:37'),
	(1887, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.547827, 29.305303, _binary 0x000000000101000000e55e6056284e3d401430702f1f464440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:08:37","ind":0,"enl":"40.5478267","boy":"029.305303","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":83.65484000000001,"mes":47350.2,"yon":198,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:08:37"}', '2025-08-25 06:08:37', '2025-08-25 06:08:38'),
	(1888, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.546823, 29.304890, _binary 0x000000000101000000a0e062450d4e3d406c184f4efe454440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:08:42","ind":0,"enl":"40.5468233","boy":"029.304890","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.83972,"mes":47350.3,"yon":197,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:08:42"}', '2025-08-25 06:08:42', '2025-08-25 06:08:44'),
	(1889, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.544742, 29.304295, _binary 0x0000000001010000001956f146e64d3d403c229518ba454440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:08:54","ind":0,"enl":"40.5447417","boy":"029.304295","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":81.98804000000001,"mes":47350.5,"yon":193,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:08:54"}', '2025-08-25 06:08:54', '2025-08-25 06:08:55'),
	(1890, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.540172, 29.304201, _binary 0x0000000001010000001669e21de04d3d40c4dca45824454440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:09:16","ind":0,"enl":"40.5401717","boy":"029.304201","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":86.32172,"mes":47351.1,"yon":167,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:09:16"}', '2025-08-25 06:09:16', '2025-08-25 06:09:18'),
	(1891, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.536097, 29.306355, _binary 0x00000000010100000051f701486d4e3d402cff10d19e444440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:09:37","ind":0,"enl":"40.5360967","boy":"029.306355","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.13596,"mes":47351.6,"yon":154,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:09:37"}', '2025-08-25 06:09:37', '2025-08-25 06:09:38'),
	(1892, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.531847, 29.309030, _binary 0x0000000001010000009e7b0f971c4f3d40267e7b8d13444440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:10:01","ind":0,"enl":"40.5318467","boy":"029.309030","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":78.45072,"mes":47352.2,"yon":155,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:10:01"}', '2025-08-25 06:10:01', '2025-08-25 06:10:12'),
	(1893, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.527502, 29.312221, _binary 0x000000000101000000da1f28b7ed4f3d40ce0afb2c85434440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:10:27","ind":0,"enl":"40.5275017","boy":"029.312221","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":66.22752,"mes":47352.6,"yon":146,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:10:27"}', '2025-08-25 06:10:27', '2025-08-25 06:10:29'),
	(1894, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.523025, 29.314756, _binary 0x000000000101000000433866d993503d40c5feb27bf2424440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:10:59","ind":0,"enl":"40.5230250","boy":"029.314756","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":61.80124,"mes":47353.2,"yon":162,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:10:59"}', '2025-08-25 06:10:59', '2025-08-25 06:11:01'),
	(1895, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.518268, 29.316045, _binary 0x00000000010100000077103b53e8503d40da869b9d56424440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:11:27","ind":0,"enl":"40.5182683","boy":"029.316045","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":71.302,"mes":47353.7,"yon":174,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:11:27"}', '2025-08-25 06:11:27', '2025-08-25 06:11:28'),
	(1896, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.513378, 29.316093, _binary 0x000000000101000000997e8978eb503d40f07c5061b6414440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:11:56","ind":0,"enl":"40.5133783","boy":"029.316093","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":67.19056,"mes":47354.3,"yon":180,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:11:56"}', '2025-08-25 06:11:56', '2025-08-25 06:11:57'),
	(1897, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.508643, 29.316088, _binary 0x00000000010100000076a8a624eb503d402e6a41391b414440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:12:23","ind":0,"enl":"40.5086433","boy":"029.316088","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":73.87628000000001,"mes":47354.7,"yon":179,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:12:23"}', '2025-08-25 06:12:23', '2025-08-25 06:12:25'),
	(1898, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.503857, 29.315920, _binary 0x000000000101000000fe261422e0503d406c2f58607e404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:12:53","ind":0,"enl":"40.5038567","boy":"029.315920","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":75.72828,"mes":47355.3,"yon":180,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:12:53"}', '2025-08-25 06:12:53', '2025-08-25 06:12:55'),
	(1899, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.500827, 29.315795, _binary 0x000000000101000000863dedf0d7503d4057bbdc161b404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:13:55","ind":0,"enl":"40.5008267","boy":"029.315795","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47355.6,"yon":194,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 09:13:55"}', '2025-08-25 06:13:55', '2025-08-25 06:13:56'),
	(1900, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.496842, 29.312411, _binary 0x00000000010100000021e9d32afa4f3d40ff644282983f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:14:39","ind":0,"enl":"40.4968417","boy":"029.312411","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":61.46788,"mes":47356.1,"yon":208,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:14:39"}', '2025-08-25 06:14:39', '2025-08-25 06:14:41'),
	(1901, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.492260, 29.311298, _binary 0x0000000001010000006a4fc939b14f3d4082902c60023f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:15:32","ind":0,"enl":"40.4922600","boy":"029.311298","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":52.6894,"mes":47356.7,"yon":185,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:15:32"}', '2025-08-25 06:15:32', '2025-08-25 06:15:33'),
	(1902, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.489595, 29.310866, _binary 0x000000000101000000377007ea944f3d407fa4880cab3e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:16:33","ind":0,"enl":"40.4895950","boy":"029.310866","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":44.98508,"mes":47357,"yon":184,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:16:33"}', '2025-08-25 06:16:33', '2025-08-25 06:16:35'),
	(1903, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.484898, 29.310153, _binary 0x0000000001010000009cc1df2f664f3d406831c225113e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:17:04","ind":0,"enl":"40.4848983","boy":"029.310153","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":64.30144,"mes":47357.5,"yon":194,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:17:04"}', '2025-08-25 06:17:04', '2025-08-25 06:17:05'),
	(1904, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.480815, 29.307486, _binary 0x00000000010100000055fa0967b74e3d408f368e588b3d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:17:48","ind":0,"enl":"40.4808150","boy":"029.307486","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":50.967040000000004,"mes":47358,"yon":210,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:17:48"}', '2025-08-25 06:17:48', '2025-08-25 06:17:50'),
	(1905, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.477355, 29.304688, _binary 0x000000000101000000d07b6308004e3d4082caf8f7193d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:18:12","ind":0,"enl":"40.4773550","boy":"029.304688","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.32124,"mes":47358.4,"yon":211,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:18:12"}', '2025-08-25 06:18:12', '2025-08-25 06:18:14'),
	(1906, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.477185, 29.304550, _binary 0x0000000001010000002eff21fdf64d3d402592e865143d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:18:13","ind":0,"enl":"40.4771850","boy":"029.304550","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.93232,"mes":47358.4,"yon":211,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:18:13"}', '2025-08-25 06:18:13', '2025-08-25 06:18:15'),
	(1907, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.477018, 29.304411, _binary 0x000000000101000000ec8a19e1ed4d3d40f80b87ef0e3d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:18:14","ind":0,"enl":"40.4770183","boy":"029.304411","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.43236,"mes":47358.5,"yon":211,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:18:14"}', '2025-08-25 06:18:14', '2025-08-25 06:18:16'),
	(1908, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.472737, 29.300960, _binary 0x0000000001010000007767edb60b4d3d403a0fdda2823c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:18:37","ind":0,"enl":"40.4727367","boy":"029.300960","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":86.9514,"mes":47359,"yon":212,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:18:37"}', '2025-08-25 06:18:37', '2025-08-25 06:18:40'),
	(1909, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.468633, 29.297658, _binary 0x0000000001010000008c648f50334c3d4085a80c2dfc3b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:18:59","ind":0,"enl":"40.4686333","boy":"029.297658","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":82.33992,"mes":47359.6,"yon":211,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:18:59"}', '2025-08-25 06:18:59', '2025-08-25 06:19:01'),
	(1910, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.468292, 29.297380, _binary 0x000000000101000000077c7e18214c3d407f3e80fbf03b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:19:01","ind":0,"enl":"40.4682917","boy":"029.297380","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.5434,"mes":47359.6,"yon":211,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:19:01"}', '2025-08-25 06:19:01', '2025-08-25 06:19:03'),
	(1911, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.467288, 29.296563, _binary 0x0000000001010000002234828deb4b3d40d7265f1ad03b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:19:07","ind":0,"enl":"40.4672883","boy":"029.296563","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.39532,"mes":47359.7,"yon":211,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:19:07"}', '2025-08-25 06:19:07', '2025-08-25 06:19:08'),
	(1912, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.463795, 29.293721, _binary 0x000000000101000000ff25a94c314b3d402f8672a25d3b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:19:27","ind":0,"enl":"40.4637950","boy":"029.293721","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.37672,"mes":47360.2,"yon":211,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:19:27"}', '2025-08-25 06:19:27', '2025-08-25 06:19:29'),
	(1913, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.459832, 29.290360, _binary 0x0000000001010000000a117008554a3d400195e0c3db3a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:20:14","ind":0,"enl":"40.4598317","boy":"029.290360","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":57.337920000000004,"mes":47360.7,"yon":210,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:20:14"}', '2025-08-25 06:20:14', '2025-08-25 06:20:16'),
	(1914, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.455617, 29.287018, _binary 0x000000000101000000035dfb027a493d407701e5a5513a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:20:43","ind":0,"enl":"40.4556167","boy":"029.287018","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":69.32036000000001,"mes":47361.3,"yon":215,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:20:43"}', '2025-08-25 06:20:43', '2025-08-25 06:20:45'),
	(1915, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.452490, 29.282935, _binary 0x000000000101000000cde49b6d6e483d402ee23b31eb394440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:21:09","ind":0,"enl":"40.4524900","boy":"029.282935","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.48792,"mes":47361.8,"yon":234,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:21:09"}', '2025-08-25 06:21:09', '2025-08-25 06:21:11'),
	(1916, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.449568, 29.277453, _binary 0x000000000101000000562de92807473d40bfe83c748b394440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:21:32","ind":0,"enl":"40.4495683","boy":"029.277453","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":99.32276000000002,"mes":47362.2,"yon":234,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:21:32"}', '2025-08-25 06:21:32', '2025-08-25 06:21:39'),
	(1917, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.446850, 29.272325, _binary 0x00000000010100000019e25817b7453d40da1b7c6132394440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:21:51","ind":0,"enl":"40.4468500","boy":"029.272325","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":91.89624,"mes":47362.8,"yon":233,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:21:51"}', '2025-08-25 06:21:51', '2025-08-25 06:21:53'),
	(1918, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.446357, 29.271406, _binary 0x0000000001010000002cf015dd7a453d40dd6c623722394440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:21:55","ind":0,"enl":"40.4463567","boy":"029.271406","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.39524,"mes":47362.9,"yon":235,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:21:55"}', '2025-08-25 06:21:55', '2025-08-25 06:21:57'),
	(1919, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.443692, 29.266378, _binary 0x000000000101000000b75f3e5931443d40da80bee3ca384440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:22:31","ind":0,"enl":"40.4436917","boy":"029.266378","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":81.61764000000001,"mes":47363.4,"yon":232,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:22:31"}', '2025-08-25 06:22:31', '2025-08-25 06:22:33'),
	(1920, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.440700, 29.260856, _binary 0x00000000010100000023f77475c7423d4071ac8bdb68384440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:22:53","ind":0,"enl":"40.4407000","boy":"029.260856","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":103.67496,"mes":47364,"yon":235,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:22:53"}', '2025-08-25 06:22:53', '2025-08-25 06:22:54'),
	(1921, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.437468, 29.255505, _binary 0x000000000101000000e8f692c668413d40b3c414f6fe374440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:23:13","ind":0,"enl":"40.4374683","boy":"029.255505","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":95.95212000000001,"mes":47364.6,"yon":225,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:23:13"}', '2025-08-25 06:23:13', '2025-08-25 06:23:15'),
	(1922, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.433608, 29.251535, _binary 0x000000000101000000a3cc069964403d4018e30d7a80374440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:23:32","ind":0,"enl":"40.4336083","boy":"029.251535","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":114.43508,"mes":47365.1,"yon":216,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:23:32"}', '2025-08-25 06:23:32', '2025-08-25 06:23:34'),
	(1923, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.429515, 29.247406, _binary 0x0000000001010000008dd5e6ff553f3d401b12f758fa364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:23:51","ind":0,"enl":"40.4295150","boy":"029.247406","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":99.2672,"mes":47365.6,"yon":207,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:23:51"}', '2025-08-25 06:23:51', '2025-08-25 06:23:53'),
	(1924, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.426157, 29.243108, _binary 0x0000000001010000005e656d533c3e3d4053bc804d8c364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:24:12","ind":0,"enl":"40.4261567","boy":"029.243108","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":89.9146,"mes":47366.2,"yon":249,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:24:12"}', '2025-08-25 06:24:12', '2025-08-25 06:24:14'),
	(1925, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.426590, 29.236760, _binary 0x0000000001010000003f00a94d9c3c3d407b6649809a364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:24:34","ind":0,"enl":"40.4265900","boy":"029.236760","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":87.02548,"mes":47366.8,"yon":281,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:24:34"}', '2025-08-25 06:24:34', '2025-08-25 06:24:36'),
	(1926, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.426655, 29.235975, _binary 0x00000000010100000071ac8bdb683c3d4062d68ba19c364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:24:37","ind":0,"enl":"40.4266550","boy":"029.235975","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":72.57988,"mes":47366.8,"yon":271,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:24:37"}', '2025-08-25 06:24:37', '2025-08-25 06:24:39'),
	(1927, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.424848, 29.230315, _binary 0x0000000001010000003bc780ecf53a3d406f21d96d61364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:25:11","ind":0,"enl":"40.4248483","boy":"029.230315","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":49.74472,"mes":47367.3,"yon":264,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:25:11"}', '2025-08-25 06:25:11', '2025-08-25 06:25:13'),
	(1928, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.425968, 29.224135, _binary 0x00000000010100000093e34ee960393d40fdd0162186364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:25:43","ind":0,"enl":"40.4259683","boy":"029.224135","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":77.09876000000001,"mes":47367.8,"yon":265,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:25:43"}', '2025-08-25 06:25:43', '2025-08-25 06:25:44'),
	(1929, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.424293, 29.218310, _binary 0x000000000101000000c763062ae3373d40bab42b3e4f364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:26:09","ind":0,"enl":"40.4242933","boy":"029.218310","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":77.1358,"mes":47368.4,"yon":241,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:26:09"}', '2025-08-25 06:26:09', '2025-08-25 06:26:11'),
	(1930, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.423105, 29.212181, _binary 0x00000000010100000024d5777e51363d4015e3fc4d28364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:26:37","ind":0,"enl":"40.4231050","boy":"029.212181","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":76.78392000000001,"mes":47369,"yon":265,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:26:37"}', '2025-08-25 06:26:37', '2025-08-25 06:26:39'),
	(1931, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.423118, 29.211166, _binary 0x000000000101000000f20698f90e363d40686b8ebd28364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:26:41","ind":0,"enl":"40.4231183","boy":"029.211166","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.76572,"mes":47369,"yon":273,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:26:41"}', '2025-08-25 06:26:41', '2025-08-25 06:26:49'),
	(1932, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.423265, 29.209615, _binary 0x00000000010100000044c02154a9353d404e452a8c2d364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:26:47","ind":0,"enl":"40.4232650","boy":"029.209615","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.24708,"mes":47369.1,"yon":278,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:26:47"}', '2025-08-25 06:26:47', '2025-08-25 06:26:49'),
	(1933, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.423890, 29.203500, _binary 0x0000000001010000006abc749318343d40fc8c0b0742364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:27:13","ind":0,"enl":"40.4238900","boy":"029.203500","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":65.30152,"mes":47369.6,"yon":267,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:27:13"}', '2025-08-25 06:27:13', '2025-08-25 06:27:15'),
	(1934, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.422835, 29.197195, _binary 0x0000000001010000004aef1b5f7b323d40554d10751f364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:27:43","ind":0,"enl":"40.4228350","boy":"029.197195","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":69.95004000000002,"mes":47370.1,"yon":271,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:27:43"}', '2025-08-25 06:27:43', '2025-08-25 06:27:45'),
	(1935, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.423815, 29.191185, _binary 0x0000000001010000005b7c0a80f1303d40f146e6913f364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:28:18","ind":0,"enl":"40.4238150","boy":"029.191185","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":32.873000000000005,"mes":47370.7,"yon":293,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:28:18"}', '2025-08-25 06:28:18', '2025-08-25 06:28:20'),
	(1936, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.424058, 29.188458, _binary 0x00000000010100000069ab92c83e303d40760cd98a47364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:28:31","ind":0,"enl":"40.4240583","boy":"029.188458","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":85.11792000000001,"mes":47370.9,"yon":270,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:28:31"}', '2025-08-25 06:28:31', '2025-08-25 06:28:32'),
	(1937, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.423650, 29.182253, _binary 0x0000000001010000000f99f221a82e3d40a779c7293a364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:28:49","ind":0,"enl":"40.4236500","boy":"029.182253","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":113.0646,"mes":47371.4,"yon":264,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:28:49"}', '2025-08-25 06:28:49', '2025-08-25 06:28:51'),
	(1938, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.423243, 29.175826, _binary 0x00000000010100000058c9c7ee022d3d4025e021d62c364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:29:10","ind":0,"enl":"40.4232433","boy":"029.175826","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":81.46948,"mes":47372,"yon":264,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:29:10"}', '2025-08-25 06:29:10', '2025-08-25 06:29:11'),
	(1939, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.423202, 29.175303, _binary 0x00000000010100000004e44ba8e02c3d40498e2a792b364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:29:12","ind":0,"enl":"40.4232017","boy":"029.175303","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":78.95076,"mes":47372,"yon":264,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:29:12"}', '2025-08-25 06:29:12', '2025-08-25 06:29:13'),
	(1940, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.424262, 29.169876, _binary 0x000000000101000000136058fe7c2b3d40023917354e364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:29:43","ind":0,"enl":"40.4242617","boy":"029.169876","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":47.689,"mes":47372.5,"yon":347,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:29:43"}', '2025-08-25 06:29:43', '2025-08-25 06:29:44'),
	(1941, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.428792, 29.169533, _binary 0x000000000101000000c097c283662b3d40eb257ca5e2364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:30:17","ind":0,"enl":"40.4287917","boy":"029.169533","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":64.69036,"mes":47373,"yon":345,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:30:17"}', '2025-08-25 06:30:17', '2025-08-25 06:30:19'),
	(1942, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.433675, 29.168880, _binary 0x000000000101000000d0f23cb83b2b3d40e10b93a982374440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:30:48","ind":0,"enl":"40.4336750","boy":"029.168880","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":62.89392,"mes":47373.6,"yon":358,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:30:48"}', '2025-08-25 06:30:48', '2025-08-25 06:30:50'),
	(1943, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.438095, 29.167175, _binary 0x00000000010100000074b515fbcb2a3d4043c5387f13384440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:31:16","ind":0,"enl":"40.4380950","boy":"029.167175","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":77.19136,"mes":47374.2,"yon":299,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:31:16"}', '2025-08-25 06:31:16', '2025-08-25 06:31:18'),
	(1944, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.438135, 29.163785, _binary 0x0000000001010000004b9352d0ed293d40d21dc4ce14384440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:31:30","ind":0,"enl":"40.4381350","boy":"029.163785","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.96944,"mes":47374.4,"yon":247,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:31:30"}', '2025-08-25 06:31:30', '2025-08-25 06:31:32'),
	(1945, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.437452, 29.161885, _binary 0x00000000010100000085b69c4b71293d40308ad46afe374440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:31:38","ind":0,"enl":"40.4374517","boy":"029.161885","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.13596,"mes":47374.6,"yon":245,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:31:38"}', '2025-08-25 06:31:38', '2025-08-25 06:31:39'),
	(1946, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.439673, 29.159826, _binary 0x000000000101000000ed0c535bea283d405336f63647384440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:32:07","ind":0,"enl":"40.4396733","boy":"029.159826","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":63.00504000000001,"mes":47375.1,"yon":15,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:32:07"}', '2025-08-25 06:32:07', '2025-08-25 06:32:09'),
	(1947, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.440387, 29.155886, _binary 0x0000000001010000007de71725e8273d40f30b65975e384440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:32:32","ind":0,"enl":"40.4403867","boy":"029.155886","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.39532,"mes":47375.5,"yon":240,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:32:32"}', '2025-08-25 06:32:32', '2025-08-25 06:32:34'),
	(1948, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.440203, 29.155446, _binary 0x000000000101000000454b1e4fcb273d40af8bec9458384440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:32:34","ind":0,"enl":"40.4402033","boy":"029.155446","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":73.91332,"mes":47375.5,"yon":242,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:32:34"}', '2025-08-25 06:32:34', '2025-08-25 06:32:36'),
	(1949, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.439387, 29.149495, _binary 0x00000000010100000060eae74d45263d401066c9d23d384440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:33:01","ind":0,"enl":"40.4393867","boy":"029.149495","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":67.72764000000001,"mes":47376.1,"yon":297,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:33:01"}', '2025-08-25 06:33:01', '2025-08-25 06:33:03'),
	(1950, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.441378, 29.144393, _binary 0x00000000010100000076c58cf0f6243d4000d589157f384440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:33:37","ind":0,"enl":"40.4413783","boy":"029.144393","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":39.92912,"mes":47376.6,"yon":273,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:33:37"}', '2025-08-25 06:33:37', '2025-08-25 06:33:43'),
	(1951, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.443210, 29.139131, _binary 0x0000000001010000001adcd6169e233d404da1f31abb384440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:34:20","ind":0,"enl":"40.4432100","boy":"029.139131","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":27.48368,"mes":47377.2,"yon":336,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:34:20"}', '2025-08-25 06:34:20', '2025-08-25 06:34:24'),
	(1952, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.445468, 29.134676, _binary 0x0000000001010000005c8e57207a223d40cef3f11a05394440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:35:05","ind":0,"enl":"40.4454683","boy":"029.134676","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":63.22728000000001,"mes":47377.6,"yon":287,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:35:05"}', '2025-08-25 06:35:05', '2025-08-25 06:35:07'),
	(1953, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.449248, 29.132081, _binary 0x000000000101000000486c770fd0213d404d24e2f780394440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:35:37","ind":0,"enl":"40.4492483","boy":"029.132081","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":56.93048,"mes":47378.2,"yon":326,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:35:37"}', '2025-08-25 06:35:37', '2025-08-25 06:35:39'),
	(1954, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.451995, 29.127085, _binary 0x000000000101000000eacf7ea488203d404e7adff8da394440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:36:07","ind":0,"enl":"40.4519950","boy":"029.127085","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":60.15296,"mes":47378.7,"yon":317,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:36:07"}', '2025-08-25 06:36:07', '2025-08-25 06:36:09'),
	(1955, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.456368, 29.124690, _binary 0x000000000101000000642310afeb1f3d402fb7c5466a3a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:36:39","ind":0,"enl":"40.4563683","boy":"029.124690","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":64.82000000000001,"mes":47379.3,"yon":309,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:36:39"}', '2025-08-25 06:36:39', '2025-08-25 06:36:41'),
	(1956, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.457133, 29.118406, _binary 0x00000000010100000072a609db4f1e3d40cfb40e58833a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:37:07","ind":0,"enl":"40.4571333","boy":"029.118406","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":71.26496,"mes":47379.8,"yon":293,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:37:07"}', '2025-08-25 06:37:07', '2025-08-25 06:37:08'),
	(1957, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.460232, 29.113585, _binary 0x000000000101000000f05014e8131d3d408f0a52dfe83a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:37:36","ind":0,"enl":"40.4602317","boy":"029.113585","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":66.61644,"mes":47380.3,"yon":284,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:37:36"}', '2025-08-25 06:37:36', '2025-08-25 06:37:37'),
	(1958, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.462718, 29.112808, _binary 0x00000000010100000028ba2efce01c3d405fe16e5a3a3b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:38:08","ind":0,"enl":"40.4627183","boy":"029.112808","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":63.523599999999995,"mes":47380.9,"yon":81,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:38:08"}', '2025-08-25 06:38:08', '2025-08-25 06:38:10'),
	(1959, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.465318, 29.109915, _binary 0x0000000001010000000057b263231c3d407b5dd08c8f3b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:38:38","ind":0,"enl":"40.4653183","boy":"029.109915","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":74.7282,"mes":47381.3,"yon":294,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:38:38"}', '2025-08-25 06:38:38', '2025-08-25 06:38:40'),
	(1960, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.465828, 29.108545, _binary 0x000000000101000000f224e99ac91b3d4090060143a03b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:38:44","ind":0,"enl":"40.4658283","boy":"029.108545","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.41384000000001,"mes":47381.5,"yon":302,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:38:44"}', '2025-08-25 06:38:44', '2025-08-25 06:38:46'),
	(1961, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.466317, 29.107656, _binary 0x000000000101000000da37f7578f1b3d40110a0044b03b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:38:48","ind":0,"enl":"40.4663167","boy":"029.107656","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.173,"mes":47381.6,"yon":308,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:38:48"}', '2025-08-25 06:38:48', '2025-08-25 06:38:49'),
	(1962, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.470097, 29.104006, _binary 0x00000000010100000078962023a01a3d40903af0202c3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:39:13","ind":0,"enl":"40.4700967","boy":"029.104006","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":63.83844,"mes":47382,"yon":327,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:39:13"}', '2025-08-25 06:39:13', '2025-08-25 06:39:15'),
	(1963, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473283, 29.100113, _binary 0x0000000001010000008ae76c01a1193d40199f138c943c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:39:52","ind":0,"enl":"40.4732833","boy":"029.100113","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":32.46556,"mes":47382.6,"yon":265,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:39:52"}', '2025-08-25 06:39:52', '2025-08-25 06:39:54'),
	(1964, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473113, 29.096271, _binary 0x000000000101000000a08d5c37a5183d40bd6603fa8e3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:40:54","ind":0,"enl":"40.4731133","boy":"029.096271","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":27.24292,"mes":47383,"yon":319,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:40:54"}', '2025-08-25 06:40:54', '2025-08-25 06:40:55'),
	(1965, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473380, 29.095318, _binary 0x0000000001010000005ab8acc266183d404d4a41b7973c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:41:56","ind":0,"enl":"40.4733800","boy":"029.095318","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":4.37072,"mes":47383.2,"yon":52,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 09:41:56"}', '2025-08-25 06:41:56', '2025-08-25 06:41:57'),
	(1966, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473472, 29.095501, _binary 0x0000000001010000003cbce7c072183d406f8a7db89a3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:42:57","ind":0,"enl":"40.4734717","boy":"029.095501","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":59,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 09:42:57"}', '2025-08-25 06:42:57', '2025-08-25 06:42:59'),
	(1967, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473472, 29.095501, _binary 0x0000000001010000003cbce7c072183d406f8a7db89a3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:43:59","ind":0,"enl":"40.4734717","boy":"029.095501","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":54,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 09:43:59"}', '2025-08-25 06:43:59', '2025-08-25 06:44:00'),
	(1968, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473472, 29.095501, _binary 0x0000000001010000003cbce7c072183d406f8a7db89a3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:44:00","ind":0,"enl":"40.4734717","boy":"029.095501","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":54,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 09:44:00"}', '2025-08-25 06:44:00', '2025-08-25 06:44:02'),
	(1969, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"09:59:25","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 09:59:25"}', '2025-08-25 06:59:25', '2025-08-25 06:59:27'),
	(1970, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"10:14:50","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":302,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 10:14:50"}', '2025-08-25 07:14:50', '2025-08-25 07:14:51'),
	(1971, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"10:23:14","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":221,"A":"4","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 10:23:14"}', '2025-08-25 07:23:14', '2025-08-25 07:23:16'),
	(1972, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"10:38:40","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":125,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 10:38:40"}', '2025-08-25 07:38:40', '2025-08-25 07:38:42'),
	(1973, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"10:54:05","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":47,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 10:54:05"}', '2025-08-25 07:54:05', '2025-08-25 07:54:06'),
	(1974, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"11:09:29","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":176,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 11:09:29"}', '2025-08-25 08:09:29', '2025-08-25 08:09:31'),
	(1975, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"11:24:54","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":174,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 11:24:54"}', '2025-08-25 08:24:54', '2025-08-25 08:24:56'),
	(1976, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"11:40:20","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":107,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 11:40:20"}', '2025-08-25 08:40:20', '2025-08-25 08:40:21'),
	(1977, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"11:55:45","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":134,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 11:55:45"}', '2025-08-25 08:55:45', '2025-08-25 08:55:46'),
	(1978, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"12:11:10","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":114,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 12:11:10"}', '2025-08-25 09:11:10', '2025-08-25 09:11:12'),
	(1979, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"12:26:35","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":117,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 12:26:35"}', '2025-08-25 09:26:35', '2025-08-25 09:26:37'),
	(1980, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"12:42:00","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":62,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 12:42:00"}', '2025-08-25 09:42:00', '2025-08-25 09:42:02'),
	(1981, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"12:57:25","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":87,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 12:57:25"}', '2025-08-25 09:57:25', '2025-08-25 09:57:27'),
	(1982, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"13:12:50","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":141,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 13:12:50"}', '2025-08-25 10:12:50', '2025-08-25 10:12:52'),
	(1983, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"13:28:15","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":349,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 13:28:15"}', '2025-08-25 10:28:15', '2025-08-25 10:28:17'),
	(1984, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"13:43:41","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":165,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 13:43:41"}', '2025-08-25 10:43:41', '2025-08-25 10:43:42'),
	(1985, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"13:59:06","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":80,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 13:59:06"}', '2025-08-25 10:59:06', '2025-08-25 10:59:08'),
	(1986, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"14:14:32","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":173,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 14:14:32"}', '2025-08-25 11:14:32', '2025-08-25 11:14:33'),
	(1987, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"14:29:57","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":168,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 14:29:57"}', '2025-08-25 11:29:57', '2025-08-25 11:29:59'),
	(1988, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"14:45:22","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":148,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 14:45:22"}', '2025-08-25 11:45:22', '2025-08-25 11:45:24'),
	(1989, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"15:00:48","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":2,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 15:00:48"}', '2025-08-25 12:00:48', '2025-08-25 12:00:49'),
	(1990, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"15:16:13","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":217,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 15:16:13"}', '2025-08-25 12:16:13', '2025-08-25 12:16:14'),
	(1991, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"15:31:38","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":202,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 15:31:38"}', '2025-08-25 12:31:38', '2025-08-25 12:31:39'),
	(1992, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"15:47:03","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":229,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 15:47:03"}', '2025-08-25 12:47:03', '2025-08-25 12:47:05'),
	(1993, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"16:02:28","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":306,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 16:02:28"}', '2025-08-25 13:02:28', '2025-08-25 13:02:30'),
	(1994, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"16:17:53","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":205,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 16:17:53"}', '2025-08-25 13:17:53', '2025-08-25 13:17:54'),
	(1995, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"16:33:18","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":201,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 16:33:18"}', '2025-08-25 13:33:18', '2025-08-25 13:33:19'),
	(1996, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"16:48:42","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":240,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 16:48:42"}', '2025-08-25 13:48:42', '2025-08-25 13:48:44'),
	(1997, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:04:07","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":179,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 17:04:07"}', '2025-08-25 14:04:07', '2025-08-25 14:04:08'),
	(1998, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:19:31","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":117,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 17:19:31"}', '2025-08-25 14:19:31', '2025-08-25 14:19:33'),
	(1999, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473508, 29.095510, _binary 0x000000000101000000e370e65773183d40397183eb9b3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:33:32","ind":0,"enl":"40.4735083","boy":"029.095510","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47383.2,"yon":219,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 17:33:32"}', '2025-08-25 14:33:32', '2025-08-25 14:33:34'),
	(2000, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.473542, 29.095605, _binary 0x0000000001010000008655bc9179183d406865b1039d3c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:34:33","ind":0,"enl":"40.4735417","boy":"029.095605","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":14.038160000000001,"mes":47383.2,"yon":60,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:34:33"}', '2025-08-25 14:34:33', '2025-08-25 14:34:35'),
	(2001, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.472717, 29.097668, _binary 0x000000000101000000a0dd21c500193d40f36217fb813c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:35:35","ind":0,"enl":"40.4727167","boy":"029.097668","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":7.389480000000001,"mes":47383.5,"yon":41,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:35:35"}', '2025-08-25 14:35:35', '2025-08-25 14:35:36'),
	(2002, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.471733, 29.102503, _binary 0x000000000101000000ecbdf8a23d1a3d4092f7bbc1613c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:36:33","ind":0,"enl":"40.4717333","boy":"029.102503","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":61.74568000000001,"mes":47384,"yon":147,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:36:33"}', '2025-08-25 14:36:33', '2025-08-25 14:36:35'),
	(2003, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.467767, 29.105951, _binary 0x0000000001010000007ffacf9a1f1b3d4034547bc7df3b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:37:00","ind":0,"enl":"40.4677667","boy":"029.105951","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":72.82064,"mes":47384.6,"yon":146,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:37:00"}', '2025-08-25 14:37:00', '2025-08-25 14:37:02'),
	(2004, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.466238, 29.107841, _binary 0x000000000101000000fe2ac0779b1b3d40425255b2ad3b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:37:11","ind":0,"enl":"40.4662383","boy":"029.107841","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":81.28428000000001,"mes":47384.8,"yon":125,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:37:11"}', '2025-08-25 14:37:11', '2025-08-25 14:37:12'),
	(2005, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.464487, 29.112126, _binary 0x00000000010100000003081f4ab41c3d40a7f6d84c743b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:37:29","ind":0,"enl":"40.4644867","boy":"029.112126","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.98788,"mes":47385.2,"yon":116,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:37:29"}', '2025-08-25 14:37:29', '2025-08-25 14:37:31'),
	(2006, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.462117, 29.110795, _binary 0x000000000101000000718fa50f5d1c3d40bdb7d8a3263b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:38:03","ind":0,"enl":"40.4621167","boy":"029.110795","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":43.65164,"mes":47385.7,"yon":199,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:38:03"}', '2025-08-25 14:38:03', '2025-08-25 14:38:04'),
	(2007, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.459365, 29.115485, _binary 0x000000000101000000b62dca6c901d3d40a9f6e978cc3a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:38:38","ind":0,"enl":"40.4593650","boy":"029.115485","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":63.00504000000001,"mes":47386.2,"yon":140,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:38:38"}', '2025-08-25 14:38:38', '2025-08-25 14:38:39'),
	(2008, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.456810, 29.120700, _binary 0x00000000010100000090a0f831e61e3d402d3e05c0783a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:39:08","ind":0,"enl":"40.4568100","boy":"029.120700","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":64.39404,"mes":47386.8,"yon":94,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:39:08"}', '2025-08-25 14:39:08', '2025-08-25 14:39:10'),
	(2009, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.454913, 29.125808, _binary 0x0000000001010000003e93fdf334203d40fa0159993a3a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:39:40","ind":0,"enl":"40.4549133","boy":"029.125808","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":62.61612000000001,"mes":47387.2,"yon":168,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:39:40"}', '2025-08-25 14:39:40', '2025-08-25 14:39:41'),
	(2010, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.450777, 29.128611, _binary 0x000000000101000000e6e786a6ec203d403f26080db3394440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:40:13","ind":0,"enl":"40.4507767","boy":"029.128611","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":59.856640000000006,"mes":47387.8,"yon":136,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:40:13"}', '2025-08-25 14:40:13', '2025-08-25 14:40:14'),
	(2011, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.447645, 29.132283, _binary 0x00000000010100000018d1764cdd213d40e59b6d6e4c394440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:40:47","ind":0,"enl":"40.4476450","boy":"029.132283","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":56.023,"mes":47388.3,"yon":183,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:40:47"}', '2025-08-25 14:40:47', '2025-08-25 14:40:50'),
	(2012, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.445190, 29.137030, _binary 0x0000000001010000002592e86514233d40cc4065fcfb384440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:41:26","ind":0,"enl":"40.4451900","boy":"029.137030","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":42.8738,"mes":47388.9,"yon":95,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:41:26"}', '2025-08-25 14:41:26', '2025-08-25 14:41:27'),
	(2013, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.442132, 29.140663, _binary 0x000000000101000000dbc1887d02243d402f0384c597384440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:42:14","ind":0,"enl":"40.4421317","boy":"029.140663","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":50.50404,"mes":47389.3,"yon":105,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:42:14"}', '2025-08-25 14:42:14', '2025-08-25 14:42:15'),
	(2014, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.440278, 29.145838, _binary 0x0000000001010000009983a0a355253d40bad1110a5b384440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:42:55","ind":0,"enl":"40.4402783","boy":"029.145838","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":44.6332,"mes":47389.9,"yon":122,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:42:55"}', '2025-08-25 14:42:55', '2025-08-25 14:42:58'),
	(2015, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.439150, 29.151008, _binary 0x000000000101000000336fd575a8263d40ea04341136384440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:43:57","ind":0,"enl":"40.4391500","boy":"029.151008","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":50.689240000000005,"mes":47390.4,"yon":81,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:43:57"}', '2025-08-25 14:43:57', '2025-08-25 14:43:58'),
	(2016, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.440645, 29.156733, _binary 0x000000000101000000373465a71f283d40ae122c0e67384440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:44:33","ind":0,"enl":"40.4406450","boy":"029.156733","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":53.133880000000005,"mes":47390.8,"yon":62,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:44:33"}', '2025-08-25 14:44:33', '2025-08-25 14:44:34'),
	(2017, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.438212, 29.159066, _binary 0x000000000101000000d1e7a38cb8283d40be1c2c5217384440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:45:05","ind":0,"enl":"40.4382117","boy":"029.159066","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":63.35692,"mes":47391.4,"yon":197,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:45:05"}', '2025-08-25 14:45:05', '2025-08-25 14:45:06'),
	(2018, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.437875, 29.163471, _binary 0x0000000001010000002cd8463cd9293d40355eba490c384440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:45:36","ind":0,"enl":"40.4378750","boy":"029.163471","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":68.78328,"mes":47391.9,"yon":65,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:45:36"}', '2025-08-25 14:45:36', '2025-08-25 14:45:38'),
	(2019, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.436552, 29.168581, _binary 0x0000000001010000001bbad91f282b3d40b14115ede0374440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:46:02","ind":0,"enl":"40.4365517","boy":"029.168581","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":76.6728,"mes":47392.4,"yon":161,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:46:02"}', '2025-08-25 14:46:02', '2025-08-25 14:46:03'),
	(2020, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.431833, 29.168848, _binary 0x000000000101000000b9fe5d9f392b3d407169465046374440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:46:36","ind":0,"enl":"40.4318333","boy":"029.168848","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":34.59536,"mes":47392.9,"yon":178,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:46:36"}', '2025-08-25 14:46:36', '2025-08-25 14:46:38'),
	(2021, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.428410, 29.169453, _binary 0x00000000010100000087359545612b3d40c2a38d23d6364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:47:38","ind":0,"enl":"40.4284100","boy":"029.169453","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":38.81792,"mes":47393.4,"yon":162,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:47:38"}', '2025-08-25 14:47:38', '2025-08-25 14:47:39'),
	(2022, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.423833, 29.169613, _binary 0x000000000101000000f8f9efc16b2b3d40563a692b40364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:48:36","ind":0,"enl":"40.4238333","boy":"029.169613","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":58.96768,"mes":47393.8,"yon":184,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:48:36"}', '2025-08-25 14:48:36', '2025-08-25 14:48:38'),
	(2023, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.422742, 29.170585, _binary 0x0000000001010000002b306475ab2b3d40e61368661c364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:49:16","ind":0,"enl":"40.4227417","boy":"029.170585","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":61.838280000000005,"mes":47394.4,"yon":82,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:49:16"}', '2025-08-25 14:49:16', '2025-08-25 14:49:18'),
	(2024, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.423223, 29.177063, _binary 0x000000000101000000e7543200542d3d40dd335c2e2c364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:49:45","ind":0,"enl":"40.4232233","boy":"029.177063","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":73.48736000000001,"mes":47394.9,"yon":84,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:49:45"}', '2025-08-25 14:49:45', '2025-08-25 14:49:47'),
	(2025, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.423352, 29.179081, _binary 0x000000000101000000c1559e40d82d3d405e1a756330364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:49:53","ind":0,"enl":"40.4233517","boy":"029.179081","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":82.11768000000001,"mes":47395.1,"yon":84,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:49:53"}', '2025-08-25 14:49:53', '2025-08-25 14:49:55'),
	(2026, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.423758, 29.185088, _binary 0x000000000101000000cee15aed612f3d404cf443b63d364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:50:14","ind":0,"enl":"40.4237583","boy":"029.185088","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":77.56176,"mes":47395.6,"yon":85,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:50:14"}', '2025-08-25 14:50:14', '2025-08-25 14:50:16'),
	(2027, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.423902, 29.188145, _binary 0x000000000101000000eae74d452a303d40021c316942364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:51:16","ind":0,"enl":"40.4239017","boy":"029.188145","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47395.9,"yon":87,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 17:51:16"}', '2025-08-25 14:51:16', '2025-08-25 14:51:17'),
	(2028, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.423227, 29.194401, _binary 0x000000000101000000484f9143c4313d40a2a5e14a2c364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:51:53","ind":0,"enl":"40.4232267","boy":"029.194401","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":69.59816000000001,"mes":47396.4,"yon":103,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:51:53"}', '2025-08-25 14:51:53', '2025-08-25 14:51:55'),
	(2029, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.423320, 29.200555, _binary 0x0000000001010000009e0c8e9257333d4011df89592f364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:52:22","ind":0,"enl":"40.4233200","boy":"029.200555","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":68.76476000000001,"mes":47397,"yon":70,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:52:22"}', '2025-08-25 14:52:22', '2025-08-25 14:52:24'),
	(2030, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.423708, 29.205880, _binary 0x00000000010100000086e63a8db4343d409ac5d5123c364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:52:46","ind":0,"enl":"40.4237083","boy":"029.205880","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":82.82144,"mes":47397.4,"yon":100,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:52:46"}', '2025-08-25 14:52:46', '2025-08-25 14:52:48'),
	(2031, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.423078, 29.211350, _binary 0x00000000010100000075029a081b363d40da12036e27364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:53:04","ind":0,"enl":"40.4230783","boy":"029.211350","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.71008,"mes":47397.9,"yon":93,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:53:04"}', '2025-08-25 14:53:04', '2025-08-25 14:53:05'),
	(2032, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.423945, 29.217310, _binary 0x0000000001010000000118cfa0a1373d40c0266bd443364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:53:31","ind":0,"enl":"40.4239450","boy":"029.217310","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":71.45016,"mes":47398.4,"yon":72,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:53:31"}', '2025-08-25 14:53:31', '2025-08-25 14:53:33'),
	(2033, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.425922, 29.223038, _binary 0x000000000101000000e7c3b30419393d4010142e9a84364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:53:58","ind":0,"enl":"40.4259217","boy":"029.223038","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":74.41336,"mes":47398.9,"yon":86,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:53:58"}', '2025-08-25 14:53:58', '2025-08-25 14:54:00'),
	(2034, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.424912, 29.229165, _binary 0x0000000001010000004963b48eaa3a3d400998af8163364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:54:24","ind":0,"enl":"40.4249117","boy":"029.229165","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":72.26504000000001,"mes":47399.4,"yon":109,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:54:24"}', '2025-08-25 14:54:24', '2025-08-25 14:54:26'),
	(2035, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.426013, 29.233706, _binary 0x00000000010100000005e10a28d43b3d409d94939a87364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:54:44","ind":0,"enl":"40.4260133","boy":"029.233706","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.099,"mes":47399.9,"yon":61,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:54:44"}', '2025-08-25 14:54:44', '2025-08-25 14:54:46'),
	(2036, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.426522, 29.235408, _binary 0x0000000001010000007e37ddb2433c3d406544584398364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:54:51","ind":0,"enl":"40.4265217","boy":"029.235408","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.83972,"mes":47400,"yon":77,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:54:51"}', '2025-08-25 14:54:51', '2025-08-25 14:54:52'),
	(2037, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.426550, 29.235660, _binary 0x000000000101000000b1f9b836543c3d40ed0dbe3099364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:54:52","ind":0,"enl":"40.4265500","boy":"029.235660","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.22864,"mes":47400,"yon":81,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:54:52"}', '2025-08-25 14:54:52', '2025-08-25 14:54:53'),
	(2038, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.425753, 29.240363, _binary 0x0000000001010000001f2bf86d883d3d4000d589157f364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:55:10","ind":0,"enl":"40.4257533","boy":"029.240363","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":78.98780000000001,"mes":47400.4,"yon":92,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:55:10"}', '2025-08-25 14:55:10', '2025-08-25 14:55:12'),
	(2039, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.426315, 29.244530, _binary 0x00000000010100000011e4a084993e3d40aa656b7d91364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:55:27","ind":0,"enl":"40.4263150","boy":"029.244530","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":81.35836,"mes":47400.8,"yon":76,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:55:27"}', '2025-08-25 14:55:27', '2025-08-25 14:55:28'),
	(2040, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.425670, 29.250433, _binary 0x000000000101000000d4d688601c403d40b471c45a7c364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:55:50","ind":0,"enl":"40.4256700","boy":"029.250433","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":82.09916,"mes":47401.2,"yon":121,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:55:50"}', '2025-08-25 14:55:50', '2025-08-25 14:55:52'),
	(2041, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.424892, 29.252311, _binary 0x000000000101000000ca6b257497403d40c2ebe9d962364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:55:58","ind":0,"enl":"40.4248917","boy":"029.252311","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.80268000000001,"mes":47401.5,"yon":114,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:55:58"}', '2025-08-25 14:55:58', '2025-08-25 14:56:00'),
	(2042, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.424735, 29.252790, _binary 0x0000000001010000007fc16ed8b6403d40b83b6bb75d364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:56:00","ind":0,"enl":"40.4247350","boy":"029.252790","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":81.83988,"mes":47401.5,"yon":110,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:56:00"}', '2025-08-25 14:56:00', '2025-08-25 14:56:02'),
	(2043, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.424137, 29.259220, _binary 0x0000000001010000001878ee3d5c423d4045c4831c4a364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:56:24","ind":0,"enl":"40.4241367","boy":"029.259220","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":80.30272000000001,"mes":47402.1,"yon":94,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:56:24"}', '2025-08-25 14:56:24', '2025-08-25 14:56:28'),
	(2044, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.424058, 29.260008, _binary 0x000000000101000000c8b260e28f423d40760cd98a47364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:56:27","ind":0,"enl":"40.4240583","boy":"029.260008","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.98788,"mes":47402.1,"yon":95,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:56:27"}', '2025-08-25 14:56:27', '2025-08-25 14:56:29'),
	(2045, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.424040, 29.260258, _binary 0x000000000101000000ba85ae44a0423d40111956f146364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:56:28","ind":0,"enl":"40.4240400","boy":"029.260258","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.30272000000001,"mes":47402.2,"yon":95,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:56:28"}', '2025-08-25 14:56:28', '2025-08-25 14:56:30'),
	(2046, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.423813, 29.263173, _binary 0x000000000101000000b130444e5f433d400f8ea3833f364440, '0', '{"device_model":"Ortem","p":"0","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:56:39","ind":0,"enl":"40.4238133","boy":"029.263173","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.74712000000001,"mes":47402.4,"yon":95,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:56:39"}', '2025-08-25 14:56:39', '2025-08-25 14:56:46'),
	(2047, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.423308, 29.269993, _binary 0x0000000001010000002026e1421e453d400c5064f72e364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:57:06","ind":0,"enl":"40.4233083","boy":"029.269993","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":77.93216,"mes":47403,"yon":95,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:57:06"}', '2025-08-25 14:57:06', '2025-08-25 14:57:08'),
	(2048, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.422768, 29.276491, _binary 0x0000000001010000006aa33a1dc8463d408c248b451d364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:57:32","ind":0,"enl":"40.4227683","boy":"029.276491","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":73.45031999999999,"mes":47403.4,"yon":96,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:57:32"}', '2025-08-25 14:57:32', '2025-08-25 14:57:34'),
	(2049, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.422290, 29.282736, _binary 0x000000000101000000e066f16261483d40c3b645990d364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:58:04","ind":0,"enl":"40.4222900","boy":"029.282736","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":63.46804000000001,"mes":47404,"yon":93,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:58:04"}', '2025-08-25 14:58:04', '2025-08-25 14:58:06'),
	(2050, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.422137, 29.285155, _binary 0x000000000101000000774a07ebff483d407f784c9308364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:58:14","ind":0,"enl":"40.4221367","boy":"029.285155","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.46940000000001,"mes":47404.3,"yon":94,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:58:14"}', '2025-08-25 14:58:14', '2025-08-25 14:58:20'),
	(2051, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.422092, 29.285665, _binary 0x000000000101000000a29c685721493d40dfb4cf1907364440, '0', '{"device_model":"Ortem","p":"0","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:58:16","ind":0,"enl":"40.4220917","boy":"029.285665","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.52488,"mes":47404.3,"yon":95,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:58:16"}', '2025-08-25 14:58:16', '2025-08-25 14:58:21'),
	(2052, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.421593, 29.292663, _binary 0x000000000101000000cfbf5df6eb4a3d403adbedc4f6354440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:58:44","ind":0,"enl":"40.4215933","boy":"029.292663","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.41384000000001,"mes":47404.8,"yon":95,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:58:44"}', '2025-08-25 14:58:44', '2025-08-25 14:58:46'),
	(2053, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.421563, 29.292923, _binary 0x000000000101000000073f7100fd4a3d40d05845c9f5354440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:58:45","ind":0,"enl":"40.4215633","boy":"029.292923","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":80.43236,"mes":47404.8,"yon":95,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:58:45"}', '2025-08-25 14:58:45', '2025-08-25 14:58:46'),
	(2054, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.421367, 29.295565, _binary 0x0000000001010000009dd7d825aa4b3d40cd0f1258ef354440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:58:55","ind":0,"enl":"40.4213667","boy":"029.295565","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.08048000000001,"mes":47405.1,"yon":95,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:58:55"}', '2025-08-25 14:58:55', '2025-08-25 14:58:57'),
	(2055, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.420883, 29.301953, _binary 0x000000000101000000d9edb3ca4c4d3d405e770481df354440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:59:22","ind":0,"enl":"40.4208833","boy":"029.301953","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":67.46836,"mes":47405.6,"yon":96,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:59:22"}', '2025-08-25 14:59:22', '2025-08-25 14:59:24'),
	(2056, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.420790, 29.302951, _binary 0x0000000001010000005e4a5d328e4d3d40ee3d5c72dc354440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:59:26","ind":0,"enl":"40.4207900","boy":"029.302951","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":81.83988,"mes":47405.6,"yon":95,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:59:26"}', '2025-08-25 14:59:26', '2025-08-25 14:59:28'),
	(2057, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.420480, 29.307235, _binary 0x000000000101000000c22ff5f3a64e3d40a04fe449d2354440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"17:59:41","ind":0,"enl":"40.4204800","boy":"029.307235","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.58044,"mes":47406,"yon":95,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 17:59:41"}', '2025-08-25 14:59:41', '2025-08-25 14:59:42'),
	(2058, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.420037, 29.313615, _binary 0x000000000101000000f888981249503d4054cf38c3c3354440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:00:15","ind":0,"enl":"40.4200367","boy":"029.313615","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":67.56096,"mes":47406.6,"yon":95,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:00:15"}', '2025-08-25 15:00:15', '2025-08-25 15:00:16'),
	(2059, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.419588, 29.320123, _binary 0x00000000010100000089b2b794f3513d406224c511b5354440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:00:43","ind":0,"enl":"40.4195883","boy":"029.320123","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":71.19087999999999,"mes":47407.1,"yon":95,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:00:43"}', '2025-08-25 15:00:43', '2025-08-25 15:00:44'),
	(2060, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.419180, 29.326463, _binary 0x000000000101000000a35a441493533d409291b3b0a7354440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:01:09","ind":0,"enl":"40.4191800","boy":"029.326463","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":74.65412,"mes":47407.6,"yon":94,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:01:09"}', '2025-08-25 15:01:09', '2025-08-25 15:01:11'),
	(2061, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.418805, 29.332916, _binary 0x000000000101000000ad50a4fb39553d405d33f9669b354440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:01:35","ind":0,"enl":"40.4188050","boy":"029.332916","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":76.02459999999999,"mes":47408.2,"yon":94,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:01:35"}', '2025-08-25 15:01:35', '2025-08-25 15:01:37'),
	(2062, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.418430, 29.339413, _binary 0x00000000010100000056d636c5e3563d4028d53e1d8f354440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:02:02","ind":0,"enl":"40.4184300","boy":"029.339413","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":71.83908,"mes":47408.8,"yon":92,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:02:02"}', '2025-08-25 15:02:02', '2025-08-25 15:02:03'),
	(2063, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.417870, 29.345695, _binary 0x0000000001010000000664af777f583d4061fd9fc37c354440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:02:28","ind":0,"enl":"40.4178700","boy":"029.345695","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":73.82072000000001,"mes":47409.2,"yon":98,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:02:28"}', '2025-08-25 15:02:28', '2025-08-25 15:02:32'),
	(2064, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.417180, 29.352090, _binary 0x000000000101000000a73ffb91225a3d40cc457c2766354440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:02:55","ind":0,"enl":"40.4171800","boy":"029.352090","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":72.35764,"mes":47409.8,"yon":97,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:02:55"}', '2025-08-25 15:02:55', '2025-08-25 15:02:57'),
	(2065, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.416095, 29.358218, _binary 0x000000000101000000aad6c22cb45b3d40ba83d89942354440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:03:25","ind":0,"enl":"40.4160950","boy":"029.358218","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":62.3198,"mes":47410.3,"yon":118,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:03:25"}', '2025-08-25 15:03:25', '2025-08-25 15:03:27'),
	(2066, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.414053, 29.363800, _binary 0x000000000101000000e9482eff215d3d408326d3b2ff344440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:03:59","ind":0,"enl":"40.4140533","boy":"029.363800","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":54.33768,"mes":47410.9,"yon":90,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:03:59"}', '2025-08-25 15:03:59', '2025-08-25 15:04:00'),
	(2067, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.413148, 29.369901, _binary 0x000000000101000000f8c1f9d4b15e3d40f272220be2344440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:04:30","ind":0,"enl":"40.4131483","boy":"029.369901","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":66.50532,"mes":47411.4,"yon":122,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:04:30"}', '2025-08-25 15:04:30', '2025-08-25 15:04:31'),
	(2068, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.410583, 29.375305, _binary 0x00000000010100000079060dfd13603d4052e45afe8d344440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:05:01","ind":0,"enl":"40.4105833","boy":"029.375305","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":61.541959999999996,"mes":47411.9,"yon":106,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:05:01"}', '2025-08-25 15:05:01', '2025-08-25 15:05:03'),
	(2069, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.409187, 29.381153, _binary 0x000000000101000000b5c5353e93613d40a53ad33a60344440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:05:32","ind":0,"enl":"40.4091867","boy":"029.381153","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":68.67216,"mes":47412.5,"yon":108,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:05:32"}', '2025-08-25 15:05:32', '2025-08-25 15:05:34'),
	(2070, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.407430, 29.387243, _binary 0x000000000101000000dd9a745b22633d4063b48eaa26344440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:06:00","ind":0,"enl":"40.4074300","boy":"029.387243","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":73.80220000000001,"mes":47412.9,"yon":116,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:06:00"}', '2025-08-25 15:06:00', '2025-08-25 15:06:02'),
	(2071, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.405765, 29.393283, _binary 0x000000000101000000a112d731ae643d40446e861bf0334440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:06:27","ind":0,"enl":"40.4057650","boy":"029.393283","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":69.1722,"mes":47413.5,"yon":108,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:06:27"}', '2025-08-25 15:06:27', '2025-08-25 15:06:29'),
	(2072, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.404100, 29.399191, _binary 0x00000000010100000087dba16131663d4024287e8cb9334440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:06:54","ind":0,"enl":"40.4041000","boy":"029.399191","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":66.43124,"mes":47414,"yon":111,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:06:54"}', '2025-08-25 15:06:54', '2025-08-25 15:06:56'),
	(2073, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.402632, 29.405140, _binary 0x0000000001010000002b4d4a41b7673d409cea7f6f89334440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:07:23","ind":0,"enl":"40.4026317","boy":"029.405140","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":60.81968000000001,"mes":47414.6,"yon":112,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:07:23"}', '2025-08-25 15:07:23', '2025-08-25 15:07:24'),
	(2074, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.398943, 29.408705, _binary 0x00000000010100000031b610e4a0683d40aa3af59210334440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:07:54","ind":0,"enl":"40.3989433","boy":"029.408705","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":60.764120000000005,"mes":47415.1,"yon":126,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:07:54"}', '2025-08-25 15:07:54', '2025-08-25 15:07:56'),
	(2075, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.396275, 29.413683, _binary 0x00000000010100000042e90b21e7693d40789ca223b9324440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:08:36","ind":0,"enl":"40.3962750","boy":"029.413683","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":37.85488,"mes":47415.6,"yon":139,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:08:36"}', '2025-08-25 15:08:36', '2025-08-25 15:08:37'),
	(2076, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.393310, 29.417410, _binary 0x000000000101000000fb05bb61db6a3d404a9869fb57324440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:09:32","ind":0,"enl":"40.3933100","boy":"029.417410","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":25.909480000000002,"mes":47416.1,"yon":97,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:09:32"}', '2025-08-25 15:09:32', '2025-08-25 15:09:34'),
	(2077, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.394643, 29.422696, _binary 0x000000000101000000672618ce356c3d40f28af1ab83324440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:10:11","ind":0,"enl":"40.3946433","boy":"029.422696","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":64.80148000000001,"mes":47416.6,"yon":66,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:10:11"}', '2025-08-25 15:10:11', '2025-08-25 15:10:13'),
	(2078, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.395925, 29.427996, _binary 0x0000000001010000009ed15625916d3d409b559fabad324440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:10:35","ind":0,"enl":"40.3959250","boy":"029.427996","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.69164,"mes":47417.1,"yon":91,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:10:35"}', '2025-08-25 15:10:35', '2025-08-25 15:10:36'),
	(2079, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.395902, 29.428820, _binary 0x000000000101000000e8dec325c76d3d4025f72ae8ac324440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:10:38","ind":0,"enl":"40.3959017","boy":"029.428820","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.93232,"mes":47417.2,"yon":92,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:10:38"}', '2025-08-25 15:10:38', '2025-08-25 15:10:42'),
	(2080, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.395503, 29.435151, _binary 0x0000000001010000005bd2510e666f3d40e47a25da9f324440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:11:07","ind":0,"enl":"40.3955033","boy":"029.435151","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":65.54228,"mes":47417.7,"yon":93,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:11:07"}', '2025-08-25 15:11:07', '2025-08-25 15:11:09'),
	(2081, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.394762, 29.441180, _binary 0x00000000010100000037a6272cf1703d404f9b278d87324440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:11:41","ind":0,"enl":"40.3947617","boy":"029.441180","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":52.93016,"mes":47418.3,"yon":105,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:11:41"}', '2025-08-25 15:11:41', '2025-08-25 15:11:42'),
	(2082, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.393747, 29.447156, _binary 0x000000000101000000ce35ccd078723d4037b4b74a66324440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:12:21","ind":0,"enl":"40.3937467","boy":"029.447156","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":42.52192,"mes":47418.7,"yon":105,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:12:21"}', '2025-08-25 15:12:21', '2025-08-25 15:12:23'),
	(2083, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.392072, 29.452910, _binary 0x0000000001010000000708e6e8f1733d40f497cc672f324440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:12:59","ind":0,"enl":"40.3920717","boy":"029.452910","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":50.30032,"mes":47419.3,"yon":99,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:12:59"}', '2025-08-25 15:12:59', '2025-08-25 15:13:01'),
	(2084, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.390992, 29.458846, _binary 0x00000000010100000082e673ee76753d40f4401a040c324440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:13:41","ind":0,"enl":"40.3909917","boy":"029.458846","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":52.89312,"mes":47419.8,"yon":110,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:13:41"}', '2025-08-25 15:13:41', '2025-08-25 15:13:43'),
	(2085, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.389212, 29.464258, _binary 0x00000000010100000008e8be9cd9763d403b5c61b0d1314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:14:23","ind":0,"enl":"40.3892117","boy":"029.464258","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":36.09548,"mes":47420.3,"yon":116,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:14:23"}', '2025-08-25 15:14:23', '2025-08-25 15:14:25'),
	(2086, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.388317, 29.470030, _binary 0x0000000001010000008e23d6e253783d40cd7e935cb4314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:15:13","ind":0,"enl":"40.3883167","boy":"029.470030","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":76.26536,"mes":47420.8,"yon":85,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:15:13"}', '2025-08-25 15:15:13', '2025-08-25 15:15:14'),
	(2087, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.387045, 29.475561, _binary 0x000000000101000000c8409e5dbe793d40488ac8b08a314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:15:42","ind":0,"enl":"40.3870450","boy":"029.475561","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":53.78208,"mes":47421.4,"yon":105,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:15:42"}', '2025-08-25 15:15:42', '2025-08-25 15:15:44'),
	(2088, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.387268, 29.481080, _binary 0x0000000001010000007ac2120f287b3d4086a3f50192314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:16:26","ind":0,"enl":"40.3872683","boy":"029.481080","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":29.33568,"mes":47421.8,"yon":96,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:16:26"}', '2025-08-25 15:16:26', '2025-08-25 15:16:27'),
	(2089, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.387488, 29.486963, _binary 0x000000000101000000af5c6f9ba97c3d40940a743799314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:17:09","ind":0,"enl":"40.3874883","boy":"029.486963","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":51.52264,"mes":47422.4,"yon":98,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:17:09"}', '2025-08-25 15:17:09', '2025-08-25 15:17:11'),
	(2090, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.388203, 29.493263, _binary 0x000000000101000000ac53e57b467e3d4082d94ea5b0314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:17:41","ind":0,"enl":"40.3882033","boy":"029.493263","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":62.727239999999995,"mes":47422.9,"yon":77,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:17:41"}', '2025-08-25 15:17:41', '2025-08-25 15:17:43'),
	(2091, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.387932, 29.499366, _binary 0x000000000101000000fdbb3e73d67f3d40754af6bea7314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:18:14","ind":0,"enl":"40.3879317","boy":"029.499366","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":63.02356,"mes":47423.5,"yon":106,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:18:14"}', '2025-08-25 15:18:14', '2025-08-25 15:18:15'),
	(2092, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.387365, 29.505555, _binary 0x0000000001010000004c546f0d6c813d40ba4e232d95314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:18:45","ind":0,"enl":"40.3873650","boy":"029.505555","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":64.6348,"mes":47423.9,"yon":105,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:18:45"}', '2025-08-25 15:18:45', '2025-08-25 15:18:48'),
	(2093, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.386275, 29.511691, _binary 0x00000000010100000054a86e2efe823d4096218e7571314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:19:16","ind":0,"enl":"40.3862750","boy":"029.511691","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":63.13468000000001,"mes":47424.5,"yon":101,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:19:16"}', '2025-08-25 15:19:16', '2025-08-25 15:19:19'),
	(2094, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.387163, 29.517905, _binary 0x000000000101000000546f0d6c95843d4010db27918e314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:19:47","ind":0,"enl":"40.3871633","boy":"029.517905","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":63.208760000000005,"mes":47425,"yon":69,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:19:47"}', '2025-08-25 15:19:47', '2025-08-25 15:19:49'),
	(2095, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.388142, 29.523828, _binary 0x000000000101000000a6ba809719863d405fdb91a0ae314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:20:19","ind":0,"enl":"40.3881417","boy":"029.523828","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":60.81968000000001,"mes":47425.6,"yon":111,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:20:19"}', '2025-08-25 15:20:19', '2025-08-25 15:20:21'),
	(2096, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.385450, 29.529178, _binary 0x00000000010100000040c39b3578873d40211ff46c56314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:20:48","ind":0,"enl":"40.3854500","boy":"029.529178","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":66.17196,"mes":47426,"yon":111,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:20:48"}', '2025-08-25 15:20:48', '2025-08-25 15:20:49'),
	(2097, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.385552, 29.535240, _binary 0x000000000101000000d482177d05893d40673513c259314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:21:18","ind":0,"enl":"40.3855517","boy":"029.535240","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":63.11616,"mes":47426.6,"yon":71,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:21:18"}', '2025-08-25 15:21:18', '2025-08-25 15:21:20'),
	(2098, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.384152, 29.541023, _binary 0x0000000001010000004162bb7b808a3d40f51906e22b314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:21:51","ind":0,"enl":"40.3841517","boy":"029.541023","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":59.02324,"mes":47427.2,"yon":113,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:21:51"}', '2025-08-25 15:21:51', '2025-08-25 15:21:54'),
	(2099, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.383698, 29.546968, _binary 0x00000000010100000062f54718068c3d40f103a1061d314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:22:31","ind":0,"enl":"40.3836983","boy":"029.546968","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":53.78208,"mes":47427.6,"yon":60,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:22:31"}', '2025-08-25 15:22:31', '2025-08-25 15:22:33'),
	(2100, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.384815, 29.553196, _binary 0x0000000001010000002c47c8409e8d3d405001309e41314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:23:04","ind":0,"enl":"40.3848150","boy":"029.553196","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":70.98716,"mes":47428.2,"yon":80,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:23:04"}', '2025-08-25 15:23:04', '2025-08-25 15:23:07'),
	(2101, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.385250, 29.559141, _binary 0x0000000001010000004dda54dd238f3d405a643bdf4f314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:23:32","ind":0,"enl":"40.3852500","boy":"029.559141","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":62.24572,"mes":47428.7,"yon":100,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:23:32"}', '2025-08-25 15:23:32', '2025-08-25 15:23:34'),
	(2102, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.382832, 29.564701, _binary 0x000000000101000000bc04a73e90903d40a0af0fa100314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:24:02","ind":0,"enl":"40.3828317","boy":"029.564701","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":70.376,"mes":47429.3,"yon":113,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:24:02"}', '2025-08-25 15:24:02', '2025-08-25 15:24:06'),
	(2103, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.381718, 29.570918, _binary 0x0000000001010000009eb29aae27923d4072642f25dc304440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:24:29","ind":0,"enl":"40.3817183","boy":"029.570918","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":73.0614,"mes":47429.7,"yon":89,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:24:29"}', '2025-08-25 15:24:29', '2025-08-25 15:24:32'),
	(2104, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.382863, 29.577201, _binary 0x000000000101000000ef37da71c3933d40582b24aa01314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:24:56","ind":0,"enl":"40.3828633","boy":"029.577201","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":71.09828,"mes":47430.3,"yon":73,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:24:56"}', '2025-08-25 15:24:56', '2025-08-25 15:24:57'),
	(2105, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.384647, 29.583035, _binary 0x000000000101000000616c21c841953d40d581621a3c314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:25:26","ind":0,"enl":"40.3846467","boy":"029.583035","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":54.208040000000004,"mes":47430.8,"yon":70,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:25:26"}', '2025-08-25 15:25:26', '2025-08-25 15:25:28'),
	(2106, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.383035, 29.588595, _binary 0x000000000101000000d1967329ae963d40971c774a07314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:25:57","ind":0,"enl":"40.3830350","boy":"029.588595","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":62.042,"mes":47431.3,"yon":122,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:25:57"}', '2025-08-25 15:25:57', '2025-08-25 15:25:59'),
	(2107, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.382808, 29.594760, _binary 0x0000000001010000000ef8fc3042983d409591c4dcff304440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:26:27","ind":0,"enl":"40.3828083","boy":"029.594760","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":67.82024,"mes":47431.9,"yon":69,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:26:27"}', '2025-08-25 15:26:27', '2025-08-25 15:26:28'),
	(2108, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.383743, 29.601068, _binary 0x00000000010100000011acaa97df993d4091c71d801e314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:26:57","ind":0,"enl":"40.3837433","boy":"029.601068","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":70.07968000000001,"mes":47432.4,"yon":94,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:26:57"}', '2025-08-25 15:26:57', '2025-08-25 15:26:59'),
	(2109, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.384208, 29.607085, _binary 0x00000000010100000065e42cec699b3d4006add1bc2d314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:27:27","ind":0,"enl":"40.3842083","boy":"029.607085","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":60.13444,"mes":47433,"yon":57,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:27:27"}', '2025-08-25 15:27:27', '2025-08-25 15:27:29'),
	(2110, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.385873, 29.612983, _binary 0x00000000010100000004013274ec9c3d4026f3d94b64314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:28:01","ind":0,"enl":"40.3858733","boy":"029.612983","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":57.282360000000004,"mes":47433.4,"yon":70,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:28:01"}', '2025-08-25 15:28:01', '2025-08-25 15:28:02'),
	(2111, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.388233, 29.618345, _binary 0x00000000010100000027a5a0db4b9e3d40ed5bf7a0b1314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:28:32","ind":0,"enl":"40.3882333","boy":"029.618345","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":66.9498,"mes":47434,"yon":67,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:28:32"}', '2025-08-25 15:28:32', '2025-08-25 15:28:34'),
	(2112, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.388350, 29.624083, _binary 0x00000000010100000054fd4ae7c39f3d4068b3ea73b5314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:29:03","ind":0,"enl":"40.3883500","boy":"029.624083","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":65.5608,"mes":47434.5,"yon":114,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:29:03"}', '2025-08-25 15:29:03', '2025-08-25 15:29:04'),
	(2113, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.386287, 29.629391, _binary 0x0000000001010000009065c1c41fa13d409cb0b3d771314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:29:32","ind":0,"enl":"40.3862867","boy":"029.629391","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":68.09804000000001,"mes":47435,"yon":92,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:29:32"}', '2025-08-25 15:29:32', '2025-08-25 15:29:34'),
	(2114, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.385172, 29.635513, _binary 0x000000000101000000cf2edffab0a23d40206c674e4d314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:30:01","ind":0,"enl":"40.3851717","boy":"029.635513","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":66.59792,"mes":47435.5,"yon":93,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:30:01"}', '2025-08-25 15:30:01', '2025-08-25 15:30:03'),
	(2115, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.386367, 29.641551, _binary 0x00000000010100000052b7b3af3ca43d40b961ca7674314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:30:29","ind":0,"enl":"40.3863667","boy":"029.641551","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":70.0056,"mes":47436.1,"yon":67,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:30:29"}', '2025-08-25 15:30:29', '2025-08-25 15:30:31'),
	(2116, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.388272, 29.647290, _binary 0x000000000101000000210725ccb4a53d402dbb16e3b2314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:30:58","ind":0,"enl":"40.3882717","boy":"029.647290","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":60.04184000000001,"mes":47436.5,"yon":67,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:30:58"}', '2025-08-25 15:30:58', '2025-08-25 15:30:59'),
	(2117, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.389913, 29.653123, _binary 0x000000000101000000f243a51133a73d4042e3d3ade8314440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:31:32","ind":0,"enl":"40.3899133","boy":"029.653123","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":59.33808,"mes":47437.1,"yon":85,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:31:32"}', '2025-08-25 15:31:32', '2025-08-25 15:31:33'),
	(2118, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.392823, 29.658168, _binary 0x0000000001010000001346b3b27da83d40ac4dad0848324440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:32:03","ind":0,"enl":"40.3928233","boy":"029.658168","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":79.41376000000001,"mes":47437.7,"yon":43,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:32:03"}', '2025-08-25 15:32:03', '2025-08-25 15:32:04'),
	(2119, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.395478, 29.662558, _binary 0x00000000010100000003b4ad669da93d408b636e089f324440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:32:32","ind":0,"enl":"40.3954783","boy":"029.662558","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":65.85712000000001,"mes":47438.2,"yon":93,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:32:32"}', '2025-08-25 15:32:32', '2025-08-25 15:32:34'),
	(2120, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.394473, 29.668678, _binary 0x000000000101000000008e3d7b2eab3d409652e1197e324440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:33:02","ind":0,"enl":"40.3944733","boy":"029.668678","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":55.48592000000001,"mes":47438.7,"yon":72,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:33:02"}', '2025-08-25 15:33:02', '2025-08-25 15:33:04'),
	(2121, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.392812, 29.674356, _binary 0x00000000010100000083dc4598a2ac3d403b7e5ea747324440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:33:32","ind":0,"enl":"40.3928117","boy":"029.674356","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":67.78320000000001,"mes":47439.2,"yon":116,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:33:32"}', '2025-08-25 15:33:32', '2025-08-25 15:33:33'),
	(2122, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.394565, 29.679785, _binary 0x000000000101000000b54fc76306ae3d40b8921d1b81324440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:34:00","ind":0,"enl":"40.3945650","boy":"029.679785","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":67.37576000000001,"mes":47439.8,"yon":44,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:34:00"}', '2025-08-25 15:34:00', '2025-08-25 15:34:02'),
	(2123, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.396688, 29.685223, _binary 0x0000000001010000008e7747c66aaf3d40599aa5aec6324440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:34:29","ind":0,"enl":"40.3966883","boy":"029.685223","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":71.02420000000001,"mes":47440.3,"yon":75,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:34:29"}', '2025-08-25 15:34:29', '2025-08-25 15:34:30'),
	(2124, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.397080, 29.691036, _binary 0x000000000101000000d15b3cbce7b03d40a6f27684d3324440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:34:57","ind":0,"enl":"40.3970800","boy":"029.691036","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":64.0792,"mes":47440.8,"yon":134,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:34:57"}', '2025-08-25 15:34:57', '2025-08-25 15:34:59'),
	(2125, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.398382, 29.694718, _binary 0x0000000001010000004af1f109d9b13d409669ea2bfe324440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:35:29","ind":0,"enl":"40.3983817","boy":"029.694718","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":81.56208000000001,"mes":47441.3,"yon":37,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:35:29"}', '2025-08-25 15:35:29', '2025-08-25 15:35:31'),
	(2126, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.402363, 29.698963, _binary 0x000000000101000000321d3a3defb23d40294effa380334440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:35:51","ind":0,"enl":"40.4023633","boy":"029.698963","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":94.98908,"mes":47441.9,"yon":39,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:35:51"}', '2025-08-25 15:35:51', '2025-08-25 15:35:53'),
	(2127, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.406228, 29.703173, _binary 0x000000000101000000226e4e2503b43d40d79af749ff334440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:36:13","ind":0,"enl":"40.4062283","boy":"029.703173","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":85.56240000000001,"mes":47442.3,"yon":39,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:36:13"}', '2025-08-25 15:36:13', '2025-08-25 15:36:14'),
	(2128, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.408363, 29.705385, _binary 0x000000000101000000c616821c94b43d407d31a53f45344440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:36:26","ind":0,"enl":"40.4083633","boy":"029.705385","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":76.98764,"mes":47442.7,"yon":38,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:36:26"}', '2025-08-25 15:36:26', '2025-08-25 15:36:28'),
	(2129, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.412073, 29.709333, _binary 0x0000000001010000003cf9f4d896b53d40048761d1be344440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:36:58","ind":0,"enl":"40.4120733","boy":"029.709333","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":59.18992000000001,"mes":47443.3,"yon":38,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:36:58"}', '2025-08-25 15:36:58', '2025-08-25 15:37:00'),
	(2130, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.415745, 29.713275, _binary 0x000000000101000000ed0dbe3099b63d40de3cd52137354440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:37:31","ind":0,"enl":"40.4157450","boy":"029.713275","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":58.375040000000006,"mes":47443.7,"yon":41,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:37:31"}', '2025-08-25 15:37:31', '2025-08-25 15:37:32'),
	(2131, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.418583, 29.717976, _binary 0x0000000001010000001a506f46cdb73d406d13382394354440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:38:03","ind":0,"enl":"40.4185833","boy":"029.717976","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":31.743280000000002,"mes":47444.2,"yon":84,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:38:03"}', '2025-08-25 15:38:03', '2025-08-25 15:38:04'),
	(2132, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.421058, 29.719016, _binary 0x000000000101000000fd4cbd6e11b83d40cc1a063de5354440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:39:04","ind":0,"enl":"40.4210583","boy":"029.719016","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47444.7,"yon":54,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 18:39:04"}', '2025-08-25 15:39:04', '2025-08-25 15:39:06'),
	(2133, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.421058, 29.719016, _binary 0x000000000101000000fd4cbd6e11b83d40cc1a063de5354440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:40:06","ind":0,"enl":"40.4210583","boy":"029.719016","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47444.7,"yon":333,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 18:40:06"}', '2025-08-25 15:40:06', '2025-08-25 15:40:08'),
	(2134, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.421183, 29.719126, _binary 0x0000000001010000000bb43ba418b83d40898f9955e9354440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:41:08","ind":0,"enl":"40.4211833","boy":"029.719126","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":18.74224,"mes":47444.7,"yon":33,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:41:08"}', '2025-08-25 15:41:08', '2025-08-25 15:41:09'),
	(2135, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.425687, 29.719471, _binary 0x000000000101000000a06b5f402fb83d40cc6bdbe67c364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:42:06","ind":0,"enl":"40.4256867","boy":"029.719471","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":36.13252000000001,"mes":47445.1,"yon":5,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:42:06"}', '2025-08-25 15:42:06', '2025-08-25 15:42:08'),
	(2136, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.428692, 29.719721, _binary 0x000000000101000000923eada23fb83d4088c89f5edf364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:43:08","ind":0,"enl":"40.4286917","boy":"029.719721","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":14.00112,"mes":47445.5,"yon":9,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:43:08"}', '2025-08-25 15:43:08', '2025-08-25 15:43:09'),
	(2137, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.429530, 29.718718, _binary 0x000000000101000000e90b21e7fdb73d405053cbd6fa364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:44:10","ind":0,"enl":"40.4295300","boy":"029.718718","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":13.83444,"mes":47445.7,"yon":274,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:44:10"}', '2025-08-25 15:44:10', '2025-08-25 15:44:11'),
	(2138, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.429723, 29.715436, _binary 0x0000000001010000008d614ed026b73d4023ea4f2c01374440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:45:11","ind":0,"enl":"40.4297233","boy":"029.715436","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":20.149760000000004,"mes":47445.9,"yon":271,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:45:11"}', '2025-08-25 15:45:11', '2025-08-25 15:45:13'),
	(2139, '31.143.24.218:57421', 'aebcc2b375a24f3f0', 40.429725, 29.713003, _binary 0x0000000001010000002cf3565d87b63d4005a3923a01374440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:46:13","ind":0,"enl":"40.4297250","boy":"029.713003","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":18.853360000000002,"mes":47446.2,"yon":190,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 18:46:13"}', '2025-08-25 15:46:13', '2025-08-25 15:46:21'),
	(2140, '176.238.4.21:7995', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"18:53:49","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":336,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 18:53:49"}', '2025-08-25 15:53:49', '2025-08-25 15:53:51'),
	(2141, '188.57.69.151:11495', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"19:04:09","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":301,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 19:04:09"}', '2025-08-25 16:04:09', '2025-08-25 16:04:11'),
	(2142, '188.57.69.151:11495', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"19:05:42","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":179,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 19:05:42"}', '2025-08-25 16:05:42', '2025-08-25 16:05:43'),
	(2143, '188.57.69.151:11495', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"19:21:08","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":223,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 19:21:08"}', '2025-08-25 16:21:08', '2025-08-25 16:21:11'),
	(2144, '188.57.65.244:42261', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"19:29:05","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":321,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 19:29:05"}', '2025-08-25 16:29:05', '2025-08-25 16:29:07'),
	(2145, '188.57.65.244:42261', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"19:29:35","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":296,"A":"4","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 19:29:35"}', '2025-08-25 16:29:35', '2025-08-25 16:29:38'),
	(2146, '188.57.65.244:42261', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"19:45:02","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":357,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 19:45:02"}', '2025-08-25 16:45:02', '2025-08-25 16:45:03'),
	(2147, '176.238.23.156:30732', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"19:49:42","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":43,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 19:49:42"}', '2025-08-25 16:49:42', '2025-08-25 16:49:44'),
	(2148, '176.238.23.156:30732', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"20:00:28","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":205,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:00:28"}', '2025-08-25 17:00:28', '2025-08-25 17:00:30'),
	(2149, '176.227.64.154:38338', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"20:13:53","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":189,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:13:53"}', '2025-08-25 17:13:53', '2025-08-25 17:13:55'),
	(2150, '176.227.64.154:38338', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"20:15:54","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":326,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:15:54"}', '2025-08-25 17:15:54', '2025-08-25 17:16:03'),
	(2151, '176.227.64.154:38338', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"20:31:21","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":180,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:31:21"}', '2025-08-25 17:31:21', '2025-08-25 17:31:23'),
	(2152, '176.238.15.246:5054', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"20:36:25","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":172,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:36:25"}', '2025-08-25 17:36:25', '2025-08-25 17:36:28'),
	(2153, '176.227.86.214:11997', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"20:44:34","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":340,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:44:34"}', '2025-08-25 17:44:34', '2025-08-25 17:44:35'),
	(2154, '176.227.86.214:11997', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"20:46:48","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":137,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:46:48"}', '2025-08-25 17:46:48', '2025-08-25 17:46:51'),
	(2155, '188.57.75.103:34290', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"20:54:38","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":268,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:54:38"}', '2025-08-25 17:54:38', '2025-08-25 17:54:40'),
	(2156, '178.245.74.133:39593', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"21:00:43","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":13,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:00:43"}', '2025-08-25 18:00:43', '2025-08-25 18:00:59'),
	(2157, '178.245.74.133:39593', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"21:02:15","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":216,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:02:15"}', '2025-08-25 18:02:15', '2025-08-25 18:02:35'),
	(2158, '188.57.85.201:53771', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"21:03:57","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":39,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:03:57"}', '2025-08-25 18:03:57', '2025-08-25 18:03:58'),
	(2159, '188.57.89.240:30656', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"21:14:22","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":155,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:14:22"}', '2025-08-25 18:14:22', '2025-08-25 18:14:24'),
	(2160, '31.143.161.121:14455', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"0","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"21:23:59","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":153,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:23:59"}', '2025-08-25 18:23:59', '2025-08-25 18:24:09'),
	(2161, '176.227.85.185:41737', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"21:33:08","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":325,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:33:08"}', '2025-08-25 18:33:08', '2025-08-25 18:37:44'),
	(2162, '176.227.85.185:41737', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"21:37:41","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":334,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:37:41"}', '2025-08-25 18:37:41', '2025-08-25 18:37:43'),
	(2163, '176.238.9.114:30027', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"21:44:22","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":121,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:44:22"}', '2025-08-25 18:44:22', '2025-08-25 18:44:23'),
	(2164, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"21:48:34","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":157,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:48:34"}', '2025-08-25 18:48:34', '2025-08-25 19:46:30'),
	(2165, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:04:00","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":97,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:04:00"}', '2025-08-25 19:04:00', '2025-08-25 19:46:31'),
	(2166, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:19:26","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":324,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:19:26"}', '2025-08-25 19:19:26', '2025-08-25 19:46:32'),
	(2167, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:34:51","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":285,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:34:51"}', '2025-08-25 19:34:51', '2025-08-25 19:46:33'),
	(2168, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:44:41","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":0,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 22:44:41"}', '2025-08-25 19:44:41', '2025-08-25 19:46:33'),
	(2169, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.427653, 29.712288, _binary 0x0000000001010000005055a18158b63d4064c3e457bd364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:45:42","ind":0,"enl":"40.4276533","boy":"029.712288","drm":[1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0],"hiz":21.50172,"mes":47446.5,"yon":57,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:45:42"}', '2025-08-25 19:45:42', '2025-08-25 19:46:34'),
	(2170, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 0.000000, 0.000000, _binary 0x00000000010100000000000000000000000000000000000000, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:45:47","ind":8,"enl":"00.0000000","boy":"000.000000","drm":[1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":0,"A":"77","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 22:45:47"}', '2025-08-25 19:45:47', '2025-08-25 19:46:35'),
	(2171, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.430927, 29.713276, _binary 0x0000000001010000008e05854199b63d4092bc299b28374440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:46:28","ind":0,"enl":"40.4309267","boy":"029.713276","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":40.00320000000001,"mes":47446.9,"yon":9,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:46:28"}', '2025-08-25 19:46:28', '2025-08-25 19:46:29'),
	(2172, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.432730, 29.713965, _binary 0x000000000101000000187d0569c6b63d40c1ff56b263374440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:46:48","ind":0,"enl":"40.4327300","boy":"029.713965","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":28.74304,"mes":47447.1,"yon":29,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:46:48"}', '2025-08-25 19:46:48', '2025-08-25 19:46:50'),
	(2173, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.436517, 29.716915, _binary 0x0000000001010000000803cfbd87b73d4034547bc7df374440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:47:42","ind":0,"enl":"40.4365167","boy":"029.716915","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":39.818000000000005,"mes":47447.5,"yon":2,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:47:42"}', '2025-08-25 19:47:42', '2025-08-25 19:47:43'),
	(2174, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.441047, 29.716646, _binary 0x00000000010100000029cfbc1c76b73d401e41e03774384440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:48:39","ind":0,"enl":"40.4410467","boy":"029.716646","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":25.853920000000002,"mes":47448.1,"yon":356,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:48:39"}', '2025-08-25 19:48:39', '2025-08-25 19:48:41'),
	(2175, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.444953, 29.715561, _binary 0x000000000101000000064b75012fb73d40a7dfcf3af4384440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:49:39","ind":0,"enl":"40.4449533","boy":"029.715561","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":51.96712,"mes":47448.6,"yon":334,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:49:39"}', '2025-08-25 19:49:39', '2025-08-25 19:49:41'),
	(2176, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.449000, 29.713293, _binary 0x0000000001010000003a77bb5e9ab63d40b6f3fdd478394440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:50:23","ind":0,"enl":"40.4490000","boy":"029.713293","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":18.779280000000004,"mes":47449.2,"yon":28,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:50:23"}', '2025-08-25 19:50:23', '2025-08-25 19:50:25'),
	(2177, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.451622, 29.708328, _binary 0x00000000010100000052d7dafb54b53d40fbd467bdce394440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:51:10","ind":0,"enl":"40.4516217","boy":"029.708328","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":58.50468,"mes":47449.6,"yon":302,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:51:10"}', '2025-08-25 19:51:10', '2025-08-25 19:51:11'),
	(2178, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.454233, 29.703275, _binary 0x0000000001010000002b1895d409b43d4088201851243a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:51:36","ind":0,"enl":"40.4542333","boy":"029.703275","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":73.11695999999999,"mes":47450.2,"yon":304,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:51:36"}', '2025-08-25 19:51:36', '2025-08-25 19:51:38'),
	(2179, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.456975, 29.698071, _binary 0x0000000001010000003849f3c7b4b23d40780b24287e3a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:52:03","ind":0,"enl":"40.4569750","boy":"029.698071","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":68.83884,"mes":47450.7,"yon":304,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:52:03"}', '2025-08-25 19:52:03', '2025-08-25 19:52:05'),
	(2180, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.459800, 29.692918, _binary 0x0000000001010000004acff41263b13d40b459f5b9da3a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:52:32","ind":0,"enl":"40.4598000","boy":"029.692918","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":68.59808,"mes":47451.2,"yon":305,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:52:32"}', '2025-08-25 19:52:32', '2025-08-25 19:52:34'),
	(2181, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.462680, 29.687646, _binary 0x000000000101000000a839799109b03d40b3412619393b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:53:00","ind":0,"enl":"40.4626800","boy":"029.687646","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":75.78384000000001,"mes":47451.7,"yon":305,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:53:00"}', '2025-08-25 19:53:00', '2025-08-25 19:53:02'),
	(2182, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.465563, 29.682356, _binary 0x000000000101000000b83a00e2aeae3d40e2db0594973b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:53:26","ind":0,"enl":"40.4655633","boy":"029.682356","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":69.61668000000002,"mes":47452.3,"yon":305,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:53:26"}', '2025-08-25 19:53:26', '2025-08-25 19:53:27'),
	(2183, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.468285, 29.677285, _binary 0x0000000001010000004512bd8c62ad3d408b1a4cc3f03b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:53:52","ind":0,"enl":"40.4682850","boy":"029.677285","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":76.65428,"mes":47452.8,"yon":301,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:53:52"}', '2025-08-25 19:53:52', '2025-08-25 19:53:54'),
	(2184, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.469028, 29.671085, _binary 0x0000000001010000000fd6ff39ccab3d4001b38c1e093c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:54:18","ind":0,"enl":"40.4690283","boy":"029.671085","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":75.52456000000001,"mes":47453.3,"yon":279,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:54:18"}', '2025-08-25 19:54:18', '2025-08-25 19:54:19'),
	(2185, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.468013, 29.665116, _binary 0x000000000101000000dd0bcc0a45aa3d40e9cb1cdce73b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:54:50","ind":0,"enl":"40.4680133","boy":"029.665116","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":57.0416,"mes":47453.9,"yon":286,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:54:50"}', '2025-08-25 19:54:50', '2025-08-25 19:54:52'),
	(2186, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.471225, 29.661288, _binary 0x000000000101000000bc3c9d2b4aa93d405f07ce19513c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:55:34","ind":0,"enl":"40.4712250","boy":"029.661288","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":39.11424,"mes":47454.4,"yon":3,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:55:34"}', '2025-08-25 19:55:34', '2025-08-25 19:55:36'),
	(2187, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.475812, 29.662131, _binary 0x000000000101000000f3aace6a81a93d40ef46d565e73c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:56:22","ind":0,"enl":"40.4758117","boy":"029.662131","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":40.336560000000006,"mes":47454.8,"yon":6,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:56:22"}', '2025-08-25 19:56:22', '2025-08-25 19:56:24'),
	(2188, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.480685, 29.662055, _binary 0x0000000001010000003d27bd6f7ca93d40c1560916873d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:57:05","ind":0,"enl":"40.4806850","boy":"029.662055","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":54.559920000000005,"mes":47455.4,"yon":334,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:57:05"}', '2025-08-25 19:57:05', '2025-08-25 19:57:07'),
	(2189, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.484558, 29.658400, _binary 0x000000000101000000b8af03e78ca83d40b0c0a101063e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:57:38","ind":0,"enl":"40.4845583","boy":"029.658400","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":58.28244,"mes":47456,"yon":321,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:57:38"}', '2025-08-25 19:57:38', '2025-08-25 19:57:39'),
	(2190, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.487475, 29.653725, _binary 0x000000000101000000de9387855aa73d400e4faf94653e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:58:08","ind":0,"enl":"40.4874750","boy":"029.653725","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":73.20956000000001,"mes":47456.5,"yon":299,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:58:08"}', '2025-08-25 19:58:08', '2025-08-25 19:58:10'),
	(2191, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.487820, 29.652806, _binary 0x000000000101000000f1a1444b1ea73d40d82ac1e2703e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:58:12","ind":0,"enl":"40.4878200","boy":"029.652806","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":82.87700000000001,"mes":47456.6,"yon":293,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:58:12"}', '2025-08-25 19:58:12', '2025-08-25 19:58:14'),
	(2192, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.488985, 29.648163, _binary 0x0000000001010000002d7aa702eea53d40069e7b0f973e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:58:29","ind":0,"enl":"40.4889850","boy":"029.648163","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":74.48744,"mes":47456.9,"yon":274,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:58:29"}', '2025-08-25 19:58:29', '2025-08-25 19:58:30'),
	(2193, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.489885, 29.645826, _binary 0x00000000010100000010e84cda54a53d4086e63a8db43e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:58:40","ind":0,"enl":"40.4898850","boy":"029.645826","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":81.00648000000001,"mes":47457.2,"yon":301,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:58:40"}', '2025-08-25 19:58:40', '2025-08-25 19:58:42'),
	(2194, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.491898, 29.639895, _binary 0x000000000101000000b9dfa128d0a33d40a0ba0386f63e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:03","ind":0,"enl":"40.4918983","boy":"029.639895","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":82.1362,"mes":47457.7,"yon":293,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:03"}', '2025-08-25 19:59:03', '2025-08-25 19:59:05'),
	(2195, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.492048, 29.639405, _binary 0x0000000001010000001de6cb0bb0a33d40b5464e70fb3e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:05","ind":0,"enl":"40.4920483","boy":"029.639405","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.59895999999999,"mes":47457.7,"yon":289,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:05"}', '2025-08-25 19:59:05', '2025-08-25 19:59:08'),
	(2196, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.492157, 29.638900, _binary 0x000000000101000000166a4df38ea33d40ef80a1fdfe3e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:07","ind":0,"enl":"40.4921567","boy":"029.638900","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.562,"mes":47457.8,"yon":283,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:07"}', '2025-08-25 19:59:07', '2025-08-25 19:59:09'),
	(2197, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.492198, 29.638638, _binary 0x0000000001010000009cfbabc77da33d40cad2985a003f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:08","ind":0,"enl":"40.4921983","boy":"029.638638","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.33968000000002,"mes":47457.8,"yon":280,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:08"}', '2025-08-25 19:59:08', '2025-08-25 19:59:10'),
	(2198, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.492235, 29.638370, _binary 0x0000000001010000005dbf60376ca33d402979758e013f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:09","ind":0,"enl":"40.4922350","boy":"029.638370","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":83.04368000000001,"mes":47457.8,"yon":280,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:09"}', '2025-08-25 19:59:09', '2025-08-25 19:59:11'),
	(2199, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.492505, 29.635675, _binary 0x00000000010100000082e2c798bba23d40e90e62670a3f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:19","ind":0,"enl":"40.4925050","boy":"029.635675","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.8212,"mes":47458.1,"yon":272,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:19"}', '2025-08-25 19:59:19', '2025-08-25 19:59:21'),
	(2200, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.492510, 29.635416, _binary 0x000000000101000000ea5a7b9faaa23d40fb7953910a3f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:20","ind":0,"enl":"40.4925100","boy":"029.635416","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.39532,"mes":47458.1,"yon":270,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:20"}', '2025-08-25 19:59:20', '2025-08-25 19:59:22'),
	(2201, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.492467, 29.633803, _binary 0x000000000101000000501bd5e940a23d403d6f1926093f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:26","ind":0,"enl":"40.4924667","boy":"029.633803","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.74712000000001,"mes":47458.2,"yon":270,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:26"}', '2025-08-25 19:59:26', '2025-08-25 19:59:27'),
	(2202, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.492490, 29.633271, _binary 0x00000000010100000056815a0c1ea23d40b3cd8de9093f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:28","ind":0,"enl":"40.4924900","boy":"029.633271","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.15456,"mes":47458.3,"yon":276,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:28"}', '2025-08-25 19:59:28', '2025-08-25 19:59:30'),
	(2203, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.492563, 29.632753, _binary 0x0000000001010000002672c119fca13d40dc5a70500c3f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:30","ind":0,"enl":"40.4925633","boy":"029.632753","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.00640000000001,"mes":47458.3,"yon":284,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:30"}', '2025-08-25 19:59:30', '2025-08-25 19:59:32'),
	(2204, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.492680, 29.632255, _binary 0x00000000010100000084bbb376dba13d4057b26323103f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:32","ind":0,"enl":"40.4926800","boy":"029.632255","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.11752,"mes":47458.4,"yon":287,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:32"}', '2025-08-25 19:59:32', '2025-08-25 19:59:33'),
	(2205, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.492742, 29.632016, _binary 0x0000000001010000007a8cf2cccba13d400f70f728123f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:33","ind":0,"enl":"40.4927417","boy":"029.632016","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":76.04312,"mes":47458.4,"yon":287,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:33"}', '2025-08-25 19:59:33', '2025-08-25 19:59:34'),
	(2206, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.493565, 29.629160, _binary 0x0000000001010000008cf337a110a13d40a1b94e232d3f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:45","ind":0,"enl":"40.4935650","boy":"029.629160","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.46940000000001,"mes":47458.7,"yon":290,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:45"}', '2025-08-25 19:59:45', '2025-08-25 19:59:47'),
	(2207, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.494185, 29.626313, _binary 0x000000000101000000450f7c0c56a03d403e963e74413f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:56","ind":0,"enl":"40.4941850","boy":"029.626313","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.9138,"mes":47458.9,"yon":281,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:56"}', '2025-08-25 19:59:56', '2025-08-25 19:59:57'),
	(2208, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.494250, 29.625798, _binary 0x000000000101000000f7e6374c34a03d4025068195433f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:58","ind":0,"enl":"40.4942500","boy":"029.625798","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.21012,"mes":47458.9,"yon":277,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:58"}', '2025-08-25 19:59:58', '2025-08-25 19:59:59'),
	(2209, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.494272, 29.625535, _binary 0x000000000101000000dc80cf0f23a03d404e6b894b443f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:59","ind":0,"enl":"40.4942717","boy":"029.625535","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.59895999999999,"mes":47459,"yon":274,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:59"}', '2025-08-25 19:59:59', '2025-08-25 20:00:00'),
	(2210, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.494280, 29.624990, _binary 0x000000000101000000b9533a58ff9f3d4090882991443f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:00:01","ind":0,"enl":"40.4942800","boy":"029.624990","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":85.08088,"mes":47459,"yon":270,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:00:01"}', '2025-08-25 20:00:01', '2025-08-25 20:00:03'),
	(2211, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.493822, 29.618338, _binary 0x000000000101000000c2df2f664b9e3d400ec7a98c353f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:00:24","ind":0,"enl":"40.4938217","boy":"029.618338","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":89.34048000000001,"mes":47459.6,"yon":257,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:00:24"}', '2025-08-25 20:00:24', '2025-08-25 20:00:25'),
	(2212, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.493528, 29.614905, _binary 0x0000000001010000009a25016a6a9d3d40431372ef2b3f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:00:36","ind":0,"enl":"40.4935283","boy":"029.614905","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":77.37656000000001,"mes":47459.8,"yon":266,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:00:36"}', '2025-08-25 20:00:36', '2025-08-25 20:00:38'),
	(2213, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.492032, 29.608801, _binary 0x000000000101000000a8c5e061da9b3d40320c0ee5fa3e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:01:04","ind":0,"enl":"40.4920317","boy":"029.608801","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":79.32116,"mes":47460.4,"yon":238,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:01:04"}', '2025-08-25 20:01:04', '2025-08-25 20:01:05'),
	(2214, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.491752, 29.608151, _binary 0x0000000001010000009a07b0c8af9b3d404fa03eb8f13e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:01:07","ind":0,"enl":"40.4917517","boy":"029.608151","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.98796,"mes":47460.4,"yon":241,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:01:07"}', '2025-08-25 20:01:07', '2025-08-25 20:01:09'),
	(2215, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.490910, 29.606021, _binary 0x00000000010100000070b03731249b3d40c2a38d23d63e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:01:16","ind":0,"enl":"40.4909100","boy":"029.606021","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.74712000000001,"mes":47460.6,"yon":243,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:01:16"}', '2025-08-25 20:01:16', '2025-08-25 20:01:18'),
	(2216, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.489368, 29.601471, _binary 0x0000000001010000000f7ee200fa993d407d19d69ea33e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:01:36","ind":0,"enl":"40.4893683","boy":"029.601471","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.17308,"mes":47461.1,"yon":247,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:01:36"}', '2025-08-25 20:01:36', '2025-08-25 20:01:37'),
	(2217, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.488088, 29.597660, _binary 0x0000000001010000009b20ea3e00993d40b6076bad793e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:01:51","ind":0,"enl":"40.4880883","boy":"029.597660","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.22856,"mes":47461.4,"yon":249,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:01:51"}', '2025-08-25 20:01:51', '2025-08-25 20:01:53'),
	(2218, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.486882, 29.593200, _binary 0x000000000101000000b9fc87f4db973d40ac42b923523e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:02:11","ind":0,"enl":"40.4868817","boy":"029.593200","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.69164,"mes":47461.8,"yon":277,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:02:11"}', '2025-08-25 20:02:11', '2025-08-25 20:02:14'),
	(2219, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.487012, 29.592436, _binary 0x0000000001010000001af9bce2a9973d407a223e66563e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:02:14","ind":0,"enl":"40.4870117","boy":"029.592436","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":76.89504000000001,"mes":47461.9,"yon":283,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:02:14"}', '2025-08-25 20:02:14', '2025-08-25 20:02:15'),
	(2220, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.489123, 29.586818, _binary 0x00000000010100000042b456b439963d40169ba0979b3e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:02:41","ind":0,"enl":"40.4891233","boy":"029.586818","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":72.00576000000001,"mes":47462.4,"yon":318,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:02:41"}', '2025-08-25 20:02:41', '2025-08-25 20:02:42'),
	(2221, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.490128, 29.580946, _binary 0x000000000101000000f5bd86e0b8943d400bac2d86bc3e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:03:09","ind":0,"enl":"40.4901283","boy":"029.580946","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":58.801,"mes":47462.9,"yon":255,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:03:09"}', '2025-08-25 20:03:09', '2025-08-25 20:03:11'),
	(2222, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.488415, 29.575156, _binary 0x0000000001010000002219726c3d933d401cf0f961843e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:03:38","ind":0,"enl":"40.4884150","boy":"029.575156","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":64.89408,"mes":47463.4,"yon":237,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:03:38"}', '2025-08-25 20:03:38', '2025-08-25 20:03:40'),
	(2223, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.485633, 29.569960, _binary 0x000000000101000000350708e6e8913d409eac623b293e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:04:08","ind":0,"enl":"40.4856333","boy":"029.569960","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":59.68996,"mes":47464,"yon":231,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:04:08"}', '2025-08-25 20:04:08', '2025-08-25 20:04:10'),
	(2224, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.483887, 29.564525, _binary 0x0000000001010000003fc6dcb584903d4014bcd7ffef3d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:04:43","ind":0,"enl":"40.4838867","boy":"029.564525","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":46.61484000000001,"mes":47464.4,"yon":292,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:04:43"}', '2025-08-25 20:04:43', '2025-08-25 20:04:44'),
	(2225, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.482845, 29.559078, _binary 0x000000000101000000c0e95dbc1f8f3d40c0046eddcd3d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:05:23","ind":0,"enl":"40.4828450","boy":"029.559078","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":51.33744,"mes":47465,"yon":239,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:05:23"}', '2025-08-25 20:05:23', '2025-08-25 20:05:25'),
	(2226, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.483513, 29.553501, _binary 0x000000000101000000a54dd53db28d3d402c5789c3e33d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:06:02","ind":0,"enl":"40.4835133","boy":"029.553501","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":46.818560000000005,"mes":47465.5,"yon":296,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:06:02"}', '2025-08-25 20:06:02', '2025-08-25 20:06:16'),
	(2227, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.484252, 29.547440, _binary 0x000000000101000000b2852007258c3d402644aff5fb3d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:06:39","ind":0,"enl":"40.4842517","boy":"029.547440","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":62.37536,"mes":47466.1,"yon":267,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:06:39"}', '2025-08-25 20:06:39', '2025-08-25 20:06:41'),
	(2228, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.484005, 29.540873, _binary 0x000000000101000000174a26a7768a3d40dd0c37e0f33d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:07:06","ind":0,"enl":"40.4840050","boy":"029.540873","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":76.63576,"mes":47466.6,"yon":266,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:07:06"}', '2025-08-25 20:07:06', '2025-08-25 20:07:08'),
	(2229, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.483848, 29.534391, _binary 0x000000000101000000d8463cd9cd883d40d35cb8bdee3d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:07:32","ind":0,"enl":"40.4838483","boy":"029.534391","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":72.46876,"mes":47467.1,"yon":277,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:07:32"}', '2025-08-25 20:07:32', '2025-08-25 20:07:33'),
	(2230, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.484212, 29.527898, _binary 0x000000000101000000b29fc55224873d4098eb23a6fa3d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:07:59","ind":0,"enl":"40.4842117","boy":"029.527898","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":78.74704000000001,"mes":47467.7,"yon":268,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:07:59"}', '2025-08-25 20:07:59', '2025-08-25 20:08:01'),
	(2231, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.484182, 29.526898, _binary 0x000000000101000000eb538ec9e2863d402d697baaf93d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:08:03","ind":0,"enl":"40.4841817","boy":"029.526898","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.30272000000001,"mes":47467.8,"yon":268,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:08:03"}', '2025-08-25 20:08:03', '2025-08-25 20:08:05'),
	(2232, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.484183, 29.526653, _binary 0x0000000001010000001d5723bbd2863d407a62e7b7f93d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:08:04","ind":0,"enl":"40.4841833","boy":"029.526653","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.63600000000001,"mes":47467.8,"yon":268,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:08:04"}', '2025-08-25 20:08:04', '2025-08-25 20:08:05'),
	(2233, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.484282, 29.520273, _binary 0x000000000101000000e7fd7f9c30853d4090c657f1fc3d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:08:31","ind":0,"enl":"40.4842817","boy":"029.520273","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":60.50484000000001,"mes":47468.3,"yon":271,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:08:31"}', '2025-08-25 20:08:31', '2025-08-25 20:08:33'),
	(2234, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.484280, 29.514073, _binary 0x000000000101000000b1c1c2499a833d40ae0d15e3fc3d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:08:59","ind":0,"enl":"40.4842800","boy":"029.514073","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":68.19064,"mes":47468.8,"yon":269,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:08:59"}', '2025-08-25 20:08:59', '2025-08-25 20:09:01'),
	(2235, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.485443, 29.507841, _binary 0x000000000101000000649126de01823d40fac78c01233e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:09:26","ind":0,"enl":"40.4854433","boy":"029.507841","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":77.39508000000001,"mes":47469.3,"yon":294,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:09:26"}', '2025-08-25 20:09:26', '2025-08-25 20:09:31'),
	(2236, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.487457, 29.501981, _binary 0x000000000101000000a036aad381803d40a95b2cfb643e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:09:52","ind":0,"enl":"40.4874567","boy":"029.501981","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":75.3764,"mes":47469.9,"yon":294,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:09:52"}', '2025-08-25 20:09:52', '2025-08-25 20:09:55'),
	(2237, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.489460, 29.496068, _binary 0x0000000001010000009697fc4ffe7e3d409f5912a0a63e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:10:18","ind":0,"enl":"40.4894600","boy":"029.496068","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":75.17268000000001,"mes":47470.5,"yon":293,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:10:18"}', '2025-08-25 20:10:18', '2025-08-25 20:10:20'),
	(2238, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.491503, 29.490138, _binary 0x000000000101000000e08618af797d3d4023b08394e93e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:10:44","ind":0,"enl":"40.4915033","boy":"029.490138","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":77.19136,"mes":47470.9,"yon":294,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:10:44"}', '2025-08-25 20:10:44', '2025-08-25 20:10:45'),
	(2239, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.493465, 29.484376, _binary 0x000000000101000000a1f7c610007c3d403e5c72dc293f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:11:09","ind":0,"enl":"40.4934650","boy":"029.484376","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":78.11736,"mes":47471.5,"yon":295,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:11:09"}', '2025-08-25 20:11:09', '2025-08-25 20:11:11'),
	(2240, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.495493, 29.478471, _binary 0x0000000001010000009c1551137d7a3d408d710f536c3f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:11:35","ind":0,"enl":"40.4954933","boy":"029.478471","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":72.02428,"mes":47472,"yon":293,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:11:35"}', '2025-08-25 20:11:35', '2025-08-25 20:11:37'),
	(2241, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.497558, 29.472495, _binary 0x0000000001010000000586ac6ef5783d403b2d89fdaf3f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:12:03","ind":0,"enl":"40.4975583","boy":"029.472495","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":69.45,"mes":47472.5,"yon":296,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:12:03"}', '2025-08-25 20:12:03', '2025-08-25 20:12:04'),
	(2242, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.499658, 29.466786, _binary 0x0000000001010000000c3b8c497f773d4065d69ccdf43f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:12:31","ind":0,"enl":"40.4996583","boy":"029.466786","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":72.57988,"mes":47473.1,"yon":294,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:12:31"}', '2025-08-25 20:12:31', '2025-08-25 20:12:32'),
	(2243, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.501528, 29.461151, _binary 0x0000000001010000008884effd0d763d405d424f1432404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:12:58","ind":0,"enl":"40.5015283","boy":"029.461151","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":70.50564,"mes":47473.6,"yon":293,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:12:58"}', '2025-08-25 20:12:58', '2025-08-25 20:13:00'),
	(2244, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.503515, 29.455058, _binary 0x0000000001010000007ec85bae7e743d40d105f52d73404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:13:25","ind":0,"enl":"40.5035150","boy":"029.455058","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":75.61716,"mes":47474.2,"yon":293,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:13:25"}', '2025-08-25 20:13:25', '2025-08-25 20:13:27'),
	(2245, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.505492, 29.449178, _binary 0x0000000001010000002b155454fd723d4021f3b7f3b3404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:13:51","ind":0,"enl":"40.5054917","boy":"029.449178","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":75.11712000000001,"mes":47474.6,"yon":294,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:13:51"}', '2025-08-25 20:13:51', '2025-08-25 20:13:52'),
	(2246, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.507305, 29.443271, _binary 0x000000000101000000e54350357a713d40740cc85eef404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:14:17","ind":0,"enl":"40.5073050","boy":"029.443271","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":72.45024,"mes":47475.2,"yon":284,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:14:17"}', '2025-08-25 20:14:17', '2025-08-25 20:14:18'),
	(2247, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.507553, 29.437136, _binary 0x0000000001010000007de71725e86f3d400a3dac81f7404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:14:44","ind":0,"enl":"40.5075533","boy":"029.437136","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":70.43156,"mes":47475.7,"yon":266,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:14:44"}', '2025-08-25 20:14:44', '2025-08-25 20:14:46'),
	(2248, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.507122, 29.430815, _binary 0x00000000010100000051a04fe4496e3d40c44b265de9404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:15:11","ind":0,"enl":"40.5071217","boy":"029.430815","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":74.3578,"mes":47476.3,"yon":265,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:15:11"}', '2025-08-25 20:15:11', '2025-08-25 20:15:13'),
	(2249, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.506663, 29.424190, _binary 0x0000000001010000004d4a41b7976c3d40aecacf57da404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:15:38","ind":0,"enl":"40.5066633","boy":"029.424190","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":76.82096,"mes":47476.7,"yon":264,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:15:38"}', '2025-08-25 20:15:38', '2025-08-25 20:15:40'),
	(2250, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.506482, 29.421671, _binary 0x000000000101000000efab72a1f26b3d40e1c27064d4404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:15:48","ind":0,"enl":"40.5064817","boy":"029.421671","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.562,"mes":47476.9,"yon":264,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:15:48"}', '2025-08-25 20:15:48', '2025-08-25 20:15:50'),
	(2251, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.506372, 29.419810, _binary 0x000000000101000000a4880cab786b3d405a8fb1c9d0404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:15:55","ind":0,"enl":"40.5063717","boy":"029.419810","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":78.63592,"mes":47477.2,"yon":265,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:15:55"}', '2025-08-25 20:15:55', '2025-08-25 20:15:57'),
	(2252, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.505958, 29.413211, _binary 0x000000000101000000f3583332c8693d40e4d1d73dc3404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:16:21","ind":0,"enl":"40.5059583","boy":"029.413211","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":78.71000000000001,"mes":47477.6,"yon":265,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:16:21"}', '2025-08-25 20:16:21', '2025-08-25 20:16:24'),
	(2253, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.505945, 29.412931, _binary 0x0000000001010000002c8194d8b5693d40904946cec2404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:16:22","ind":0,"enl":"40.5059450","boy":"029.412931","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.89536,"mes":47477.8,"yon":264,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:16:22"}', '2025-08-25 20:16:22', '2025-08-25 20:16:25'),
	(2254, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.505705, 29.409473, _binary 0x0000000001010000005298f738d3683d403b3602f1ba404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:16:35","ind":0,"enl":"40.5057050","boy":"029.409473","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.58044,"mes":47478,"yon":264,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:16:35"}', '2025-08-25 20:16:35', '2025-08-25 20:16:36'),
	(2255, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.505507, 29.406638, _binary 0x000000000101000000944f8f6d19683d4056348c71b4404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:16:46","ind":0,"enl":"40.5055067","boy":"029.406638","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.33976000000001,"mes":47478.2,"yon":265,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:16:46"}', '2025-08-25 20:16:46', '2025-08-25 20:16:47'),
	(2256, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.505485, 29.406385, _binary 0x000000000101000000c095ecd808683d402dcf83bbb3404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:16:47","ind":0,"enl":"40.5054850","boy":"029.406385","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.19152,"mes":47478.2,"yon":264,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:16:47"}', '2025-08-25 20:16:47', '2025-08-25 20:16:48'),
	(2257, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.505043, 29.399861, _binary 0x00000000010100000024f25d4a5d663d402e484442a5404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:17:13","ind":0,"enl":"40.5050433","boy":"029.399861","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":73.8948,"mes":47478.8,"yon":265,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:17:13"}', '2025-08-25 20:17:13', '2025-08-25 20:17:14'),
	(2258, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.504667, 29.393753, _binary 0x000000000101000000afb321ffcc643d40acf01deb98404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:17:38","ind":0,"enl":"40.5046667","boy":"029.393753","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":74.85784000000001,"mes":47479.3,"yon":265,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:17:38"}', '2025-08-25 20:17:38', '2025-08-25 20:17:40'),
	(2259, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.504157, 29.387280, _binary 0x000000000101000000176536c824633d409747ed3488404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:18:04","ind":0,"enl":"40.5041567","boy":"029.387280","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":77.39508000000001,"mes":47479.8,"yon":265,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:18:04"}', '2025-08-25 20:18:04', '2025-08-25 20:18:06'),
	(2260, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.503790, 29.380760, _binary 0x000000000101000000fd9fc37c79613d40a306d3307c404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:18:31","ind":0,"enl":"40.5037900","boy":"029.380760","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":77.02468,"mes":47480.4,"yon":265,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:18:31"}', '2025-08-25 20:18:31', '2025-08-25 20:18:33'),
	(2261, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.503727, 29.379968, _binary 0x000000000101000000cb86359545613d409e4fd31d7a404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:18:34","ind":0,"enl":"40.5037267","boy":"029.379968","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.1916,"mes":47480.4,"yon":263,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:18:34"}', '2025-08-25 20:18:34', '2025-08-25 20:18:35'),
	(2262, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.503695, 29.379708, _binary 0x0000000001010000009207228b34613d405114e81379404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:18:35","ind":0,"enl":"40.5036950","boy":"029.379708","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.06196,"mes":47480.4,"yon":263,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:18:35"}', '2025-08-25 20:18:35', '2025-08-25 20:18:39'),
	(2263, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.503225, 29.373375, _binary 0x000000000101000000dd240681955f3d40cac342ad69404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:00","ind":0,"enl":"40.5032250","boy":"029.373375","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":78.74704000000001,"mes":47481,"yon":263,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:00"}', '2025-08-25 20:19:00', '2025-08-25 20:19:02'),
	(2264, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.503195, 29.372871, _binary 0x00000000010100000077a04e79745f3d405f419ab168404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:02","ind":0,"enl":"40.5031950","boy":"029.372871","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.32124,"mes":47481,"yon":264,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:02"}', '2025-08-25 20:19:02', '2025-08-25 20:19:04'),
	(2265, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.503182, 29.372610, _binary 0x0000000001010000009e29745e635f3d400cb9084268404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:03","ind":0,"enl":"40.5031817","boy":"029.372610","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.96936000000001,"mes":47481,"yon":264,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:03"}', '2025-08-25 20:19:03', '2025-08-25 20:19:05'),
	(2266, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.503163, 29.372340, _binary 0x0000000001010000001efe9aac515f3d401206afa767404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:04","ind":0,"enl":"40.5031633","boy":"029.372340","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.17308,"mes":47481.1,"yon":263,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:04"}', '2025-08-25 20:19:04', '2025-08-25 20:19:06'),
	(2267, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.503055, 29.371040, _binary 0x0000000001010000000282397afc5e3d406e8b321b64404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:09","ind":0,"enl":"40.5030550","boy":"029.371040","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.87676,"mes":47481.2,"yon":264,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:09"}', '2025-08-25 20:19:09', '2025-08-25 20:19:11'),
	(2268, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.503037, 29.370775, _binary 0x000000000101000000a52c431ceb5e3d400998af8163404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:10","ind":0,"enl":"40.5030367","boy":"029.370775","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.1916,"mes":47481.2,"yon":264,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:10"}', '2025-08-25 20:19:10', '2025-08-25 20:19:11'),
	(2269, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.503022, 29.370516, _binary 0x0000000001010000000da5f622da5e3d40d356db0363404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:11","ind":0,"enl":"40.5030217","boy":"029.370516","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.74712000000001,"mes":47481.2,"yon":265,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:11"}', '2025-08-25 20:19:11', '2025-08-25 20:19:13'),
	(2270, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.502958, 29.369745, _binary 0x0000000001010000000adcba9ba75e3d403ae004f060404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:14","ind":0,"enl":"40.5029583","boy":"029.369745","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.30272000000001,"mes":47481.3,"yon":264,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:14"}', '2025-08-25 20:19:14', '2025-08-25 20:19:17'),
	(2271, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.502937, 29.369490, _binary 0x000000000101000000f4328ae5965e3d40a53ad33a60404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:15","ind":0,"enl":"40.5029367","boy":"029.369490","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.78416,"mes":47481.3,"yon":264,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:15"}', '2025-08-25 20:19:15', '2025-08-25 20:19:18'),
	(2272, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.502685, 29.365561, _binary 0x0000000001010000006cb1db67955d3d404a9869fb57404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:30","ind":0,"enl":"40.5026850","boy":"029.365561","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.59904000000002,"mes":47481.6,"yon":263,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:30"}', '2025-08-25 20:19:30', '2025-08-25 20:19:31'),
	(2273, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.502658, 29.365310, _binary 0x000000000101000000dae6c6f4845d3d400fc86f1b57404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:31","ind":0,"enl":"40.5026583","boy":"029.365310","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.95084000000001,"mes":47481.7,"yon":263,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:31"}', '2025-08-25 20:19:31', '2025-08-25 20:19:32'),
	(2274, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.502637, 29.365038, _binary 0x00000000010100000018cc5f21735d3d407a223e6656404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:32","ind":0,"enl":"40.5026367","boy":"029.365038","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.33976000000001,"mes":47481.7,"yon":263,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:32"}', '2025-08-25 20:19:32', '2025-08-25 20:19:33'),
	(2275, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.502565, 29.364236, _binary 0x0000000001010000009e060c923e5d3d409f8ec70c54404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:35","ind":0,"enl":"40.5025650","boy":"029.364236","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.173,"mes":47481.7,"yon":263,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:35"}', '2025-08-25 20:19:35', '2025-08-25 20:19:37'),
	(2276, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.502455, 29.363236, _binary 0x000000000101000000d8bad408fd5c3d40185b087250404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:39","ind":0,"enl":"40.5024550","boy":"029.363236","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.72868000000001,"mes":47481.8,"yon":264,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:39"}', '2025-08-25 20:19:39', '2025-08-25 20:19:41'),
	(2277, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.502235, 29.359745, _binary 0x00000000010100000047e6913f185c3d400af4893c49404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:52","ind":0,"enl":"40.5022350","boy":"029.359745","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":77.8766,"mes":47482.2,"yon":264,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:52"}', '2025-08-25 20:19:52', '2025-08-25 20:19:53'),
	(2278, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.501513, 29.353585, _binary 0x0000000001010000002d5beb8b845a3d4028017b9631404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:20:17","ind":0,"enl":"40.5015133","boy":"029.353585","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":72.43172,"mes":47482.6,"yon":252,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:20:17"}', '2025-08-25 20:20:17', '2025-08-25 20:20:19'),
	(2279, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.500020, 29.347613, _binary 0x00000000010100000019aa622afd583d4047acc5a700404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:20:46","ind":0,"enl":"40.5000200","boy":"029.347613","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":55.411840000000005,"mes":47483.2,"yon":251,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:20:46"}', '2025-08-25 20:20:46', '2025-08-25 20:20:48'),
	(2280, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.501948, 29.343106, _binary 0x000000000101000000b60f79cbd5573d40336486d73f404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:21:32","ind":0,"enl":"40.5019483","boy":"029.343106","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":32.521119999999996,"mes":47483.7,"yon":290,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:21:32"}', '2025-08-25 20:21:32', '2025-08-25 20:21:34'),
	(2281, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.504608, 29.338458, _binary 0x000000000101000000cf11f92ea5563d4024e5380197404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:22:03","ind":0,"enl":"40.5046083","boy":"029.338458","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":75.04304,"mes":47484.2,"yon":346,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:22:03"}', '2025-08-25 20:22:03', '2025-08-25 20:22:05'),
	(2282, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.506388, 29.338666, _binary 0x0000000001010000006344a2d0b2563d40dcc9f154d1404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:22:12","ind":0,"enl":"40.5063883","boy":"029.338666","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":83.09924,"mes":47484.4,"yon":17,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:22:12"}', '2025-08-25 20:22:12', '2025-08-25 20:22:14'),
	(2283, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.511172, 29.340213, _binary 0x0000000001010000008eacfc3218573d40031203136e414440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:22:34","ind":0,"enl":"40.5111717","boy":"029.340213","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":97.58188,"mes":47484.9,"yon":12,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:22:34"}', '2025-08-25 20:22:34', '2025-08-25 20:22:36'),
	(2284, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.516305, 29.341388, _binary 0x000000000101000000313f373465573d4072e1404816424440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:22:56","ind":0,"enl":"40.5163050","boy":"029.341388","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":92.21108000000001,"mes":47485.5,"yon":7,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:22:56"}', '2025-08-25 20:22:56', '2025-08-25 20:22:59'),
	(2285, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.521062, 29.342065, _binary 0x000000000101000000331b649291573d405d595826b2424440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:23:17","ind":0,"enl":"40.5210617","boy":"029.342065","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":91.47028,"mes":47486,"yon":4,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:23:17"}', '2025-08-25 20:23:17', '2025-08-25 20:23:21'),
	(2286, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.526207, 29.342555, _binary 0x000000000101000000cf143aafb1573d40d2b7bbbd5a434440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:23:39","ind":0,"enl":"40.5262067","boy":"029.342555","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":97.67448,"mes":47486.6,"yon":3,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:23:39"}', '2025-08-25 20:23:39', '2025-08-25 20:23:41'),
	(2287, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.531288, 29.343058, _binary 0x00000000010100000094a12aa6d2573d40ac9f484101444440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:24:00","ind":0,"enl":"40.5312883","boy":"029.343058","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":96.50772,"mes":47487.1,"yon":6,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:24:00"}', '2025-08-25 20:24:00', '2025-08-25 20:24:02'),
	(2288, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.536032, 29.344416, _binary 0x0000000001010000001938a0a52b583d40458fceaf9c444440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:24:20","ind":0,"enl":"40.5360317","boy":"029.344416","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":99.02644000000001,"mes":47487.6,"yon":17,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:24:20"}', '2025-08-25 20:24:20', '2025-08-25 20:24:22'),
	(2289, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.540745, 29.346980, _binary 0x000000000101000000b75d68aed3583d40de3cd52137454440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:24:40","ind":0,"enl":"40.5407450","boy":"029.346980","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":103.84164000000001,"mes":47488.2,"yon":24,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:24:40"}', '2025-08-25 20:24:40', '2025-08-25 20:24:42'),
	(2290, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.545225, 29.349820, _binary 0x0000000001010000009a7cb3cd8d593d4016fbcbeec9454440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:24:59","ind":0,"enl":"40.5452250","boy":"029.349820","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":102.02668000000001,"mes":47488.8,"yon":17,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:24:59"}', '2025-08-25 20:24:59', '2025-08-25 20:25:01'),
	(2291, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.550208, 29.350606, _binary 0x00000000010100000008c89750c1593d406f3ebf396d464440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:25:19","ind":0,"enl":"40.5502083","boy":"029.350606","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":95.9336,"mes":47489.2,"yon":3,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:25:19"}', '2025-08-25 20:25:19', '2025-08-25 20:25:21'),
	(2292, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.552675, 29.350798, _binary 0x0000000001010000009180d1e5cd593d408d28ed0dbe464440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:25:41","ind":4,"enl":"40.5526750","boy":"029.350798","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":81.45096,"mes":47489.8,"yon":5,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:25:41"}', '2025-08-25 20:25:41', '2025-08-25 20:25:44'),
	(2293, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.589080, 29.365680, _binary 0x00000000010100000021cd58349d5d3d40255d33f9664b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:28:28","ind":0,"enl":"40.5890800","boy":"029.365680","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":111.583,"mes":47493.6,"yon":26,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:28:28"}', '2025-08-25 20:28:28', '2025-08-25 20:28:30'),
	(2294, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.589080, 29.365680, _binary 0x00000000010100000021cd58349d5d3d40255d33f9664b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:28:28","ind":0,"enl":"40.5890800","boy":"029.365680","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":111.583,"mes":47493.6,"yon":26,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:28:28"}', '2025-08-25 20:28:28', '2025-08-25 20:28:30'),
	(2295, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.593885, 29.367608, _binary 0x0000000001010000007bbfd18e1b5e3d40e04a766c044c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:28:47","ind":0,"enl":"40.5938850","boy":"029.367608","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":106.74928000000001,"mes":47494.1,"yon":1,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:28:47"}', '2025-08-25 20:28:47', '2025-08-25 20:28:48'),
	(2296, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.593885, 29.367608, _binary 0x0000000001010000007bbfd18e1b5e3d40e04a766c044c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:28:47","ind":0,"enl":"40.5938850","boy":"029.367608","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":106.74928000000001,"mes":47494.1,"yon":1,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:28:47"}', '2025-08-25 20:28:47', '2025-08-25 20:28:48'),
	(2297, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.598755, 29.367171, _binary 0x000000000101000000240a2debfe5d3d4082a8fb00a44c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:29:05","ind":0,"enl":"40.5987550","boy":"029.367171","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":108.67536,"mes":47494.7,"yon":356,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:29:05"}', '2025-08-25 20:29:05', '2025-08-25 20:29:07'),
	(2298, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.603970, 29.367885, _binary 0x00000000010100000060b01bb62d5e3d40efe192e34e4d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:29:24","ind":0,"enl":"40.6039700","boy":"029.367885","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":112.65716,"mes":47495.2,"yon":15,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:29:24"}', '2025-08-25 20:29:24', '2025-08-25 20:29:25'),
	(2299, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.608523, 29.370681, _binary 0x000000000101000000a33f34f3e45e3d40502d6c17e44d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:29:42","ind":0,"enl":"40.6085233","boy":"029.370681","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":111.30520000000001,"mes":47495.8,"yon":34,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:29:42"}', '2025-08-25 20:29:42', '2025-08-25 20:29:45'),
	(2300, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.612167, 29.375330, _binary 0x0000000001010000002b357ba015603d40a2197a7a5b4e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:30:00","ind":0,"enl":"40.6121667","boy":"029.375330","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":114.69436,"mes":47496.3,"yon":51,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:30:00"}', '2025-08-25 20:30:00', '2025-08-25 20:30:01'),
	(2301, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.615463, 29.380060, _binary 0x0000000001010000008c84b69c4b613d40b2b15c80c74e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:30:17","ind":0,"enl":"40.6154633","boy":"029.380060","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":114.62028000000001,"mes":47496.9,"yon":38,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:30:17"}', '2025-08-25 20:30:17', '2025-08-25 20:30:19'),
	(2302, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.619980, 29.382935, _binary 0x000000000101000000677e350708623d40481630815b4f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:30:35","ind":0,"enl":"40.6199800","boy":"029.382935","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":113.45352,"mes":47497.4,"yon":14,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:30:35"}', '2025-08-25 20:30:35', '2025-08-25 20:30:36'),
	(2303, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.625017, 29.383200, _binary 0x000000000101000000c3d32b6519623d4018fa168c00504440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:30:53","ind":0,"enl":"40.6250167","boy":"029.383200","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":111.37928000000001,"mes":47497.9,"yon":356,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:30:53"}', '2025-08-25 20:30:53', '2025-08-25 20:30:55'),
	(2304, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.630123, 29.383550, _binary 0x0000000001010000007c61325530623d404bf95ae1a7504440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:31:11","ind":0,"enl":"40.6301233","boy":"029.383550","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":112.86088,"mes":47498.5,"yon":10,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:31:11"}', '2025-08-25 20:31:11', '2025-08-25 20:31:13'),
	(2305, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.634708, 29.385498, _binary 0x00000000010100000064ac36ffaf623d40f87f1f1f3e514440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:31:28","ind":0,"enl":"40.6347083","boy":"029.385498","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":114.86104000000002,"mes":47499.1,"yon":22,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:31:28"}', '2025-08-25 20:31:28', '2025-08-25 20:31:30'),
	(2306, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.639083, 29.389103, _binary 0x00000000010100000086c613419c633d40bb75487bcd514440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:31:46","ind":0,"enl":"40.6390833","boy":"029.389103","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":113.8054,"mes":47499.5,"yon":47,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:31:46"}', '2025-08-25 20:31:46', '2025-08-25 20:31:47'),
	(2307, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.641340, 29.394555, _binary 0x0000000001010000002979758e01653d40eeceda6d17524440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:32:04","ind":0,"enl":"40.6413400","boy":"029.394555","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":100.91548,"mes":47500.1,"yon":68,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:32:04"}', '2025-08-25 20:32:04', '2025-08-25 20:32:06'),
	(2308, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.642590, 29.401131, _binary 0x0000000001010000006a696e85b0663d404a5e9d6340524440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:32:25","ind":0,"enl":"40.6425900","boy":"029.401131","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":99.00792000000001,"mes":47500.7,"yon":83,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:32:25"}', '2025-08-25 20:32:25', '2025-08-25 20:32:28'),
	(2309, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.643375, 29.407743, _binary 0x000000000101000000452c62d861683d403108ac1c5a524440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:32:46","ind":0,"enl":"40.6433750","boy":"029.407743","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":96.10028000000001,"mes":47501.1,"yon":71,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:32:46"}', '2025-08-25 20:32:46', '2025-08-25 20:32:47'),
	(2310, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.645982, 29.412896, _binary 0x00000000010100000033a6608db3693d4041a84187af524440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:33:06","ind":0,"enl":"40.6459817","boy":"029.412896","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":93.00744,"mes":47501.7,"yon":41,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:33:06"}', '2025-08-25 20:33:06', '2025-08-25 20:33:08'),
	(2311, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.650583, 29.415685, _binary 0x000000000101000000117008556a6a3d407169465046534440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:33:27","ind":0,"enl":"40.6505833","boy":"029.415685","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":102.04520000000001,"mes":47502.3,"yon":9,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:33:27"}', '2025-08-25 20:33:27', '2025-08-25 20:33:28'),
	(2312, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.655440, 29.416228, _binary 0x000000000101000000f3ad0feb8d6a3d40c03e3a75e5534440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:33:45","ind":0,"enl":"40.6554400","boy":"029.416228","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":112.97200000000001,"mes":47502.8,"yon":15,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:33:45"}', '2025-08-25 20:33:45', '2025-08-25 20:33:47'),
	(2313, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.660192, 29.419448, _binary 0x000000000101000000635fb2f1606b3d409a4b602981544440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:34:04","ind":0,"enl":"40.6601917","boy":"029.419448","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":112.71272,"mes":47503.3,"yon":31,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:34:04"}', '2025-08-25 20:34:04', '2025-08-25 20:34:05'),
	(2314, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.664013, 29.423626, _binary 0x0000000001010000003cbce7c0726c3d40f5cd4763fe544440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:34:22","ind":0,"enl":"40.6640133","boy":"029.423626","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":111.91636000000001,"mes":47503.9,"yon":54,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:34:22"}', '2025-08-25 20:34:22', '2025-08-25 20:34:24'),
	(2315, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.665695, 29.430061, _binary 0x000000000101000000f9484a7a186e3d402c0e677e35554440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:34:41","ind":0,"enl":"40.6656950","boy":"029.430061","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":106.00848,"mes":47504.5,"yon":87,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:34:41"}', '2025-08-25 20:34:41', '2025-08-25 20:34:43'),
	(2316, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.664968, 29.436565, _binary 0x00000000010100000008944db9c26f3d4038b066ae1d554440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:35:00","ind":0,"enl":"40.6649683","boy":"029.436565","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":107.61972,"mes":47505.1,"yon":94,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:35:00"}', '2025-08-25 20:35:00', '2025-08-25 20:35:02'),
	(2317, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.666015, 29.443006, _binary 0x00000000010100000089ee59d768713d409ed2c1fa3f554440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:35:18","ind":0,"enl":"40.6660150","boy":"029.443006","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":115.78704,"mes":47505.5,"yon":62,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:35:18"}', '2025-08-25 20:35:18', '2025-08-25 20:35:19'),
	(2318, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.669075, 29.448443, _binary 0x000000000101000000c11e1329cd723d401dc9e53fa4554440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:35:36","ind":0,"enl":"40.6690750","boy":"029.448443","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":113.60168000000002,"mes":47506.1,"yon":52,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:35:36"}', '2025-08-25 20:35:36', '2025-08-25 20:35:37'),
	(2319, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.671917, 29.453628, _binary 0x000000000101000000c58cf0f620743d407011ce5d01564440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:35:53","ind":0,"enl":"40.6719167","boy":"029.453628","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":116.12040000000002,"mes":47506.6,"yon":54,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:35:53"}', '2025-08-25 20:35:53', '2025-08-25 20:35:54'),
	(2320, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.674712, 29.458951, _binary 0x0000000001010000006c770fd07d753d4042ddf6f35c564440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:36:10","ind":0,"enl":"40.6747117","boy":"029.458951","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":111.00888,"mes":47507.2,"yon":53,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:36:10"}', '2025-08-25 20:36:10', '2025-08-25 20:36:12'),
	(2321, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.678673, 29.463470, _binary 0x00000000010100000058ad4cf8a5763d408e1546c4de564440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:36:28","ind":0,"enl":"40.6786733","boy":"029.463470","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":123.91732,"mes":47507.7,"yon":35,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:36:28"}', '2025-08-25 20:36:28', '2025-08-25 20:36:30'),
	(2322, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.682655, 29.467198, _binary 0x000000000101000000b1c1c2499a773d40b6b9313d61574440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:36:44","ind":0,"enl":"40.6826550","boy":"029.467198","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":121.91716000000001,"mes":47508.3,"yon":36,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:36:44"}', '2025-08-25 20:36:44', '2025-08-25 20:36:46'),
	(2323, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.686608, 29.471598, _binary 0x000000000101000000e8db82a5ba783d40c2d4e0c7e2574440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:37:02","ind":0,"enl":"40.6866083","boy":"029.471598","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":111.84228,"mes":47508.8,"yon":42,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:37:02"}', '2025-08-25 20:37:02', '2025-08-25 20:37:03'),
	(2324, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.690103, 29.476273, _binary 0x000000000101000000c2f7fe06ed793d404b2e104e55584440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:37:20","ind":0,"enl":"40.6901033","boy":"029.476273","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":106.76780000000001,"mes":47509.4,"yon":45,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:37:20"}', '2025-08-25 20:37:20', '2025-08-25 20:37:28'),
	(2325, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.693742, 29.481268, _binary 0x000000000101000000809c3061347b3d408baf2c87cc584440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:37:40","ind":0,"enl":"40.6937417","boy":"029.481268","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":106.97152,"mes":47509.9,"yon":46,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:37:40"}', '2025-08-25 20:37:40', '2025-08-25 20:37:42'),
	(2326, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.697185, 29.485726, _binary 0x00000000010100000020d1048a587c3d408121ab5b3d594440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:37:58","ind":0,"enl":"40.6971850","boy":"029.485726","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":107.84196,"mes":47510.5,"yon":41,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:37:58"}', '2025-08-25 20:37:58', '2025-08-25 20:38:00'),
	(2327, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.701325, 29.489773, _binary 0x000000000101000000bc7669c3617d3d40006f8104c5594440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:38:17","ind":0,"enl":"40.7013250","boy":"029.489773","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":109.3606,"mes":47511,"yon":31,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:38:17"}', '2025-08-25 20:38:17', '2025-08-25 20:38:19'),
	(2328, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.705735, 29.493086, _binary 0x0000000001010000008f1d54e23a7e3d403f524486555a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:38:36","ind":0,"enl":"40.7057350","boy":"029.493086","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":103.60088,"mes":47511.6,"yon":29,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:38:36"}', '2025-08-25 20:38:36', '2025-08-25 20:38:37'),
	(2329, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.710033, 29.496215, _binary 0x000000000101000000dec83cf2077f3d401549055fe25a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:38:56","ind":0,"enl":"40.7100333","boy":"029.496215","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":103.87868000000002,"mes":47512.1,"yon":29,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:38:56"}', '2025-08-25 20:38:56', '2025-08-25 20:38:58'),
	(2330, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.714547, 29.499345, _binary 0x000000000101000000cf6bec12d57f3d407cfb2944765b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:39:17","ind":0,"enl":"40.7145467","boy":"029.499345","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":80.50644,"mes":47512.6,"yon":25,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:39:17"}', '2025-08-25 20:39:17', '2025-08-25 20:39:18'),
	(2331, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.714885, 29.499536, _binary 0x000000000101000000b62c5f97e17f3d4053b3075a815b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:39:19","ind":0,"enl":"40.7148850","boy":"029.499536","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":71.80204,"mes":47512.7,"yon":26,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:39:19"}', '2025-08-25 20:39:19', '2025-08-25 20:39:21'),
	(2332, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.716435, 29.500471, _binary 0x000000000101000000af9811de1e803d40d95a5f24b45b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:40:21","ind":0,"enl":"40.7164350","boy":"029.500471","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47512.8,"yon":40,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 23:40:21"}', '2025-08-25 20:40:21', '2025-08-25 20:40:22'),
	(2333, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.718627, 29.501798, _binary 0x000000000101000000be326fd575803d402644aff5fb5b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:40:45","ind":0,"enl":"40.7186267","boy":"029.501798","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":81.54356,"mes":47513.2,"yon":21,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:40:45"}', '2025-08-25 20:40:45', '2025-08-25 20:40:47'),
	(2334, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.723748, 29.503245, _binary 0x00000000010100000022e010aad4803d408e84c7c8a35c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:41:05","ind":0,"enl":"40.7237483","boy":"029.503245","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":112.67568000000001,"mes":47513.6,"yon":10,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:41:05"}', '2025-08-25 20:41:05', '2025-08-25 20:41:06'),
	(2335, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.728213, 29.505510, _binary 0x0000000001010000000ccd751a69813d409101ea17365d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:41:22","ind":0,"enl":"40.7282133","boy":"029.505510","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":115.04624,"mes":47514.2,"yon":31,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:41:22"}', '2025-08-25 20:41:22', '2025-08-25 20:41:24'),
	(2336, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.732270, 29.509593, _binary 0x0000000001010000004145d5af74823d40c4ebfa05bb5d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:41:42","ind":0,"enl":"40.7322700","boy":"029.509593","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":95.67432,"mes":47514.8,"yon":34,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:41:42"}', '2025-08-25 20:41:42', '2025-08-25 20:41:43'),
	(2337, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.736783, 29.512478, _binary 0x00000000010100000064eb19c231833d4096de48ea4e5e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:42:03","ind":0,"enl":"40.7367833","boy":"029.512478","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":94.0816,"mes":47515.3,"yon":18,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:42:03"}', '2025-08-25 20:42:03', '2025-08-25 20:42:05'),
	(2338, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.741552, 29.513776, _binary 0x0000000001010000003e78edd286833d4088e5852aeb5e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:42:24","ind":0,"enl":"40.7415517","boy":"029.513776","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":84.32156,"mes":47515.8,"yon":7,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:42:24"}', '2025-08-25 20:42:24', '2025-08-25 20:42:26'),
	(2339, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.746457, 29.514585, _binary 0x0000000001010000001d03b2d7bb833d40a730a5e48b5f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:42:47","ind":0,"enl":"40.7464567","boy":"029.514585","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":91.59992000000001,"mes":47516.4,"yon":7,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:42:47"}', '2025-08-25 20:42:47', '2025-08-25 20:42:49'),
	(2340, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.751353, 29.515383, _binary 0x00000000010100000014eae923f0833d40ef9e4d582c604440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:43:08","ind":0,"enl":"40.7513533","boy":"029.515383","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":91.54436,"mes":47516.9,"yon":7,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:43:08"}', '2025-08-25 20:43:08', '2025-08-25 20:43:11'),
	(2341, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.756418, 29.516213, _binary 0x00000000010100000022c5008926843d40474c9a50d2604440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:43:31","ind":0,"enl":"40.7564183","boy":"029.516213","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":89.63680000000001,"mes":47517.5,"yon":7,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:43:31"}', '2025-08-25 20:43:31', '2025-08-25 20:43:33'),
	(2342, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.761395, 29.517001, _binary 0x000000000101000000d2ff722d5a843d40412b306475614440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:43:54","ind":0,"enl":"40.7613950","boy":"029.517001","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":84.52528000000001,"mes":47518,"yon":7,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:43:54"}', '2025-08-25 20:43:54', '2025-08-25 20:43:55'),
	(2343, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.766138, 29.517808, _binary 0x0000000001010000006f9ba9108f843d40455bdfd110624440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:44:15","ind":0,"enl":"40.7661383","boy":"029.517808","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":91.97032,"mes":47518.5,"yon":7,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:44:15"}', '2025-08-25 20:44:15', '2025-08-25 20:44:17'),
	(2344, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.771133, 29.518551, _binary 0x000000000101000000df4e22c2bf843d40a42df87eb4624440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:44:35","ind":0,"enl":"40.7711333","boy":"029.518551","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":105.76772,"mes":47519.1,"yon":5,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:44:35"}', '2025-08-25 20:44:35', '2025-08-25 20:44:37'),
	(2345, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.776218, 29.518468, _binary 0x000000000101000000c405a051ba843d4042870a1f5b634440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:44:55","ind":0,"enl":"40.7762183","boy":"029.518468","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":98.41528000000001,"mes":47519.7,"yon":354,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:44:55"}', '2025-08-25 20:44:55', '2025-08-25 20:44:56'),
	(2346, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.781040, 29.517388, _binary 0x000000000101000000c5573b8a73843d40156f641ef9634440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:45:15","ind":0,"enl":"40.7810400","boy":"029.517388","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":95.06316,"mes":47520.1,"yon":345,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:45:15"}', '2025-08-25 20:45:15', '2025-08-25 20:45:21'),
	(2347, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.785873, 29.515700, _binary 0x000000000101000000158c4aea04843d4059260d7f97644440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:45:36","ind":0,"enl":"40.7858733","boy":"029.515700","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":92.61852,"mes":47520.7,"yon":345,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:45:36"}', '2025-08-25 20:45:36', '2025-08-25 20:45:37'),
	(2348, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.790632, 29.513980, _binary 0x0000000001010000004fcc7a3194833d402757676b33654440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:45:57","ind":0,"enl":"40.7906317","boy":"029.513980","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":92.09996,"mes":47521.3,"yon":341,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:45:57"}', '2025-08-25 20:45:57', '2025-08-25 20:45:59'),
	(2349, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.795010, 29.510870, _binary 0x000000000101000000ed815660c8823d4019ff3ee3c2654440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:46:19","ind":0,"enl":"40.7950100","boy":"029.510870","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":88.11816,"mes":47521.7,"yon":340,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:46:19"}', '2025-08-25 20:46:19', '2025-08-25 20:46:21'),
	(2350, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.799718, 29.508791, _binary 0x000000000101000000c77f812040823d40a141542b5d664440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:46:41","ind":0,"enl":"40.7997183","boy":"029.508791","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":87.04400000000001,"mes":47522.3,"yon":318,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:46:41"}', '2025-08-25 20:46:41', '2025-08-25 20:46:42'),
	(2351, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.801265, 29.502801, _binary 0x0000000001010000006765fb90b7803d40f836fdd98f664440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:47:01","ind":0,"enl":"40.8012650","boy":"029.502801","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":97.10036000000001,"mes":47522.8,"yon":292,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:47:01"}', '2025-08-25 20:47:01', '2025-08-25 20:47:03'),
	(2352, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.803915, 29.497335, _binary 0x000000000101000000fa27b858517f3d40c6e1ccafe6664440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:47:23","ind":0,"enl":"40.8039150","boy":"029.497335","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":89.15528,"mes":47523.4,"yon":304,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:47:23"}', '2025-08-25 20:47:23', '2025-08-25 20:47:26'),
	(2353, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.805788, 29.491248, _binary 0x000000000101000000b439ce6dc27d3d40eeff2d1224674440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:47:44","ind":0,"enl":"40.8057883","boy":"029.491248","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":101.04512000000001,"mes":47523.9,"yon":275,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:47:44"}', '2025-08-25 20:47:44', '2025-08-25 20:47:45'),
	(2354, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.805200, 29.484860, _binary 0x0000000001010000007923f3c81f7c3d409e5e29cb10674440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:48:03","ind":0,"enl":"40.8052000","boy":"029.484860","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":102.86008,"mes":47524.4,"yon":263,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:48:03"}', '2025-08-25 20:48:03', '2025-08-25 20:48:05'),
	(2355, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.806072, 29.478198, _binary 0x0000000001010000003a03232f6b7a3d4095dd825b2d674440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:48:22","ind":0,"enl":"40.8060717","boy":"029.478198","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":110.60144,"mes":47525,"yon":287,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:48:22"}', '2025-08-25 20:48:22', '2025-08-25 20:48:23'),
	(2356, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.807600, 29.471931, _binary 0x000000000101000000f5f75278d0783d40f31fd26f5f674440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:48:40","ind":0,"enl":"40.8076000","boy":"029.471931","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":111.23112,"mes":47525.6,"yon":287,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:48:40"}', '2025-08-25 20:48:40', '2025-08-25 20:48:42'),
	(2357, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.809205, 29.465446, _binary 0x000000000101000000d40d147827773d403d61890794674440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:48:59","ind":0,"enl":"40.8092050","boy":"029.465446","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":106.84188,"mes":47526.1,"yon":287,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:48:59"}', '2025-08-25 20:48:59', '2025-08-25 20:49:00'),
	(2358, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.811070, 29.459628, _binary 0x0000000001010000006d533c2eaa753d4024624a24d1674440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:49:17","ind":0,"enl":"40.8110700","boy":"029.459628","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":106.04552,"mes":47526.6,"yon":297,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:49:17"}', '2025-08-25 20:49:17', '2025-08-25 20:49:19'),
	(2359, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.814000, 29.453796, _binary 0x0000000001010000003d0e83f92b743d40d578e92631684440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:49:36","ind":0,"enl":"40.8140000","boy":"029.453796","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":117.63904000000001,"mes":47527.2,"yon":309,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:49:36"}', '2025-08-25 20:49:36', '2025-08-25 20:49:38'),
	(2360, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.817360, 29.449135, _binary 0x0000000001010000002c7de882fa723d407f87a2409f684440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:49:52","ind":0,"enl":"40.8173600","boy":"029.449135","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":123.39876,"mes":47527.8,"yon":315,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:49:52"}', '2025-08-25 20:49:52', '2025-08-25 20:49:54'),
	(2361, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.821337, 29.444316, _binary 0x000000000101000000ec1681b1be713d4096c09c8f21694440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:50:10","ind":0,"enl":"40.8213367","boy":"029.444316","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":113.8054,"mes":47528.3,"yon":320,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:50:10"}', '2025-08-25 20:50:10', '2025-08-25 20:50:11'),
	(2362, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.825083, 29.440058, _binary 0x000000000101000000da571ea4a7703d40e6fc5e549c694440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:50:28","ind":0,"enl":"40.8250833","boy":"029.440058","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":110.15696,"mes":47528.8,"yon":318,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:50:28"}', '2025-08-25 20:50:28', '2025-08-25 20:50:29'),
	(2363, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.828778, 29.435370, _binary 0x000000000101000000d6a88768746f3d4037114768156a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:50:47","ind":0,"enl":"40.8287783","boy":"029.435370","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":107.67528,"mes":47529.4,"yon":311,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:50:47"}', '2025-08-25 20:50:47', '2025-08-25 20:50:48'),
	(2364, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.831780, 29.430133, _binary 0x0000000001010000002dee3f321d6e3d40c3bb5cc4776a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:51:05","ind":0,"enl":"40.8317800","boy":"029.430133","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":110.49032,"mes":47530,"yon":302,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:51:05"}', '2025-08-25 20:51:05', '2025-08-25 20:51:08'),
	(2365, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.834260, 29.424241, _binary 0x000000000101000000519fe40e9b6c3d40342e1c08c96a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:51:24","ind":0,"enl":"40.8342600","boy":"029.424241","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":108.32348,"mes":47530.4,"yon":299,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:51:24"}', '2025-08-25 20:51:24', '2025-08-25 20:51:25'),
	(2366, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.837143, 29.418928, _binary 0x000000000101000000f2608bdd3e6b3d4063c8fb82276b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:51:42","ind":0,"enl":"40.8371433","boy":"029.418928","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":111.19408,"mes":47531,"yon":311,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:51:42"}', '2025-08-25 20:51:42', '2025-08-25 20:51:44'),
	(2367, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.841337, 29.414840, _binary 0x000000000101000000991249f4326a3d4058b6c5ebb06b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:52:02","ind":0,"enl":"40.8413367","boy":"029.414840","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":106.23072,"mes":47531.6,"yon":332,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:52:02"}', '2025-08-25 20:52:02', '2025-08-25 20:52:04'),
	(2368, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.845965, 29.413003, _binary 0x0000000001010000005f268a90ba693d40c347c494486c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:52:19","ind":0,"enl":"40.8459650","boy":"029.413003","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":108.76796,"mes":47532.2,"yon":349,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:52:19"}', '2025-08-25 20:52:19', '2025-08-25 20:52:21'),
	(2369, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.850818, 29.411371, _binary 0x000000000101000000d7851f9c4f693d404eab329de76c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:52:38","ind":0,"enl":"40.8508183","boy":"029.411371","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":105.56400000000001,"mes":47532.6,"yon":339,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:52:38"}', '2025-08-25 20:52:38', '2025-08-25 20:52:40'),
	(2370, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.855365, 29.408403, _binary 0x0000000001010000009a9658198d683d404f92ae997c6d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:52:57","ind":0,"enl":"40.8553650","boy":"029.408403","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":111.12,"mes":47533.2,"yon":329,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:52:57"}', '2025-08-25 20:52:57', '2025-08-25 20:52:59'),
	(2371, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.859533, 29.404631, _binary 0x000000000101000000a1f2afe595673d4057a9ea2f056e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:53:15","ind":0,"enl":"40.8595333","boy":"029.404631","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":109.6384,"mes":47533.8,"yon":322,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:53:15"}', '2025-08-25 20:53:15', '2025-08-25 20:53:18'),
	(2372, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.863757, 29.400853, _binary 0x000000000101000000e5805d4d9e663d40b7195d948f6e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:53:34","ind":0,"enl":"40.8637567","boy":"029.400853","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":102.786,"mes":47534.2,"yon":329,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:53:34"}', '2025-08-25 20:53:34', '2025-08-25 20:53:35'),
	(2373, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.868125, 29.397836, _binary 0x000000000101000000e52b8194d8653d4085eb51b81e6f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:53:52","ind":0,"enl":"40.8681250","boy":"029.397836","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":118.76876,"mes":47534.8,"yon":333,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:53:52"}', '2025-08-25 20:53:52', '2025-08-25 20:53:56'),
	(2374, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.872560, 29.393880, _binary 0x000000000101000000698cd651d5643d401de6cb0bb06f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:54:09","ind":0,"enl":"40.8725600","boy":"029.393880","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":130.26968000000002,"mes":47535.4,"yon":319,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:54:09"}', '2025-08-25 20:54:09', '2025-08-25 20:54:10'),
	(2375, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.875868, 29.389261, _binary 0x000000000101000000b79be09ba6633d40330dd4731c704440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:54:24","ind":0,"enl":"40.8758683","boy":"029.389261","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":120.843,"mes":47535.9,"yon":309,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:54:24"}', '2025-08-25 20:54:24', '2025-08-25 20:54:27'),
	(2376, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.879050, 29.383820, _binary 0x000000000101000000fc8c0b0742623d403fc6dcb584704440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:54:42","ind":0,"enl":"40.8790500","boy":"029.383820","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":116.676,"mes":47536.4,"yon":309,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:54:42"}', '2025-08-25 20:54:42', '2025-08-25 20:54:43'),
	(2377, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.882562, 29.379211, _binary 0x0000000001010000009148dbf813613d40e01923c8f7704440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:54:59","ind":0,"enl":"40.8825617","boy":"029.379211","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":119.06508000000002,"mes":47537,"yon":319,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:54:59"}', '2025-08-25 20:54:59', '2025-08-25 20:55:01'),
	(2378, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.886783, 29.375001, _binary 0x000000000101000000a1f7c61000603d40c9117c1d82714440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:55:16","ind":0,"enl":"40.8867833","boy":"029.375001","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":127.89912000000001,"mes":47537.6,"yon":327,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:55:16"}', '2025-08-25 20:55:16', '2025-08-25 20:55:17'),
	(2379, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.891293, 29.371890, _binary 0x0000000001010000009eb5db2e345f3d406c521be615724440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:55:32","ind":0,"enl":"40.8912933","boy":"029.371890","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":124.69516,"mes":47538.2,"yon":335,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:55:32"}', '2025-08-25 20:55:32', '2025-08-25 20:55:34'),
	(2380, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.896168, 29.369473, _binary 0x00000000010100000048c153c8955e3d40201b92a4b5724440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:55:50","ind":0,"enl":"40.8961683","boy":"029.369473","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":111.30520000000001,"mes":47538.6,"yon":343,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:55:50"}', '2025-08-25 20:55:50', '2025-08-25 20:55:52'),
	(2381, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.900732, 29.367246, _binary 0x0000000001010000003a9677d5035e3d4039fc242d4b734440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:56:07","ind":0,"enl":"40.9007317","boy":"029.367246","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":117.34272,"mes":47539.2,"yon":334,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:56:07"}', '2025-08-25 20:56:07', '2025-08-25 20:56:14'),
	(2382, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.905342, 29.363601, _binary 0x000000000101000000fbca83f4145d3d403f9aa03ce2734440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:56:25","ind":0,"enl":"40.9053417","boy":"029.363601","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":116.0278,"mes":47539.8,"yon":323,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:56:25"}', '2025-08-25 20:56:25', '2025-08-25 20:56:26'),
	(2383, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.909175, 29.359326, _binary 0x0000000001010000003d9aeac9fc5b3d409fabadd85f744440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:56:42","ind":0,"enl":"40.9091750","boy":"029.359326","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":115.23144,"mes":47540.4,"yon":321,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:56:42"}', '2025-08-25 20:56:42', '2025-08-25 20:56:44'),
	(2384, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.913673, 29.355416, _binary 0x000000000101000000a379008bfc5a3d403c5d273ff3744440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:57:00","ind":0,"enl":"40.9136733","boy":"029.355416","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":112.21268,"mes":47541,"yon":331,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:57:00"}', '2025-08-25 20:57:00', '2025-08-25 20:57:01'),
	(2385, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.918237, 29.352698, _binary 0x000000000101000000575d876a4a5a3d40553ebac788754440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:57:17","ind":0,"enl":"40.9182367","boy":"029.352698","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":125.88044000000001,"mes":47541.4,"yon":341,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:57:17"}', '2025-08-25 20:57:17', '2025-08-25 20:57:18'),
	(2386, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.923390, 29.350993, _binary 0x000000000101000000fb1f60adda593d400ababda431764440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:57:34","ind":0,"enl":"40.9233900","boy":"029.350993","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":123.3432,"mes":47542,"yon":347,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:57:34"}', '2025-08-25 20:57:34', '2025-08-25 20:57:37'),
	(2387, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.927817, 29.348590, _binary 0x00000000010100000070b6b9313d593d40619797b2c2764440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:57:50","ind":0,"enl":"40.9278167","boy":"029.348590","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":116.0278,"mes":47542.6,"yon":328,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:57:50"}', '2025-08-25 20:57:50', '2025-08-25 20:57:52'),
	(2388, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.931608, 29.343630, _binary 0x000000000101000000abecbb22f8573d405197d6f03e774440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:58:08","ind":0,"enl":"40.9316083","boy":"029.343630","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":123.86176,"mes":47543.2,"yon":304,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:58:08"}', '2025-08-25 20:58:08', '2025-08-25 20:58:09'),
	(2389, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.933848, 29.337716, _binary 0x0000000001010000000056478e74563d406df6515788774440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:58:24","ind":0,"enl":"40.9338483","boy":"029.337716","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":124.32476,"mes":47543.6,"yon":295,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:58:24"}', '2025-08-25 20:58:24', '2025-08-25 20:58:25'),
	(2390, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.936618, 29.331510, _binary 0x000000000101000000064ce0d6dd543d40e5aac31be3774440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:58:41","ind":0,"enl":"40.9366183","boy":"029.331510","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":131.34384,"mes":47544.2,"yon":305,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:58:41"}', '2025-08-25 20:58:41', '2025-08-25 20:58:42'),
	(2391, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.939478, 29.326498, _binary 0x0000000001010000009c35785f95533d409de62ed340784440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:58:56","ind":0,"enl":"40.9394783","boy":"029.326498","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":102.69340000000001,"mes":47544.8,"yon":304,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:58:56"}', '2025-08-25 20:58:56', '2025-08-25 20:58:58'),
	(2392, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.941928, 29.320548, _binary 0x00000000010100000057cc086f0f523d40a4d6451b91784440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:59:17","ind":0,"enl":"40.9419283","boy":"029.320548","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":110.21252,"mes":47545.4,"yon":296,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:59:17"}', '2025-08-25 20:59:17', '2025-08-25 20:59:19'),
	(2393, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.944353, 29.315041, _binary 0x0000000001010000002ee6e786a6503d4052afa591e0784440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:59:34","ind":0,"enl":"40.9443533","boy":"029.315041","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":117.34272,"mes":47545.8,"yon":305,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:59:34"}', '2025-08-25 20:59:34', '2025-08-25 20:59:36'),
	(2394, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.947748, 29.310021, _binary 0x000000000101000000be1248895d4f3d4078abf8d04f794440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:59:51","ind":0,"enl":"40.9477483","boy":"029.310021","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":122.17644,"mes":47546.4,"yon":312,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:59:51"}', '2025-08-25 20:59:51', '2025-08-25 20:59:55'),
	(2395, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"03:03:10","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":39,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:03:10"}', '2025-08-26 00:03:10', '2025-08-26 00:03:11'),
	(2396, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"03:18:34","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":342,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:18:34"}', '2025-08-26 00:18:34', '2025-08-26 00:18:35'),
	(2397, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"03:33:59","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":272,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:33:59"}', '2025-08-26 00:33:59', '2025-08-26 00:34:00'),
	(2398, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"03:49:24","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":109,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:49:24"}', '2025-08-26 00:49:24', '2025-08-26 00:49:25'),
	(2399, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"04:04:48","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":243,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:04:48"}', '2025-08-26 01:04:48', '2025-08-26 01:04:49'),
	(2400, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"04:20:12","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":327,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:20:12"}', '2025-08-26 01:20:12', '2025-08-26 01:20:14'),
	(2401, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"04:35:37","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":147,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:35:37"}', '2025-08-26 01:35:37', '2025-08-26 01:35:38'),
	(2402, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"04:51:01","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":128,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:51:01"}', '2025-08-26 01:51:01', '2025-08-26 01:51:02'),
	(2403, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"05:06:26","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":235,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:06:26"}', '2025-08-26 02:06:26', '2025-08-26 02:06:27'),
	(2404, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"05:21:50","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":248,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:21:50"}', '2025-08-26 02:21:50', '2025-08-26 02:21:52'),
	(2405, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"05:37:15","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":164,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:37:15"}', '2025-08-26 02:37:15', '2025-08-26 02:37:16'),
	(2406, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"05:52:40","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":228,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:52:40"}', '2025-08-26 02:52:40', '2025-08-26 02:52:41'),
	(2407, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"06:08:04","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":100,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:08:04"}', '2025-08-26 03:08:04', '2025-08-26 03:08:06'),
	(2408, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"06:23:29","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":244,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:23:29"}', '2025-08-26 03:23:29', '2025-08-26 03:23:31'),
	(2409, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"06:38:54","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":40,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:38:54"}', '2025-08-26 03:38:54', '2025-08-26 03:38:56'),
	(2410, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"06:54:20","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":95,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:54:20"}', '2025-08-26 03:54:20', '2025-08-26 03:54:21'),
	(2411, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"07:09:44","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":351,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:09:44"}', '2025-08-26 04:09:44', '2025-08-26 04:09:46'),
	(2412, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"07:25:09","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":102,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:25:09"}', '2025-08-26 04:25:09', '2025-08-26 04:25:11'),
	(2413, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"07:40:34","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":9,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:40:34"}', '2025-08-26 04:40:34', '2025-08-26 04:40:35'),
	(2414, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"07:55:58","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":292,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:55:58"}', '2025-08-26 04:55:58', '2025-08-26 04:56:00'),
	(2415, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"08:11:23","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":257,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:11:23"}', '2025-08-26 05:11:23', '2025-08-26 05:11:25'),
	(2416, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"08:26:48","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":108,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:26:48"}', '2025-08-26 05:26:48', '2025-08-26 05:26:50'),
	(2417, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"08:42:12","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":297,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:42:12"}', '2025-08-26 05:42:12', '2025-08-26 05:42:14'),
	(2418, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"08:57:37","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":256,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:57:37"}', '2025-08-26 05:57:37', '2025-08-26 05:57:38'),
	(2419, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"09:13:01","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":259,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:13:01"}', '2025-08-26 06:13:01', '2025-08-26 06:13:02'),
	(2420, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"09:28:26","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":104,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:28:26"}', '2025-08-26 06:28:26', '2025-08-26 06:28:27'),
	(2421, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"09:43:50","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":206,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:43:50"}', '2025-08-26 06:43:50', '2025-08-26 06:43:52'),
	(2422, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"09:59:15","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":49,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:59:15"}', '2025-08-26 06:59:15', '2025-08-26 06:59:16'),
	(2423, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"10:14:39","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":278,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:14:39"}', '2025-08-26 07:14:39', '2025-08-26 07:14:41'),
	(2424, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"10:30:04","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":239,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:30:04"}', '2025-08-26 07:30:04', '2025-08-26 07:30:05'),
	(2425, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"10:45:29","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":12,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:45:29"}', '2025-08-26 07:45:29', '2025-08-26 07:45:30'),
	(2426, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"11:00:53","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":318,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:00:53"}', '2025-08-26 08:00:53', '2025-08-26 08:00:55'),
	(2427, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"11:16:18","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":355,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:16:18"}', '2025-08-26 08:16:18', '2025-08-26 08:16:19'),
	(2428, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"11:31:43","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":50,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:31:43"}', '2025-08-26 08:31:43', '2025-08-26 08:31:44'),
	(2429, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"11:47:08","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":253,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:47:08"}', '2025-08-26 08:47:08', '2025-08-26 08:47:09'),
	(2430, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"12:02:33","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":130,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:02:33"}', '2025-08-26 09:02:33', '2025-08-26 09:02:34'),
	(2431, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"12:17:57","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":71,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:17:57"}', '2025-08-26 09:17:57', '2025-08-26 09:17:58'),
	(2432, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"12:33:21","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":241,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:33:21"}', '2025-08-26 09:33:21', '2025-08-26 09:33:23'),
	(2433, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"12:48:45","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":359,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:48:45"}', '2025-08-26 09:48:45', '2025-08-26 09:48:47'),
	(2434, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"13:04:10","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":82,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:04:10"}', '2025-08-26 10:04:10', '2025-08-26 10:04:11'),
	(2435, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"13:19:34","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":114,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:19:34"}', '2025-08-26 10:19:34', '2025-08-26 10:19:35'),
	(2436, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"13:34:59","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":337,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:34:59"}', '2025-08-26 10:34:59', '2025-08-26 10:35:00'),
	(2437, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"13:50:23","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":126,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:50:23"}', '2025-08-26 10:50:23', '2025-08-26 10:50:25'),
	(2438, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"14:05:47","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":326,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 14:05:47"}', '2025-08-26 11:05:47', '2025-08-26 11:05:49'),
	(2439, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"14:21:12","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":280,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 14:21:12"}', '2025-08-26 11:21:12', '2025-08-26 11:21:13'),
	(2440, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"14:36:37","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":243,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 14:36:37"}', '2025-08-26 11:36:37', '2025-08-26 11:36:38'),
	(2441, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"14:52:01","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":278,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 14:52:01"}', '2025-08-26 11:52:01', '2025-08-26 11:52:03'),
	(2442, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"15:07:26","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":72,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 15:07:26"}', '2025-08-26 12:07:26', '2025-08-26 12:07:27'),
	(2443, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"15:22:51","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":257,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 15:22:51"}', '2025-08-26 12:22:51', '2025-08-26 12:22:52'),
	(2444, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"15:38:15","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":63,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 15:38:15"}', '2025-08-26 12:38:15', '2025-08-26 12:38:17'),
	(2445, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"15:53:40","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":73,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 15:53:40"}', '2025-08-26 12:53:40', '2025-08-26 12:53:42'),
	(2446, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"16:09:04","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":264,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 16:09:04"}', '2025-08-26 13:09:04', '2025-08-26 13:09:06'),
	(2447, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"16:24:29","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":292,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 16:24:29"}', '2025-08-26 13:24:29', '2025-08-26 13:24:30'),
	(2448, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"16:39:53","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":278,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 16:39:53"}', '2025-08-26 13:39:53', '2025-08-26 13:39:54'),
	(2459, '31.142.118.30:45618', '352016703347070', 40.997893, 29.047355, _binary 0x000000000101000000554d10751f0c3d4023f433f5ba7f4440, '0', '{"p":"1","did":"352016703347070","trh":"26.8.23","sat":"21:17:37","ind":0,"enl":"40.9978933","boy":"29.047355","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":0,"mes":0,"yon":0,"A":"","Sensor":"","drx":1}', '2023-11-14 16:43:16', '2023-11-14 16:43:16'),
	(2460, '31.142.118.30:45794', '352016703347070', 40.997243, 29.048565, _binary 0x000000000101000000f1ba7ec16e0c3d401c959ba8a57f4440, '0', '{"p":"1","did":"352016703347070","trh":"27.8.23","sat":"14:06:17","ind":0,"enl":"40.9972433","boy":"29.048565","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":0,"mes":0,"yon":8,"A":"","Sensor":"","drx":1}', '2023-11-14 16:52:34', '2023-11-14 16:52:34'),
	(2461, '31.142.118.30:45794', '352016703347070', 40.997312, 29.048510, _binary 0x0000000001010000006a87bf266b0c3d4045f46beba77f4440, '0', '{"p":"1","did":"352016703347070","trh":"27.8.23","sat":"22:40:56","ind":0,"enl":"40.9973116","boy":"29.04851","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":0,"mes":0,"yon":104,"A":"","Sensor":"","drx":1}', '2023-11-14 16:54:13', '2023-11-14 16:54:13'),
	(2462, '31.142.118.30:45321', '352016703347070', 40.997430, 29.048352, _binary 0x0000000001010000003ab2f2cb600c3d404f0647c9ab7f4440, '0', '{"p":"1","did":"352016703347070","trh":"3.9.23","sat":"16:47:26","ind":0,"enl":"40.99743","boy":"29.0483516","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":0,"mes":0,"yon":3,"A":"","Sensor":"","drx":1}', '2023-11-14 17:23:18', '2023-11-14 17:23:18'),
	(2463, '31.142.118.30:45321', '352016703347070', 40.997598, 29.048393, _binary 0x000000000101000000f75ad07b630c3d400b47904ab17f4440, '0', '{"p":"1","did":"352016703347070","trh":"5.9.23","sat":"21:12:21","ind":0,"enl":"40.9975983","boy":"29.0483933","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":0,"mes":0,"yon":337,"A":"","Sensor":"","drx":1}', '2023-11-14 17:31:52', '2023-11-14 17:31:52'),
	(2464, '31.142.118.30:45321', '352016703347070', 40.997608, 29.048270, _binary 0x000000000101000000bf60376c5b0c3d402e1d739eb17f4440, '0', '{"p":"1","did":"352016703347070","trh":"5.9.23","sat":"21:31:37","ind":0,"enl":"40.9976083","boy":"29.04827","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":0,"mes":0,"yon":0,"A":"","Sensor":"","drx":1}', '2023-11-14 17:31:57', '2023-11-14 17:31:57'),
	(2466, '31.142.118.30:46195', '352016703347070', 40.997328, 29.047553, _binary 0x000000000101000000a2d3f36e2c0c3d404bb1a371a87f4440, '0', '{"p":"1","did":"352016703347070","trh":"14.11.23","sat":"21:48:28","ind":0,"enl":"40.9973283","boy":"29.0475533","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":0,"mes":0,"yon":283,"A":"","Sensor":"","drx":1}', '2023-11-14 18:48:37', '2023-11-14 18:48:37'),
	(2467, '31.142.118.30:45130', '352016703347070', 40.997445, 29.048317, _binary 0x00000000010100000041d7be805e0c3d4084471b47ac7f4440, '0', '{"p":"1","did":"352016703347070","trh":"17.11.23","sat":"18:51:54","ind":0,"enl":"40.997445","boy":"29.0483166","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":0,"mes":0,"yon":336,"A":"","Sensor":"","drx":1}', '2023-11-17 15:51:57', '2023-11-17 15:51:57'),
	(2468, '31.142.118.30:45130', '352016703347070', 40.997452, 29.048300, _binary 0x000000000101000000956588635d0c3d4037aad381ac7f4440, '0', '{"p":"1","did":"352016703347070","trh":"17.11.23","sat":"18:52:09","ind":0,"enl":"40.9974516","boy":"29.0483","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":4,"mes":0,"yon":151,"A":"","Sensor":"","drx":2}', '2023-11-17 15:52:11', '2023-11-17 15:52:11'),
	(2469, '31.142.118.30:45130', '352016703347070', 40.997592, 29.048135, _binary 0x000000000101000000ffca4a93520c3d4028603b18b17f4440, '0', '{"p":"1","did":"352016703347070","trh":"17.11.23","sat":"19:06:32","ind":0,"enl":"40.9975916","boy":"29.048135","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":0,"mes":0,"yon":322,"A":"","Sensor":"","drx":0}', '2023-11-17 16:06:35', '2023-11-17 16:06:35'),
	(2470, '31.142.118.30:45130', '352016703347070', 40.997500, 29.048163, _binary 0x00000000010100000093e00d69540c3d4048e17a14ae7f4440, '0', '{"p":"1","did":"352016703347070","trh":"17.11.23","sat":"19:06:34","ind":0,"enl":"40.9975","boy":"29.0481633","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":0,"mes":0,"yon":318,"A":"","Sensor":"","drx":0}', '2023-11-17 16:06:36', '2023-11-17 16:06:36'),
	(2471, '31.142.118.30:45438', '352016703347070', 40.997360, 29.048455, _binary 0x000000000101000000e353008c670c3d40562b137ea97f4440, '0', '{"p":"1","did":"352016703347070","trh":"20.11.23","sat":"18:24:23","ind":0,"enl":"40.99736","boy":"29.0484549","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":0,"mes":0,"yon":312,"A":"","Sensor":"","drx":1}', '2023-11-20 15:24:26', '2023-11-20 15:24:26'),
	(2472, '31.142.118.30:46111', '352016703347070', 40.997360, 29.048562, _binary 0x0000000001010000000fd4298f6e0c3d40562b137ea97f4440, '0', '{"p":"1","did":"352016703347070","trh":"21.11.23","sat":"19:13:33","ind":0,"enl":"40.99736","boy":"29.0485616","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":5,"mes":0,"yon":310,"A":"","Sensor":"","drx":2}', '2023-11-21 16:13:36', '2023-11-21 16:13:36'),
	(2473, '31.142.118.30:46111', '352016703347070', 40.997343, 29.048587, _binary 0x000000000101000000c1029832700c3d4080f277efa87f4440, '0', '{"p":"1","did":"352016703347070","trh":"21.11.23","sat":"19:13:35","ind":0,"enl":"40.9973433","boy":"29.0485866","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":8,"mes":0,"yon":314,"A":"","Sensor":"","drx":2}', '2023-11-21 16:13:42', '2023-11-21 16:13:42'),
	(2474, '31.142.118.30:46111', '352016703347070', 40.997312, 29.048430, _binary 0x000000000101000000312592e8650c3d4045f46beba77f4440, '0', '{"p":"1","did":"352016703347070","trh":"21.11.23","sat":"19:14:04","ind":0,"enl":"40.9973116","boy":"29.04843","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":7,"mes":0,"yon":298,"A":"","Sensor":"","drx":2}', '2023-11-21 16:14:09', '2023-11-21 16:14:09'),
	(2475, '31.142.118.30:46111', '352016703347070', 40.997337, 29.048207, _binary 0x0000000001010000003370404b570c3d409e0b23bda87f4440, '0', '{"p":"1","did":"352016703347070","trh":"21.11.23","sat":"19:14:13","ind":0,"enl":"40.9973366","boy":"29.0482066","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":7,"mes":0,"yon":263,"A":"","Sensor":"","drx":2}', '2023-11-21 16:14:21', '2023-11-21 16:14:21'),
	(2476, '31.142.118.30:46111', '352016703347070', 40.997363, 29.048130, _binary 0x000000000101000000dcf4673f520c3d40c79e3d97a97f4440, '0', '{"p":"1","did":"352016703347070","trh":"21.11.23","sat":"19:14:20","ind":0,"enl":"40.9973633","boy":"29.0481299","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":8,"mes":0,"yon":284,"A":"","Sensor":"","drx":2}', '2023-11-21 16:14:22', '2023-11-21 16:14:22'),
	(2477, '31.142.118.30:46111', '352016703347070', 40.997392, 29.048162, _binary 0x000000000101000000f3e84658540c3d4061a5828aaa7f4440, '0', '{"p":"1","did":"352016703347070","trh":"21.11.23","sat":"19:14:22","ind":0,"enl":"40.9973916","boy":"29.0481616","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":5,"mes":0,"yon":292,"A":"","Sensor":"","drx":2}', '2023-11-21 16:14:23', '2023-11-21 16:14:23'),
	(2478, '31.142.118.30:45999', '352016703347070', 40.997212, 29.048507, _binary 0x00000000010100000088a06af46a0c3d40e1968fa4a47f4440, '0', '{"p":"1","did":"352016703347070","trh":"28.11.23","sat":"11:06:20","ind":0,"enl":"40.9972116","boy":"29.0485066","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":0,"mes":0,"yon":312,"A":"","Sensor":"","drx":1}', '2023-11-28 08:06:22', '2023-11-28 08:06:22'),
	(2479, '178.243.245.133:27228', '352016703347070', 40.994922, 29.049582, _binary 0x0000000001010000006478ec67b10c3d401409a69a597f4440, '0', '{"p":"1","did":"352016703347070","trh":"9.12.23","sat":"22:00:02","ind":0,"enl":"40.9949216","boy":"29.0495816","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":0,"mes":3007,"yon":13,"A":"","Sensor":"","drx":1}', '2023-12-09 19:00:04', '2023-12-09 19:00:04'),
	(2480, '188.58.109.120:26310', '352016703347070', 40.997670, 29.048067, _binary 0x0000000001010000004f04711e4e0c3d40a4198ba6b37f4440, '0', '{"p":"1","did":"352016703347070","trh":"29.12.23","sat":"19:12:33","ind":0,"enl":"40.99767","boy":"29.0480666","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":17,"mes":3.045,"yon":330,"A":"","Sensor":"","drx":2}', '2023-12-29 16:12:35', '2023-12-29 16:12:35'),
	(2481, '188.58.109.120:26310', '352016703347070', 40.997708, 29.048037, _binary 0x0000000001010000007aff1f274c0c3d40927a4fe5b47f4440, '0', '{"p":"1","did":"352016703347070","trh":"29.12.23","sat":"19:12:35","ind":0,"enl":"40.9977083","boy":"29.0480366","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":17,"mes":3.05,"yon":334,"A":"","Sensor":"","drx":2}', '2023-12-29 16:12:38', '2023-12-29 16:12:38'),
	(2482, '188.58.109.120:26310', '352016703347070', 40.997753, 29.047987, _binary 0x00000000010100000016a243e0480c3d40323ecc5eb67f4440, '0', '{"p":"1","did":"352016703347070","trh":"29.12.23","sat":"19:12:37","ind":0,"enl":"40.9977533","boy":"29.0479866","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":20,"mes":3.057,"yon":330,"A":"","Sensor":"","drx":2}', '2023-12-29 16:12:39', '2023-12-29 16:12:39'),
	(2483, '188.58.109.120:26310', '352016703347070', 40.997828, 29.047942, _binary 0x000000000101000000d61a4aed450c3d403c84f1d3b87f4440, '0', '{"p":"1","did":"352016703347070","trh":"29.12.23","sat":"19:12:40","ind":0,"enl":"40.9978283","boy":"29.0479416","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":21,"mes":3.066,"yon":336,"A":"","Sensor":"","drx":2}', '2023-12-29 16:12:42', '2023-12-29 16:12:42'),
	(2484, '188.58.109.120:26310', '352016703347070', 40.997858, 29.047923, _binary 0x000000000101000000e9b985ae440c3d40a7069acfb97f4440, '0', '{"p":"1","did":"352016703347070","trh":"29.12.23","sat":"19:12:41","ind":0,"enl":"40.9978583","boy":"29.0479233","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":23,"mes":3.069,"yon":337,"A":"","Sensor":"","drx":2}', '2023-12-29 16:12:43', '2023-12-29 16:12:43'),
	(2485, '188.58.109.120:26310', '352016703347070', 40.997917, 29.047837, _binary 0x000000000101000000ec89ae0b3f0c3d40ac8f87bebb7f4440, '0', '{"p":"1","did":"352016703347070","trh":"29.12.23","sat":"19:12:45","ind":0,"enl":"40.9979166","boy":"29.0478366","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":20,"mes":3.078,"yon":332,"A":"","Sensor":"","drx":2}', '2023-12-29 16:12:49', '2023-12-29 16:12:49'),
	(2486, '188.58.109.120:26310', '352016703347070', 40.997958, 29.047770, _binary 0x000000000101000000dcba9ba73a0c3d400a647616bd7f4440, '0', '{"p":"1","did":"352016703347070","trh":"29.12.23","sat":"19:12:48","ind":0,"enl":"40.9979583","boy":"29.04777","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":23,"mes":3.087,"yon":328,"A":"","Sensor":"","drx":2}', '2023-12-29 16:12:50', '2023-12-29 16:12:50'),
	(2487, '188.58.109.120:26310', '352016703347070', 40.997968, 29.047748, _binary 0x0000000001010000000c738236390c3d402e3a596abd7f4440, '0', '{"p":"1","did":"352016703347070","trh":"29.12.23","sat":"19:12:49","ind":0,"enl":"40.9979683","boy":"29.0477483","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":21,"mes":3.087,"yon":327,"A":"","Sensor":"","drx":2}', '2023-12-29 16:12:51', '2023-12-29 16:12:51'),
	(2488, '188.58.109.120:26310', '352016703347070', 40.997998, 29.047645, _binary 0x00000000010100000063d17476320c3d4099bc0166be7f4440, '0', '{"p":"1","did":"352016703347070","trh":"29.12.23","sat":"19:12:52","ind":0,"enl":"40.9979983","boy":"29.047645","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":20,"mes":3.096,"yon":323,"A":"","Sensor":"","drx":2}', '2023-12-29 16:12:55', '2023-12-29 16:12:55'),
	(2489, '188.58.109.120:26310', '352016703347070', 40.998085, 29.047823, _binary 0x00000000010100000022ffcc203e0c3d4068d0d03fc17f4440, '0', '{"p":"1","did":"352016703347070","trh":"29.12.23","sat":"19:12:56","ind":0,"enl":"40.9980849","boy":"29.0478233","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":16,"mes":3.116,"yon":1,"A":"","Sensor":"","drx":2}', '2023-12-29 16:12:59', '2023-12-29 16:12:59'),
	(2490, '188.58.109.120:26310', '352016703347070', 40.998140, 29.047997, _binary 0x0000000001010000005d4e0988490c3d402b6a300dc37f4440, '0', '{"p":"1","did":"352016703347070","trh":"29.12.23","sat":"19:12:58","ind":0,"enl":"40.99814","boy":"29.0479966","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":16,"mes":3.131,"yon":16,"A":"","Sensor":"","drx":2}', '2023-12-29 16:13:00', '2023-12-29 16:13:00'),
	(2491, '178.245.95.126:9813', '352016703347070', 40.997722, 29.048175, _binary 0x0000000001010000001c7c6132550c3d40f73fc05ab57f4440, '0', '{"p":"1","did":"352016703347070","trh":"26.2.24","sat":"21:45:49","ind":0,"enl":"40.9977216","boy":"29.0481749","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":0,"mes":3.022,"yon":0,"A":"12","Sensor":"","drx":1}', '2024-02-26 18:47:37', '2024-02-26 18:47:37'),
	(2492, '178.245.95.126:9813', '352016703347070', 40.997108, 29.048515, _binary 0x0000000001010000008d5da27a6b0c3d403c4a253ca17f4440, '0', '{"p":"1","did":"352016703347070","trh":"26.2.24","sat":"21:56:42","ind":0,"enl":"40.9971083","boy":"29.048515","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":9,"mes":3.022,"yon":161,"A":"","Sensor":"","drx":0}', '2024-02-26 18:56:48', '2024-02-26 18:56:48');
/*!40000 ALTER TABLE `vts_device_logs` ENABLE KEYS */;

-- tablo yapısı dökülüyor vts_database.vts_device_logs_copy
CREATE TABLE IF NOT EXISTS `vts_device_logs_copy` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(50) DEFAULT NULL COMMENT 'IP adres',
  `did` varchar(50) DEFAULT NULL COMMENT 'device ID',
  `latitude` decimal(10,6) DEFAULT NULL COMMENT 'Latitude',
  `longitude` decimal(10,6) DEFAULT NULL COMMENT 'Longitude',
  `coord` point DEFAULT NULL COMMENT 'Coordinate ',
  `notification_sent` varchar(50) NOT NULL DEFAULT '0' COMMENT 'Notification sent status',
  `log_data_json` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'JSON log data',
  `log_datetime` timestamp NULL DEFAULT NULL COMMENT 'Log datetime',
  `dt` timestamp NULL DEFAULT NULL COMMENT 'Db datetime',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_vts_device_logs_did_id` (`did`,`id`) USING BTREE,
  KEY `idx_vts_device_logs_did_log_datetime` (`did`,`log_datetime`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2408777 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci ROW_FORMAT=DYNAMIC;

-- vts_database.vts_device_logs_copy: 1.280 rows tablosu için veriler indiriliyor
/*!40000 ALTER TABLE `vts_device_logs_copy` DISABLE KEYS */;
INSERT INTO `vts_device_logs_copy` (`id`, `ip`, `did`, `latitude`, `longitude`, `coord`, `notification_sent`, `log_data_json`, `log_datetime`, `dt`) VALUES
	(345691, '31.142.118.30:46045', '352016703347070', 40.997493, 29.048172, _binary 0x0000000001010000003a950c00550c3d40957ec2d9ad7f4440, '0', '{"p":"1","did":"352016703347070","trh":"20.11.23","sat":"06:21:55","ind":0,"enl":"40.9974933","boy":"29.0481716","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":0,"mes":0,"yon":0,"A":"","Sensor":"","drx":1}', '2025-08-25 12:58:07', '2023-11-19 20:21:58'),
	(2407339, '176.238.23.156:30732', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"20:00:28","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":205,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:00:28"}', '2025-08-25 10:00:28', '2025-08-25 10:00:30'),
	(2407340, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003753, 29.224698, _binary 0x000000000101000000037ae1ce85393d404460f6fc7a804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"25.08.2025","sat":"20:01:48","ind":0,"enl":"41.0037533","boy":"029.224698","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43221.7,"yon":190,"A":"4","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:01:48"}', '2025-08-25 10:01:48', '2025-08-25 10:01:50'),
	(2407341, '5.24.114.91:59134', '86090604649604512', 41.002663, 29.124220, _binary 0x0000000001010000005682c5e1cc1f3d402133614557804440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"25.08.2025","sat":"20:04:43","ind":0,"enl":"41.0026633","boy":"029.124220","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":29332.1,"yon":94,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 20:04:43"}', '2025-08-25 10:04:43', '2025-08-25 10:04:45'),
	(2407342, '5.24.114.91:59134', '86090604649604512', 41.006995, 29.125615, _binary 0x00000000010100000015e3fc4d28203d40261e5036e5804440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"25.08.2025","sat":"20:06:27","ind":0,"enl":"41.0069950","boy":"029.125615","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":9.09332,"mes":29332.6,"yon":24,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 20:06:27"}', '2025-08-25 10:06:27', '2025-08-25 10:06:29'),
	(2407343, '178.240.198.6:6180', '86090604649604512', 41.007452, 29.125916, _binary 0x0000000001010000000b0bee073c203d4059e6632df4804440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"25.08.2025","sat":"20:07:12","ind":0,"enl":"41.0074517","boy":"029.125916","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":29332.7,"yon":16,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 20:07:12"}', '2025-08-25 10:07:12', '2025-08-25 10:07:14'),
	(2407344, '178.240.198.6:6180', '86090604649604512', 41.007452, 29.125916, _binary 0x0000000001010000000b0bee073c203d4059e6632df4804440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"25.08.2025","sat":"20:06:54","ind":0,"enl":"41.0074517","boy":"029.125916","drm":[1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":29332.7,"yon":16,"A":"74","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 20:06:54"}', '2025-08-25 10:06:54', '2025-08-25 10:07:14'),
	(2407345, '176.227.27.113:25020', '44fe033664dac2621', 41.012117, 29.050781, _binary 0x0000000001010000001842cefbff0c3d40231e3f0a8d814440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"25.08.2025","sat":"20:07:48","ind":0,"enl":"41.0121167","boy":"029.050781","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74647.3,"yon":130,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:07:48"}', '2025-08-25 10:07:48', '2025-08-25 10:07:50'),
	(2407346, '176.227.27.113:25020', '44fe033664dac2621', 41.012117, 29.050781, _binary 0x0000000001010000001842cefbff0c3d40231e3f0a8d814440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"25.08.2025","sat":"20:07:31","ind":0,"enl":"41.0121167","boy":"029.050781","drm":[1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74647.3,"yon":127,"A":"74","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:07:31"}', '2025-08-25 10:07:31', '2025-08-25 10:07:50'),
	(2407347, '31.142.112.178:48705', '353201357563383', 40.997282, 29.048400, _binary 0x0000000001010000005c2041f1630c3d40877368eca67f4440, '0', '{"device_model": "Teltonika", "p": "1", "did": "353201357563383", "trh": "2025-08-25", "sat": "20:07:28", "ind": 0, "enl": "40.9972816", "boy": "29.0484", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 3.137, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12001, "battery_voltage": 0, "battery_current": 0, "record_timestamp": "2025-08-25 20:07:28", "codec_id": 8}', '2025-08-25 10:07:28', '2025-08-25 10:09:02'),
	(2407348, '178.240.198.6:6180', '86090604649604512', 41.008013, 29.126213, _binary 0x0000000001010000007e54c37e4f203d406eb76e9406814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"25.08.2025","sat":"20:08:59","ind":0,"enl":"41.0080133","boy":"029.126213","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":29332.7,"yon":15,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 20:08:59"}', '2025-08-25 10:08:59', '2025-08-25 10:09:01'),
	(2407349, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"20:09:46","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:09:46"}', '2025-08-25 10:09:46', '2025-08-25 10:09:45'),
	(2407350, '31.142.69.246:17347', '86090604649604512', 41.008013, 29.126213, _binary 0x0000000001010000007e54c37e4f203d406eb76e9406814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"25.08.2025","sat":"20:10:31","ind":0,"enl":"41.0080133","boy":"029.126213","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":29332.8,"yon":15,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 20:10:31"}', '2025-08-25 10:10:31', '2025-08-25 10:10:33'),
	(2407351, '31.142.69.246:17347', '86090604649604512', 41.008013, 29.126213, _binary 0x0000000001010000007e54c37e4f203d406eb76e9406814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"25.08.2025","sat":"20:10:11","ind":0,"enl":"41.0080133","boy":"029.126213","drm":[1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":29332.8,"yon":15,"A":"74","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 20:10:11"}', '2025-08-25 10:10:11', '2025-08-25 10:10:33'),
	(2407352, '31.142.69.246:17347', '86090604649604512', 41.008013, 29.126213, _binary 0x0000000001010000007e54c37e4f203d406eb76e9406814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"25.08.2025","sat":"20:10:27","ind":0,"enl":"41.0080133","boy":"029.126213","drm":[1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":29332.8,"yon":15,"A":"74","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 20:10:27"}', '2025-08-25 10:10:27', '2025-08-25 10:10:35'),
	(2407353, '31.142.69.246:17347', '86090604649604512', 41.008013, 29.126213, _binary 0x0000000001010000007e54c37e4f203d406eb76e9406814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"25.08.2025","sat":"20:10:27","ind":0,"enl":"41.0080133","boy":"029.126213","drm":[1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":29332.8,"yon":15,"A":"74","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 20:10:27"}', '2025-08-25 10:10:27', '2025-08-25 10:10:35'),
	(2407354, '31.142.69.246:17347', '86090604649604512', 41.011725, 29.128071, _binary 0x000000000101000000e690d442c9203d40d6c56d3480814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"25.08.2025","sat":"20:11:48","ind":0,"enl":"41.0117250","boy":"029.128071","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":29333.1,"yon":7,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:11:48"}', '2025-08-25 10:11:48', '2025-08-25 10:11:52'),
	(2407355, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997238, 29.074741, _binary 0x0000000001010000009babe63922133d40c9682e81a57f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"25.08.2025","sat":"20:12:28","ind":0,"enl":"40.9972383","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":196,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:12:28"}', '2025-08-25 10:12:28', '2025-08-25 10:12:31'),
	(2407356, '31.142.69.246:17347', '86090604649604512', 41.011735, 29.128046, _binary 0x0000000001010000003562669fc7203d40fa9b508880814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"25.08.2025","sat":"20:13:35","ind":0,"enl":"41.0117350","boy":"029.128046","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":29333.1,"yon":170,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 20:13:35"}', '2025-08-25 10:13:35', '2025-08-25 10:13:37'),
	(2407357, '31.142.69.246:17347', '86090604649604512', 41.011735, 29.128028, _binary 0x000000000101000000e8f86871c6203d40fa9b508880814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"25.08.2025","sat":"20:13:37","ind":0,"enl":"41.0117350","boy":"029.128028","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":29333.1,"yon":166,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:13:37"}', '2025-08-25 10:13:37', '2025-08-25 10:13:39'),
	(2407358, '31.142.69.246:17347', '86090604649604512', 41.011730, 29.128030, _binary 0x00000000010100000029e8f692c6203d40e8305f5e80814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"25.08.2025","sat":"20:13:38","ind":0,"enl":"41.0117300","boy":"029.128030","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":2.315,"mes":29333.1,"yon":354,"A":"12","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 20:13:38"}', '2025-08-25 10:13:38', '2025-08-25 10:13:40'),
	(2407359, '176.227.64.154:38338', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"20:13:53","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":189,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:13:53"}', '2025-08-25 10:13:53', '2025-08-25 10:13:55'),
	(2407360, '31.142.69.246:17347', '86090604649604512', 41.012630, 29.125520, _binary 0x00000000010100000072fe261422203d4068791edc9d814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"25.08.2025","sat":"20:15:43","ind":0,"enl":"41.0126300","boy":"029.125520","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":3.35212,"mes":29333.5,"yon":154,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 20:15:43"}', '2025-08-25 10:15:43', '2025-08-25 10:15:44'),
	(2407361, '31.142.69.246:17347', '86090604649604512', 41.012630, 29.125520, _binary 0x00000000010100000072fe261422203d4068791edc9d814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"25.08.2025","sat":"20:15:54","ind":0,"enl":"41.0126300","boy":"029.125520","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":154,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:15:54"}', '2025-08-25 10:15:54', '2025-08-25 10:15:56'),
	(2407362, '176.227.64.154:38338', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"20:15:54","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":326,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:15:54"}', '2025-08-25 10:15:54', '2025-08-25 10:16:03'),
	(2407363, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.011677, 29.050981, _binary 0x000000000101000000a6b73f170d0d3d400750429f7e814440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"25.08.2025","sat":"20:18:40","ind":0,"enl":"41.0116767","boy":"029.050981","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43113.3,"yon":189,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:18:40"}', '2025-08-25 10:18:40', '2025-08-25 10:18:41'),
	(2407364, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"20:19:47","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:19:47"}', '2025-08-25 10:19:47', '2025-08-25 10:19:45'),
	(2407365, '178.243.219.93:21646', '44fe033664dac2621', 41.012117, 29.050781, _binary 0x0000000001010000001842cefbff0c3d40231e3f0a8d814440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"25.08.2025","sat":"20:23:42","ind":0,"enl":"41.0121167","boy":"029.050781","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74647.3,"yon":220,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:23:42"}', '2025-08-25 10:23:42', '2025-08-25 10:23:44'),
	(2407366, '178.243.219.93:21646', '44fe033664dac2621', 41.012117, 29.050781, _binary 0x0000000001010000001842cefbff0c3d40231e3f0a8d814440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"25.08.2025","sat":"20:23:24","ind":0,"enl":"41.0121167","boy":"029.050781","drm":[1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74647.3,"yon":220,"A":"74","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:23:24"}', '2025-08-25 10:23:24', '2025-08-25 10:23:44'),
	(2407367, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003638, 29.079390, _binary 0x00000000010100000023a12de752143d40abc1453877804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"25.08.2025","sat":"20:26:10","ind":0,"enl":"41.0036383","boy":"029.079390","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94765.6,"yon":227,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:26:10"}', '2025-08-25 10:26:10', '2025-08-25 10:26:14'),
	(2407368, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"25.08.2025","sat":"20:26:15","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":46,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:26:15"}', '2025-08-25 10:26:15', '2025-08-25 10:26:17'),
	(2407369, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"25.08.2025","sat":"20:26:16","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":20,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:26:16"}', '2025-08-25 10:26:16', '2025-08-25 10:26:18'),
	(2407370, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003638, 29.079390, _binary 0x00000000010100000023a12de752143d40abc1453877804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"25.08.2025","sat":"20:26:34","ind":0,"enl":"41.0036383","boy":"029.079390","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94765.6,"yon":227,"A":"4","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:26:34"}', '2025-08-25 10:26:34', '2025-08-25 10:26:37'),
	(2407371, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"25.08.2025","sat":"20:27:48","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":182,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:27:48"}', '2025-08-25 10:27:48', '2025-08-25 10:27:51'),
	(2407372, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"20:29:47","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:29:47"}', '2025-08-25 10:29:47', '2025-08-25 10:29:46'),
	(2407373, '31.143.219.198:35638', '86284304533376212', 40.992082, 28.905356, _binary 0x000000000101000000c53c2b69c5e73c40e43a7c88fc7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"25.08.2025","sat":"20:29:45","ind":0,"enl":"40.9920817","boy":"028.905356","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10953.7,"yon":265,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:29:45"}', '2025-08-25 10:29:45', '2025-08-25 10:29:47'),
	(2407374, '176.227.64.154:38338', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"20:31:21","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":180,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:31:21"}', '2025-08-25 10:31:21', '2025-08-25 10:31:23'),
	(2407375, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003753, 29.224698, _binary 0x000000000101000000037ae1ce85393d404460f6fc7a804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"25.08.2025","sat":"20:32:51","ind":0,"enl":"41.0037533","boy":"029.224698","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43221.7,"yon":241,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:32:51"}', '2025-08-25 10:32:51', '2025-08-25 10:32:54'),
	(2407376, '176.238.15.246:5054', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"20:36:25","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":172,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:36:25"}', '2025-08-25 10:36:25', '2025-08-25 10:36:28'),
	(2407377, '31.143.219.198:35638', '86284304533376212', 40.992082, 28.905356, _binary 0x000000000101000000c53c2b69c5e73c40e43a7c88fc7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"25.08.2025","sat":"20:38:09","ind":0,"enl":"40.9920817","boy":"028.905356","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10953.7,"yon":204,"A":"4","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:38:09"}', '2025-08-25 10:38:09', '2025-08-25 10:38:11'),
	(2407378, '31.143.21.53:17428', '44fe033664dac2621', 41.012117, 29.050781, _binary 0x0000000001010000001842cefbff0c3d40231e3f0a8d814440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"25.08.2025","sat":"20:39:31","ind":0,"enl":"41.0121167","boy":"029.050781","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74647.3,"yon":139,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:39:31"}', '2025-08-25 10:39:31', '2025-08-25 10:39:32'),
	(2407379, '31.143.21.53:17428', '44fe033664dac2621', 41.012117, 29.050781, _binary 0x0000000001010000001842cefbff0c3d40231e3f0a8d814440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"25.08.2025","sat":"20:39:12","ind":0,"enl":"41.0121167","boy":"029.050781","drm":[1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74647.3,"yon":137,"A":"74","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:39:12"}', '2025-08-25 10:39:12', '2025-08-25 10:39:33'),
	(2407380, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"20:39:47","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:39:47"}', '2025-08-25 10:39:47', '2025-08-25 10:39:46'),
	(2407381, '178.240.194.65:21396', '350612079185623', 41.014947, 29.054153, _binary 0x00000000010100000071789cfddc0d3d40dc172bc5e9814440, '0', '{"device_model": "Teltonika", "p": "1", "did": "350612079185623", "trh": "2025-08-25", "sat": "20:39:23", "ind": 0, "enl": "41.0149466", "boy": "29.0541533", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 27279.236, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12693, "battery_voltage": 4057, "battery_current": 0, "record_timestamp": "2025-08-25 20:39:23", "codec_id": 8}', '2025-08-25 10:39:23', '2025-08-25 10:41:02'),
	(2407382, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997238, 29.074741, _binary 0x0000000001010000009babe63922133d40c9682e81a57f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"25.08.2025","sat":"20:43:29","ind":0,"enl":"40.9972383","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":243,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:43:29"}', '2025-08-25 10:43:29', '2025-08-25 10:43:31'),
	(2407383, '176.227.86.214:11997', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"20:44:34","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":340,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:44:34"}', '2025-08-25 10:44:34', '2025-08-25 10:44:35'),
	(2407384, '176.227.86.214:11997', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"20:46:48","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":137,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:46:48"}', '2025-08-25 10:46:48', '2025-08-25 10:46:51'),
	(2407385, '31.142.69.246:17347', '86090604649604512', 41.012618, 29.125513, _binary 0x0000000001010000000d39b69e21203d4062eaf8799d814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"25.08.2025","sat":"20:47:04","ind":0,"enl":"41.0126183","boy":"029.125513","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":208,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:47:04"}', '2025-08-25 10:47:04', '2025-08-25 10:47:05'),
	(2407386, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.011428, 29.051483, _binary 0x000000000101000000cb4c69fd2d0d3d40db5f877b76814440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"25.08.2025","sat":"20:49:42","ind":0,"enl":"41.0114283","boy":"029.051483","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43113.3,"yon":68,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:49:42"}', '2025-08-25 10:49:42', '2025-08-25 10:49:44'),
	(2407387, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"20:49:48","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:49:48"}', '2025-08-25 10:49:48', '2025-08-25 10:49:46'),
	(2407388, '31.142.69.246:17347', '86090604649604512', 41.012618, 29.125513, _binary 0x0000000001010000000d39b69e21203d4062eaf8799d814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"25.08.2025","sat":"20:53:36","ind":0,"enl":"41.0126183","boy":"029.125513","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":189,"A":"4","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:53:36"}', '2025-08-25 10:53:36', '2025-08-25 10:53:38'),
	(2407389, '188.57.75.103:34290', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"20:54:38","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":268,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:54:38"}', '2025-08-25 10:54:38', '2025-08-25 10:54:40'),
	(2407390, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"25.08.2025","sat":"20:57:17","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":52,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:57:17"}', '2025-08-25 10:57:17', '2025-08-25 10:57:20'),
	(2407391, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"25.08.2025","sat":"20:57:18","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":158,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:57:18"}', '2025-08-25 10:57:18', '2025-08-25 10:57:20'),
	(2407392, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003592, 29.078888, _binary 0x000000000101000000fe0b040132143d40be045db175804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"25.08.2025","sat":"20:57:37","ind":0,"enl":"41.0035917","boy":"029.078888","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94765.6,"yon":257,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:57:37"}', '2025-08-25 10:57:37', '2025-08-25 10:57:40'),
	(2407393, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"25.08.2025","sat":"20:58:52","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":149,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:58:52"}', '2025-08-25 10:58:52', '2025-08-25 10:58:55'),
	(2407394, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"20:59:47","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 20:59:47"}', '2025-08-25 10:59:47', '2025-08-25 10:59:46'),
	(2407395, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"21:00:23","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"21","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:00:23"}', '2025-08-25 11:00:23', '2025-08-25 11:00:22'),
	(2407396, '178.245.74.133:39593', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"21:00:43","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":13,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:00:43"}', '2025-08-25 11:00:43', '2025-08-25 11:00:59'),
	(2407397, '178.245.74.133:39593', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"21:02:15","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":216,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:02:15"}', '2025-08-25 11:02:15', '2025-08-25 11:02:35'),
	(2407398, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003753, 29.224698, _binary 0x000000000101000000037ae1ce85393d404460f6fc7a804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"25.08.2025","sat":"21:03:55","ind":0,"enl":"41.0037533","boy":"029.224698","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43221.7,"yon":183,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:03:55"}', '2025-08-25 11:03:55', '2025-08-25 11:03:58'),
	(2407399, '188.57.85.201:53771', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"21:03:57","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":39,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:03:57"}', '2025-08-25 11:03:57', '2025-08-25 11:03:58'),
	(2407400, '31.142.30.107:35025', '353201357563383', 40.997282, 29.048400, _binary 0x0000000001010000005c2041f1630c3d40877368eca67f4440, '0', '{"device_model": "Teltonika", "p": "1", "did": "353201357563383", "trh": "2025-08-25", "sat": "21:07:28", "ind": 0, "enl": "40.9972816", "boy": "29.0484", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 3.137, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12001, "battery_voltage": 0, "battery_current": 0, "record_timestamp": "2025-08-25 21:07:28", "codec_id": 8}', '2025-08-25 11:07:28', '2025-08-25 11:10:01'),
	(2407401, '31.143.219.198:35638', '86284304533376212', 40.992082, 28.905356, _binary 0x000000000101000000c53c2b69c5e73c40e43a7c88fc7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"25.08.2025","sat":"21:09:08","ind":0,"enl":"40.9920817","boy":"028.905356","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10953.7,"yon":121,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:09:08"}', '2025-08-25 11:09:08', '2025-08-25 11:09:10'),
	(2407402, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"21:10:22","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:10:22"}', '2025-08-25 11:10:22', '2025-08-25 11:10:21'),
	(2407403, '31.143.21.53:17428', '44fe033664dac2621', 41.012117, 29.050781, _binary 0x0000000001010000001842cefbff0c3d40231e3f0a8d814440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"25.08.2025","sat":"21:10:21","ind":0,"enl":"41.0121167","boy":"029.050781","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74647.3,"yon":35,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:10:21"}', '2025-08-25 11:10:21', '2025-08-25 11:10:22'),
	(2407404, '188.57.89.240:30656', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"21:14:22","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":155,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:14:22"}', '2025-08-25 11:14:22', '2025-08-25 11:14:24'),
	(2407405, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997238, 29.074741, _binary 0x0000000001010000009babe63922133d40c9682e81a57f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"25.08.2025","sat":"21:14:29","ind":0,"enl":"40.9972383","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":284,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:14:29"}', '2025-08-25 11:14:29', '2025-08-25 11:14:32'),
	(2407406, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"21:20:22","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:20:22"}', '2025-08-25 11:20:22', '2025-08-25 11:20:21'),
	(2407407, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.011808, 29.050980, _binary 0x00000000010100000005c078060d0d3d40222933ef82814440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"25.08.2025","sat":"21:20:45","ind":0,"enl":"41.0118083","boy":"029.050980","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43113.3,"yon":162,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:20:45"}', '2025-08-25 11:20:45', '2025-08-25 11:20:47'),
	(2407408, '31.143.161.121:14455', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"0","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"21:23:59","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":153,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:23:59"}', '2025-08-25 11:23:59', '2025-08-25 11:24:09'),
	(2407409, '31.142.69.246:17347', '86090604649604512', 41.012618, 29.125513, _binary 0x0000000001010000000d39b69e21203d4062eaf8799d814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"25.08.2025","sat":"21:24:44","ind":0,"enl":"41.0126183","boy":"029.125513","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":172,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:24:44"}', '2025-08-25 11:24:44', '2025-08-25 11:24:46'),
	(2407410, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"25.08.2025","sat":"21:28:19","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":13,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:28:19"}', '2025-08-25 11:28:19', '2025-08-25 11:28:22'),
	(2407411, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"25.08.2025","sat":"21:28:20","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":33,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:28:20"}', '2025-08-25 11:28:20', '2025-08-25 11:28:23'),
	(2407412, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003592, 29.078888, _binary 0x000000000101000000fe0b040132143d40be045db175804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"25.08.2025","sat":"21:28:41","ind":0,"enl":"41.0035917","boy":"029.078888","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94765.6,"yon":164,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:28:41"}', '2025-08-25 11:28:41', '2025-08-25 11:28:43'),
	(2407413, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"25.08.2025","sat":"21:29:56","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":138,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:29:56"}', '2025-08-25 11:29:56', '2025-08-25 11:29:58'),
	(2407414, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"21:30:22","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:30:22"}', '2025-08-25 11:30:22', '2025-08-25 11:30:21'),
	(2407415, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003753, 29.224698, _binary 0x000000000101000000037ae1ce85393d404460f6fc7a804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"25.08.2025","sat":"21:35:00","ind":0,"enl":"41.0037533","boy":"029.224698","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43221.7,"yon":176,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:35:00"}', '2025-08-25 11:35:00', '2025-08-25 11:35:03'),
	(2407416, '176.227.85.185:41737', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"21:37:41","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":334,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:37:41"}', '2025-08-25 11:37:41', '2025-08-25 11:37:43'),
	(2407417, '176.227.85.185:41737', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"21:33:08","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":325,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:33:08"}', '2025-08-25 11:33:08', '2025-08-25 11:37:44'),
	(2407418, '176.89.152.48:30665', '350612079185623', 41.014947, 29.054153, _binary 0x00000000010100000071789cfddc0d3d40dc172bc5e9814440, '0', '{"device_model": "Teltonika", "p": "1", "did": "350612079185623", "trh": "2025-08-25", "sat": "21:39:29", "ind": 0, "enl": "41.0149466", "boy": "29.0541533", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 27279.236, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12660, "battery_voltage": 4057, "battery_current": 0, "record_timestamp": "2025-08-25 21:39:29", "codec_id": 8}', '2025-08-25 11:39:29', '2025-08-25 11:41:01'),
	(2407419, '31.143.219.198:35638', '86284304533376212', 40.992082, 28.905356, _binary 0x000000000101000000c53c2b69c5e73c40e43a7c88fc7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"25.08.2025","sat":"21:40:09","ind":0,"enl":"40.9920817","boy":"028.905356","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10953.7,"yon":117,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:40:09"}', '2025-08-25 11:40:09', '2025-08-25 11:40:11'),
	(2407420, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"21:40:23","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:40:23"}', '2025-08-25 11:40:23', '2025-08-25 11:40:21'),
	(2407421, '31.143.21.53:17428', '44fe033664dac2621', 41.012117, 29.050781, _binary 0x0000000001010000001842cefbff0c3d40231e3f0a8d814440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"25.08.2025","sat":"21:41:30","ind":0,"enl":"41.0121167","boy":"029.050781","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74647.3,"yon":68,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:41:30"}', '2025-08-25 11:41:30', '2025-08-25 11:41:31'),
	(2407422, '176.238.9.114:30027', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"21:44:22","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":121,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:44:22"}', '2025-08-25 11:44:22', '2025-08-25 11:44:23'),
	(2407423, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997238, 29.074741, _binary 0x0000000001010000009babe63922133d40c9682e81a57f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"25.08.2025","sat":"21:45:30","ind":0,"enl":"40.9972383","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":279,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:45:30"}', '2025-08-25 11:45:30', '2025-08-25 11:45:33'),
	(2407424, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"21:50:23","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:50:23"}', '2025-08-25 11:50:23', '2025-08-25 11:50:21'),
	(2407425, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.011808, 29.050980, _binary 0x00000000010100000005c078060d0d3d40222933ef82814440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"25.08.2025","sat":"21:51:48","ind":0,"enl":"41.0118083","boy":"029.050980","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43113.3,"yon":4,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:51:48"}', '2025-08-25 11:51:48', '2025-08-25 11:51:50'),
	(2407426, '31.142.69.246:17347', '86090604649604512', 41.012618, 29.125513, _binary 0x0000000001010000000d39b69e21203d4062eaf8799d814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"25.08.2025","sat":"21:55:52","ind":0,"enl":"41.0126183","boy":"029.125513","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":77,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:55:52"}', '2025-08-25 11:55:52', '2025-08-25 11:55:54'),
	(2407427, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"25.08.2025","sat":"21:59:23","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":159,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:59:23"}', '2025-08-25 11:59:23', '2025-08-25 11:59:25'),
	(2407428, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"25.08.2025","sat":"21:59:23","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":118,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:59:23"}', '2025-08-25 11:59:23', '2025-08-25 11:59:25'),
	(2407429, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003660, 29.079390, _binary 0x00000000010100000023a12de752143d40d5264eee77804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"25.08.2025","sat":"21:59:44","ind":0,"enl":"41.0036600","boy":"029.079390","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94765.6,"yon":335,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:59:44"}', '2025-08-25 11:59:44', '2025-08-25 11:59:47'),
	(2407430, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"22:00:23","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:00:23"}', '2025-08-25 12:00:23', '2025-08-25 12:00:22'),
	(2407431, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"22:00:59","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"21","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:00:59"}', '2025-08-25 12:00:59', '2025-08-25 12:00:57'),
	(2407432, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"25.08.2025","sat":"22:01:00","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":216,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:01:00"}', '2025-08-25 12:01:00', '2025-08-25 12:01:03'),
	(2407433, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003753, 29.224698, _binary 0x000000000101000000037ae1ce85393d404460f6fc7a804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"25.08.2025","sat":"22:06:05","ind":0,"enl":"41.0037533","boy":"029.224698","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43221.7,"yon":202,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:06:05"}', '2025-08-25 12:06:05', '2025-08-25 12:06:08'),
	(2407434, '31.141.80.138:43351', '353201357563383', 40.997282, 29.048400, _binary 0x0000000001010000005c2041f1630c3d40877368eca67f4440, '0', '{"device_model": "Teltonika", "p": "1", "did": "353201357563383", "trh": "2025-08-25", "sat": "22:07:28", "ind": 0, "enl": "40.9972816", "boy": "29.0484", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 3.137, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12001, "battery_voltage": 0, "battery_current": 0, "record_timestamp": "2025-08-25 22:07:28", "codec_id": 8}', '2025-08-25 12:07:28', '2025-08-25 12:09:02'),
	(2407435, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"22:11:00","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:11:00"}', '2025-08-25 12:11:00', '2025-08-25 12:10:58'),
	(2407436, '31.143.219.198:35638', '86284304533376212', 40.992082, 28.905356, _binary 0x000000000101000000c53c2b69c5e73c40e43a7c88fc7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"25.08.2025","sat":"22:11:10","ind":0,"enl":"40.9920817","boy":"028.905356","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10953.7,"yon":308,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:11:10"}', '2025-08-25 12:11:10', '2025-08-25 12:11:13'),
	(2407437, '31.143.21.53:17428', '44fe033664dac2621', 41.012117, 29.050781, _binary 0x0000000001010000001842cefbff0c3d40231e3f0a8d814440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"25.08.2025","sat":"22:12:39","ind":0,"enl":"41.0121167","boy":"029.050781","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74647.3,"yon":75,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:12:39"}', '2025-08-25 12:12:39', '2025-08-25 12:12:40'),
	(2407438, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997238, 29.074741, _binary 0x0000000001010000009babe63922133d40c9682e81a57f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"25.08.2025","sat":"22:16:32","ind":0,"enl":"40.9972383","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":191,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:16:32"}', '2025-08-25 12:16:32', '2025-08-25 12:16:34'),
	(2407439, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"22:21:00","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:21:00"}', '2025-08-25 12:21:00', '2025-08-25 12:20:58'),
	(2407440, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.011808, 29.050980, _binary 0x00000000010100000005c078060d0d3d40222933ef82814440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"25.08.2025","sat":"22:22:53","ind":0,"enl":"41.0118083","boy":"029.050980","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43113.3,"yon":144,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:22:53"}', '2025-08-25 12:22:53', '2025-08-25 12:22:54'),
	(2407441, '31.142.69.246:17347', '86090604649604512', 41.012618, 29.125513, _binary 0x0000000001010000000d39b69e21203d4062eaf8799d814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"25.08.2025","sat":"22:27:01","ind":0,"enl":"41.0126183","boy":"029.125513","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":177,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:27:01"}', '2025-08-25 12:27:01', '2025-08-25 12:27:03'),
	(2407442, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"25.08.2025","sat":"22:30:25","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":210,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:30:25"}', '2025-08-25 12:30:25', '2025-08-25 12:30:28'),
	(2407443, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"25.08.2025","sat":"22:30:25","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":103,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:30:25"}', '2025-08-25 12:30:25', '2025-08-25 12:30:28'),
	(2407444, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003660, 29.079390, _binary 0x00000000010100000023a12de752143d40d5264eee77804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"25.08.2025","sat":"22:30:48","ind":0,"enl":"41.0036600","boy":"029.079390","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94765.6,"yon":265,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:30:48"}', '2025-08-25 12:30:48', '2025-08-25 12:30:50'),
	(2407445, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"22:31:00","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:31:00"}', '2025-08-25 12:31:00', '2025-08-25 12:30:58'),
	(2407446, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"25.08.2025","sat":"22:32:04","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":179,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:32:04"}', '2025-08-25 12:32:04', '2025-08-25 12:32:07'),
	(2407447, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003753, 29.224698, _binary 0x000000000101000000037ae1ce85393d404460f6fc7a804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"25.08.2025","sat":"22:37:10","ind":0,"enl":"41.0037533","boy":"029.224698","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43221.7,"yon":313,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:37:10"}', '2025-08-25 12:37:10', '2025-08-25 12:37:13'),
	(2407448, '31.142.62.8:47898', '350612079185623', 41.014947, 29.054153, _binary 0x00000000010100000071789cfddc0d3d40dc172bc5e9814440, '0', '{"device_model": "Teltonika", "p": "1", "did": "350612079185623", "trh": "2025-08-25", "sat": "22:39:35", "ind": 0, "enl": "41.0149466", "boy": "29.0541533", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 27279.236, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12660, "battery_voltage": 4057, "battery_current": 0, "record_timestamp": "2025-08-25 22:39:35", "codec_id": 8}', '2025-08-25 12:39:35', '2025-08-25 12:41:02'),
	(2407449, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"22:41:01","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:41:01"}', '2025-08-25 12:41:01', '2025-08-25 12:40:58'),
	(2407450, '31.143.219.198:35638', '86284304533376212', 40.992082, 28.905356, _binary 0x000000000101000000c53c2b69c5e73c40e43a7c88fc7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"25.08.2025","sat":"22:42:11","ind":0,"enl":"40.9920817","boy":"028.905356","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10953.7,"yon":239,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:42:11"}', '2025-08-25 12:42:11', '2025-08-25 12:42:14'),
	(2407451, '31.143.21.53:17428', '44fe033664dac2621', 41.012117, 29.050781, _binary 0x0000000001010000001842cefbff0c3d40231e3f0a8d814440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"25.08.2025","sat":"22:43:47","ind":0,"enl":"41.0121167","boy":"029.050781","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74647.3,"yon":38,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:43:47"}', '2025-08-25 12:43:47', '2025-08-25 12:43:48'),
	(2407452, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.430927, 29.713276, _binary 0x0000000001010000008e05854199b63d4092bc299b28374440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:46:28","ind":0,"enl":"40.4309267","boy":"029.713276","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":40.00320000000001,"mes":47446.9,"yon":9,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:46:28"}', '2025-08-25 12:46:28', '2025-08-25 12:46:29'),
	(2407453, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"21:48:34","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":157,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 21:48:34"}', '2025-08-25 11:48:34', '2025-08-25 12:46:30'),
	(2407454, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:04:00","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":97,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:04:00"}', '2025-08-25 12:04:00', '2025-08-25 12:46:31'),
	(2407455, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:19:26","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":324,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:19:26"}', '2025-08-25 12:19:26', '2025-08-25 12:46:32'),
	(2407456, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:34:51","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":285,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:34:51"}', '2025-08-25 12:34:51', '2025-08-25 12:46:33'),
	(2407457, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.427410, 29.712318, _binary 0x000000000101000000255af2785ab63d40dffdf15eb5364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:44:41","ind":0,"enl":"40.4274100","boy":"029.712318","drm":[1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":0,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 22:44:41"}', '2025-08-25 12:44:41', '2025-08-25 12:46:33'),
	(2407458, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.427653, 29.712288, _binary 0x0000000001010000005055a18158b63d4064c3e457bd364440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:45:42","ind":0,"enl":"40.4276533","boy":"029.712288","drm":[1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0],"hiz":21.50172,"mes":47446.5,"yon":57,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:45:42"}', '2025-08-25 12:45:42', '2025-08-25 12:46:34'),
	(2407459, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 0.000000, 0.000000, _binary 0x00000000010100000000000000000000000000000000000000, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:45:47","ind":8,"enl":"00.0000000","boy":"000.000000","drm":[1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47446.5,"yon":0,"A":"77","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 22:45:47"}', '2025-08-25 12:45:47', '2025-08-25 12:46:35'),
	(2407460, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.432730, 29.713965, _binary 0x000000000101000000187d0569c6b63d40c1ff56b263374440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:46:48","ind":0,"enl":"40.4327300","boy":"029.713965","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":28.74304,"mes":47447.1,"yon":29,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:46:48"}', '2025-08-25 12:46:48', '2025-08-25 12:46:50'),
	(2407461, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997238, 29.074741, _binary 0x0000000001010000009babe63922133d40c9682e81a57f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"25.08.2025","sat":"22:47:34","ind":0,"enl":"40.9972383","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":53,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:47:34"}', '2025-08-25 12:47:34', '2025-08-25 12:47:36'),
	(2407462, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.436517, 29.716915, _binary 0x0000000001010000000803cfbd87b73d4034547bc7df374440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:47:42","ind":0,"enl":"40.4365167","boy":"029.716915","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":39.818000000000005,"mes":47447.5,"yon":2,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:47:42"}', '2025-08-25 12:47:42', '2025-08-25 12:47:43'),
	(2407463, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.441047, 29.716646, _binary 0x00000000010100000029cfbc1c76b73d401e41e03774384440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:48:39","ind":0,"enl":"40.4410467","boy":"029.716646","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":25.853920000000002,"mes":47448.1,"yon":356,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:48:39"}', '2025-08-25 12:48:39', '2025-08-25 12:48:41'),
	(2407464, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.444953, 29.715561, _binary 0x000000000101000000064b75012fb73d40a7dfcf3af4384440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:49:39","ind":0,"enl":"40.4449533","boy":"029.715561","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":51.96712,"mes":47448.6,"yon":334,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:49:39"}', '2025-08-25 12:49:39', '2025-08-25 12:49:41'),
	(2407465, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.449000, 29.713293, _binary 0x0000000001010000003a77bb5e9ab63d40b6f3fdd478394440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:50:23","ind":0,"enl":"40.4490000","boy":"029.713293","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":18.779280000000004,"mes":47449.2,"yon":28,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:50:23"}', '2025-08-25 12:50:23', '2025-08-25 12:50:25'),
	(2407466, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"22:51:01","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:51:01"}', '2025-08-25 12:51:01', '2025-08-25 12:50:58'),
	(2407467, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.451622, 29.708328, _binary 0x00000000010100000052d7dafb54b53d40fbd467bdce394440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:51:10","ind":0,"enl":"40.4516217","boy":"029.708328","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":58.50468,"mes":47449.6,"yon":302,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:51:10"}', '2025-08-25 12:51:10', '2025-08-25 12:51:11'),
	(2407468, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.454233, 29.703275, _binary 0x0000000001010000002b1895d409b43d4088201851243a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:51:36","ind":0,"enl":"40.4542333","boy":"029.703275","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":73.11695999999999,"mes":47450.2,"yon":304,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:51:36"}', '2025-08-25 12:51:36', '2025-08-25 12:51:38'),
	(2407469, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.456975, 29.698071, _binary 0x0000000001010000003849f3c7b4b23d40780b24287e3a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:52:03","ind":0,"enl":"40.4569750","boy":"029.698071","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":68.83884,"mes":47450.7,"yon":304,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:52:03"}', '2025-08-25 12:52:03', '2025-08-25 12:52:05'),
	(2407470, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.459800, 29.692918, _binary 0x0000000001010000004acff41263b13d40b459f5b9da3a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:52:32","ind":0,"enl":"40.4598000","boy":"029.692918","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":68.59808,"mes":47451.2,"yon":305,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:52:32"}', '2025-08-25 12:52:32', '2025-08-25 12:52:34'),
	(2407471, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.462680, 29.687646, _binary 0x000000000101000000a839799109b03d40b3412619393b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:53:00","ind":0,"enl":"40.4626800","boy":"029.687646","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":75.78384000000001,"mes":47451.7,"yon":305,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:53:00"}', '2025-08-25 12:53:00', '2025-08-25 12:53:02'),
	(2407472, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.465563, 29.682356, _binary 0x000000000101000000b83a00e2aeae3d40e2db0594973b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:53:26","ind":0,"enl":"40.4655633","boy":"029.682356","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":69.61668000000002,"mes":47452.3,"yon":305,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:53:26"}', '2025-08-25 12:53:26', '2025-08-25 12:53:27'),
	(2407473, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.468285, 29.677285, _binary 0x0000000001010000004512bd8c62ad3d408b1a4cc3f03b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:53:52","ind":0,"enl":"40.4682850","boy":"029.677285","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":76.65428,"mes":47452.8,"yon":301,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:53:52"}', '2025-08-25 12:53:52', '2025-08-25 12:53:54'),
	(2407474, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.011808, 29.050980, _binary 0x00000000010100000005c078060d0d3d40222933ef82814440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"25.08.2025","sat":"22:53:56","ind":0,"enl":"41.0118083","boy":"029.050980","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43113.3,"yon":265,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:53:56"}', '2025-08-25 12:53:56', '2025-08-25 12:53:57'),
	(2407475, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.469028, 29.671085, _binary 0x0000000001010000000fd6ff39ccab3d4001b38c1e093c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:54:18","ind":0,"enl":"40.4690283","boy":"029.671085","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":75.52456000000001,"mes":47453.3,"yon":279,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:54:18"}', '2025-08-25 12:54:18', '2025-08-25 12:54:19'),
	(2407476, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.468013, 29.665116, _binary 0x000000000101000000dd0bcc0a45aa3d40e9cb1cdce73b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:54:50","ind":0,"enl":"40.4680133","boy":"029.665116","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":57.0416,"mes":47453.9,"yon":286,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:54:50"}', '2025-08-25 12:54:50', '2025-08-25 12:54:52'),
	(2407477, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.471225, 29.661288, _binary 0x000000000101000000bc3c9d2b4aa93d405f07ce19513c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:55:34","ind":0,"enl":"40.4712250","boy":"029.661288","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":39.11424,"mes":47454.4,"yon":3,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:55:34"}', '2025-08-25 12:55:34', '2025-08-25 12:55:36'),
	(2407478, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.475812, 29.662131, _binary 0x000000000101000000f3aace6a81a93d40ef46d565e73c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:56:22","ind":0,"enl":"40.4758117","boy":"029.662131","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":40.336560000000006,"mes":47454.8,"yon":6,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:56:22"}', '2025-08-25 12:56:22', '2025-08-25 12:56:24'),
	(2407479, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.480685, 29.662055, _binary 0x0000000001010000003d27bd6f7ca93d40c1560916873d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:57:05","ind":0,"enl":"40.4806850","boy":"029.662055","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":54.559920000000005,"mes":47455.4,"yon":334,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:57:05"}', '2025-08-25 12:57:05', '2025-08-25 12:57:07'),
	(2407480, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.484558, 29.658400, _binary 0x000000000101000000b8af03e78ca83d40b0c0a101063e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:57:38","ind":0,"enl":"40.4845583","boy":"029.658400","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":58.28244,"mes":47456,"yon":321,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:57:38"}', '2025-08-25 12:57:38', '2025-08-25 12:57:39'),
	(2407481, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.487475, 29.653725, _binary 0x000000000101000000de9387855aa73d400e4faf94653e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:58:08","ind":0,"enl":"40.4874750","boy":"029.653725","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":73.20956000000001,"mes":47456.5,"yon":299,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:58:08"}', '2025-08-25 12:58:08', '2025-08-25 12:58:10'),
	(2407482, '31.142.69.246:17347', '86090604649604512', 41.012618, 29.125513, _binary 0x0000000001010000000d39b69e21203d4062eaf8799d814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"25.08.2025","sat":"22:58:10","ind":0,"enl":"41.0126183","boy":"029.125513","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":266,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 22:58:10"}', '2025-08-25 12:58:10', '2025-08-25 12:58:11'),
	(2407483, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.487820, 29.652806, _binary 0x000000000101000000f1a1444b1ea73d40d82ac1e2703e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:58:12","ind":0,"enl":"40.4878200","boy":"029.652806","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":82.87700000000001,"mes":47456.6,"yon":293,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:58:12"}', '2025-08-25 12:58:12', '2025-08-25 12:58:14'),
	(2407484, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.488985, 29.648163, _binary 0x0000000001010000002d7aa702eea53d40069e7b0f973e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:58:29","ind":0,"enl":"40.4889850","boy":"029.648163","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":74.48744,"mes":47456.9,"yon":274,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:58:29"}', '2025-08-25 12:58:29', '2025-08-25 12:58:30'),
	(2407485, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.489885, 29.645826, _binary 0x00000000010100000010e84cda54a53d4086e63a8db43e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:58:40","ind":0,"enl":"40.4898850","boy":"029.645826","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":81.00648000000001,"mes":47457.2,"yon":301,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:58:40"}', '2025-08-25 12:58:40', '2025-08-25 12:58:42'),
	(2407486, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.491898, 29.639895, _binary 0x000000000101000000b9dfa128d0a33d40a0ba0386f63e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:03","ind":0,"enl":"40.4918983","boy":"029.639895","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":82.1362,"mes":47457.7,"yon":293,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:03"}', '2025-08-25 12:59:03', '2025-08-25 12:59:05'),
	(2407487, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.492048, 29.639405, _binary 0x0000000001010000001de6cb0bb0a33d40b5464e70fb3e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:05","ind":0,"enl":"40.4920483","boy":"029.639405","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.59895999999999,"mes":47457.7,"yon":289,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:05"}', '2025-08-25 12:59:05', '2025-08-25 12:59:08'),
	(2407488, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.492157, 29.638900, _binary 0x000000000101000000166a4df38ea33d40ef80a1fdfe3e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:07","ind":0,"enl":"40.4921567","boy":"029.638900","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.562,"mes":47457.8,"yon":283,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:07"}', '2025-08-25 12:59:07', '2025-08-25 12:59:09'),
	(2407489, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.492198, 29.638638, _binary 0x0000000001010000009cfbabc77da33d40cad2985a003f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:08","ind":0,"enl":"40.4921983","boy":"029.638638","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.33968000000002,"mes":47457.8,"yon":280,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:08"}', '2025-08-25 12:59:08', '2025-08-25 12:59:10'),
	(2407490, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.492235, 29.638370, _binary 0x0000000001010000005dbf60376ca33d402979758e013f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:09","ind":0,"enl":"40.4922350","boy":"029.638370","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":83.04368000000001,"mes":47457.8,"yon":280,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:09"}', '2025-08-25 12:59:09', '2025-08-25 12:59:11'),
	(2407491, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.492505, 29.635675, _binary 0x00000000010100000082e2c798bba23d40e90e62670a3f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:19","ind":0,"enl":"40.4925050","boy":"029.635675","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.8212,"mes":47458.1,"yon":272,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:19"}', '2025-08-25 12:59:19', '2025-08-25 12:59:21'),
	(2407492, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.492510, 29.635416, _binary 0x000000000101000000ea5a7b9faaa23d40fb7953910a3f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:20","ind":0,"enl":"40.4925100","boy":"029.635416","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.39532,"mes":47458.1,"yon":270,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:20"}', '2025-08-25 12:59:20', '2025-08-25 12:59:22'),
	(2407493, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.492467, 29.633803, _binary 0x000000000101000000501bd5e940a23d403d6f1926093f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:26","ind":0,"enl":"40.4924667","boy":"029.633803","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.74712000000001,"mes":47458.2,"yon":270,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:26"}', '2025-08-25 12:59:26', '2025-08-25 12:59:27'),
	(2407494, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.492490, 29.633271, _binary 0x00000000010100000056815a0c1ea23d40b3cd8de9093f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:28","ind":0,"enl":"40.4924900","boy":"029.633271","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.15456,"mes":47458.3,"yon":276,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:28"}', '2025-08-25 12:59:28', '2025-08-25 12:59:30'),
	(2407495, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.492563, 29.632753, _binary 0x0000000001010000002672c119fca13d40dc5a70500c3f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:30","ind":0,"enl":"40.4925633","boy":"029.632753","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.00640000000001,"mes":47458.3,"yon":284,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:30"}', '2025-08-25 12:59:30', '2025-08-25 12:59:32'),
	(2407496, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.492680, 29.632255, _binary 0x00000000010100000084bbb376dba13d4057b26323103f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:32","ind":0,"enl":"40.4926800","boy":"029.632255","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.11752,"mes":47458.4,"yon":287,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:32"}', '2025-08-25 12:59:32', '2025-08-25 12:59:33'),
	(2407497, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.492742, 29.632016, _binary 0x0000000001010000007a8cf2cccba13d400f70f728123f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:33","ind":0,"enl":"40.4927417","boy":"029.632016","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":76.04312,"mes":47458.4,"yon":287,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:33"}', '2025-08-25 12:59:33', '2025-08-25 12:59:34'),
	(2407498, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.493565, 29.629160, _binary 0x0000000001010000008cf337a110a13d40a1b94e232d3f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:45","ind":0,"enl":"40.4935650","boy":"029.629160","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.46940000000001,"mes":47458.7,"yon":290,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:45"}', '2025-08-25 12:59:45', '2025-08-25 12:59:47'),
	(2407499, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.494185, 29.626313, _binary 0x000000000101000000450f7c0c56a03d403e963e74413f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:56","ind":0,"enl":"40.4941850","boy":"029.626313","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.9138,"mes":47458.9,"yon":281,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:56"}', '2025-08-25 12:59:56', '2025-08-25 12:59:57'),
	(2407500, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.494250, 29.625798, _binary 0x000000000101000000f7e6374c34a03d4025068195433f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:58","ind":0,"enl":"40.4942500","boy":"029.625798","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.21012,"mes":47458.9,"yon":277,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:58"}', '2025-08-25 12:59:58', '2025-08-25 12:59:59'),
	(2407501, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.494272, 29.625535, _binary 0x000000000101000000dc80cf0f23a03d404e6b894b443f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"22:59:59","ind":0,"enl":"40.4942717","boy":"029.625535","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.59895999999999,"mes":47459,"yon":274,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 22:59:59"}', '2025-08-25 12:59:59', '2025-08-25 13:00:00'),
	(2407502, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.494280, 29.624990, _binary 0x000000000101000000b9533a58ff9f3d4090882991443f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:00:01","ind":0,"enl":"40.4942800","boy":"029.624990","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":85.08088,"mes":47459,"yon":270,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:00:01"}', '2025-08-25 13:00:01', '2025-08-25 13:00:03'),
	(2407503, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.493822, 29.618338, _binary 0x000000000101000000c2df2f664b9e3d400ec7a98c353f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:00:24","ind":0,"enl":"40.4938217","boy":"029.618338","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":89.34048000000001,"mes":47459.6,"yon":257,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:00:24"}', '2025-08-25 13:00:24', '2025-08-25 13:00:25'),
	(2407504, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.493528, 29.614905, _binary 0x0000000001010000009a25016a6a9d3d40431372ef2b3f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:00:36","ind":0,"enl":"40.4935283","boy":"029.614905","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":77.37656000000001,"mes":47459.8,"yon":266,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:00:36"}', '2025-08-25 13:00:36', '2025-08-25 13:00:38'),
	(2407505, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"23:01:01","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:01:01"}', '2025-08-25 13:01:01', '2025-08-25 13:00:59'),
	(2407506, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.492032, 29.608801, _binary 0x000000000101000000a8c5e061da9b3d40320c0ee5fa3e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:01:04","ind":0,"enl":"40.4920317","boy":"029.608801","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":79.32116,"mes":47460.4,"yon":238,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:01:04"}', '2025-08-25 13:01:04', '2025-08-25 13:01:05'),
	(2407507, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.491752, 29.608151, _binary 0x0000000001010000009a07b0c8af9b3d404fa03eb8f13e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:01:07","ind":0,"enl":"40.4917517","boy":"029.608151","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.98796,"mes":47460.4,"yon":241,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:01:07"}', '2025-08-25 13:01:07', '2025-08-25 13:01:09'),
	(2407508, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.490910, 29.606021, _binary 0x00000000010100000070b03731249b3d40c2a38d23d63e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:01:16","ind":0,"enl":"40.4909100","boy":"029.606021","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.74712000000001,"mes":47460.6,"yon":243,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:01:16"}', '2025-08-25 13:01:16', '2025-08-25 13:01:18'),
	(2407509, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"25.08.2025","sat":"23:01:27","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":316,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:01:27"}', '2025-08-25 13:01:27', '2025-08-25 13:01:30'),
	(2407510, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"25.08.2025","sat":"23:01:28","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":168,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:01:28"}', '2025-08-25 13:01:28', '2025-08-25 13:01:30'),
	(2407511, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"23:01:36","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"21","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:01:36"}', '2025-08-25 13:01:36', '2025-08-25 13:01:34'),
	(2407512, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.489368, 29.601471, _binary 0x0000000001010000000f7ee200fa993d407d19d69ea33e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:01:36","ind":0,"enl":"40.4893683","boy":"029.601471","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.17308,"mes":47461.1,"yon":247,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:01:36"}', '2025-08-25 13:01:36', '2025-08-25 13:01:37'),
	(2407513, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003660, 29.079390, _binary 0x00000000010100000023a12de752143d40d5264eee77804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"25.08.2025","sat":"23:01:50","ind":0,"enl":"41.0036600","boy":"029.079390","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94765.6,"yon":302,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:01:50"}', '2025-08-25 13:01:50', '2025-08-25 13:01:53'),
	(2407514, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.488088, 29.597660, _binary 0x0000000001010000009b20ea3e00993d40b6076bad793e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:01:51","ind":0,"enl":"40.4880883","boy":"029.597660","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.22856,"mes":47461.4,"yon":249,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:01:51"}', '2025-08-25 13:01:51', '2025-08-25 13:01:53'),
	(2407515, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.486882, 29.593200, _binary 0x000000000101000000b9fc87f4db973d40ac42b923523e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:02:11","ind":0,"enl":"40.4868817","boy":"029.593200","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.69164,"mes":47461.8,"yon":277,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:02:11"}', '2025-08-25 13:02:11', '2025-08-25 13:02:14'),
	(2407516, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.487012, 29.592436, _binary 0x0000000001010000001af9bce2a9973d407a223e66563e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:02:14","ind":0,"enl":"40.4870117","boy":"029.592436","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":76.89504000000001,"mes":47461.9,"yon":283,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:02:14"}', '2025-08-25 13:02:14', '2025-08-25 13:02:15'),
	(2407517, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.489123, 29.586818, _binary 0x00000000010100000042b456b439963d40169ba0979b3e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:02:41","ind":0,"enl":"40.4891233","boy":"029.586818","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":72.00576000000001,"mes":47462.4,"yon":318,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:02:41"}', '2025-08-25 13:02:41', '2025-08-25 13:02:42'),
	(2407518, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.490128, 29.580946, _binary 0x000000000101000000f5bd86e0b8943d400bac2d86bc3e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:03:09","ind":0,"enl":"40.4901283","boy":"029.580946","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":58.801,"mes":47462.9,"yon":255,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:03:09"}', '2025-08-25 13:03:09', '2025-08-25 13:03:11'),
	(2407519, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"25.08.2025","sat":"23:03:09","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":125,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:03:09"}', '2025-08-25 13:03:09', '2025-08-25 13:03:11'),
	(2407520, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.488415, 29.575156, _binary 0x0000000001010000002219726c3d933d401cf0f961843e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:03:38","ind":0,"enl":"40.4884150","boy":"029.575156","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":64.89408,"mes":47463.4,"yon":237,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:03:38"}', '2025-08-25 13:03:38', '2025-08-25 13:03:40'),
	(2407521, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.485633, 29.569960, _binary 0x000000000101000000350708e6e8913d409eac623b293e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:04:08","ind":0,"enl":"40.4856333","boy":"029.569960","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":59.68996,"mes":47464,"yon":231,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:04:08"}', '2025-08-25 13:04:08', '2025-08-25 13:04:10'),
	(2407522, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.483887, 29.564525, _binary 0x0000000001010000003fc6dcb584903d4014bcd7ffef3d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:04:43","ind":0,"enl":"40.4838867","boy":"029.564525","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":46.61484000000001,"mes":47464.4,"yon":292,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:04:43"}', '2025-08-25 13:04:43', '2025-08-25 13:04:44'),
	(2407523, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.482845, 29.559078, _binary 0x000000000101000000c0e95dbc1f8f3d40c0046eddcd3d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:05:23","ind":0,"enl":"40.4828450","boy":"029.559078","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":51.33744,"mes":47465,"yon":239,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:05:23"}', '2025-08-25 13:05:23', '2025-08-25 13:05:25'),
	(2407524, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.483513, 29.553501, _binary 0x000000000101000000a54dd53db28d3d402c5789c3e33d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:06:02","ind":0,"enl":"40.4835133","boy":"029.553501","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":46.818560000000005,"mes":47465.5,"yon":296,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:06:02"}', '2025-08-25 13:06:02', '2025-08-25 13:06:16'),
	(2407525, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.484252, 29.547440, _binary 0x000000000101000000b2852007258c3d402644aff5fb3d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:06:39","ind":0,"enl":"40.4842517","boy":"029.547440","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":62.37536,"mes":47466.1,"yon":267,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:06:39"}', '2025-08-25 13:06:39', '2025-08-25 13:06:41'),
	(2407526, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.484005, 29.540873, _binary 0x000000000101000000174a26a7768a3d40dd0c37e0f33d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:07:06","ind":0,"enl":"40.4840050","boy":"029.540873","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":76.63576,"mes":47466.6,"yon":266,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:07:06"}', '2025-08-25 13:07:06', '2025-08-25 13:07:08'),
	(2407527, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.483848, 29.534391, _binary 0x000000000101000000d8463cd9cd883d40d35cb8bdee3d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:07:32","ind":0,"enl":"40.4838483","boy":"029.534391","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":72.46876,"mes":47467.1,"yon":277,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:07:32"}', '2025-08-25 13:07:32', '2025-08-25 13:07:33'),
	(2407528, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.484212, 29.527898, _binary 0x000000000101000000b29fc55224873d4098eb23a6fa3d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:07:59","ind":0,"enl":"40.4842117","boy":"029.527898","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":78.74704000000001,"mes":47467.7,"yon":268,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:07:59"}', '2025-08-25 13:07:59', '2025-08-25 13:08:01'),
	(2407529, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.484182, 29.526898, _binary 0x000000000101000000eb538ec9e2863d402d697baaf93d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:08:03","ind":0,"enl":"40.4841817","boy":"029.526898","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.30272000000001,"mes":47467.8,"yon":268,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:08:03"}', '2025-08-25 13:08:03', '2025-08-25 13:08:05'),
	(2407530, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.484183, 29.526653, _binary 0x0000000001010000001d5723bbd2863d407a62e7b7f93d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:08:04","ind":0,"enl":"40.4841833","boy":"029.526653","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.63600000000001,"mes":47467.8,"yon":268,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:08:04"}', '2025-08-25 13:08:04', '2025-08-25 13:08:05'),
	(2407531, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003753, 29.224698, _binary 0x000000000101000000037ae1ce85393d404460f6fc7a804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"25.08.2025","sat":"23:08:16","ind":0,"enl":"41.0037533","boy":"029.224698","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43221.7,"yon":161,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:08:16"}', '2025-08-25 13:08:16', '2025-08-25 13:08:18'),
	(2407532, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.484282, 29.520273, _binary 0x000000000101000000e7fd7f9c30853d4090c657f1fc3d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:08:31","ind":0,"enl":"40.4842817","boy":"029.520273","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":60.50484000000001,"mes":47468.3,"yon":271,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:08:31"}', '2025-08-25 13:08:31', '2025-08-25 13:08:33'),
	(2407533, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.484280, 29.514073, _binary 0x000000000101000000b1c1c2499a833d40ae0d15e3fc3d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:08:59","ind":0,"enl":"40.4842800","boy":"029.514073","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":68.19064,"mes":47468.8,"yon":269,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:08:59"}', '2025-08-25 13:08:59', '2025-08-25 13:09:01'),
	(2407534, '178.240.181.127:30227', '353201357563383', 40.997282, 29.048400, _binary 0x0000000001010000005c2041f1630c3d40877368eca67f4440, '0', '{"device_model": "Teltonika", "p": "1", "did": "353201357563383", "trh": "2025-08-25", "sat": "23:07:28", "ind": 0, "enl": "40.9972816", "boy": "29.0484", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 3.137, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12001, "battery_voltage": 0, "battery_current": 0, "record_timestamp": "2025-08-25 23:07:28", "codec_id": 8}', '2025-08-25 13:07:28', '2025-08-25 13:10:01'),
	(2407535, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.485443, 29.507841, _binary 0x000000000101000000649126de01823d40fac78c01233e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:09:26","ind":0,"enl":"40.4854433","boy":"029.507841","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":77.39508000000001,"mes":47469.3,"yon":294,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:09:26"}', '2025-08-25 13:09:26', '2025-08-25 13:09:31'),
	(2407536, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.487457, 29.501981, _binary 0x000000000101000000a036aad381803d40a95b2cfb643e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:09:52","ind":0,"enl":"40.4874567","boy":"029.501981","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":75.3764,"mes":47469.9,"yon":294,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:09:52"}', '2025-08-25 13:09:52', '2025-08-25 13:09:55'),
	(2407537, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.489460, 29.496068, _binary 0x0000000001010000009697fc4ffe7e3d409f5912a0a63e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:10:18","ind":0,"enl":"40.4894600","boy":"029.496068","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":75.17268000000001,"mes":47470.5,"yon":293,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:10:18"}', '2025-08-25 13:10:18', '2025-08-25 13:10:20'),
	(2407538, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.491503, 29.490138, _binary 0x000000000101000000e08618af797d3d4023b08394e93e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:10:44","ind":0,"enl":"40.4915033","boy":"029.490138","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":77.19136,"mes":47470.9,"yon":294,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:10:44"}', '2025-08-25 13:10:44', '2025-08-25 13:10:45'),
	(2407539, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.493465, 29.484376, _binary 0x000000000101000000a1f7c610007c3d403e5c72dc293f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:11:09","ind":0,"enl":"40.4934650","boy":"029.484376","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":78.11736,"mes":47471.5,"yon":295,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:11:09"}', '2025-08-25 13:11:09', '2025-08-25 13:11:11'),
	(2407540, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"23:11:37","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:11:37"}', '2025-08-25 13:11:37', '2025-08-25 13:11:36'),
	(2407541, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.495493, 29.478471, _binary 0x0000000001010000009c1551137d7a3d408d710f536c3f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:11:35","ind":0,"enl":"40.4954933","boy":"029.478471","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":72.02428,"mes":47472,"yon":293,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:11:35"}', '2025-08-25 13:11:35', '2025-08-25 13:11:37'),
	(2407542, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.497558, 29.472495, _binary 0x0000000001010000000586ac6ef5783d403b2d89fdaf3f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:12:03","ind":0,"enl":"40.4975583","boy":"029.472495","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":69.45,"mes":47472.5,"yon":296,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:12:03"}', '2025-08-25 13:12:03', '2025-08-25 13:12:04'),
	(2407543, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.499658, 29.466786, _binary 0x0000000001010000000c3b8c497f773d4065d69ccdf43f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:12:31","ind":0,"enl":"40.4996583","boy":"029.466786","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":72.57988,"mes":47473.1,"yon":294,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:12:31"}', '2025-08-25 13:12:31', '2025-08-25 13:12:32'),
	(2407544, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.501528, 29.461151, _binary 0x0000000001010000008884effd0d763d405d424f1432404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:12:58","ind":0,"enl":"40.5015283","boy":"029.461151","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":70.50564,"mes":47473.6,"yon":293,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:12:58"}', '2025-08-25 13:12:58', '2025-08-25 13:13:00'),
	(2407545, '31.143.219.198:35638', '86284304533376212', 40.992082, 28.905356, _binary 0x000000000101000000c53c2b69c5e73c40e43a7c88fc7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"25.08.2025","sat":"23:13:13","ind":0,"enl":"40.9920817","boy":"028.905356","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10953.7,"yon":341,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:13:13"}', '2025-08-25 13:13:13', '2025-08-25 13:13:15'),
	(2407546, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.503515, 29.455058, _binary 0x0000000001010000007ec85bae7e743d40d105f52d73404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:13:25","ind":0,"enl":"40.5035150","boy":"029.455058","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":75.61716,"mes":47474.2,"yon":293,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:13:25"}', '2025-08-25 13:13:25', '2025-08-25 13:13:27'),
	(2407547, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.505492, 29.449178, _binary 0x0000000001010000002b155454fd723d4021f3b7f3b3404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:13:51","ind":0,"enl":"40.5054917","boy":"029.449178","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":75.11712000000001,"mes":47474.6,"yon":294,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:13:51"}', '2025-08-25 13:13:51', '2025-08-25 13:13:52'),
	(2407548, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.507305, 29.443271, _binary 0x000000000101000000e54350357a713d40740cc85eef404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:14:17","ind":0,"enl":"40.5073050","boy":"029.443271","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":72.45024,"mes":47475.2,"yon":284,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:14:17"}', '2025-08-25 13:14:17', '2025-08-25 13:14:18'),
	(2407549, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.507553, 29.437136, _binary 0x0000000001010000007de71725e86f3d400a3dac81f7404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:14:44","ind":0,"enl":"40.5075533","boy":"029.437136","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":70.43156,"mes":47475.7,"yon":266,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:14:44"}', '2025-08-25 13:14:44', '2025-08-25 13:14:46'),
	(2407550, '31.143.21.53:17428', '44fe033664dac2621', 41.012117, 29.050781, _binary 0x0000000001010000001842cefbff0c3d40231e3f0a8d814440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"25.08.2025","sat":"23:14:56","ind":0,"enl":"41.0121167","boy":"029.050781","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74647.3,"yon":53,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:14:56"}', '2025-08-25 13:14:56', '2025-08-25 13:14:57'),
	(2407551, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.507122, 29.430815, _binary 0x00000000010100000051a04fe4496e3d40c44b265de9404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:15:11","ind":0,"enl":"40.5071217","boy":"029.430815","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":74.3578,"mes":47476.3,"yon":265,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:15:11"}', '2025-08-25 13:15:11', '2025-08-25 13:15:13'),
	(2407552, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.506663, 29.424190, _binary 0x0000000001010000004d4a41b7976c3d40aecacf57da404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:15:38","ind":0,"enl":"40.5066633","boy":"029.424190","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":76.82096,"mes":47476.7,"yon":264,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:15:38"}', '2025-08-25 13:15:38', '2025-08-25 13:15:40'),
	(2407553, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.506482, 29.421671, _binary 0x000000000101000000efab72a1f26b3d40e1c27064d4404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:15:48","ind":0,"enl":"40.5064817","boy":"029.421671","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.562,"mes":47476.9,"yon":264,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:15:48"}', '2025-08-25 13:15:48', '2025-08-25 13:15:50'),
	(2407554, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.506372, 29.419810, _binary 0x000000000101000000a4880cab786b3d405a8fb1c9d0404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:15:55","ind":0,"enl":"40.5063717","boy":"029.419810","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":78.63592,"mes":47477.2,"yon":265,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:15:55"}', '2025-08-25 13:15:55', '2025-08-25 13:15:57'),
	(2407555, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.505958, 29.413211, _binary 0x000000000101000000f3583332c8693d40e4d1d73dc3404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:16:21","ind":0,"enl":"40.5059583","boy":"029.413211","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":78.71000000000001,"mes":47477.6,"yon":265,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:16:21"}', '2025-08-25 13:16:21', '2025-08-25 13:16:24'),
	(2407556, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.505945, 29.412931, _binary 0x0000000001010000002c8194d8b5693d40904946cec2404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:16:22","ind":0,"enl":"40.5059450","boy":"029.412931","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.89536,"mes":47477.8,"yon":264,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:16:22"}', '2025-08-25 13:16:22', '2025-08-25 13:16:25'),
	(2407557, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.505705, 29.409473, _binary 0x0000000001010000005298f738d3683d403b3602f1ba404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:16:35","ind":0,"enl":"40.5057050","boy":"029.409473","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.58044,"mes":47478,"yon":264,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:16:35"}', '2025-08-25 13:16:35', '2025-08-25 13:16:36'),
	(2407558, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.505507, 29.406638, _binary 0x000000000101000000944f8f6d19683d4056348c71b4404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:16:46","ind":0,"enl":"40.5055067","boy":"029.406638","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.33976000000001,"mes":47478.2,"yon":265,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:16:46"}', '2025-08-25 13:16:46', '2025-08-25 13:16:47'),
	(2407559, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.505485, 29.406385, _binary 0x000000000101000000c095ecd808683d402dcf83bbb3404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:16:47","ind":0,"enl":"40.5054850","boy":"029.406385","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.19152,"mes":47478.2,"yon":264,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:16:47"}', '2025-08-25 13:16:47', '2025-08-25 13:16:48'),
	(2407560, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.505043, 29.399861, _binary 0x00000000010100000024f25d4a5d663d402e484442a5404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:17:13","ind":0,"enl":"40.5050433","boy":"029.399861","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":73.8948,"mes":47478.8,"yon":265,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:17:13"}', '2025-08-25 13:17:13', '2025-08-25 13:17:14'),
	(2407561, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.504667, 29.393753, _binary 0x000000000101000000afb321ffcc643d40acf01deb98404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:17:38","ind":0,"enl":"40.5046667","boy":"029.393753","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":74.85784000000001,"mes":47479.3,"yon":265,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:17:38"}', '2025-08-25 13:17:38', '2025-08-25 13:17:40'),
	(2407562, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.504157, 29.387280, _binary 0x000000000101000000176536c824633d409747ed3488404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:18:04","ind":0,"enl":"40.5041567","boy":"029.387280","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":77.39508000000001,"mes":47479.8,"yon":265,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:18:04"}', '2025-08-25 13:18:04', '2025-08-25 13:18:06'),
	(2407563, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.503790, 29.380760, _binary 0x000000000101000000fd9fc37c79613d40a306d3307c404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:18:31","ind":0,"enl":"40.5037900","boy":"029.380760","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":77.02468,"mes":47480.4,"yon":265,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:18:31"}', '2025-08-25 13:18:31', '2025-08-25 13:18:33'),
	(2407564, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.503727, 29.379968, _binary 0x000000000101000000cb86359545613d409e4fd31d7a404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:18:34","ind":0,"enl":"40.5037267","boy":"029.379968","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.1916,"mes":47480.4,"yon":263,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:18:34"}', '2025-08-25 13:18:34', '2025-08-25 13:18:35'),
	(2407565, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997405, 29.074240, _binary 0x000000000101000000170e846401133d40f6ee8ff7aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"25.08.2025","sat":"23:18:35","ind":0,"enl":"40.9974050","boy":"029.074240","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":48,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:18:35"}', '2025-08-25 13:18:35', '2025-08-25 13:18:37'),
	(2407566, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.503695, 29.379708, _binary 0x0000000001010000009207228b34613d405114e81379404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:18:35","ind":0,"enl":"40.5036950","boy":"029.379708","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.06196,"mes":47480.4,"yon":263,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:18:35"}', '2025-08-25 13:18:35', '2025-08-25 13:18:39'),
	(2407567, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.503225, 29.373375, _binary 0x000000000101000000dd240681955f3d40cac342ad69404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:00","ind":0,"enl":"40.5032250","boy":"029.373375","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":78.74704000000001,"mes":47481,"yon":263,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:00"}', '2025-08-25 13:19:00', '2025-08-25 13:19:02'),
	(2407568, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.503195, 29.372871, _binary 0x00000000010100000077a04e79745f3d405f419ab168404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:02","ind":0,"enl":"40.5031950","boy":"029.372871","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.32124,"mes":47481,"yon":264,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:02"}', '2025-08-25 13:19:02', '2025-08-25 13:19:04'),
	(2407569, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.503182, 29.372610, _binary 0x0000000001010000009e29745e635f3d400cb9084268404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:03","ind":0,"enl":"40.5031817","boy":"029.372610","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.96936000000001,"mes":47481,"yon":264,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:03"}', '2025-08-25 13:19:03', '2025-08-25 13:19:05'),
	(2407570, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.503163, 29.372340, _binary 0x0000000001010000001efe9aac515f3d401206afa767404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:04","ind":0,"enl":"40.5031633","boy":"029.372340","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.17308,"mes":47481.1,"yon":263,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:04"}', '2025-08-25 13:19:04', '2025-08-25 13:19:06'),
	(2407571, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.503055, 29.371040, _binary 0x0000000001010000000282397afc5e3d406e8b321b64404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:09","ind":0,"enl":"40.5030550","boy":"029.371040","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.87676,"mes":47481.2,"yon":264,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:09"}', '2025-08-25 13:19:09', '2025-08-25 13:19:11'),
	(2407572, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.503037, 29.370775, _binary 0x000000000101000000a52c431ceb5e3d400998af8163404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:10","ind":0,"enl":"40.5030367","boy":"029.370775","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.1916,"mes":47481.2,"yon":264,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:10"}', '2025-08-25 13:19:10', '2025-08-25 13:19:11'),
	(2407573, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.503022, 29.370516, _binary 0x0000000001010000000da5f622da5e3d40d356db0363404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:11","ind":0,"enl":"40.5030217","boy":"029.370516","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.74712000000001,"mes":47481.2,"yon":265,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:11"}', '2025-08-25 13:19:11', '2025-08-25 13:19:13'),
	(2407574, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.502958, 29.369745, _binary 0x0000000001010000000adcba9ba75e3d403ae004f060404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:14","ind":0,"enl":"40.5029583","boy":"029.369745","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.30272000000001,"mes":47481.3,"yon":264,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:14"}', '2025-08-25 13:19:14', '2025-08-25 13:19:17'),
	(2407575, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.502937, 29.369490, _binary 0x000000000101000000f4328ae5965e3d40a53ad33a60404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:15","ind":0,"enl":"40.5029367","boy":"029.369490","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.78416,"mes":47481.3,"yon":264,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:15"}', '2025-08-25 13:19:15', '2025-08-25 13:19:18'),
	(2407576, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.502685, 29.365561, _binary 0x0000000001010000006cb1db67955d3d404a9869fb57404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:30","ind":0,"enl":"40.5026850","boy":"029.365561","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.59904000000002,"mes":47481.6,"yon":263,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:30"}', '2025-08-25 13:19:30', '2025-08-25 13:19:31'),
	(2407577, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.502658, 29.365310, _binary 0x000000000101000000dae6c6f4845d3d400fc86f1b57404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:31","ind":0,"enl":"40.5026583","boy":"029.365310","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.95084000000001,"mes":47481.7,"yon":263,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:31"}', '2025-08-25 13:19:31', '2025-08-25 13:19:32'),
	(2407578, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.502637, 29.365038, _binary 0x00000000010100000018cc5f21735d3d407a223e6656404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:32","ind":0,"enl":"40.5026367","boy":"029.365038","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.33976000000001,"mes":47481.7,"yon":263,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:32"}', '2025-08-25 13:19:32', '2025-08-25 13:19:33'),
	(2407579, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.502565, 29.364236, _binary 0x0000000001010000009e060c923e5d3d409f8ec70c54404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:35","ind":0,"enl":"40.5025650","boy":"029.364236","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":79.173,"mes":47481.7,"yon":263,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:35"}', '2025-08-25 13:19:35', '2025-08-25 13:19:37'),
	(2407580, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.502455, 29.363236, _binary 0x000000000101000000d8bad408fd5c3d40185b087250404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:39","ind":0,"enl":"40.5024550","boy":"029.363236","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":80.72868000000001,"mes":47481.8,"yon":264,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:39"}', '2025-08-25 13:19:39', '2025-08-25 13:19:41'),
	(2407581, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.502235, 29.359745, _binary 0x00000000010100000047e6913f185c3d400af4893c49404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:19:52","ind":0,"enl":"40.5022350","boy":"029.359745","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":77.8766,"mes":47482.2,"yon":264,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:19:52"}', '2025-08-25 13:19:52', '2025-08-25 13:19:53'),
	(2407582, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.501513, 29.353585, _binary 0x0000000001010000002d5beb8b845a3d4028017b9631404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:20:17","ind":0,"enl":"40.5015133","boy":"029.353585","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":72.43172,"mes":47482.6,"yon":252,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:20:17"}', '2025-08-25 13:20:17', '2025-08-25 13:20:19'),
	(2407583, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.500020, 29.347613, _binary 0x00000000010100000019aa622afd583d4047acc5a700404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:20:46","ind":0,"enl":"40.5000200","boy":"029.347613","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":55.411840000000005,"mes":47483.2,"yon":251,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:20:46"}', '2025-08-25 13:20:46', '2025-08-25 13:20:48'),
	(2407584, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.501948, 29.343106, _binary 0x000000000101000000b60f79cbd5573d40336486d73f404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:21:32","ind":0,"enl":"40.5019483","boy":"029.343106","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":32.521119999999996,"mes":47483.7,"yon":290,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:21:32"}', '2025-08-25 13:21:32', '2025-08-25 13:21:34'),
	(2407585, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"23:21:37","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:21:37"}', '2025-08-25 13:21:37', '2025-08-25 13:21:35'),
	(2407586, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.504608, 29.338458, _binary 0x000000000101000000cf11f92ea5563d4024e5380197404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:22:03","ind":0,"enl":"40.5046083","boy":"029.338458","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":75.04304,"mes":47484.2,"yon":346,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:22:03"}', '2025-08-25 13:22:03', '2025-08-25 13:22:05'),
	(2407587, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.506388, 29.338666, _binary 0x0000000001010000006344a2d0b2563d40dcc9f154d1404440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:22:12","ind":0,"enl":"40.5063883","boy":"029.338666","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":83.09924,"mes":47484.4,"yon":17,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:22:12"}', '2025-08-25 13:22:12', '2025-08-25 13:22:14'),
	(2407588, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.511172, 29.340213, _binary 0x0000000001010000008eacfc3218573d40031203136e414440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:22:34","ind":0,"enl":"40.5111717","boy":"029.340213","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":97.58188,"mes":47484.9,"yon":12,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:22:34"}', '2025-08-25 13:22:34', '2025-08-25 13:22:36'),
	(2407589, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.516305, 29.341388, _binary 0x000000000101000000313f373465573d4072e1404816424440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:22:56","ind":0,"enl":"40.5163050","boy":"029.341388","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":92.21108000000001,"mes":47485.5,"yon":7,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:22:56"}', '2025-08-25 13:22:56', '2025-08-25 13:22:59'),
	(2407590, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.521062, 29.342065, _binary 0x000000000101000000331b649291573d405d595826b2424440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:23:17","ind":0,"enl":"40.5210617","boy":"029.342065","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":91.47028,"mes":47486,"yon":4,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:23:17"}', '2025-08-25 13:23:17', '2025-08-25 13:23:21'),
	(2407591, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.526207, 29.342555, _binary 0x000000000101000000cf143aafb1573d40d2b7bbbd5a434440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:23:39","ind":0,"enl":"40.5262067","boy":"029.342555","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":97.67448,"mes":47486.6,"yon":3,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:23:39"}', '2025-08-25 13:23:39', '2025-08-25 13:23:41'),
	(2407592, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.531288, 29.343058, _binary 0x00000000010100000094a12aa6d2573d40ac9f484101444440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:24:00","ind":0,"enl":"40.5312883","boy":"029.343058","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":96.50772,"mes":47487.1,"yon":6,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:24:00"}', '2025-08-25 13:24:00', '2025-08-25 13:24:02'),
	(2407593, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.536032, 29.344416, _binary 0x0000000001010000001938a0a52b583d40458fceaf9c444440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:24:20","ind":0,"enl":"40.5360317","boy":"029.344416","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":99.02644000000001,"mes":47487.6,"yon":17,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:24:20"}', '2025-08-25 13:24:20', '2025-08-25 13:24:22'),
	(2407594, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.540745, 29.346980, _binary 0x000000000101000000b75d68aed3583d40de3cd52137454440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:24:40","ind":0,"enl":"40.5407450","boy":"029.346980","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":103.84164000000001,"mes":47488.2,"yon":24,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:24:40"}', '2025-08-25 13:24:40', '2025-08-25 13:24:42'),
	(2407595, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.011808, 29.050980, _binary 0x00000000010100000005c078060d0d3d40222933ef82814440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"25.08.2025","sat":"23:24:59","ind":0,"enl":"41.0118083","boy":"029.050980","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43113.3,"yon":187,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:24:59"}', '2025-08-25 13:24:59', '2025-08-25 13:25:00'),
	(2407596, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.545225, 29.349820, _binary 0x0000000001010000009a7cb3cd8d593d4016fbcbeec9454440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:24:59","ind":0,"enl":"40.5452250","boy":"029.349820","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":102.02668000000001,"mes":47488.8,"yon":17,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:24:59"}', '2025-08-25 13:24:59', '2025-08-25 13:25:01'),
	(2407597, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.550208, 29.350606, _binary 0x00000000010100000008c89750c1593d406f3ebf396d464440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:25:19","ind":0,"enl":"40.5502083","boy":"029.350606","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":95.9336,"mes":47489.2,"yon":3,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:25:19"}', '2025-08-25 13:25:19', '2025-08-25 13:25:21'),
	(2407598, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.552675, 29.350798, _binary 0x0000000001010000009180d1e5cd593d408d28ed0dbe464440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:25:41","ind":4,"enl":"40.5526750","boy":"029.350798","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":81.45096,"mes":47489.8,"yon":5,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:25:41"}', '2025-08-25 13:25:41', '2025-08-25 13:25:44'),
	(2407605, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.589080, 29.365680, _binary 0x00000000010100000021cd58349d5d3d40255d33f9664b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:28:28","ind":0,"enl":"40.5890800","boy":"029.365680","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":111.583,"mes":47493.6,"yon":26,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:28:28"}', '2025-08-25 13:28:28', '2025-08-25 13:28:30'),
	(2407606, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.593885, 29.367608, _binary 0x0000000001010000007bbfd18e1b5e3d40e04a766c044c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:28:47","ind":0,"enl":"40.5938850","boy":"029.367608","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":106.74928000000001,"mes":47494.1,"yon":1,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:28:47"}', '2025-08-25 13:28:47', '2025-08-25 13:28:48'),
	(2407608, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.589080, 29.365680, _binary 0x00000000010100000021cd58349d5d3d40255d33f9664b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:28:28","ind":0,"enl":"40.5890800","boy":"029.365680","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":111.583,"mes":47493.6,"yon":26,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:28:28"}', '2025-08-25 13:28:28', '2025-08-25 13:28:30'),
	(2407609, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.593885, 29.367608, _binary 0x0000000001010000007bbfd18e1b5e3d40e04a766c044c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:28:47","ind":0,"enl":"40.5938850","boy":"029.367608","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":106.74928000000001,"mes":47494.1,"yon":1,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:28:47"}', '2025-08-25 13:28:47', '2025-08-25 13:28:48'),
	(2407610, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.598755, 29.367171, _binary 0x000000000101000000240a2debfe5d3d4082a8fb00a44c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:29:05","ind":0,"enl":"40.5987550","boy":"029.367171","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":108.67536,"mes":47494.7,"yon":356,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:29:05"}', '2025-08-25 13:29:05', '2025-08-25 13:29:07'),
	(2407611, '31.142.69.246:17347', '86090604649604512', 41.012618, 29.125513, _binary 0x0000000001010000000d39b69e21203d4062eaf8799d814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"25.08.2025","sat":"23:29:18","ind":0,"enl":"41.0126183","boy":"029.125513","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":181,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:29:18"}', '2025-08-25 13:29:18', '2025-08-25 13:29:19'),
	(2407612, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.603970, 29.367885, _binary 0x00000000010100000060b01bb62d5e3d40efe192e34e4d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:29:24","ind":0,"enl":"40.6039700","boy":"029.367885","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":112.65716,"mes":47495.2,"yon":15,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:29:24"}', '2025-08-25 13:29:24', '2025-08-25 13:29:25'),
	(2407613, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.608523, 29.370681, _binary 0x000000000101000000a33f34f3e45e3d40502d6c17e44d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:29:42","ind":0,"enl":"40.6085233","boy":"029.370681","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":111.30520000000001,"mes":47495.8,"yon":34,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:29:42"}', '2025-08-25 13:29:42', '2025-08-25 13:29:45'),
	(2407614, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.612167, 29.375330, _binary 0x0000000001010000002b357ba015603d40a2197a7a5b4e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:30:00","ind":0,"enl":"40.6121667","boy":"029.375330","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":114.69436,"mes":47496.3,"yon":51,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:30:00"}', '2025-08-25 13:30:00', '2025-08-25 13:30:01'),
	(2407615, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.615463, 29.380060, _binary 0x0000000001010000008c84b69c4b613d40b2b15c80c74e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:30:17","ind":0,"enl":"40.6154633","boy":"029.380060","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":114.62028000000001,"mes":47496.9,"yon":38,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:30:17"}', '2025-08-25 13:30:17', '2025-08-25 13:30:19'),
	(2407616, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.619980, 29.382935, _binary 0x000000000101000000677e350708623d40481630815b4f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:30:35","ind":0,"enl":"40.6199800","boy":"029.382935","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":113.45352,"mes":47497.4,"yon":14,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:30:35"}', '2025-08-25 13:30:35', '2025-08-25 13:30:36'),
	(2407617, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.625017, 29.383200, _binary 0x000000000101000000c3d32b6519623d4018fa168c00504440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:30:53","ind":0,"enl":"40.6250167","boy":"029.383200","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":111.37928000000001,"mes":47497.9,"yon":356,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:30:53"}', '2025-08-25 13:30:53', '2025-08-25 13:30:55'),
	(2407618, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.630123, 29.383550, _binary 0x0000000001010000007c61325530623d404bf95ae1a7504440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:31:11","ind":0,"enl":"40.6301233","boy":"029.383550","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":112.86088,"mes":47498.5,"yon":10,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:31:11"}', '2025-08-25 13:31:11', '2025-08-25 13:31:13'),
	(2407619, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.634708, 29.385498, _binary 0x00000000010100000064ac36ffaf623d40f87f1f1f3e514440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:31:28","ind":0,"enl":"40.6347083","boy":"029.385498","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":114.86104000000002,"mes":47499.1,"yon":22,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:31:28"}', '2025-08-25 13:31:28', '2025-08-25 13:31:30'),
	(2407620, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"23:31:38","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:31:38"}', '2025-08-25 13:31:38', '2025-08-25 13:31:36'),
	(2407621, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.639083, 29.389103, _binary 0x00000000010100000086c613419c633d40bb75487bcd514440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:31:46","ind":0,"enl":"40.6390833","boy":"029.389103","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":113.8054,"mes":47499.5,"yon":47,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:31:46"}', '2025-08-25 13:31:46', '2025-08-25 13:31:47'),
	(2407622, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.641340, 29.394555, _binary 0x0000000001010000002979758e01653d40eeceda6d17524440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:32:04","ind":0,"enl":"40.6413400","boy":"029.394555","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":100.91548,"mes":47500.1,"yon":68,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:32:04"}', '2025-08-25 13:32:04', '2025-08-25 13:32:06'),
	(2407623, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.642590, 29.401131, _binary 0x0000000001010000006a696e85b0663d404a5e9d6340524440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:32:25","ind":0,"enl":"40.6425900","boy":"029.401131","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":99.00792000000001,"mes":47500.7,"yon":83,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:32:25"}', '2025-08-25 13:32:25', '2025-08-25 13:32:28'),
	(2407624, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"25.08.2025","sat":"23:32:30","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":137,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:32:30"}', '2025-08-25 13:32:30', '2025-08-25 13:32:32'),
	(2407625, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"25.08.2025","sat":"23:32:30","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":31,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:32:30"}', '2025-08-25 13:32:30', '2025-08-25 13:32:33'),
	(2407626, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.643375, 29.407743, _binary 0x000000000101000000452c62d861683d403108ac1c5a524440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:32:46","ind":0,"enl":"40.6433750","boy":"029.407743","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":96.10028000000001,"mes":47501.1,"yon":71,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:32:46"}', '2025-08-25 13:32:46', '2025-08-25 13:32:47'),
	(2407627, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003660, 29.079390, _binary 0x00000000010100000023a12de752143d40d5264eee77804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"25.08.2025","sat":"23:32:52","ind":0,"enl":"41.0036600","boy":"029.079390","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94765.6,"yon":326,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:32:52"}', '2025-08-25 13:32:52', '2025-08-25 13:32:55'),
	(2407628, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.645982, 29.412896, _binary 0x00000000010100000033a6608db3693d4041a84187af524440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:33:06","ind":0,"enl":"40.6459817","boy":"029.412896","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":93.00744,"mes":47501.7,"yon":41,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:33:06"}', '2025-08-25 13:33:06', '2025-08-25 13:33:08'),
	(2407629, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.650583, 29.415685, _binary 0x000000000101000000117008556a6a3d407169465046534440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:33:27","ind":0,"enl":"40.6505833","boy":"029.415685","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":102.04520000000001,"mes":47502.3,"yon":9,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:33:27"}', '2025-08-25 13:33:27', '2025-08-25 13:33:28'),
	(2407630, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.655440, 29.416228, _binary 0x000000000101000000f3ad0feb8d6a3d40c03e3a75e5534440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:33:45","ind":0,"enl":"40.6554400","boy":"029.416228","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":112.97200000000001,"mes":47502.8,"yon":15,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:33:45"}', '2025-08-25 13:33:45', '2025-08-25 13:33:47'),
	(2407631, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.660192, 29.419448, _binary 0x000000000101000000635fb2f1606b3d409a4b602981544440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:34:04","ind":0,"enl":"40.6601917","boy":"029.419448","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":112.71272,"mes":47503.3,"yon":31,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:34:04"}', '2025-08-25 13:34:04', '2025-08-25 13:34:05'),
	(2407632, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"25.08.2025","sat":"23:34:13","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":174,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:34:13"}', '2025-08-25 13:34:13', '2025-08-25 13:34:15'),
	(2407633, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.664013, 29.423626, _binary 0x0000000001010000003cbce7c0726c3d40f5cd4763fe544440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:34:22","ind":0,"enl":"40.6640133","boy":"029.423626","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":111.91636000000001,"mes":47503.9,"yon":54,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:34:22"}', '2025-08-25 13:34:22', '2025-08-25 13:34:24'),
	(2407634, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.665695, 29.430061, _binary 0x000000000101000000f9484a7a186e3d402c0e677e35554440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:34:41","ind":0,"enl":"40.6656950","boy":"029.430061","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":106.00848,"mes":47504.5,"yon":87,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:34:41"}', '2025-08-25 13:34:41', '2025-08-25 13:34:43'),
	(2407635, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.664968, 29.436565, _binary 0x00000000010100000008944db9c26f3d4038b066ae1d554440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:35:00","ind":0,"enl":"40.6649683","boy":"029.436565","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":107.61972,"mes":47505.1,"yon":94,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:35:00"}', '2025-08-25 13:35:00', '2025-08-25 13:35:02'),
	(2407636, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.666015, 29.443006, _binary 0x00000000010100000089ee59d768713d409ed2c1fa3f554440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:35:18","ind":0,"enl":"40.6660150","boy":"029.443006","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":115.78704,"mes":47505.5,"yon":62,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:35:18"}', '2025-08-25 13:35:18', '2025-08-25 13:35:19'),
	(2407637, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.669075, 29.448443, _binary 0x000000000101000000c11e1329cd723d401dc9e53fa4554440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:35:36","ind":0,"enl":"40.6690750","boy":"029.448443","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":113.60168000000002,"mes":47506.1,"yon":52,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:35:36"}', '2025-08-25 13:35:36', '2025-08-25 13:35:37'),
	(2407638, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.671917, 29.453628, _binary 0x000000000101000000c58cf0f620743d407011ce5d01564440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:35:53","ind":0,"enl":"40.6719167","boy":"029.453628","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":116.12040000000002,"mes":47506.6,"yon":54,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:35:53"}', '2025-08-25 13:35:53', '2025-08-25 13:35:54'),
	(2407639, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.674712, 29.458951, _binary 0x0000000001010000006c770fd07d753d4042ddf6f35c564440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:36:10","ind":0,"enl":"40.6747117","boy":"029.458951","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":111.00888,"mes":47507.2,"yon":53,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:36:10"}', '2025-08-25 13:36:10', '2025-08-25 13:36:12'),
	(2407640, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.678673, 29.463470, _binary 0x00000000010100000058ad4cf8a5763d408e1546c4de564440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:36:28","ind":0,"enl":"40.6786733","boy":"029.463470","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":123.91732,"mes":47507.7,"yon":35,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:36:28"}', '2025-08-25 13:36:28', '2025-08-25 13:36:30'),
	(2407641, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.682655, 29.467198, _binary 0x000000000101000000b1c1c2499a773d40b6b9313d61574440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:36:44","ind":0,"enl":"40.6826550","boy":"029.467198","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":121.91716000000001,"mes":47508.3,"yon":36,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:36:44"}', '2025-08-25 13:36:44', '2025-08-25 13:36:46'),
	(2407642, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.686608, 29.471598, _binary 0x000000000101000000e8db82a5ba783d40c2d4e0c7e2574440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:37:02","ind":0,"enl":"40.6866083","boy":"029.471598","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":111.84228,"mes":47508.8,"yon":42,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:37:02"}', '2025-08-25 13:37:02', '2025-08-25 13:37:03'),
	(2407643, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.690103, 29.476273, _binary 0x000000000101000000c2f7fe06ed793d404b2e104e55584440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:37:20","ind":0,"enl":"40.6901033","boy":"029.476273","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":106.76780000000001,"mes":47509.4,"yon":45,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:37:20"}', '2025-08-25 13:37:20', '2025-08-25 13:37:28'),
	(2407644, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.693742, 29.481268, _binary 0x000000000101000000809c3061347b3d408baf2c87cc584440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:37:40","ind":0,"enl":"40.6937417","boy":"029.481268","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":106.97152,"mes":47509.9,"yon":46,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:37:40"}', '2025-08-25 13:37:40', '2025-08-25 13:37:42'),
	(2407645, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.697185, 29.485726, _binary 0x00000000010100000020d1048a587c3d408121ab5b3d594440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:37:58","ind":0,"enl":"40.6971850","boy":"029.485726","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":107.84196,"mes":47510.5,"yon":41,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:37:58"}', '2025-08-25 13:37:58', '2025-08-25 13:38:00'),
	(2407646, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.701325, 29.489773, _binary 0x000000000101000000bc7669c3617d3d40006f8104c5594440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:38:17","ind":0,"enl":"40.7013250","boy":"029.489773","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":109.3606,"mes":47511,"yon":31,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:38:17"}', '2025-08-25 13:38:17', '2025-08-25 13:38:19'),
	(2407647, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.705735, 29.493086, _binary 0x0000000001010000008f1d54e23a7e3d403f524486555a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:38:36","ind":0,"enl":"40.7057350","boy":"029.493086","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":103.60088,"mes":47511.6,"yon":29,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:38:36"}', '2025-08-25 13:38:36', '2025-08-25 13:38:37'),
	(2407648, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.710033, 29.496215, _binary 0x000000000101000000dec83cf2077f3d401549055fe25a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:38:56","ind":0,"enl":"40.7100333","boy":"029.496215","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":103.87868000000002,"mes":47512.1,"yon":29,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:38:56"}', '2025-08-25 13:38:56', '2025-08-25 13:38:58'),
	(2407649, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.714547, 29.499345, _binary 0x000000000101000000cf6bec12d57f3d407cfb2944765b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:39:17","ind":0,"enl":"40.7145467","boy":"029.499345","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":80.50644,"mes":47512.6,"yon":25,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:39:17"}', '2025-08-25 13:39:17', '2025-08-25 13:39:18'),
	(2407650, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.714885, 29.499536, _binary 0x000000000101000000b62c5f97e17f3d4053b3075a815b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:39:19","ind":0,"enl":"40.7148850","boy":"029.499536","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":71.80204,"mes":47512.7,"yon":26,"A":"36","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:39:19"}', '2025-08-25 13:39:19', '2025-08-25 13:39:21'),
	(2407651, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003753, 29.224698, _binary 0x000000000101000000037ae1ce85393d404460f6fc7a804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"25.08.2025","sat":"23:39:21","ind":0,"enl":"41.0037533","boy":"029.224698","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43221.7,"yon":269,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:39:21"}', '2025-08-25 13:39:21', '2025-08-25 13:39:23'),
	(2407652, '176.89.142.133:42984', '350612079185623', 41.014947, 29.054153, _binary 0x00000000010100000071789cfddc0d3d40dc172bc5e9814440, '0', '{"device_model": "Teltonika", "p": "1", "did": "350612079185623", "trh": "2025-08-25", "sat": "23:39:42", "ind": 0, "enl": "41.0149466", "boy": "29.0541533", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 27279.236, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12660, "battery_voltage": 4057, "battery_current": 0, "record_timestamp": "2025-08-25 23:39:42", "codec_id": 8}', '2025-08-25 13:39:42', '2025-08-25 13:41:02'),
	(2407653, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.716435, 29.500471, _binary 0x000000000101000000af9811de1e803d40d95a5f24b45b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:40:21","ind":0,"enl":"40.7164350","boy":"029.500471","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":47512.8,"yon":40,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-25 23:40:21"}', '2025-08-25 13:40:21', '2025-08-25 13:40:22'),
	(2407654, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.718627, 29.501798, _binary 0x000000000101000000be326fd575803d402644aff5fb5b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:40:45","ind":0,"enl":"40.7186267","boy":"029.501798","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":81.54356,"mes":47513.2,"yon":21,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:40:45"}', '2025-08-25 13:40:45', '2025-08-25 13:40:47'),
	(2407655, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.723748, 29.503245, _binary 0x00000000010100000022e010aad4803d408e84c7c8a35c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:41:05","ind":0,"enl":"40.7237483","boy":"029.503245","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":112.67568000000001,"mes":47513.6,"yon":10,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:41:05"}', '2025-08-25 13:41:05', '2025-08-25 13:41:06'),
	(2407656, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.728213, 29.505510, _binary 0x0000000001010000000ccd751a69813d409101ea17365d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:41:22","ind":0,"enl":"40.7282133","boy":"029.505510","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":115.04624,"mes":47514.2,"yon":31,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:41:22"}', '2025-08-25 13:41:22', '2025-08-25 13:41:24'),
	(2407657, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"23:41:38","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:41:38"}', '2025-08-25 13:41:38', '2025-08-25 13:41:36'),
	(2407658, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.732270, 29.509593, _binary 0x0000000001010000004145d5af74823d40c4ebfa05bb5d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:41:42","ind":0,"enl":"40.7322700","boy":"029.509593","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":95.67432,"mes":47514.8,"yon":34,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:41:42"}', '2025-08-25 13:41:42', '2025-08-25 13:41:43'),
	(2407659, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.736783, 29.512478, _binary 0x00000000010100000064eb19c231833d4096de48ea4e5e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:42:03","ind":0,"enl":"40.7367833","boy":"029.512478","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":94.0816,"mes":47515.3,"yon":18,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:42:03"}', '2025-08-25 13:42:03', '2025-08-25 13:42:05'),
	(2407660, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.741552, 29.513776, _binary 0x0000000001010000003e78edd286833d4088e5852aeb5e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:42:24","ind":0,"enl":"40.7415517","boy":"029.513776","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":84.32156,"mes":47515.8,"yon":7,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:42:24"}', '2025-08-25 13:42:24', '2025-08-25 13:42:26'),
	(2407661, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.746457, 29.514585, _binary 0x0000000001010000001d03b2d7bb833d40a730a5e48b5f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:42:47","ind":0,"enl":"40.7464567","boy":"029.514585","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":91.59992000000001,"mes":47516.4,"yon":7,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:42:47"}', '2025-08-25 13:42:47', '2025-08-25 13:42:49'),
	(2407662, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.751353, 29.515383, _binary 0x00000000010100000014eae923f0833d40ef9e4d582c604440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:43:08","ind":0,"enl":"40.7513533","boy":"029.515383","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":91.54436,"mes":47516.9,"yon":7,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:43:08"}', '2025-08-25 13:43:08', '2025-08-25 13:43:11'),
	(2407663, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.756418, 29.516213, _binary 0x00000000010100000022c5008926843d40474c9a50d2604440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:43:31","ind":0,"enl":"40.7564183","boy":"029.516213","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":89.63680000000001,"mes":47517.5,"yon":7,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:43:31"}', '2025-08-25 13:43:31', '2025-08-25 13:43:33'),
	(2407664, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.761395, 29.517001, _binary 0x000000000101000000d2ff722d5a843d40412b306475614440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:43:54","ind":0,"enl":"40.7613950","boy":"029.517001","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":84.52528000000001,"mes":47518,"yon":7,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:43:54"}', '2025-08-25 13:43:54', '2025-08-25 13:43:55'),
	(2407665, '31.143.219.198:35638', '86284304533376212', 40.992082, 28.905356, _binary 0x000000000101000000c53c2b69c5e73c40e43a7c88fc7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"25.08.2025","sat":"23:44:14","ind":0,"enl":"40.9920817","boy":"028.905356","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10953.7,"yon":27,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:44:14"}', '2025-08-25 13:44:14', '2025-08-25 13:44:17'),
	(2407666, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.766138, 29.517808, _binary 0x0000000001010000006f9ba9108f843d40455bdfd110624440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:44:15","ind":0,"enl":"40.7661383","boy":"029.517808","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":91.97032,"mes":47518.5,"yon":7,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:44:15"}', '2025-08-25 13:44:15', '2025-08-25 13:44:17'),
	(2407667, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.771133, 29.518551, _binary 0x000000000101000000df4e22c2bf843d40a42df87eb4624440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:44:35","ind":0,"enl":"40.7711333","boy":"029.518551","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":105.76772,"mes":47519.1,"yon":5,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:44:35"}', '2025-08-25 13:44:35', '2025-08-25 13:44:37'),
	(2407668, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.776218, 29.518468, _binary 0x000000000101000000c405a051ba843d4042870a1f5b634440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:44:55","ind":0,"enl":"40.7762183","boy":"029.518468","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":98.41528000000001,"mes":47519.7,"yon":354,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:44:55"}', '2025-08-25 13:44:55', '2025-08-25 13:44:56'),
	(2407669, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.781040, 29.517388, _binary 0x000000000101000000c5573b8a73843d40156f641ef9634440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:45:15","ind":0,"enl":"40.7810400","boy":"029.517388","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":95.06316,"mes":47520.1,"yon":345,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:45:15"}', '2025-08-25 13:45:15', '2025-08-25 13:45:21'),
	(2407670, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.785873, 29.515700, _binary 0x000000000101000000158c4aea04843d4059260d7f97644440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:45:36","ind":0,"enl":"40.7858733","boy":"029.515700","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":92.61852,"mes":47520.7,"yon":345,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:45:36"}', '2025-08-25 13:45:36', '2025-08-25 13:45:37'),
	(2407671, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.790632, 29.513980, _binary 0x0000000001010000004fcc7a3194833d402757676b33654440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:45:57","ind":0,"enl":"40.7906317","boy":"029.513980","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":92.09996,"mes":47521.3,"yon":341,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:45:57"}', '2025-08-25 13:45:57', '2025-08-25 13:45:59'),
	(2407672, '31.143.21.53:17428', '44fe033664dac2621', 41.012117, 29.050781, _binary 0x0000000001010000001842cefbff0c3d40231e3f0a8d814440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"25.08.2025","sat":"23:46:04","ind":0,"enl":"41.0121167","boy":"029.050781","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74647.3,"yon":60,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:46:04"}', '2025-08-25 13:46:04', '2025-08-25 13:46:06'),
	(2407673, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.795010, 29.510870, _binary 0x000000000101000000ed815660c8823d4019ff3ee3c2654440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:46:19","ind":0,"enl":"40.7950100","boy":"029.510870","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":88.11816,"mes":47521.7,"yon":340,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:46:19"}', '2025-08-25 13:46:19', '2025-08-25 13:46:21'),
	(2407674, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.799718, 29.508791, _binary 0x000000000101000000c77f812040823d40a141542b5d664440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:46:41","ind":0,"enl":"40.7997183","boy":"029.508791","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":87.04400000000001,"mes":47522.3,"yon":318,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:46:41"}', '2025-08-25 13:46:41', '2025-08-25 13:46:42'),
	(2407675, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.801265, 29.502801, _binary 0x0000000001010000006765fb90b7803d40f836fdd98f664440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:47:01","ind":0,"enl":"40.8012650","boy":"029.502801","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":97.10036000000001,"mes":47522.8,"yon":292,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:47:01"}', '2025-08-25 13:47:01', '2025-08-25 13:47:03'),
	(2407676, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.803915, 29.497335, _binary 0x000000000101000000fa27b858517f3d40c6e1ccafe6664440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:47:23","ind":0,"enl":"40.8039150","boy":"029.497335","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":89.15528,"mes":47523.4,"yon":304,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:47:23"}', '2025-08-25 13:47:23', '2025-08-25 13:47:26'),
	(2407677, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.805788, 29.491248, _binary 0x000000000101000000b439ce6dc27d3d40eeff2d1224674440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:47:44","ind":0,"enl":"40.8057883","boy":"029.491248","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":101.04512000000001,"mes":47523.9,"yon":275,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:47:44"}', '2025-08-25 13:47:44', '2025-08-25 13:47:45'),
	(2407678, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.805200, 29.484860, _binary 0x0000000001010000007923f3c81f7c3d409e5e29cb10674440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:48:03","ind":0,"enl":"40.8052000","boy":"029.484860","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":102.86008,"mes":47524.4,"yon":263,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:48:03"}', '2025-08-25 13:48:03', '2025-08-25 13:48:05'),
	(2407679, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.806072, 29.478198, _binary 0x0000000001010000003a03232f6b7a3d4095dd825b2d674440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:48:22","ind":0,"enl":"40.8060717","boy":"029.478198","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":110.60144,"mes":47525,"yon":287,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:48:22"}', '2025-08-25 13:48:22', '2025-08-25 13:48:23'),
	(2407680, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.807600, 29.471931, _binary 0x000000000101000000f5f75278d0783d40f31fd26f5f674440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:48:40","ind":0,"enl":"40.8076000","boy":"029.471931","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":111.23112,"mes":47525.6,"yon":287,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:48:40"}', '2025-08-25 13:48:40', '2025-08-25 13:48:42'),
	(2407681, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.809205, 29.465446, _binary 0x000000000101000000d40d147827773d403d61890794674440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:48:59","ind":0,"enl":"40.8092050","boy":"029.465446","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":106.84188,"mes":47526.1,"yon":287,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:48:59"}', '2025-08-25 13:48:59', '2025-08-25 13:49:00'),
	(2407682, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.811070, 29.459628, _binary 0x0000000001010000006d533c2eaa753d4024624a24d1674440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:49:17","ind":0,"enl":"40.8110700","boy":"029.459628","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":106.04552,"mes":47526.6,"yon":297,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:49:17"}', '2025-08-25 13:49:17', '2025-08-25 13:49:19'),
	(2407683, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.814000, 29.453796, _binary 0x0000000001010000003d0e83f92b743d40d578e92631684440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:49:36","ind":0,"enl":"40.8140000","boy":"029.453796","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":117.63904000000001,"mes":47527.2,"yon":309,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:49:36"}', '2025-08-25 13:49:36', '2025-08-25 13:49:38'),
	(2407684, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997470, 29.074741, _binary 0x0000000001010000009babe63922133d40dd5ed218ad7f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"25.08.2025","sat":"23:49:36","ind":0,"enl":"40.9974700","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":158,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:49:36"}', '2025-08-25 13:49:36', '2025-08-25 13:49:38'),
	(2407685, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.817360, 29.449135, _binary 0x0000000001010000002c7de882fa723d407f87a2409f684440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:49:52","ind":0,"enl":"40.8173600","boy":"029.449135","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":123.39876,"mes":47527.8,"yon":315,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:49:52"}', '2025-08-25 13:49:52', '2025-08-25 13:49:54'),
	(2407686, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.821337, 29.444316, _binary 0x000000000101000000ec1681b1be713d4096c09c8f21694440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:50:10","ind":0,"enl":"40.8213367","boy":"029.444316","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":113.8054,"mes":47528.3,"yon":320,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:50:10"}', '2025-08-25 13:50:10', '2025-08-25 13:50:11'),
	(2407687, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.825083, 29.440058, _binary 0x000000000101000000da571ea4a7703d40e6fc5e549c694440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:50:28","ind":0,"enl":"40.8250833","boy":"029.440058","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":110.15696,"mes":47528.8,"yon":318,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:50:28"}', '2025-08-25 13:50:28', '2025-08-25 13:50:29'),
	(2407688, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.828778, 29.435370, _binary 0x000000000101000000d6a88768746f3d4037114768156a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:50:47","ind":0,"enl":"40.8287783","boy":"029.435370","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":107.67528,"mes":47529.4,"yon":311,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:50:47"}', '2025-08-25 13:50:47', '2025-08-25 13:50:48'),
	(2407689, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.831780, 29.430133, _binary 0x0000000001010000002dee3f321d6e3d40c3bb5cc4776a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:51:05","ind":0,"enl":"40.8317800","boy":"029.430133","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":110.49032,"mes":47530,"yon":302,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:51:05"}', '2025-08-25 13:51:05', '2025-08-25 13:51:08'),
	(2407690, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.834260, 29.424241, _binary 0x000000000101000000519fe40e9b6c3d40342e1c08c96a4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:51:24","ind":0,"enl":"40.8342600","boy":"029.424241","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":108.32348,"mes":47530.4,"yon":299,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:51:24"}', '2025-08-25 13:51:24', '2025-08-25 13:51:25'),
	(2407691, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"25.08.2025","sat":"23:51:38","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:51:38"}', '2025-08-25 13:51:38', '2025-08-25 13:51:36'),
	(2407692, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.837143, 29.418928, _binary 0x000000000101000000f2608bdd3e6b3d4063c8fb82276b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:51:42","ind":0,"enl":"40.8371433","boy":"029.418928","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":111.19408,"mes":47531,"yon":311,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:51:42"}', '2025-08-25 13:51:42', '2025-08-25 13:51:44'),
	(2407693, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.841337, 29.414840, _binary 0x000000000101000000991249f4326a3d4058b6c5ebb06b4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:52:02","ind":0,"enl":"40.8413367","boy":"029.414840","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":106.23072,"mes":47531.6,"yon":332,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:52:02"}', '2025-08-25 13:52:02', '2025-08-25 13:52:04'),
	(2407694, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.845965, 29.413003, _binary 0x0000000001010000005f268a90ba693d40c347c494486c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:52:19","ind":0,"enl":"40.8459650","boy":"029.413003","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":108.76796,"mes":47532.2,"yon":349,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:52:19"}', '2025-08-25 13:52:19', '2025-08-25 13:52:21'),
	(2407695, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.850818, 29.411371, _binary 0x000000000101000000d7851f9c4f693d404eab329de76c4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:52:38","ind":0,"enl":"40.8508183","boy":"029.411371","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":105.56400000000001,"mes":47532.6,"yon":339,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:52:38"}', '2025-08-25 13:52:38', '2025-08-25 13:52:40'),
	(2407696, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.855365, 29.408403, _binary 0x0000000001010000009a9658198d683d404f92ae997c6d4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:52:57","ind":0,"enl":"40.8553650","boy":"029.408403","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":111.12,"mes":47533.2,"yon":329,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:52:57"}', '2025-08-25 13:52:57', '2025-08-25 13:52:59'),
	(2407697, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.859533, 29.404631, _binary 0x000000000101000000a1f2afe595673d4057a9ea2f056e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:53:15","ind":0,"enl":"40.8595333","boy":"029.404631","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":109.6384,"mes":47533.8,"yon":322,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:53:15"}', '2025-08-25 13:53:15', '2025-08-25 13:53:18'),
	(2407698, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.863757, 29.400853, _binary 0x000000000101000000e5805d4d9e663d40b7195d948f6e4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:53:34","ind":0,"enl":"40.8637567","boy":"029.400853","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":102.786,"mes":47534.2,"yon":329,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:53:34"}', '2025-08-25 13:53:34', '2025-08-25 13:53:35'),
	(2407699, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.868125, 29.397836, _binary 0x000000000101000000e52b8194d8653d4085eb51b81e6f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:53:52","ind":0,"enl":"40.8681250","boy":"029.397836","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":118.76876,"mes":47534.8,"yon":333,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:53:52"}', '2025-08-25 13:53:52', '2025-08-25 13:53:56'),
	(2407700, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.872560, 29.393880, _binary 0x000000000101000000698cd651d5643d401de6cb0bb06f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:54:09","ind":0,"enl":"40.8725600","boy":"029.393880","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":130.26968000000002,"mes":47535.4,"yon":319,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:54:09"}', '2025-08-25 13:54:09', '2025-08-25 13:54:10'),
	(2407701, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.875868, 29.389261, _binary 0x000000000101000000b79be09ba6633d40330dd4731c704440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:54:24","ind":0,"enl":"40.8758683","boy":"029.389261","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":120.843,"mes":47535.9,"yon":309,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:54:24"}', '2025-08-25 13:54:24', '2025-08-25 13:54:27'),
	(2407702, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.879050, 29.383820, _binary 0x000000000101000000fc8c0b0742623d403fc6dcb584704440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:54:42","ind":0,"enl":"40.8790500","boy":"029.383820","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":116.676,"mes":47536.4,"yon":309,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:54:42"}', '2025-08-25 13:54:42', '2025-08-25 13:54:43'),
	(2407703, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.882562, 29.379211, _binary 0x0000000001010000009148dbf813613d40e01923c8f7704440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:54:59","ind":0,"enl":"40.8825617","boy":"029.379211","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":119.06508000000002,"mes":47537,"yon":319,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:54:59"}', '2025-08-25 13:54:59', '2025-08-25 13:55:01'),
	(2407704, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.886783, 29.375001, _binary 0x000000000101000000a1f7c61000603d40c9117c1d82714440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:55:16","ind":0,"enl":"40.8867833","boy":"029.375001","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":127.89912000000001,"mes":47537.6,"yon":327,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:55:16"}', '2025-08-25 13:55:16', '2025-08-25 13:55:17'),
	(2407705, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.891293, 29.371890, _binary 0x0000000001010000009eb5db2e345f3d406c521be615724440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:55:32","ind":0,"enl":"40.8912933","boy":"029.371890","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":124.69516,"mes":47538.2,"yon":335,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:55:32"}', '2025-08-25 13:55:32', '2025-08-25 13:55:34'),
	(2407706, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.896168, 29.369473, _binary 0x00000000010100000048c153c8955e3d40201b92a4b5724440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:55:50","ind":0,"enl":"40.8961683","boy":"029.369473","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":111.30520000000001,"mes":47538.6,"yon":343,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:55:50"}', '2025-08-25 13:55:50', '2025-08-25 13:55:52'),
	(2407707, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.011808, 29.050980, _binary 0x00000000010100000005c078060d0d3d40222933ef82814440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"25.08.2025","sat":"23:56:02","ind":0,"enl":"41.0118083","boy":"029.050980","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43113.3,"yon":250,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-25 23:56:02"}', '2025-08-25 13:56:02', '2025-08-25 13:56:03'),
	(2407708, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.900732, 29.367246, _binary 0x0000000001010000003a9677d5035e3d4039fc242d4b734440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:56:07","ind":0,"enl":"40.9007317","boy":"029.367246","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":117.34272,"mes":47539.2,"yon":334,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:56:07"}', '2025-08-25 13:56:07', '2025-08-25 13:56:14'),
	(2407709, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.905342, 29.363601, _binary 0x000000000101000000fbca83f4145d3d403f9aa03ce2734440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:56:25","ind":0,"enl":"40.9053417","boy":"029.363601","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":116.0278,"mes":47539.8,"yon":323,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:56:25"}', '2025-08-25 13:56:25', '2025-08-25 13:56:26'),
	(2407710, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.909175, 29.359326, _binary 0x0000000001010000003d9aeac9fc5b3d409fabadd85f744440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:56:42","ind":0,"enl":"40.9091750","boy":"029.359326","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":115.23144,"mes":47540.4,"yon":321,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:56:42"}', '2025-08-25 13:56:42', '2025-08-25 13:56:44'),
	(2407711, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.913673, 29.355416, _binary 0x000000000101000000a379008bfc5a3d403c5d273ff3744440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:57:00","ind":0,"enl":"40.9136733","boy":"029.355416","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":112.21268,"mes":47541,"yon":331,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:57:00"}', '2025-08-25 13:57:00', '2025-08-25 13:57:01'),
	(2407712, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.918237, 29.352698, _binary 0x000000000101000000575d876a4a5a3d40553ebac788754440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:57:17","ind":0,"enl":"40.9182367","boy":"029.352698","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":125.88044000000001,"mes":47541.4,"yon":341,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:57:17"}', '2025-08-25 13:57:17', '2025-08-25 13:57:18'),
	(2407713, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.923390, 29.350993, _binary 0x000000000101000000fb1f60adda593d400ababda431764440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:57:34","ind":0,"enl":"40.9233900","boy":"029.350993","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":123.3432,"mes":47542,"yon":347,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:57:34"}', '2025-08-25 13:57:34', '2025-08-25 13:57:37'),
	(2407714, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.927817, 29.348590, _binary 0x00000000010100000070b6b9313d593d40619797b2c2764440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:57:50","ind":0,"enl":"40.9278167","boy":"029.348590","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":116.0278,"mes":47542.6,"yon":328,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:57:50"}', '2025-08-25 13:57:50', '2025-08-25 13:57:52'),
	(2407715, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.931608, 29.343630, _binary 0x000000000101000000abecbb22f8573d405197d6f03e774440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:58:08","ind":0,"enl":"40.9316083","boy":"029.343630","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":123.86176,"mes":47543.2,"yon":304,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:58:08"}', '2025-08-25 13:58:08', '2025-08-25 13:58:09'),
	(2407716, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.933848, 29.337716, _binary 0x0000000001010000000056478e74563d406df6515788774440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:58:24","ind":0,"enl":"40.9338483","boy":"029.337716","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":124.32476,"mes":47543.6,"yon":295,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:58:24"}', '2025-08-25 13:58:24', '2025-08-25 13:58:25'),
	(2407717, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.936618, 29.331510, _binary 0x000000000101000000064ce0d6dd543d40e5aac31be3774440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:58:41","ind":0,"enl":"40.9366183","boy":"029.331510","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":131.34384,"mes":47544.2,"yon":305,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:58:41"}', '2025-08-25 13:58:41', '2025-08-25 13:58:42'),
	(2407718, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.939478, 29.326498, _binary 0x0000000001010000009c35785f95533d409de62ed340784440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:58:56","ind":0,"enl":"40.9394783","boy":"029.326498","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":102.69340000000001,"mes":47544.8,"yon":304,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:58:56"}', '2025-08-25 13:58:56', '2025-08-25 13:58:58'),
	(2407719, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.941928, 29.320548, _binary 0x00000000010100000057cc086f0f523d40a4d6451b91784440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:59:17","ind":0,"enl":"40.9419283","boy":"029.320548","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":110.21252,"mes":47545.4,"yon":296,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:59:17"}', '2025-08-25 13:59:17', '2025-08-25 13:59:19'),
	(2407720, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.944353, 29.315041, _binary 0x0000000001010000002ee6e786a6503d4052afa591e0784440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:59:34","ind":0,"enl":"40.9443533","boy":"029.315041","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":117.34272,"mes":47545.8,"yon":305,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:59:34"}', '2025-08-25 13:59:34', '2025-08-25 13:59:36'),
	(2407721, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.947748, 29.310021, _binary 0x000000000101000000be1248895d4f3d4078abf8d04f794440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"25.08.2025","sat":"23:59:51","ind":0,"enl":"40.9477483","boy":"029.310021","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":122.17644,"mes":47546.4,"yon":312,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-25 23:59:51"}', '2025-08-25 13:59:51', '2025-08-25 13:59:55'),
	(2407756, '178.240.219.188:48832', '353201357563383', 40.997282, 29.048400, _binary 0x0000000001010000005c2041f1630c3d40877368eca67f4440, '0', '{"device_model": "Teltonika", "p": "1", "did": "353201357563383", "trh": "2025-08-26", "sat": "00:07:28", "ind": 0, "enl": "40.9972816", "boy": "29.0484", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 3.137, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12001, "battery_voltage": 0, "battery_current": 0, "record_timestamp": "2025-08-26 00:07:28", "codec_id": 8}', '2025-08-25 14:07:28', '2025-08-25 14:09:02'),
	(2407804, '176.227.45.207:17568', '350612079185623', 41.014947, 29.054153, _binary 0x00000000010100000071789cfddc0d3d40dc172bc5e9814440, '0', '{"device_model": "Teltonika", "p": "1", "did": "350612079185623", "trh": "2025-08-26", "sat": "00:39:48", "ind": 0, "enl": "41.0149466", "boy": "29.0541533", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 27279.236, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12660, "battery_voltage": 4057, "battery_current": 0, "record_timestamp": "2025-08-26 00:39:48", "codec_id": 8}', '2025-08-25 14:39:48', '2025-08-25 14:42:02'),
	(2407821, '176.237.78.42:17355', '353201357563383', 40.997282, 29.048400, _binary 0x0000000001010000005c2041f1630c3d40877368eca67f4440, '0', '{"device_model": "Teltonika", "p": "1", "did": "353201357563383", "trh": "2025-08-26", "sat": "01:07:28", "ind": 0, "enl": "40.9972816", "boy": "29.0484", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 3.137, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12001, "battery_voltage": 0, "battery_current": 0, "record_timestamp": "2025-08-26 01:07:28", "codec_id": 8}', '2025-08-25 15:07:28', '2025-08-25 15:10:01'),
	(2407837, '178.243.201.173:59538', '350612079185623', 41.014947, 29.054153, _binary 0x00000000010100000071789cfddc0d3d40dc172bc5e9814440, '0', '{"device_model": "Teltonika", "p": "1", "did": "350612079185623", "trh": "2025-08-26", "sat": "01:39:54", "ind": 0, "enl": "41.0149466", "boy": "29.0541533", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 27279.236, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12660, "battery_voltage": 4057, "battery_current": 0, "record_timestamp": "2025-08-26 01:39:54", "codec_id": 8}', '2025-08-25 15:39:54', '2025-08-25 15:42:01'),
	(2407850, '176.238.4.228:58443', '353201357563383', 40.997282, 29.048400, _binary 0x0000000001010000005c2041f1630c3d40877368eca67f4440, '0', '{"device_model": "Teltonika", "p": "1", "did": "353201357563383", "trh": "2025-08-26", "sat": "02:07:28", "ind": 0, "enl": "40.9972816", "boy": "29.0484", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 3.137, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12001, "battery_voltage": 0, "battery_current": 0, "record_timestamp": "2025-08-26 02:07:28", "codec_id": 8}', '2025-08-25 16:07:28', '2025-08-25 16:08:02'),
	(2407870, '31.143.249.245:23237', '350612079185623', 41.014947, 29.054153, _binary 0x00000000010100000071789cfddc0d3d40dc172bc5e9814440, '0', '{"device_model": "Teltonika", "p": "1", "did": "350612079185623", "trh": "2025-08-26", "sat": "02:40:01", "ind": 0, "enl": "41.0149466", "boy": "29.0541533", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 27279.236, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12660, "battery_voltage": 4057, "battery_current": 0, "record_timestamp": "2025-08-26 02:40:01", "codec_id": 8}', '2025-08-25 16:40:01', '2025-08-25 16:42:02'),
	(2407878, '31.143.59.246:59440', '86090604649604512', 41.012470, 29.125526, _binary 0x00000000010100000036ccd07822203d402f17f19d98814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"03:00:52","ind":0,"enl":"41.0124700","boy":"029.125526","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":132,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:00:52"}', '2025-08-25 17:00:52', '2025-08-25 17:00:54'),
	(2407880, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.011808, 29.050980, _binary 0x00000000010100000005c078060d0d3d40222933ef82814440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"03:02:16","ind":0,"enl":"41.0118083","boy":"029.050980","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43113.3,"yon":329,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:02:16"}', '2025-08-25 17:02:16', '2025-08-25 17:02:17'),
	(2407881, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"03:03:10","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":39,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:03:10"}', '2025-08-25 17:03:10', '2025-08-25 17:03:11'),
	(2407882, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"03:03:27","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:03:27"}', '2025-08-25 17:03:27', '2025-08-25 17:03:24'),
	(2407883, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"03:04:03","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"21","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:04:03"}', '2025-08-25 17:04:03', '2025-08-25 17:03:59'),
	(2407884, '31.142.11.211:47910', '353201357563383', 40.997282, 29.048400, _binary 0x0000000001010000005c2041f1630c3d40877368eca67f4440, '0', '{"device_model": "Teltonika", "p": "1", "did": "353201357563383", "trh": "2025-08-26", "sat": "03:07:28", "ind": 0, "enl": "40.9972816", "boy": "29.0484", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 3.137, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12001, "battery_voltage": 0, "battery_current": 0, "record_timestamp": "2025-08-26 03:07:28", "codec_id": 8}', '2025-08-25 17:07:28', '2025-08-25 17:09:02'),
	(2407885, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"26.08.2025","sat":"03:09:39","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":29,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:09:39"}', '2025-08-25 17:09:39', '2025-08-25 17:09:41'),
	(2407886, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"26.08.2025","sat":"03:09:42","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":270,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:09:42"}', '2025-08-25 17:09:42', '2025-08-25 17:09:44'),
	(2407887, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003660, 29.079390, _binary 0x00000000010100000023a12de752143d40d5264eee77804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"03:10:08","ind":0,"enl":"41.0036600","boy":"029.079390","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94765.6,"yon":344,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:10:08"}', '2025-08-25 17:10:08', '2025-08-25 17:10:11'),
	(2407888, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"26.08.2025","sat":"03:11:34","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":209,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:11:34"}', '2025-08-25 17:11:34', '2025-08-25 17:11:36'),
	(2407889, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"03:14:03","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:14:03"}', '2025-08-25 17:14:03', '2025-08-25 17:14:00'),
	(2407890, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003753, 29.224698, _binary 0x000000000101000000037ae1ce85393d404460f6fc7a804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"03:16:46","ind":0,"enl":"41.0037533","boy":"029.224698","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43221.7,"yon":276,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:16:46"}', '2025-08-25 17:16:46', '2025-08-25 17:16:49'),
	(2407891, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"03:18:34","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":342,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:18:34"}', '2025-08-25 17:18:34', '2025-08-25 17:18:35'),
	(2407892, '31.143.219.198:35638', '86284304533376212', 40.992082, 28.905356, _binary 0x000000000101000000c53c2b69c5e73c40e43a7c88fc7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"03:21:14","ind":0,"enl":"40.9920817","boy":"028.905356","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10953.7,"yon":333,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:21:14"}', '2025-08-25 17:21:14', '2025-08-25 17:21:17'),
	(2407893, '31.143.21.53:17428', '44fe033664dac2621', 41.012117, 29.050781, _binary 0x0000000001010000001842cefbff0c3d40231e3f0a8d814440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"03:23:58","ind":0,"enl":"41.0121167","boy":"029.050781","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74647.3,"yon":117,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:23:58"}', '2025-08-25 17:23:58', '2025-08-25 17:23:59'),
	(2407894, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"03:24:04","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:24:04"}', '2025-08-25 17:24:04', '2025-08-25 17:24:00'),
	(2407895, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997470, 29.074741, _binary 0x0000000001010000009babe63922133d40dd5ed218ad7f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"26.08.2025","sat":"03:26:40","ind":0,"enl":"40.9974700","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":72,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:26:40"}', '2025-08-25 17:26:40', '2025-08-25 17:26:42'),
	(2407896, '31.143.59.246:59440', '86090604649604512', 41.012470, 29.125526, _binary 0x00000000010100000036ccd07822203d402f17f19d98814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"03:31:39","ind":0,"enl":"41.0124700","boy":"029.125526","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":340,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:31:39"}', '2025-08-25 17:31:39', '2025-08-25 17:31:41'),
	(2407897, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.011808, 29.050980, _binary 0x00000000010100000005c078060d0d3d40222933ef82814440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"03:33:19","ind":0,"enl":"41.0118083","boy":"029.050980","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43113.3,"yon":310,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:33:19"}', '2025-08-25 17:33:19', '2025-08-25 17:33:20'),
	(2407898, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"03:33:59","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":272,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:33:59"}', '2025-08-25 17:33:59', '2025-08-25 17:34:00'),
	(2407899, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"03:34:04","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:34:04"}', '2025-08-25 17:34:04', '2025-08-25 17:34:01'),
	(2407900, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"26.08.2025","sat":"03:40:40","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":145,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:40:40"}', '2025-08-25 17:40:40', '2025-08-25 17:40:42'),
	(2407901, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"26.08.2025","sat":"03:40:43","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":348,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:40:43"}', '2025-08-25 17:40:43', '2025-08-25 17:40:45'),
	(2407902, '188.58.69.139:21682', '350612079185623', 41.014947, 29.054153, _binary 0x00000000010100000071789cfddc0d3d40dc172bc5e9814440, '0', '{"device_model": "Teltonika", "p": "1", "did": "350612079185623", "trh": "2025-08-26", "sat": "03:40:06", "ind": 0, "enl": "41.0149466", "boy": "29.0541533", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 27279.236, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12660, "battery_voltage": 4057, "battery_current": 0, "record_timestamp": "2025-08-26 03:40:06", "codec_id": 8}', '2025-08-25 17:40:06', '2025-08-25 17:42:01'),
	(2407903, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003660, 29.079390, _binary 0x00000000010100000023a12de752143d40d5264eee77804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"03:41:10","ind":0,"enl":"41.0036600","boy":"029.079390","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94765.6,"yon":169,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:41:10"}', '2025-08-25 17:41:10', '2025-08-25 17:41:13'),
	(2407904, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"26.08.2025","sat":"03:42:37","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":332,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:42:37"}', '2025-08-25 17:42:37', '2025-08-25 17:42:40'),
	(2407905, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"03:44:04","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:44:04"}', '2025-08-25 17:44:04', '2025-08-25 17:44:00'),
	(2407906, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003753, 29.224698, _binary 0x000000000101000000037ae1ce85393d404460f6fc7a804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"03:47:49","ind":0,"enl":"41.0037533","boy":"029.224698","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43221.7,"yon":228,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:47:49"}', '2025-08-25 17:47:49', '2025-08-25 17:47:52'),
	(2407907, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"03:49:24","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":109,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:49:24"}', '2025-08-25 17:49:24', '2025-08-25 17:49:25'),
	(2407908, '31.143.219.198:35638', '86284304533376212', 40.992082, 28.905356, _binary 0x000000000101000000c53c2b69c5e73c40e43a7c88fc7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"03:52:15","ind":0,"enl":"40.9920817","boy":"028.905356","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10953.7,"yon":68,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:52:15"}', '2025-08-25 17:52:15', '2025-08-25 17:52:17'),
	(2407909, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"03:54:04","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:54:04"}', '2025-08-25 17:54:04', '2025-08-25 17:54:01'),
	(2407910, '31.143.21.53:17428', '44fe033664dac2621', 41.012117, 29.050781, _binary 0x0000000001010000001842cefbff0c3d40231e3f0a8d814440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"03:55:05","ind":0,"enl":"41.0121167","boy":"029.050781","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74647.3,"yon":247,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:55:05"}', '2025-08-25 17:55:05', '2025-08-25 17:55:07'),
	(2407911, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997470, 29.074741, _binary 0x0000000001010000009babe63922133d40dd5ed218ad7f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"26.08.2025","sat":"03:57:41","ind":0,"enl":"40.9974700","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":47,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:57:41"}', '2025-08-25 17:57:41', '2025-08-25 17:57:43'),
	(2407912, '31.143.59.246:59440', '86090604649604512', 41.012470, 29.125526, _binary 0x00000000010100000036ccd07822203d402f17f19d98814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"04:02:46","ind":0,"enl":"41.0124700","boy":"029.125526","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":172,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:02:46"}', '2025-08-25 18:02:46', '2025-08-25 18:02:48'),
	(2407913, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"04:04:05","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:04:05"}', '2025-08-25 18:04:05', '2025-08-25 18:04:01'),
	(2407914, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.011808, 29.050980, _binary 0x00000000010100000005c078060d0d3d40222933ef82814440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"04:04:22","ind":0,"enl":"41.0118083","boy":"029.050980","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43113.3,"yon":340,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:04:22"}', '2025-08-25 18:04:22', '2025-08-25 18:04:24'),
	(2407915, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"04:04:40","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"21","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:04:40"}', '2025-08-25 18:04:40', '2025-08-25 18:04:36'),
	(2407916, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"04:04:48","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":243,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:04:48"}', '2025-08-25 18:04:48', '2025-08-25 18:04:49'),
	(2407917, '178.247.74.120:52786', '353201357563383', 40.997282, 29.048400, _binary 0x0000000001010000005c2041f1630c3d40877368eca67f4440, '0', '{"device_model": "Teltonika", "p": "1", "did": "353201357563383", "trh": "2025-08-26", "sat": "04:07:28", "ind": 0, "enl": "40.9972816", "boy": "29.0484", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 3.137, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12001, "battery_voltage": 0, "battery_current": 0, "record_timestamp": "2025-08-26 04:07:28", "codec_id": 8}', '2025-08-25 18:07:28', '2025-08-25 18:08:02'),
	(2407918, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"26.08.2025","sat":"04:11:41","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":200,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:11:41"}', '2025-08-25 18:11:41', '2025-08-25 18:11:44'),
	(2407919, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"26.08.2025","sat":"04:11:45","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":169,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:11:45"}', '2025-08-25 18:11:45', '2025-08-25 18:11:47'),
	(2407920, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003660, 29.079390, _binary 0x00000000010100000023a12de752143d40d5264eee77804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"04:12:14","ind":0,"enl":"41.0036600","boy":"029.079390","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94765.6,"yon":156,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:12:14"}', '2025-08-25 18:12:14', '2025-08-25 18:12:16'),
	(2407921, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"26.08.2025","sat":"04:13:40","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":96,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:13:40"}', '2025-08-25 18:13:40', '2025-08-25 18:13:42'),
	(2407922, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"04:14:41","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:14:41"}', '2025-08-25 18:14:41', '2025-08-25 18:14:37'),
	(2407923, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003753, 29.224698, _binary 0x000000000101000000037ae1ce85393d404460f6fc7a804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"04:18:53","ind":0,"enl":"41.0037533","boy":"029.224698","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43221.7,"yon":300,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:18:53"}', '2025-08-25 18:18:53', '2025-08-25 18:18:55'),
	(2407924, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"04:20:12","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":327,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:20:12"}', '2025-08-25 18:20:12', '2025-08-25 18:20:14'),
	(2407925, '31.143.219.198:35638', '86284304533376212', 40.992082, 28.905356, _binary 0x000000000101000000c53c2b69c5e73c40e43a7c88fc7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"04:23:14","ind":0,"enl":"40.9920817","boy":"028.905356","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10953.7,"yon":297,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:23:14"}', '2025-08-25 18:23:14', '2025-08-25 18:23:17'),
	(2407926, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"04:24:41","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:24:41"}', '2025-08-25 18:24:41', '2025-08-25 18:24:38'),
	(2407927, '31.143.21.53:17428', '44fe033664dac2621', 41.012117, 29.050781, _binary 0x0000000001010000001842cefbff0c3d40231e3f0a8d814440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"04:26:13","ind":0,"enl":"41.0121167","boy":"029.050781","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74647.3,"yon":161,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:26:13"}', '2025-08-25 18:26:13', '2025-08-25 18:26:14'),
	(2407928, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997470, 29.074741, _binary 0x0000000001010000009babe63922133d40dd5ed218ad7f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"26.08.2025","sat":"04:28:42","ind":0,"enl":"40.9974700","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":187,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:28:42"}', '2025-08-25 18:28:42', '2025-08-25 18:28:44'),
	(2407929, '31.143.59.246:59440', '86090604649604512', 41.012470, 29.125526, _binary 0x00000000010100000036ccd07822203d402f17f19d98814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"04:33:54","ind":0,"enl":"41.0124700","boy":"029.125526","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":286,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:33:54"}', '2025-08-25 18:33:54', '2025-08-25 18:33:55'),
	(2407930, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"04:34:41","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:34:41"}', '2025-08-25 18:34:41', '2025-08-25 18:34:38'),
	(2407931, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.011808, 29.050980, _binary 0x00000000010100000005c078060d0d3d40222933ef82814440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"04:35:25","ind":0,"enl":"41.0118083","boy":"029.050980","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43113.3,"yon":113,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:35:25"}', '2025-08-25 18:35:25', '2025-08-25 18:35:26'),
	(2407932, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"04:35:37","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":147,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:35:37"}', '2025-08-25 18:35:37', '2025-08-25 18:35:38'),
	(2407933, '178.240.164.172:38315', '350612079185623', 41.014947, 29.054153, _binary 0x00000000010100000071789cfddc0d3d40dc172bc5e9814440, '0', '{"device_model": "Teltonika", "p": "1", "did": "350612079185623", "trh": "2025-08-26", "sat": "04:40:12", "ind": 0, "enl": "41.0149466", "boy": "29.0541533", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 27279.236, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12656, "battery_voltage": 4057, "battery_current": 0, "record_timestamp": "2025-08-26 04:40:12", "codec_id": 8}', '2025-08-25 18:40:12', '2025-08-25 18:42:02'),
	(2407934, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"26.08.2025","sat":"04:42:43","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":42,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:42:43"}', '2025-08-25 18:42:43', '2025-08-25 18:42:45'),
	(2407935, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"26.08.2025","sat":"04:42:46","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":244,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:42:46"}', '2025-08-25 18:42:46', '2025-08-25 18:42:48'),
	(2407936, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003660, 29.079390, _binary 0x00000000010100000023a12de752143d40d5264eee77804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"04:43:17","ind":0,"enl":"41.0036600","boy":"029.079390","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94765.6,"yon":66,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:43:17"}', '2025-08-25 18:43:17', '2025-08-25 18:43:21'),
	(2407937, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"04:44:42","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:44:42"}', '2025-08-25 18:44:42', '2025-08-25 18:44:38'),
	(2407938, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"26.08.2025","sat":"04:44:43","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":177,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:44:43"}', '2025-08-25 18:44:43', '2025-08-25 18:44:46'),
	(2407939, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003753, 29.224698, _binary 0x000000000101000000037ae1ce85393d404460f6fc7a804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"04:49:57","ind":0,"enl":"41.0037533","boy":"029.224698","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43221.7,"yon":277,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:49:57"}', '2025-08-25 18:49:57', '2025-08-25 18:49:59'),
	(2407940, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"04:51:01","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":128,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:51:01"}', '2025-08-25 18:51:01', '2025-08-25 18:51:02'),
	(2407941, '31.143.219.198:35638', '86284304533376212', 40.992082, 28.905356, _binary 0x000000000101000000c53c2b69c5e73c40e43a7c88fc7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"04:54:14","ind":0,"enl":"40.9920817","boy":"028.905356","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10953.7,"yon":45,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:54:14"}', '2025-08-25 18:54:14', '2025-08-25 18:54:17'),
	(2407942, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"04:54:42","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:54:42"}', '2025-08-25 18:54:42', '2025-08-25 18:54:38'),
	(2407943, '31.143.21.53:17428', '44fe033664dac2621', 41.012117, 29.050781, _binary 0x0000000001010000001842cefbff0c3d40231e3f0a8d814440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"04:57:20","ind":0,"enl":"41.0121167","boy":"029.050781","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74647.3,"yon":146,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:57:20"}', '2025-08-25 18:57:20', '2025-08-25 18:57:22'),
	(2407944, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997470, 29.074741, _binary 0x0000000001010000009babe63922133d40dd5ed218ad7f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"26.08.2025","sat":"04:59:43","ind":0,"enl":"40.9974700","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":77,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 04:59:43"}', '2025-08-25 18:59:43', '2025-08-25 18:59:45'),
	(2407945, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"05:04:42","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:04:42"}', '2025-08-25 19:04:42', '2025-08-25 19:04:38'),
	(2407946, '31.143.59.246:59440', '86090604649604512', 41.012470, 29.125526, _binary 0x00000000010100000036ccd07822203d402f17f19d98814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"05:05:03","ind":0,"enl":"41.0124700","boy":"029.125526","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":226,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:05:03"}', '2025-08-25 19:05:03', '2025-08-25 19:05:04'),
	(2407947, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"05:05:17","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"21","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:05:17"}', '2025-08-25 19:05:17', '2025-08-25 19:05:13'),
	(2407948, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"05:06:26","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":235,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:06:26"}', '2025-08-25 19:06:26', '2025-08-25 19:06:27'),
	(2407949, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.011165, 29.051533, _binary 0x0000000001010000002eaa4544310d3d400feeceda6d814440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"05:06:27","ind":0,"enl":"41.0111650","boy":"029.051533","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43113.3,"yon":103,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:06:27"}', '2025-08-25 19:06:27', '2025-08-25 19:06:28'),
	(2407950, '176.227.16.14:17928', '353201357563383', 40.997282, 29.048400, _binary 0x0000000001010000005c2041f1630c3d40877368eca67f4440, '0', '{"device_model": "Teltonika", "p": "1", "did": "353201357563383", "trh": "2025-08-26", "sat": "05:07:28", "ind": 0, "enl": "40.9972816", "boy": "29.0484", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 3.137, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12001, "battery_voltage": 0, "battery_current": 0, "record_timestamp": "2025-08-26 05:07:28", "codec_id": 8}', '2025-08-25 19:07:28', '2025-08-25 19:09:01'),
	(2407951, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"26.08.2025","sat":"05:13:44","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":272,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:13:44"}', '2025-08-25 19:13:44', '2025-08-25 19:13:47'),
	(2407952, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"26.08.2025","sat":"05:13:48","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":24,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:13:48"}', '2025-08-25 19:13:48', '2025-08-25 19:13:51'),
	(2407953, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003660, 29.079390, _binary 0x00000000010100000023a12de752143d40d5264eee77804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"05:14:21","ind":0,"enl":"41.0036600","boy":"029.079390","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94765.6,"yon":272,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:14:21"}', '2025-08-25 19:14:21', '2025-08-25 19:14:24'),
	(2407954, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"05:15:17","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:15:17"}', '2025-08-25 19:15:17', '2025-08-25 19:15:12'),
	(2407955, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"26.08.2025","sat":"05:15:48","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":152,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:15:48"}', '2025-08-25 19:15:48', '2025-08-25 19:15:51'),
	(2407956, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003753, 29.224698, _binary 0x000000000101000000037ae1ce85393d404460f6fc7a804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"05:21:02","ind":0,"enl":"41.0037533","boy":"029.224698","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43221.7,"yon":217,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:21:02"}', '2025-08-25 19:21:02', '2025-08-25 19:21:04'),
	(2407957, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"05:21:50","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":248,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:21:50"}', '2025-08-25 19:21:50', '2025-08-25 19:21:52'),
	(2407958, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"05:25:17","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:25:17"}', '2025-08-25 19:25:17', '2025-08-25 19:25:12'),
	(2407959, '31.143.219.198:35638', '86284304533376212', 40.992082, 28.905356, _binary 0x000000000101000000c53c2b69c5e73c40e43a7c88fc7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"05:25:15","ind":0,"enl":"40.9920817","boy":"028.905356","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10953.7,"yon":348,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:25:15"}', '2025-08-25 19:25:15', '2025-08-25 19:25:17'),
	(2407960, '31.143.21.53:17428', '44fe033664dac2621', 41.012117, 29.050781, _binary 0x0000000001010000001842cefbff0c3d40231e3f0a8d814440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"05:28:30","ind":0,"enl":"41.0121167","boy":"029.050781","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74647.3,"yon":132,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:28:30"}', '2025-08-25 19:28:30', '2025-08-25 19:28:31'),
	(2407961, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997470, 29.074741, _binary 0x0000000001010000009babe63922133d40dd5ed218ad7f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"26.08.2025","sat":"05:30:45","ind":0,"enl":"40.9974700","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":259,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:30:45"}', '2025-08-25 19:30:45', '2025-08-25 19:30:47'),
	(2407962, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"05:35:17","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:35:17"}', '2025-08-25 19:35:17', '2025-08-25 19:35:13'),
	(2407963, '31.143.59.246:59440', '86090604649604512', 41.012470, 29.125526, _binary 0x00000000010100000036ccd07822203d402f17f19d98814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"05:36:12","ind":0,"enl":"41.0124700","boy":"029.125526","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":40,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:36:12"}', '2025-08-25 19:36:12', '2025-08-25 19:36:13'),
	(2407964, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"05:37:15","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":164,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:37:15"}', '2025-08-25 19:37:15', '2025-08-25 19:37:16'),
	(2407965, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.010788, 29.051805, _binary 0x000000000101000000f0c4ac17430d3d40f8d6d18261814440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"05:37:30","ind":0,"enl":"41.0107883","boy":"029.051805","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43113.3,"yon":209,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:37:30"}', '2025-08-25 19:37:30', '2025-08-25 19:37:32'),
	(2407966, '31.143.66.159:37889', '350612079185623', 41.014947, 29.054153, _binary 0x00000000010100000071789cfddc0d3d40dc172bc5e9814440, '0', '{"device_model": "Teltonika", "p": "1", "did": "350612079185623", "trh": "2025-08-26", "sat": "05:40:18", "ind": 0, "enl": "41.0149466", "boy": "29.0541533", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 27279.236, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12640, "battery_voltage": 4057, "battery_current": 0, "record_timestamp": "2025-08-26 05:40:18", "codec_id": 8}', '2025-08-25 19:40:18', '2025-08-25 19:42:01'),
	(2407967, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"26.08.2025","sat":"05:44:47","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":70,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:44:47"}', '2025-08-25 19:44:47', '2025-08-25 19:44:50'),
	(2407968, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"26.08.2025","sat":"05:44:51","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":136,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:44:51"}', '2025-08-25 19:44:51', '2025-08-25 19:44:53'),
	(2407969, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"05:45:17","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:45:17"}', '2025-08-25 19:45:17', '2025-08-25 19:45:13'),
	(2407970, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003660, 29.079390, _binary 0x00000000010100000023a12de752143d40d5264eee77804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"05:45:25","ind":0,"enl":"41.0036600","boy":"029.079390","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94765.6,"yon":259,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:45:25"}', '2025-08-25 19:45:25', '2025-08-25 19:45:28'),
	(2407971, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"26.08.2025","sat":"05:46:52","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":181,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:46:52"}', '2025-08-25 19:46:52', '2025-08-25 19:46:55'),
	(2407972, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003753, 29.224698, _binary 0x000000000101000000037ae1ce85393d404460f6fc7a804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"05:52:06","ind":0,"enl":"41.0037533","boy":"029.224698","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43221.7,"yon":178,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:52:06"}', '2025-08-25 19:52:06', '2025-08-25 19:52:09'),
	(2407973, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"05:52:40","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":228,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:52:40"}', '2025-08-25 19:52:40', '2025-08-25 19:52:41'),
	(2407974, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"05:55:18","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:55:18"}', '2025-08-25 19:55:18', '2025-08-25 19:55:13'),
	(2407975, '31.143.219.198:35638', '86284304533376212', 40.992082, 28.905356, _binary 0x000000000101000000c53c2b69c5e73c40e43a7c88fc7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"05:56:16","ind":0,"enl":"40.9920817","boy":"028.905356","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10953.7,"yon":347,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:56:16"}', '2025-08-25 19:56:16', '2025-08-25 19:56:18'),
	(2407976, '31.143.21.53:17428', '44fe033664dac2621', 41.012117, 29.050781, _binary 0x0000000001010000001842cefbff0c3d40231e3f0a8d814440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"05:59:38","ind":0,"enl":"41.0121167","boy":"029.050781","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74647.3,"yon":28,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 05:59:38"}', '2025-08-25 19:59:38', '2025-08-25 19:59:40'),
	(2407977, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997470, 29.074741, _binary 0x0000000001010000009babe63922133d40dd5ed218ad7f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"26.08.2025","sat":"06:01:47","ind":0,"enl":"40.9974700","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":228,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:01:47"}', '2025-08-25 20:01:47', '2025-08-25 20:01:49'),
	(2407978, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"06:05:18","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:05:18"}', '2025-08-25 20:05:18', '2025-08-25 20:05:13'),
	(2407979, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"06:05:54","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"21","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:05:54"}', '2025-08-25 20:05:54', '2025-08-25 20:05:50'),
	(2407980, '31.143.59.246:59440', '86090604649604512', 41.012470, 29.125526, _binary 0x00000000010100000036ccd07822203d402f17f19d98814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"06:07:20","ind":0,"enl":"41.0124700","boy":"029.125526","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":162,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:07:20"}', '2025-08-25 20:07:20', '2025-08-25 20:07:21'),
	(2407981, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"06:08:04","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":100,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:08:04"}', '2025-08-25 20:08:04', '2025-08-25 20:08:06'),
	(2407982, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.011258, 29.050788, _binary 0x0000000001010000007d073f71000d3d407f2777e970814440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"06:08:34","ind":0,"enl":"41.0112583","boy":"029.050788","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43113.3,"yon":343,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:08:34"}', '2025-08-25 20:08:34', '2025-08-25 20:08:35'),
	(2407983, '188.57.72.133:57791', '353201357563383', 40.997282, 29.048400, _binary 0x0000000001010000005c2041f1630c3d40877368eca67f4440, '0', '{"device_model": "Teltonika", "p": "1", "did": "353201357563383", "trh": "2025-08-26", "sat": "06:07:28", "ind": 0, "enl": "40.9972816", "boy": "29.0484", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 3.137, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12001, "battery_voltage": 0, "battery_current": 0, "record_timestamp": "2025-08-26 06:07:28", "codec_id": 8}', '2025-08-25 20:07:28', '2025-08-25 20:10:02'),
	(2407984, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"06:15:54","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:15:54"}', '2025-08-25 20:15:54', '2025-08-25 20:15:50'),
	(2407985, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"26.08.2025","sat":"06:15:50","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":23,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:15:50"}', '2025-08-25 20:15:50', '2025-08-25 20:15:53'),
	(2407986, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"26.08.2025","sat":"06:15:53","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":228,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:15:53"}', '2025-08-25 20:15:53', '2025-08-25 20:15:56'),
	(2407987, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003660, 29.079390, _binary 0x00000000010100000023a12de752143d40d5264eee77804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"06:16:29","ind":0,"enl":"41.0036600","boy":"029.079390","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94765.6,"yon":357,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:16:29"}', '2025-08-25 20:16:29', '2025-08-25 20:16:32'),
	(2407988, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"26.08.2025","sat":"06:17:56","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":231,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:17:56"}', '2025-08-25 20:17:56', '2025-08-25 20:17:59'),
	(2407989, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003753, 29.224698, _binary 0x000000000101000000037ae1ce85393d404460f6fc7a804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"06:23:11","ind":0,"enl":"41.0037533","boy":"029.224698","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43221.7,"yon":158,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:23:11"}', '2025-08-25 20:23:11', '2025-08-25 20:23:13'),
	(2407990, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"06:23:29","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":244,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:23:29"}', '2025-08-25 20:23:29', '2025-08-25 20:23:31'),
	(2407991, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"06:25:54","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:25:54"}', '2025-08-25 20:25:54', '2025-08-25 20:25:50'),
	(2407992, '31.143.219.198:35638', '86284304533376212', 40.992082, 28.905356, _binary 0x000000000101000000c53c2b69c5e73c40e43a7c88fc7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"06:27:17","ind":0,"enl":"40.9920817","boy":"028.905356","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10953.7,"yon":343,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:27:17"}', '2025-08-25 20:27:17', '2025-08-25 20:27:19'),
	(2407993, '31.143.21.53:17428', '44fe033664dac2621', 41.012117, 29.050781, _binary 0x0000000001010000001842cefbff0c3d40231e3f0a8d814440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"06:30:47","ind":0,"enl":"41.0121167","boy":"029.050781","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74647.3,"yon":227,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:30:47"}', '2025-08-25 20:30:47', '2025-08-25 20:30:48'),
	(2407994, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997470, 29.074741, _binary 0x0000000001010000009babe63922133d40dd5ed218ad7f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"26.08.2025","sat":"06:32:49","ind":0,"enl":"40.9974700","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":90,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:32:49"}', '2025-08-25 20:32:49', '2025-08-25 20:32:51'),
	(2407995, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"06:35:55","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:35:55"}', '2025-08-25 20:35:55', '2025-08-25 20:35:50'),
	(2407996, '31.143.59.246:59440', '86090604649604512', 41.012470, 29.125526, _binary 0x00000000010100000036ccd07822203d402f17f19d98814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"06:38:29","ind":0,"enl":"41.0124700","boy":"029.125526","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":106,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:38:29"}', '2025-08-25 20:38:29', '2025-08-25 20:38:30'),
	(2407997, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"06:38:54","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":40,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:38:54"}', '2025-08-25 20:38:54', '2025-08-25 20:38:56'),
	(2407998, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.011258, 29.050788, _binary 0x0000000001010000007d073f71000d3d407f2777e970814440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"06:39:37","ind":0,"enl":"41.0112583","boy":"029.050788","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43113.3,"yon":200,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:39:37"}', '2025-08-25 20:39:37', '2025-08-25 20:39:39'),
	(2407999, '178.247.158.89:19461', '350612079185623', 41.014947, 29.054153, _binary 0x00000000010100000071789cfddc0d3d40dc172bc5e9814440, '0', '{"device_model": "Teltonika", "p": "1", "did": "350612079185623", "trh": "2025-08-26", "sat": "06:40:25", "ind": 0, "enl": "41.0149466", "boy": "29.0541533", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 27279.236, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12620, "battery_voltage": 4057, "battery_current": 0, "record_timestamp": "2025-08-26 06:40:25", "codec_id": 8}', '2025-08-25 20:40:25', '2025-08-25 20:42:02'),
	(2408000, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"06:45:55","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:45:55"}', '2025-08-25 20:45:55', '2025-08-25 20:45:50'),
	(2408001, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"26.08.2025","sat":"06:46:53","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":55,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:46:53"}', '2025-08-25 20:46:53', '2025-08-25 20:46:55'),
	(2408002, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"26.08.2025","sat":"06:46:56","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":166,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:46:56"}', '2025-08-25 20:46:56', '2025-08-25 20:46:59'),
	(2408003, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003660, 29.079390, _binary 0x00000000010100000023a12de752143d40d5264eee77804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"06:47:32","ind":0,"enl":"41.0036600","boy":"029.079390","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94765.6,"yon":156,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:47:32"}', '2025-08-25 20:47:32', '2025-08-25 20:47:35'),
	(2408004, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"26.08.2025","sat":"06:49:00","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":174,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:49:00"}', '2025-08-25 20:49:00', '2025-08-25 20:49:03'),
	(2408005, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003753, 29.224698, _binary 0x000000000101000000037ae1ce85393d404460f6fc7a804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"06:54:16","ind":0,"enl":"41.0037533","boy":"029.224698","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43221.7,"yon":175,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:54:16"}', '2025-08-25 20:54:16', '2025-08-25 20:54:18'),
	(2408006, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"06:54:20","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":95,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:54:20"}', '2025-08-25 20:54:20', '2025-08-25 20:54:21'),
	(2408007, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"06:55:55","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:55:55"}', '2025-08-25 20:55:55', '2025-08-25 20:55:51'),
	(2408008, '31.143.219.198:35638', '86284304533376212', 40.992082, 28.905356, _binary 0x000000000101000000c53c2b69c5e73c40e43a7c88fc7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"06:58:18","ind":0,"enl":"40.9920817","boy":"028.905356","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10953.7,"yon":348,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 06:58:18"}', '2025-08-25 20:58:18', '2025-08-25 20:58:21'),
	(2408009, '31.143.21.53:17428', '44fe033664dac2621', 41.012117, 29.050781, _binary 0x0000000001010000001842cefbff0c3d40231e3f0a8d814440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"07:01:56","ind":0,"enl":"41.0121167","boy":"029.050781","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74647.3,"yon":93,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:01:56"}', '2025-08-25 21:01:56', '2025-08-25 21:01:57'),
	(2408010, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997470, 29.074741, _binary 0x0000000001010000009babe63922133d40dd5ed218ad7f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"26.08.2025","sat":"07:03:50","ind":0,"enl":"40.9974700","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":92,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:03:50"}', '2025-08-25 21:03:50', '2025-08-25 21:03:53'),
	(2408011, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"07:05:55","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:05:55"}', '2025-08-25 21:05:55', '2025-08-25 21:05:51'),
	(2408012, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"07:06:31","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"21","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:06:31"}', '2025-08-25 21:06:31', '2025-08-25 21:06:26'),
	(2408013, '178.243.199.160:37547', '353201357563383', 40.997282, 29.048400, _binary 0x0000000001010000005c2041f1630c3d40877368eca67f4440, '0', '{"device_model": "Teltonika", "p": "1", "did": "353201357563383", "trh": "2025-08-26", "sat": "07:07:28", "ind": 0, "enl": "40.9972816", "boy": "29.0484", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 3.137, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12001, "battery_voltage": 0, "battery_current": 0, "record_timestamp": "2025-08-26 07:07:28", "codec_id": 8}', '2025-08-25 21:07:28', '2025-08-25 21:09:01'),
	(2408014, '31.143.59.246:59440', '86090604649604512', 41.012470, 29.125526, _binary 0x00000000010100000036ccd07822203d402f17f19d98814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"07:09:37","ind":0,"enl":"41.0124700","boy":"029.125526","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":85,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:09:37"}', '2025-08-25 21:09:37', '2025-08-25 21:09:38'),
	(2408015, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"07:09:44","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":351,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:09:44"}', '2025-08-25 21:09:44', '2025-08-25 21:09:46'),
	(2408016, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.011765, 29.050770, _binary 0x000000000101000000309e4143ff0c3d40641ef98381814440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"07:10:41","ind":0,"enl":"41.0117650","boy":"029.050770","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43113.3,"yon":357,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:10:41"}', '2025-08-25 21:10:41', '2025-08-25 21:10:42'),
	(2408017, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"07:16:31","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:16:31"}', '2025-08-25 21:16:31', '2025-08-25 21:16:27'),
	(2408018, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"26.08.2025","sat":"07:17:55","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":63,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:17:55"}', '2025-08-25 21:17:55', '2025-08-25 21:17:58'),
	(2408019, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"26.08.2025","sat":"07:17:59","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":112,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:17:59"}', '2025-08-25 21:17:59', '2025-08-25 21:18:01'),
	(2408020, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003660, 29.079390, _binary 0x00000000010100000023a12de752143d40d5264eee77804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"07:18:35","ind":0,"enl":"41.0036600","boy":"029.079390","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94765.6,"yon":342,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:18:35"}', '2025-08-25 21:18:35', '2025-08-25 21:18:38'),
	(2408021, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"26.08.2025","sat":"07:20:04","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":195,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:20:04"}', '2025-08-25 21:20:04', '2025-08-25 21:20:07'),
	(2408022, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"07:25:09","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":102,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:25:09"}', '2025-08-25 21:25:09', '2025-08-25 21:25:11'),
	(2408023, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003753, 29.224698, _binary 0x000000000101000000037ae1ce85393d404460f6fc7a804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"07:25:20","ind":0,"enl":"41.0037533","boy":"029.224698","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43221.7,"yon":184,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:25:20"}', '2025-08-25 21:25:20', '2025-08-25 21:25:23'),
	(2408024, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"07:26:32","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:26:32"}', '2025-08-25 21:26:32', '2025-08-25 21:26:27'),
	(2408025, '31.143.219.198:35638', '86284304533376212', 40.992082, 28.905356, _binary 0x000000000101000000c53c2b69c5e73c40e43a7c88fc7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"07:29:20","ind":0,"enl":"40.9920817","boy":"028.905356","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10953.7,"yon":35,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:29:20"}', '2025-08-25 21:29:20', '2025-08-25 21:29:22'),
	(2408026, '31.143.21.53:17428', '44fe033664dac2621', 41.012117, 29.050781, _binary 0x0000000001010000001842cefbff0c3d40231e3f0a8d814440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"07:33:04","ind":0,"enl":"41.0121167","boy":"029.050781","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74647.3,"yon":46,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:33:04"}', '2025-08-25 21:33:04', '2025-08-25 21:33:06'),
	(2408027, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997470, 29.074741, _binary 0x0000000001010000009babe63922133d40dd5ed218ad7f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"26.08.2025","sat":"07:34:51","ind":0,"enl":"40.9974700","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":332,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:34:51"}', '2025-08-25 21:34:51', '2025-08-25 21:34:54'),
	(2408028, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"07:36:32","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:36:32"}', '2025-08-25 21:36:32', '2025-08-25 21:36:27'),
	(2408029, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"07:40:34","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":9,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:40:34"}', '2025-08-25 21:40:34', '2025-08-25 21:40:35'),
	(2408030, '31.143.59.246:59440', '86090604649604512', 41.012470, 29.125526, _binary 0x00000000010100000036ccd07822203d402f17f19d98814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"07:40:46","ind":0,"enl":"41.0124700","boy":"029.125526","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":23,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:40:46"}', '2025-08-25 21:40:46', '2025-08-25 21:40:48'),
	(2408031, '31.141.91.166:41864', '350612079185623', 41.014947, 29.054153, _binary 0x00000000010100000071789cfddc0d3d40dc172bc5e9814440, '0', '{"device_model": "Teltonika", "p": "1", "did": "350612079185623", "trh": "2025-08-26", "sat": "07:40:31", "ind": 0, "enl": "41.0149466", "boy": "29.0541533", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 27279.236, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12616, "battery_voltage": 4057, "battery_current": 0, "record_timestamp": "2025-08-26 07:40:31", "codec_id": 8}', '2025-08-25 21:40:31', '2025-08-25 21:42:02'),
	(2408032, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.011598, 29.050773, _binary 0x00000000010100000012859675ff0c3d403898970d7c814440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"07:41:45","ind":0,"enl":"41.0115983","boy":"029.050773","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43113.3,"yon":177,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:41:45"}', '2025-08-25 21:41:45', '2025-08-25 21:41:46'),
	(2408033, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"07:46:32","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:46:32"}', '2025-08-25 21:46:32', '2025-08-25 21:46:27'),
	(2408034, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"26.08.2025","sat":"07:48:58","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":16,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:48:58"}', '2025-08-25 21:48:58', '2025-08-25 21:49:01'),
	(2408035, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"26.08.2025","sat":"07:49:02","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":291,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:49:02"}', '2025-08-25 21:49:02', '2025-08-25 21:49:04'),
	(2408036, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003660, 29.079390, _binary 0x00000000010100000023a12de752143d40d5264eee77804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"07:49:38","ind":0,"enl":"41.0036600","boy":"029.079390","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94765.6,"yon":80,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:49:38"}', '2025-08-25 21:49:38', '2025-08-25 21:49:40'),
	(2408037, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"26.08.2025","sat":"07:51:08","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":29,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:51:08"}', '2025-08-25 21:51:08', '2025-08-25 21:51:10'),
	(2408038, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"07:55:58","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":292,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:55:58"}', '2025-08-25 21:55:58', '2025-08-25 21:56:00'),
	(2408039, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003753, 29.224698, _binary 0x000000000101000000037ae1ce85393d404460f6fc7a804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"07:56:25","ind":0,"enl":"41.0037533","boy":"029.224698","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43221.7,"yon":171,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:56:25"}', '2025-08-25 21:56:25', '2025-08-25 21:56:27'),
	(2408040, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"07:56:33","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 07:56:33"}', '2025-08-25 21:56:33', '2025-08-25 21:56:28'),
	(2408041, '31.143.21.53:17428', '44fe033664dac2621', 41.012117, 29.050781, _binary 0x0000000001010000001842cefbff0c3d40231e3f0a8d814440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"07:57:18","ind":0,"enl":"41.0121167","boy":"029.050781","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74647.3,"yon":142,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 07:57:18"}', '2025-08-25 21:57:18', '2025-08-25 21:57:19'),
	(2408042, '31.143.21.53:17428', '44fe033664dac2621', 41.008587, 29.050971, _binary 0x0000000001010000005f0b7a6f0c0d3d401dd7755e19814440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"07:58:57","ind":0,"enl":"41.0085867","boy":"029.050971","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":19.20524,"mes":74647.8,"yon":128,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 07:58:57"}', '2025-08-25 21:58:57', '2025-08-25 21:58:59'),
	(2408043, '31.143.21.53:17428', '44fe033664dac2621', 41.005447, 29.054880, _binary 0x00000000010100000059349d9d0c0e3d40812f3b7ab2804440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"08:00:13","ind":0,"enl":"41.0054467","boy":"029.054880","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":45.20732,"mes":74648.3,"yon":182,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:00:13"}', '2025-08-25 22:00:13', '2025-08-25 22:00:15'),
	(2408044, '31.143.219.198:35638', '86284304533376212', 40.992082, 28.905356, _binary 0x000000000101000000c53c2b69c5e73c40e43a7c88fc7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"08:00:22","ind":0,"enl":"40.9920817","boy":"028.905356","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10953.7,"yon":99,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:00:22"}', '2025-08-25 22:00:22', '2025-08-25 22:00:25'),
	(2408045, '31.143.21.53:17428', '44fe033664dac2621', 41.000768, 29.053056, _binary 0x00000000010100000049dbf813950d3d40cfaff72c19804440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"08:00:55","ind":0,"enl":"41.0007683","boy":"029.053056","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":43.503479999999996,"mes":74648.8,"yon":208,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:00:55"}', '2025-08-25 22:00:55', '2025-08-25 22:00:57'),
	(2408046, '31.143.21.53:17428', '44fe033664dac2621', 40.998937, 29.055601, _binary 0x000000000101000000f99ffcdd3b0e3d4018a36428dd7f4440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"08:01:41","ind":0,"enl":"40.9989367","boy":"029.055601","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":33.02116,"mes":74649.4,"yon":115,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:01:41"}', '2025-08-25 22:01:41', '2025-08-25 22:01:44'),
	(2408047, '31.143.21.53:17428', '44fe033664dac2621', 40.996913, 29.061428, _binary 0x000000000101000000060fd3beb90f3d404639e2da9a7f4440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"08:02:22","ind":0,"enl":"40.9969133","boy":"029.061428","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":70.33896,"mes":74649.8,"yon":115,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:02:22"}', '2025-08-25 22:02:22', '2025-08-25 22:02:24'),
	(2408048, '31.143.21.53:17428', '44fe033664dac2621', 40.994780, 29.067131, _binary 0x0000000001010000003b8c497f2f113d40815b77f3547f4440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"08:02:50","ind":0,"enl":"40.9947800","boy":"029.067131","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":67.76468000000001,"mes":74650.4,"yon":116,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:02:50"}', '2025-08-25 22:02:50', '2025-08-25 22:02:57'),
	(2408049, '31.143.21.53:17428', '44fe033664dac2621', 40.992637, 29.072805, _binary 0x0000000001010000003bfc3559a3123d4099a729b80e7f4440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"08:03:19","ind":0,"enl":"40.9926367","boy":"029.072805","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":69.09812000000001,"mes":74650.9,"yon":116,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:03:19"}', '2025-08-25 22:03:19', '2025-08-25 22:03:26'),
	(2408050, '31.143.21.53:17428', '44fe033664dac2621', 40.990475, 29.078686, _binary 0x0000000001010000002fa704c424143d40b84082e2c77e4440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"08:03:45","ind":0,"enl":"40.9904750","boy":"029.078686","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":84.41416,"mes":74651.5,"yon":116,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:03:45"}', '2025-08-25 22:03:45', '2025-08-25 22:03:46'),
	(2408051, '31.143.21.53:17428', '44fe033664dac2621', 40.988243, 29.084568, _binary 0x000000000101000000c3499a3fa6153d40ddfea6c17e7e4440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"08:04:10","ind":0,"enl":"40.9882433","boy":"029.084568","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":77.9692,"mes":74652,"yon":118,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:04:10"}', '2025-08-25 22:04:10', '2025-08-25 22:04:14'),
	(2408052, '31.143.21.53:17428', '44fe033664dac2621', 40.985462, 29.089928, _binary 0x000000000101000000a4fe7a8505173d40f47ae69b237e4440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"08:04:34","ind":0,"enl":"40.9854617","boy":"029.089928","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":93.69268000000001,"mes":74652.5,"yon":129,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:04:34"}', '2025-08-25 22:04:34', '2025-08-25 22:04:40'),
	(2408053, '31.143.21.53:17428', '44fe033664dac2621', 40.981795, 29.094465, _binary 0x000000000101000000dc9db5db2e183d402b306475ab7d4440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"08:04:58","ind":0,"enl":"40.9817950","boy":"029.094465","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":86.3032,"mes":74653.1,"yon":143,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:04:58"}', '2025-08-25 22:04:58', '2025-08-25 22:05:07'),
	(2408054, '31.143.21.53:17428', '44fe033664dac2621', 40.977642, 29.097625, _binary 0x000000000101000000a245b6f3fd183d40595afc5c237d4440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"08:05:20","ind":0,"enl":"40.9776417","boy":"029.097625","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":83.91412000000001,"mes":74653.5,"yon":155,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:05:20"}', '2025-08-25 22:05:20', '2025-08-25 22:05:22'),
	(2408055, '31.143.21.53:17428', '44fe033664dac2621', 40.972993, 29.100271, _binary 0x000000000101000000babc395cab193d40125d610b8b7c4440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"08:05:49","ind":0,"enl":"40.9729933","boy":"029.100271","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":74.89488,"mes":74654.1,"yon":156,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:05:49"}', '2025-08-25 22:05:49', '2025-08-25 22:05:51'),
	(2408056, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997470, 29.074741, _binary 0x0000000001010000009babe63922133d40dd5ed218ad7f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"26.08.2025","sat":"08:05:53","ind":0,"enl":"40.9974700","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":65,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:05:53"}', '2025-08-25 22:05:53', '2025-08-25 22:05:56'),
	(2408057, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"08:06:33","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:06:33"}', '2025-08-25 22:06:33', '2025-08-25 22:06:28'),
	(2408058, '31.143.21.53:17428', '44fe033664dac2621', 40.968523, 29.102726, _binary 0x000000000101000000eb724a404c1a3d40fe744d92f87b4440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"08:06:13","ind":0,"enl":"40.9685233","boy":"029.102726","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":79.76564,"mes":74654.7,"yon":156,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:06:13"}', '2025-08-25 22:06:13', '2025-08-25 22:06:36'),
	(2408059, '31.143.21.53:17428', '44fe033664dac2621', 40.964255, 29.105716, _binary 0x000000000101000000f8a92a34101b3d40930035b56c7b4440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"08:06:38","ind":0,"enl":"40.9642550","boy":"029.105716","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":82.50659999999999,"mes":74655.2,"yon":144,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:06:38"}', '2025-08-25 22:06:38', '2025-08-25 22:06:40'),
	(2408060, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"08:07:06","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"21","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:07:06"}', '2025-08-25 22:07:06', '2025-08-25 22:07:01'),
	(2408061, '31.143.21.53:17428', '44fe033664dac2621', 40.960330, 29.109746, _binary 0x000000000101000000e8dd5850181c3d4010afeb17ec7a4440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"08:07:10","ind":0,"enl":"40.9603300","boy":"029.109746","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":46.2074,"mes":74655.7,"yon":139,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:07:10"}', '2025-08-25 22:07:10', '2025-08-25 22:07:11'),
	(2408062, '31.143.21.53:17428', '44fe033664dac2621', 40.956800, 29.113520, _binary 0x00000000010100000022718fa50f1d3d400a68226c787a4440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"08:08:17","ind":0,"enl":"40.9568000","boy":"029.113520","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":19.20524,"mes":74656.2,"yon":140,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:08:17"}', '2025-08-25 22:08:17', '2025-08-25 22:08:19'),
	(2408063, '31.143.14.179:7111', '353201357563383', 40.997282, 29.048400, _binary 0x0000000001010000005c2041f1630c3d40877368eca67f4440, '0', '{"device_model": "Teltonika", "p": "1", "did": "353201357563383", "trh": "2025-08-26", "sat": "08:07:28", "ind": 0, "enl": "40.9972816", "boy": "29.0484", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 3.137, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12001, "battery_voltage": 0, "battery_current": 0, "record_timestamp": "2025-08-26 08:07:28", "codec_id": 8}', '2025-08-25 22:07:28', '2025-08-25 22:10:01'),
	(2408064, '31.143.21.53:17428', '44fe033664dac2621', 40.953232, 29.117465, _binary 0x000000000101000000b56cad2f121e3d405881107f037a4440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"08:09:21","ind":0,"enl":"40.9532317","boy":"029.117465","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":46.05924,"mes":74656.8,"yon":141,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:09:21"}', '2025-08-25 22:09:21', '2025-08-25 22:09:23'),
	(2408065, '31.143.21.53:17428', '44fe033664dac2621', 40.949650, 29.121611, _binary 0x00000000010100000078d503e6211f3d40bd5296218e794440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"08:10:03","ind":0,"enl":"40.9496500","boy":"029.121611","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":39.077200000000005,"mes":74657.2,"yon":137,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:10:03"}', '2025-08-25 22:10:03', '2025-08-25 22:10:05'),
	(2408066, '31.143.21.53:17428', '44fe033664dac2621', 40.946217, 29.125840, _binary 0x0000000001010000005587dc0c37203d40ebb6faa01d794440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"08:10:55","ind":0,"enl":"40.9462167","boy":"029.125840","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":35.502840000000006,"mes":74657.8,"yon":137,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:10:55"}', '2025-08-25 22:10:55', '2025-08-25 22:10:57'),
	(2408067, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"08:11:23","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":257,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:11:23"}', '2025-08-25 22:11:23', '2025-08-25 22:11:25'),
	(2408068, '31.143.59.246:59440', '86090604649604512', 41.012470, 29.125526, _binary 0x00000000010100000036ccd07822203d402f17f19d98814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"08:11:56","ind":0,"enl":"41.0124700","boy":"029.125526","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":177,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:11:56"}', '2025-08-25 22:11:56', '2025-08-25 22:11:57'),
	(2408069, '31.143.21.53:17428', '44fe033664dac2621', 40.942787, 29.129890, _binary 0x000000000101000000d313967840213d4048cd0d3cad784440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"08:12:13","ind":0,"enl":"40.9427867","boy":"029.129890","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":38.78088,"mes":74658.3,"yon":138,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:12:13"}', '2025-08-25 22:12:13', '2025-08-25 22:12:14'),
	(2408070, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.011598, 29.050773, _binary 0x00000000010100000012859675ff0c3d403898970d7c814440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"08:12:48","ind":0,"enl":"41.0115983","boy":"029.050773","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43113.3,"yon":54,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:12:48"}', '2025-08-25 22:12:48', '2025-08-25 22:12:50'),
	(2408071, '31.143.21.53:17428', '44fe033664dac2621', 40.939422, 29.133845, _binary 0x000000000101000000aebb79aa43223d408c5363f83e784440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"08:13:15","ind":0,"enl":"40.9394217","boy":"029.133845","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":5.481920000000001,"mes":74658.8,"yon":134,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:13:15"}', '2025-08-25 22:13:15', '2025-08-25 22:13:17'),
	(2408072, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003753, 29.224698, _binary 0x000000000101000000037ae1ce85393d404460f6fc7a804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:15:10","ind":0,"enl":"41.0037533","boy":"029.224698","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43221.7,"yon":267,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 08:15:10"}', '2025-08-25 22:15:10', '2025-08-25 22:15:12'),
	(2408073, '31.143.21.53:17428', '44fe033664dac2621', 40.937145, 29.133730, _binary 0x0000000001010000007c7e18213c223d40124e0b5ef4774440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"08:15:19","ind":0,"enl":"40.9371450","boy":"029.133730","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":74659.2,"yon":167,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:15:19"}', '2025-08-25 22:15:19', '2025-08-25 22:15:20'),
	(2408074, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"08:17:07","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:17:07"}', '2025-08-25 22:17:07', '2025-08-25 22:17:02'),
	(2408075, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003655, 29.225918, _binary 0x000000000101000000e69315c3d5393d40c3bb5cc477804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:17:14","ind":0,"enl":"41.0036550","boy":"029.225918","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":13.241800000000001,"mes":43221.9,"yon":94,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:17:14"}', '2025-08-25 22:17:14', '2025-08-25 22:17:16'),
	(2408076, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.005362, 29.222675, _binary 0x00000000010100000005a3923a01393d40531333b1af804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:18:32","ind":0,"enl":"41.0053617","boy":"029.222675","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":23.90932,"mes":43222.3,"yon":18,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:18:32"}', '2025-08-25 22:18:32', '2025-08-25 22:18:35'),
	(2408077, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.006002, 29.219315, _binary 0x000000000101000000b285200725383d40369ce8a9c4804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:19:35","ind":0,"enl":"41.0060017","boy":"029.219315","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":25.20572,"mes":43222.8,"yon":331,"A":"5","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:19:35"}', '2025-08-25 22:19:35', '2025-08-25 22:19:37'),
	(2408078, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"26.08.2025","sat":"08:20:01","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":349,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:20:01"}', '2025-08-25 22:20:01', '2025-08-25 22:20:03'),
	(2408079, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"26.08.2025","sat":"08:20:05","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":157,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:20:05"}', '2025-08-25 22:20:05', '2025-08-25 22:20:07'),
	(2408080, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003660, 29.079390, _binary 0x00000000010100000023a12de752143d40d5264eee77804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"08:20:41","ind":0,"enl":"41.0036600","boy":"029.079390","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94765.6,"yon":65,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:20:41"}', '2025-08-25 22:20:41', '2025-08-25 22:20:44'),
	(2408081, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.006258, 29.215821, _binary 0x0000000001010000003eca880b40373d400eea6c12cd804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:21:38","ind":0,"enl":"41.0062583","boy":"029.215821","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":4.87076,"mes":43223.1,"yon":270,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:21:38"}', '2025-08-25 22:21:38', '2025-08-25 22:21:40'),
	(2408082, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"26.08.2025","sat":"08:22:12","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":130,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:22:12"}', '2025-08-25 22:22:12', '2025-08-25 22:22:14'),
	(2408083, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.006647, 29.211550, _binary 0x00000000010100000003780b2428363d402b908fccd9804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:23:42","ind":0,"enl":"41.0066467","boy":"029.211550","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":20.68684,"mes":43223.6,"yon":301,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:23:42"}', '2025-08-25 22:23:42', '2025-08-25 22:23:45'),
	(2408084, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.006502, 29.205833, _binary 0x0000000001010000000470b378b1343d40286f360cd5804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:25:11","ind":0,"enl":"41.0065017","boy":"029.205833","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":22.14992,"mes":43224.1,"yon":265,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:25:11"}', '2025-08-25 22:25:11', '2025-08-25 22:25:14'),
	(2408085, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003677, 29.202060, _binary 0x0000000001010000006bd44334ba333d40ec20657a78804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:26:15","ind":0,"enl":"41.0036767","boy":"029.202060","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":37.7808,"mes":43224.5,"yon":191,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:26:15"}', '2025-08-25 22:26:15', '2025-08-25 22:26:18'),
	(2408086, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"08:26:48","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":108,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:26:48"}', '2025-08-25 22:26:48', '2025-08-25 22:26:50'),
	(2408087, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"08:27:08","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:27:08"}', '2025-08-25 22:27:08', '2025-08-25 22:27:02'),
	(2408088, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.999437, 29.200241, _binary 0x0000000001010000007e5182fe42333d400976b28aed7f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:27:27","ind":0,"enl":"40.9994367","boy":"029.200241","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":7.2228,"mes":43225.1,"yon":216,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:27:27"}', '2025-08-25 22:27:27', '2025-08-25 22:27:29'),
	(2408089, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.997232, 29.196925, _binary 0x000000000101000000cac342ad69323d406a04d149a57f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:29:31","ind":0,"enl":"40.9972317","boy":"029.196925","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":20.13124,"mes":43225.4,"yon":254,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:29:31"}', '2025-08-25 22:29:31', '2025-08-25 22:29:34'),
	(2408090, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.994648, 29.194195, _binary 0x000000000101000000f60b76c3b6313d40d1c2afa2507f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:30:45","ind":0,"enl":"40.9946483","boy":"029.194195","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":14.964160000000001,"mes":43225.9,"yon":204,"A":"5","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:30:45"}', '2025-08-25 22:30:45', '2025-08-25 22:30:46'),
	(2408091, '31.143.219.198:35638', '86284304533376212', 40.992082, 28.905356, _binary 0x000000000101000000c53c2b69c5e73c40e43a7c88fc7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"08:31:23","ind":0,"enl":"40.9920817","boy":"028.905356","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10953.7,"yon":245,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:31:23"}', '2025-08-25 22:31:23', '2025-08-25 22:31:26'),
	(2408092, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.994590, 29.191781, _binary 0x00000000010100000082fe428f18313d40de76a1b94e7f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:31:41","ind":0,"enl":"40.9945900","boy":"029.191781","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":17.07544,"mes":43226.1,"yon":305,"A":"5","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:31:41"}', '2025-08-25 22:31:41', '2025-08-25 22:31:42'),
	(2408093, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.996638, 29.186621, _binary 0x0000000001010000002fbfd364c62f3d40743804d8917f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:33:41","ind":0,"enl":"40.9966383","boy":"029.186621","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":37.595600000000005,"mes":43226.6,"yon":298,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:33:41"}', '2025-08-25 22:33:41', '2025-08-25 22:33:53'),
	(2408094, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.998978, 29.181610, _binary 0x00000000010100000066a032fe7d2e3d40f3f45b85de7f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:34:30","ind":0,"enl":"40.9989783","boy":"029.181610","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":29.66904,"mes":43227.2,"yon":281,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:34:30"}', '2025-08-25 22:34:30', '2025-08-25 22:34:34'),
	(2408095, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.999838, 29.179403, _binary 0x000000000101000000e6cde15aed2d3d40e5e48fb3fa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:35:00","ind":0,"enl":"40.9998383","boy":"029.179403","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":10.63048,"mes":43227.4,"yon":340,"A":"5","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:35:00"}', '2025-08-25 22:35:00', '2025-08-25 22:35:02'),
	(2408096, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.011598, 29.050773, _binary 0x00000000010100000012859675ff0c3d403898970d7c814440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"08:35:48","ind":0,"enl":"41.0115983","boy":"029.050773","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43113.3,"yon":139,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 08:35:48"}', '2025-08-25 22:35:48', '2025-08-25 22:35:50'),
	(2408097, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.001852, 29.174346, _binary 0x0000000001010000003c3080f0a12c3d4094782fad3c804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:36:01","ind":0,"enl":"41.0018517","boy":"029.174346","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":20.872040000000002,"mes":43227.9,"yon":294,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:36:01"}', '2025-08-25 22:36:01', '2025-08-25 22:36:03'),
	(2408098, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003827, 29.169820, _binary 0x000000000101000000ec34d252792b3d4001adaf647d804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:36:48","ind":0,"enl":"41.0038267","boy":"029.169820","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":10.38972,"mes":43228.3,"yon":265,"A":"5","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:36:48"}', '2025-08-25 22:36:48', '2025-08-25 22:36:50'),
	(2408099, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997470, 29.074741, _binary 0x0000000001010000009babe63922133d40dd5ed218ad7f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"26.08.2025","sat":"08:36:55","ind":0,"enl":"40.9974700","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":64,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:36:55"}', '2025-08-25 22:36:55', '2025-08-25 22:36:57'),
	(2408100, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"08:37:08","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:37:08"}', '2025-08-25 22:37:08', '2025-08-25 22:37:02'),
	(2408101, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.010915, 29.052116, _binary 0x0000000001010000002d996379570d3d409604a8a965814440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"08:37:19","ind":0,"enl":"41.0109150","boy":"029.052116","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":10.29712,"mes":43113.4,"yon":79,"A":"5","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:37:19"}', '2025-08-25 22:37:19', '2025-08-25 22:37:21'),
	(2408102, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.001078, 29.165456, _binary 0x0000000001010000004eed0c535b2a3d401e9e6f5523804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:37:40","ind":0,"enl":"41.0010783","boy":"029.165456","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":26.168760000000002,"mes":43228.8,"yon":270,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:37:40"}', '2025-08-25 22:37:40', '2025-08-25 22:37:43'),
	(2408103, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.012218, 29.056813, _binary 0x000000000101000000d6fcf84b8b0e3d40d474875e90814440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"08:38:41","ind":0,"enl":"41.0122183","boy":"029.056813","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":28.983800000000002,"mes":43114,"yon":35,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:38:41"}', '2025-08-25 22:38:41', '2025-08-25 22:38:43'),
	(2408104, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.001115, 29.160965, _binary 0x000000000101000000f7cc920035293d407c444c8924804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:39:13","ind":0,"enl":"41.0011150","boy":"029.160965","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":22.57588,"mes":43229.4,"yon":227,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:39:13"}', '2025-08-25 22:39:13', '2025-08-25 22:39:18'),
	(2408105, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.012405, 29.059240, _binary 0x000000000101000000739d465a2a0f3d4048a7ae7c96814440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"08:39:19","ind":0,"enl":"41.0124050","boy":"029.059240","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":4.00032,"mes":43114.2,"yon":126,"A":"6","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:39:19"}', '2025-08-25 22:39:19', '2025-08-25 22:39:21'),
	(2408106, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.007998, 29.061651, _binary 0x00000000010100000005c4245cc80f3d4038769a1606814440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"08:39:59","ind":0,"enl":"41.0079983","boy":"029.061651","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":66.98684,"mes":43114.8,"yon":139,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:39:59"}', '2025-08-25 22:39:59', '2025-08-25 22:40:00'),
	(2408107, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.007630, 29.062140, _binary 0x00000000010100000000c63368e80f3d40f73b1405fa804440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"08:40:02","ind":0,"enl":"41.0076300","boy":"029.062140","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":70.0982,"mes":43114.8,"yon":133,"A":"3","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:40:02"}', '2025-08-25 22:40:02', '2025-08-25 22:40:05'),
	(2408108, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.005507, 29.067838, _binary 0x000000000101000000116dc7d45d113d4056348c71b4804440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"08:40:32","ind":0,"enl":"41.0055067","boy":"029.067838","drm":[1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":59.0788,"mes":43115.4,"yon":99,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:40:32"}', '2025-08-25 22:40:32', '2025-08-25 22:40:34'),
	(2408109, '5.27.203.178:20690', '350612079185623', 41.014947, 29.054153, _binary 0x00000000010100000071789cfddc0d3d40dc172bc5e9814440, '0', '{"device_model": "Teltonika", "p": "1", "did": "350612079185623", "trh": "2025-08-26", "sat": "08:40:37", "ind": 0, "enl": "41.0149466", "boy": "29.0541533", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 27279.236, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12616, "battery_voltage": 4057, "battery_current": 0, "record_timestamp": "2025-08-26 08:40:37", "codec_id": 8}', '2025-08-25 22:40:37', '2025-08-25 22:42:01'),
	(2408110, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.005530, 29.074193, _binary 0x0000000001010000009697fc4ffe123d40cd920035b5804440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"08:41:05","ind":0,"enl":"41.0055300","boy":"029.074193","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":51.763400000000004,"mes":43115.8,"yon":80,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:41:05"}', '2025-08-25 22:41:05', '2025-08-25 22:41:06'),
	(2408111, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.997623, 29.157660, _binary 0x0000000001010000002ae3df675c283d40229dcb1eb27f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:41:18","ind":0,"enl":"40.9976233","boy":"029.157660","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43229.8,"yon":221,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 08:41:18"}', '2025-08-25 22:41:18', '2025-08-25 22:41:21'),
	(2408112, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"08:42:12","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":297,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:42:12"}', '2025-08-25 22:42:12', '2025-08-25 22:42:14'),
	(2408113, '5.27.202.142:9550', 'a1a58402fabc488f0', 41.002548, 29.077676, _binary 0x00000000010100000021af0793e2133d408894b08053804440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"08:42:14","ind":0,"enl":"41.0025483","boy":"029.077676","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":20.483120000000003,"mes":43116.4,"yon":147,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:42:14"}', '2025-08-25 22:42:14', '2025-08-25 22:42:17'),
	(2408114, '31.143.59.246:59440', '86090604649604512', 41.012470, 29.125526, _binary 0x00000000010100000036ccd07822203d402f17f19d98814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"08:43:04","ind":0,"enl":"41.0124700","boy":"029.125526","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":183,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:43:04"}', '2025-08-25 22:43:04', '2025-08-25 22:43:05'),
	(2408115, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.998010, 29.156473, _binary 0x000000000101000000feb4519d0e283d405d8aabcabe7f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:43:22","ind":0,"enl":"40.9980100","boy":"029.156473","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43230,"yon":302,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 08:43:22"}', '2025-08-25 22:43:22', '2025-08-25 22:43:24'),
	(2408116, '5.27.202.142:9550', 'a1a58402fabc488f0', 40.998397, 29.077888, _binary 0x00000000010100000038c0cc77f0133d4098778b76cb7f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"08:43:31","ind":0,"enl":"40.9983967","boy":"029.077888","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":16.81616,"mes":43116.9,"yon":157,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:43:31"}', '2025-08-25 22:43:31', '2025-08-25 22:43:33'),
	(2408117, '5.27.202.142:9550', 'a1a58402fabc488f0', 40.995732, 29.075935, _binary 0x0000000001010000002c9fe57970133d40958be722747f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"08:45:00","ind":0,"enl":"40.9957317","boy":"029.075935","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":20.68684,"mes":43117.3,"yon":272,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:45:00"}', '2025-08-25 22:45:00', '2025-08-25 22:45:02'),
	(2408118, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.998082, 29.154816, _binary 0x000000000101000000c5e57805a2273d40381e2224c17f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:45:26","ind":0,"enl":"40.9980817","boy":"029.154816","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":6.68572,"mes":43230.2,"yon":205,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:45:26"}', '2025-08-25 22:45:26', '2025-08-25 22:45:29'),
	(2408119, '31.143.219.198:35638', '86284304533376212', 40.992082, 28.905356, _binary 0x000000000101000000c53c2b69c5e73c40e43a7c88fc7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"08:46:09","ind":0,"enl":"40.9920817","boy":"028.905356","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10953.7,"yon":113,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 08:46:09"}', '2025-08-25 22:46:09', '2025-08-25 22:46:12'),
	(2408120, '31.143.219.198:35638', '86284304533376212', 40.992030, 28.905418, _binary 0x000000000101000000b1355b79c9e73c405053cbd6fa7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"08:46:21","ind":0,"enl":"40.9920300","boy":"028.905418","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10953.8,"yon":113,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:46:21"}', '2025-08-25 22:46:21', '2025-08-25 22:46:23'),
	(2408121, '31.143.219.198:35638', '86284304533376212', 40.992047, 28.905390, _binary 0x0000000001010000001d2098a3c7e73c40684de262fb7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"08:46:23","ind":0,"enl":"40.9920467","boy":"028.905390","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10953.8,"yon":113,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 08:46:23"}', '2025-08-25 22:46:23', '2025-08-25 22:46:24'),
	(2408122, '5.27.202.142:9550', 'a1a58402fabc488f0', 40.996362, 29.074198, _binary 0x000000000101000000b96ddfa3fe123d40553ebac7887f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"08:46:23","ind":0,"enl":"40.9963617","boy":"029.074198","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43117.6,"yon":320,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:46:23"}', '2025-08-25 22:46:23', '2025-08-25 22:46:25'),
	(2408123, '31.143.21.53:17428', '44fe033664dac2621', 40.937120, 29.133683, _binary 0x000000000101000000fb07910c39223d40b936548cf3774440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"08:46:26","ind":0,"enl":"40.9371200","boy":"029.133683","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":74659.2,"yon":125,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:46:26"}', '2025-08-25 22:46:26', '2025-08-25 22:46:27'),
	(2408124, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"08:47:08","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:47:08"}', '2025-08-25 22:47:08', '2025-08-25 22:47:03'),
	(2408125, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.997538, 29.154875, _binary 0x000000000101000000cff753e3a5273d40f480c355af7f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:47:30","ind":0,"enl":"40.9975383","boy":"029.154875","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43230.2,"yon":162,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 08:47:30"}', '2025-08-25 22:47:30', '2025-08-25 22:47:33'),
	(2408126, '31.143.219.198:35638', '86284304533376212', 40.993565, 28.905470, _binary 0x0000000001010000005682c5e1cce73c40a1b94e232d7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"08:48:26","ind":0,"enl":"40.9935650","boy":"028.905470","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":14.46412,"mes":10953.9,"yon":12,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:48:26"}', '2025-08-25 22:48:26', '2025-08-25 22:48:29'),
	(2408127, '5.27.202.142:9550', 'a1a58402fabc488f0', 40.996377, 29.074191, _binary 0x00000000010100000054a86e2efe123d408a7f8e45897f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"08:48:34","ind":0,"enl":"40.9963767","boy":"029.074191","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43117.6,"yon":80,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 08:48:34"}', '2025-08-25 22:48:34', '2025-08-25 22:48:35'),
	(2408128, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.996995, 29.155000, _binary 0x00000000010100000048e17a14ae273d4044a33b889d7f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:49:34","ind":0,"enl":"40.9969950","boy":"029.155000","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":2.5002000000000004,"mes":43230.3,"yon":174,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:49:34"}', '2025-08-25 22:49:34', '2025-08-25 22:49:37'),
	(2408129, '31.143.219.198:35638', '86284304533376212', 40.997468, 28.904483, _binary 0x000000000101000000b8c9a8328ce73c40fba58f0aad7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"08:50:13","ind":0,"enl":"40.9974683","boy":"028.904483","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":19.33488,"mes":10954.3,"yon":6,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:50:13"}', '2025-08-25 22:50:13', '2025-08-25 22:50:17'),
	(2408130, '5.27.202.142:9550', 'a1a58402fabc488f0', 40.997238, 29.074733, _binary 0x00000000010100000095eeaeb321133d40c9682e81a57f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"08:50:27","ind":0,"enl":"40.9972383","boy":"029.074733","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43117.8,"yon":0,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:50:27"}', '2025-08-25 22:50:27', '2025-08-25 22:50:28'),
	(2408131, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"26.08.2025","sat":"08:51:02","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":274,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:51:02"}', '2025-08-25 22:51:02', '2025-08-25 22:51:05'),
	(2408132, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"26.08.2025","sat":"08:51:07","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":81,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:51:07"}', '2025-08-25 22:51:07', '2025-08-25 22:51:10'),
	(2408133, '31.143.219.198:35638', '86284304533376212', 40.996828, 28.903431, _binary 0x0000000001010000004d31074147e73c40171dda11987f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"08:51:26","ind":0,"enl":"40.9968283","boy":"028.903431","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10954.6,"yon":236,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:51:26"}', '2025-08-25 22:51:26', '2025-08-25 22:51:27'),
	(2408134, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.994900, 29.151225, _binary 0x0000000001010000006d567daeb6263d402c6519e2587f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:51:38","ind":0,"enl":"40.9949000","boy":"029.151225","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":7.0746400000000005,"mes":43230.8,"yon":272,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:51:38"}', '2025-08-25 22:51:38', '2025-08-25 22:51:41'),
	(2408135, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003660, 29.079390, _binary 0x00000000010100000023a12de752143d40d5264eee77804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"08:51:44","ind":0,"enl":"41.0036600","boy":"029.079390","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94765.6,"yon":151,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:51:44"}', '2025-08-25 22:51:44', '2025-08-25 22:51:47'),
	(2408136, '31.143.59.246:59440', '86090604649604512', 41.012470, 29.125526, _binary 0x00000000010100000036ccd07822203d402f17f19d98814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"08:52:23","ind":0,"enl":"41.0124700","boy":"029.125526","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":325,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 08:52:23"}', '2025-08-25 22:52:23', '2025-08-25 22:52:25'),
	(2408137, '31.143.59.246:59440', '86090604649604512', 41.012700, 29.125550, _binary 0x0000000001010000004703780b24203d4061545227a0814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"08:52:35","ind":0,"enl":"41.0127000","boy":"029.125550","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":63,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:52:35"}', '2025-08-25 22:52:35', '2025-08-25 22:52:37'),
	(2408138, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"26.08.2025","sat":"08:53:16","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":152,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:53:16"}', '2025-08-25 22:53:16', '2025-08-25 22:53:19'),
	(2408139, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.995618, 29.145491, _binary 0x000000000101000000c2dceee53e253d4049e6a26b707f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:53:24","ind":0,"enl":"40.9956183","boy":"029.145491","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":18.22368,"mes":43231.4,"yon":284,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:53:24"}', '2025-08-25 22:53:24', '2025-08-25 22:53:28'),
	(2408140, '31.143.59.246:59440', '86090604649604512', 41.012683, 29.125553, _binary 0x00000000010100000029eacc3d24203d40495a3b9b9f814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"08:53:48","ind":0,"enl":"41.0126833","boy":"029.125553","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":182,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 08:53:48"}', '2025-08-25 22:53:48', '2025-08-25 22:53:50'),
	(2408141, '31.143.59.246:59440', '86090604649604512', 41.012692, 29.125533, _binary 0x0000000001010000009b9141ee22203d401f37b2e19f814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"08:53:51","ind":0,"enl":"41.0126917","boy":"029.125533","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":151,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:53:51"}', '2025-08-25 22:53:51', '2025-08-25 22:53:53'),
	(2408142, '31.143.59.246:59440', '86090604649604512', 41.012690, 29.125535, _binary 0x000000000101000000dc80cf0f23203d403d7e6fd39f814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"08:53:52","ind":0,"enl":"41.0126900","boy":"029.125535","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":120,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 08:53:52"}', '2025-08-25 22:53:52', '2025-08-25 22:53:54'),
	(2408143, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.996740, 29.139591, _binary 0x000000000101000000e1d05b3cbc233d40ba4e232d957f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:54:08","ind":0,"enl":"40.9967400","boy":"029.139591","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":62.393879999999996,"mes":43231.8,"yon":282,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:54:08"}', '2025-08-25 22:54:08', '2025-08-25 22:54:10'),
	(2408144, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.997148, 29.133445, _binary 0x00000000010100000091d0967329223d4089e1348ea27f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:54:38","ind":0,"enl":"40.9971483","boy":"029.133445","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":59.33808,"mes":43232.3,"yon":266,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:54:38"}', '2025-08-25 22:54:38', '2025-08-25 22:54:40'),
	(2408145, '31.143.21.53:17428', '44fe033664dac2621', 40.937120, 29.133683, _binary 0x000000000101000000fb07910c39223d40b936548cf3774440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"08:54:49","ind":0,"enl":"40.9371200","boy":"029.133683","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74659.2,"yon":299,"A":"4","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:54:49"}', '2025-08-25 22:54:49', '2025-08-25 22:54:51'),
	(2408146, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.996513, 29.127546, _binary 0x00000000010100000051bccadaa6203d40b7c370bf8d7f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:55:30","ind":0,"enl":"40.9965133","boy":"029.127546","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":37.24372,"mes":43232.9,"yon":259,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:55:30"}', '2025-08-25 22:55:30', '2025-08-25 22:55:33'),
	(2408147, '31.143.59.246:59440', '86090604649604512', 41.012690, 29.125535, _binary 0x000000000101000000dc80cf0f23203d403d7e6fd39f814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"08:55:57","ind":0,"enl":"41.0126900","boy":"029.125535","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":29333.5,"yon":172,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 08:55:57"}', '2025-08-25 22:55:57', '2025-08-25 22:55:58'),
	(2408148, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.995838, 29.121420, _binary 0x00000000010100000090149161151f3d40584d21a1777f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:56:05","ind":0,"enl":"40.9958383","boy":"029.121420","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":58.94916,"mes":43233.3,"yon":265,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:56:05"}', '2025-08-25 22:56:05', '2025-08-25 22:56:07'),
	(2408149, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.995892, 29.117285, _binary 0x000000000101000000b54fc763061e3d40ceed1461797f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:56:28","ind":0,"enl":"40.9958917","boy":"029.117285","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":59.13436,"mes":43233.7,"yon":276,"A":"5","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:56:28"}', '2025-08-25 22:56:28', '2025-08-25 22:56:29'),
	(2408150, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.997292, 29.111610, _binary 0x00000000010100000014e81379921c3d403f092241a77f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:56:54","ind":0,"enl":"40.9972917","boy":"029.111610","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":86.6736,"mes":43234.2,"yon":298,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:56:54"}', '2025-08-25 22:56:54', '2025-08-25 22:57:02'),
	(2408151, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"08:57:08","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:57:08"}', '2025-08-25 22:57:08', '2025-08-25 22:57:03'),
	(2408152, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.999967, 29.107030, _binary 0x000000000101000000deb06d51661b3d4066cba8e8fe7f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:57:17","ind":4,"enl":"40.9999667","boy":"029.107030","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":89.87756,"mes":43234.7,"yon":314,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:57:17"}', '2025-08-25 22:57:17', '2025-08-25 22:57:19'),
	(2408153, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"08:57:37","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":256,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 08:57:37"}', '2025-08-25 22:57:37', '2025-08-25 22:57:38'),
	(2408154, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003863, 29.102166, _binary 0x0000000001010000005dc30c8d271a3d40cb93b5977e804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:57:38","ind":0,"enl":"41.0038633","boy":"029.102166","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":86.34024,"mes":43235.3,"yon":316,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:57:38"}', '2025-08-25 22:57:38', '2025-08-25 22:57:40'),
	(2408155, '31.143.59.246:59440', '86090604649604512', 41.012690, 29.125535, _binary 0x000000000101000000dc80cf0f23203d403d7e6fd39f814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"08:58:01","ind":0,"enl":"41.0126900","boy":"029.125535","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":2.79652,"mes":29333.5,"yon":229,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:58:01"}', '2025-08-25 22:58:01', '2025-08-25 22:58:02'),
	(2408156, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.007070, 29.097718, _binary 0x000000000101000000043bfe0b04193d40306475abe7804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:58:02","ind":0,"enl":"41.0070700","boy":"029.097718","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":60.06036,"mes":43235.8,"yon":310,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:58:02"}', '2025-08-25 22:58:02', '2025-08-25 22:58:05'),
	(2408157, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.009363, 29.092778, _binary 0x000000000101000000cdc98b4cc0173d402da40dd132814440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:58:41","ind":0,"enl":"41.0093633","boy":"029.092778","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":42.262640000000005,"mes":43236.2,"yon":300,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:58:41"}', '2025-08-25 22:58:41', '2025-08-25 22:58:46'),
	(2408158, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.009822, 29.086828, _binary 0x00000000010100000089601c5c3a163d40442564d641814440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"08:59:43","ind":0,"enl":"41.0098217","boy":"029.086828","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":11.704640000000001,"mes":43236.8,"yon":270,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 08:59:43"}', '2025-08-25 22:59:43', '2025-08-25 22:59:46'),
	(2408159, '31.143.59.246:59440', '86090604649604512', 41.015907, 29.126590, _binary 0x0000000001010000002a00c63368203d40c624123b09824440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"09:00:01","ind":0,"enl":"41.0159067","boy":"029.126590","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":19.260800000000003,"mes":29334.1,"yon":71,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:00:01"}', '2025-08-25 23:00:01', '2025-08-25 23:00:03'),
	(2408160, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.009412, 29.084188, _binary 0x00000000010100000035b742588d153d4092d90f6734814440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"09:01:04","ind":0,"enl":"41.0094117","boy":"029.084188","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":32.26184000000001,"mes":43237.3,"yon":173,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:01:04"}', '2025-08-25 23:01:04', '2025-08-25 23:01:08'),
	(2408161, '31.143.59.246:59440', '86090604649604512', 41.018018, 29.130105, _binary 0x000000000101000000cc0bb08f4e213d40619d746c4e824440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"09:01:30","ind":0,"enl":"41.0180183","boy":"029.130105","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":28.59488,"mes":29334.5,"yon":319,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:01:30"}', '2025-08-25 23:01:30', '2025-08-25 23:01:31'),
	(2408162, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.005472, 29.083466, _binary 0x000000000101000000f4531c075e153d40da46f24bb3804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"09:02:16","ind":0,"enl":"41.0054717","boy":"029.083466","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":35.447280000000006,"mes":43237.7,"yon":223,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:02:16"}', '2025-08-25 23:02:16', '2025-08-25 23:02:19'),
	(2408163, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003487, 29.081430, _binary 0x000000000101000000cde9b298d8143d40493c8f4072804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"09:03:10","ind":0,"enl":"41.0034867","boy":"029.081430","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43238.1,"yon":235,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:03:10"}', '2025-08-25 23:03:10', '2025-08-25 23:03:12'),
	(2408164, '31.143.59.246:59440', '86090604649604512', 41.018102, 29.131081, _binary 0x000000000101000000812040868e213d4042c0102851824440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"09:03:12","ind":0,"enl":"41.0181017","boy":"029.131081","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":29.0764,"mes":29335.1,"yon":217,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:03:12"}', '2025-08-25 23:03:12', '2025-08-25 23:03:15'),
	(2408165, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003485, 29.081430, _binary 0x000000000101000000cde9b298d8143d4066834c3272804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"09:04:55","ind":0,"enl":"41.0034850","boy":"029.081430","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43238.1,"yon":235,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 09:04:55"}', '2025-08-25 23:04:55', '2025-08-25 23:04:57'),
	(2408166, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003660, 29.079390, _binary 0x00000000010100000023a12de752143d40d5264eee77804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:05:13","ind":0,"enl":"41.0036600","boy":"029.079390","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94765.6,"yon":266,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 09:05:13"}', '2025-08-25 23:05:13', '2025-08-25 23:05:15'),
	(2408167, '31.143.59.246:59440', '86090604649604512', 41.014603, 29.131296, _binary 0x0000000001010000007a185a9d9c213d40f3f45b85de814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"09:05:17","ind":0,"enl":"41.0146033","boy":"029.131296","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":28.92824,"mes":29335.6,"yon":149,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:05:17"}', '2025-08-25 23:05:17', '2025-08-25 23:05:18'),
	(2408168, '31.143.59.246:59440', '86090604649604512', 41.013953, 29.132241, _binary 0x000000000101000000ba30d28bda213d40ec95c338c9814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"09:05:45","ind":0,"enl":"41.0139533","boy":"029.132241","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":29335.7,"yon":97,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:05:45"}', '2025-08-25 23:05:45', '2025-08-25 23:05:47'),
	(2408169, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.001218, 29.077803, _binary 0x000000000101000000db87bce5ea133d400f54d7eb27804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"09:06:58","ind":0,"enl":"41.0012183","boy":"029.077803","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":29.20604,"mes":43238.4,"yon":236,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:06:58"}', '2025-08-25 23:06:58', '2025-08-25 23:07:01'),
	(2408170, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"09:07:09","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:07:09"}', '2025-08-25 23:07:09', '2025-08-25 23:07:03'),
	(2408171, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.000550, 29.077400, _binary 0x000000000101000000ddb5847cd0133d40a301bc0512804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:07:16","ind":0,"enl":"41.0005500","boy":"029.077400","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":25.87244,"mes":94766,"yon":173,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:07:16"}', '2025-08-25 23:07:16', '2025-08-25 23:07:19'),
	(2408172, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"09:07:43","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"21","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:07:43"}', '2025-08-25 23:07:43', '2025-08-25 23:07:37'),
	(2408173, '31.143.59.246:59440', '86090604649604512', 41.013953, 29.132285, _binary 0x00000000010100000059c0046edd213d40ec95c338c9814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"09:07:52","ind":0,"enl":"41.0139533","boy":"029.132285","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":29335.7,"yon":213,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 09:07:52"}', '2025-08-25 23:07:52', '2025-08-25 23:07:54'),
	(2408174, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997470, 29.074741, _binary 0x0000000001010000009babe63922133d40dd5ed218ad7f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"26.08.2025","sat":"09:07:55","ind":0,"enl":"40.9974700","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":243,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:07:55"}', '2025-08-25 23:07:55', '2025-08-25 23:07:58'),
	(2408175, '176.89.129.251:17622', '353201357563383', 40.997282, 29.048400, _binary 0x0000000001010000005c2041f1630c3d40877368eca67f4440, '0', '{"device_model": "Teltonika", "p": "1", "did": "353201357563383", "trh": "2025-08-26", "sat": "09:07:28", "ind": 0, "enl": "40.9972816", "boy": "29.0484", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 3.137, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12001, "battery_voltage": 0, "battery_current": 0, "record_timestamp": "2025-08-26 09:07:28", "codec_id": 8}', '2025-08-25 23:07:28', '2025-08-25 23:09:01'),
	(2408176, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.997500, 29.074551, _binary 0x00000000010100000054e23ac615133d4048e17a14ae7f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"09:08:14","ind":0,"enl":"40.9975000","boy":"029.074551","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":14.29744,"mes":43239,"yon":193,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:08:14"}', '2025-08-25 23:08:14', '2025-08-25 23:08:16'),
	(2408177, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.997422, 29.074558, _binary 0x000000000101000000b9a7ab3b16133d400de9a683ab7f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:08:51","ind":0,"enl":"40.9974217","boy":"029.074558","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94766.5,"yon":77,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:08:51"}', '2025-08-25 23:08:51', '2025-08-25 23:08:53'),
	(2408178, '31.143.59.246:59440', '86090604649604512', 41.011098, 29.132671, _binary 0x000000000101000000ab2006baf6213d4046c549ab6b814440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"09:09:07","ind":0,"enl":"41.0110983","boy":"029.132671","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":30.261680000000002,"mes":29336.1,"yon":220,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:09:07"}', '2025-08-25 23:09:07', '2025-08-25 23:09:08'),
	(2408179, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.997280, 29.074576, _binary 0x0000000001010000000611a96917133d403a7afcdea67f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"09:09:15","ind":0,"enl":"40.9972800","boy":"029.074576","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43239,"yon":343,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:09:15"}', '2025-08-25 23:09:15', '2025-08-25 23:09:16'),
	(2408180, '31.143.59.246:59440', '86090604649604512', 41.007598, 29.128898, _binary 0x00000000010100000012859675ff203d40aa0029fbf8804440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"09:10:05","ind":0,"enl":"41.0075983","boy":"029.128898","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":30.872840000000004,"mes":29336.7,"yon":204,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:10:05"}', '2025-08-25 23:10:05', '2025-08-25 23:10:07'),
	(2408181, '31.143.59.246:59440', '86090604649604512', 41.003198, 29.127658, _binary 0x000000000101000000a112d731ae203d408ff348cd68804440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"09:11:11","ind":0,"enl":"41.0031983","boy":"029.127658","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":28.0578,"mes":29337.2,"yon":177,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:11:11"}', '2025-08-25 23:11:11', '2025-08-25 23:11:17'),
	(2408182, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"09:13:01","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":259,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:13:01"}', '2025-08-25 23:13:01', '2025-08-25 23:13:02'),
	(2408183, '31.143.59.246:59440', '86090604649604512', 40.999177, 29.126035, _binary 0x000000000101000000c0266bd443203d406db6a805e57f4440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"09:13:16","ind":0,"enl":"40.9991767","boy":"029.126035","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":9.797080000000001,"mes":29337.8,"yon":147,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:13:16"}', '2025-08-25 23:13:16', '2025-08-25 23:13:17'),
	(2408184, '31.143.59.246:59440', '86090604649604512', 40.998078, 29.130996, _binary 0x00000000010100000025e82ff488213d4074ac9c07c17f4440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"09:14:09","ind":0,"enl":"40.9980783","boy":"029.130996","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":34.41016,"mes":29338.2,"yon":175,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:14:09"}', '2025-08-25 23:14:09', '2025-08-25 23:14:10'),
	(2408185, '31.143.59.246:59440', '86090604649604512', 40.994833, 29.128058, _binary 0x000000000101000000bdfdb968c8203d40633c94b2567f4440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"09:15:09","ind":0,"enl":"40.9948333","boy":"029.128058","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":22.85368,"mes":29338.7,"yon":199,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:15:09"}', '2025-08-25 23:15:09', '2025-08-25 23:15:10'),
	(2408186, '31.143.59.246:59440', '86090604649604512', 40.993090, 29.123953, _binary 0x000000000101000000b83d4162bb1f3d4009feb7921d7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86090604649604512","trh":"26.08.2025","sat":"09:16:58","ind":0,"enl":"40.9930900","boy":"029.123953","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":37.595600000000005,"mes":29339.3,"yon":267,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:16:58"}', '2025-08-25 23:16:58', '2025-08-25 23:17:00'),
	(2408187, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"09:17:43","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:17:43"}', '2025-08-25 23:17:43', '2025-08-25 23:17:37'),
	(2408188, '31.143.219.198:35638', '86284304533376212', 40.996753, 28.903386, _binary 0x0000000001010000000daa0d4e44e73c400dd7b49c957f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:20:08","ind":0,"enl":"40.9967533","boy":"028.903386","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10954.6,"yon":330,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 09:20:08"}', '2025-08-25 23:20:08', '2025-08-25 23:20:11'),
	(2408189, '31.143.219.198:35638', '86284304533376212', 40.996747, 28.903441, _binary 0x00000000010100000094ddcce847e73c40ae725765957f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:20:13","ind":0,"enl":"40.9967467","boy":"028.903441","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10954.6,"yon":330,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:20:13"}', '2025-08-25 23:20:13', '2025-08-25 23:20:16'),
	(2408190, '31.143.219.198:35638', '86284304533376212', 40.996747, 28.903445, _binary 0x00000000010100000017bce82b48e73c40ae725765957f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:20:14","ind":0,"enl":"40.9967467","boy":"028.903445","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10954.6,"yon":330,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 09:20:14"}', '2025-08-25 23:20:14', '2025-08-25 23:20:16'),
	(2408191, '5.27.202.142:9550', 'a1a58402fabc488f0', 40.997228, 29.074670, _binary 0x00000000010100000009feb7921d133d40a6924b2da57f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"09:21:28","ind":0,"enl":"40.9972283","boy":"029.074670","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43117.8,"yon":230,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:21:28"}', '2025-08-25 23:21:28', '2025-08-25 23:21:30'),
	(2408192, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"26.08.2025","sat":"09:22:03","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":297,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:22:03"}', '2025-08-25 23:22:03', '2025-08-25 23:22:06'),
	(2408193, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"26.08.2025","sat":"09:22:08","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":359,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:22:08"}', '2025-08-25 23:22:08', '2025-08-25 23:22:11'),
	(2408194, '31.143.219.198:35638', '86284304533376212', 40.996412, 28.900266, _binary 0x00000000010100000063b323d577e63c40076d286b8a7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:22:17","ind":0,"enl":"40.9964117","boy":"028.900266","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":18.316280000000003,"mes":10954.9,"yon":301,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:22:17"}', '2025-08-25 23:22:17', '2025-08-25 23:22:20'),
	(2408195, '31.143.219.198:35638', '86284304533376212', 40.997423, 28.895495, _binary 0x00000000010100000045bb0a293fe53c405be21291ab7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:23:58","ind":0,"enl":"40.9974233","boy":"028.895495","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":14.149280000000001,"mes":10955.5,"yon":318,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:23:58"}', '2025-08-25 23:23:58', '2025-08-25 23:24:00'),
	(2408196, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"26.08.2025","sat":"09:24:18","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":149,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:24:18"}', '2025-08-25 23:24:18', '2025-08-25 23:24:21'),
	(2408197, '31.143.21.53:17428', '44fe033664dac2621', 40.937120, 29.133683, _binary 0x000000000101000000fb07910c39223d40b936548cf3774440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"09:25:56","ind":0,"enl":"40.9371200","boy":"029.133683","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74659.2,"yon":118,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:25:56"}', '2025-08-25 23:25:56', '2025-08-25 23:25:57'),
	(2408198, '31.143.219.198:35638', '86284304533376212', 41.001608, 28.894781, _binary 0x00000000010100000009151c5e10e53c407af365b334804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:25:55","ind":0,"enl":"41.0016083","boy":"028.894781","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":10.44528,"mes":10956,"yon":7,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:25:55"}', '2025-08-25 23:25:55', '2025-08-25 23:25:57'),
	(2408199, '31.143.219.198:35638', '86284304533376212', 41.005922, 28.895616, _binary 0x0000000001010000003bc6151747e53c401aebd10ac2804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:26:53","ind":0,"enl":"41.0059217","boy":"028.895616","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":14.37152,"mes":10956.4,"yon":320,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:26:53"}', '2025-08-25 23:26:53', '2025-08-25 23:26:55'),
	(2408200, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"09:27:43","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:27:43"}', '2025-08-25 23:27:43', '2025-08-25 23:27:37'),
	(2408201, '31.143.219.198:35638', '86284304533376212', 41.002280, 28.891601, _binary 0x000000000101000000b61490f63fe43c40aab706b64a804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:27:36","ind":0,"enl":"41.0022800","boy":"028.891601","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":43.78128,"mes":10957,"yon":247,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:27:36"}', '2025-08-25 23:27:36', '2025-08-25 23:27:40'),
	(2408202, '5.27.202.142:9550', 'a1a58402fabc488f0', 40.997228, 29.074670, _binary 0x00000000010100000009feb7921d133d40a6924b2da57f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"09:27:42","ind":0,"enl":"40.9972283","boy":"029.074670","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43117.8,"yon":9,"A":"4","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:27:42"}', '2025-08-25 23:27:42', '2025-08-25 23:27:44'),
	(2408203, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"09:28:26","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":104,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:28:26"}', '2025-08-25 23:28:26', '2025-08-25 23:28:27'),
	(2408204, '31.143.219.198:35638', '86284304533376212', 41.001350, 28.885630, _binary 0x000000000101000000425bcea5b8e23c40c0ec9e3c2c804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:28:28","ind":0,"enl":"41.0013500","boy":"028.885630","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":39.55872,"mes":10957.5,"yon":234,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:28:28"}', '2025-08-25 23:28:28', '2025-08-25 23:28:30'),
	(2408205, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.997417, 29.074600, _binary 0x000000000101000000174850fc18133d40fc7db559ab7f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:29:05","ind":0,"enl":"40.9974167","boy":"029.074600","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94766.5,"yon":270,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 09:29:05"}', '2025-08-25 23:29:05', '2025-08-25 23:29:07'),
	(2408206, '31.143.219.198:35638', '86284304533376212', 41.004993, 28.882268, _binary 0x000000000101000000ad4ece50dce13c407d19d69ea3804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:29:40","ind":0,"enl":"41.0049933","boy":"028.882268","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":39.651320000000005,"mes":10957.9,"yon":335,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:29:40"}', '2025-08-25 23:29:40', '2025-08-25 23:29:43'),
	(2408207, '31.143.219.198:35638', '86284304533376212', 41.009483, 28.881130, _binary 0x000000000101000000448655bc91e13c40d8adafbf36814440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:30:24","ind":0,"enl":"41.0094833","boy":"028.881130","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":44.94804,"mes":10958.5,"yon":355,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:30:24"}', '2025-08-25 23:30:24', '2025-08-25 23:30:26'),
	(2408208, '31.143.219.198:35638', '86284304533376212', 41.014097, 28.880293, _binary 0x000000000101000000d2e5cde15ae13c40a3bdb0ebcd814440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:31:05","ind":0,"enl":"41.0140967","boy":"028.880293","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":43.09604,"mes":10959,"yon":348,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:31:05"}', '2025-08-25 23:31:05', '2025-08-25 23:31:08'),
	(2408209, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.997423, 29.074545, _binary 0x0000000001010000009014916115133d405be21291ab7f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:31:08","ind":0,"enl":"40.9974233","boy":"029.074545","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94766.5,"yon":196,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 09:31:08"}', '2025-08-25 23:31:08', '2025-08-25 23:31:10'),
	(2408210, '31.143.219.198:35638', '86284304533376212', 41.016368, 28.878135, _binary 0x00000000010100000014799274cde03c407798405b18824440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:32:20","ind":0,"enl":"41.0163683","boy":"028.878135","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":27.63184,"mes":10959.4,"yon":262,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:32:20"}', '2025-08-25 23:32:20', '2025-08-25 23:32:23'),
	(2408211, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.997423, 29.074545, _binary 0x0000000001010000009014916115133d405be21291ab7f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:33:12","ind":0,"enl":"40.9974233","boy":"029.074545","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":2.0372000000000003,"mes":94766.5,"yon":128,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:33:12"}', '2025-08-25 23:33:12', '2025-08-25 23:33:14'),
	(2408212, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.001145, 29.077693, _binary 0x000000000101000000cd203eb0e3133d40e7c6f48425804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:34:14","ind":0,"enl":"41.0011450","boy":"029.077693","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":25.965040000000002,"mes":94767.1,"yon":56,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:34:14"}', '2025-08-25 23:34:14', '2025-08-25 23:34:16'),
	(2408213, '31.143.219.198:35638', '86284304533376212', 41.015890, 28.875036, _binary 0x0000000001010000009ad2fa5b02e03c40ae2afbae08824440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:34:25","ind":0,"enl":"41.0158900","boy":"028.875036","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":2.25944,"mes":10959.8,"yon":142,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:34:25"}', '2025-08-25 23:34:25', '2025-08-25 23:34:27'),
	(2408214, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.004950, 29.076088, _binary 0x000000000101000000389ecf807a133d40bf0e9c33a2804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:35:35","ind":0,"enl":"41.0049500","boy":"029.076088","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":22.335120000000003,"mes":94767.5,"yon":329,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:35:35"}', '2025-08-25 23:35:35', '2025-08-25 23:35:37'),
	(2408215, '31.143.219.198:35638', '86284304533376212', 41.016178, 28.874821, _binary 0x000000000101000000a1dae044f4df3c40d3b36a2112824440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:36:30","ind":0,"enl":"41.0161783","boy":"028.874821","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":3.50028,"mes":10959.9,"yon":224,"A":"13","Sensor":"","drx":1,"ignition":1,"datetime":"2025-08-26 09:36:30"}', '2025-08-25 23:36:30', '2025-08-25 23:36:31'),
	(2408216, '31.143.219.198:35638', '86284304533376212', 41.016178, 28.874821, _binary 0x000000000101000000a1dae044f4df3c40d3b36a2112824440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:36:29","ind":0,"enl":"41.0161783","boy":"028.874821","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":2.0372000000000003,"mes":10959.9,"yon":232,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:36:29"}', '2025-08-25 23:36:29', '2025-08-25 23:36:31'),
	(2408217, '31.143.219.198:35638', '86284304533376212', 41.016262, 28.874720, _binary 0x000000000101000000392861a6eddf3c40b4d606dd14824440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:36:37","ind":0,"enl":"41.0162617","boy":"028.874720","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10959.9,"yon":266,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 09:36:37"}', '2025-08-25 23:36:37', '2025-08-25 23:36:39'),
	(2408218, '31.143.219.198:35638', '86284304533376212', 41.016298, 28.874695, _binary 0x00000000010100000087f9f202ecdf3c407ebd0c1016824440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:36:41","ind":0,"enl":"41.0162983","boy":"028.874695","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10959.9,"yon":358,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:36:41"}', '2025-08-25 23:36:41', '2025-08-25 23:36:43'),
	(2408219, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.007308, 29.079851, _binary 0x0000000001010000008b8d791d71143d40a3be767aef804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:37:00","ind":0,"enl":"41.0073083","boy":"029.079851","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":39.484640000000006,"mes":94768,"yon":62,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:37:00"}', '2025-08-25 23:37:00', '2025-08-25 23:37:03'),
	(2408220, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"09:37:43","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:37:43"}', '2025-08-25 23:37:43', '2025-08-25 23:37:38'),
	(2408221, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.008978, 29.085473, _binary 0x000000000101000000e6b0fb8ee1153d40d56f703326814440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:37:39","ind":0,"enl":"41.0089783","boy":"029.085473","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":55.911880000000004,"mes":94768.6,"yon":72,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:37:39"}', '2025-08-25 23:37:39', '2025-08-25 23:37:42'),
	(2408222, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.008917, 29.091615, _binary 0x000000000101000000b3d2a41474173d40b271b32e24814440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:38:13","ind":0,"enl":"41.0089167","boy":"029.091615","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":53.411680000000004,"mes":94769,"yon":116,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:38:13"}', '2025-08-25 23:38:13', '2025-08-25 23:38:16'),
	(2408223, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997470, 29.074741, _binary 0x0000000001010000009babe63922133d40dd5ed218ad7f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"26.08.2025","sat":"09:38:56","ind":0,"enl":"40.9974700","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":0,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:38:56"}', '2025-08-25 23:38:56', '2025-08-25 23:38:58'),
	(2408224, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.007122, 29.097165, _binary 0x000000000101000000db5031cedf183d40c44b265de9804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:39:04","ind":0,"enl":"41.0071217","boy":"029.097165","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":43.65164,"mes":94769.6,"yon":120,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:39:04"}', '2025-08-25 23:39:04', '2025-08-25 23:39:07'),
	(2408225, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003950, 29.101643, _binary 0x00000000010100000009de9046051a3d40dc68006f81804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:39:39","ind":0,"enl":"41.0039500","boy":"029.101643","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":64.26440000000001,"mes":94770.1,"yon":135,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:39:39"}', '2025-08-25 23:39:39', '2025-08-25 23:39:42'),
	(2408226, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.000570, 29.105921, _binary 0x000000000101000000a9f57ea31d1b3d40ebad81ad12804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:40:07","ind":0,"enl":"41.0005700","boy":"029.105921","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":67.50540000000001,"mes":94770.5,"yon":136,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:40:07"}', '2025-08-25 23:40:07', '2025-08-25 23:40:10'),
	(2408227, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.997325, 29.074580, _binary 0x00000000010100000089efc4ac17133d40d93d7958a87f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"09:40:15","ind":0,"enl":"40.9973250","boy":"029.074580","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43239,"yon":283,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:40:15"}', '2025-08-25 23:40:15', '2025-08-25 23:40:18'),
	(2408228, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.997525, 29.110686, _binary 0x0000000001010000000420eeea551c3d40a1f831e6ae7f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:40:33","ind":0,"enl":"40.9975250","boy":"029.110686","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":68.11656,"mes":94771.1,"yon":123,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:40:33"}', '2025-08-25 23:40:33', '2025-08-25 23:40:36'),
	(2408229, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.994668, 29.115420, _binary 0x000000000101000000e84d452a8c1d3d40186f754a517f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:41:09","ind":0,"enl":"40.9946683","boy":"029.115420","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":43.26272,"mes":94771.6,"yon":145,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:41:09"}', '2025-08-25 23:41:09', '2025-08-25 23:41:12'),
	(2408230, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.995503, 29.120755, _binary 0x00000000010100000017d4b7cce91e3d40b147f2a66c7f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:41:51","ind":0,"enl":"40.9955033","boy":"029.120755","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":47.63344,"mes":94772.2,"yon":84,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:41:51"}', '2025-08-25 23:41:51', '2025-08-25 23:42:00'),
	(2408231, '176.89.73.86:39026', '350612079185623', 41.014947, 29.054153, _binary 0x00000000010100000071789cfddc0d3d40dc172bc5e9814440, '0', '{"device_model": "Teltonika", "p": "1", "did": "350612079185623", "trh": "2025-08-26", "sat": "09:40:44", "ind": 0, "enl": "41.0149466", "boy": "29.0541533", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 27279.236, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12616, "battery_voltage": 4057, "battery_current": 0, "record_timestamp": "2025-08-26 09:40:44", "codec_id": 8}', '2025-08-25 23:40:44', '2025-08-25 23:43:02'),
	(2408232, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.995668, 29.126730, _binary 0x0000000001010000000d6c956071203d40fb14110f727f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:42:28","ind":0,"enl":"40.9956683","boy":"029.126730","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":55.24516,"mes":94772.6,"yon":80,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:42:28"}', '2025-08-25 23:42:28', '2025-08-25 23:42:33'),
	(2408233, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.994615, 29.128046, _binary 0x0000000001010000003562669fc7203d40378e588b4f7f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:43:29","ind":0,"enl":"40.9946150","boy":"029.128046","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":43.910920000000004,"mes":94773.1,"yon":196,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:43:29"}', '2025-08-25 23:43:29', '2025-08-25 23:43:32'),
	(2408234, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"09:43:50","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":206,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:43:50"}', '2025-08-25 23:43:50', '2025-08-25 23:43:52'),
	(2408235, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.990833, 29.125825, _binary 0x000000000101000000ea04341136203d40d5a425a0d37e4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:44:26","ind":0,"enl":"40.9908333","boy":"029.125825","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":25.3724,"mes":94773.7,"yon":267,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:44:26"}', '2025-08-25 23:44:26', '2025-08-25 23:44:31'),
	(2408236, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.992297, 29.122798, _binary 0x000000000101000000a30392b06f1f3d40e0360994037f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:45:48","ind":0,"enl":"40.9922967","boy":"029.122798","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94774,"yon":259,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:45:48"}', '2025-08-25 23:45:48', '2025-08-25 23:45:49'),
	(2408237, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.997325, 29.074580, _binary 0x00000000010100000089efc4ac17133d40d93d7958a87f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"09:46:56","ind":0,"enl":"40.9973250","boy":"029.074580","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43239,"yon":9,"A":"4","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:46:56"}', '2025-08-25 23:46:56', '2025-08-25 23:46:57'),
	(2408238, '31.143.219.198:35638', '86284304533376212', 41.016322, 28.874680, _binary 0x0000000001010000001d774a07ebdf3c4089db57d416824440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:47:13","ind":0,"enl":"41.0163217","boy":"028.874680","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10959.9,"yon":183,"A":"4","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:47:13"}', '2025-08-25 23:47:13', '2025-08-25 23:47:14'),
	(2408239, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"09:47:43","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:47:43"}', '2025-08-25 23:47:43', '2025-08-25 23:47:38'),
	(2408240, '31.143.219.198:35638', '86284304533376212', 41.016322, 28.874680, _binary 0x0000000001010000001d774a07ebdf3c4089db57d416824440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:49:42","ind":0,"enl":"41.0163217","boy":"028.874680","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10959.9,"yon":23,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 09:49:42"}', '2025-08-25 23:49:42', '2025-08-25 23:49:44'),
	(2408241, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.997325, 29.074580, _binary 0x00000000010100000089efc4ac17133d40d93d7958a87f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"09:50:48","ind":0,"enl":"40.9973250","boy":"029.074580","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43239,"yon":58,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 09:50:48"}', '2025-08-25 23:50:48', '2025-08-25 23:50:49'),
	(2408242, '31.143.219.198:35638', '86284304533376212', 41.016215, 28.874676, _binary 0x0000000001010000009a982ec4eadf3c40325a475513824440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:51:05","ind":0,"enl":"41.0162150","boy":"028.874676","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10959.9,"yon":99,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:51:05"}', '2025-08-25 23:51:05', '2025-08-25 23:51:07'),
	(2408243, '31.143.219.198:35638', '86284304533376212', 41.016238, 28.874731, _binary 0x00000000010100000021cced5eeedf3c40a8b8bb1814824440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:51:07","ind":0,"enl":"41.0162383","boy":"028.874731","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10959.9,"yon":354,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 09:51:07"}', '2025-08-25 23:51:07', '2025-08-25 23:51:08'),
	(2408244, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.997322, 29.074030, _binary 0x00000000010100000042ec4ca1f3123d40aa8bca3ca87f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"09:52:10","ind":0,"enl":"40.9973217","boy":"029.074030","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":11.18608,"mes":43239.1,"yon":341,"A":"5","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:52:10"}', '2025-08-25 23:52:10', '2025-08-25 23:52:11'),
	(2408245, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"26.08.2025","sat":"09:53:05","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":7,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:53:05"}', '2025-08-25 23:53:05', '2025-08-25 23:53:07'),
	(2408246, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"26.08.2025","sat":"09:53:10","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":190,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:53:10"}', '2025-08-25 23:53:10', '2025-08-25 23:53:13'),
	(2408247, '31.143.219.198:35638', '86284304533376212', 41.016163, 28.873965, _binary 0x00000000010100000040d9942bbcdf3c409e7296a311824440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:53:10","ind":0,"enl":"41.0161633","boy":"028.873965","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10960,"yon":36,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 09:53:10"}', '2025-08-25 23:53:10', '2025-08-25 23:53:13'),
	(2408248, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.992290, 29.122786, _binary 0x0000000001010000001b683ee76e1f3d40ec12d55b037f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:53:26","ind":0,"enl":"40.9922900","boy":"029.122786","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94774,"yon":259,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 09:53:26"}', '2025-08-25 23:53:26', '2025-08-25 23:53:27'),
	(2408249, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.000643, 29.073060, _binary 0x00000000010100000051a5660fb4123d40133b641415804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"09:54:00","ind":0,"enl":"41.0006433","boy":"029.073060","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":37.55856000000001,"mes":43239.6,"yon":165,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:54:00"}', '2025-08-25 23:54:00', '2025-08-25 23:54:02'),
	(2408250, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.996105, 29.073953, _binary 0x000000000101000000eb707495ee123d40e8305f5e807f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"09:54:32","ind":0,"enl":"40.9961050","boy":"029.073953","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":51.52264,"mes":43240.1,"yon":184,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:54:32"}', '2025-08-25 23:54:32', '2025-08-25 23:54:35'),
	(2408251, '31.143.219.198:35638', '86284304533376212', 41.013708, 28.877903, _binary 0x0000000001010000006f0f4240bee03c4085178e31c1814440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:54:53","ind":0,"enl":"41.0137083","boy":"028.877903","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":32.2248,"mes":10960.5,"yon":183,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:54:53"}', '2025-08-25 23:54:53', '2025-08-25 23:54:56'),
	(2408252, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.991835, 29.117036, _binary 0x00000000010100000064744012f61d3d409b030473f47e4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:55:12","ind":0,"enl":"40.9918350","boy":"029.117036","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":45.725880000000004,"mes":94774.6,"yon":267,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:55:12"}', '2025-08-25 23:55:12', '2025-08-25 23:55:16'),
	(2408253, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"26.08.2025","sat":"09:55:20","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":288,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:55:20"}', '2025-08-25 23:55:20', '2025-08-25 23:55:22'),
	(2408254, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.993918, 29.070316, _binary 0x000000000101000000b262b83a00123d40adb200b7387f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"09:55:44","ind":0,"enl":"40.9939183","boy":"029.070316","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":43.07752000000001,"mes":43240.6,"yon":296,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:55:44"}', '2025-08-25 23:55:44', '2025-08-25 23:55:47'),
	(2408255, '31.143.219.198:35638', '86284304533376212', 41.009773, 28.874993, _binary 0x0000000001010000009b3a8f8affdf3c40dfef614040814440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:56:16","ind":0,"enl":"41.0097733","boy":"028.874993","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":32.243320000000004,"mes":10960.9,"yon":200,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:56:16"}', '2025-08-25 23:56:16', '2025-08-25 23:56:18'),
	(2408256, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.995842, 29.064863, _binary 0x0000000001010000006fb88fdc9a103d401cbfa6bd777f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"09:56:39","ind":0,"enl":"40.9958417","boy":"029.064863","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":25.261280000000003,"mes":43241.2,"yon":295,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:56:39"}', '2025-08-25 23:56:39', '2025-08-25 23:56:42'),
	(2408257, '31.143.21.53:17428', '44fe033664dac2621', 40.937120, 29.133683, _binary 0x000000000101000000fb07910c39223d40b936548cf3774440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"09:57:02","ind":0,"enl":"40.9371200","boy":"029.133683","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74659.2,"yon":110,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:57:02"}', '2025-08-25 23:57:02', '2025-08-25 23:57:04'),
	(2408258, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.993213, 29.112958, _binary 0x00000000010100000052d2c3d0ea1c3d40e3b9089d217f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:57:09","ind":0,"enl":"40.9932133","boy":"029.112958","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":54.263600000000004,"mes":94775.1,"yon":286,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:57:09"}', '2025-08-25 23:57:09', '2025-08-25 23:57:19'),
	(2408259, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.997912, 29.059480, _binary 0x0000000001010000001ec4ce143a0f3d40dce51192bb7f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"09:57:29","ind":0,"enl":"40.9979117","boy":"029.059480","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":43.87388000000001,"mes":43241.7,"yon":296,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:57:29"}', '2025-08-25 23:57:29', '2025-08-25 23:57:32'),
	(2408260, '31.143.219.198:35638', '86284304533376212', 41.006667, 28.871253, _binary 0x000000000101000000b98ac56f0adf3c40723c5574da804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:57:34","ind":0,"enl":"41.0066667","boy":"028.871253","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":48.577960000000004,"mes":10961.5,"yon":242,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:57:34"}', '2025-08-25 23:57:34', '2025-08-25 23:57:36'),
	(2408261, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"09:57:44","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:57:44"}', '2025-08-25 23:57:44', '2025-08-25 23:57:38'),
	(2408262, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.996668, 29.111380, _binary 0x000000000101000000b16d5166831c3d40dfbaacd3927f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:58:01","ind":0,"enl":"40.9966683","boy":"029.111380","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":32.46556,"mes":94775.5,"yon":294,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:58:01"}', '2025-08-25 23:58:01', '2025-08-25 23:58:04'),
	(2408263, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.000048, 29.057103, _binary 0x000000000101000000e5805d4d9e0e3d40d0752b9501804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"09:58:12","ind":0,"enl":"41.0000483","boy":"029.057103","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":30.724680000000003,"mes":43242.1,"yon":145,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:58:12"}', '2025-08-25 23:58:12', '2025-08-25 23:58:15'),
	(2408264, '31.143.219.198:35638', '86284304533376212', 41.003857, 28.866391, _binary 0x0000000001010000007a8cf2cccbdd3c406c2f58607e804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:58:41","ind":0,"enl":"41.0038567","boy":"028.866391","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":51.52264,"mes":10962,"yon":233,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:58:41"}', '2025-08-25 23:58:41', '2025-08-25 23:58:44'),
	(2408265, '5.27.202.142:9550', 'a1a58402fabc488f0', 40.997228, 29.074670, _binary 0x00000000010100000009feb7921d133d40a6924b2da57f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"09:58:44","ind":0,"enl":"40.9972283","boy":"029.074670","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43117.8,"yon":252,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:58:44"}', '2025-08-25 23:58:44', '2025-08-25 23:58:46'),
	(2408266, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.996715, 29.052990, _binary 0x000000000101000000da03adc0900d3d4061376c5b947f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"09:58:45","ind":0,"enl":"40.9967150","boy":"029.052990","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":62.56056,"mes":43242.7,"yon":228,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:58:45"}', '2025-08-25 23:58:45', '2025-08-25 23:58:49'),
	(2408267, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.999788, 29.108928, _binary 0x000000000101000000629e95b4e21b3d4033b62110f97f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:58:50","ind":0,"enl":"40.9997883","boy":"029.108928","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":43.55904,"mes":94776.1,"yon":313,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:58:50"}', '2025-08-25 23:58:50', '2025-08-25 23:58:53'),
	(2408268, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"09:59:15","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":49,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 09:59:15"}', '2025-08-25 23:59:15', '2025-08-25 23:59:16'),
	(2408269, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.994000, 29.047926, _binary 0x000000000101000000cba0dae0440c3d40ac1c5a643b7f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"09:59:16","ind":0,"enl":"40.9940000","boy":"029.047926","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":59.87516,"mes":43243.2,"yon":254,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:59:16"}', '2025-08-25 23:59:16', '2025-08-25 23:59:19'),
	(2408270, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.002548, 29.104071, _binary 0x0000000001010000004776a565a41a3d408894b08053804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:59:26","ind":0,"enl":"41.0025483","boy":"029.104071","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":69.24628,"mes":94776.6,"yon":317,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:59:26"}', '2025-08-25 23:59:26', '2025-08-25 23:59:29'),
	(2408271, '31.143.219.198:35638', '86284304533376212', 41.001023, 28.861785, _binary 0x000000000101000000f12e17f19ddc3c405a04108821804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"09:59:28","ind":0,"enl":"41.0010233","boy":"028.861785","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":27.72444,"mes":10962.6,"yon":236,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:59:28"}', '2025-08-25 23:59:28', '2025-08-25 23:59:30'),
	(2408272, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.991780, 29.042283, _binary 0x000000000101000000412d060fd30a3d40d769a4a5f27e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"09:59:49","ind":0,"enl":"40.9917800","boy":"029.042283","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":63.07912000000001,"mes":43243.6,"yon":231,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:59:49"}', '2025-08-25 23:59:49', '2025-08-25 23:59:51'),
	(2408273, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.005965, 29.099675, _binary 0x000000000101000000933a014d84193d40d8f50b76c3804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"09:59:52","ind":0,"enl":"41.0059650","boy":"029.099675","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":72.9688,"mes":94777.1,"yon":308,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 09:59:52"}', '2025-08-25 23:59:52', '2025-08-25 23:59:55'),
	(2408274, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.989172, 29.037218, _binary 0x00000000010100000091d26c1e87093d407ad0a22d9d7e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:00:21","ind":0,"enl":"40.9891717","boy":"029.037218","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":55.097,"mes":43244.2,"yon":239,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:00:21"}', '2025-08-26 00:00:21', '2025-08-26 00:00:23'),
	(2408275, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.008707, 29.094833, _binary 0x000000000101000000e294b9f946183d40c7e0174d1d814440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:00:22","ind":0,"enl":"41.0087067","boy":"029.094833","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":40.22544,"mes":94777.6,"yon":290,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:00:22"}', '2025-08-26 00:00:22', '2025-08-26 00:00:24'),
	(2408276, '31.143.219.198:35638', '86284304533376212', 40.998150, 28.857115, _binary 0x0000000001010000003ae97de36bdb3c404f401361c37f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"10:00:59","ind":0,"enl":"40.9981500","boy":"028.857115","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":45.6518,"mes":10963,"yon":232,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:00:59"}', '2025-08-26 00:00:59', '2025-08-26 00:01:03'),
	(2408277, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.987657, 29.038036, _binary 0x000000000101000000171230babc093d407016e5886b7e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:01:08","ind":0,"enl":"40.9876567","boy":"029.038036","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":42.725640000000006,"mes":43244.7,"yon":158,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:01:08"}', '2025-08-26 00:01:08', '2025-08-26 00:01:15'),
	(2408278, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.009825, 29.089028, _binary 0x000000000101000000a46dfc89ca163d4073d712f241814440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:01:17","ind":0,"enl":"41.0098250","boy":"029.089028","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":35.70656,"mes":94778.1,"yon":276,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:01:17"}', '2025-08-26 00:01:17', '2025-08-26 00:01:20'),
	(2408279, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.009218, 29.083408, _binary 0x0000000001010000008a39083a5a153d402a83b4102e814440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:02:49","ind":0,"enl":"41.0092183","boy":"029.083408","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":29.446800000000003,"mes":94778.6,"yon":248,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:02:49"}', '2025-08-26 00:02:49', '2025-08-26 00:02:52'),
	(2408280, '31.143.219.198:35638', '86284304533376212', 40.996650, 28.854560, _binary 0x0000000001010000004278b471c4da3c407ac7293a927f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"10:03:03","ind":0,"enl":"40.9966500","boy":"028.854560","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":5.2041200000000005,"mes":10963.3,"yon":237,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:03:03"}', '2025-08-26 00:03:03', '2025-08-26 00:03:06'),
	(2408281, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.986935, 29.036183, _binary 0x000000000101000000d2ab014a43093d408e23d6e2537e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:03:07","ind":0,"enl":"40.9869350","boy":"029.036183","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":31.89144,"mes":43245.2,"yon":321,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:03:07"}', '2025-08-26 00:03:07', '2025-08-26 00:03:10'),
	(2408282, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.006428, 29.081430, _binary 0x000000000101000000cde9b298d8143d406b227da4d2804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:04:52","ind":0,"enl":"41.0064283","boy":"029.081430","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":37.3178,"mes":94779.1,"yon":168,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:04:52"}', '2025-08-26 00:04:52', '2025-08-26 00:04:56'),
	(2408283, '31.143.219.198:35638', '86284304533376212', 40.993828, 28.852218, _binary 0x000000000101000000021077f52ada3c406d2b07c4357f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"10:05:07","ind":0,"enl":"40.9938283","boy":"028.852218","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":19.05708,"mes":10963.7,"yon":197,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:05:07"}', '2025-08-26 00:05:07', '2025-08-26 00:05:10'),
	(2408284, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.987510, 29.033976, _binary 0x00000000010100000051d9b0a6b2083d408a3c49ba667e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:05:11","ind":0,"enl":"40.9875100","boy":"029.033976","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":21.31652,"mes":43245.4,"yon":332,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:05:11"}', '2025-08-26 00:05:11', '2025-08-26 00:05:16'),
	(2408285, '31.143.219.198:35638', '86284304533376212', 40.991907, 28.846980, _binary 0x000000000101000000b75d68aed3d83c4076977accf67e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"10:05:56","ind":0,"enl":"40.9919067","boy":"028.846980","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":42.596000000000004,"mes":10964.2,"yon":271,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:05:56"}', '2025-08-26 00:05:56', '2025-08-26 00:05:59'),
	(2408286, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.002803, 29.080853, _binary 0x00000000010100000093c83ec8b2143d4012e9c8db5b804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:06:02","ind":0,"enl":"41.0028033","boy":"029.080853","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":32.37296,"mes":94779.6,"yon":211,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:06:02"}', '2025-08-26 00:06:02', '2025-08-26 00:06:06'),
	(2408287, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.983392, 29.033061, _binary 0x000000000101000000e7c589af76083d4034547bc7df7d4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:06:10","ind":0,"enl":"40.9833917","boy":"029.033061","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":21.927680000000002,"mes":43245.9,"yon":196,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:06:10"}', '2025-08-26 00:06:10', '2025-08-26 00:06:13'),
	(2408288, '31.143.219.198:35638', '86284304533376212', 40.992178, 28.841063, _binary 0x0000000001010000002ae09ee74fd73c408326d3b2ff7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"10:06:44","ind":0,"enl":"40.9921783","boy":"028.841063","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":52.43012,"mes":10964.8,"yon":274,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:06:44"}', '2025-08-26 00:06:44', '2025-08-26 00:06:47'),
	(2408289, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.000007, 29.076771, _binary 0x000000000101000000fe47a643a7133d40f423343800804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:07:02","ind":4,"enl":"41.0000067","boy":"029.076771","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":26.7614,"mes":94780.2,"yon":220,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:07:02"}', '2025-08-26 00:07:02', '2025-08-26 00:07:04'),
	(2408290, '31.143.219.198:35638', '86284304533376212', 40.992480, 28.834895, _binary 0x0000000001010000000b98c0adbbd53c4090f7aa95097f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"10:07:16","ind":0,"enl":"40.9924800","boy":"028.834895","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":64.78296,"mes":10965.2,"yon":274,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:07:16"}', '2025-08-26 00:07:16', '2025-08-26 00:07:29'),
	(2408291, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.984520, 29.028061, _binary 0x000000000101000000064b75012f073d40042159c0047e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:07:34","ind":0,"enl":"40.9845200","boy":"029.028061","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":26.1132,"mes":43246.4,"yon":289,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:07:34"}', '2025-08-26 00:07:34', '2025-08-26 00:07:37'),
	(2408292, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"10:07:44","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:07:44"}', '2025-08-26 00:07:44', '2025-08-26 00:07:38'),
	(2408293, '31.143.219.198:35638', '86284304533376212', 40.992842, 28.828526, _binary 0x000000000101000000bde2a9471ad43c4072cdd36f157f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"10:07:47","ind":0,"enl":"40.9928417","boy":"028.828526","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":60.20852,"mes":10965.8,"yon":274,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:07:47"}', '2025-08-26 00:07:47', '2025-08-26 00:07:50'),
	(2408294, '178.245.95.200:52240', '86243005630594516', 40.998368, 29.053156, _binary 0x0000000001010000001096b1a19b0d3d407bee4e88ca7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"10:08:20","ind":4,"enl":"40.9983683","boy":"029.053156","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":119,"A":"21","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:08:20"}', '2025-08-26 00:08:20', '2025-08-26 00:08:14'),
	(2408295, '31.143.219.198:35638', '86284304533376212', 40.993612, 28.822581, _binary 0x0000000001010000009c4f1dab94d23c4024360eab2e7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"10:08:22","ind":0,"enl":"40.9936117","boy":"028.822581","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":51.930080000000004,"mes":10966.3,"yon":309,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:08:22"}', '2025-08-26 00:08:22', '2025-08-26 00:08:24'),
	(2408296, '31.143.219.198:35638', '86284304533376212', 40.997588, 28.819995, _binary 0x0000000001010000002ee23b31ebd13c40a5af31f9b07f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"10:08:58","ind":0,"enl":"40.9975883","boy":"028.819995","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":48.94836,"mes":10966.7,"yon":343,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:08:58"}', '2025-08-26 00:08:58', '2025-08-26 00:09:01'),
	(2408297, '31.142.88.1:22480', '353201357563383', 40.997282, 29.048400, _binary 0x0000000001010000005c2041f1630c3d40877368eca67f4440, '0', '{"device_model": "Teltonika", "p": "1", "did": "353201357563383", "trh": "2025-08-26", "sat": "10:07:28", "ind": 0, "enl": "40.9972816", "boy": "29.0484", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 3.137, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12001, "battery_voltage": 0, "battery_current": 0, "record_timestamp": "2025-08-26 10:07:28", "codec_id": 8}', '2025-08-26 00:07:28', '2025-08-26 00:10:01'),
	(2408298, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.997318, 29.074668, _binary 0x000000000101000000c70e2a711d133d40e6194520a87f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:09:06","ind":0,"enl":"40.9973183","boy":"029.074668","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94780.5,"yon":92,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 10:09:06"}', '2025-08-26 00:09:06', '2025-08-26 00:09:08'),
	(2408299, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.985663, 29.025941, _binary 0x00000000010100000023a0c211a4063d40082f0b372a7e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:09:39","ind":0,"enl":"40.9856633","boy":"029.025941","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43246.7,"yon":223,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 10:09:39"}', '2025-08-26 00:09:39', '2025-08-26 00:09:41'),
	(2408300, '31.143.219.198:35638', '86284304533376212', 41.000562, 28.822160, _binary 0x0000000001010000005114e81379d23c40a990e16712804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"10:09:44","ind":0,"enl":"41.0005617","boy":"028.822160","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":29.50236,"mes":10967.3,"yon":82,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:09:44"}', '2025-08-26 00:09:44', '2025-08-26 00:09:46'),
	(2408301, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997470, 29.074741, _binary 0x0000000001010000009babe63922133d40dd5ed218ad7f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"26.08.2025","sat":"10:09:57","ind":0,"enl":"40.9974700","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":7,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:09:57"}', '2025-08-26 00:09:57', '2025-08-26 00:10:00'),
	(2408302, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.997318, 29.074668, _binary 0x000000000101000000c70e2a711d133d40e6194520a87f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:11:10","ind":0,"enl":"40.9973183","boy":"029.074668","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94780.5,"yon":307,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 10:11:10"}', '2025-08-26 00:11:10', '2025-08-26 00:11:12'),
	(2408303, '31.143.219.198:35638', '86284304533376212', 41.001005, 28.827891, _binary 0x0000000001010000001aa721aaf0d33c40f5108dee20804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"10:11:19","ind":0,"enl":"41.0010050","boy":"028.827891","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":15.408640000000002,"mes":10967.8,"yon":108,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:11:19"}', '2025-08-26 00:11:19', '2025-08-26 00:11:22'),
	(2408304, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.985663, 29.025941, _binary 0x00000000010100000023a0c211a4063d40082f0b372a7e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:11:43","ind":0,"enl":"40.9856633","boy":"029.025941","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43246.7,"yon":223,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 10:11:43"}', '2025-08-26 00:11:43', '2025-08-26 00:11:46'),
	(2408305, '31.143.219.198:35638', '86284304533376212', 41.001372, 28.827726, _binary 0x000000000101000000840ce4d9e5d33c40e951a7f22c804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"10:13:01","ind":0,"enl":"41.0013717","boy":"028.827726","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":2.00016,"mes":10967.9,"yon":193,"A":"13","Sensor":"","drx":1,"ignition":1,"datetime":"2025-08-26 10:13:01"}', '2025-08-26 00:13:01', '2025-08-26 00:13:04'),
	(2408306, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.997318, 29.074668, _binary 0x000000000101000000c70e2a711d133d40e6194520a87f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:13:14","ind":0,"enl":"40.9973183","boy":"029.074668","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94780.5,"yon":274,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 10:13:14"}', '2025-08-26 00:13:14', '2025-08-26 00:13:16'),
	(2408307, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.985622, 29.025840, _binary 0x000000000101000000bbed42739d063d402ddd13da287e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:13:47","ind":0,"enl":"40.9856217","boy":"029.025840","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43246.7,"yon":223,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 10:13:47"}', '2025-08-26 00:13:47', '2025-08-26 00:13:50'),
	(2408308, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"10:14:39","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":278,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:14:39"}', '2025-08-26 00:14:39', '2025-08-26 00:14:41'),
	(2408309, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.998778, 29.075501, _binary 0x000000000101000000b7d0950854133d402c3aa3f7d77f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:15:18","ind":0,"enl":"40.9987783","boy":"029.075501","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94780.7,"yon":15,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 10:15:18"}', '2025-08-26 00:15:18', '2025-08-26 00:15:21'),
	(2408310, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.985038, 29.026506, _binary 0x000000000101000000d525e318c9063d405ae729bc157e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:15:51","ind":0,"enl":"40.9850383","boy":"029.026506","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":5.3893200000000006,"mes":43246.9,"yon":7,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:15:51"}', '2025-08-26 00:15:51', '2025-08-26 00:15:54'),
	(2408311, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.002258, 29.078133, _binary 0x00000000010100000006bd378600143d408152feff49804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:16:50","ind":0,"enl":"41.0022583","boy":"029.078133","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":30.280200000000004,"mes":94781.2,"yon":330,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:16:50"}', '2025-08-26 00:16:50', '2025-08-26 00:16:53'),
	(2408312, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.987238, 29.026926, _binary 0x0000000001010000007f69519fe4063d40e8ed19d35d7e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:17:56","ind":0,"enl":"40.9872383","boy":"029.026926","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":17.2236,"mes":43247.3,"yon":21,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:17:56"}', '2025-08-26 00:17:56', '2025-08-26 00:17:59'),
	(2408313, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.005967, 29.076363, _binary 0x000000000101000000dc9f8b868c133d40baae4e84c3804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:18:07","ind":0,"enl":"41.0059667","boy":"029.076363","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":28.243000000000002,"mes":94781.8,"yon":66,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:18:07"}', '2025-08-26 00:18:07', '2025-08-26 00:18:10'),
	(2408314, '178.245.95.200:52240', '86243005630594516', 40.993478, 29.052406, _binary 0x0000000001010000003b1dc87a6a0d3d4091e4034c2a7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"10:18:13","ind":4,"enl":"40.9934783","boy":"029.052406","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":34,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:18:13"}', '2025-08-26 00:18:13', '2025-08-26 00:18:15'),
	(2408315, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.007890, 29.081620, _binary 0x00000000010100000014b35e0ce5143d4094fb1d8a02814440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:18:56","ind":0,"enl":"41.0078900","boy":"029.081620","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":67.43132,"mes":94782.2,"yon":59,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:18:56"}', '2025-08-26 00:18:56', '2025-08-26 00:18:59'),
	(2408316, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.009262, 29.087368, _binary 0x00000000010100000089b7cebf5d163d407d4dc57c2f814440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:19:29","ind":0,"enl":"41.0092617","boy":"029.087368","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":70.32044,"mes":94782.7,"yon":86,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:19:29"}', '2025-08-26 00:19:29', '2025-08-26 00:19:32'),
	(2408317, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.008437, 29.093655, _binary 0x0000000001010000005c1b2ac6f9173d40074b2b7414814440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:19:59","ind":0,"enl":"41.0084367","boy":"029.093655","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":40.48472,"mes":94783.3,"yon":120,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:19:59"}', '2025-08-26 00:19:59', '2025-08-26 00:20:01'),
	(2408318, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.986158, 29.024271, _binary 0x000000000101000000c03dcf9f36063d40e896676f3a7e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:20:00","ind":0,"enl":"40.9861583","boy":"029.024271","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":15.72348,"mes":43247.7,"yon":298,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:20:00"}', '2025-08-26 00:20:00', '2025-08-26 00:20:02'),
	(2408319, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.006193, 29.098753, _binary 0x000000000101000000c36169e047193d40277a2af1ca804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:20:42","ind":0,"enl":"41.0061933","boy":"029.098753","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":51.83748,"mes":94783.7,"yon":130,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:20:42"}', '2025-08-26 00:20:42', '2025-08-26 00:20:46'),
	(2408320, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.002800, 29.103136, _binary 0x0000000001010000004e0af31e671a3d40e3361ac05b804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:21:10","ind":0,"enl":"41.0028000","boy":"029.103136","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":70.1908,"mes":94784.3,"yon":137,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:21:10"}', '2025-08-26 00:21:10', '2025-08-26 00:21:13'),
	(2408321, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.999468, 29.107498, _binary 0x000000000101000000aa622afd841b3d40c1f1c693ee7f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:21:36","ind":0,"enl":"40.9994683","boy":"029.107498","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":75.48752,"mes":94784.8,"yon":132,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:21:36"}', '2025-08-26 00:21:36', '2025-08-26 00:21:39'),
	(2408322, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.985835, 29.023186, _binary 0x0000000001010000009db98784ef053d4047205ed72f7e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:22:04","ind":0,"enl":"40.9858350","boy":"029.023186","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":18.3348,"mes":43247.9,"yon":120,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:22:04"}', '2025-08-26 00:22:04', '2025-08-26 00:22:07'),
	(2408323, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.996738, 29.112495, _binary 0x000000000101000000a9f6e978cc1c3d40d795e01e957f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:22:04","ind":0,"enl":"40.9967383","boy":"029.112495","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":61.041920000000005,"mes":94785.2,"yon":121,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:22:04"}', '2025-08-26 00:22:04', '2025-08-26 00:22:07'),
	(2408324, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.994117, 29.117111, _binary 0x0000000001010000007a008bfcfa1d3d4027744d373f7f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:22:36","ind":0,"enl":"40.9941167","boy":"029.117111","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":55.467400000000005,"mes":94785.8,"yon":62,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:22:36"}', '2025-08-26 00:22:36', '2025-08-26 00:22:38'),
	(2408325, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.995645, 29.122853, _binary 0x0000000001010000002a37514b731f3d4085b69c4b717f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:23:04","ind":0,"enl":"40.9956450","boy":"029.122853","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":70.39452,"mes":94786.3,"yon":90,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:23:04"}', '2025-08-26 00:23:04', '2025-08-26 00:23:08'),
	(2408326, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.996148, 29.129106, _binary 0x000000000101000000a6b73f170d213d40a63b99c9817f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:23:31","ind":0,"enl":"40.9961483","boy":"029.129106","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":55.15256000000001,"mes":94786.9,"yon":69,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:23:31"}', '2025-08-26 00:23:31', '2025-08-26 00:23:34'),
	(2408327, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"26.08.2025","sat":"10:24:06","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":197,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:24:06"}', '2025-08-26 00:24:06', '2025-08-26 00:24:09'),
	(2408328, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.986557, 29.025550, _binary 0x000000000101000000ad69de718a063d4029136d7d477e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:24:08","ind":0,"enl":"40.9865567","boy":"029.025550","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43248.3,"yon":10,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 10:24:08"}', '2025-08-26 00:24:08', '2025-08-26 00:24:11'),
	(2408329, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"26.08.2025","sat":"10:24:12","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":156,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:24:12"}', '2025-08-26 00:24:12', '2025-08-26 00:24:14'),
	(2408330, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.992903, 29.127120, _binary 0x000000000101000000e3aab2ef8a203d4095cb9074177f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:24:20","ind":0,"enl":"40.9929033","boy":"029.127120","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":31.798840000000006,"mes":94787.3,"yon":222,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:24:20"}', '2025-08-26 00:24:20', '2025-08-26 00:24:22'),
	(2408331, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.992293, 29.125495, _binary 0x000000000101000000c0cfb87020203d401cc58377037f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:26:04","ind":0,"enl":"40.9922933","boy":"029.125495","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":15.76052,"mes":94787.8,"yon":268,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:26:04"}', '2025-08-26 00:26:04', '2025-08-26 00:26:07'),
	(2408332, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.986532, 29.023213, _binary 0x00000000010100000090d78349f1053d40d0fbb5ab467e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:26:13","ind":0,"enl":"40.9865317","boy":"029.023213","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":12.186160000000001,"mes":43248.6,"yon":317,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:26:13"}', '2025-08-26 00:26:13', '2025-08-26 00:26:15'),
	(2408333, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"26.08.2025","sat":"10:26:23","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":46,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:26:23"}', '2025-08-26 00:26:23', '2025-08-26 00:26:26'),
	(2408334, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.992270, 29.122901, _binary 0x0000000001010000004ca59f70761f3d40a5660fb4027f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:26:47","ind":0,"enl":"40.9922700","boy":"029.122901","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94788,"yon":264,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:26:47"}', '2025-08-26 00:26:47', '2025-08-26 00:26:54'),
	(2408335, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.992248, 29.122853, _binary 0x0000000001010000002a37514b731f3d407c0107fe017f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:26:49","ind":0,"enl":"40.9922483","boy":"029.122853","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94788,"yon":264,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 10:26:49"}', '2025-08-26 00:26:49', '2025-08-26 00:26:54'),
	(2408336, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.992248, 29.122856, _binary 0x0000000001010000000c1ea67d731f3d407c0107fe017f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:26:51","ind":0,"enl":"40.9922483","boy":"029.122856","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94788,"yon":264,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:26:51"}', '2025-08-26 00:26:51', '2025-08-26 00:26:55'),
	(2408337, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.988457, 29.023031, _binary 0x0000000001010000004fcb0f5ce5053d408c01c8bf857e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:27:39","ind":0,"enl":"40.9884567","boy":"029.023031","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":19.00152,"mes":43248.8,"yon":41,"A":"5","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:27:39"}', '2025-08-26 00:27:39', '2025-08-26 00:27:40'),
	(2408338, '31.143.21.53:17428', '44fe033664dac2621', 40.937120, 29.133683, _binary 0x000000000101000000fb07910c39223d40b936548cf3774440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"10:28:08","ind":0,"enl":"40.9371200","boy":"029.133683","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74659.2,"yon":132,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:28:08"}', '2025-08-26 00:28:08', '2025-08-26 00:28:10'),
	(2408339, '178.245.95.200:52240', '86243005630594516', 40.996182, 29.053735, _binary 0x0000000001010000008ba6b393c10d3d40d52fc7e1827f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"10:28:13","ind":0,"enl":"40.9961817","boy":"029.053735","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":80,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:28:13"}', '2025-08-26 00:28:13', '2025-08-26 00:28:15'),
	(2408340, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.987020, 29.021625, _binary 0x000000000101000000a8c64b3789053d40bc3fdeab567e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:29:42","ind":0,"enl":"40.9870200","boy":"029.021625","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":26.2984,"mes":43249.4,"yon":174,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:29:42"}', '2025-08-26 00:29:42', '2025-08-26 00:29:44'),
	(2408341, '5.27.202.142:9550', 'a1a58402fabc488f0', 40.997405, 29.074666, _binary 0x000000000101000000861f9c4f1d133d40f6ee8ff7aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"10:29:46","ind":0,"enl":"40.9974050","boy":"029.074666","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43117.8,"yon":356,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:29:46"}', '2025-08-26 00:29:46', '2025-08-26 00:29:48'),
	(2408342, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"10:30:04","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":239,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:30:04"}', '2025-08-26 00:30:04', '2025-08-26 00:30:05'),
	(2408343, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.985457, 29.024168, _binary 0x000000000101000000179cc1df2f063d40e20ff571237e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:30:42","ind":0,"enl":"40.9854567","boy":"029.024168","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":10.241560000000002,"mes":43249.6,"yon":122,"A":"5","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:30:42"}', '2025-08-26 00:30:42', '2025-08-26 00:30:44'),
	(2408344, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.984447, 29.026833, _binary 0x0000000001010000001d740987de063d40db937659027e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:32:45","ind":0,"enl":"40.9844467","boy":"029.026833","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43249.9,"yon":82,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 10:32:45"}', '2025-08-26 00:32:45', '2025-08-26 00:32:48'),
	(2408345, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.992250, 29.122856, _binary 0x0000000001010000000c1ea67d731f3d405eba490c027f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:32:52","ind":0,"enl":"40.9922500","boy":"029.122856","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94788,"yon":80,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 10:32:52"}', '2025-08-26 00:32:52', '2025-08-26 00:32:55'),
	(2408346, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.993928, 29.120980, _binary 0x0000000001010000005778978bf81e3d40d188e30a397f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:34:48","ind":4,"enl":"40.9939283","boy":"029.120980","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":26.81696,"mes":94788.5,"yon":37,"A":"13","Sensor":"","drx":1,"ignition":1,"datetime":"2025-08-26 10:34:48"}', '2025-08-26 00:34:48', '2025-08-26 00:34:50'),
	(2408347, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.983622, 29.030833, _binary 0x00000000010100000038a3e6abe4073d406691dc50e77d4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:34:49","ind":0,"enl":"40.9836217","boy":"029.030833","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":5.75972,"mes":43250.3,"yon":11,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:34:49"}', '2025-08-26 00:34:49', '2025-08-26 00:34:52'),
	(2408348, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.984710, 29.027188, _binary 0x000000000101000000f9d7f2caf5063d40a7052ffa0a7e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:36:53","ind":0,"enl":"40.9847100","boy":"029.027188","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":18.01996,"mes":43250.7,"yon":298,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:36:53"}', '2025-08-26 00:36:53', '2025-08-26 00:36:56'),
	(2408349, '178.245.95.200:52240', '86243005630594516', 40.994947, 29.052115, _binary 0x0000000001010000008ca19c68570d3d40aee1d8695a7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"10:38:13","ind":0,"enl":"40.9949467","boy":"029.052115","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":96,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:38:13"}', '2025-08-26 00:38:13', '2025-08-26 00:38:15'),
	(2408350, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.986935, 29.026818, _binary 0x000000000101000000b2f1608bdd063d408e23d6e2537e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:38:58","ind":0,"enl":"40.9869350","boy":"029.026818","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":13.53812,"mes":43251.1,"yon":198,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:38:58"}', '2025-08-26 00:38:58', '2025-08-26 00:39:00'),
	(2408351, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.993928, 29.120980, _binary 0x0000000001010000005778978bf81e3d40d188e30a397f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:39:34","ind":4,"enl":"40.9939283","boy":"029.120980","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94788.5,"yon":37,"A":"21","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:39:34"}', '2025-08-26 00:39:34', '2025-08-26 00:39:36'),
	(2408352, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.993928, 29.120980, _binary 0x0000000001010000005778978bf81e3d40d188e30a397f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"10:40:16","ind":4,"enl":"40.9939283","boy":"029.120980","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94788.5,"yon":37,"A":"4","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:40:16"}', '2025-08-26 00:40:16', '2025-08-26 00:40:18'),
	(2408353, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997470, 29.074741, _binary 0x0000000001010000009babe63922133d40dd5ed218ad7f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"26.08.2025","sat":"10:40:58","ind":0,"enl":"40.9974700","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":306,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:40:58"}', '2025-08-26 00:40:58', '2025-08-26 00:41:01'),
	(2408354, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.984758, 29.027663, _binary 0x0000000001010000002b4f20ec14073d40777b5a8f0c7e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:41:02","ind":0,"enl":"40.9847583","boy":"029.027663","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43251.4,"yon":185,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 10:41:02"}', '2025-08-26 00:41:02', '2025-08-26 00:41:05'),
	(2408355, '176.238.10.16:26970', '350612079185623', 41.014947, 29.054153, _binary 0x00000000010100000071789cfddc0d3d40dc172bc5e9814440, '0', '{"device_model": "Teltonika", "p": "1", "did": "350612079185623", "trh": "2025-08-26", "sat": "10:40:50", "ind": 0, "enl": "41.0149466", "boy": "29.0541533", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 27279.236, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12616, "battery_voltage": 4057, "battery_current": 0, "record_timestamp": "2025-08-26 10:40:50", "codec_id": 8}', '2025-08-26 00:40:50', '2025-08-26 00:43:02'),
	(2408356, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.985320, 29.024981, _binary 0x0000000001010000007905a22765063d40200c3cf71e7e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:43:06","ind":0,"enl":"40.9853200","boy":"029.024981","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43251.7,"yon":202,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 10:43:06"}', '2025-08-26 00:43:06', '2025-08-26 00:43:10'),
	(2408357, '31.143.219.198:35638', '86284304533376212', 41.001303, 28.827633, _binary 0x00000000010100000022179cc1dfd33c403d70dfb42a804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"10:44:00","ind":0,"enl":"41.0013033","boy":"028.827633","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10967.9,"yon":309,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:44:00"}', '2025-08-26 00:44:00', '2025-08-26 00:44:03'),
	(2408358, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.985320, 29.024981, _binary 0x0000000001010000007905a22765063d40200c3cf71e7e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:45:10","ind":0,"enl":"40.9853200","boy":"029.024981","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43251.7,"yon":202,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 10:45:10"}', '2025-08-26 00:45:10', '2025-08-26 00:45:13'),
	(2408359, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"10:45:29","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":12,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:45:29"}', '2025-08-26 00:45:29', '2025-08-26 00:45:30'),
	(2408360, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.986303, 29.025700, _binary 0x000000000101000000d881734694063d40ecb7c02f3f7e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:47:15","ind":0,"enl":"40.9863033","boy":"029.025700","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43252.1,"yon":300,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 10:47:15"}', '2025-08-26 00:47:15', '2025-08-26 00:47:17'),
	(2408361, '178.245.95.200:52240', '86243005630594516', 40.997028, 29.050695, _binary 0x0000000001010000001b12f758fa0c3d40ded7929f9e7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"10:48:13","ind":4,"enl":"40.9970283","boy":"029.050695","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":182,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:48:13"}', '2025-08-26 00:48:13', '2025-08-26 00:48:15'),
	(2408362, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.986753, 29.023431, _binary 0x0000000001010000006bb6f292ff053d402b5ca0ee4d7e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:49:19","ind":0,"enl":"40.9867533","boy":"029.023431","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":18.83484,"mes":43252.4,"yon":213,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:49:19"}', '2025-08-26 00:49:19', '2025-08-26 00:49:22'),
	(2408363, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.984790, 29.026346, _binary 0x0000000001010000006361889cbe063d40c3b645990d7e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:51:23","ind":0,"enl":"40.9847900","boy":"029.026346","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":14.519680000000001,"mes":43252.9,"yon":23,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:51:23"}', '2025-08-26 00:51:23', '2025-08-26 00:51:27'),
	(2408364, '31.143.219.198:35638', '86284304533376212', 41.001303, 28.827633, _binary 0x00000000010100000022179cc1dfd33c403d70dfb42a804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"10:52:25","ind":0,"enl":"41.0013033","boy":"028.827633","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10967.9,"yon":159,"A":"4","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:52:25"}', '2025-08-26 00:52:25', '2025-08-26 00:52:27'),
	(2408365, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.986352, 29.025686, _binary 0x0000000001010000000ef7915b93063d4050edc2c5407e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:53:16","ind":0,"enl":"40.9863517","boy":"029.025686","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43253.1,"yon":3,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:53:16"}', '2025-08-26 00:53:16', '2025-08-26 00:53:18'),
	(2408366, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.986433, 29.025681, _binary 0x000000000101000000ea20af0793063d40ba974572437e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:53:35","ind":0,"enl":"40.9864333","boy":"029.025681","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43253.1,"yon":3,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 10:53:35"}', '2025-08-26 00:53:35', '2025-08-26 00:53:37'),
	(2408367, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"26.08.2025","sat":"10:55:08","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":278,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:55:08"}', '2025-08-26 00:55:08', '2025-08-26 00:55:11'),
	(2408368, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"26.08.2025","sat":"10:55:14","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":128,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:55:14"}', '2025-08-26 00:55:14', '2025-08-26 00:55:16'),
	(2408369, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.985360, 29.025053, _binary 0x000000000101000000acaa97df69063d40ae64c746207e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:55:38","ind":0,"enl":"40.9853600","boy":"029.025053","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":13.07512,"mes":43253.3,"yon":196,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 10:55:38"}', '2025-08-26 00:55:38', '2025-08-26 00:55:40'),
	(2408370, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.985213, 29.024936, _binary 0x000000000101000000397ea83462063d40c88a2b781b7e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"10:55:56","ind":0,"enl":"40.9852133","boy":"029.024936","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43253.3,"yon":187,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:55:56"}', '2025-08-26 00:55:56', '2025-08-26 00:55:58'),
	(2408371, '178.245.95.200:52240', '86243005630594516', 40.996147, 29.051370, _binary 0x000000000101000000dafe9595260d3d4058422dbc817f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"10:55:58","ind":4,"enl":"40.9961467","boy":"029.051370","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":117,"A":"21","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:55:58"}', '2025-08-26 00:55:58', '2025-08-26 00:55:59'),
	(2408372, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"26.08.2025","sat":"10:57:26","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":351,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:57:26"}', '2025-08-26 00:57:26', '2025-08-26 00:57:29'),
	(2408373, '31.143.21.53:17428', '44fe033664dac2621', 40.937120, 29.133683, _binary 0x000000000101000000fb07910c39223d40b936548cf3774440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"10:59:15","ind":0,"enl":"40.9371200","boy":"029.133683","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74659.2,"yon":305,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 10:59:15"}', '2025-08-26 00:59:15', '2025-08-26 00:59:16'),
	(2408374, '5.27.202.142:9550', 'a1a58402fabc488f0', 40.996227, 29.075345, _binary 0x000000000101000000c8ea56cf49133d4075f3435b847f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"11:00:48","ind":0,"enl":"40.9962267","boy":"029.075345","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43117.8,"yon":335,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:00:48"}', '2025-08-26 01:00:48', '2025-08-26 01:00:49'),
	(2408375, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"11:00:53","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":318,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:00:53"}', '2025-08-26 01:00:53', '2025-08-26 01:00:55'),
	(2408376, '178.245.95.200:52240', '86243005630594516', 40.997018, 29.050698, _binary 0x000000000101000000fdf84b8bfa0c3d40bb01b04b9e7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"11:05:58","ind":0,"enl":"40.9970183","boy":"029.050698","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":195,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:05:58"}', '2025-08-26 01:05:58', '2025-08-26 01:05:59'),
	(2408377, '5.24.49.75:55434', '353201357563383', 40.997282, 29.048400, _binary 0x0000000001010000005c2041f1630c3d40877368eca67f4440, '0', '{"device_model": "Teltonika", "p": "1", "did": "353201357563383", "trh": "2025-08-26", "sat": "11:07:28", "ind": 0, "enl": "40.9972816", "boy": "29.0484", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 3.137, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12001, "battery_voltage": 0, "battery_current": 0, "record_timestamp": "2025-08-26 11:07:28", "codec_id": 8}', '2025-08-26 01:07:28', '2025-08-26 01:08:01'),
	(2408378, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.993928, 29.120980, _binary 0x0000000001010000005778978bf81e3d40d188e30a397f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"11:11:03","ind":4,"enl":"40.9939283","boy":"029.120980","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94788.5,"yon":37,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:11:03"}', '2025-08-26 01:11:03', '2025-08-26 01:11:05'),
	(2408379, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997470, 29.074741, _binary 0x0000000001010000009babe63922133d40dd5ed218ad7f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"26.08.2025","sat":"11:11:59","ind":0,"enl":"40.9974700","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":8,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:11:59"}', '2025-08-26 01:11:59', '2025-08-26 01:12:02'),
	(2408380, '178.245.95.200:52240', '86243005630594516', 40.996865, 29.049800, _binary 0x0000000001010000003f575bb1bf0c3d4076c3b645997f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"11:15:58","ind":0,"enl":"40.9968650","boy":"029.049800","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":48,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:15:58"}', '2025-08-26 01:15:58', '2025-08-26 01:16:00'),
	(2408381, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"11:16:18","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":355,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:16:18"}', '2025-08-26 01:16:18', '2025-08-26 01:16:19'),
	(2408382, '31.143.219.198:35638', '86284304533376212', 41.001303, 28.827633, _binary 0x00000000010100000022179cc1dfd33c403d70dfb42a804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"11:23:24","ind":0,"enl":"41.0013033","boy":"028.827633","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10967.9,"yon":266,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:23:24"}', '2025-08-26 01:23:24', '2025-08-26 01:23:27'),
	(2408383, '178.245.95.200:52240', '86243005630594516', 40.996215, 29.049870, _binary 0x000000000101000000300dc347c40c3d406f641ef9837f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"11:25:58","ind":4,"enl":"40.9962150","boy":"029.049870","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":275,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:25:58"}', '2025-08-26 01:25:58', '2025-08-26 01:26:00'),
	(2408384, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"26.08.2025","sat":"11:26:10","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":194,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:26:10"}', '2025-08-26 01:26:10', '2025-08-26 01:26:12'),
	(2408385, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"26.08.2025","sat":"11:26:15","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":6,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:26:15"}', '2025-08-26 01:26:15', '2025-08-26 01:26:17'),
	(2408386, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.985128, 29.024873, _binary 0x000000000101000000ac8db1135e063d409a6e23af187e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"11:26:57","ind":0,"enl":"40.9851283","boy":"029.024873","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43253.3,"yon":315,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:26:57"}', '2025-08-26 01:26:57', '2025-08-26 01:26:59'),
	(2408387, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"26.08.2025","sat":"11:28:29","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":165,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:28:29"}', '2025-08-26 01:28:29', '2025-08-26 01:28:32'),
	(2408388, '31.143.21.53:17428', '44fe033664dac2621', 40.937120, 29.133683, _binary 0x000000000101000000fb07910c39223d40b936548cf3774440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"11:30:22","ind":0,"enl":"40.9371200","boy":"029.133683","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74659.2,"yon":96,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:30:22"}', '2025-08-26 01:30:22', '2025-08-26 01:30:23'),
	(2408389, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"11:31:43","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":50,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:31:43"}', '2025-08-26 01:31:43', '2025-08-26 01:31:44'),
	(2408390, '178.245.95.200:52240', '86243005630594516', 40.996215, 29.049870, _binary 0x000000000101000000300dc347c40c3d406f641ef9837f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"11:31:43","ind":4,"enl":"40.9962150","boy":"029.049870","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":224,"A":"21","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:31:43"}', '2025-08-26 01:31:43', '2025-08-26 01:31:44'),
	(2408391, '5.27.202.142:9550', 'a1a58402fabc488f0', 40.997832, 29.076655, _binary 0x0000000001010000002b137ea99f133d40bf34fbf2b87f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"11:31:50","ind":0,"enl":"40.9978317","boy":"029.076655","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43117.8,"yon":269,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:31:50"}', '2025-08-26 01:31:50', '2025-08-26 01:31:51'),
	(2408392, '5.27.202.142:9550', 'a1a58402fabc488f0', 40.996903, 29.073140, _binary 0x0000000001010000008907944db9123d402263ff869a7f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"11:34:02","ind":0,"enl":"40.9969033","boy":"029.073140","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43117.8,"yon":7,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 11:34:02"}', '2025-08-26 01:34:02', '2025-08-26 01:34:03'),
	(2408393, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.985128, 29.024873, _binary 0x000000000101000000ac8db1135e063d409a6e23af187e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"11:35:03","ind":0,"enl":"40.9851283","boy":"029.024873","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43253.3,"yon":39,"A":"4","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:35:03"}', '2025-08-26 01:35:03', '2025-08-26 01:35:05'),
	(2408394, '5.27.202.142:9550', 'a1a58402fabc488f0', 40.996750, 29.077548, _binary 0x000000000101000000c6de8b2fda133d40dd240681957f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"11:36:01","ind":0,"enl":"40.9967500","boy":"029.077548","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43118.1,"yon":339,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:36:01"}', '2025-08-26 01:36:01', '2025-08-26 01:36:02'),
	(2408395, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.993928, 29.120980, _binary 0x0000000001010000005778978bf81e3d40d188e30a397f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"11:39:33","ind":4,"enl":"40.9939283","boy":"029.120980","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94788.5,"yon":37,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 11:39:33"}', '2025-08-26 01:39:33', '2025-08-26 01:39:35'),
	(2408396, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.993928, 29.120980, _binary 0x0000000001010000005778978bf81e3d40d188e30a397f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"11:39:35","ind":4,"enl":"40.9939283","boy":"029.120980","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94788.5,"yon":37,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:39:35"}', '2025-08-26 01:39:35', '2025-08-26 01:39:36'),
	(2408397, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.993928, 29.120980, _binary 0x0000000001010000005778978bf81e3d40d188e30a397f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"11:41:08","ind":4,"enl":"40.9939283","boy":"029.120980","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94788.5,"yon":37,"A":"21","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:41:08"}', '2025-08-26 01:41:08', '2025-08-26 01:41:11'),
	(2408398, '178.245.95.200:52240', '86243005630594516', 40.997318, 29.053873, _binary 0x0000000001010000002d23f59eca0d3d40e6194520a87f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"11:41:43","ind":0,"enl":"40.9973183","boy":"029.053873","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":195,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:41:43"}', '2025-08-26 01:41:43', '2025-08-26 01:41:44'),
	(2408399, '178.243.207.214:47270', '350612079185623', 41.014947, 29.054153, _binary 0x00000000010100000071789cfddc0d3d40dc172bc5e9814440, '0', '{"device_model": "Teltonika", "p": "1", "did": "350612079185623", "trh": "2025-08-26", "sat": "11:40:56", "ind": 0, "enl": "41.0149466", "boy": "29.0541533", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 27279.236, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12616, "battery_voltage": 4057, "battery_current": 0, "record_timestamp": "2025-08-26 11:40:56", "codec_id": 8}', '2025-08-26 01:40:56', '2025-08-26 01:43:02'),
	(2408400, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997470, 29.074741, _binary 0x0000000001010000009babe63922133d40dd5ed218ad7f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"26.08.2025","sat":"11:43:00","ind":0,"enl":"40.9974700","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":210,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:43:00"}', '2025-08-26 01:43:00', '2025-08-26 01:43:03'),
	(2408401, '5.27.202.142:9550', 'a1a58402fabc488f0', 40.997108, 29.078080, _binary 0x000000000101000000c078060dfd133d40fb88a93ea17f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"11:44:20","ind":0,"enl":"40.9971083","boy":"029.078080","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43118.1,"yon":282,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 11:44:20"}', '2025-08-26 01:44:20', '2025-08-26 01:44:22'),
	(2408402, '5.27.202.142:9550', 'a1a58402fabc488f0', 40.998018, 29.076221, _binary 0x000000000101000000b7442e3883133d409ea74b10bf7f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"11:45:23","ind":0,"enl":"40.9980183","boy":"029.076221","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":5.98196,"mes":43118.5,"yon":316,"A":"6","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 11:45:23"}', '2025-08-26 01:45:23', '2025-08-26 01:45:25'),
	(2408403, '5.27.202.142:9550', 'a1a58402fabc488f0', 40.997092, 29.075816, _binary 0x000000000101000000778368ad68133d40784e69b3a07f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"11:45:59","ind":0,"enl":"40.9970917","boy":"029.075816","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":8.55624,"mes":43118.6,"yon":230,"A":"6","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 11:45:59"}', '2025-08-26 01:45:59', '2025-08-26 01:46:00'),
	(2408404, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"11:47:08","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":253,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:47:08"}', '2025-08-26 01:47:08', '2025-08-26 01:47:09'),
	(2408405, '5.27.202.142:9550', 'a1a58402fabc488f0', 40.997505, 29.074675, _binary 0x0000000001010000002cd49ae61d133d40594c6c3eae7f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"11:47:11","ind":0,"enl":"40.9975050","boy":"029.074675","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":11.889840000000001,"mes":43118.8,"yon":21,"A":"5","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 11:47:11"}', '2025-08-26 01:47:11', '2025-08-26 01:47:12'),
	(2408406, '5.27.202.142:9550', 'a1a58402fabc488f0', 40.997633, 29.074661, _binary 0x0000000001010000006249b9fb1c133d404573ae72b27f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"11:47:51","ind":0,"enl":"40.9976333","boy":"029.074661","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":2.24092,"mes":43118.8,"yon":299,"A":"13","Sensor":"","drx":1,"ignition":1,"datetime":"2025-08-26 11:47:51"}', '2025-08-26 01:47:51', '2025-08-26 01:47:53'),
	(2408407, '178.245.95.200:52240', '86243005630594516', 40.996593, 29.055286, _binary 0x00000000010100000039ed2939270e3d40d474875e907f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"11:51:43","ind":4,"enl":"40.9965933","boy":"029.055286","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":118,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:51:43"}', '2025-08-26 01:51:43', '2025-08-26 01:51:44'),
	(2408408, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.985128, 29.024873, _binary 0x000000000101000000ac8db1135e063d409a6e23af187e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"11:51:52","ind":0,"enl":"40.9851283","boy":"029.024873","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43253.3,"yon":236,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 11:51:52"}', '2025-08-26 01:51:52', '2025-08-26 01:51:53'),
	(2408409, '178.245.95.200:52240', '86243005630594516', 40.996593, 29.055286, _binary 0x00000000010100000039ed2939270e3d40d474875e907f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"11:53:13","ind":4,"enl":"40.9965933","boy":"029.055286","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":118,"A":"21","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:53:13"}', '2025-08-26 01:53:13', '2025-08-26 01:53:14'),
	(2408410, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.985008, 29.025018, _binary 0x000000000101000000b3cf639467063d40ef6481c0147e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"11:53:55","ind":0,"enl":"40.9850083","boy":"029.025018","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43253.3,"yon":67,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 11:53:55"}', '2025-08-26 01:53:55', '2025-08-26 01:53:58'),
	(2408411, '31.143.219.198:35638', '86284304533376212', 41.001303, 28.827633, _binary 0x00000000010100000022179cc1dfd33c403d70dfb42a804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"11:54:24","ind":0,"enl":"41.0013033","boy":"028.827633","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10967.9,"yon":97,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:54:24"}', '2025-08-26 01:54:24', '2025-08-26 01:54:27'),
	(2408412, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.984123, 29.027363, _binary 0x000000000101000000d61ef64201073d40a55d96c0f77d4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"11:55:59","ind":0,"enl":"40.9841233","boy":"029.027363","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":17.9644,"mes":43253.7,"yon":152,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 11:55:59"}', '2025-08-26 01:55:59', '2025-08-26 01:56:02'),
	(2408413, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"26.08.2025","sat":"11:57:11","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":235,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:57:11"}', '2025-08-26 01:57:11', '2025-08-26 01:57:14'),
	(2408414, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"26.08.2025","sat":"11:57:16","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":108,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:57:16"}', '2025-08-26 01:57:16', '2025-08-26 01:57:19'),
	(2408415, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.983245, 29.033100, _binary 0x000000000101000000637fd93d79083d404e7adff8da7d4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"11:57:47","ind":0,"enl":"40.9832450","boy":"029.033100","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":10.35268,"mes":43254.2,"yon":26,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 11:57:47"}', '2025-08-26 01:57:47', '2025-08-26 01:57:50'),
	(2408416, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.987110, 29.034546, _binary 0x0000000001010000002635b401d8083d40fcc6d79e597e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"11:59:04","ind":0,"enl":"40.9871100","boy":"029.034546","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":37.706720000000004,"mes":43254.6,"yon":83,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 11:59:04"}', '2025-08-26 01:59:04', '2025-08-26 01:59:06'),
	(2408417, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"26.08.2025","sat":"11:59:33","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":332,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 11:59:33"}', '2025-08-26 01:59:33', '2025-08-26 01:59:35'),
	(2408418, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.984410, 29.038843, _binary 0x000000000101000000b4ad669df1093d407ced9925017e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:00:17","ind":0,"enl":"40.9844100","boy":"029.038843","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":36.42884000000001,"mes":43255.2,"yon":133,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:00:17"}', '2025-08-26 02:00:17', '2025-08-26 02:00:20'),
	(2408419, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.993928, 29.120980, _binary 0x0000000001010000005778978bf81e3d40d188e30a397f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"12:00:46","ind":4,"enl":"40.9939283","boy":"029.120980","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94788.5,"yon":37,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 12:00:46"}', '2025-08-26 02:00:46', '2025-08-26 02:00:51'),
	(2408420, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.993928, 29.120980, _binary 0x0000000001010000005778978bf81e3d40d188e30a397f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"12:00:51","ind":4,"enl":"40.9939283","boy":"029.120980","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94788.5,"yon":37,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:00:51"}', '2025-08-26 02:00:51', '2025-08-26 02:00:53'),
	(2408421, '31.143.21.53:17428', '44fe033664dac2621', 40.937120, 29.133683, _binary 0x000000000101000000fb07910c39223d40b936548cf3774440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"12:01:29","ind":0,"enl":"40.9371200","boy":"029.133683","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74659.2,"yon":98,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:01:29"}', '2025-08-26 02:01:29', '2025-08-26 02:01:30'),
	(2408422, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.982450, 29.040648, _binary 0x000000000101000000d7a546e8670a3d4044faedebc07d4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:02:21","ind":0,"enl":"40.9824500","boy":"029.040648","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":34.6324,"mes":43255.4,"yon":155,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:02:21"}', '2025-08-26 02:02:21', '2025-08-26 02:02:25'),
	(2408423, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"12:02:33","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":130,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:02:33"}', '2025-08-26 02:02:33', '2025-08-26 02:02:34'),
	(2408424, '178.245.95.200:52240', '86243005630594516', 40.996593, 29.055286, _binary 0x00000000010100000039ed2939270e3d40d474875e907f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"12:03:13","ind":4,"enl":"40.9965933","boy":"029.055286","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":118,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:03:13"}', '2025-08-26 02:03:13', '2025-08-26 02:03:15'),
	(2408425, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.978017, 29.041748, _binary 0x00000000010100000064ac36ffaf0a3d408eb8b6a62f7d4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:03:33","ind":0,"enl":"40.9780167","boy":"029.041748","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":23.74264,"mes":43256,"yon":168,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:03:33"}', '2025-08-26 02:03:33', '2025-08-26 02:03:36'),
	(2408426, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.973692, 29.042005, _binary 0x000000000101000000bb44f5d6c00a3d407ef1fbeda17c4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:04:49","ind":0,"enl":"40.9736917","boy":"029.042005","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":0,"mes":43256.5,"yon":212,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 12:04:49"}', '2025-08-26 02:04:49', '2025-08-26 02:04:51'),
	(2408427, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.971212, 29.042461, _binary 0x000000000101000000ff5a5eb9de0a3d400c7f3caa507c4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:06:53","ind":0,"enl":"40.9712117","boy":"029.042461","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43256.8,"yon":35,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:06:53"}', '2025-08-26 02:06:53', '2025-08-26 02:06:55'),
	(2408428, '188.58.85.36:25732', '353201357563383', 40.997282, 29.048400, _binary 0x0000000001010000005c2041f1630c3d40877368eca67f4440, '0', '{"device_model": "Teltonika", "p": "1", "did": "353201357563383", "trh": "2025-08-26", "sat": "12:07:28", "ind": 0, "enl": "40.9972816", "boy": "29.0484", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 3.137, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12001, "battery_voltage": 0, "battery_current": 0, "record_timestamp": "2025-08-26 12:07:28", "codec_id": 8}', '2025-08-26 02:07:28', '2025-08-26 02:09:01'),
	(2408429, '178.245.95.200:52240', '86243005630594516', 40.996593, 29.055286, _binary 0x00000000010100000039ed2939270e3d40d474875e907f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"12:13:14","ind":4,"enl":"40.9965933","boy":"029.055286","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":118,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:13:14"}', '2025-08-26 02:13:14', '2025-08-26 02:13:15'),
	(2408430, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997470, 29.074741, _binary 0x0000000001010000009babe63922133d40dd5ed218ad7f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"26.08.2025","sat":"12:14:01","ind":0,"enl":"40.9974700","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":217,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:14:01"}', '2025-08-26 02:14:01', '2025-08-26 02:14:03'),
	(2408431, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.971238, 29.042493, _binary 0x000000000101000000164f3dd2e00a3d40b38f5f89517c4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:15:46","ind":0,"enl":"40.9712383","boy":"029.042493","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43256.8,"yon":37,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 12:15:46"}', '2025-08-26 02:15:46', '2025-08-26 02:15:48'),
	(2408432, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.993928, 29.120980, _binary 0x0000000001010000005778978bf81e3d40d188e30a397f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"12:16:58","ind":4,"enl":"40.9939283","boy":"029.120980","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94788.5,"yon":37,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 12:16:58"}', '2025-08-26 02:16:58', '2025-08-26 02:17:00'),
	(2408433, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.971207, 29.042565, _binary 0x00000000010100000049f4328ae50a3d40fb134b80507c4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:17:50","ind":0,"enl":"40.9712067","boy":"029.042565","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43256.8,"yon":37,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 12:17:50"}', '2025-08-26 02:17:50', '2025-08-26 02:17:52'),
	(2408434, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"12:17:57","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":71,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:17:57"}', '2025-08-26 02:17:57', '2025-08-26 02:17:58'),
	(2408435, '5.27.202.142:9550', 'a1a58402fabc488f0', 40.997538, 29.075095, _binary 0x000000000101000000d717096d39133d40f480c355af7f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"12:18:55","ind":0,"enl":"40.9975383","boy":"029.075095","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43118.8,"yon":143,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:18:55"}', '2025-08-26 02:18:55', '2025-08-26 02:18:56'),
	(2408436, '5.27.202.142:9550', 'a1a58402fabc488f0', 40.997538, 29.075095, _binary 0x000000000101000000d717096d39133d40f480c355af7f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"12:19:00","ind":0,"enl":"40.9975383","boy":"029.075095","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43118.8,"yon":114,"A":"4","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:19:00"}', '2025-08-26 02:19:00', '2025-08-26 02:19:02'),
	(2408437, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.993928, 29.120980, _binary 0x0000000001010000005778978bf81e3d40d188e30a397f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"12:19:01","ind":4,"enl":"40.9939283","boy":"029.120980","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94788.5,"yon":37,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 12:19:01"}', '2025-08-26 02:19:01', '2025-08-26 02:19:03'),
	(2408438, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.970720, 29.044040, _binary 0x00000000010100000041b79734460b3d405cc98e8d407c4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:19:54","ind":0,"enl":"40.9707200","boy":"029.044040","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":28.0578,"mes":43257,"yon":18,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:19:54"}', '2025-08-26 02:19:54', '2025-08-26 02:19:57'),
	(2408439, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.993928, 29.120980, _binary 0x0000000001010000005778978bf81e3d40d188e30a397f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"12:21:04","ind":4,"enl":"40.9939283","boy":"029.120980","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94788.5,"yon":37,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 12:21:04"}', '2025-08-26 02:21:04', '2025-08-26 02:21:09'),
	(2408440, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.974802, 29.046481, _binary 0x000000000101000000a8e2c62de60b3d40e8ca564dc67c4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:21:47","ind":0,"enl":"40.9748017","boy":"029.046481","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":24.15008,"mes":43257.5,"yon":25,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:21:47"}', '2025-08-26 02:21:47', '2025-08-26 02:21:56'),
	(2408441, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.992768, 29.114790, _binary 0x00000000010100000068e89fe0621d3d40b5801a08137f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"12:22:24","ind":0,"enl":"40.9927683","boy":"029.114790","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":23.7982,"mes":94788.9,"yon":351,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:22:24"}', '2025-08-26 02:22:24', '2025-08-26 02:22:27'),
	(2408442, '178.245.95.200:52240', '86243005630594516', 40.996593, 29.055286, _binary 0x00000000010100000039ed2939270e3d40d474875e907f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"12:23:14","ind":4,"enl":"40.9965933","boy":"029.055286","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":118,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:23:14"}', '2025-08-26 02:23:14', '2025-08-26 02:23:15'),
	(2408443, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.995232, 29.111521, _binary 0x00000000010100000035d1e7a38c1c3d40a3b899c0637f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"12:23:19","ind":0,"enl":"40.9952317","boy":"029.111521","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":30.095000000000002,"mes":94789.4,"yon":10,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:23:19"}', '2025-08-26 02:23:19', '2025-08-26 02:23:22'),
	(2408444, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.976740, 29.047888, _binary 0x000000000101000000f0de5163420c3d40f758fad0057d4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:23:51","ind":0,"enl":"40.9767400","boy":"029.047888","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43257.7,"yon":14,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 12:23:51"}', '2025-08-26 02:23:51', '2025-08-26 02:23:54'),
	(2408445, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.998485, 29.109986, _binary 0x0000000001010000009204e10a281c3d40f645425bce7f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"12:24:21","ind":0,"enl":"40.9984850","boy":"029.109986","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":26.946600000000004,"mes":94790,"yon":16,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:24:21"}', '2025-08-26 02:24:21', '2025-08-26 02:24:23'),
	(2408446, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.001332, 29.105373, _binary 0x000000000101000000a4e194b9f91a3d405bf91ba32b804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"12:25:11","ind":0,"enl":"41.0013317","boy":"029.105373","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":68.98700000000001,"mes":94790.5,"yon":316,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:25:11"}', '2025-08-26 02:25:11', '2025-08-26 02:25:15'),
	(2408447, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.980835, 29.049765, _binary 0x000000000101000000467c2766bd0c3d40d6e253008c7d4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:25:24","ind":0,"enl":"40.9808350","boy":"029.049765","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":24.539,"mes":43258.3,"yon":23,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:25:24"}', '2025-08-26 02:25:24', '2025-08-26 02:25:26'),
	(2408448, '31.143.219.198:35638', '86284304533376212', 41.001303, 28.827633, _binary 0x00000000010100000022179cc1dfd33c403d70dfb42a804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:25:24","ind":0,"enl":"41.0013033","boy":"028.827633","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10967.9,"yon":143,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:25:24"}', '2025-08-26 02:25:24', '2025-08-26 02:25:27'),
	(2408449, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.004875, 29.101033, _binary 0x00000000010100000018d1764cdd193d40b4c876be9f804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"12:25:35","ind":0,"enl":"41.0048750","boy":"029.101033","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":86.65508,"mes":94791,"yon":315,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:25:35"}', '2025-08-26 02:25:35', '2025-08-26 02:25:39'),
	(2408450, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.007940, 29.096236, _binary 0x000000000101000000a7b228eca2183d40452a8c2d04814440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"12:25:57","ind":0,"enl":"41.0079400","boy":"029.096236","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":71.35756,"mes":94791.5,"yon":311,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:25:57"}', '2025-08-26 02:25:57', '2025-08-26 02:26:03'),
	(2408451, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.009662, 29.090743, _binary 0x0000000001010000004757e9ee3a173d400bc336983c814440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"12:26:25","ind":0,"enl":"41.0096617","boy":"029.090743","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":65.24596,"mes":94792.1,"yon":274,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:26:25"}', '2025-08-26 02:26:25', '2025-08-26 02:26:30'),
	(2408452, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.983932, 29.047308, _binary 0x000000000101000000d4d688601c0c3d40b47f5479f17d4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:26:42","ind":0,"enl":"40.9839317","boy":"029.047308","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":31.743280000000002,"mes":43258.8,"yon":25,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:26:42"}', '2025-08-26 02:26:42', '2025-08-26 02:26:45'),
	(2408453, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.009560, 29.084930, _binary 0x0000000001010000000473f4f8bd153d40c5ac174339814440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"12:27:09","ind":0,"enl":"41.0095600","boy":"029.084930","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":51.133720000000004,"mes":94792.5,"yon":256,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:27:09"}', '2025-08-26 02:27:09', '2025-08-26 02:27:12'),
	(2408454, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.007380, 29.081051, _binary 0x000000000101000000df4e22c2bf143d407e52edd3f1804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"12:28:13","ind":0,"enl":"41.0073800","boy":"029.081051","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":11.575000000000001,"mes":94793,"yon":163,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:28:13"}', '2025-08-26 02:28:13', '2025-08-26 02:28:15'),
	(2408455, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"26.08.2025","sat":"12:28:14","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":232,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:28:14"}', '2025-08-26 02:28:14', '2025-08-26 02:28:16'),
	(2408456, '31.143.219.198:35638', '86284304533376212', 41.001303, 28.827633, _binary 0x00000000010100000022179cc1dfd33c403d70dfb42a804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:28:17","ind":0,"enl":"41.0013033","boy":"028.827633","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10967.9,"yon":180,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 12:28:17"}', '2025-08-26 02:28:17', '2025-08-26 02:28:19'),
	(2408457, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"26.08.2025","sat":"12:28:19","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":176,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:28:19"}', '2025-08-26 02:28:19', '2025-08-26 02:28:21'),
	(2408458, '31.143.219.198:35638', '86284304533376212', 41.001270, 28.827696, _binary 0x000000000101000000af0793e2e3d33c40a33b889d29804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:28:21","ind":0,"enl":"41.0012700","boy":"028.827696","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":2.42612,"mes":10967.9,"yon":180,"A":"13","Sensor":"","drx":1,"ignition":1,"datetime":"2025-08-26 12:28:21"}', '2025-08-26 02:28:21', '2025-08-26 02:28:23'),
	(2408459, '31.143.219.198:35638', '86284304533376212', 41.001283, 28.827711, _binary 0x0000000001010000001a8a3bdee4d33c40f6c3190d2a804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:28:22","ind":0,"enl":"41.0012833","boy":"028.827711","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10967.9,"yon":180,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 12:28:22"}', '2025-08-26 02:28:22', '2025-08-26 02:28:24'),
	(2408460, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.987155, 29.045823, _binary 0x00000000010100000094675e0ebb0b3d409c8a54185b7e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:28:35","ind":0,"enl":"40.9871550","boy":"029.045823","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":46.26296,"mes":43259.4,"yon":302,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:28:35"}', '2025-08-26 02:28:35', '2025-08-26 02:28:37'),
	(2408461, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.989900, 29.041018, _binary 0x0000000001010000001e8cd827800a3d40bb270f0bb57e4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:29:26","ind":0,"enl":"40.9899000","boy":"029.041018","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":37.52152,"mes":43259.8,"yon":319,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:29:26"}', '2025-08-26 02:29:26', '2025-08-26 02:29:28'),
	(2408462, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.004695, 29.078320, _binary 0x0000000001010000006b9f8ec70c143d4034ba83d899804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"12:29:37","ind":0,"enl":"41.0046950","boy":"029.078320","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":28.557840000000002,"mes":94793.6,"yon":174,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:29:37"}', '2025-08-26 02:29:37', '2025-08-26 02:29:40'),
	(2408463, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.993033, 29.045071, _binary 0x0000000001010000007effe6c5890b3d4063ab15b71b7f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:29:58","ind":0,"enl":"40.9930333","boy":"029.045071","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":68.20916,"mes":43260.3,"yon":61,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:29:58"}', '2025-08-26 02:29:58', '2025-08-26 02:30:00'),
	(2408464, '31.143.219.198:35638', '86284304533376212', 41.000932, 28.829925, _binary 0x000000000101000000ff21fdf675d43c40cd83aa871e804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:30:25","ind":0,"enl":"41.0009317","boy":"028.829925","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10968.2,"yon":71,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 12:30:25"}', '2025-08-26 02:30:25', '2025-08-26 02:30:28'),
	(2408465, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.994760, 29.050758, _binary 0x000000000101000000a702ee79fe0c3d403aafb14b547f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:30:26","ind":0,"enl":"40.9947600","boy":"029.050758","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":65.37559999999999,"mes":43260.9,"yon":49,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:30:26"}', '2025-08-26 02:30:26', '2025-08-26 02:30:30'),
	(2408466, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"26.08.2025","sat":"12:30:37","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":158,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:30:37"}', '2025-08-26 02:30:37', '2025-08-26 02:30:39'),
	(2408467, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003607, 29.079426, _binary 0x000000000101000000bd73284355143d40f345312f76804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"12:30:59","ind":0,"enl":"41.0036067","boy":"029.079426","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94793.8,"yon":52,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:30:59"}', '2025-08-26 02:30:59', '2025-08-26 02:31:00'),
	(2408468, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.997188, 29.055808, _binary 0x000000000101000000ecdade6e490e3d40173ac0dda37f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:30:59","ind":0,"enl":"40.9971883","boy":"029.055808","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":65.30152,"mes":43261.3,"yon":87,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:30:59"}', '2025-08-26 02:30:59', '2025-08-26 02:31:09'),
	(2408469, '176.238.2.104:60052', '9d67f34c0d92da9e7', 40.999965, 29.057103, _binary 0x000000000101000000e5805d4d9e0e3d40841266dafe7f4440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:31:34","ind":0,"enl":"40.9999650","boy":"029.057103","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":48.94836,"mes":43261.8,"yon":285,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:31:34"}', '2025-08-26 02:31:34', '2025-08-26 02:31:38'),
	(2408470, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.000763, 29.051133, _binary 0x00000000010100000012bf620d170d3d40be44060319804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:32:07","ind":0,"enl":"41.0007633","boy":"029.051133","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":52.30048,"mes":43262.4,"yon":289,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:32:07"}', '2025-08-26 02:32:07', '2025-08-26 02:32:10'),
	(2408471, '31.143.219.198:35638', '86284304533376212', 41.000008, 28.830488, _binary 0x0000000001010000006fb88fdc9ad43c40411da04500804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:32:30","ind":4,"enl":"41.0000083","boy":"028.830488","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":17.5014,"mes":10968.4,"yon":186,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:32:30"}', '2025-08-26 02:32:30', '2025-08-26 02:32:32'),
	(2408472, '31.143.21.53:17428', '44fe033664dac2621', 40.937120, 29.133683, _binary 0x000000000101000000fb07910c39223d40b936548cf3774440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"12:32:37","ind":0,"enl":"40.9371200","boy":"029.133683","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74659.2,"yon":105,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:32:37"}', '2025-08-26 02:32:37', '2025-08-26 02:32:38'),
	(2408473, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003640, 29.079455, _binary 0x000000000101000000f180b22957143d408d7a884677804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"12:32:50","ind":0,"enl":"41.0036400","boy":"029.079455","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94793.8,"yon":52,"A":"4","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:32:50"}', '2025-08-26 02:32:50', '2025-08-26 02:32:52'),
	(2408474, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.002005, 29.045370, _binary 0x00000000010100000032384a5e9d0b3d40d8b628b341804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:32:59","ind":0,"enl":"41.0020050","boy":"029.045370","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":35.447280000000006,"mes":43262.8,"yon":284,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:32:59"}', '2025-08-26 02:32:59', '2025-08-26 02:33:09'),
	(2408475, '178.245.95.200:52240', '86243005630594516', 40.996593, 29.055286, _binary 0x00000000010100000039ed2939270e3d40d474875e907f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"12:33:14","ind":4,"enl":"40.9965933","boy":"029.055286","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":118,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:33:14"}', '2025-08-26 02:33:14', '2025-08-26 02:33:15'),
	(2408476, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"12:33:21","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":241,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:33:21"}', '2025-08-26 02:33:21', '2025-08-26 02:33:23'),
	(2408477, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.003167, 29.039231, _binary 0x00000000010100000048fdf50a0b0a3d40d77734c467804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:33:31","ind":0,"enl":"41.0031667","boy":"029.039231","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":77.30248,"mes":43263.4,"yon":283,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:33:31"}', '2025-08-26 02:33:31', '2025-08-26 02:33:39'),
	(2408478, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.004282, 29.033346, _binary 0x000000000101000000d2730b5d89083d4053bc804d8c804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:33:59","ind":0,"enl":"41.0042817","boy":"029.033346","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":63.81992,"mes":43263.9,"yon":284,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:33:59"}', '2025-08-26 02:33:59', '2025-08-26 02:34:01'),
	(2408479, '31.143.219.198:35638', '86284304533376212', 40.995253, 28.831293, _binary 0x000000000101000000cb64389ecfd43c40385ecb75647f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:34:09","ind":0,"enl":"40.9952533","boy":"028.831293","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":34.521280000000004,"mes":10968.8,"yon":177,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:34:09"}', '2025-08-26 02:34:09', '2025-08-26 02:34:20'),
	(2408480, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.005407, 29.027638, _binary 0x0000000001010000007920b24813073d40f3d6af2ab1804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:34:24","ind":0,"enl":"41.0054067","boy":"029.027638","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":54.61548,"mes":43264.3,"yon":284,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:34:24"}', '2025-08-26 02:34:24', '2025-08-26 02:34:27'),
	(2408481, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.008617, 29.023301, _binary 0x000000000101000000cff6e80df7053d4087591e5a1a814440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:35:04","ind":0,"enl":"41.0086167","boy":"029.023301","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":34.59536,"mes":43264.9,"yon":327,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:35:04"}', '2025-08-26 02:35:04', '2025-08-26 02:35:06'),
	(2408482, '31.143.219.198:35638', '86284304533376212', 40.993273, 28.835510, _binary 0x000000000101000000207bbdfbe3d53c40b8be5994237f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:35:25","ind":0,"enl":"40.9932733","boy":"028.835510","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":37.94748,"mes":10969.4,"yon":168,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:35:25"}', '2025-08-26 02:35:25', '2025-08-26 02:35:28'),
	(2408483, '31.143.219.198:35638', '86284304533376212', 40.991908, 28.839091, _binary 0x000000000101000000315ef3aaced63c40c390e6d9f67e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:36:17","ind":0,"enl":"40.9919083","boy":"028.839091","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":38.65124,"mes":10969.9,"yon":93,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:36:17"}', '2025-08-26 02:36:17', '2025-08-26 02:36:20'),
	(2408484, '31.143.219.198:35638', '86284304533376212', 40.991695, 28.845160, _binary 0x0000000001010000002ae3df675cd83c40a94d9cdcef7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:36:58","ind":0,"enl":"40.9916950","boy":"028.845160","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":53.26352000000001,"mes":10970.3,"yon":97,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:36:58"}', '2025-08-26 02:36:58', '2025-08-26 02:37:06'),
	(2408485, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.011570, 29.020836, _binary 0x0000000001010000005794128255053d40afce31207b814440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:37:08","ind":0,"enl":"41.0115700","boy":"029.020836","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":20.0942,"mes":43265.3,"yon":333,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:37:08"}', '2025-08-26 02:37:08', '2025-08-26 02:37:12'),
	(2408486, '31.143.219.198:35638', '86284304533376212', 40.991855, 28.851550, _binary 0x000000000101000000a7e8482effd93c40e2afc91af57e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:37:29","ind":0,"enl":"40.9918550","boy":"028.851550","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":61.8568,"mes":10970.9,"yon":85,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:37:29"}', '2025-08-26 02:37:29', '2025-08-26 02:37:36'),
	(2408487, '31.143.219.198:35638', '86284304533376212', 40.993192, 28.857443, _binary 0x000000000101000000232f6b6281db3c404e14d7e7207f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:38:03","ind":0,"enl":"40.9931917","boy":"028.857443","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":52.744960000000006,"mes":10971.4,"yon":68,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:38:03"}', '2025-08-26 02:38:03', '2025-08-26 02:38:06'),
	(2408488, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.013732, 29.016860, _binary 0x0000000001010000004e9cdcef50043d409135d9f5c1814440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:38:46","ind":0,"enl":"41.0137317","boy":"029.016860","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":31.595119999999998,"mes":43265.7,"yon":316,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:38:46"}', '2025-08-26 02:38:46', '2025-08-26 02:38:50'),
	(2408489, '31.143.219.198:35638', '86284304533376212', 40.994768, 28.863095, _binary 0x00000000010100000054573ecbf3dc3c407bcc5191547f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:38:49","ind":0,"enl":"40.9947683","boy":"028.863095","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":30.66912,"mes":10971.9,"yon":77,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:38:49"}', '2025-08-26 02:38:49', '2025-08-26 02:38:52'),
	(2408490, '31.143.219.198:35638', '86284304533376212', 40.996722, 28.868731, _binary 0x0000000001010000007905a22765de3c40555ba093947f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:39:34","ind":0,"enl":"40.9967217","boy":"028.868731","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":30.113520000000005,"mes":10972.4,"yon":66,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:39:34"}', '2025-08-26 02:39:34', '2025-08-26 02:39:38'),
	(2408491, '31.143.219.198:35638', '86284304533376212', 40.998230, 28.874370, _binary 0x000000000101000000809a5ab6d6df3c406bf12900c67f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:40:21","ind":0,"enl":"40.9982300","boy":"028.874370","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":53.430200000000006,"mes":10972.9,"yon":71,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:40:21"}', '2025-08-26 02:40:21', '2025-08-26 02:40:24'),
	(2408492, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.018128, 29.016870, _binary 0x0000000001010000009548a29751043d40e8d0330752824440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:40:34","ind":0,"enl":"41.0181283","boy":"029.016870","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":25.50204,"mes":43266.3,"yon":8,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:40:34"}', '2025-08-26 02:40:34', '2025-08-26 02:40:37'),
	(2408493, '31.143.219.198:35638', '86284304533376212', 40.999872, 28.880468, _binary 0x000000000101000000ae2cd15966e13c4014d9bdcbfb7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:41:00","ind":0,"enl":"40.9998717","boy":"028.880468","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":40.00320000000001,"mes":10973.4,"yon":73,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:41:00"}', '2025-08-26 02:41:00', '2025-08-26 02:41:02'),
	(2408494, '31.143.219.198:35638', '86284304533376212', 41.001598, 28.885885, _binary 0x0000000001010000005704ff5bc9e23c40561d835f34804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:41:37","ind":0,"enl":"41.0015983","boy":"028.885885","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":53.55984000000001,"mes":10973.9,"yon":68,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:41:37"}', '2025-08-26 02:41:37', '2025-08-26 02:41:40'),
	(2408495, '5.24.46.45:28670', '350612079185623', 41.014947, 29.054153, _binary 0x00000000010100000071789cfddc0d3d40dc172bc5e9814440, '0', '{"device_model": "Teltonika", "p": "1", "did": "350612079185623", "trh": "2025-08-26", "sat": "12:41:03", "ind": 0, "enl": "41.0149466", "boy": "29.0541533", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 27279.236, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12616, "battery_voltage": 4057, "battery_current": 0, "record_timestamp": "2025-08-26 12:41:03", "codec_id": 8}', '2025-08-26 02:41:03', '2025-08-26 02:43:02'),
	(2408496, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.019335, 29.017800, _binary 0x0000000001010000006ade718a8e043d408655bc9179824440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"12:42:04","ind":0,"enl":"41.0193350","boy":"029.017800","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43266.4,"yon":148,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:42:04"}', '2025-08-26 02:42:04', '2025-08-26 02:42:05'),
	(2408497, '31.143.219.198:35638', '86284304533376212', 41.003517, 28.891468, _binary 0x000000000101000000376e313f37e43c40b3be373c73804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:42:18","ind":0,"enl":"41.0035167","boy":"028.891468","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":48.855760000000004,"mes":10974.5,"yon":57,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:42:18"}', '2025-08-26 02:42:18', '2025-08-26 02:42:22'),
	(2408498, '178.245.95.200:52240', '86243005630594516', 40.996593, 29.055286, _binary 0x00000000010100000039ed2939270e3d40d474875e907f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"12:43:14","ind":4,"enl":"40.9965933","boy":"029.055286","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":118,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:43:14"}', '2025-08-26 02:43:14', '2025-08-26 02:43:15'),
	(2408499, '31.143.219.198:35638', '86284304533376212', 41.004450, 28.894796, _binary 0x0000000001010000007497c45911e53c40cd3b4ed191804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:43:56","ind":0,"enl":"41.0044500","boy":"028.894796","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":11.112,"mes":10975,"yon":27,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:43:56"}', '2025-08-26 02:43:56', '2025-08-26 02:43:58'),
	(2408500, '31.143.219.198:35638', '86284304533376212', 41.007797, 28.898845, _binary 0x000000000101000000522cb7b41ae63c4024c2757bff804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:44:55","ind":0,"enl":"41.0077967","boy":"028.898845","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":24.687160000000002,"mes":10975.4,"yon":76,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:44:55"}', '2025-08-26 02:44:55', '2025-08-26 02:44:57'),
	(2408501, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997470, 29.074741, _binary 0x0000000001010000009babe63922133d40dd5ed218ad7f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"26.08.2025","sat":"12:45:02","ind":0,"enl":"40.9974700","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":232,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:45:02"}', '2025-08-26 02:45:02', '2025-08-26 02:45:05'),
	(2408502, '31.143.219.198:35638', '86284304533376212', 41.004988, 28.901635, _binary 0x000000000101000000d0ed258dd1e63c406baee474a3804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:46:14","ind":0,"enl":"41.0049883","boy":"028.901635","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":28.74304,"mes":10976,"yon":178,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:46:14"}', '2025-08-26 02:46:14', '2025-08-26 02:46:17'),
	(2408503, '31.143.219.198:35638', '86284304533376212', 41.000773, 28.901505, _binary 0x000000000101000000342e1c08c9e63c40e11ae95619804440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:48:15","ind":0,"enl":"41.0007733","boy":"028.901505","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":18.66816,"mes":10976.5,"yon":176,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:48:15"}', '2025-08-26 02:48:15', '2025-08-26 02:48:18'),
	(2408504, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"12:48:45","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":359,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:48:45"}', '2025-08-26 02:48:45', '2025-08-26 02:48:47'),
	(2408505, '5.27.202.142:9550', 'a1a58402fabc488f0', 40.996980, 29.076003, _binary 0x000000000101000000dc65bfee74133d400f62670a9d7f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"12:50:02","ind":0,"enl":"40.9969800","boy":"029.076003","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43118.8,"yon":112,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:50:02"}', '2025-08-26 02:50:02', '2025-08-26 02:50:03'),
	(2408506, '31.143.219.198:35638', '86284304533376212', 40.997397, 28.903611, _binary 0x0000000001010000004d4eed0c53e73c40b5d1efb1aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:50:10","ind":0,"enl":"40.9973967","boy":"028.903611","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":14.20484,"mes":10976.9,"yon":129,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:50:10"}', '2025-08-26 02:50:10', '2025-08-26 02:50:13'),
	(2408507, '31.143.219.198:35638', '86284304533376212', 40.996715, 28.903238, _binary 0x0000000001010000002481069b3ae73c4061376c5b947f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:51:07","ind":0,"enl":"40.9967150","boy":"028.903238","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10977,"yon":224,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:51:07"}', '2025-08-26 02:51:07', '2025-08-26 02:51:09'),
	(2408508, '178.245.95.200:52240', '86243005630594516', 40.996593, 29.055286, _binary 0x00000000010100000039ed2939270e3d40d474875e907f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"12:53:15","ind":4,"enl":"40.9965933","boy":"029.055286","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":118,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:53:15"}', '2025-08-26 02:53:15', '2025-08-26 02:53:16'),
	(2408509, '178.245.95.200:52240', '86243005630594516', 40.996593, 29.055286, _binary 0x00000000010100000039ed2939270e3d40d474875e907f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"12:53:49","ind":4,"enl":"40.9965933","boy":"029.055286","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":118,"A":"21","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:53:49"}', '2025-08-26 02:53:49', '2025-08-26 02:53:50'),
	(2408510, '31.143.219.198:35638', '86284304533376212', 40.996702, 28.903273, _binary 0x0000000001010000001c5c3ae63ce73c400eafdaeb937f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:54:08","ind":0,"enl":"40.9967017","boy":"028.903273","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10977,"yon":118,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 12:54:08"}', '2025-08-26 02:54:08', '2025-08-26 02:54:10'),
	(2408511, '31.143.219.198:35638', '86284304533376212', 40.996645, 28.903325, _binary 0x000000000101000000c1a8a44e40e73c40685c3810927f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:54:13","ind":0,"enl":"40.9966450","boy":"028.903325","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":2.9446800000000004,"mes":10977,"yon":114,"A":"13","Sensor":"","drx":1,"ignition":1,"datetime":"2025-08-26 12:54:13"}', '2025-08-26 02:54:13', '2025-08-26 02:54:15'),
	(2408512, '31.143.219.198:35638', '86284304533376212', 40.996627, 28.903368, _binary 0x000000000101000000c040102043e73c400369b576917f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:54:14","ind":0,"enl":"40.9966267","boy":"028.903368","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10977,"yon":119,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 12:54:14"}', '2025-08-26 02:54:14', '2025-08-26 02:54:16'),
	(2408513, '31.143.219.198:35638', '86284304533376212', 40.993628, 28.904781, _binary 0x000000000101000000cc0a45ba9fe73c40a6704e362f7f4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:56:17","ind":0,"enl":"40.9936283","boy":"028.904781","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":7.3524400000000005,"mes":10977.6,"yon":125,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 12:56:17"}', '2025-08-26 02:56:17', '2025-08-26 02:56:19'),
	(2408514, '31.143.219.198:35638', '86284304533376212', 40.992183, 28.905405, _binary 0x00000000010100000087a2409fc8e73c409591c4dcff7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"12:58:21","ind":0,"enl":"40.9921833","boy":"028.905405","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10977.8,"yon":181,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 12:58:21"}', '2025-08-26 02:58:21', '2025-08-26 02:58:24'),
	(2408515, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"26.08.2025","sat":"12:59:15","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":43,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:59:15"}', '2025-08-26 02:59:15', '2025-08-26 02:59:18'),
	(2408516, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"26.08.2025","sat":"12:59:21","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":208,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 12:59:21"}', '2025-08-26 02:59:21', '2025-08-26 02:59:24'),
	(2408517, '31.143.219.198:35638', '86284304533376212', 40.989942, 28.906586, _binary 0x000000000101000000ef02250516e83c402c39dd68b67e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"13:00:25","ind":0,"enl":"40.9899417","boy":"028.906586","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10978.2,"yon":355,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 13:00:25"}', '2025-08-26 03:00:25', '2025-08-26 03:00:28'),
	(2408518, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"26.08.2025","sat":"13:01:41","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":192,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:01:41"}', '2025-08-26 03:01:41', '2025-08-26 03:01:44'),
	(2408519, '31.143.219.198:35638', '86284304533376212', 40.990217, 28.907815, _binary 0x00000000010100000078d1579066e83c40fd39bb6bbf7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"13:01:46","ind":0,"enl":"40.9902167","boy":"028.907815","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10978.3,"yon":350,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:01:46"}', '2025-08-26 03:01:46', '2025-08-26 03:01:47'),
	(2408520, '31.143.21.53:17428', '44fe033664dac2621', 40.937120, 29.133683, _binary 0x000000000101000000fb07910c39223d40b936548cf3774440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"13:03:44","ind":0,"enl":"40.9371200","boy":"029.133683","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74659.2,"yon":148,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:03:44"}', '2025-08-26 03:03:44', '2025-08-26 03:03:45'),
	(2408521, '178.245.95.200:52240', '86243005630594516', 40.996593, 29.055286, _binary 0x00000000010100000039ed2939270e3d40d474875e907f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"13:03:49","ind":4,"enl":"40.9965933","boy":"029.055286","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":118,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:03:49"}', '2025-08-26 03:03:49', '2025-08-26 03:03:50'),
	(2408522, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003640, 29.079455, _binary 0x000000000101000000f180b22957143d408d7a884677804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"13:03:53","ind":0,"enl":"41.0036400","boy":"029.079455","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94793.8,"yon":160,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:03:53"}', '2025-08-26 03:03:53', '2025-08-26 03:03:55'),
	(2408523, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"13:04:10","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":82,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:04:10"}', '2025-08-26 03:04:10', '2025-08-26 03:04:11'),
	(2408524, '176.89.23.82:63874', '353201357563383', 40.997282, 29.048400, _binary 0x0000000001010000005c2041f1630c3d40877368eca67f4440, '0', '{"device_model": "Teltonika", "p": "1", "did": "353201357563383", "trh": "2025-08-26", "sat": "13:07:28", "ind": 0, "enl": "40.9972816", "boy": "29.0484", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 3.137, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12001, "battery_voltage": 0, "battery_current": 0, "record_timestamp": "2025-08-26 13:07:28", "codec_id": 8}', '2025-08-26 03:07:28', '2025-08-26 03:08:01'),
	(2408525, '178.244.140.13:41884', 'a1a58402fabc488f0', 40.996980, 29.076003, _binary 0x000000000101000000dc65bfee74133d400f62670a9d7f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"13:12:09","ind":0,"enl":"40.9969800","boy":"029.076003","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43118.8,"yon":145,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:12:09"}', '2025-08-26 03:12:09', '2025-08-26 03:12:11'),
	(2408526, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.019373, 29.017765, _binary 0x00000000010100000071033e3f8c043d4032f504d37a824440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"13:12:36","ind":0,"enl":"41.0193733","boy":"029.017765","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43266.4,"yon":345,"A":"4","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:12:36"}', '2025-08-26 03:12:36', '2025-08-26 03:12:38'),
	(2408527, '178.245.95.200:52240', '86243005630594516', 40.996593, 29.055286, _binary 0x00000000010100000039ed2939270e3d40d474875e907f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"13:13:49","ind":4,"enl":"40.9965933","boy":"029.055286","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":118,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:13:49"}', '2025-08-26 03:13:49', '2025-08-26 03:13:50'),
	(2408528, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997470, 29.074741, _binary 0x0000000001010000009babe63922133d40dd5ed218ad7f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"26.08.2025","sat":"13:16:03","ind":0,"enl":"40.9974700","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":215,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:16:03"}', '2025-08-26 03:16:03', '2025-08-26 03:16:06'),
	(2408529, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"13:19:34","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":114,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:19:34"}', '2025-08-26 03:19:34', '2025-08-26 03:19:35'),
	(2408530, '178.246.188.99:11184', 'a1a58402fabc488f0', 40.996580, 29.076510, _binary 0x00000000010100000024d1cb2896133d4081ecf5ee8f7f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"13:22:43","ind":0,"enl":"40.9965800","boy":"029.076510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43118.8,"yon":110,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:22:43"}', '2025-08-26 03:22:43', '2025-08-26 03:22:45'),
	(2408531, '178.245.95.200:52240', '86243005630594516', 40.996593, 29.055286, _binary 0x00000000010100000039ed2939270e3d40d474875e907f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"13:23:49","ind":4,"enl":"40.9965933","boy":"029.055286","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":118,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:23:49"}', '2025-08-26 03:23:49', '2025-08-26 03:23:50'),
	(2408532, '31.143.36.169:57767', 'a1a58402fabc488f0', 40.996580, 29.076510, _binary 0x00000000010100000024d1cb2896133d4081ecf5ee8f7f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"13:23:58","ind":0,"enl":"40.9965800","boy":"029.076510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43118.8,"yon":295,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:23:58"}', '2025-08-26 03:23:58', '2025-08-26 03:23:59'),
	(2408533, '178.246.164.209:55418', '7d8fbc41b40287e28', 40.997378, 29.074623, _binary 0x0000000001010000008787307e1a133d40bb1e9617aa7f4440, '0', '{"device_model":"Ortem","p":"1","did":"7d8fbc41b40287e28","trh":"26.08.2025","sat":"13:30:18","ind":0,"enl":"40.9973783","boy":"029.074623","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43119.8,"yon":326,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:30:18"}', '2025-08-26 03:30:18', '2025-08-26 03:30:20'),
	(2408534, '31.143.61.170:52483', '4c72eb3d775e77e3b', 40.997173, 29.074691, _binary 0x000000000101000000384e0af31e133d40e2f8eb5fa37f4440, '0', '{"device_model":"Ortem","p":"1","did":"4c72eb3d775e77e3b","trh":"26.08.2025","sat":"13:30:24","ind":0,"enl":"40.9971733","boy":"029.074691","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":153562.4,"yon":154,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:30:24"}', '2025-08-26 03:30:24', '2025-08-26 03:30:26'),
	(2408535, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.019373, 29.017765, _binary 0x00000000010100000071033e3f8c043d4032f504d37a824440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"13:31:10","ind":0,"enl":"41.0193733","boy":"029.017765","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43266.4,"yon":21,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 13:31:10"}', '2025-08-26 03:31:10', '2025-08-26 03:31:11'),
	(2408536, '31.143.219.198:35638', '86284304533376212', 40.990238, 28.907853, _binary 0x0000000001010000005393e00d69e83c4092dfec20c07e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"13:32:44","ind":0,"enl":"40.9902383","boy":"028.907853","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10978.3,"yon":111,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:32:44"}', '2025-08-26 03:32:44', '2025-08-26 03:32:47'),
	(2408537, '5.46.201.113:19729', '86284304718288612', 41.074905, 28.261966, _binary 0x000000000101000000f8a92a3410433c4048a7ae7c96894440, '0', '{"device_model":"Ortem","p":"1","did":"86284304718288612","trh":"26.08.2025","sat":"13:32:46","ind":0,"enl":"41.0749050","boy":"028.261966","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":26473.6,"yon":178,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:32:46"}', '2025-08-26 03:32:46', '2025-08-26 03:32:49'),
	(2408538, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.017573, 29.018236, _binary 0x000000000101000000209c4f1dab043d40336486d73f824440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"13:33:13","ind":0,"enl":"41.0175733","boy":"029.018236","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":17.834760000000003,"mes":43266.8,"yon":194,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:33:13"}', '2025-08-26 03:33:13', '2025-08-26 03:33:16'),
	(2408539, '176.89.105.65:36413', 'a1a58402fabc488f0', 40.996580, 29.076510, _binary 0x00000000010100000024d1cb2896133d4081ecf5ee8f7f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"13:33:27","ind":0,"enl":"40.9965800","boy":"029.076510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43118.8,"yon":318,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:33:27"}', '2025-08-26 03:33:27', '2025-08-26 03:33:29'),
	(2408540, '178.245.95.200:52240', '86243005630594516', 40.996593, 29.055286, _binary 0x00000000010100000039ed2939270e3d40d474875e907f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"13:33:49","ind":4,"enl":"40.9965933","boy":"029.055286","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":118,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:33:49"}', '2025-08-26 03:33:49', '2025-08-26 03:33:50'),
	(2408541, '5.24.140.87:48865', 'a1a58402fabc488f0', 40.996580, 29.076510, _binary 0x00000000010100000024d1cb2896133d4081ecf5ee8f7f4440, '0', '{"device_model":"Ortem","p":"1","did":"a1a58402fabc488f0","trh":"26.08.2025","sat":"13:33:57","ind":0,"enl":"40.9965800","boy":"029.076510","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":43118.8,"yon":142,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:33:57"}', '2025-08-26 03:33:57', '2025-08-26 03:33:58'),
	(2408542, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.013292, 29.019855, _binary 0x0000000001010000007ea99f3715053d407567dc8ab3814440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"13:34:17","ind":0,"enl":"41.0132917","boy":"029.019855","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":25.798360000000002,"mes":43267.2,"yon":159,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:34:17"}', '2025-08-26 03:34:17', '2025-08-26 03:34:20'),
	(2408543, '31.143.21.53:17428', '44fe033664dac2621', 40.937120, 29.133683, _binary 0x000000000101000000fb07910c39223d40b936548cf3774440, '0', '{"device_model":"Ortem","p":"1","did":"44fe033664dac2621","trh":"26.08.2025","sat":"13:34:52","ind":0,"enl":"40.9371200","boy":"029.133683","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":74659.2,"yon":11,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:34:52"}', '2025-08-26 03:34:52', '2025-08-26 03:34:53'),
	(2408544, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003640, 29.079455, _binary 0x000000000101000000f180b22957143d408d7a884677804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"13:34:58","ind":0,"enl":"41.0036400","boy":"029.079455","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94793.8,"yon":333,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:34:58"}', '2025-08-26 03:34:58', '2025-08-26 03:35:00'),
	(2408545, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"13:34:59","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":337,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:34:59"}', '2025-08-26 03:34:59', '2025-08-26 03:35:00'),
	(2408546, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.009343, 29.022508, _binary 0x000000000101000000fbe59315c3053d40e6f7472932814440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"13:35:41","ind":0,"enl":"41.0093433","boy":"029.022508","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":40.836600000000004,"mes":43267.7,"yon":146,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:35:41"}', '2025-08-26 03:35:41', '2025-08-26 03:35:45'),
	(2408547, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.005428, 29.025888, _binary 0x000000000101000000dd5b9198a0063d40877ce1dfb1804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"13:36:18","ind":0,"enl":"41.0054283","boy":"029.025888","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":43.55904,"mes":43268.3,"yon":145,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:36:18"}', '2025-08-26 03:36:18', '2025-08-26 03:36:21'),
	(2408548, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.001372, 29.028951, _binary 0x000000000101000000be2f2e5569073d40e951a7f22c804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"13:37:18","ind":0,"enl":"41.0013717","boy":"029.028951","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":49.8188,"mes":43268.7,"yon":156,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:37:18"}', '2025-08-26 03:37:18', '2025-08-26 03:37:20'),
	(2408549, '31.143.219.198:35638', '86284304533376212', 40.990238, 28.907853, _binary 0x0000000001010000005393e00d69e83c4092dfec20c07e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"13:38:07","ind":0,"enl":"40.9902383","boy":"028.907853","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10978.3,"yon":47,"A":"4","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:38:07"}', '2025-08-26 03:38:07', '2025-08-26 03:38:08'),
	(2408550, '176.238.2.104:60052', '9d67f34c0d92da9e7', 41.001587, 29.033491, _binary 0x000000000101000000d9b5bddd92083d40e54d34fe33804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"13:38:56","ind":0,"enl":"41.0015867","boy":"029.033491","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":37.15112,"mes":43269.2,"yon":23,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:38:56"}', '2025-08-26 03:38:56', '2025-08-26 03:38:59'),
	(2408551, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003640, 29.079455, _binary 0x000000000101000000f180b22957143d408d7a884677804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"13:40:17","ind":0,"enl":"41.0036400","boy":"029.079455","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":94793.8,"yon":162,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 13:40:17"}', '2025-08-26 03:40:17', '2025-08-26 03:40:19'),
	(2408552, '176.89.93.153:43901', '9d67f34c0d92da9e7', 41.007033, 29.038023, _binary 0x000000000101000000ed7e15e0bb093d40d2bd9877e6804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"13:40:41","ind":0,"enl":"41.0070333","boy":"029.038023","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":25.8354,"mes":43266.7,"yon":31,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:40:41"}', '2025-08-26 03:40:41', '2025-08-26 03:40:44'),
	(2408553, '176.89.93.153:43901', '9d67f34c0d92da9e7', 0.000000, 0.000000, _binary 0x00000000010100000000000000000000000000000000000000, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"03:00:00","ind":8,"enl":"00.0000000","boy":"000.000000","drm":[1,1,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43266.4,"yon":0,"A":"77","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 03:00:00"}', '2025-08-25 17:00:00', '2025-08-26 03:40:45'),
	(2408554, '176.89.93.153:43901', '9d67f34c0d92da9e7', 41.009908, 29.042440, _binary 0x000000000101000000d00a0c59dd0a3d40bf3ad8ac44814440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"13:41:46","ind":0,"enl":"41.0099083","boy":"029.042440","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":35.91028,"mes":43267.2,"yon":102,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:41:46"}', '2025-08-26 03:41:46', '2025-08-26 03:41:48'),
	(2408555, '188.58.127.114:7373', '350612079185623', 41.014947, 29.054153, _binary 0x00000000010100000071789cfddc0d3d40dc172bc5e9814440, '0', '{"device_model": "Teltonika", "p": "1", "did": "350612079185623", "trh": "2025-08-26", "sat": "13:41:09", "ind": 0, "enl": "41.0149466", "boy": "29.0541533", "drm": [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1], "hiz": 0, "mes": 27279.236, "yon": 0, "A": "", "Sensor": "", "drx": 0, "ignition": 0, "altitude": 0, "satellites": 0, "movement": 0, "sleep_mode": 2, "gnss_status": 3, "ext_voltage": 12616, "battery_voltage": 4057, "battery_current": 0, "record_timestamp": "2025-08-26 13:41:09", "codec_id": 8}', '2025-08-26 03:41:09', '2025-08-26 03:43:02'),
	(2408556, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.000190, 29.077143, _binary 0x000000000101000000861dc6a4bf133d40a4e4d53906804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"13:42:05","ind":0,"enl":"41.0001900","boy":"029.077143","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":30.150560000000002,"mes":94794.3,"yon":222,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:42:05"}', '2025-08-26 03:42:05', '2025-08-26 03:42:08'),
	(2408557, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.997352, 29.074596, _binary 0x000000000101000000946934b918133d40150e7338a97f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"13:42:59","ind":0,"enl":"40.9973517","boy":"029.074596","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94794.7,"yon":208,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:42:59"}', '2025-08-26 03:42:59', '2025-08-26 03:43:01'),
	(2408558, '176.89.93.153:43901', '9d67f34c0d92da9e7', 41.010545, 29.047718, _binary 0x000000000101000000376e313f370c3d407311df8959814440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"13:43:00","ind":0,"enl":"41.0105450","boy":"029.047718","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":20.2794,"mes":43267.7,"yon":43,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:43:00"}', '2025-08-26 03:43:00', '2025-08-26 03:43:03'),
	(2408559, '178.245.95.200:52240', '86243005630594516', 40.996593, 29.055286, _binary 0x00000000010100000039ed2939270e3d40d474875e907f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"13:43:50","ind":4,"enl":"40.9965933","boy":"029.055286","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":118,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:43:50"}', '2025-08-26 03:43:50', '2025-08-26 03:43:51'),
	(2408560, '176.89.93.153:43901', '9d67f34c0d92da9e7', 41.012000, 29.050533, _binary 0x000000000101000000685e0ebbef0c3d40a8c64b3789814440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"13:45:05","ind":0,"enl":"41.0120000","boy":"029.050533","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43268,"yon":156,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 13:45:05"}', '2025-08-26 03:45:05', '2025-08-26 03:45:07'),
	(2408561, '176.89.93.153:43901', '9d67f34c0d92da9e7', 41.012000, 29.050533, _binary 0x000000000101000000685e0ebbef0c3d40a8c64b3789814440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"13:45:33","ind":0,"enl":"41.0120000","boy":"029.050533","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43268,"yon":38,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:45:33"}', '2025-08-26 03:45:33', '2025-08-26 03:45:35'),
	(2408562, '176.227.71.125:46243', '3da51418ae7c6a801', 40.997470, 29.074741, _binary 0x0000000001010000009babe63922133d40dd5ed218ad7f4440, '0', '{"device_model":"Ortem","p":"1","did":"3da51418ae7c6a801","trh":"26.08.2025","sat":"13:47:05","ind":0,"enl":"40.9974700","boy":"029.074741","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":89091.3,"yon":206,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:47:05"}', '2025-08-26 03:47:05', '2025-08-26 03:47:07'),
	(2408563, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.997302, 29.074581, _binary 0x00000000010100000029e78bbd17133d4063df0495a77f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"13:47:23","ind":0,"enl":"40.9973017","boy":"029.074581","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94794.7,"yon":208,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 13:47:23"}', '2025-08-26 03:47:23', '2025-08-26 03:47:25'),
	(2408564, '31.143.219.198:35638', '86284304533376212', 40.989920, 28.908356, _binary 0x0000000001010000001920d1048ae83c4002d4d4b2b57e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"13:48:29","ind":0,"enl":"40.9899200","boy":"028.908356","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":10978.3,"yon":322,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 13:48:29"}', '2025-08-26 03:48:29', '2025-08-26 03:48:30'),
	(2408565, '31.143.219.198:35638', '86284304533376212', 40.990138, 28.908248, _binary 0x0000000001010000004ca8e0f082e83c402e8210dabc7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"13:48:39","ind":0,"enl":"40.9901383","boy":"028.908248","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10978.3,"yon":323,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:48:39"}', '2025-08-26 03:48:39', '2025-08-26 03:48:41'),
	(2408566, '31.143.219.198:35638', '86284304533376212', 40.990198, 28.908161, _binary 0x000000000101000000ae80423d7de83c40048761d1be7e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"13:48:40","ind":0,"enl":"40.9901983","boy":"028.908161","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10978.3,"yon":323,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 13:48:40"}', '2025-08-26 03:48:40', '2025-08-26 03:48:42'),
	(2408567, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.001008, 29.077661, _binary 0x000000000101000000b62c5f97e1133d4025c33b0a21804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"13:48:46","ind":0,"enl":"41.0010083","boy":"029.077661","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":18.26072,"mes":94795.2,"yon":56,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:48:46"}', '2025-08-26 03:48:46', '2025-08-26 03:48:49'),
	(2408568, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.004600, 29.076266, _binary 0x000000000101000000f7cb272b86133d40e3c798bb96804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"13:49:46","ind":0,"enl":"41.0046000","boy":"029.076266","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":20.649800000000003,"mes":94795.7,"yon":328,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:49:46"}', '2025-08-26 03:49:46', '2025-08-26 03:49:49'),
	(2408569, '188.57.80.104:16936', 'aebcc2b375a24f3f0', 40.992880, 29.031993, _binary 0x00000000010100000070b378b130083d401e6d1cb1167f4440, '0', '{"device_model":"Ortem","p":"1","did":"aebcc2b375a24f3f0","trh":"26.08.2025","sat":"13:50:23","ind":0,"enl":"40.9928800","boy":"029.031993","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0],"hiz":0,"mes":47573.5,"yon":126,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:50:23"}', '2025-08-26 03:50:23', '2025-08-26 03:50:25'),
	(2408570, '31.143.219.198:35638', '86284304533376212', 40.989858, 28.907261, _binary 0x000000000101000000aeefc34142e83c404b1641adb37e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"13:50:43","ind":0,"enl":"40.9898583","boy":"028.907261","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10978.4,"yon":187,"A":"","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 13:50:43"}', '2025-08-26 03:50:43', '2025-08-26 03:50:45'),
	(2408571, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.007212, 29.079683, _binary 0x000000000101000000130ce71a66143d4004d31f50ec804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"13:50:55","ind":0,"enl":"41.0072117","boy":"029.079683","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":41.521840000000005,"mes":94796.2,"yon":56,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:50:55"}', '2025-08-26 03:50:55', '2025-08-26 03:50:57'),
	(2408572, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.008913, 29.085206, _binary 0x000000000101000000486c770fd0153d40eeff2d1224814440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"13:51:34","ind":0,"enl":"41.0089133","boy":"029.085206","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":49.00392,"mes":94796.7,"yon":72,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:51:34"}', '2025-08-26 03:51:34', '2025-08-26 03:51:37'),
	(2408573, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.009003, 29.091346, _binary 0x000000000101000000d49e927362173d402e87270527814440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"13:52:08","ind":0,"enl":"41.0090033","boy":"029.091346","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":62.819840000000006,"mes":94797.3,"yon":113,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:52:08"}', '2025-08-26 03:52:08', '2025-08-26 03:52:11'),
	(2408574, '176.89.93.153:43901', '9d67f34c0d92da9e7', 41.011943, 29.050513, _binary 0x000000000101000000d905836bee0c3d400274a95b87814440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"13:52:30","ind":0,"enl":"41.0119433","boy":"029.050513","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":43268,"yon":10,"A":"12","Sensor":"","drx":1,"ignition":0,"datetime":"2025-08-26 13:52:30"}', '2025-08-26 03:52:30', '2025-08-26 03:52:32'),
	(2408575, '31.143.219.198:35638', '86284304533376212', 40.989948, 28.905321, _binary 0x000000000101000000cc61f71dc3e73c408b9d3aa0b67e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"13:52:47","ind":0,"enl":"40.9899483","boy":"028.905321","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":23.150000000000002,"mes":10978.7,"yon":359,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:52:47"}', '2025-08-26 03:52:47', '2025-08-26 03:52:49'),
	(2408576, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.007147, 29.097065, _binary 0x00000000010100000014967840d9183d401d63dd2eea804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"13:52:50","ind":0,"enl":"41.0071467","boy":"029.097065","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":52.319,"mes":94797.7,"yon":120,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:52:50"}', '2025-08-26 03:52:50', '2025-08-26 03:52:53'),
	(2408577, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.003952, 29.101665, _binary 0x000000000101000000d925aab7061a3d40be21437d81804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"13:53:20","ind":0,"enl":"41.0039517","boy":"029.101665","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":73.45031999999999,"mes":94798.3,"yon":135,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:53:20"}', '2025-08-26 03:53:20', '2025-08-26 03:53:23'),
	(2408578, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 41.000575, 29.105886, _binary 0x000000000101000000b11a4b581b1b3d40fc1873d712804440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"13:53:46","ind":0,"enl":"41.0005750","boy":"029.105886","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":68.91292,"mes":94798.8,"yon":135,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:53:46"}', '2025-08-26 03:53:46', '2025-08-26 03:53:48'),
	(2408579, '178.245.95.200:52240', '86243005630594516', 40.996593, 29.055286, _binary 0x00000000010100000039ed2939270e3d40d474875e907f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"13:53:50","ind":4,"enl":"40.9965933","boy":"029.055286","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":118,"A":"","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:53:50"}', '2025-08-26 03:53:50', '2025-08-26 03:53:51'),
	(2408580, '31.143.219.198:35638', '86284304533376212', 40.991933, 28.905548, _binary 0x0000000001010000004df564fed1e73c401ca89dabf77e4440, '0', '{"device_model":"Ortem","p":"1","did":"86284304533376212","trh":"26.08.2025","sat":"13:54:00","ind":0,"enl":"40.9919333","boy":"028.905548","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":10978.9,"yon":126,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:54:00"}', '2025-08-26 03:54:00', '2025-08-26 03:54:02'),
	(2408581, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.997592, 29.110488, _binary 0x000000000101000000b7990af1481c3d406a21b715b17f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"13:54:19","ind":0,"enl":"40.9975917","boy":"029.110488","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":44.22576,"mes":94799.3,"yon":122,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:54:19"}', '2025-08-26 03:54:19', '2025-08-26 03:54:22'),
	(2408582, '178.245.95.200:52240', '86243005630594516', 40.996593, 29.055286, _binary 0x00000000010100000039ed2939270e3d40d474875e907f4440, '0', '{"device_model":"Ortem","p":"1","did":"86243005630594516","trh":"26.08.2025","sat":"13:54:25","ind":4,"enl":"40.9965933","boy":"029.055286","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0],"hiz":0,"mes":0,"yon":118,"A":"21","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:54:25"}', '2025-08-26 03:54:25', '2025-08-26 03:54:27'),
	(2408583, '176.89.93.153:43901', '9d67f34c0d92da9e7', 41.010982, 29.051761, _binary 0x00000000010100000050357a35400d3d40602d2dd967814440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"13:54:33","ind":0,"enl":"41.0109817","boy":"029.051761","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":23.779680000000003,"mes":43268.3,"yon":132,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:54:33"}', '2025-08-26 03:54:33', '2025-08-26 03:54:36'),
	(2408584, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.994757, 29.115295, _binary 0x0000000001010000006f641ef9831d3d400bfd0230547f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"13:54:53","ind":0,"enl":"40.9947567","boy":"029.115295","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":62.61612000000001,"mes":94799.8,"yon":145,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:54:53"}', '2025-08-26 03:54:53', '2025-08-26 03:54:56'),
	(2408585, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.995437, 29.120550, _binary 0x0000000001010000006688635ddc1e3d407cde43786a7f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"13:55:29","ind":0,"enl":"40.9954367","boy":"029.120550","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":58.6158,"mes":94800.3,"yon":85,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:55:29"}', '2025-08-26 03:55:29', '2025-08-26 03:55:34'),
	(2408586, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.995643, 29.126855, _binary 0x0000000001010000008655bc9179203d40a2fd593d717f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"13:56:04","ind":0,"enl":"40.9956433","boy":"029.126855","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":55.356280000000005,"mes":94800.9,"yon":81,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:56:04"}', '2025-08-26 03:56:04', '2025-08-26 03:56:06'),
	(2408587, '176.89.93.153:43901', '9d67f34c0d92da9e7', 41.011032, 29.055375, _binary 0x0000000001010000001904560e2d0e3d40115c9b7c69814440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"13:56:37","ind":0,"enl":"41.0110317","boy":"029.055375","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":26.46508,"mes":43268.6,"yon":85,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:56:37"}', '2025-08-26 03:56:37', '2025-08-26 03:56:45'),
	(2408588, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.994633, 29.128080, _binary 0x0000000001010000008d45d3d9c9203d409b81db24507f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"13:56:50","ind":0,"enl":"40.9946333","boy":"029.128080","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":41.466280000000005,"mes":94801.3,"yon":197,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:56:50"}', '2025-08-26 03:56:50', '2025-08-26 03:56:53'),
	(2408589, '176.89.93.153:43901', '9d67f34c0d92da9e7', 41.012047, 29.059495, _binary 0x000000000101000000884677103b0f3d402a430bbf8a814440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"13:57:47","ind":0,"enl":"41.0120467","boy":"029.059495","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":35.613960000000006,"mes":43269.2,"yon":160,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:57:47"}', '2025-08-26 03:57:47', '2025-08-26 03:57:51'),
	(2408590, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.990827, 29.125946, _binary 0x000000000101000000e00f3fff3d203d407640c868d37e4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"13:57:51","ind":0,"enl":"40.9908267","boy":"029.125946","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":30.020920000000004,"mes":94801.8,"yon":270,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:57:51"}', '2025-08-26 03:57:51', '2025-08-26 03:57:54'),
	(2408591, '176.89.93.153:43901', '9d67f34c0d92da9e7', 41.007820, 29.061971, _binary 0x000000000101000000e84cda54dd0f3d409b20ea3e00814440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"13:58:20","ind":0,"enl":"41.0078200","boy":"029.061971","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":75.26528,"mes":43269.7,"yon":135,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:58:20"}', '2025-08-26 03:58:20', '2025-08-26 03:58:23'),
	(2408592, '176.89.93.153:43901', '9d67f34c0d92da9e7', 41.005633, 29.067395, _binary 0x000000000101000000f7e978cc40113d4060a28b97b8804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"13:58:45","ind":0,"enl":"41.0056333","boy":"029.067395","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":69.41296,"mes":43270.1,"yon":105,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:58:45"}', '2025-08-26 03:58:45', '2025-08-26 03:58:49'),
	(2408593, '176.227.59.231:40030', '0190b4dcbd63bd3fe', 40.992227, 29.122880, _binary 0x0000000001010000001d554d10751f3d40e85bd548017f4440, '0', '{"device_model":"Ortem","p":"1","did":"0190b4dcbd63bd3fe","trh":"26.08.2025","sat":"13:59:26","ind":0,"enl":"40.9922267","boy":"029.122880","drm":[1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],"hiz":0,"mes":94802.3,"yon":274,"A":"13","Sensor":"","drx":0,"ignition":1,"datetime":"2025-08-26 13:59:26"}', '2025-08-26 03:59:26', '2025-08-26 03:59:27'),
	(2408594, '176.89.93.153:43901', '9d67f34c0d92da9e7', 41.004480, 29.072341, _binary 0x000000000101000000f22895f084123d4038bef6cc92804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"13:59:48","ind":0,"enl":"41.0044800","boy":"029.072341","drm":[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],"hiz":21.74248,"mes":43270.7,"yon":177,"A":"","Sensor":"","drx":2,"ignition":0,"datetime":"2025-08-26 13:59:48"}', '2025-08-26 03:59:48', '2025-08-26 03:59:51'),
	(2408595, '176.89.93.153:43901', '9d67f34c0d92da9e7', 41.000025, 29.073288, _binary 0x00000000010100000073309b00c3123d405917b7d100804440, '0', '{"device_model":"Ortem","p":"1","did":"9d67f34c0d92da9e7","trh":"26.08.2025","sat":"14:00:37","ind":0,"enl":"41.0000250","boy":"029.073288","drm":[1,0,0,0,0,0,0,