<?php
    $alertClasses = ['alert', 'alert-' . $type];
    if ($dismissible) {
        $alertClasses[] = 'alert-dismissible';
    }
    if ($class) {
        $alertClasses[] = $class;
    }
    $alertClass = implode(' ', $alertClasses);
    
    $alertId = $id ? 'id="' . $id . '"' : '';
    $alertDataAttributes = '';
    if ($autoHide) {
        $alertDataAttributes .= ' data-auto-hide="true" data-delay="' . $delay . '"';
    }
    
    // Default icons for each type
    $defaultIcons = [
        'success' => 'check-circle',
        'danger' => 'alert-circle',
        'warning' => 'alert-triangle',
        'info' => 'info-circle',
        'primary' => 'info-circle',
        'secondary' => 'info-circle'
    ];
    
    $iconName = $icon ?: ($defaultIcons[$type] ?? 'info-circle');
    $iconHtml = '<i class="ti ti-' . $iconName . '"></i>';
?>

<div class="<?php echo e($alertClass); ?>" <?php echo e($alertId); ?><?php echo e($alertDataAttributes); ?> role="alert">
    <?php if($icon || $title): ?>
        <div class="d-flex align-items-center">
            <?php if($icon): ?>
                <div class="me-2">
                    <?php echo $iconHtml; ?>

                </div>
            <?php endif; ?>
            <?php if($title): ?>
                <div class="flex-fill">
                    <h4 class="alert-title"><?php echo e($title); ?></h4>
                </div>
            <?php endif; ?>
        </div>
    <?php endif; ?>
    
    <div class="alert-content">
        <?php echo e($slot); ?>

    </div>
    
    <?php if($dismissible): ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    <?php endif; ?>
</div>

<?php if($autoHide): ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const alert = document.querySelector('[data-auto-hide="true"]');
    if (alert) {
        setTimeout(function() {
            const bsAlert = new bootstrap.Alert(alert);
            bsAlert.close();
        }, <?php echo e($delay); ?>);
    }
});
</script>
<?php endif; ?><?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views\components\alert.blade.php ENDPATH**/ ?>