<?php $__env->startSection('title', __('Mileage Tracking Report')); ?>

<?php $__env->startSection('content'); ?>
<div class="page-wrapper" id="mileage-tracking-report">
    <div class="page-header d-print-none">
        <div class="container-xl">
            <div class="row g-2 align-items-center">
                <div class="col">
                    <div class="page-pretitle">
                        <a href="/reports" class="text-muted"><?php echo e(__('Reports')); ?></a> / <?php echo e(__('Maintenance Reports')); ?>

                    </div>
                    <h2 class="page-title">
                        <i class="ti ti-speed me-2"></i>
                        <?php echo e(__('Mileage Tracking Report')); ?>

                    </h2>
                    <div class="text-muted mt-1">
                        <?php echo e(__('Monitor vehicle mileage maintenance schedules and remaining distances')); ?>

                    </div>
                </div>
                <div class="col-auto ms-auto d-print-none">
                    <div class="btn-list">
                        <button type="button" class="btn btn-secondary" onclick="printReport()">
                            <i class="ti ti-printer me-1"></i>
                            <?php echo e(__('Print')); ?>

                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="container-xl">
            <!-- Filters -->
            <div class="card mb-3">
                <div class="card-header">
                    <h3 class="card-title"><?php echo e(__('Filters')); ?></h3>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-3">
                            <label class="form-label"><?php echo e(__('Status')); ?></label>
                            <select class="form-select" id="statusFilter">
                                <option value=""><?php echo e(__('All Status')); ?></option>
                                <option value="overdue"><?php echo e(__('Overdue')); ?></option>
                                <option value="due_soon"><?php echo e(__('Due Soon (100 km)')); ?></option>
                                <option value="upcoming"><?php echo e(__('Upcoming')); ?></option>
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label class="form-label">&nbsp;</label>
                            <div>
                                <button type="button" class="btn btn-primary w-100" onclick="generateReport()">
                                    <i class="icon ti ti-search me-1"></i>
                                    <?php echo e(__('Generate Report')); ?>

                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Summary Cards -->
            <div class="row row-cards mb-3" id="summaryCards">
                <div class="col-sm-6 col-lg-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="subheader"><?php echo e(__('Total Vehicles')); ?></div>
                            </div>
                            <div class="h1 mb-0" id="totalVehicles">-</div>
                            <div class="text-muted" id="totalVehiclesTrend">
                                <?php echo e(__('All vehicles in system')); ?>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="subheader"><?php echo e(__('With Mileage Monitoring')); ?></div>
                            </div>
                            <div class="h1 mb-0" id="withMileageMonitoring">-</div>
                            <div class="text-muted" id="withMileageMonitoringTrend">
                                <?php echo e(__('Vehicles with mileage monitoring')); ?>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="subheader"><?php echo e(__('Overdue')); ?></div>
                            </div>
                            <div class="h1 mb-0 text-danger" id="overdueCount">-</div>
                            <div class="text-muted" id="overdueTrend">
                                <?php echo e(__('Vehicles past maintenance km')); ?>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="subheader"><?php echo e(__('Due Soon')); ?></div>
                            </div>
                            <div class="h1 mb-0 text-warning" id="dueSoonCount">-</div>
                            <div class="text-muted" id="dueSoonTrend">
                                <?php echo e(__('Due within 100 km')); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Charts Row -->
            <div class="row mb-3" id="chartsRow">
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title"><?php echo e(__('Mileage Status Distribution')); ?></h3>
                        </div>
                        <div class="card-body">
                            <div id="statusDistributionChart" style="height: 300px;"></div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title"><?php echo e(__('Average Remaining Distance')); ?></h3>
                        </div>
                        <div class="card-body">
                            <div id="averageRemainingChart" style="height: 300px;"></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Mileage Tracking Table -->
            <div class="card mb-3 d-none" id="mileageTableCard">
                <div class="card-header">
                    <h3 class="card-title"><?php echo e(__('Mileage Tracking Details')); ?></h3>
                    <div class="card-actions">
                        <div class="btn-list">
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div id="mileage-table"></div>
                </div>
            </div>

            <!-- Vehicles Without Mileage Monitoring Table -->
            <div class="card d-none" id="noMileageTableCard">
                <div class="card-header">
                    <h3 class="card-title"><?php echo e(__('Vehicles Without Mileage Monitoring')); ?></h3>
                    <div class="card-subtitle text-muted"><?php echo e(__('Vehicles that need mileage monitoring configuration')); ?></div>
                    <div class="card-actions">
                        <div class="btn-list">
                            
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div id="no-mileage-table"></div>
                </div>
            </div>

            <!-- Loading State -->
            <div class="card d-none" id="loadingState">
                <div class="card-body text-center py-4">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden"><?php echo e(__('Loading...')); ?></span>
                    </div>
                    <div class="mt-2"><?php echo e(__('Generating mileage tracking report...')); ?></div>
                </div>
            </div>

            <!-- No Data State -->
            <div class="card d-none" id="noDataState">
                <div class="card-body text-center py-4">
                    <div class="empty">
                        <div class="empty-img">
                            <img src="/assets/src/static/illustrations/undraw_quitting_time_dm8t.svg" style="height: 128px;" alt="">
                        </div>
                        <p class="empty-title"><?php echo e(__('No mileage data found')); ?></p>
                        <p class="empty-subtitle text-muted">
                            <?php echo e(__('No vehicles with mileage monitoring enabled for the selected period.')); ?>

                        </p>
                    </div>
                </div>
            </div>

            <!-- No Monitoring State -->
            <div class="card" id="noMonitoringState">
                <div class="card-body text-center py-4">
                    <div class="empty">
                        <div class="empty-img">
                            <img src="/assets/src/static/illustrations/undraw_quitting_time_dm8t.svg" style="height: 128px;" alt="">
                        </div>
                        <p class="empty-title"><?php echo e(__('No Mileage Monitoring')); ?></p>
                        <p class="empty-subtitle text-muted">
                            <?php echo e(__('Please enable mileage monitoring for vehicles in vehicle settings to use this report.')); ?>

                        </p>
                        <div class="empty-action">
                            <a href="/vehicle-settings" class="btn btn-primary">
                                <i class="ti ti-settings me-2"></i>
                                <?php echo e(__('Go to Vehicle Settings')); ?>

                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .status-badge {
        padding: 0.25rem 0.5rem;
        border-radius: 0.375rem;
        font-size: 0.75rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.05em;
    }
    
    .status-overdue {
        background-color: #fef2f2;
        color: #dc2626;
    }
    
    .status-due-soon {
        background-color: #fffbeb;
        color: #d97706;
    }
    
    .status-upcoming {
        background-color: #eff6ff;
        color: #2563eb;
    }
    
    .status-compliant {
        background-color: #f0fdf4;
        color: #16a34a;
    }
    
    .status-no-config {
        background-color: #fef3c7;
        color: #d97706;
    }
    
    .status-disabled {
        background-color: #f3f4f6;
        color: #6b7280;
    }
    
    .days-overdue {
        color: #dc2626;
        font-weight: 600;
    }
    
    .days-remaining {
        color: #d97706;
        font-weight: 600;
    }
    
    .days-compliant {
        color: #16a34a;
        font-weight: 600;
    }
    
    .km-overdue {
        color: #dc2626;
        font-weight: 600;
    }
    
    .km-remaining {
        color: #d97706;
        font-weight: 600;
    }
    
    .km-compliant {
        color: #16a34a;
        font-weight: 600;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    let reportData = [];
    let tableMileage;
    let tableNoMileage;
    let vehicles = [];
    let allVehicles = [];
    let vehiclesWithMileage = [];
    let vehiclesWithoutMileage = [];
    
    // Chart variables
    let statusDistributionChart;
    let averageRemainingChart;
    
    var speedUnit = '';
    var lengthUnit = '';
    var currency = '';

    $('#summaryCards').addClass('d-none');
    $('#chartsRow').addClass('d-none');
    $('#mileageTableCard').addClass('d-none');
    $('#noMileageTableCard').addClass('d-none');
    $('#loadingState').addClass('d-none');
    $('#noDataState').addClass('d-none');
    $('#noMonitoringState').removeClass('d-none');
    
    onAppReady(function() {
        // Initialize the page after app is ready
        initializePage();
    });

    function initializePage() {
        initializeTable();
        initializeNoMileageTable();
        loadMileageData();
    }

    // Initialize table
    function initializeTable() {
        tableMileage = createTabulator("#mileage-table", {
            pagination: "local",
            paginationSize: 20,
            initialSort: [
                {column: "remaining_km", dir: "asc"}
            ],
            columns: [
                {title: "#", field: "id", width: 50, hozAlign: "center"},
                {
                    title: "<?php echo e(__('Vehicle')); ?>", 
                    field: "vehicle_name",
                    formatter: function(cell) {
                        const data = cell.getData();
                        return `<strong>${data.vehicle_name}</strong>`;
                    }
                },
                {
                    title: "<?php echo e(__('Maintenance Date')); ?>", 
                    field: "maintenance_km_date",
                    formatter: function(cell) {
                        const date = cell.getValue();
                        if (!date) return '<span class="text-muted">-</span>';
                        return dateFormatter(date);
                    }
                },
                {
                    title: "<?php echo e(__('Maintenance Km')); ?>", 
                    field: "maintenance_km_interval",
                    formatter: function(cell) {
                        const km = cell.getValue();
                        if (!km) return '<span class="text-muted">-</span>';
                        return `${km} km`;
                    }
                },
                {
                    title: "<?php echo e(__('Current Km')); ?>", 
                    field: "km_end",
                    formatter: function(cell) {
                        const km = cell.getValue();
                        if (!km) return '<span class="text-muted">-</span>';
                        return `${km} km`;
                    }
                },
                {
                    title: "<?php echo e(__('Distance Traveled')); ?>", 
                    field: "distance_traveled",
                    formatter: function(cell) {
                        const distance = cell.getValue();
                        if (!distance || distance <= 0) return '<span class="text-muted">-</span>';
                        return `${distance} km`;
                    }
                },
                {
                    title: "<?php echo e(__('Remaining Km')); ?>", 
                    field: "remaining_km", 
                    hozAlign: "center",
                    formatter: function(cell) {
                        const km = cell.getValue();
                        const status = cell.getData().status;
                        
                        let textClass = '';
                        let prefix = '';
                        
                        if (status === 'overdue') {
                            textClass = 'km-overdue';
                            prefix = '<?php echo e(__("Overdue by")); ?> ';
                        } else if (status === 'due_soon') {
                            textClass = 'km-remaining';
                            prefix = '<?php echo e(__("Due in")); ?> ';
                        } else if (status === 'upcoming') {
                            textClass = 'km-remaining';
                            prefix = '<?php echo e(__("Due in")); ?> ';
                        } else {
                            textClass = '';
                            prefix = '';
                        }
                        
                        return `<span class="${textClass}">${prefix}${Math.abs(km)} km</span>`;
                    }
                },
                {
                    title: "<?php echo e(__('Status')); ?>", 
                    field: "status", 
                    hozAlign: "center",
                    formatter: function(cell) {
                        const status = cell.getValue();
                        
                        let badgeClass = '';
                        let statusText = '';
                        
                        if (status === 'overdue') {
                            badgeClass = 'status-overdue';
                            statusText = '<?php echo e(__("Overdue")); ?>';
                        } else if (status === 'due_soon') {
                            badgeClass = 'status-due-soon';
                            statusText = '<?php echo e(__("Due Soon")); ?>';
                        } else if (status === 'upcoming') {
                            badgeClass = 'status-upcoming';
                            statusText = '<?php echo e(__("Upcoming")); ?>';
                        } else {
                            badgeClass = '';
                            statusText = '-';
                        }
                        
                        return `<span class="status-badge ${badgeClass}">${statusText}</span>`;
                    }
                },
                {
                    title: "<?php echo e(__('Actions')); ?>", 
                    field: "actions", 
                    hozAlign: "center",
                    formatter: function(cell) {
                        const data = cell.getData();
                        let buttons = '';
                        
                        // Go to vehicle settings button
                        if (data.vehicle_id) {
                            const settingsUrlEncoded = btoa(JSON.stringify({
                                did: data.vehicle_id
                            }));
                            buttons += `<a href="/vehicle-settings/${settingsUrlEncoded}" class="btn btn-sm btn-primary me-1" title="<?php echo e(__('Vehicle Settings')); ?>">
                                <i class="ti ti-settings"></i>
                                <span class="d-none d-md-inline"><?php echo e(__("Settings")); ?></span>
                            </a>`;
                        }
                        
                        // Vehicle history button
                        if (data.vehicle_id) {
                            const today = new Date().toISOString().split('T')[0];
                            const urlEncoded = btoa(JSON.stringify({
                                did: data.vehicle_id,
                                date: today,
                                start_time: "00:01",
                                end_time: "23:59"
                            }));
                            buttons += `<a href="/vehicle-map/${urlEncoded}" class="btn btn-sm btn-info me-1" title="<?php echo e(__('Vehicle History')); ?>">
                                <i class="ti ti-history"></i>
                                <span class="d-none d-md-inline"><?php echo e(__("History")); ?></span>
                            </a>`;
                        }
                        
                        return buttons;
                    }
                }
            ]
        });
    }

    // Initialize table for vehicles without mileage monitoring
    function initializeNoMileageTable() {
        tableNoMileage = createTabulator("#no-mileage-table", {
            initialSort: [
                {column: "vehicle_name", dir: "asc"}
            ],
            columns: [
                {title: "#", field: "id", width: 50, hozAlign: "center"},
                {
                    title: "<?php echo e(__('Vehicle')); ?>", 
                    field: "vehicle_name",
                    formatter: function(cell) {
                        const data = cell.getData();
                        return `<strong>${data.vehicle_name}</strong><br><small class="text-muted">${data.vehicle_id || ''}</small>`;
                    }
                },
                {
                    title: "<?php echo e(__('Mileage Monitoring')); ?>", 
                    field: "mileage_monitoring", 
                    hozAlign: "center",
                    formatter: function(cell) {
                        const status = cell.getValue();
                        if (status) {
                            return '<span class="badge text-white bg-warning"><?php echo e(__("Enabled (No Config)")); ?></span>';
                        } else {
                            return '<span class="badge text-white bg-danger"><?php echo e(__("Disabled")); ?></span>';
                        }
                    }
                },
                {
                    title: "<?php echo e(__('Actions')); ?>", 
                    field: "actions", 
                    hozAlign: "center",
                    formatter: function(cell) {
                        const data = cell.getData();
                        let buttons = '';
                        
                        // Go to vehicle settings button
                        if (data.vehicle_id) {
                            const settingsUrlEncoded = btoa(JSON.stringify({
                                did: data.vehicle_id
                            }));
                            buttons += `<a href="/vehicle-settings/${settingsUrlEncoded}" class="btn btn-sm btn-primary me-1" title="<?php echo e(__('Vehicle Settings')); ?>">
                                <i class="ti ti-settings"></i>
                                <span class="d-none d-md-inline"><?php echo e(__("Settings")); ?></span>
                            </a>`;
                        }
                        
                        return buttons;
                    }
                }
            ]
        });
    }

    // Load mileage data
    function loadMileageData() {
        showLoadingState();

        http.post({
            url: '/api/reports/mileage-tracking',
            data: {},
            loading: false
        })
        .then(function(response) {
            hideLoadingState();
            
            if (response.success) {
        
                // Set units after data is loaded
                speedUnit = __(window.sessionSettings.speedUnit || 'km/h');
                lengthUnit = __(window.sessionSettings.lengthUnit || 'km');
                currency = __(window.sessionSettings.currency || 'TRY');
                
                reportData = response.data;
                allVehicles = response.data.vehicles || [];
                vehicles = response.data.vehicles || [];

                var message = __('#name# used #value# records').replace('#name#', __('Mileage Tracking')).replace('#value#', allVehicles.length);
                showReportDataProcessingInfo(message);
                
                if (allVehicles.length === 0) {
                    showNoMonitoringState();
                    return;
                }

                processMileageData(response.data);
            } else {
                showNoDataState();
                showConfirmDialog({
                    title: '<?php echo e(__("Error")); ?>',
                    message: response.message || '<?php echo e(__("Unknown error occurred")); ?>',
                    confirmText: '<?php echo e(__("OK")); ?>',
                    cancelText: '',
                    type: 'danger',
                    onConfirm: function() {},
                    onCancel: function() {}
                });
            }
        })
        .catch(function(error) {
            hideLoadingState();
            showNoDataState();
            console.error('Error loading mileage data:', error);
            showConfirmDialog({
                title: '<?php echo e(__("Error")); ?>',
                message: '<?php echo e(__("Error loading mileage data")); ?>',
                confirmText: '<?php echo e(__("OK")); ?>',
                cancelText: '',
                type: 'danger',
                onConfirm: function() {},
                onCancel: function() {}
            });
        });
    }

    // Process mileage data
    function processMileageData(data) {
        if (!data.vehicles || data.vehicles.length === 0) {
            showNoDataState();
            return;
        }

        // Separate vehicles with and without mileage monitoring
        vehiclesWithMileage = [];
        vehiclesWithoutMileage = [];

        data.vehicles.forEach(vehicle => {
            let hasMileageMonitoring = false;
            let maintenanceDate = vehicle.maintenance_km_date;
            let maintenanceKm = vehicle.maintenance_km_interval;
            
            // Check if mileage monitoring is enabled (has maintenance km interval)
            hasMileageMonitoring = maintenanceKm !== null && maintenanceKm !== undefined;

            if (hasMileageMonitoring) {
                // Vehicle has mileage monitoring
                vehiclesWithMileage.push(vehicle);
            } else {
                // Vehicle doesn't have mileage monitoring
                vehiclesWithoutMileage.push(vehicle);
            }
        });


        // Process vehicles with mileage monitoring
        const processedVehicles = vehiclesWithMileage.map((vehicle, index) => {
            const maintenanceDate = vehicle.maintenance_km_date;
            const maintenanceKm = parseFloat(vehicle.maintenance_km_interval) || 0;
            const kmStart = parseFloat(vehicle.km_start) || 0;
            const kmEnd = parseFloat(vehicle.km_end) || 0;
            
             // Calculate metrics
             const distanceTraveled = Math.round((kmEnd - kmStart) * 10) / 10;
             const remainingKm = Math.round((maintenanceKm - distanceTraveled) * 10) / 10;
            
            // Determine status
            let status = 'unknown';
            if (remainingKm <= 0) {
                status = 'overdue';
            } else if (remainingKm <= 100) {
                status = 'due_soon';
            } else if (remainingKm <= 500) {
                status = 'upcoming';
            } else {
                status = 'compliant';
            }

            



            
            return {
                id: index + 1,
                vehicle_id: vehicle.vehicle_id,
                device_id: vehicle.device_id,
                vehicle_name: vehicle.vehicle_name || '<?php echo e(__("Unknown Vehicle")); ?>',
                maintenance_km_date: maintenanceDate,
                maintenance_km_interval: Math.round(maintenanceKm * 10) / 10,
                km_start: Math.round(kmStart * 10) / 10,
                km_end: Math.round(kmEnd * 10) / 10,
                distance_traveled: distanceTraveled,
                remaining_km: remainingKm,
                status: status
            };
        });

        // Filter by status if specified
        const statusFilter = $('#statusFilter').val();
        let filteredVehicles = processedVehicles;
        
        if (statusFilter) {
            filteredVehicles = processedVehicles.filter(vehicle => vehicle.status === statusFilter);
        }

        if (filteredVehicles.length === 0) {
            showNoDataState();
            return;
        }

        // Calculate summary statistics
        const summary = calculateSummary(processedVehicles);
        
        // Display the processed data
        displayReport({
            summary: summary,
            detailed_data: filteredVehicles
        });
    }

    // Calculate summary statistics
    function calculateSummary(vehicles) {
        const totalVehicles = allVehicles.length;
        const withMileageMonitoring = vehiclesWithMileage.length;
        const overdueCount = vehicles.filter(v => v.status === 'overdue').length;
        const dueSoonCount = vehicles.filter(v => v.status === 'due_soon').length;
        const upcomingCount = vehicles.filter(v => v.status === 'upcoming').length;
        
        return {
            total_vehicles: totalVehicles,
            with_mileage_monitoring: withMileageMonitoring,
            overdue_count: overdueCount,
            due_soon_count: dueSoonCount,
            upcoming_count: upcomingCount
        };
    }

    // Display report data
    function displayReport(data) {
        // Show all sections
        $('#summaryCards').removeClass('d-none');
        $('#chartsRow').removeClass('d-none');
        $('#mileageTableCard').removeClass('d-none');
        $('#noDataState').addClass('d-none');
        $('#noMonitoringState').addClass('d-none');

        // Update summary cards
        $('#totalVehicles').text(data.summary.total_vehicles);
        $('#withMileageMonitoring').text(data.summary.with_mileage_monitoring);
        $('#overdueCount').text(data.summary.overdue_count);
        $('#dueSoonCount').text(data.summary.due_soon_count);

        // Display detailed data
        displayDetailedData(data.detailed_data);

        // Display vehicles without mileage monitoring
        displayNoMileageData();

        // Update charts
        updateCharts(data.detailed_data);
    }

    // Display detailed data table
    function displayDetailedData(data) {
        if (data && data.length > 0) {
            tableMileage.setData(data);
        } else {
            tableMileage.setData([]);
        }
    }

    // Display vehicles without mileage monitoring
    function displayNoMileageData() {
        if (vehiclesWithoutMileage.length === 0) {
            $('#noMileageTableCard').addClass('d-none');
            return;
        }

        const processedNoMileage = vehiclesWithoutMileage.map((vehicle, index) => {
            return {
                id: index + 1,
                vehicle_id: vehicle.vehicle_id,
                device_id: vehicle.device_id,
                vehicle_name: vehicle.vehicle_name || '<?php echo e(__("Unknown Vehicle")); ?>',
                mileage_monitoring: false
            };
        });

        tableNoMileage.setData(processedNoMileage);
        $('#noMileageTableCard').removeClass('d-none');
    }

    // Update charts
    function updateCharts(data) {
        // Status distribution chart
        const statusCounts = {
            overdue: data.filter(v => v.status === 'overdue').length,
            due_soon: data.filter(v => v.status === 'due_soon').length,
            upcoming: data.filter(v => v.status === 'upcoming').length
        };

        renderStatusDistributionChart(statusCounts);

                 // Average remaining distance chart
         const averageRemaining = data.length > 0 ? 
             Math.round((data.reduce((sum, v) => sum + v.remaining_km, 0) / data.length) * 10) / 10 : 0;
        renderAverageRemainingChart(averageRemaining);
    }

    // Render status distribution chart
    function renderStatusDistributionChart(statusCounts) {
        // Clear existing chart
        $("#statusDistributionChart").html('');
        
        const labels = [
            '<?php echo e(__("Overdue")); ?>',
            '<?php echo e(__("Due Soon")); ?>',
            '<?php echo e(__("Upcoming")); ?>'
        ];
        
        const chartData = [
            statusCounts.overdue,
            statusCounts.due_soon,
            statusCounts.upcoming
        ];
        
        const colors = ['#ef4444', '#f59e0b', '#3b82f6'];
        
        var options = {
            chart: {
                type: 'donut',
                height: 300,
                toolbar: { show: false }
            },
            series: chartData,
            labels: labels,
            colors: colors,
            legend: { position: 'bottom' },
            plotOptions: {
                pie: {
                    donut: {
                        size: '60%'
                    }
                }
            },
            dataLabels: {
                enabled: true,
                formatter: function(val, opts) {
                    return opts.w.globals.series[opts.seriesIndex];
                }
            }
        };
        
        new ApexCharts(document.querySelector("#statusDistributionChart"), options).render();
    }

    // Render average remaining distance chart
    function renderAverageRemainingChart(averageRemaining) {
        // Clear existing chart
        $("#averageRemainingChart").html('');
        
        var options = {
            chart: {
                type: 'radialBar',
                height: 300,
                toolbar: { show: false }
            },
            series: [Math.round(averageRemaining)],
            labels: ['<?php echo e(__("Average Remaining Km")); ?>'],
            plotOptions: {
                radialBar: {
                    startAngle: -135,
                    endAngle: 135,
                    hollow: {
                        margin: 15,
                        size: '70%',
                    },
                    track: {
                        background: '#e7e7e7',
                        strokeWidth: '97%',
                        margin: 5,
                    },
                    dataLabels: {
                        name: {
                            show: false,
                        },
                        value: {
                            offsetY: 7,
                            color: '#111',
                            fontSize: '20px',
                            show: true,
                            formatter: function(val) {
                                return val + ' km';
                            }
                        }
                    }
                }
            },
            fill: {
                type: 'gradient',
                gradient: {
                    shade: 'dark',
                    type: 'horizontal',
                    shadeIntensity: 0.5,
                    gradientToColors: ['#3b82f6'],
                    inverseColors: true,
                    opacityFrom: 1,
                    opacityTo: 1,
                    stops: [0, 100]
                }
            },
            stroke: {
                lineCap: 'round'
            }
        };
        
        new ApexCharts(document.querySelector("#averageRemainingChart"), options).render();
    }

    // Generate report (called from filter button)
    function generateReport() {
        loadMileageData();
    }

    // Print report
    function printReport() {
        window.print();
    }

    // Toggle columns
    function toggleColumns() {
        showConfirmDialog({
            title: '<?php echo e(__("Info")); ?>',
            message: '<?php echo e(__("Column selector feature will be added")); ?>',
            confirmText: '<?php echo e(__("OK")); ?>',
            cancelText: '',
            type: 'info',
            onConfirm: function() {},
            onCancel: function() {}
        });
    }

    // State management functions
    function showLoadingState() {
        $('#loadingState').removeClass('d-none');
        $('#summaryCards').addClass('d-none');
        $('#chartsRow').addClass('d-none');
        $('#mileageTableCard').addClass('d-none');
        $('#noMileageTableCard').addClass('d-none');
        $('#noDataState').addClass('d-none');
        $('#noMonitoringState').addClass('d-none');
    }

    function hideLoadingState() {
        $('#loadingState').addClass('d-none');
    }

    function showNoDataState() {
        $('#noDataState').removeClass('d-none');
        $('#summaryCards').addClass('d-none');
        $('#chartsRow').addClass('d-none');
        $('#mileageTableCard').addClass('d-none');
        $('#noMileageTableCard').addClass('d-none');
        $('#noMonitoringState').addClass('d-none');
    }

    function showNoMonitoringState() {
        $('#noMonitoringState').removeClass('d-none');
        $('#summaryCards').addClass('d-none');
        $('#chartsRow').addClass('d-none');
        $('#mileageTableCard').addClass('d-none');
        $('#noMileageTableCard').addClass('d-none');
        $('#noDataState').addClass('d-none');
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views\reports\mileage-tracking.blade.php ENDPATH**/ ?>