<?php
use App\Helpers\Base64Helper;

$get_data = null;
//$get_data = Base64Helper::decode($data);

$did = $get_data != null ? $get_data['did'] : '';
$date = $get_data != null ? $get_data['date'] : date('Y-m-d');
$start_date = $get_data != null ? $get_data['date'] : date('Y-m-d');
$end_date = $get_data != null ? $get_data['date'] : date('Y-m-d');
?>



<?php $__env->startSection('title', __('Parking/Stop Analysis') ); ?>

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <!-- Page header -->
    <div class="page-header d-print-none">
        <div class="container-xl">
            <div class="row g-2 align-items-center">
                <div class="col">
                    <div class="page-pretitle">
                        <a href="/reports" class="text-muted"><?php echo e(__('Reports')); ?></a> / <?php echo e(__('Operational Reports')); ?>

                    </div>
                    <h2 class="page-title">
                        <i class="ti ti-parking me-2"></i>
                        <?php echo e(__('Parking/Stop Analysis')); ?>

                    </h2>
                </div>
                <div class="col-auto ms-auto d-print-none">
                    <div class="btn-list">
                        <button class="btn btn-primary" onclick="printReport()">
                            <i class="ti ti-printer me-2"></i>
                            <?php echo e(__('Print')); ?>

                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Page body -->
    <div class="page-body">
        <div class="container-xl">
            <!-- Filtreler -->
            <div class="card filter-card mb-3">
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-3">
                            <label class="form-label"><?php echo e(__('Vehicle Selection')); ?></label>
                            <select class="form-select" id="vehicleSelect">
                                <option value=""><?php echo e(__('All Vehicles')); ?></option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label"><?php echo e(__('Start Date')); ?></label>
                            <input type="date" class="form-control" id="startDate" value="<?php echo e($start_date); ?>">
                        </div>
                        <div class="col-md-3">
                            <label class="form-label"><?php echo e(__('End Date')); ?></label>
                            <input type="date" class="form-control" id="endDate" value="<?php echo e($end_date); ?>">
                        </div>
                        <div class="col-md-3">
                            <label class="form-label"><?php echo e(__('Min. Stop Duration (min)')); ?></label>
                            <input type="number" class="form-control" id="minDuration" value="5" min="1">
                            <small class="form-hint"><?php echo e(__('Only stops longer than this duration will be shown')); ?></small>
                        </div>
                        <div class="col-12">
                            <button class="btn btn-primary" onclick="loadParkingData()">
                                <i class="ti ti-search me-2"></i>
                                <?php echo e(__('Update Report')); ?>

                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Loading State -->
            <div class="text-center py-4 d-none" id="loadingState">
                <div class="spinner-border text-primary" role="status">
                    <span class="visually-hidden"><?php echo e(__('Loading...')); ?></span>
                </div>
                <div class="mt-2"><?php echo e(__('Generating parking analysis report...')); ?></div>
            </div>

            <!-- Özet Kartları -->
            <div class="row row-cards mb-3">
                <div class="col-sm-6 col-lg-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="subheader"><?php echo e(__('Total Stops')); ?></div>
                            </div>
                            <div class="h1 mb-0" id="totalStops">-</div>
                            <div class="text-muted" style="padding-top: 19px;">

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="subheader"><?php echo e(__('Total Stop Duration')); ?></div>
                            </div>
                            <div class="h1 mb-0" id="totalDuration">-</div>
                            <div class="text-muted" id="percentParked">-</div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="subheader"><?php echo e(__('Average Stop')); ?></div>
                            </div>
                            <div class="h1 mb-0" id="avgDuration">-</div>
                            <div class="text-muted" id="medianDuration">-</div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="subheader"><?php echo e(__('Long Park')); ?></div>
                            </div>
                            <div class="h1 mb-0" id="longestStop">-</div>
                            <div class="text-muted" id="longParkThreshold">-</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Zaman Çizelgesi -->
            <div class="card mb-3">
                <div class="card-header">
                    <h3 class="card-title"><?php echo e(__('Daily Movement Timeline')); ?></h3>
                </div>
                <div class="card-body">
                    <div id="timelineChart"></div>
                </div>
            </div>

            <!-- Harita ve Tablo -->
            <div class="row">
                <div class="col-lg-6">
                    <div class="card mb-3">
                        <div class="card-header">
                            <h3 class="card-title"><?php echo e(__('Park Locations')); ?></h3>
                            <div class="card-actions">
                                <a href="#" class="btn btn-sm" onclick="toggleMapView()">
                                    <i class="ti ti-maximize"></i>
                                </a>
                            </div>
                        </div>
                        <div class="card-body p-0">
                            <div id="parkingMap"></div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="card mb-3">
                        <div class="card-header">
                            <h3 class="card-title"><?php echo e(__('Top 10 Longest Stops')); ?></h3>
                        </div>
                        <div class="card-body">
                            <div id="durationChart"></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Detaylı Tablo -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><?php echo e(__('Stop Details')); ?></h3>
                    <div class="card-actions">
                        <div class="btn-list">
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div id="parking-table"></div>
                </div>
            </div>

            <!-- No Data State -->
            <div class="text-center py-4 d-none" id="noDataState">
                <div class="empty">
                    <div class="empty-img">
                        <i class="ti ti-parking text-muted" style="font-size: 3rem;"></i>
                    </div>
                    <p class="empty-title"><?php echo e(__('No parking data found')); ?></p>
                    <p class="empty-subtitle text-muted">
                        <?php echo e(__('No parking or stop data was found for the selected period.')); ?>

                    </p>
                </div>
            </div>
        </div>
    </div>

</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<style>
    #parkingMap {
        height: 400px;
    }

    .parking-marker .map-icon-label {
        background-color: transparent !important;
        font-size: 15px !important;
        font-weight: 500 !important;
        color: #fff !important;
        padding: 0 !important;
        margin: 0 !important;
        border-radius: 0 !important;
        border: 0 !important;
    }

    .tabulator-cell[tabulator-field="duration"] {
        font-weight: 600;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script>
    let tableParking;
    let myMap;
    let timelineChart;
    var speedUnit = '';
    var lengthUnit = '';
    var liquidUnit = '';
    var currency = '';

    onAppReady(function() {       
        
        loadVehicles()
        .then(initializeMap)
        .then(initializeTable)
        .then(initializeChart)
        .then(initializeTimelineChart)
        .then(loadParkingData);

    });

    // Harita başlatma
    async function initializeMap() {
        myMap = new LeafletMap();
        myMap.initMap("parkingMap", {
            //zoomLevelDefault: 12 // opsiyonel ayar, default zoom
        });
    }

    // Tablo başlatma
    async function initializeTable() {
        tableParking = createTabulator("#parking-table", {
            initialSort: [
                {column: "duration_minutes", dir: "desc"}
            ],
            columns: [
                {title: "#", field: "id", width: 50, hozAlign: "center"},
                {
                    title: "<?php echo e(__('Start')); ?>", 
                    field: "start_time",
                    sorter: "datetime", 
                    formatter: function(cell) {
                        return dateTimeFormatter(cell.getValue());
                    }
                },
                {
                    title: "<?php echo e(__('End')); ?>", 
                    field: "end_time", 
                    sorter: "datetime", 
                    formatter: function(cell) {
                        return dateTimeFormatter(cell.getValue());
                    }
                },
                {
                    title: "<?php echo e(__('Duration')); ?>", 
                    field: "duration", 
                    hozAlign: "center", 
                    formatter: function(cell) {
                        const minutes = cell.getData().duration_minutes;
                        const durationText = formatDuration(minutes);
                        
                        if (minutes >= 60) {
                            return `<span class="badge text-white bg-red">${durationText}</span>`;
                        } else if (minutes >= 30) {
                            return `<span class="badge text-white bg-orange">${durationText}</span>`;
                        } else if (minutes >= 10) {
                            return `<span class="badge text-white bg-yellow">${durationText}</span>`;
                        } else {
                            return `<span class="badge text-white bg-green">${durationText}</span>`;
                        }
                    }
                },
                {title: "<?php echo e(__('Status')); ?>", field: "status", hozAlign: "center",
                    formatter: function(cell) {
                        const status = cell.getValue();
                        const statusMap = {
                            'stopping': `<span class="badge text-white bg-red"><?php echo e(__('Park')); ?></span>`,
                            'waiting': `<span class="badge text-white bg-yellow"><?php echo e(__('Wait')); ?></span>`,
                            'engine_off': `<span class="badge text-white bg-dark"><?php echo e(__('Engine Off')); ?></span>`
                        };
                        return statusMap[status] || status;
                    }
                },
                {title: "<?php echo e(__('Location')); ?>", field: "location", 
                    formatter: function(cell) {
                        const data = cell.getData();
                        return `<a href="#" onclick="showLocationOnMap(${data.lat}, ${data.lon})"><?php echo e(__('See on map')); ?></a>`;
                    }
                },
                {title: "<?php echo e(__('Latitude')); ?>", field: "lat", width: 100, visible: false},
                {title: "<?php echo e(__('Longitude')); ?>", field: "lon", width: 100, visible: false},
                {title: "<?php echo e(__('Note')); ?>", field: "note", width: 150, editor: "input"}
            ]
        });
    }

    // Grafik başlatma
    async function initializeChart() {
        window.durationChart = new ApexCharts(document.getElementById('durationChart'), {
            chart: {
                type: 'bar',
                height: 368,
                toolbar: {
                    show: false
                }
            },
            series: [{
                name: '<?php echo e(__('Stop Duration (min)')); ?>',
                data: []
            }],
            xaxis: {
                categories: [],
                labels: {
                    rotate: -45,
                    rotateAlways: false,
                    maxHeight: 60
                }
            },
            yaxis: {
                title: {
                    text: '<?php echo e(__('Minute')); ?>'
                },
                labels: {
                    formatter: function(value) {
                        return formatDuration(value);
                    }
                }
            },
            colors: ['#ef4444'],
            plotOptions: {
                bar: {
                    borderRadius: 4,
                    dataLabels: {
                        position: 'top'
                    }
                }
            },
            dataLabels: {
                enabled: true,
                formatter: function(val) {
                    return formatDuration(val);
                },
                style: {
                    fontSize: '12px',
                    colors: ['#304758']
                }
            },
            tooltip: {
                y: {
                    formatter: function(value) {
                        return formatDuration(value);
                    }
                }
            },
            legend: {
                show: false
            }
        });
        
        window.durationChart.render();
    }

    // Timeline chart başlatma
    async function initializeTimelineChart() {
        try {
    
            
            timelineChart = new ApexCharts(document.getElementById('timelineChart'), {
                chart: {
                    type: 'bar',
                    height: 250,
                    stacked: true,
                    toolbar: {
                        show: false
                    }
                },
                series: [
                    {
                        name: '<?php echo e(__("Moving")); ?>',
                        data: []
                    },
                    {
                        name: '<?php echo e(__("Parking")); ?>',
                        data: []
                    },
                    {
                        name: '<?php echo e(__("Engine Off")); ?>',
                        data: []
                    }
                ],
                xaxis: {
                    type: 'datetime',
                    labels: {
                        format: 'HH:mm',
                        rotate: -45,
                        rotateAlways: false
                    },
                    title: {
                        text: '<?php echo e(__("Time")); ?>'
                    }
                },
                yaxis: {
                    title: {
                        text: '<?php echo e(__("Duration (min)")); ?>'
                    },
                    max: 60, // Max 60 minutes per hour
                    labels: {
                        formatter: function(value) {
                            return formatDuration(value);
                        }
                    }
                },
                colors: ['#10b981', '#ef4444', '#6b7280'],
                plotOptions: {
                    bar: {
                        horizontal: false,
                        borderRadius: 4
                    }
                },
                dataLabels: {
                    enabled: false
                },
                tooltip: {
                    x: {
                        format: 'dd MMM yyyy HH:mm'
                    },
                    y: {
                        formatter: function(value, { series, seriesIndex, dataPointIndex, w }) {
                            const seriesNames = ['<?php echo e(__("Moving")); ?>', '<?php echo e(__("Parking")); ?>', '<?php echo e(__("Engine Off")); ?>'];
                            const seriesName = seriesNames[seriesIndex];
                            return `${seriesName}: ${formatDuration(value)}`;
                        }
                    }
                },
                legend: {
                    position: 'top'
                }
            });
            
            timelineChart.render();
    
        } catch (error) {
            console.error('Error initializing timeline chart:', error);
        }
    }

    // Load vehicles for dropdown
    async function loadVehicles() {
        http.post({
            url: "/api/vehicles/list",
        }).then((response) => {
            if(response.success && response.data && response.data.vehicles){

                var vehicles = response.data.vehicles || [];
                
                const vehicleSelect = document.getElementById('vehicleSelect');
                // Clear existing options except "All Vehicles"
                vehicleSelect.innerHTML = '<option value=""><?php echo e(__("All Vehicles")); ?></option>';
                
                // Add vehicle options
                vehicles.forEach(vehicle => {
                    const option = document.createElement('option');
                    option.value = vehicle.did;
                    option.textContent = vehicle.name;
                    vehicleSelect.appendChild(option);
                });    
            }
        });
    }

    // Park verilerini yükle
    async function loadParkingData() {
        // API'den veri çek
        const vehicleId = document.getElementById('vehicleSelect').value;
        const startDate = document.getElementById('startDate').value;
        const endDate = document.getElementById('endDate').value;
        const minDuration = document.getElementById('minDuration').value;

        // Show loading state
        $('#loadingState').removeClass('d-none');
        $('.card').addClass('d-none');
        $('#noDataState').addClass('d-none');
        $('.filter-card').removeClass('d-none');

        // Fetch parking data
        http.post({
            url: '/api/reports/parking-analysis',
            data: {
                vehicle: vehicleId,
                start_date: startDate,
                end_date: endDate,
                min_duration: minDuration
            },
            loading: true
        }).then(function(response) {
            // Hide loading state
            $('#loadingState').addClass('d-none');

            console.log("response.data", response.data);

            var message = __('#name# used #value# records').replace('#name#', __('Parking Analysis')).replace('#value#', response.data.data.length);
            showReportDataProcessingInfo(message);
            
            if (response.success) {
                // Set units after data is loaded
                speedUnit = __(sessionSettings.speedUnit || 'km/h');
                lengthUnit = __(sessionSettings.lengthUnit || 'km');
                liquidUnit = __(sessionSettings.liquidUnit || 'lt');
                currency = __(sessionSettings.currency || 'TRY');
                const _parkingData = response.data.data;

                const parkingData = processVehicleData(_parkingData, minDuration);
                //console.log("parkingData", parkingData);
                if (parkingData.length > 0) {
                    tableParking.setData(parkingData);
                    updateMap(parkingData);
                    updateChart(parkingData);
                    // Update summary stats
                    updateSummaryStats(parkingData);
                    // Update timeline
                    updateTimeline(_parkingData);
                    $('.card').removeClass('d-none');
                    $('#noDataState').addClass('d-none');
                } else {
                    $('.card').addClass('d-none');
                    $('#noDataState').removeClass('d-none');
                    $('.filter-card').removeClass('d-none');
                }
            } else {
                // handle error
                showConfirmDialog({
                    title: __('Warning'),
                    message: __('Data not found'),
                    confirmText: __('OK'),
                    cancelText: '',
                    type: 'warning',
                    onConfirm: function() {},
                    onCancel: function() {}
                });
            }
        }).catch(function(error) {
            // Hide loading state on error
            $('#loadingState').addClass('d-none');
            
            showConfirmDialog({
                title: __('Warning'),
                message: __('Error fetching data'),
                confirmText: __('OK'),
                cancelText: '',
                type: 'warning',
                onConfirm: function() {},
                onCancel: function() {}
            });
        });
    }

    // Haritayı güncelle
    function updateMap(data) {
        myMap.removeMarkers();
        // Build an array of marker models
        const markerModels = data.map(function(parking) {
            
            return {
                id: rand_id(),
                markerClassName: "parking-marker",
                label: `<div class="badge text-white bg-${parking.duration_minutes >= 30 ? 'red' : 'yellow'}">${formatDuration(parking.duration_minutes)}</div>`,
                popup: `
                    <strong>${parking.address}</strong><br>
                    <?php echo e(__('Start')); ?>: ${ dateTimeFormatter(parking.start_time) }<br>
                    <?php echo e(__('Duration')); ?>: ${formatDuration(parking.duration_minutes)}<br>
                    ${parking.note ? '<?php echo e(__('Note')); ?>: ' + parking.note : ''}
                `,
                coord: [(parking.lat * 1), (parking.lon * 1)],
                icon: {
                    name: "ti ti-arrow-bar-up",
                    color: parking.duration_minutes >= 30 ? 'red' : 'yellow',
                    direction: 0,
                    className: "custom-div-icon", 
                }
            };
        });

        if (markerModels.length > 0) {
            // Pass the array to pinMarkers
            myMap.pinMarkers(markerModels);

            // Add regions and places to the map
            addRegionsAndPlacesToMap();

            myMap.fitBounds();
            setTimeout(() => {
                //refresh map
                myMap.mapLet.invalidateSize();
            }, 100);
        }
    }

    // Grafiği güncelle
    function updateChart(data) {
        // En uzun 10 durmayı al
        const top10 = data.sort((a, b) => b.duration_minutes - a.duration_minutes).slice(0, 10);
        
        window.durationChart.updateOptions({
            xaxis: {
                categories: top10.map(p => p.address.substring(0, 15) + '...')
            }
        });
        
        window.durationChart.updateSeries([{
            name: '<?php echo e(__('Stop Duration (min)')); ?>',
            data: top10.map(p => p.duration_minutes)
        }]);
    }

    // Haritada konumu göster
    function showLocationOnMap(lat, lon) {
        myMap.mapLet.setView([lat, lon], 16);
        // Popup'ı aç
        myMap.mapLet.eachLayer(function(marker) {
            if (marker.getLatLng && marker.getLatLng().lat === lat && marker.getLatLng().lng === lon) {
                marker.openPopup();
            }
        });
    }

    // Kolon görünürlüğü
    function toggleColumns() {
        // Kolon seçici modal göster
        showConfirmDialog({
            title: __('Warning'),
            message: __('Column selector feature will be added'),
            confirmText: __('OK'),
            cancelText: '',
            type: 'warning',
            onConfirm: function() {},
            onCancel: function() {}
        });
    }

    // Rapor dışa aktarma
    function exportReport(format) {
        if (format === 'pdf') {
            window.print();
        } else if (format === 'excel') {
            tableParking.download("xlsx", "<?php echo e(__('Stop-Park-Analysis')); ?>.xlsx");
        }
    }

    // Yazdır
    function printReport() {
        window.print();
    }

    // Harita tam ekran
    function toggleMapView() {
        document.getElementById('parkingMap').requestFullscreen();
    }

    // Data model adapter functions
function parseLogData(logDataString) {
    try {
        return JSON.parse(logDataString);
    } catch (e) {
        return null;
    }
}

function processVehicleData(rawData, minDuration = 1) {

    // Filter out records without location data
    const validRecords = rawData.filter(record => 
        record.latitude && record.longitude && record.dtx && record.log_data
    );

    // Sort by datetime
    validRecords.sort((a, b) => new Date(a.dtx) - new Date(b.dtx));

    // Group by vehicle and detect stops
    const parkingData = [];
    let currentStop = null;

    for (let i = 0; i < validRecords.length; i++) {
        const record = validRecords[i];
        const logData = parseLogData(record.log_data);
        
        if (!logData) continue;

        const isStationary = logData.hiz === 0; // Speed is 0
        const engineOn = logData.drm && logData.drm[0] === 1; // Engine status from drm array

        if (isStationary && currentStop === null) {
            // Start of a new stop
            currentStop = {
                id: parkingData.length + 1,
                vehicle_id: record.vehicle_id,
                vehicle_name: record.vehicle_name,
                did: record.did,
                start_time: record.dtx,
                start_lat: parseFloat(record.latitude),
                start_lng: parseFloat(record.longitude),
                lat: parseFloat(record.latitude),
                lon: parseFloat(record.longitude), // Note: using 'lon' to match your table structure
                end_time: null,
                duration_minutes: 0,
                status: engineOn ? 'stopping' : 'engine_off',
                address: `${record.latitude}, ${record.longitude}`, // You might want to reverse geocode this
                note: '',
                mileage: logData.mes || 0,
                direction: logData.yon || 0
            };
        } else if (isStationary && currentStop !== null) {
            // Continue current stop - update end time
            currentStop.end_time = record.dtx;
            currentStop.duration_minutes = Math.round(
                (new Date(record.dtx) - new Date(currentStop.start_time)) / (1000 * 60)
            );
            
            // Update status based on engine state
            if (!engineOn) {
                currentStop.status = 'engine_off';
            }
        } else if (!isStationary && currentStop !== null) {
            // End of current stop
            currentStop.end_time = currentStop.end_time || record.dtx;
            currentStop.duration_minutes = Math.round(
                (new Date(currentStop.end_time) - new Date(currentStop.start_time)) / (1000 * 60)
            );
            
            // Only add stops that meet minimum duration filter
            if (currentStop.duration_minutes >= minDuration) {
                parkingData.push(currentStop);
            }
            
            currentStop = null;
        }
    }

    // Handle case where data ends while vehicle is still stopped
    if (currentStop !== null) {
        const lastRecord = validRecords[validRecords.length - 1];
        currentStop.end_time = lastRecord.dtx;
        currentStop.duration_minutes = Math.round(
            (new Date(currentStop.end_time) - new Date(currentStop.start_time)) / (1000 * 60)
        );
        
        if (currentStop.duration_minutes >= minDuration) {
            parkingData.push(currentStop);
        }
    }

    return parkingData;
}
// Add summary stats update function
function updateSummaryStats(parkingData) {
    const totalStops = parkingData.length;
    const totalDuration = parkingData.reduce((sum, stop) => sum + stop.duration_minutes, 0);
    const avgDuration = totalStops > 0 ? Math.round(totalDuration / totalStops) : 0;
    const longestStop = totalStops > 0 ? Math.max(...parkingData.map(s => s.duration_minutes)) : 0;
    
    // Calculate median duration
    const durations = parkingData.map(s => s.duration_minutes).sort((a, b) => a - b);
    const medianDuration = durations.length > 0 ? 
        durations.length % 2 === 0 ? 
            Math.round((durations[durations.length/2 - 1] + durations[durations.length/2]) / 2) :
            durations[Math.floor(durations.length/2)] : 0;
    
    // Count long parks (over 30 minutes)
    const longParks = parkingData.filter(s => s.duration_minutes >= 30).length;
    
    // Calculate total duration in hours and minutes
    const totalHours = Math.floor(totalDuration / 60);
    const totalMinutes = totalDuration % 60;
    const totalDurationText = formatDuration(totalDuration);
    
    // Calculate percentage of time parked (assuming 24 hours = 1440 minutes)
    const totalTimeInRange = 1440; // 24 hours in minutes
    const percentParked = totalTimeInRange > 0 ? Math.round((totalDuration / totalTimeInRange) * 100) : 0;

    // Update summary cards
    $('#totalStops').text(totalStops);
    $('#totalDuration').text(totalDurationText);
    $('#avgDuration').text(formatDuration(avgDuration));
    $('#longestStop').text(longParks);
    
    // Update the median text in the Average Stop card
    $('#medianDuration').text(`<?php echo e(__('Median')); ?>: ${formatDuration(medianDuration)}`);
    
    // Update the percentage text in the Total Stop Duration card
    $('#percentParked').text(`%${percentParked} <?php echo e(__('parked')); ?>`);
    
    // Update the long parks threshold text
    $('#longParkThreshold').text(`<?php echo e(__('Over 30 min')); ?>`);
}

// Helper function to format duration in hours and minutes
function formatDuration(minutes) {
    if (minutes < 60) {
        return `${minutes} <?php echo e(__('min')); ?>`;
    } else {
        const hours = Math.floor(minutes / 60);
        const mins = minutes % 60;
        if (mins === 0) {
            return `${hours} <?php echo e(__('hour')); ?>`;
        } else {
            return `${hours} <?php echo e(__('hour')); ?> ${mins} <?php echo e(__('min')); ?>`;
        }
    }
}

// Dynamic timeline calculation and display
function updateTimeline(rawData) {
    // Check if timelineChart is initialized
    if (!timelineChart) {
        console.error('Timeline chart is not initialized');
        return;
    }

    

    if (!rawData || rawData.length === 0) {
        // Clear chart data
        timelineChart.updateOptions({
            xaxis: {
                type: 'datetime',
                categories: []
            }
        });
        
        timelineChart.updateSeries([
            { name: '<?php echo e(__("Moving")); ?>', data: [] },
            { name: '<?php echo e(__("Parking")); ?>', data: [] },
            { name: '<?php echo e(__("Engine Off")); ?>', data: [] }
        ]);
        

        return;
    }

    // Filter and sort records by time
    const validRecords = rawData.filter(record => 
        record.latitude && record.longitude  && record.dtx && record.log_data
    ).sort((a, b) => new Date(a.dtx) - new Date(b.dtx));

    

    if (validRecords.length === 0) {
        timelineChart.updateOptions({
            xaxis: {
                type: 'datetime',
                categories: []
            }
        });
        
        timelineChart.updateSeries([
            { name: '<?php echo e(__("Moving")); ?>', data: [] },
            { name: '<?php echo e(__("Parking")); ?>', data: [] },
            { name: '<?php echo e(__("Engine Off")); ?>', data: [] }
        ]);
        

        return;
    }

    // Get date range from filters
    const startDate = new Date(document.getElementById('startDate').value);
    const endDate = new Date(document.getElementById('endDate').value);
    
    
    
    // Create hourly buckets for the entire date range
    const hourlyData = {};
    const currentDate = new Date(startDate);
    
    while (currentDate <= endDate) {
        for (let hour = 0; hour < 24; hour++) {
            const hourKey = new Date(currentDate);
            hourKey.setHours(hour, 0, 0, 0);
            hourlyData[hourKey.getTime()] = {
                moving: 0,
                parking: 0,
                engineOff: 0
            };
        }
        currentDate.setDate(currentDate.getDate() + 1);
    }

    // Process records and aggregate by hour
    for (let i = 0; i < validRecords.length; i++) {
        const record = validRecords[i];
        const logData = parseLogData(record.log_data);
        
        if (!logData) continue;

        const recordTime = new Date(record.dtx);
        const isStationary = logData.hiz === 0;
        const engineOn = logData.drm && logData.drm[0] === 1;
        
        // Round to hour
        const hourKey = new Date(recordTime);
        hourKey.setMinutes(0, 0, 0);
        const hourTimestamp = hourKey.getTime();
        
        if (hourlyData[hourTimestamp]) {
            if (isStationary) {
                if (engineOn) {
                    hourlyData[hourTimestamp].parking += 1; // 1 minute per record
                } else {
                    hourlyData[hourTimestamp].engineOff += 1;
                }
            } else {
                hourlyData[hourTimestamp].moving += 1;
            }
        }
        

    }

    // Prepare chart data
    const labels = [];
    const movingData = [];
    const parkingData = [];
    const engineOffData = [];

    Object.keys(hourlyData).sort().forEach(timestamp => {
        const date = new Date(parseInt(timestamp));
        labels.push(date.getTime()); // Use timestamp for ApexCharts datetime
        
        const data = hourlyData[timestamp];
        movingData.push(data.moving);
        parkingData.push(data.parking);
        engineOffData.push(data.engineOff);
    });

    try {
        // Update chart with datetime data
        timelineChart.updateOptions({
            xaxis: {
                type: 'datetime',
                categories: labels
            }
        });
        
        timelineChart.updateSeries([
            {
                name: '<?php echo e(__("Moving")); ?>',
                data: movingData
            },
            {
                name: '<?php echo e(__("Parking")); ?>',
                data: parkingData
            },
            {
                name: '<?php echo e(__("Engine Off")); ?>',
                data: engineOffData
            }
        ]);
        
    } catch (error) {
        console.error('Error updating timeline chart:', error);
    }
}

// Add regions and places to the map
function addRegionsAndPlacesToMap() {
    // Load regions and places data
    http.post({
        url: '/regions-list',
        loading: false
    }).then(function(regionsResponse) {
        if (regionsResponse.success && regionsResponse.data) {
            const regions = regionsResponse.data;
            
            // Add regions to map
            regions.forEach(function(region) {
                if (region.polygon_json) {
                    myMap.addPolygon({
                        id: region.id,
                        label: region.name,
                        color: "gray",
                        fillColor: "gray",
                        coords: region.polygon_json,
                    });
                }
            });
        }
    }).catch(function(error) {
        console.error('Error loading regions:', error);
    });

    // Load places data
    http.post({
        url: '/places-list',
        loading: false
    }).then(function(placesResponse) {
        if (placesResponse.success && placesResponse.data) {
            const places = placesResponse.data;
            
            // Add places to map
            var placeMarkerColor = "gray";
            places.forEach(function(place) {
                if (place.latitude && place.longitude) {
                    var marker = [
                        {
                            id: place.id,
                            markerClassName: "place-marker",
                            device_id: 0,
                            label: place.name,
                            status: place.status_id,
                            popup: place.name,
                            coord: [
                                parseFloat(place.latitude),
                                parseFloat(place.longitude),
                            ],
                            icon: {
                                name: "fa-solid fa-location-dot",
                                color: placeMarkerColor,
                                direction: 0,
                                className: "",
                            },
                        },
                    ];
                    myMap.pinMarkers(marker); // add markers to the map
                    
                    // Add circle if radius is defined
                    if (place.radius && place.radius > 0) {
                        var circle = L.circle([place.latitude, place.longitude], {
                            radius: place.radius,
                            color: placeMarkerColor,
                            fillColor: placeMarkerColor,
                            fillOpacity: 0.2,
                        }).addTo(myMap.mapLet);
                    }
                }
            });
        }
    }).catch(function(error) {
        console.error('Error loading places:', error);
    });
}
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views\reports\parking-analysis.blade.php ENDPATH**/ ?>