<label class="form-label"><?php echo e(__('You can choose a category for your vehicle.')); ?></label>



<div id="categoriesList"></div>

<script>
    var categoriesListData = [];
    var currentCategoryId = null;
    // Load categories data
    function initCategories() {
        loadCategories();
    }

    function loadCategories() {
        var deviceId = $("#device_id").val();
        
        http.post({
            url: "/categories-list",
            data: {
                device_id: deviceId
            }
        }).then((response) => {
            var data = response.data;
            
            // Ensure device_categoty_match is properly set for each category
            data.forEach(function(category) {
                if (category.device_categoty_match === null || category.device_categoty_match === undefined) {
                    category.device_categoty_match = 0;
                }
            });
            
            categoriesList(data);
            categoriesListData = data;
        });
    }

    // Create Tabulator for categories
    function categoriesList(data) {
        var table = createTabulator("#categoriesList", {
            buttons: [
                {
                    label: __("Add New Category"),
                    icon: "fas fa-plus",
                    icon_color: "success",
                    func: addNewCategory,
                },
            ],
            data: data,
            movableRows: true,
            rowHeader: {
                headerSort: false,
                resizable: false,
                minWidth: 30,
                width: 30,
                rowHandle: true,
                formatter: "handle",
            },
            columns: [
                {
                    title: "<?php echo e(__('Name')); ?>",
                    field: "name",
                    editor: "input",
                    minWidth: 200,
                    validator: "required",
                    formatter: function (cell) {
                        var value = cell.getValue();
                        var row = cell.getRow();
                        var data = row.getData();
                        
                        var html = '<div class="d-flex align-items-center">';
                        html += '<div class="flex-fill">';
                        html += '<div class="font-weight-medium">' + value + '</div>';
                        if (data.description) {
                            html += '<div class="text-muted small">' + data.description + '</div>';
                        }
                        html += '</div>';
                        html += '</div>';
                        
                        return html;
                    },
                },
                {
                    title: "<?php echo e(__('Vehicles')); ?>",
                    field: "device_count",
                    width: 100,
                    hozAlign: "center",
                    formatter: function (cell) {
                        var count = cell.getValue() || 0;
                        return '<span class="badge text-white bg-blue">' + count + '</span>';
                    },
                },
                {
                    title: "<?php echo e(__('Assignment')); ?>",
                    field: "device_categoty_match",
                    width: 120,
                    headerSort: false,
                    formatter: function (cell) {
                        var value = cell.getValue();
                        return value == 1
                            ? `<label class="form-check form-switch toggle-assignment-btn" 
                                    title="${__("Toggle Assignment")}" data-status="0">
                                <input class="form-check-input bg-lime" type="checkbox" checked="checked">
                                <span class="form-check-label">
                                    ${__("Assigned")}</span>
                            </label>`
                            : `<label class="form-check form-switch toggle-assignment-btn" 
                                title="${__("Toggle Assignment")}" data-status="1">
                                <input class="form-check-input bg-red" type="checkbox">
                                <span class="form-check-label">
                                    ${__("Not Assigned")}</span>
                            </label>`;
                    },
                    cellClick: function (e, cell) {
                        e.stopPropagation();
                        e.preventDefault();

                        if (e.target.closest(".toggle-assignment-btn")) {
                            var newStatus = e.target
                                .closest(".toggle-assignment-btn")
                                .getAttribute("data-status");
                            var rowData = cell.getRow().getData();

                            clearTimeout(cell._assignmentToggleTimeout);
                            cell._assignmentToggleTimeout = setTimeout(function () {
                                toggleVehicleCategoryAssignment(
                                    cell.getRow(),
                                    rowData,
                                    newStatus
                                );
                            }, 100);
                        }
                    },
                },
                                 {
                     title: "<?php echo e(__('Action')); ?>",
                     width: 150,
                     headerSort: false,
                     formatter: function () {
                         return `
                             <div class="btn-group" role="group">
                                 <button class="btn btn-sm btn-outline-success px-2 py-1 duplicate-row-btn" 
                                     title="${__("Duplicate")}">
                                     <i class="fas fa-copy"></i>
                                 </button>
                                 <button class="btn btn-sm btn-outline-danger px-2 py-1 delete-row-btn" 
                                     title="${__("Delete")}">
                                     <i class="fas fa-trash"></i>
                                 </button>
                             </div>
                         `;
                     },
                     cellClick: function (e, cell) {
                         var rowData = cell.getRow().getData();

                         if (e.target.closest(".duplicate-row-btn")) {
                             duplicateCategoryRow(rowData);
                         } else if (e.target.closest(".delete-row-btn")) {
                             deleteCategoryRow(cell.getRow(), rowData);
                         }
                     },
                 },
            ],
        });

        table.on("rowMoved", function (row) {
            updateCategoryOrder(table.getData());
        });

        table.on("cellEdited", function (cell) {
            var rowData = cell.getRow().getData();
            updateCategoryData(rowData);
        });

        window.categoriesTable = table;
        return table;
    }

    // CRUD Functions

    function addNewCategory() {
        var newCategory = {
            name: __("New Category"),
            description: "",
            sts: 1,
            ord: null,
        };

        const postModel = Base64Helper.encode(newCategory);

        http.post({
            url: "/category-add",
            data: {
                data: postModel,
            },
        })
            .then((response) => {
                if (response.success) {
                    var row = window.categoriesTable.addRow(response.data, true);
                    categoriesListData.push(response.data);
                    showNotification("success", __("Category added successfully"));
                } else {
                    showNotification("error", __("Error adding category"));
                }
            })
            .catch((error) => {
                console.error("Add error:", error);
                showNotification("error", __("Error adding category"));
            });
    }



    function duplicateCategoryRow(rowData) {
        var duplicatedCategory = {
            id: rowData.id,
            name: rowData.name + " (" + __("Copy") + ")",
            description: rowData.description,
            sts: rowData.sts,
            ord: null,
        };

        const postModel = Base64Helper.encode(duplicatedCategory);

        http.post({
            url: "/category-duplicate",
            data: {
                data: postModel,
            },
        })
            .then((response) => {
                if (response.success) {
                    var row = window.categoriesTable.addRow(response.data, true);
                    showNotification("success", __("Category duplicated successfully"));
                } else {
                    showNotification("error", __("Error duplicating category"));
                }
            })
            .catch((error) => {
                console.error("Duplicate error:", error);
                showNotification("error", __("Error duplicating category"));
            });
    }

    function deleteCategoryRow(row, rowData) {
        var vehicleCount = rowData.device_count || 0;
        var message = __("Are you sure you want to delete") + " : " + rowData.name;
        
        if (vehicleCount > 0) {
            message += "\n\n" +  __("This category is assigned to #vehicleCount# vehicle(s)").replace("#vehicleCount#", vehicleCount) + ".\n" + __("Would you like to delete the category and remove all vehicle assignments?");
        }

        showConfirmDialog({
            title: __("Delete Category"),
            message: message,
            confirmText: __("Delete"),
            cancelText: __("Cancel"),
            type: "danger",
            onConfirm: function () {
                const postModel = Base64Helper.encode({ 
                    id: rowData.id,
                    device_count: vehicleCount
                });

                http.post({
                    url: "/category-delete",
                    data: {
                        data: postModel,
                    },
                })
                    .then((response) => {
                        if (response.success) {
                            row.delete();
                            showNotification("success", __("Category deleted successfully"));
                        } else {
                            showNotification("error", __("Error deleting category"));
                        }
                    })
                    .catch((error) => {
                        console.error("Delete error:", error);
                        showNotification("error", __("Error deleting category"));
                    });
            },
        });
    }

    // Backend Communication Functions

    function updateCategoryData(rowData) {
        const mappedData = {
            id: rowData.id,
            name: rowData.name,
            order: rowData.ord,
            status_id: rowData.sts,
        };

        const postModel = Base64Helper.encode(mappedData);

        http.post({
            url: "/category-edit",
            data: {
                data: postModel,
            },
        })
            .then((response) => {
                if (response.success) {
                    showNotification("success", __("Category updated successfully"));
                } else {
                    showNotification("error", __("Error updating category"));
                }
            })
            .catch((error) => {
                console.error("Update error:", error);
                showNotification("error", __("Error updating category"));
            });
    }

    function updateCategoryOrder(tableData) {
        var orderData = tableData.map(function (row, index) {
            return {
                id: row.id,
                ord: index + 1,
            };
        });

        const postModel = Base64Helper.encode({ orders: orderData });

        http.post({
            url: "/categories-update-order",
            data: {
                data: postModel,
            },
        })
            .then((response) => {
                if (response.success) {
            
                }
            })
            .catch((error) => {
                console.error("Order update error:", error);
            });
    }

    // Toggle vehicle-category assignment function
    function toggleVehicleCategoryAssignment(row, rowData, newStatus) {
        var deviceId = $("#device_id").val();
        
        const postModel = Base64Helper.encode({
            category_id: rowData.id,
            device_id: deviceId,
            status: newStatus,
        });

        http.post({
            url: "/category-set-device",
            data: {
                data: postModel,
            },
        })
            .then((response) => {
                if (response.success) {
                    row.update({ device_categoty_match: parseInt(newStatus) });
                    showNotification("success", __("Vehicle assignment updated successfully"));
                    
                    // Refresh the table to update device counts
                    loadCategories();
                } else {
                    showNotification("error", __("Error updating vehicle assignment"));
                }
            })
            .catch((error) => {
                console.error("Toggle assignment error:", error);
                showNotification("error", __("Error updating vehicle assignment"));
            });
    }

    // Export functions to global scope
    window.addNewCategory = addNewCategory;
    window.duplicateCategoryRow = duplicateCategoryRow;
    window.deleteCategoryRow = deleteCategoryRow;
    window.toggleVehicleCategoryAssignment = toggleVehicleCategoryAssignment;
    window.refreshCategoriesTable = function () {
        http.post({
            url: "/categories-list",
        }).then((response) => {
            window.categoriesTable.setData(response.data);
        });
    };
</script>

<?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views/partials/forms/settings/category.blade.php ENDPATH**/ ?>