<?php
$vehicle = $vehicle ?? [];
?>



<?php $__env->startSection('title', __('Settings') ); ?>

<?php $__env->startSection('content'); ?>
<!-- Page header -->
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <!-- Page pre-title -->
                <div class="page-pretitle">
                    <?php echo e(__('Settings')); ?>

                </div>
                <h2 class="page-title">
                    <?php echo e($vehicle['name'] ?? __('Unknown')); ?>

                </h2>
            </div>
        </div>
    </div>
</div>
<!-- Page body -->
<div class="page-body">
    <div class="container-xl">
        <div class="row row-deck row-cards">
            
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            <i class="icon vertical-center me-1 text-muted ti ti-settings-check"></i>
                            <?php echo e(__('Settings')); ?>

                        </h4>
                    </div>
                    <div class="card-body">
                        <?php echo $__env->make('partials.forms.settings.general', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>
            
            <div class="col-sm-6 col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            <i class="icon vertical-center me-1 text-muted ti ti-category-plus"></i>
                            <?php echo e(__('Categories')); ?>

                        </h4>
                    </div>
                    <div class="card-body">
                        <?php echo $__env->make('partials.forms.settings.category', ['categories' => $categories], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    </div>
                </div>
            </div>
            
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            <i class="icon vertical-center me-1 text-muted ti ti-calendar-exclamation"></i>
                            <?php echo e(__('Vehicle Inspection')); ?>

                        </h4>
                    </div>
                    <div class="card-body">
                        <?php echo $__env->make('partials.forms.settings.inspection', ['inspection' => $alarms], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>
            
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            <i class="icon vertical-center me-1 text-muted ti ti-engine"></i>
                            <?php echo e(__('Engine Blockage')); ?>

                        </h4>
                    </div>
                    <div class="card-body">
                        <?php echo $__env->make('partials.forms.settings.engine_block', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>
            
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            <i class="icon vertical-center me-1 text-muted ti ti-parking-off"></i>
                            <?php echo e(__('Vehicle Being Towed')); ?>

                        </h4>
                    </div>
                    <div class="card-body">
                        <?php echo $__env->make('partials.forms.settings.towed', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>
            
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            <i class="icon vertical-center me-1 text-muted ti ti-brand-speedtest"></i>
                            <?php echo e(__('High Speed ​​Alarm')); ?>

                        </h4>
                    </div>
                    <div class="card-body">
                        <?php echo $__env->make('partials.forms.settings.high_speed', ['alarms' => $alarms], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>
            
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            <i class="icon vertical-center me-1 text-muted ti ti-arrow-iteration"></i>
                            <?php echo e(__('Acceleration/Deceleration Alarm')); ?>

                        </h4>
                    </div>
                    <div class="card-body">
                        <?php echo $__env->make('partials.forms.settings.acceleration_deceleration', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>
            
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            <i class="icon vertical-center me-1 text-muted ti ti-road"></i>
                            <?php echo e(__('Mileage Maintenance')); ?>

                        </h4>
                    </div>
                    <div class="card-body">
                        <?php echo $__env->make('partials.forms.settings.mileage_maintenance', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>
            
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            <i class="icon vertical-center me-1 text-muted ti ti-clock-shield"></i>
                            <?php echo e(__('After-hours use')); ?>

                        </h4>
                    </div>
                    <div class="">
                        <?php echo $__env->make('partials.forms.settings.after_hours', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>
            
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            <i class="icon vertical-center me-1 text-muted ti ti-polygon"></i>
                            <?php echo e(__('Regions')); ?>

                        </h4>
                        <div class="card-actions">
                            <a href="/regions" class="btn btn-primary">
                                <i class="icon vertical-center ti ti-settings-check"></i>
                                <?php echo e(__('Add')); ?> / <?php echo e(__('Edit')); ?>

                            </a>
                        </div>
                    </div>
                    <?php echo $__env->make('partials.forms.settings.region', ['regions' => $regions], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
            
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            <i class="icon vertical-center me-1 text-muted ti ti-map-pin"></i>
                            <?php echo e(__('Places')); ?>

                        </h4>
                        <div class="card-actions">
                            <a href="/places" class="btn btn-primary">
                                <i class="icon vertical-center ti ti-settings-check"></i>
                                <?php echo e(__('Add')); ?> / <?php echo e(__('Edit')); ?>

                            </a>
                        </div>
                    </div>
                    <?php echo $__env->make('partials.forms.settings.places', ['places' => $places], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
            
        </div>
    </div>
</div>
<input type="hidden" id="device_id" value="<?php echo e($vehicle['did'] ?? ''); ?>" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('scripts'); ?>
<script>
    var menuModel = {
        actives : ["report-vehicles"],
        shows: []
    };
    menuSets(menuModel);
    
    onAppReady(function() {
        //init partials scripts
        initVehicleSettingsGeneral();
        initVehicleSettingsEngineBlock();
        initCategories();
    });

    // disable form submit
    $(".alarm-form").on("submit", function(e) {
        e.preventDefault();
    });

    function saveAlarmSettings(alarm_form_id) {
        setTimeout(() => {
            
            // Prepare data and encode with Base64Helper
            // get form data by form id
            const formData = new FormData(document.getElementById("alarmForm_" + alarm_form_id));
            // add device_id to formData
            formData.append("device_id", $("#device_id").val());
            // add alarm_form_id to formData
            formData.append("alarm_form_id", alarm_form_id);
            // formData to Base64Helper.encode
            const postData = Base64Helper.encode(Object.fromEntries(formData.entries()));
            
            http.post({
                url: "/alarm-set-device",
                data: {
                    data: postData
                }
            })
            .then(function(response) {
                if (response.success) {
                    showNotification("success", __(response.message));
                } else {
                    showNotification("error", __(response.message));
                }
            })
            .catch(function(error) {
                console.error("Update error:", error);
                showNotification("error", "<?php echo e(__('Error updating')); ?>");
            });

        }, 100);
    }

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views\vehicle-settings.blade.php ENDPATH**/ ?>