<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Lang;
use App\Http\Controllers\DeviceController;
use App\Http\Controllers\RegionController;
use App\Http\Controllers\PlaceController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\AlarmController;
use App\Http\Controllers\GeneralSettingController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\UserController;
use App\Http\Middleware\JWTAuthMiddleware;
use App\Helpers\PublicHelper;

Route::group(['middleware' => ['guest']], function () {

    /*
    |--------------------------------------------------------------------------
    | Public Routes (Accessible Without Authentication)
    |--------------------------------------------------------------------------
    */
    Route::get('/', function (Request $request) { return redirect('vehicles-map');});

    /*
    |--------------------------------------------------------------------------
    | Authentication Routes (Login & Logout)
    |--------------------------------------------------------------------------
    */
    Route::get('/login', function () { return view('login'); });
    Route::post('/login', [LoginController::class, 'login'])->name('login');

    Route::get('/forgot-password', function () { return view('forgot-password'); });

});
/*
|--------------------------------------------------------------------------
| Protected Routes (Require Authentication)
|--------------------------------------------------------------------------
*/
Route::middleware([JWTAuthMiddleware::class])->group(function () {

    Route::get('/vehicle-map/{data}', function ($data) {
        
        return view('vehicle-map', compact('data'));
    });
    Route::post('/vehicle-map', [DeviceController::class, 'getVehicleMap']);

    Route::get('/vehicles-map', function () { 
        return view('vehicles-map'); 
    })->name('vehicles-map');

    // API Vehicles Map
    // get all required data for vehicles map. categories, regions, places, vehicles
    Route::post('/api/vehicles-map', [DeviceController::class, 'apiVehiclesMap']);

    Route::get('/vehicles-map-cctv', function () { return view('vehicles-map-cctv'); })->name('vehicles-map-cctv');

    // PAGE Vehicles List
    Route::get('/vehicles-list', function () {
        // Controller'dan veri çekmek için:
        $controller = app(\App\Http\Controllers\DeviceController::class);
        $request = request();
        $response = $controller->getVehiclesList($request);
        $data = $response->getData(true);

        // $vehicles değişkenini blade'e gönder
        return view('vehicles-list', [
            'vehicles' => collect($data['data']['vehicles'] ?? [])
        ]);
    });

    Route::get('/vehicle-settings/{data}', function ($data) {

        //Device
        $deviceController = app(\App\Http\Controllers\DeviceController::class);
        $deviceRequest = request()->merge(['data' => $data]);
        $deviceResponse = $deviceController->getVehicle($deviceRequest);
        $vehicle = $deviceResponse->getData(true);
        //Categories
        $categoryController = app(\App\Http\Controllers\CategoryController::class);
        $categoryRequest = request()->merge(['data' => $data]);
        $categoryResponse = $categoryController->list($categoryRequest);
        $categories = $categoryResponse->getData(true);
        //Region
        $regionController = app(\App\Http\Controllers\RegionController::class);
        $regionRequest = request()->merge(['data' => $data]);
        $regionResponse = $regionController->list($regionRequest);
        $regions = $regionResponse->getData(true);
        //Log::info('regions data: ', ['regions' => $regions]);
        //Place
        $placeController = app(\App\Http\Controllers\PlaceController::class);
        $placeRequest = request()->merge(['data' => $data]);
        $placeResponse = $placeController->list($placeRequest);
        $places = $placeResponse->getData(true);
        //Log::info('Place data: ', ['places' => $places]);
        //Alarms
        $alarmController = app(\App\Http\Controllers\AlarmController::class);
        $alarmRequest = request()->merge(['data' => $data]);
        $alarmResponse = $alarmController->list($alarmRequest);
        $alarms = $alarmResponse->getData(true);
        $alarmsCollection = collect($alarms['data']);
        //Log::info('Place data: ', ['alarms' => $alarmsCollection]);

        return view('vehicle-settings', [
            'vehicle' => collect($vehicle['data'][0] ?? []),
            'categories' => collect($categories['data'] ?? []),
            'regions' => collect($regions['data'] ?? []),
            'places' => collect($places['data'] ?? []),
            'alarms' => collect($alarms['data'] ?? []),
        ]);
    });

    // Region management routes
    Route::get('/regions', function () { return view('regions'); });
    Route::post('/regions-list', [RegionController::class, 'list']);
    Route::post('/region-edit', [RegionController::class, 'edit']);
    Route::post('/region-add', [RegionController::class, 'add']);
    Route::post('/region-duplicate', [RegionController::class, 'duplicate']);
    Route::post('/region-update', [RegionController::class, 'update']);
    Route::post('/region-delete', [RegionController::class, 'delete']);
    Route::post('/region-toggle-status', [RegionController::class, 'toggleStatus']);
    Route::post('/regions-update-order', [RegionController::class, 'updateOrder']);
    Route::post('/region-save-polygon', [RegionController::class, 'savePolygon']);
    Route::post('/region-set-device', [RegionController::class, 'setDevice']);
    Route::post('/region-set-device-price', [RegionController::class, 'setDevicePrice']);
    // ---------- end of Region management routes ----------

    //Place management routes
    Route::get('/places', function () { return view('places'); });
    Route::post('/places-list', [PlaceController::class, 'list']);
    Route::post('/place-edit', [PlaceController::class, 'edit']);
    Route::post('/place-add', [PlaceController::class, 'add']);
    Route::post('/place-duplicate', [PlaceController::class, 'duplicate']);
    Route::post('/place-update', [PlaceController::class, 'update']);
    Route::post('/place-delete', [PlaceController::class, 'delete']);
    Route::post('/place-toggle-status', [PlaceController::class, 'toggleStatus']);
    Route::post('/places-update-order', [PlaceController::class, 'UpdateOrder']);
    Route::post('/place-save-coordinates', [PlaceController::class, 'saveCoordinates']);
    Route::post('/place-set-device', [PlaceController::class, 'setDevice']);
    // ---------- end of Place management routes ----------

    //Category management routes
    //Route::get('/categories', function () { return view('categories'); });
    Route::post('/categories-list', [CategoryController::class, 'list']);
    Route::post('/category-edit', [CategoryController::class, 'edit']);
    Route::post('/category-add', [CategoryController::class, 'add']);
    Route::post('/category-duplicate', [CategoryController::class, 'duplicate']);
    Route::post('/category-delete', [CategoryController::class, 'delete']);
    Route::post('/categories-update-order', [CategoryController::class, 'updateOrder']);
    Route::post('/category-set-device', [CategoryController::class, 'setDevice']);
    Route::post('/api/categories-devices-match', [CategoryController::class, 'getCategoriesDevicesMatch']);
    // ---------- end of Category management routes ----------
    
    // Alarm
    Route::post('/alarm-set-device', [AlarmController::class, 'setDevice']);
    // ---------- end of Alarm management routes ----------

    // Vehicle Settings
    Route::post('/vehicle-update-settings', [DeviceController::class, 'updateVehicleSettings']);
    // ---------- end of Vehicle Settings routes ----------

    // Reports PAGES

    // Reports HELPERS
    Route::post('/api/vehicles-list-with-alarm', [DeviceController::class, 'getVehiclesListWithAlarm']);
    Route::post('/api/vehicles-list-with-region', [DeviceController::class, 'getVehiclesListWithRegion']);
    Route::post('/api/regions/list', [RegionController::class, 'list']);
    Route::post('/api/vehicles/list', [DeviceController::class, 'getVehiclesList']);
    Route::post('/api/vehicles/list-simple', [DeviceController::class, 'getVehiclesListSimple']);

    // Reports PAGES
    Route::prefix('reports')->group(function () {
        Route::get('/', function () { return view('reports.index'); })->name('reports.index');
        Route::get('/daily-summary/{data}', function ($data) { return view('reports.daily-summary', compact('data')); });    
        Route::get('/parking-analysis', [ReportController::class, 'parkingAnalysis'])->name('reports.parking-analysis');
        Route::get('/route-efficiency', [ReportController::class, 'routeEfficiency'])->name('reports.route-efficiency');
        Route::get('/visit-report', [ReportController::class, 'visitReport'])->name('reports.visit-report');
        Route::get('/zone-violations', [ReportController::class, 'zoneViolations'])->name('reports.zone-violations');
        Route::get('/after-hours/{data}', function ($data) { return view('reports.after-hours', compact('data')); })->name('reports.after-hours');
        Route::get('/speed-violations/{data}', function ($data) { return view('reports.speed-violations', compact('data')); })->name('reports.speed-violations');
        Route::get('/harsh-driving', [ReportController::class, 'harshDriving'])->name('reports.harsh-driving');
        Route::get('/fuel-consumption', [ReportController::class, 'fuelConsumption'])->name('reports.fuel-consumption');
        Route::get('/toll-analysis', [ReportController::class, 'tollAnalysis'])->name('reports.toll-analysis');
        Route::get('/toll-analysis-demo', function () { return view('reports.toll-analysis-demo'); })->name('reports.toll-analysis-demo');
        Route::get('/working-hours', [ReportController::class, 'workingHours'])->name('reports.working-hours');
        Route::get('/inspection-schedule', [ReportController::class, 'inspectionSchedule'])->name('reports.inspection-schedule');
        Route::get('/mileage-tracking', [ReportController::class, 'mileageTracking'])->name('reports.mileage-tracking');
        Route::get('/vehicle-health', [ReportController::class, 'vehicleHealth'])->name('reports.vehicle-health');
        Route::get('/driver-scoring', [ReportController::class, 'driverScoring'])->name('reports.driver-scoring');
    });
    
    // Reports DATA
    Route::prefix('api/reports')->group(function () {
        Route::post('/daily-summary', [ReportController::class, 'getDailySummaryData']);
        Route::post('/parking-analysis', [ReportController::class, 'getParkingAnalysisData']);
        Route::post('/route-efficiency', [ReportController::class, 'getRouteEfficiencyData']);
        Route::post('/visit-data', [ReportController::class, 'getVisitData']);
        Route::post('/region-data', [ReportController::class, 'getRegionData']);
        Route::post('/after-hours', [ReportController::class, 'afterHoursData']);
        Route::post('/speed-violations', [ReportController::class, 'getSpeedViolationsData']);
        Route::post('/harsh-driving', [ReportController::class, 'getHarshDrivingData']);
        Route::post('/fuel-consumption', [ReportController::class, 'getFuelConsumptionData']);
        Route::post('/toll-analysis', [ReportController::class, 'getTollAnalysisData']);
        Route::post('/working-hours', [ReportController::class, 'getWorkingHoursData']);
        Route::post('/inspection-schedule', [ReportController::class, 'getInspectionScheduleData']);
        Route::post('/mileage-tracking', [ReportController::class, 'getMileageTrackingData']);
        Route::post('/vehicle-health', [ReportController::class, 'getVehicleHealthData']);
        Route::post('/vehicle-health-details', [ReportController::class, 'getVehicleHealthDetails']);
        Route::get('/vehicle-health-export', [ReportController::class, 'exportVehicleHealth']);
        Route::post('/driver-scoring', [ReportController::class, 'getDriverScoringData']);
    });
    // ---------- end of Reports ----------

    // General Settings API Routes
    // Settings page
    Route::get('/settings', function () { return view('settings'); })->name('settings');

    // Profile page
    Route::get('/profile', function () { return view('profile'); })->name('profile');

    // Users page (admin only)
    Route::get('/users', function () { return view('users'); })->name('users');

    Route::prefix('api/settings')->group(function () {
        Route::get('/', [GeneralSettingController::class, 'index']);
        Route::get('/category/{category}', [GeneralSettingController::class, 'getByCategory']);
        Route::get('/value/{key}', [GeneralSettingController::class, 'getValue']);
        Route::post('/value', [GeneralSettingController::class, 'setValue']);
        Route::post('/multiple', [GeneralSettingController::class, 'updateMultiple']);
        Route::post('/store-multiple', [GeneralSettingController::class, 'storeMultiple']);
        Route::delete('/{key}', [GeneralSettingController::class, 'delete']);
        
        // Fuel settings
        Route::get('/fuel/prices', [GeneralSettingController::class, 'getFuelPrices']);
        Route::post('/fuel/price', [GeneralSettingController::class, 'setFuelPrice']);
        
        // Category-specific settings
        Route::get('/maintenance', [GeneralSettingController::class, 'getMaintenanceSettings']);
        Route::get('/alerts', [GeneralSettingController::class, 'getAlertSettings']);
        Route::get('/system', [GeneralSettingController::class, 'getSystemSettings']);
    });

    // User Management Routes
    Route::prefix('api/users')->group(function () {
        Route::get('/', [UserController::class, 'index']); // read
        Route::post('/', [UserController::class, 'store']); // create
        Route::get('/me', [UserController::class, 'me']); // read
        Route::patch('/me', [UserController::class, 'updateProfile']); // partial update
        Route::post('/me/photo', [UserController::class, 'uploadProfilePhoto']); // upload profile photo
        Route::get('/permissions', [UserController::class, 'getAvailablePermissions']); // read
        Route::get('/{user}', [UserController::class, 'show']); // read
        Route::put('/{user}', [UserController::class, 'update']); // full update
        Route::delete('/{user}', [UserController::class, 'destroy']); // delete
        Route::get('/{user}/direct-permissions', [UserController::class, 'getUserDirectPermissions']); // read
        Route::put('/{user}/direct-permissions', [UserController::class, 'updateUserDirectPermissions']); // full update
    });

    Route::get('/logout', [LoginController::class, 'logout'])->name('logout');
    
});

// Component documentation route (no middleware)
Route::get('/component-docs', function () { return view('components-doc.component-documentation'); });

/*
|--------------------------------------------------------------------------
| Session Settings API (Returns JSON)
|--------------------------------------------------------------------------
*/
Route::post('/session-settings', [PublicHelper::class, 'getSessionSettings']);
