<!-- Sidebar -->
<aside class="navbar navbar-vertical navbar-expand-lg navbar-dark" data-bs-theme="dark">
  <div class="container-fluid">
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbar-menu">
      <span class="navbar-toggler-icon"></span>
    </button>
    <h1 class="navbar-brand navbar-brand-autodark">
      <a href=".">
        <img src="{{ asset(config('app.assets')) }}/img/logo.svg" width="100" height="32" alt="Demo Company Logo"
          class="navbar-brand-image">
      </a>
    </h1>
    <div class="navbar-nav flex-row d-lg-none">
      <div class="nav-item d-none d-lg-flex me-3">
        <div class="btn-list">
          <a href="https://github.com/tabler/tabler" class="btn" target="_blank" rel="noreferrer">
            <!-- Download SVG icon from http://tabler-icons.io/i/brand-github -->
            <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24"
              stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
              <path stroke="none" d="M0 0h24v24H0z" fill="none" />
              <path
                d="M9 19c-4.3 1.4 -4.3 -2.5 -6 -3m12 5v-3.5c0 -1 .1 -1.4 -.5 -2c2.8 -.3 5.5 -1.4 5.5 -6a4.6 4.6 0 0 0 -1.3 -3.2a4.2 4.2 0 0 0 -.1 -3.2s-1.1 -.3 -3.5 1.3a12.3 12.3 0 0 0 -6.2 0c-2.4 -1.6 -3.5 -1.3 -3.5 -1.3a4.2 4.2 0 0 0 -.1 3.2a4.6 4.6 0 0 0 -1.3 3.2c0 4.6 2.7 5.7 5.5 6c-.6 .6 -.6 1.2 -.5 2v3.5" />
            </svg>
            Source code
          </a>
          <a href="https://github.com/sponsors/codecalm" class="btn" target="_blank" rel="noreferrer">
            <!-- Download SVG icon from http://tabler-icons.io/i/heart -->
            <svg xmlns="http://www.w3.org/2000/svg" class="icon text-pink" width="24" height="24" viewBox="0 0 24 24"
              stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
              <path stroke="none" d="M0 0h24v24H0z" fill="none" />
              <path d="M19.5 12.572l-7.5 7.428l-7.5 -7.428m0 0a5 5 0 1 1 7.5 -6.566a5 5 0 1 1 7.5 6.572" />
            </svg>
            Sponsor
          </a>
        </div>
      </div>
      <div class="d-none d-lg-flex">
        <a href="?theme=dark" class="nav-link px-0 hide-theme-dark" title="{{ __('Enable dark mode') }}"
          data-bs-toggle="tooltip" data-bs-placement="bottom">
          <!-- Download SVG icon from http://tabler-icons.io/i/moon -->
          <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24"
            stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
            <path d="M12 3c.132 0 .263 0 .393 0a7.5 7.5 0 0 0 7.92 12.446a9 9 0 1 1 -8.313 -12.454z" />
          </svg>
        </a>
        <a href="?theme=light" class="nav-link px-0 hide-theme-light" title="{{ __('Enable light mode') }}"
          data-bs-toggle="tooltip" data-bs-placement="bottom">
          <!-- Download SVG icon from http://tabler-icons.io/i/sun -->
          <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24"
            stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
            <circle cx="12" cy="12" r="4" />
            <path d="M3 12h1m8 -9v1m8 8h1m-9 8v1m-6.4 -15.4l.7 .7m12.1 -.7l-.7 .7m0 11.4l.7 .7m-12.1 -.7l-.7 .7" />
          </svg>
        </a>
        <div class="nav-item dropdown d-none d-md-flex me-3">
          <a href="#" class="nav-link px-0" data-bs-toggle="dropdown" tabindex="-1" aria-label="Show notifications">
            <!-- Download SVG icon from http://tabler-icons.io/i/bell -->
            <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24"
              stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
              <path stroke="none" d="M0 0h24v24H0z" fill="none" />
              <path d="M10 5a2 2 0 0 1 4 0a7 7 0 0 1 4 6v3a4 4 0 0 0 2 3h-16a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6" />
              <path d="M9 17v1a3 3 0 0 0 6 0v-1" />
            </svg>
            <span class="badge text-white bg-red"></span>
          </a>
          <div class="dropdown-menu dropdown-menu-arrow dropdown-menu-end dropdown-menu-card">
            <div class="card">
              <div class="card-header">
                <h3 class="card-title">{{ __('Last updates') }}</h3>
              </div>
              <div class="list-group list-group-flush list-group-hoverable">
                <div class="list-group-item">
                  <div class="row align-items-center">
                    <div class="col-auto"><span class="status-dot status-dot-animated bg-red d-block"></span></div>
                    <div class="col text-truncate">
                      <a href="#" class="text-body d-block">{{ __('Example 1') }}</a>
                      <div class="d-block text-muted text-truncate mt-n1">
                        {{ __('Change deprecated html tags to text decoration classes (#29604)') }}
                      </div>
                    </div>
                    <div class="col-auto">
                      <a href="#" class="list-group-item-actions">
                        <!-- Download SVG icon from http://tabler-icons.io/i/star -->
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon text-muted" width="24" height="24"
                          viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round"
                          stroke-linejoin="round">
                          <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                          <path
                            d="M12 17.75l-6.172 3.245l1.179 -6.873l-5 -4.867l6.9 -1l3.086 -6.253l3.086 6.253l6.9 1l-5 4.867l1.179 6.873z" />
                        </svg>
                      </a>
                    </div>
                  </div>
                </div>
                <div class="list-group-item">
                  <div class="row align-items-center">
                    <div class="col-auto"><span class="status-dot d-block"></span></div>
                    <div class="col text-truncate">
                      <a href="#" class="text-body d-block">{{ __('Example 2') }}</a>
                      <div class="d-block text-muted text-truncate mt-n1">
                        {{ __('justify-content:between ⇒ justify-content:space-between (#29734)') }}
                      </div>
                    </div>
                    <div class="col-auto">
                      <a href="#" class="list-group-item-actions show">
                        <!-- Download SVG icon from http://tabler-icons.io/i/star -->
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon text-yellow" width="24" height="24"
                          viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round"
                          stroke-linejoin="round">
                          <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                          <path
                            d="M12 17.75l-6.172 3.245l1.179 -6.873l-5 -4.867l6.9 -1l3.086 -6.253l3.086 6.253l6.9 1l-5 4.867l1.179 6.873z" />
                        </svg>
                      </a>
                    </div>
                  </div>
                </div>
                <div class="list-group-item">
                  <div class="row align-items-center">
                    <div class="col-auto"><span class="status-dot d-block"></span></div>
                    <div class="col text-truncate">
                      <a href="#" class="text-body d-block">{{ __('Example 3') }}</a>
                      <div class="d-block text-muted text-truncate mt-n1">
                        {{ __('Update change-version.js (#29736)') }}
                      </div>
                    </div>
                    <div class="col-auto">
                      <a href="#" class="list-group-item-actions">
                        <!-- Download SVG icon from http://tabler-icons.io/i/star -->
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon text-muted" width="24" height="24"
                          viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round"
                          stroke-linejoin="round">
                          <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                          <path
                            d="M12 17.75l-6.172 3.245l1.179 -6.873l-5 -4.867l6.9 -1l3.086 -6.253l3.086 6.253l6.9 1l-5 4.867l1.179 6.873z" />
                        </svg>
                      </a>
                    </div>
                  </div>
                </div>
                <div class="list-group-item">
                  <div class="row align-items-center">
                    <div class="col-auto"><span class="status-dot status-dot-animated bg-green d-block"></span></div>
                    <div class="col text-truncate">
                      <a href="#" class="text-body d-block">{{ __('Example 4') }}</a>
                      <div class="d-block text-muted text-truncate mt-n1">
                        {{ __('Regenerate package-lock.json (#29730)') }}
                      </div>
                    </div>
                    <div class="col-auto">
                      <a href="#" class="list-group-item-actions">
                        <!-- Download SVG icon from http://tabler-icons.io/i/star -->
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon text-muted" width="24" height="24"
                          viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round"
                          stroke-linejoin="round">
                          <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                          <path
                            d="M12 17.75l-6.172 3.245l1.179 -6.873l-5 -4.867l6.9 -1l3.086 -6.253l3.086 6.253l6.9 1l-5 4.867l1.179 6.873z" />
                        </svg>
                      </a>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="nav-item dropdown">
        <a href="#" class="nav-link d-flex lh-1 text-reset p-0" data-bs-toggle="dropdown" aria-label="Open user menu">
          <span class="avatar avatar-sm avatar-rounded">
            {{ substr($cookieUserId ?? 'U', 0, 1) }}
          </span>
        </a>
        <div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
          <a href="{{ route('profile') }}" class="dropdown-item">
            <i class="fas fa-user dropdown-item-icon"></i>
            {{ __('Profile') }}
          </a>
          <a href="{{ route('settings') }}" class="dropdown-item">
            <i class="fas fa-cog dropdown-item-icon"></i>
            {{ __('Settings') }}
          </a>
          <div class="dropdown-divider"></div>
          <a href="/logout" class="dropdown-item">
            <i class="fas fa-sign-out-alt dropdown-item-icon"></i>
            {{ __('Logout') }}
          </a>
        </div>
      </div>
    </div>
    <div class="collapse navbar-collapse" id="navbar-menu">
      <ul class="navbar-nav pt-lg-3">

        @if($cookieUserId)

        @canaccess('map')
        <li class="nav-item dropdown menu-item" id="a_maps_li">
          <a class="nav-link dropdown-toggle menu-item" id="s_map_li_a" href="#navbar-layout" data-bs-toggle="dropdown"
            data-bs-auto-close="false" role="button" aria-expanded="true">
            <span class="nav-link-icon d-md-none d-lg-inline-block">
              <i class="ti ti-map-2"></i>
            </span>
            <span class="nav-link-title">
              {{ __('Map') }}
            </span>
          </a>
          <div class="dropdown-menu menu-item" id="s_map_div" data-bs-popper="static">
            <div class="dropdown-menu-columns">
              <div class="dropdown-menu-column">
                <a class="dropdown-item menu-item" href="/vehicles-map" id="a_map_vehicles-map">
                  {{ __('All Vehicles') }}
                </a>
                <a class="dropdown-item menu-item" href="/vehicles-map-cctv" id="a_map_vehicles-map-cctv">
                  {{ __('CCTV') }}
                </a>
              </div>
            </div>
          </div>
        </li>
        @endif

        @canaccess('vehicles')
        <li class="nav-item">
          <a class="nav-link menu-item" href="/vehicles-list" id="vehicles-list">
            <span class="nav-link-icon d-md-none d-lg-inline-block">
              <i class="ti ti-car"></i>
            </span>
            <span class="nav-link-title">
              {{ __('Vehicles') }}
            </span>
          </a>
        </li>
        @endcanaccess

        @canaccess('regions')
        <li class="nav-item">
          <a class="nav-link menu-item" href="/regions" id="regions">
            <span class="nav-link-icon d-md-none d-lg-inline-block">
              <i class="ti ti-polygon"></i>
            </span>
            <span class="nav-link-title">
              {{ __('Regions') }}
            </span>
          </a>
        </li>
        @endcanaccess

        @canaccess('places')
        <li class="nav-item">
          <a class="nav-link menu-item" href="/places" id="places">
            <span class="nav-link-icon d-md-none d-lg-inline-block">
              <i class="ti ti-device-mobile-pin"></i>
            </span>
            <span class="nav-link-title">
              {{ __('Places') }}
            </span>
          </a>
        </li>
        @endcanaccess
        @canaccess('reports')

        <li class="nav-item">
          <a class="nav-link menu-item" href="/reports" id="reports">
            <span class="nav-link-icon d-md-none d-lg-inline-block">
              <i class="ti ti-report"></i>
            </span>
            <span class="nav-link-title">
              {{ __('Reports') }}
            </span>
          </a>
        </li>
        @endcanaccess


        @canaccess('settings')
        <li class="nav-item">
          <a class="nav-link menu-item" href="/settings" id="settings">
            <span class="nav-link-icon d-md-none d-lg-inline-block">
              <i class="ti ti-settings"></i>
            </span>
            <span class="nav-link-title">
              {{ __('Settings') }}
            </span>
          </a>
        </li>
        @endcanaccess

        <li class="nav-item">
          <a class="nav-link" href="{{ route('profile') }}">
            <span class="nav-link-icon d-md-none d-lg-inline-block">
              <i class="ti ti-user"></i>
            </span>
            <span class="nav-link-title">
              {{ __('My Profile') }}
            </span>
          </a>
        </li>


        @canaccess('users')
        <li class="nav-item">
          <a class="nav-link" href="{{ route('users') }}">
            <span class="nav-link-icon d-md-none d-lg-inline-block">
              <i class="ti ti-users"></i>
            </span>
            <span class="nav-link-title">
              {{ __('Users') }}
            </span>
          </a>
        </li>
        @endcanaccess
        {{-- <li class="nav-item">
          <a class="nav-link" href="/vehicles-map">
            <span class="nav-link-icon d-md-none d-lg-inline-block">
              <i class="ti ti-map-2"></i>
            </span>
            <span class="nav-link-title">
              {{ __('Map') }}
            </span>
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="/vehicles-map-cctv">
            <span class="nav-link-icon d-md-none d-lg-inline-block">
              <i class="ti ti-map-2"></i>
            </span>
            <span class="nav-link-title">
              {{ __('CCTV') }}
            </span>
          </a>
        </li> --}}
        <li class="nav-item">
          <a class="nav-link" href="/logout">
            <span class="nav-link-icon d-md-none d-lg-inline-block">
              <i class="ti ti-logout-2"></i>
            </span>
            <span class="nav-link-title">
              {{ __('Sign Out') }}
            </span>
          </a>
        </li>
        @endif

        @if(!$cookieUserId)
        <li class="nav-item">
          <a class="nav-link" href="/login">
            <span class="nav-link-icon d-md-none d-lg-inline-block">
              <i class="ti ti-login-2"></i>
            </span>
            <span class="nav-link-title">
              {{ __('Sign In') }}
            </span>
          </a>
        </li>
        @endif
      </ul>
    </div>
  </div>
</aside>