@php
$alarm_form_id = 303; // Towed alarm form ID
$towed = $alarms->firstWhere('alarm_form_id', $alarm_form_id);
$j = [];
if($towed && isset($towed['settings_json']) && $towed['settings_json']){
if(is_string($towed['settings_json'])){
$j = json_decode($towed['settings_json'], true) ?: [];
} else {
$j = $towed['settings_json'];
}
}
@endphp
<form class="alarm-form" id="alarmForm_{{ $alarm_form_id }}">
    <div class="mb-3">
        {{ __("This alarm may give false notifications in areas where the GPS signal is very weak.") }}
    </div>
    <div class="row mb-3">
        <label class="form-selectgroup-item col-6">
            <input type="radio" name="status_id_{{$alarm_form_id}}" value="1" class="form-selectgroup-input" {{
                isset($towed['status_id']) && $towed['status_id'] ? 'checked' : '' }}>
            <span class="form-selectgroup-label" onclick="saveAlarmSettings({{ $alarm_form_id }})">
                <i class="icon vertical-center me-1 text-muted ti ti-bell-ringing"></i>
                {{ __('Alarm Open') }}
            </span>
        </label>
        <label class="form-selectgroup-item  col-6">
            <input type="radio" name="status_id_{{$alarm_form_id}}" value="0" class="form-selectgroup-input" {{
                !isset($towed['status_id']) || !$towed['status_id'] ? 'checked' : '' }}>
            <span class="form-selectgroup-label" onclick="saveAlarmSettings({{ $alarm_form_id }})">
                <i class="icon vertical-center me-1 text-muted ti ti-bell-x"></i>
                {{ __('Alarm Closed') }}
            </span>
        </label>
    </div>
</form>
{{--
Note:
<script>
    vehicle-settings.blade.php
    function saveAlarmSettings(alarm_form_id) {
</script>
--}}