<div class="card-table table-responsive">
    <div class="p-3">
        {{ __('Receive notifications via the mobile app when entering or exiting the point.') }}
    </div>
    <table class="table table-vcenter">
        <thead>
            <tr>
                <th>{{ __("Place") }}</th>
                <th>{{ __("Alarm") }}</th>
            </tr>
        </thead>
        <tbody>
            @foreach ( $places as $item )
            @if($item["status_id"] == 1)
            <tr>
                <td class="w-50">
                    {{ $item["name"] }}
                </td>
                <td class="td-truncate">

                    <label class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" {{ $item['match_status_id'] ? "checked" : "" }}
                            onchange="setPlaceDeviceStatus({{ $item['id'] }}, this)">
                    </label>

                </td>
            </tr>
            @endif
            @endforeach
        </tbody>
    </table>
</div>

<script>
    function setPlaceDeviceStatus(placeId, _this) {

        // Prepare data and encode with Base64Helper
        const postData = Base64Helper.encode({
            device_id: $("#device_id").val(),
            place_id: placeId,
            status: $(_this).is(":checked") ? 1 : 0
        });

        http.post({
            url: "/place-set-device",
            data: {
                data: postData
            }
        })
        .then(function(response) {
            if (response.success) {
                showNotification("success", "Region status updated successfully");
            } else {
                showNotification("error", "Error updating region status");
            }
        })
        .catch(function(error) {
            console.error("Update error:", error);
            showNotification("error", "Error updating region status");
        });
    }
</script>