@php
$alarm_form_id = 302; // Engine Blockage alarm form ID
$engine_block = $alarms->firstWhere('alarm_form_id', $alarm_form_id);
$j = [];
if($engine_block && isset($engine_block['settings_json']) && $engine_block['settings_json']){
if(is_string($engine_block['settings_json'])){
$j = json_decode($engine_block['settings_json'], true) ?: [];
} else {
$j = $engine_block['settings_json'];
}
}
@endphp

<form class="alarm-form" id="alarmForm_{{ $alarm_form_id }}">
    <div class="mb-3">
        {{ __('If the engine shutdown command is given to the device, the engine shutdown process is performed when the
        ignition is off, the speed is below 5 knots and the GPS data is valid for 5 seconds.') }}
    </div>
    <div class="form-floating mb-3">
        <input type="password" name="password" class="form-control" id="floating-password" value="" autocomplete="off">
        <label for="floating-password">{{ __('Password') }}</label>
    </div>
    <div class="row mb-3">
        <label class="form-selectgroup-item col-6">
            <input type="radio" name="status_id_{{$alarm_form_id}}" value="1" class="form-selectgroup-input" {{
                isset($engine_block['status_id']) && $engine_block['status_id'] ? 'checked' : '' }}>
            <span class="form-selectgroup-label">
                <i class="icon vertical-center me-1 text-muted ti ti-lock-down"></i>
                {{ __('Block Engine') }}
            </span>
        </label>
        <label class="form-selectgroup-item  col-6">
            <input type="radio" name="status_id_{{$alarm_form_id}}" value="0" class="form-selectgroup-input" {{
                !isset($engine_block['status_id']) || !$engine_block['status_id'] ? 'checked' : '' }}>
            <span class="form-selectgroup-label">
                <i class="icon vertical-center me-1 text-muted ti ti-lock-open"></i>
                {{ __('Unblock Engine') }}
            </span>
        </label>
    </div>
</form>
{{-- 
   //vehicle-settings.blade.php
   //function saveAlarmSettings(alarm_form_id) {
--}}
<script>
    function initVehicleSettingsEngineBlock() {
        var alarm_form_id = 302;
        // Handle radio button clicks
        $('input[name="status_id_'+alarm_form_id+'"]').on('change', function() {
            const password = $('#floating-password').val().trim();
            
            if (password === '') {
                showNotification("warning", "{{ __('Please enter a password first') }}");
                // Uncheck the radio button
                $(this).prop('checked', false);
                return false;
            }
            
            // Password is not empty, proceed with save
            saveAlarmSettings(alarm_form_id);
        });
    }
</script>
