@php
$alarm_form_id = 307; // After Hours Use alarm form ID
$after_hours = $alarms->firstWhere('alarm_form_id', $alarm_form_id);
$j = [];
if($after_hours && isset($after_hours['settings_json']) && $after_hours['settings_json']){
if(is_string($after_hours['settings_json'])){
$j = json_decode($after_hours['settings_json'], true) ?: [];
} else {
$j = $after_hours['settings_json'];
}
}
@endphp

<form class="alarm-form" id="alarmForm_{{ $alarm_form_id }}">
  <div class="row mb-3">
    <label class="form-selectgroup-item col-6">
      <input type="radio" name="status_id_{{$alarm_form_id}}" value="1" class="form-selectgroup-input" {{
        isset($after_hours['status_id']) && $after_hours['status_id'] ? 'checked' : '' }}>
      <span class="form-selectgroup-label" onclick="saveAlarmSettings({{ $alarm_form_id }})">
        <i class="icon vertical-center me-1 text-muted ti ti-bell-ringing"></i>
        {{ __('Alarm Open') }}
      </span>
    </label>
    <label class="form-selectgroup-item col-6">
      <input type="radio" name="status_id_{{$alarm_form_id}}" value="0" class="form-selectgroup-input" {{
        !isset($after_hours['status_id']) || !$after_hours['status_id'] ? 'checked' : '' }}>
      <span class="form-selectgroup-label" onclick="saveAlarmSettings({{ $alarm_form_id }})">
        <i class="icon vertical-center me-1 text-muted ti ti-bell-x"></i>
        {{ __('Alarm Closed') }}
      </span>
    </label>
  </div>

  <div class="card-table table-responsive">
    <table class="table table-vcenter">
      <thead>
        <tr>
          <th>{{ __("Day") }}</th>
          <th>{{ __("Start") }}</th>
          <th>{{ __("End") }}</th>
        </tr>
      </thead>
      <tbody>
        @for ($i = 1; $i <= 7; $i++) <tr>
          <td class="w-50">
            {{ __('Day_'.$i) }}
          </td>
          <td class="w-25">
            <input type="time" name="start_time_{{$i}}" class="form-control" autocomplete="off"
              value="{{ $j['start_time_'.$i] ?? '' }}">
          </td>
          <td class="w-25">
            <input type="time" name="end_time_{{$i}}" class="form-control" autocomplete="off"
              value="{{ $j['end_time_'.$i] ?? '' }}">
          </td>
          </tr>
          @endfor
      </tbody>
    </table>
  </div>
  <div class="d-flex justify-content-end p-3">
    <button type="button" class="btn btn-primary" onclick="saveAlarmSettings({{ $alarm_form_id }})"
      id="saveAllBtn_{{ $alarm_form_id }}">
      <i class="icon ti ti-device-floppy me-1"></i>
      {{ __('Save All Settings') }}
    </button>
  </div>
</form>

{{--
Note:
<script>
  vehicle-settings.blade.php
    function saveAlarmSettings(alarm_form_id) {
</script>
--}}