<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
  <head>
    <meta charset="utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover"/>
    <meta http-equiv="X-UA-Compatible" content="ie=edge"/>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title') | {{ config('app.name') }}</title>

    <!-- CSS files -->
    <link href="{{ asset(config('app.assets')) }}/dist/css/tabler.min.css?{{config('app.version')}}" rel="stylesheet"/>
    <link href="{{ asset(config('app.assets')) }}/dist/css/tabler-flags.min.css?{{config('app.version')}}" rel="stylesheet"/>
    <link href="{{ asset(config('app.assets')) }}/dist/css/tabler-payments.min.css?{{config('app.version')}}" rel="stylesheet"/>
    <link href="{{ asset(config('app.assets')) }}/dist/css/tabler-vendors.min.css?{{config('app.version')}}" rel="stylesheet"/>
    <link href="{{ asset(config('app.assets')) }}/dist/css/demo.min.css?{{config('app.version')}}" rel="stylesheet"/>

    <link rel="stylesheet" href="{{ asset(config('app.assets')) }}/dist/fonts-tabler/tabler-icons.min.css">
    <link rel="stylesheet" href="{{ asset(config('app.assets')) }}/css/custom.css">

    @yield('styles')

    <style>
      @import url('https://rsms.me/inter/inter.css');
      :root {
      	--tblr-font-sans-serif: Inter, -apple-system, BlinkMacSystemFont, San Francisco, Segoe UI, Roboto, Helvetica Neue, sans-serif;
      }
    </style>
  </head>
  <body  class="border-top-wide border-primary d-flex flex-column theme-light">
    <script src="{{ asset(config('app.assets')) }}/dist/js/demo-theme.min.js?{{config('app.version')}}"></script>

    <div class="page">
        <div class="page-wrapper">
            @yield('content')
        </div>
    </div>

    <!-- Libs JS -->
    <script src="{{ asset(config('app.assets')) }}/dist/libs/apexcharts/dist/apexcharts.min.js?{{config('app.version')}}" defer></script>
    <script src="{{ asset(config('app.assets')) }}/dist/libs/jsvectormap/dist/js/jsvectormap.min.js?{{config('app.version')}}" defer></script>
    <script src="{{ asset(config('app.assets')) }}/dist/libs/jsvectormap/dist/maps/world.js?{{config('app.version')}}" defer></script>
    <script src="{{ asset(config('app.assets')) }}/dist/libs/jsvectormap/dist/maps/world-merc.js?{{config('app.version')}}" defer></script>
    <!-- Tabler Core -->
    <script src="{{ asset(config('app.assets')) }}/dist/js/tabler.min.js?{{config('app.version')}}" defer></script>
    <script src="{{ asset(config('app.assets')) }}/dist/js/demo.min.js?{{config('app.version')}}" defer></script>
    <!-- Jquery -->
    <script src="{{ asset(config('app.js_lib')) }}/jquery-3.7.1.min.js?{{config('app.version')}}"></script>
    <!-- Common -->
    <script src="{{ asset(config('app.assets')) }}/js/common.js?{{config('app.version')}}"></script>

    @yield('scripts')

  </body>
</html>
