@extends('layouts.sign-in')

@section('title', __("Forgot password"))

@section('content')
<div class="page page-center">
      <div class="container container-tight py-4">
        <div class="text-center mb-4">
          <a href="." class="navbar-brand navbar-brand-autodark">
            <img src="{{ asset(config('app.assets')) }}/img/logo.svg" width="110" height="32" alt="Tabler" class="navbar-brand-image">
        </a>
        </div>
        <form class="card card-md" action="./" method="get" autocomplete="off" novalidate="">
          <div class="card-body">
            <h2 class="card-title text-center mb-4">{{__("Forgot password")}}</h2>
            <p class="text-muted mb-4">{{__("Enter your email address and your password will be reset and emailed to you.")}}</p>
            <div class="mb-3">
              <label class="form-label">{{__("Email address")}}</label>
              <input type="email" class="form-control" placeholder="{{__("Email address")}}">
            </div>
            <div class="form-footer">
              <a href="#" class="btn btn-primary w-100">
                <i class="ti ti-mail me-2"></i>
                {{__("Send me new password")}}
              </a>
            </div>
          </div>
        </form>
        <div class="text-center text-muted mt-3">
          <a href="{{ url('/login') }}" class="text-decoration-none">
            <i class="ti ti-arrow-left me-1"></i>
            {{__("Back to login")}}
          </a>
        </div>
      </div>
    </div>
@endsection

@section('scripts')
@endsection
