@php
    $formGroupClass = 'mb-3';
    $labelClass = 'form-label';
    $inputClass = 'form-control';
    $helpClass = 'form-text';
    $errorClass = 'invalid-feedback';
    
    // Size classes
    if ($size === 'sm') {
        $inputClass .= ' form-control-sm';
    } elseif ($size === 'lg') {
        $inputClass .= ' form-control-lg';
    }
    
    // Error state
    if ($error) {
        $inputClass .= ' is-invalid';
    }
    
    // Add custom classes
    if ($class) {
        $inputClass .= ' ' . $class;
    }
    
    // Inline form
    if ($inline) {
        $formGroupClass = 'mb-3 me-3';
    }
@endphp

<div class="{{ $formGroupClass }}">
    @if($label && !in_array($type, ['checkbox', 'radio']))
        <label for="{{ $id }}" class="{{ $labelClass }}">
            {{ $label }}
            @if($required)
                <span class="text-danger">*</span>
            @endif
        </label>
    @endif

    @switch($type)
        @case('textarea')
            <textarea 
                name="{{ $name }}" 
                id="{{ $id }}" 
                class="{{ $inputClass }}" 
                placeholder="{{ $placeholder }}"
                rows="{{ $rows }}"
                @if($cols) cols="{{ $cols }}" @endif
                @if($required) required @endif
                @if($disabled) disabled @endif
                @if($readonly) readonly @endif
            >{{ $value }}</textarea>
            @break

        @case('select')
            <select 
                name="{{ $name }}" 
                id="{{ $id }}" 
                class="{{ $inputClass }}"
                @if($required) required @endif
                @if($disabled) disabled @endif
                @if($multiple) multiple @endif
            >
                @if($placeholder && !$multiple)
                    <option value="">{{ $placeholder }}</option>
                @endif
                @foreach($options as $optionValue => $optionLabel)
                    <option 
                        value="{{ $optionValue }}" 
                        @if($value == $optionValue || (is_array($value) && in_array($optionValue, $value))) selected @endif
                    >
                        {{ $optionLabel }}
                    </option>
                @endforeach
            </select>
            @break

        @case('checkbox')
            <div class="form-check">
                <input 
                    type="checkbox" 
                    name="{{ $name }}" 
                    id="{{ $id }}" 
                    class="form-check-input"
                    value="1"
                    @if($checked) checked @endif
                    @if($required) required @endif
                    @if($disabled) disabled @endif
                >
                @if($label)
                    <label for="{{ $id }}" class="form-check-label">
                        {{ $label }}
                        @if($required)
                            <span class="text-danger">*</span>
                        @endif
                    </label>
                @endif
            </div>
            @break

        @case('radio')
            <div class="form-check">
                <input 
                    type="radio" 
                    name="{{ $name }}" 
                    id="{{ $id }}" 
                    class="form-check-input"
                    value="{{ $value }}"
                    @if($checked) checked @endif
                    @if($required) required @endif
                    @if($disabled) disabled @endif
                >
                @if($label)
                    <label for="{{ $id }}" class="form-check-label">
                        {{ $label }}
                        @if($required)
                            <span class="text-danger">*</span>
                        @endif
                    </label>
                @endif
            </div>
            @break

        @case('file')
            <input 
                type="file" 
                name="{{ $name }}" 
                id="{{ $id }}" 
                class="{{ $inputClass }}"
                @if($required) required @endif
                @if($disabled) disabled @endif
                @if($multiple) multiple @endif
            >
            @break

        @default
            <input 
                type="{{ $type }}" 
                name="{{ $name }}" 
                id="{{ $id }}" 
                class="{{ $inputClass }}" 
                placeholder="{{ $placeholder }}"
                value="{{ $value }}"
                @if($required) required @endif
                @if($disabled) disabled @endif
                @if($readonly) readonly @endif
            >
    @endswitch

    @if($helpText)
        <div class="{{ $helpClass }}">
            {{ $helpText }}
        </div>
    @endif

    @if($error)
        <div class="{{ $errorClass }}">
            {{ $error }}
        </div>
    @endif
</div>
