<?php
/**
 * Step 1: Requirements Check
 */

$requirements = [
    'PHP Version >= 8.1' => version_compare(PHP_VERSION, '8.1.0', '>='),
    'BCMath Extension' => extension_loaded('bcmath'),
    'Ctype Extension' => extension_loaded('ctype'),
    'JSON Extension' => extension_loaded('json'),
    'Mbstring Extension' => extension_loaded('mbstring'),
    'OpenSSL Extension' => extension_loaded('openssl'),
    'PDO Extension' => extension_loaded('pdo'),
    'PDO MySQL Extension' => extension_loaded('pdo_mysql'),
    'Tokenizer Extension' => extension_loaded('tokenizer'),
    'XML Extension' => extension_loaded('xml'),
    'cURL Extension' => extension_loaded('curl'),
    'Fileinfo Extension' => extension_loaded('fileinfo'),
];

$permissions = [
    'storage/' => is_writable('../../storage'),
    'bootstrap/cache/' => is_writable('../../bootstrap/cache'),
    'public/uploads/' => is_writable('../../public/uploads') || @mkdir('../../public/uploads', 0775, true),
];

$allPassed = !in_array(false, $requirements) && !in_array(false, $permissions);
?>

<h2 class="card-title mb-4">
    <i class="ti ti-checklist me-2"></i> System Requirements Check
</h2>

<p class="text-muted mb-4">
    Please ensure your server meets all the requirements below before continuing.
</p>

<!-- PHP Requirements -->
<h4 class="mb-3">PHP Requirements</h4>
<div class="mb-4">
    <?php foreach ($requirements as $name => $status): ?>
        <div class="check-item <?= $status ? 'pass' : 'fail' ?>">
            <i class="ti ti-<?= $status ? 'check' : 'x' ?> me-2"></i>
            <?= $name ?>
            <span class="badge bg-<?= $status ? 'success' : 'danger' ?> float-end">
                <?= $status ? 'Installed' : 'Missing' ?>
            </span>
        </div>
    <?php endforeach; ?>
</div>

<!-- Folder Permissions -->
<h4 class="mb-3">Folder Permissions</h4>
<div class="mb-4">
    <?php foreach ($permissions as $folder => $status): ?>
        <div class="check-item <?= $status ? 'pass' : 'fail' ?>">
            <i class="ti ti-<?= $status ? 'check' : 'x' ?> me-2"></i>
            <?= $folder ?>
            <span class="badge bg-<?= $status ? 'success' : 'danger' ?> float-end">
                <?= $status ? 'Writable' : 'Not Writable' ?>
            </span>
        </div>
    <?php endforeach; ?>
</div>

<?php if (!$allPassed): ?>
    <div class="alert alert-danger">
        <h4 class="alert-title">
            <i class="ti ti-alert-circle me-2"></i> Requirements Not Met
        </h4>
        <div class="text-muted">
            Please fix the issues above before continuing. Contact your hosting provider if you need assistance.
        </div>
    </div>
<?php else: ?>
    <div class="alert alert-success">
        <h4 class="alert-title">
            <i class="ti ti-check me-2"></i> All Requirements Met!
        </h4>
        <div class="text-muted">
            Your server meets all the requirements. Click "Next" to continue.
        </div>
    </div>
<?php endif; ?>

<!-- Navigation -->
<div class="d-flex justify-content-between mt-4">
    <div></div>
    <a href="?step=2" class="btn btn-primary <?= !$allPassed ? 'disabled' : '' ?>">
        Next: Database Configuration
        <i class="ti ti-arrow-right ms-2"></i>
    </a>
</div>

<?php
if ($allPassed) {
    $_SESSION['install']['completed_steps'][1] = true;
}
?>

