<?php
/**
 * Fleet Tracker Pro - Auto Installer
 * 
 * This wizard will guide you through the installation process.
 */

session_start();

// Check if already installed
if (file_exists('../../.env') && file_exists('../../storage/installed')) {
    header('Location: ../../');
    exit('Application is already installed. Delete storage/installed file to reinstall.');
}

// Get current step
$step = isset($_GET['step']) ? (int)$_GET['step'] : 1;
$step = max(1, min(5, $step)); // Ensure step is between 1 and 5

// Initialize session data
if (!isset($_SESSION['install'])) {
    $_SESSION['install'] = [
        'step' => 1,
        'completed_steps' => []
    ];
}

$currentStep = $step;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Fleet Tracker Pro - Installation Wizard</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@tabler/core@latest/dist/css/tabler.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@tabler/icons-webfont@latest/dist/tabler-icons.min.css">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .install-container {
            max-width: 800px;
            width: 100%;
            padding: 2rem;
        }
        .step-indicator {
            display: flex;
            justify-content: space-between;
            margin-bottom: 2rem;
        }
        .step-item {
            flex: 1;
            text-align: center;
            padding: 1rem;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            margin: 0 0.5rem;
            color: white;
            transition: all 0.3s;
        }
        .step-item.active {
            background: white;
            color: #667eea;
            transform: scale(1.05);
        }
        .step-item.completed {
            background: rgba(40, 167, 69, 0.3);
            color: white;
        }
        .card {
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
        }
        .check-item {
            padding: 0.75rem;
            border-radius: 6px;
            margin-bottom: 0.5rem;
        }
        .check-item.pass {
            background: #d1e7dd;
            border-left: 4px solid #28a745;
        }
        .check-item.fail {
            background: #f8d7da;
            border-left: 4px solid #dc3545;
        }
        .check-item.warning {
            background: #fff3cd;
            border-left: 4px solid #ffc107;
        }
    </style>
</head>
<body>
    <div class="install-container">
        <!-- Logo & Title -->
        <div class="text-center mb-4">
            <h1 class="text-white mb-2">
                <i class="ti ti-car"></i> Fleet Tracker Pro
            </h1>
            <p class="text-white-50">Installation Wizard</p>
        </div>

        <!-- Step Indicator -->
        <div class="step-indicator">
            <div class="step-item <?= $currentStep == 1 ? 'active' : ($currentStep > 1 ? 'completed' : '') ?>">
                <i class="ti ti-check-circle fs-2"></i>
                <div class="small mt-1">Requirements</div>
            </div>
            <div class="step-item <?= $currentStep == 2 ? 'active' : ($currentStep > 2 ? 'completed' : '') ?>">
                <i class="ti ti-database fs-2"></i>
                <div class="small mt-1">Database</div>
            </div>
            <div class="step-item <?= $currentStep == 3 ? 'active' : ($currentStep > 3 ? 'completed' : '') ?>">
                <i class="ti ti-user fs-2"></i>
                <div class="small mt-1">Admin</div>
            </div>
            <div class="step-item <?= $currentStep == 4 ? 'active' : ($currentStep > 4 ? 'completed' : '') ?>">
                <i class="ti ti-settings fs-2"></i>
                <div class="small mt-1">Settings</div>
            </div>
            <div class="step-item <?= $currentStep == 5 ? 'active' : '' ?>">
                <i class="ti ti-check fs-2"></i>
                <div class="small mt-1">Finish</div>
            </div>
        </div>

        <!-- Main Card -->
        <div class="card">
            <div class="card-body p-4">
                <?php
                // Include the appropriate step file
                $stepFile = __DIR__ . '/steps/step' . $currentStep . '.php';
                if (file_exists($stepFile)) {
                    include $stepFile;
                } else {
                    echo '<div class="alert alert-danger">Step file not found!</div>';
                }
                ?>
            </div>
        </div>

        <!-- Footer -->
        <div class="text-center mt-3">
            <p class="text-white-50 small">
                © 2025 Fleet Tracker Pro. All rights reserved.
            </p>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@tabler/core@latest/dist/js/tabler.min.js"></script>
</body>
</html>

