<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;
use App\Models\User;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create permissions
        $permissions = [
            // Vehicle permissions
            ['name' => 'vehicles.view', 'display_name' => 'View Vehicles', 'description' => 'Can view vehicle list and details', 'module' => 'vehicles'],
            ['name' => 'vehicles.create', 'display_name' => 'Create Vehicles', 'description' => 'Can create new vehicles', 'module' => 'vehicles'],
            ['name' => 'vehicles.edit', 'display_name' => 'Edit Vehicles', 'description' => 'Can edit vehicle information', 'module' => 'vehicles'],
            ['name' => 'vehicles.delete', 'display_name' => 'Delete Vehicles', 'description' => 'Can delete vehicles', 'module' => 'vehicles'],
            ['name' => 'vehicles.settings', 'display_name' => 'Vehicle Settings', 'description' => 'Can manage vehicle settings', 'module' => 'vehicles'],
            
            // Map permissions
            ['name' => 'map.view', 'display_name' => 'View Map', 'description' => 'Can view vehicle map', 'module' => 'map'],
            ['name' => 'map.live', 'display_name' => 'Live Map', 'description' => 'Can view live vehicle tracking', 'module' => 'map'],
            
            // Region permissions
            ['name' => 'regions.view', 'display_name' => 'View Regions', 'description' => 'Can view regions list', 'module' => 'regions'],
            ['name' => 'regions.create', 'display_name' => 'Create Regions', 'description' => 'Can create new regions', 'module' => 'regions'],
            ['name' => 'regions.edit', 'display_name' => 'Edit Regions', 'description' => 'Can edit region information', 'module' => 'regions'],
            ['name' => 'regions.delete', 'display_name' => 'Delete Regions', 'description' => 'Can delete regions', 'module' => 'regions'],
            
            // Place permissions
            ['name' => 'places.view', 'display_name' => 'View Places', 'description' => 'Can view places list', 'module' => 'places'],
            ['name' => 'places.create', 'display_name' => 'Create Places', 'description' => 'Can create new places', 'module' => 'places'],
            ['name' => 'places.edit', 'display_name' => 'Edit Places', 'description' => 'Can edit place information', 'module' => 'places'],
            ['name' => 'places.delete', 'display_name' => 'Delete Places', 'description' => 'Can delete places', 'module' => 'places'],
            
            // Alarm permissions
            ['name' => 'alarms.view', 'display_name' => 'View Alarms', 'description' => 'Can view alarm settings', 'module' => 'alarms'],
            ['name' => 'alarms.create', 'display_name' => 'Create Alarms', 'description' => 'Can create new alarms', 'module' => 'alarms'],
            ['name' => 'alarms.edit', 'display_name' => 'Edit Alarms', 'description' => 'Can edit alarm settings', 'module' => 'alarms'],
            ['name' => 'alarms.delete', 'display_name' => 'Delete Alarms', 'description' => 'Can delete alarms', 'module' => 'alarms'],
            
            // Report permissions
            ['name' => 'reports_view', 'display_name' => 'View Reports', 'description' => 'Can view all reports', 'module' => 'reports'],
            ['name' => 'reports_daily', 'display_name' => 'Daily Reports', 'description' => 'Can view daily summary reports', 'module' => 'reports'],
            ['name' => 'reports_parking', 'display_name' => 'Parking Reports', 'description' => 'Can view parking analysis reports', 'module' => 'reports'],
            ['name' => 'reports_route', 'display_name' => 'Route Reports', 'description' => 'Can view route efficiency reports', 'module' => 'reports'],
            ['name' => 'reports_visit', 'display_name' => 'Visit Reports', 'description' => 'Can view visit reports', 'module' => 'reports'],
            ['name' => 'reports_violations', 'display_name' => 'Violation Reports', 'description' => 'Can view violation reports', 'module' => 'reports'],
            ['name' => 'reports_after-hours', 'display_name' => 'After Hours Reports', 'description' => 'Can view after hours reports', 'module' => 'reports'],
            ['name' => 'reports_speed', 'display_name' => 'Speed Reports', 'description' => 'Can view speed violation reports', 'module' => 'reports'],
            ['name' => 'reports_harsh-driving', 'display_name' => 'Harsh Driving Reports', 'description' => 'Can view harsh driving reports', 'module' => 'reports'],
            ['name' => 'reports_fuel', 'display_name' => 'Fuel Reports', 'description' => 'Can view fuel consumption reports', 'module' => 'reports'],
            ['name' => 'reports_toll', 'display_name' => 'Toll Reports', 'description' => 'Can view toll analysis reports', 'module' => 'reports'],
            ['name' => 'reports_working-hours', 'display_name' => 'Working Hours Reports', 'description' => 'Can view working hours reports', 'module' => 'reports'],
            ['name' => 'reports_inspection', 'display_name' => 'Inspection Reports', 'description' => 'Can view inspection schedule reports', 'module' => 'reports'],
            ['name' => 'reports_mileage', 'display_name' => 'Mileage Reports', 'description' => 'Can view mileage tracking reports', 'module' => 'reports'],
            ['name' => 'reports_vehicle-health', 'display_name' => 'Vehicle Health Reports', 'description' => 'Can view vehicle health reports', 'module' => 'reports'],
            ['name' => 'reports_driver-scoring', 'display_name' => 'Driver Scoring Reports', 'description' => 'Can view driver scoring reports', 'module' => 'reports'],
            ['name' => 'reports_export', 'display_name' => 'Export Reports', 'description' => 'Can export reports', 'module' => 'reports'],
            
            // Settings permissions
            ['name' => 'settings_view', 'display_name' => 'View Settings', 'description' => 'Can view system settings', 'module' => 'settings'],
            ['name' => 'settings_edit', 'display_name' => 'Edit Settings', 'description' => 'Can edit system settings', 'module' => 'settings'],
            ['name' => 'settings_fuel', 'display_name' => 'Fuel Settings', 'description' => 'Can manage fuel settings', 'module' => 'settings'],
            ['name' => 'settings_maintenance', 'display_name' => 'Maintenance Settings', 'description' => 'Can manage maintenance settings', 'module' => 'settings'],
            ['name' => 'settings_alerts', 'display_name' => 'Alert Settings', 'description' => 'Can manage alert settings', 'module' => 'settings'],
            ['name' => 'settings_system', 'display_name' => 'System Settings', 'description' => 'Can manage system settings', 'module' => 'settings'],
            
            // User management permissions
            ['name' => 'users.view', 'display_name' => 'View Users', 'description' => 'Can view user list', 'module' => 'users'],
            ['name' => 'users.create', 'display_name' => 'Create Users', 'description' => 'Can create new users', 'module' => 'users'],
            ['name' => 'users.edit', 'display_name' => 'Edit Users', 'description' => 'Can edit user information', 'module' => 'users'],
            ['name' => 'users.delete', 'display_name' => 'Delete Users', 'description' => 'Can delete users', 'module' => 'users'],
            ['name' => 'users.permissions', 'display_name' => 'Manage User Permissions', 'description' => 'Can assign permissions to users', 'module' => 'users'],
        ];

        foreach ($permissions as $permissionData) {
            Permission::firstOrCreate(
                ['name' => $permissionData['name']],
                $permissionData
            );
        }
    }
} 