<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\GeneralSetting;

class GeneralSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get all merchant IDs (assuming you have users/merchants table)
        $merchantIds = \DB::table('users')->pluck('id')->toArray();
        
        // If no merchants found, create a default one
        if (empty($merchantIds)) {
            $merchantIds = [1]; // Default merchant ID
        }

        foreach ($merchantIds as $mid) {
            // Fuel Settings
            $this->createFuelSettings($mid);
            
            // Maintenance Settings
            $this->createMaintenanceSettings($mid);
            
            // Alert Settings
            $this->createAlertSettings($mid);
            
            // System Settings
            $this->createSystemSettings($mid);
        }
    }

    private function createFuelSettings($mid)
    {
        $fuelSettings = [
            [
                'key' => 'fuel_price_diesel',
                'value' => '25.50',
                'type' => 'number',
                'category' => 'fuel',
                'description' => 'Diesel fuel price per liter'
            ],
            [
                'key' => 'fuel_price_gasoline',
                'value' => '28.75',
                'type' => 'number',
                'category' => 'fuel',
                'description' => 'Gasoline fuel price per liter'
            ],
            [
                'key' => 'fuel_price_lpg',
                'value' => '15.20',
                'type' => 'number',
                'category' => 'fuel',
                'description' => 'LPG fuel price per liter'
            ],

        ];

        foreach ($fuelSettings as $setting) {
            GeneralSetting::setValue(
                $mid,
                $setting['key'],
                $setting['value'],
                $setting['type'],
                $setting['category'],
                $setting['description'],
                config('app.store_id') // store_id
            );
        }
    }

    private function createMaintenanceSettings($mid)
    {
        $maintenanceSettings = [
            [
                'key' => 'maintenance_reminder_days',
                'value' => '30',
                'type' => 'number',
                'category' => 'maintenance',
                'description' => 'Days before maintenance reminder'
            ],
            [
                'key' => 'oil_change_km',
                'value' => '10000',
                'type' => 'number',
                'category' => 'maintenance',
                'description' => 'Oil change interval in kilometers'
            ],
            [
                'key' => 'tire_change_km',
                'value' => '50000',
                'type' => 'number',
                'category' => 'maintenance',
                'description' => 'Tire change interval in kilometers'
            ],
            [
                'key' => 'maintenance_enabled',
                'value' => '1',
                'type' => 'boolean',
                'category' => 'maintenance',
                'description' => 'Enable maintenance reminders'
            ]
        ];

        foreach ($maintenanceSettings as $setting) {
            GeneralSetting::setValue(
                $mid,
                $setting['key'],
                $setting['value'],
                $setting['type'],
                $setting['category'],
                $setting['description'],
                config('app.store_id') // store_id
            );
        }
    }

    private function createAlertSettings($mid)
    {
        $alertSettings = [
            [
                'key' => 'speed_limit_default',
                'value' => '90',
                'type' => 'number',
                'category' => 'alerts',
                'description' => 'Default speed limit in km/h'
            ],
            [
                'key' => 'geofence_alerts_enabled',
                'value' => '1',
                'type' => 'boolean',
                'category' => 'alerts',
                'description' => 'Enable geofence alerts'
            ],
            [
                'key' => 'maintenance_alerts_enabled',
                'value' => '1',
                'type' => 'boolean',
                'category' => 'alerts',
                'description' => 'Enable maintenance alerts'
            ],
            [
                'key' => 'fuel_alerts_enabled',
                'value' => '1',
                'type' => 'boolean',
                'category' => 'alerts',
                'description' => 'Enable fuel level alerts'
            ],
            [
                'key' => 'alert_email_enabled',
                'value' => '1',
                'type' => 'boolean',
                'category' => 'alerts',
                'description' => 'Enable email alerts'
            ],
            [
                'key' => 'alert_sms_enabled',
                'value' => '0',
                'type' => 'boolean',
                'category' => 'alerts',
                'description' => 'Enable SMS alerts'
            ]
        ];

        foreach ($alertSettings as $setting) {
            GeneralSetting::setValue(
                $mid,
                $setting['key'],
                $setting['value'],
                $setting['type'],
                $setting['category'],
                $setting['description'],
                config('app.store_id') // store_id
            );
        }
    }

    private function createSystemSettings($mid)
    {
        $systemSettings = [
            [
                'key' => 'timezone',
                'value' => 'Europe/Istanbul',
                'type' => 'string',
                'category' => 'system',
                'description' => 'System timezone'
            ],
            [
                'key' => 'language',
                'value' => 'tr',
                'type' => 'string',
                'category' => 'system',
                'description' => 'System language'
            ],
            [
                'key' => 'date_format',
                'value' => 'd.m.Y',
                'type' => 'string',
                'category' => 'system',
                'description' => 'Date format'
            ],
            [
                'key' => 'time_format',
                'value' => 'H:i',
                'type' => 'string',
                'category' => 'system',
                'description' => 'Time format'
            ],
            [
                'key' => 'auto_backup_enabled',
                'value' => '1',
                'type' => 'boolean',
                'category' => 'system',
                'description' => 'Enable automatic backups'
            ],
            [
                'key' => 'backup_frequency',
                'value' => 'daily',
                'type' => 'string',
                'category' => 'system',
                'description' => 'Backup frequency (daily, weekly, monthly)'
            ],
            [
                'key' => 'currency',
                'value' => 'TRY',
                'type' => 'string',
                'category' => 'system',
                'description' => 'System currency'
            ],
            [
                'key' => 'weight_unit',
                'value' => 'kg',
                'type' => 'string',
                'category' => 'system',
                'description' => 'System weight unit'
            ],
            [
                'key' => 'liquid_unit',
                'value' => 'lt',
                'type' => 'string',
                'category' => 'system',
                'description' => 'System liquid unit'
            ],
            [
                'key' => 'length_unit',
                'value' => 'mt',
                'type' => 'string',
                'category' => 'system',
                'description' => 'System length unit'
            ]
        ];

        foreach ($systemSettings as $setting) {
            GeneralSetting::setValue(
                $mid,
                $setting['key'],
                $setting['value'],
                $setting['type'],
                $setting['category'],
                $setting['description'],
                config('app.store_id') // store_id
            );
        }
    }
}
