<?php

namespace App\View\Components;

use Illuminate\View\Component;
use Illuminate\View\View;

class Modal extends Component
{
    public $id;
    public $title;
    public $size;
    public $centered;
    public $scrollable;
    public $backdrop;
    public $keyboard;
    public $class;
    public $headerClass;
    public $bodyClass;
    public $footerClass;
    public $showCloseButton;
    public $closeButtonText;
    public $footer;
    public $static;

    public function __construct(
        $id = null,
        $title = null,
        $size = 'md',
        $centered = true,
        $scrollable = false,
        $backdrop = true,
        $keyboard = true,
        $class = null,
        $headerClass = null,
        $bodyClass = null,
        $footerClass = null,
        $showCloseButton = true,
        $closeButtonText = 'Close',
        $footer = null,
        $static = false
    ) {
        $this->id = $id ?: 'modal-' . uniqid();
        $this->title = $title;
        $this->size = $size;
        $this->centered = $centered;
        $this->scrollable = $scrollable;
        $this->backdrop = $backdrop;
        $this->keyboard = $keyboard;
        $this->class = $class;
        $this->headerClass = $headerClass;
        $this->bodyClass = $bodyClass;
        $this->footerClass = $footerClass;
        $this->showCloseButton = $showCloseButton;
        $this->closeButtonText = $closeButtonText;
        $this->footer = $footer;
        $this->static = $static;
    }

    public function render(): View
    {
        return view('components.modal');
    }
}
