<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PlaceDevice extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'vts_place_devices';

    /**
     * The primary key associated with the table.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'mid',
        'did',
        'pid',
        'bid',
        'gsm',
        'email',
        'dt',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'mid' => 'integer',
        'bid' => 'integer',
        'dt' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    /**
     * Get the place associated with this device.
     */
    public function place()
    {
        return $this->belongsTo(Place::class, 'pid', 'id');
    }

    /**
     * Get the device associated with this record.
     */
    public function device()
    {
        return $this->belongsTo(Device::class, 'did', 'did');
    }

    /**
     * Get the member/user associated with this record.
     */
    public function member()
    {
        return $this->belongsTo(User::class, 'mid', 'id');
    }
}
