<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Place extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'vts_places';

    /**
     * The primary key associated with the table.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'mid',
        'nm',
        'ord',
        'pcnt',
        'sts',
        'lat',
        'lng',
        'radius',
        'dt',
        'created_at',
        'created_by',
        'updated_at',
        'updated_by',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'mid' => 'integer',
        'ord' => 'integer',
        'pcnt' => 'integer',
        'sts' => 'integer',
        'radius' => 'integer',
        'dt' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    /**
     * Get the devices associated with this place.
     */
    public function devices()
    {
        return $this->hasMany(PlaceDevice::class, 'pid', 'id');
    }

    /**
     * Get the member/user associated with this place.
     */
    public function member()
    {
        return $this->belongsTo(User::class, 'mid', 'id');
    }
}