<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\RegionCoordinatesResource;

class RegionResource extends JsonResource
{
    public function toArray($request)
    {
         $data = [
            'id'   => $this->id,
            'mid'  => $this->mid,
            'name'   => $this->nm,
            'order'  => $this->ord,
            'count' => $this->pcnt,
            'status_id'  => $this->sts,
            'polygon_json'  => $this->ply?json_decode($this->ply, true):[],
            'polygon' => null,
            'price' => $this->price,
            'active' => $this->active,
            'active_name' => $this->active == 1 ? __('Active') : __('Inactive'),
            'match_did'   => $this->match_did,
            'match_status_id' => $this->match_status_id,
            'match_id'   => $this->match_did == null ? 1 : 0,
            'match_name' => $this->match_did == null ? __('Macth') : __('No Match'),
            'created_at'   => $this->created_at,
            'created_by'  => $this->created_by,
            'updated_at'   => $this->updated_at,
            'updated_by'  => $this->updated_by,
        ];

        if ($request->has('edit') && $request->query('edit') == 'true') {
            $data['poly'] = $this->poly;
        }

        return $data;
    }
}

