<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DeviceInfoResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        //{"id":"1","nm":"Mitsubishi Colt","plt":"34VM3894","drvr":"Burak Başaran","lt":"0,06","lttl":"13","icon":"convertible.png","cats":["0"]}
        return [
            'id' => $this->id,
            'nm' => $this->nm,
            'plt' => $this->plt,
            'drvr' => $this->drvr,
            'lt' => $this->lt,
            'lttl' => $this->lttl,
            'icon' => $this->icon,
            'cats' => DeviceCategoryResource::collection($this->cats),
        ];
    }
}
