<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;
use Symfony\Component\HttpFoundation\Response;

class JWTAuthMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        $token = $request->cookie(config('jwt.public_key')); // Cookie'den token'ı al

        if (!$token) {
            return redirect('/login')->with('error', __('Unauthorized access'));
        }

        try {
            // Check if JWT_SECRET is set
            $jwtSecret = config('jwt.secret');
            if (empty($jwtSecret)) {
                // Don't log this as an error - redirect to login instead
                return redirect('/login')->with('error', __('Authentication configuration error'));
            }

            $decoded = JWT::decode($token, new Key($jwtSecret, 'HS256'));
            $request->attributes->set('user', (array) $decoded);
        } catch (\Exception $e) {
            // Don't log JWT authentication errors - just redirect to login
            return redirect('/login')->with('error', __('Invalid token'));
        }

        return $next($request);
    }
}

