# Changelog

All notable changes to Fleet Tracker Pro will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.0.1] - 2025-10-09

### Fixed

-   **JavaScript**: Fixed marker dragging error where `marker.dragging` was undefined
    -   Updated `makeMarkerDraggable()` in `map.js` to initialize dragging handler if not present
    -   Markers created with `draggable: false` can now be made draggable dynamically
-   **JavaScript**: Fixed duplicate radius circles when editing places
    -   Improved circle management to update existing circles instead of creating duplicates
    -   Added proper cleanup in `reloadAllMarkers()` function
    -   Fixed circle updates in `cancelCoordinatesChanges()` and other functions
-   **Backend**: Fixed GPS timestamp issues in device logs
    -   Changed `DeviceController` to use `dt` field instead of `log_datetime` for date filtering
    -   Fixed timezone conversion issues where GPS device times were incorrect
    -   Updated `DeviceLogResource` to prioritize database write time (`dt`) over GPS time
-   **Database**: Migrated data from `device_log_8ps9` to `vts_device_logs` table
    -   Copied 811 records for device `aebcc2b375a24f3f0` (Aug 25-26, 2025)
    -   Copied 33 records for device `352016703347070` with distinct locations
    -   Fixed GPS timestamp for device `352016703347070` (was frozen at 2025-04-22)

### Added

-   **Documentation**: Comprehensive JavaScript libraries documentation
    -   Added complete API reference for all JavaScript functions
    -   Included HTTP/API communication examples
    -   Documented Leaflet map management functions
    -   Added Tabulator table examples
    -   Included UI/UX component usage
    -   Added localization and helper function references
    -   Included complete working examples
-   **Documentation**: Enhanced README.md with developer-focused content
    -   Added "Built for Developers" section
    -   Listed all supported map providers
    -   Highlighted Tabler framework features
    -   Emphasized customization capabilities
-   **Documentation**: Created CodeCanyon product description
    -   Professional marketing copy for marketplace
    -   Technical specifications and features
    -   Use cases and target audiences

### Improved

-   Better error handling in places management
-   More reliable circle and marker cleanup
-   Improved data migration utilities
-   Enhanced code comments and documentation

## [1.0.0] - 2025-10-08

### Initial Release

#### Added

-   Real-time GPS vehicle tracking with Leaflet maps
-   Multi-tenant architecture supporting multiple organizations
-   JWT-based authentication system
-   Role-based access control with granular permissions
-   12+ comprehensive reporting modules:
    -   Parking Analysis Report
    -   Mileage Tracking Report
    -   Vehicle Health Report
    -   Working Hours Report
    -   Visit Report (Places & Regions)
    -   Zone Violations Report
    -   Speed Violations Report
    -   After Hours Activity Report
    -   Fuel Consumption Report
    -   Route Efficiency Report
    -   Inspection Schedule Report
    -   Driver Scoring Report
-   Geofencing system with regions (polygons) and places (circular)
-   Vehicle management with categories
-   User management with permission system
-   Multi-language support (English, Turkish)
-   Alert and notification system
-   System settings management
-   Responsive dashboard design
-   Modern UI with Tabler framework
-   Interactive maps with route replay
-   Chart visualizations for analytics
-   Exportable reports (CSV, Excel)
-   Profile management with avatar upload
-   Dark/light theme support

#### Database

-   Optimized database structure
-   Proper indexing for performance
-   Support for large datasets
-   Efficient query optimization

#### Security

-   CSRF protection on all forms
-   SQL injection prevention via Eloquent ORM
-   XSS protection via Blade templating
-   Secure password hashing
-   JWT token-based API authentication
-   Input validation and sanitization

#### Performance

-   Lazy loading for large datasets
-   Query optimization with proper indexes
-   Efficient map rendering
-   Asset optimization
-   Cache support

---

## Future Releases

### Planned Features

-   Mobile app (iOS/Android)
-   Advanced driver behavior analysis
-   Fuel card integration
-   Maintenance scheduling automation
-   Push notifications
-   SMS/Email notifications
-   Live traffic data integration
-   Weather data integration
-   Advanced analytics dashboard
-   API webhooks
-   Third-party integrations

---

## Version History

-   **v1.0.0** (2025-10-08) - Initial public release

---

**Note**: This is the first public release. Future updates will include bug fixes, performance improvements, and new features based on user feedback.
