<?php
    $formGroupClass = 'mb-3';
    $labelClass = 'form-label';
    $inputClass = 'form-control';
    $helpClass = 'form-text';
    $errorClass = 'invalid-feedback';
    
    // Size classes
    if ($size === 'sm') {
        $inputClass .= ' form-control-sm';
    } elseif ($size === 'lg') {
        $inputClass .= ' form-control-lg';
    }
    
    // Error state
    if ($error) {
        $inputClass .= ' is-invalid';
    }
    
    // Add custom classes
    if ($class) {
        $inputClass .= ' ' . $class;
    }
    
    // Inline form
    if ($inline) {
        $formGroupClass = 'mb-3 me-3';
    }
?>

<div class="<?php echo e($formGroupClass); ?>">
    <?php if($label && !in_array($type, ['checkbox', 'radio'])): ?>
        <label for="<?php echo e($id); ?>" class="<?php echo e($labelClass); ?>">
            <?php echo e($label); ?>

            <?php if($required): ?>
                <span class="text-danger">*</span>
            <?php endif; ?>
        </label>
    <?php endif; ?>

    <?php switch($type):
        case ('textarea'): ?>
            <textarea 
                name="<?php echo e($name); ?>" 
                id="<?php echo e($id); ?>" 
                class="<?php echo e($inputClass); ?>" 
                placeholder="<?php echo e($placeholder); ?>"
                rows="<?php echo e($rows); ?>"
                <?php if($cols): ?> cols="<?php echo e($cols); ?>" <?php endif; ?>
                <?php if($required): ?> required <?php endif; ?>
                <?php if($disabled): ?> disabled <?php endif; ?>
                <?php if($readonly): ?> readonly <?php endif; ?>
            ><?php echo e($value); ?></textarea>
            <?php break; ?>

        <?php case ('select'): ?>
            <select 
                name="<?php echo e($name); ?>" 
                id="<?php echo e($id); ?>" 
                class="<?php echo e($inputClass); ?>"
                <?php if($required): ?> required <?php endif; ?>
                <?php if($disabled): ?> disabled <?php endif; ?>
                <?php if($multiple): ?> multiple <?php endif; ?>
            >
                <?php if($placeholder && !$multiple): ?>
                    <option value=""><?php echo e($placeholder); ?></option>
                <?php endif; ?>
                <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $optionValue => $optionLabel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option 
                        value="<?php echo e($optionValue); ?>" 
                        <?php if($value == $optionValue || (is_array($value) && in_array($optionValue, $value))): ?> selected <?php endif; ?>
                    >
                        <?php echo e($optionLabel); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <?php break; ?>

        <?php case ('checkbox'): ?>
            <div class="form-check">
                <input 
                    type="checkbox" 
                    name="<?php echo e($name); ?>" 
                    id="<?php echo e($id); ?>" 
                    class="form-check-input"
                    value="1"
                    <?php if($checked): ?> checked <?php endif; ?>
                    <?php if($required): ?> required <?php endif; ?>
                    <?php if($disabled): ?> disabled <?php endif; ?>
                >
                <?php if($label): ?>
                    <label for="<?php echo e($id); ?>" class="form-check-label">
                        <?php echo e($label); ?>

                        <?php if($required): ?>
                            <span class="text-danger">*</span>
                        <?php endif; ?>
                    </label>
                <?php endif; ?>
            </div>
            <?php break; ?>

        <?php case ('radio'): ?>
            <div class="form-check">
                <input 
                    type="radio" 
                    name="<?php echo e($name); ?>" 
                    id="<?php echo e($id); ?>" 
                    class="form-check-input"
                    value="<?php echo e($value); ?>"
                    <?php if($checked): ?> checked <?php endif; ?>
                    <?php if($required): ?> required <?php endif; ?>
                    <?php if($disabled): ?> disabled <?php endif; ?>
                >
                <?php if($label): ?>
                    <label for="<?php echo e($id); ?>" class="form-check-label">
                        <?php echo e($label); ?>

                        <?php if($required): ?>
                            <span class="text-danger">*</span>
                        <?php endif; ?>
                    </label>
                <?php endif; ?>
            </div>
            <?php break; ?>

        <?php case ('file'): ?>
            <input 
                type="file" 
                name="<?php echo e($name); ?>" 
                id="<?php echo e($id); ?>" 
                class="<?php echo e($inputClass); ?>"
                <?php if($required): ?> required <?php endif; ?>
                <?php if($disabled): ?> disabled <?php endif; ?>
                <?php if($multiple): ?> multiple <?php endif; ?>
            >
            <?php break; ?>

        <?php default: ?>
            <input 
                type="<?php echo e($type); ?>" 
                name="<?php echo e($name); ?>" 
                id="<?php echo e($id); ?>" 
                class="<?php echo e($inputClass); ?>" 
                placeholder="<?php echo e($placeholder); ?>"
                value="<?php echo e($value); ?>"
                <?php if($required): ?> required <?php endif; ?>
                <?php if($disabled): ?> disabled <?php endif; ?>
                <?php if($readonly): ?> readonly <?php endif; ?>
            >
    <?php endswitch; ?>

    <?php if($helpText): ?>
        <div class="<?php echo e($helpClass); ?>">
            <?php echo e($helpText); ?>

        </div>
    <?php endif; ?>

    <?php if($error): ?>
        <div class="<?php echo e($errorClass); ?>">
            <?php echo e($error); ?>

        </div>
    <?php endif; ?>
</div>
<?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views\components\form.blade.php ENDPATH**/ ?>