<?php
    $buttonClasses = ['btn'];
    
    // Type class
    if ($outline) {
        $buttonClasses[] = 'btn-outline-' . $type;
    } else {
        $buttonClasses[] = 'btn-' . $type;
    }
    
    // Size class
    if ($size === 'sm') {
        $buttonClasses[] = 'btn-sm';
    } elseif ($size === 'lg') {
        $buttonClasses[] = 'btn-lg';
    }
    
    // Custom class
    if ($class) {
        $buttonClasses[] = $class;
    }
    
    $buttonClass = implode(' ', $buttonClasses);
    
    // Icon HTML
    $iconHtml = '';
    if ($icon) {
        $iconClass = strpos($icon, ' ') !== false ? $icon : 'ti ti-' . $icon;
        $iconHtml = '<i class="' . $iconClass . '"></i>';
    }
?>

<?php if($href): ?>
    <a href="<?php echo e($href); ?>" 
       <?php if($target): ?> target="<?php echo e($target); ?>" <?php endif; ?>
       <?php if($onclick): ?> onclick="<?php echo e($onclick); ?>" <?php endif; ?>
       <?php if($id): ?> id="<?php echo e($id); ?>" <?php endif; ?>
       class="<?php echo e($buttonClass); ?>"
       <?php if($disabled): ?> disabled <?php endif; ?>>
        <?php if($icon && $iconPosition === 'left'): ?>
            <?php echo $iconHtml; ?>

        <?php endif; ?>
        <?php echo e($slot); ?>

        <?php if($icon && $iconPosition === 'right'): ?>
            <?php echo $iconHtml; ?>

        <?php endif; ?>
    </a>
<?php else: ?>
    <button type="button"
            <?php if($onclick): ?> onclick="<?php echo e($onclick); ?>" <?php endif; ?>
            <?php if($id): ?> id="<?php echo e($id); ?>" <?php endif; ?>
            class="<?php echo e($buttonClass); ?>"
            <?php if($disabled): ?> disabled <?php endif; ?>>
        <?php if($icon && $iconPosition === 'left'): ?>
            <?php echo $iconHtml; ?>

        <?php endif; ?>
        <?php echo e($slot); ?>

        <?php if($icon && $iconPosition === 'right'): ?>
            <?php echo $iconHtml; ?>

        <?php endif; ?>
    </button>
<?php endif; ?><?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views\components\button.blade.php ENDPATH**/ ?>