<?php $__env->startSection('title', __('Vehicle History') ); ?>

<?php $__env->startSection('content'); ?>

<!-- Page header -->
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <!-- Page pre-title -->
                <div class="page-pretitle">
                    <?php echo e(__('Vehicle Monitoring')); ?>

                </div>
                <h2 class="page-title" id="page-title">
                    <?php echo e(__('Vehicle History')); ?>

                </h2>
            </div>
            <div class="col-auto ms-auto d-print-none">
                <div class="btn-list">
                    <button class="btn btn-outline-secondary" id="back-to-vehicles" onclick="window.location.href = '/vehicles-list'">
                        <i class="ti ti-arrow-left me-1"></i>
                        <?php echo e(__('Back to Vehicles')); ?>

                    </button>
                    <button class="btn btn-primary" id="fullscreen-btn">
                        <i class="ti ti-maximize me-1"></i>
                        <?php echo e(__('Fullscreen')); ?>

                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Page body -->
<div class="page-body">
    <div class="container-xl">
        <!-- Modern Stat Cards Row -->
        <div class="row row-deck row-cards mb-3" >
            <!-- Total Points Card -->
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="subheader"><?php echo e(__('Total Points')); ?></div>
                            <div class="ms-auto lh-1">
                                <i class="ti ti-location ms-1 text-primary" style="font-size: 1.5rem;"></i>
                            </div>
                        </div>
                        <div class="d-flex align-items-baseline">
                            <div class="h1 mb-0 me-2" id="total-points">0</div>
                        </div>
                        <div id="apex-total-points" style="width: 100%; height: 40px;"></div>
                        <div class="text-muted"><?php echo e(__('GPS coordinates recorded')); ?></div>
                    </div>
                </div>
            </div>
            <!-- Total Distance Card -->
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="subheader"><?php echo e(__('Total Distance')); ?></div>
                            <div class="ms-auto lh-1">
                                <i class="ti ti-road ms-1 text-success" style="font-size: 1.5rem;"></i>
                            </div>
                        </div>
                        <div class="d-flex align-items-baseline">
                            <div class="h1 mb-0 me-2" id="total-distance">0 <?php echo e(__('km')); ?></div>
                        </div>
                        <div id="apex-total-distance" style="width: 100%; height: 40px;"></div>
                        <div class="text-muted"><?php echo e(__('Route distance')); ?></div>
                    </div>
                </div>
            </div>
            <!-- Avg Speed Card -->
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="subheader"><?php echo e(__('Avg Speed')); ?></div>
                            <div class="ms-auto lh-1">
                                <i class="ti ti-brand-speedtest ms-1 text-info" style="font-size: 1.5rem;"></i>
                            </div>
                        </div>
                        <div class="d-flex align-items-baseline">
                            <div class="h1 mb-0 me-2" id="avg-speed">0 <?php echo e(__('km/h')); ?></div>
                        </div>
                        <div id="apex-avg-speed" style="width: 100%; height: 40px;"></div>
                        <div class="text-muted"><?php echo e(__('Average speed')); ?></div>
                    </div>
                </div>
            </div>
            <!-- Total Duration Card -->
            <div class="col-sm-6 col-lg-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="subheader"><?php echo e(__('Duration')); ?></div>
                            <div class="ms-auto lh-1">
                                <i class="ti ti-clock ms-1 text-warning" style="font-size: 1.5rem;"></i>
                            </div>
                        </div>
                        <div class="d-flex align-items-baseline">
                            <div class="h1 mb-0 me-2" id="total-duration">0<?php echo e(__('h')); ?> 0<?php echo e(__('m')); ?></div>
                        </div>
                        <div id="apex-total-duration" style="width: 100%; height: 40px;"></div>
                        <div class="text-muted"><?php echo e(__('Total time')); ?></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Content -->
        <div class="row align-items-stretch mb-3">
            <div class="col-lg-3 d-flex">
                <div class="card h-100 w-100">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="ti ti-settings me-2"></i>
                            <?php echo e(__('Controls')); ?>

                        </h3>
                    </div>
                    <div class="card-body">
                        <!-- Date and Time Filters -->
                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('Date')); ?></label>
                            <input type="date" id="date" class="form-control" />
                        </div>
                        <div class="row mb-3">
                            <div class="col-6">
                                <label class="form-label"><?php echo e(__('Start Time')); ?></label>
                                <input type="time" id="start_time" class="form-control" />
                            </div>
                            <div class="col-6">
                                <label class="form-label"><?php echo e(__('End Time')); ?></label>
                                <input type="time" id="end_time" class="form-control" />
                            </div>
                        </div>
                        <button class="btn btn-primary w-100 mb-3" id="postMapData">
                            <i class="ti ti-search me-1"></i>
                            <?php echo e(__('Update Route')); ?>

                        </button>

                        <!-- Vehicle Status Filter -->
                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('Vehicle Status')); ?></label>
                            <select id="status-filter" class="form-select">
                                <option value="all"><?php echo e(__('All')); ?></option>
                                <option value="Waiting"><?php echo e(__('Waiting')); ?></option>
                                <option value="Moving"><?php echo e(__('Moving')); ?></option>
                                <option value="Parked"><?php echo e(__('Parked')); ?></option>
                                <option value="Stopped"><?php echo e(__('Stopped')); ?></option>
                                <option value="Offline"><?php echo e(__('Offline')); ?></option>
                            </select>
                        </div>

                        <!-- Quick Actions -->
                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('Quick Actions')); ?></label>
                            <div class="d-grid gap-2">
                                <button class="btn btn-outline-info btn-sm" id="fit-route">
                                    <i class="ti ti-arrows-maximize me-1"></i>
                                    <?php echo e(__('Fit Route')); ?>

                                </button>
                                <button class="btn btn-outline-secondary btn-sm" id="toggle-markers">
                                    <i class="ti ti-map-pin me-1"></i>
                                    <?php echo e(__('Toggle Markers')); ?>

                                </button>
                                <button class="btn btn-outline-warning btn-sm" id="toggle-start-end">
                                    <i class="ti ti-crosshair me-1"></i>
                                    <?php echo e(__('Focus Start/End')); ?>

                                </button>
                            </div>
                        </div>

                        <!-- Reports -->
                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('Reports')); ?></label>
                            <div class="d-grid gap-2">
                                <a id="daily_summary_link" class="btn btn-outline-success btn-sm">
                                    <i class="ti ti-report me-1"></i>
                                    <?php echo e(__('Daily Report')); ?>

                                </a>
                                <button class="btn btn-outline-info btn-sm" id="speed-analysis">
                                    <i class="ti ti-brand-speedtest me-1"></i>
                                    <?php echo e(__('Speed Analysis')); ?>

                                </button>
                            </div>
                        </div>

                        <!-- Route Info -->
                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('Route Information')); ?></label>
                            <div class="list-group list-group-flush">
                                <div class="list-group-item d-flex justify-content-between align-items-center">
                                    <span><?php echo e(__('Start Time')); ?></span>
                                    <span id="route-start-time">-</span>
                                </div>
                                <div class="list-group-item d-flex justify-content-between align-items-center">
                                    <span><?php echo e(__('End Time')); ?></span>
                                    <span id="route-end-time">-</span>
                                </div>
                                <div class="list-group-item d-flex justify-content-between align-items-center">
                                    <span><?php echo e(__('Max Speed')); ?></span>
                                    <span id="max-speed">-</span>
                                </div>
                                <div class="list-group-item d-flex justify-content-between align-items-center">
                                    <span><?php echo e(__('Stops')); ?></span>
                                    <span id="total-stops">-</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Map Area -->
            <div class="col-lg-9 d-flex">
                <div class="card h-100 w-100">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="ti ti-map me-2"></i>
                            <?php echo e(__('Route Map')); ?>

                        </h3>
                        <div class="card-actions">
                            <button class="btn btn-sm btn-outline-secondary" id="toggle-sidebar">
                                <i class="ti ti-chevron-left"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div id="map1" class="h-100 w-100"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Hour Range Slider (after map) -->
        <div class="container-xl mb-3 px-0">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <label class="form-label"><?php echo e(__('Hour Range')); ?></label>
                            <div id="range-connect"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Route Analysis Charts -->
    <div class="container-xl">
        <!-- Speed and Activity Charts Row -->
        <div class="row row-deck row-cards mb-3">
            <!-- Speed Distribution Chart -->
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="ti ti-brand-speedtest me-2"></i>
                            <?php echo e(__('Speed Distribution')); ?>

                        </h3>
                    </div>
                    <div class="card-body">
                        <div id="speed-distribution-chart" style="height: 300px;">
                            <div class="text-center p-4">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="visually-hidden"><?php echo e(__('Loading...')); ?></span>
                                </div>
                                <div class="mt-2"><?php echo e(__('Loading chart...')); ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Time Activity Chart -->
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="ti ti-clock me-2"></i>
                            <?php echo e(__('Hourly Activity')); ?>

                        </h3>
                    </div>
                    <div class="card-body">
                        <div id="hourly-activity-chart" style="height: 300px;"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Route Performance Charts -->
        <div class="row row-deck row-cards mb-3">
            <!-- Route Performance Chart -->
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="ti ti-trending-up me-2"></i>
                            <?php echo e(__('Route Performance')); ?>

                        </h3>
                    </div>
                    <div class="card-body">
                        <div id="route-performance-chart" style="height: 250px;"></div>
                    </div>
                </div>
            </div>
            
            <!-- Status Distribution Chart -->
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="ti ti-chart-pie me-2"></i>
                            <?php echo e(__('Status Distribution')); ?>

                        </h3>
                    </div>
                    <div class="card-body">
                        <div id="status-distribution-chart" style="height: 250px;"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <style>
        #map1 { height: 70vh; width: 100%; }
        
        /* Sidebar toggle functionality */
        .sidebar-collapsed .col-lg-3 {
            width: 0 !important;
            height: 0 !important;
            padding: 0 !important;
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .sidebar-collapsed .col-lg-9 {
            width: 100% !important;
            transition: all 0.3s ease;
        }

        .col-lg-3, .col-lg-9 {
            transition: all 0.3s ease;
        }

        #toggle-sidebar {
            transition: all 0.3s ease;
        }

        #toggle-sidebar:hover {
            transform: scale(1.1);
        }

        /* Statistics cards styling */
        .card .h1 {
            color: var(--tblr-primary);
            font-weight: 600;
        }

        .subheader {
            color: var(--tblr-secondary);
            font-size: 0.875rem;
            font-weight: 500;
        }

        /* Route info styling */
        .list-group-item {
            border: none;
            padding: 0.5rem 0;
            font-size: 0.875rem;
        }

        .list-group-item span:last-child {
            font-weight: 600;
            color: var(--tblr-primary);
        }

        /* Responsive design */
        @media (max-width: 991.98px) {
            .col-lg-3 {
                order: 2;
            }

            .col-lg-9 {
                order: 1;
            }

            .sidebar-collapsed .col-lg-3 {
                display: none;
            }
        }

        /* Map controls styling */
        .map-controls {
            position: absolute;
            top: 10px;
            right: 10px;
            z-index: 1000;
            background: white;
            border-radius: 4px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            padding: 5px;
        }

        /* Fullscreen mode */
        .fullscreen-mode {
            position: fixed;
            top: 0;
            left: 0;
            width: 100vw;
            height: 100vh;
            z-index: 9999;
            background: white;
        }

        .fullscreen-mode #map1 {
            height: 100vh !important;
        }

        .noUi-origin {
            z-index: 4 !important;
        }
        .noUi-origin:hover, .noUi-origin:focus {
            z-index: 5 !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

    <script>
        var menuModel = {
            actives : ["a_maps_li"],
            shows: ["s_map_li_a","s_map_div"]
        };
        menuSets(menuModel);

        // Global variables
        var myMap, markers = [], routeData = [], isSidebarCollapsed = false;
        const decodedUrl = Base64Helper.decode("<?php echo e($data); ?>");
        var startEndMarkers = [], routeMarkers = [];
        var markersVisible = true;
        
        // Unit variables
        var speedUnit = "";
        var lengthUnit = "";
        var currency = "";

        onAppReady(function () {
            // Initialize the page
            initializePage();
        });

        function initializePage() {

            // Set initial form values
            $("#date").val(decodedUrl.date);
            $("#start_time").val(decodedUrl.start_time);
            $("#end_time").val(decodedUrl.end_time);

            // Load initial data
            loadRouteData();

            // Setup event listeners
            setupEventListeners();
        }

        function loadRouteData() {
            http.post({
                url: "/vehicle-map",
                data: {
                    data: "<?php echo e($data); ?>"
                }
            }).then((response) => {
                
                console.log(response.data);

                var _routeData = response.data.coordinates;
                var vehicle = response.data.vehicle;
                var regions = response.data.regions;
                var places = response.data.places;

    
                // Set units after data is loaded
                speedUnit = sessionSettings.speedUnit || 'km/h';
                lengthUnit = sessionSettings.lengthUnit || 'km';
                currency = sessionSettings.currency || 'TRY';

                // Update page title - handle both old and new vehicle data structure
                var vehicleName = vehicle && vehicle.length > 0 ? 
                    (vehicle[0].device_name || vehicle[0].name || 'Unknown Vehicle') : 'Unknown Vehicle';
                $(`#page-title`).html(vehicleName);
                document.title = vehicleName + " | " + __("Red Takip");

                // Add first point (no previous point to calculate distance from)
                if (_routeData.length > 0) {
                    _routeData[0].distance = 0; // First point has 0 distance
                    routeData.push(_routeData[0]);
                }
                
                // Calculate distance for remaining points
                for (var i = 1; i < _routeData.length; i++) {
                    var distance = calculateDistance(
                        _routeData[i-1].latitude, _routeData[i-1].longitude,
                        _routeData[i].latitude, _routeData[i].longitude
                    );
                    //console.log("distance", distance);
                    if(distance < 0){
                        //console.log("distance is negative", distance);
                        continue;
                    }

                    _routeData[i].distance = distance;

                    routeData.push(_routeData[i]);
                }

                // Calculate and display statistics
                calculateAndDisplayStats(routeData);

                // Initialize map
                initializeMap(routeData, regions, places);

                // Update route information
                updateRouteInfo(routeData);

                // Initialize sparklines with real data
                initializeSparklines();

                // Initialize additional charts
                initializeAdditionalCharts();

                // Initialize hour range slider
                initializeHourRangeSlider();
            });
        }

        function calculateAndDisplayStats(data) {
            if (!data || data.length === 0) return;

            var totalPoints = data.length;
            var totalDistance = 0;
            var totalSpeed = 0;
            var maxSpeed = 0;
            var stops = 0;
            var startTime = new Date(data[0].timestamp);
            var endTime = new Date(data[data.length - 1].timestamp);

            // Calculate distance and speed statistics
            for (var i = 1; i < data.length; i++) {
                var curr = data[i];
                // Use backend-provided distance
                var distance = curr.distance || 0;
                totalDistance += distance;

                // Speed calculations
                var speed = parseFloat(curr.speed) || 0;
                totalSpeed += speed;
                if (speed > maxSpeed) maxSpeed = speed;

                // Count stops (speed < 5 km/h)
                if (speed < 5) stops++;
            }

            var avgSpeed = totalSpeed / totalPoints;
            var duration = (endTime - startTime) / (1000 * 60 * 60); // hours

            // Update statistics cards
            $("#total-points").text(totalPoints.toLocaleString());
            $("#total-distance").text(totalDistance.toFixed(2) + " " + lengthUnit);
            $("#avg-speed").text(avgSpeed.toFixed(1) + " " + __(speedUnit));
            $("#total-duration").text(formatDuration(duration));

            // Update route info
            $("#route-start-time").text(data[0].timestamp_ui);
            $("#route-end-time").text(data[data.length - 1].timestamp_ui);
            $("#max-speed").text(maxSpeed.toFixed(1) + " " + __(speedUnit));
            $("#total-stops").text(stops);
        }

        function formatDuration(hours) {
            var h = Math.floor(hours);
            var m = Math.floor((hours - h) * 60);
            return h + " " + __('h') + " " + m + " " + __('m');
        }

        function initializeMap(data, regions, places) {
            // Create markers from route data
            markers = [];
            routeMarkers = [];
            startEndMarkers = [];
                        
            for (var i = 0; i < data.length; i++) {
                // Validate coordinates before creating marker
                var lat = parseFloat(data[i].latitude);
                var lon = parseFloat(data[i].longitude);

                // Skip invalid coordinates
                if (isNaN(lat) || isNaN(lon) || lat === 0 || lon === 0) {
                    console.warn('Skipping invalid coordinates:', data[i]);
                    continue;
                }
                
                var datetime = data[i].timestamp_ui;
                var speed = Number(data[i].speed*1).toFixed(2) + " " + __(speedUnit);
                var ang = Number(data[i].direction*1).toFixed(0) + "°";
                
                let popup = `
                    <div class="">
                        <div><i class="me-2 ti ti-road"></i>${__(data[i].status_name || 'Unknown')}</div>
                        <div><i class="me-2 ti ti-brand-speedtest"></i>${speed}</div>
                        <div><i class="me-2 ti ti-calendar-pin"></i>${datetime}</div>
                        <div><i class="me-2 ti ti-compass"></i>${ang}</div>
                    </div>
                `;

                //console.log(data[i].timestamp);

                var marker = {
                    id: rand_id(),
                    device_id: 0,
                    label: null,
                    group: "route",
                    timestamp: data[i].timestamp,
                    status: data[i].status_name || 'Unknown',
                    popup: popup,
                    coord: [lat, lon],
                    icon: {
                        name: data[i].direction != null ? "fa-solid fa-location-arrow" : null,
                        color: data[i].status_color || "black",
                        direction: data[i].direction != null ? Number(data[i].direction) : 0,
                        className: "",
                    }
                };
                
                markers.push(marker);
                routeMarkers.push(marker);
            }

            // Initialize map
            myMap = new LeafletMap();
            myMap.initMap("map1", {});

            // Add markers to map
            myMap.pinMarkers(markers);
            // Add route polyline - only if we have valid markers
            if (markers.length > 0) {
                var polylineCoord = markers.map(function (marker) {
                    return marker.coord;
                });

                // Validate polyline coordinates
                var validCoords = polylineCoord.filter(function(coord) {
                    return coord && coord.length === 2 && 
                           !isNaN(coord[0]) && !isNaN(coord[1]) && 
                           coord[0] !== 0 && coord[1] !== 0;
                });

                if (validCoords.length > 1) {
                    myMap.addPolyline({
                        coords: validCoords,
                        color: '#d63939',
                        weight: 2,
                        opacity: 0.5,
                        smoothFactor: 1
                    });
                } else {
                    console.warn('Not enough valid coordinates for polyline');
                }
            }

            // Add start and end markers
            addStartEndMarkers();

            // Add regions and places
            addRegionsAndPlaces(regions, places);

            // Fit bounds to show entire route - only if we have valid markers
            if (markers.length > 0 && myMap.markerBounds && myMap.markerBounds.length > 0) {
                try {
                    myMap.fitBounds();
                } catch (error) {
                    console.warn('Could not fit bounds:', error);
                    // Fallback to default view or first marker
                    if (markers[0] && markers[0].coord && markers[0].coord[0] !== 0 && markers[0].coord[1] !== 0) {
                        myMap.mapLet.setView(markers[0].coord, 15);
                    }
                }
            } else {
                console.warn('No valid markers to fit bounds to');
                // Set default view if no markers
                myMap.mapLet.setView([39.5815051, 34.5783959], 10); // Turkey center
            }
        }

        function addStartEndMarkers() {
            if (markers.length === 0) return;

            var markerColor = "gray";

            // Add start marker (first valid marker)
            var markerFirst = markers[0];
            if (markerFirst && markerFirst.coord && markerFirst.coord[0] !== 0 && markerFirst.coord[1] !== 0) {
                var markerFirstModel = [{
                    id: markerFirst.id,
                    device_id: markerFirst.device_id,
                    label: __("Start Point"),
                    status: markerFirst.status,
                    coord: markerFirst.coord,
                    group: "startEnd",
                    icon: {
                        name: "fa-solid fa-map-pin",
                        color: markerColor,
                        direction: 0,
                        className: "",
                        anchor: [0, 25],
                    }
                }];
                startEndMarkers.push(markerFirstModel[0]);
                myMap.pinMarkers(markerFirstModel);
            }

            // Add end marker (last valid marker)
            var markerLast = markers[markers.length - 1];
            if (markerLast && markerLast.coord && markerLast.coord[0] !== 0 && markerLast.coord[1] !== 0 && 
                markerLast.id !== markerFirst.id) {
                var markerLastModel = [{
                    id: markerLast.id,
                    device_id: markerLast.device_id,
                    label: __("End Point"),
                    status: markerLast.status,
                    coord: markerLast.coord,
                    group: "startEnd",
                    icon: {
                        name: "fa-solid fa-map-pin",
                        color: markerColor,
                        direction: 0,
                        className: "",
                        anchor: [0, 25],
                    }
                }];
                startEndMarkers.push(markerLastModel[0]);
                myMap.pinMarkers(markerLastModel);
            }
        }

        function addRegionsAndPlaces(regions, places) {
            // Add regions
            regions.forEach(function (da) {
                myMap.addPolygon({
                    id: da.id,
                    label: da.name,
                    color: "gray",
                    fillColor: "gray",
                    coords: da.polygon_json,
                });
            });

            // Add places
            var placeMarkerColor = "gray";
            places.forEach(function (place) {
                if (place.latitude && place.longitude) {
                    var marker = [{
                        id: place.id,
                        markerClassName: "place-marker",
                        device_id: 0,
                        label: place.name,
                        status: place.status_id,
                        popup: place.name,
                        coord: [
                            parseFloat(place.latitude),
                            parseFloat(place.longitude),
                        ],
                        icon: {
                            name: "fa-solid fa-location-dot",
                            color: placeMarkerColor,
                            direction: 0,
                            className: "",
                        },
                    }];
                    myMap.pinMarkers(marker);
                    
                    if (place.radius && place.radius > 0) {
                        var circle = L.circle([place.latitude, place.longitude], {
                            radius: place.radius,
                            color: placeMarkerColor,
                            fillColor: placeMarkerColor,
                            fillOpacity: 0.2,
                        }).addTo(myMap.mapLet);
                    }
                }
            });
        }

        function updateRouteInfo(data) {
            if (!data || data.length === 0) return;

            var startTime = new Date(data[0].timestamp);
            var endTime = new Date(data[data.length - 1].timestamp);
            var maxSpeed = 0;

            data.forEach(function(point) {
                var speed = parseFloat(point.speed) || 0;
                if (speed > maxSpeed) maxSpeed = speed;
            });

            $("#route-start-time").text(data[0].timestamp_ui);
            $("#route-end-time").text(data[data.length - 1].timestamp_ui);
            $("#max-speed").text(maxSpeed.toFixed(1) + " " + __(speedUnit));
        }

        function setupEventListeners() {
            // Update route button
            $("#postMapData").click(function() {
                updateRoute();
            });

            // Toggle sidebar
            $("#toggle-sidebar").click(function() {
                isSidebarCollapsed = !isSidebarCollapsed;
                $(".page-body").toggleClass("sidebar-collapsed", isSidebarCollapsed);
                $(this).find("i").toggleClass("ti-chevron-left ti-chevron-right");
                
                // Trigger map resize
                setTimeout(function() {
                    if (myMap && myMap.mapLet) {
                        myMap.mapLet.invalidateSize();
                    }
                }, 300);
            });

            // Fullscreen button
            $("#fullscreen-btn").click(function() {
                if (!document.fullscreenElement) {
                    document.documentElement.requestFullscreen();
                } else {
                    document.exitFullscreen();
                }
            });

            // Quick action buttons
            $("#fit-route").click(function() {
                if (myMap && myMap.markersAll.length > 0 && myMap.markerBounds && myMap.markerBounds.length > 0) {
                    try {
                        myMap.fitBounds();
                    } catch (error) {
                        console.warn('Could not fit bounds:', error);
                        showNotification('warning', __('Could not fit route to view. Please check if route data is valid.'));
                    }
                } else {
                    showNotification('warning', __('No route data available to fit to view.'));
                }
            });

            $("#toggle-markers").click(function() {

                if (myMap && myMap.markersAll.length > 0) {
                    var routeMarkers = myMap.markersAll.filter( m=>m.group == "route");

                    if (markersVisible) {
                        // Hide route markers using filterMarkers
                        // Filter out null values and start/end markers
                        var markerIds = routeMarkers.map(function(marker) {
                            // Don't hide start/end markers
                            if (startEndMarkers.length > 0 && 
                                (marker.id == startEndMarkers[0]?.id || marker.id == startEndMarkers[1]?.id)) {
                                return null;
                            }
                            return marker.id;
                        }).filter(function(id) { return id !== null; });
                        
                        if (markerIds.length > 0) {
                            myMap.filterMarkers({ ids: markerIds, show: 0 });
                        }
                        markersVisible = false;
                        $(this).html('<i class="ti ti-map-pin me-1"></i>' + __('Show Markers'));
                    } else {
                        // Show route markers using filterMarkers
                        var markerIds = routeMarkers.map(function(marker) {
                            return marker.id;
                        });
                        myMap.filterMarkers({ ids: markerIds, show: 1 });
                        markersVisible = true;
                        $(this).html('<i class="ti ti-map-pin me-1"></i>' + __('Hide Markers'));
                    }
                }
            });

            $("#toggle-start-end").click(function() {
                if (myMap && startEndMarkers.length > 0) {
                    // Focus on start and end points
                    var bounds = L.latLngBounds([
                        startEndMarkers[0].coord,  // Start point
                        startEndMarkers[1].coord   // End point
                    ]);
                    myMap.mapLet.fitBounds(bounds, { padding: [20, 20] });
                }
            });

            $("#speed-analysis").click(function() {
                showSpeedAnalysis();
            });

            // Daily summary link
            $("#daily_summary_link").click(function() {
                var daily_summary_data = Base64Helper.encode({
                    did: decodedUrl.did,
                    date: $("#date").val(),
                    start_time: $("#date").val() + " " + $("#start_time").val(),
                    end_time: $("#date").val() + " " + $("#end_time").val()
                });
                window.location.href = `/reports/daily-summary/${daily_summary_data}`;
            });

            // Back to vehicles button
            $("#back-to-vehicles").click(function() {
                window.history.back();
            });

            // Vehicle status filter
            $("#status-filter").on("change", function() {
                var selectedStatus = $(this).val();
                var markerIdsToShow = [];

                if (selectedStatus === "all") {
                    // Show all route markers except start/end
                    markerIdsToShow = myMap.markersAll
                        .filter(function(marker) {
                            return marker.group === "route" && 
                                   startEndMarkers.length > 0 &&
                                   marker.id !== startEndMarkers[0]?.id && 
                                   marker.id !== startEndMarkers[1]?.id;
                        })
                        .map(function(marker) { return marker.id; });
                } else {
                    // Show only markers with the selected status
                    markerIdsToShow = myMap.markersAll
                        .filter(function(marker) {
                            return marker.group === "route" &&
                                   marker.status === selectedStatus &&
                                   startEndMarkers.length > 0 &&
                                   marker.id !== startEndMarkers[0]?.id && 
                                   marker.id !== startEndMarkers[1]?.id;
                        })
                        .map(function(marker) { return marker.id; });
                }

                // Hide all route markers first (except start/end)
                var allRouteMarkerIds = myMap.markersAll
                    .filter(function(marker) {
                        return marker.group === "route" &&
                               startEndMarkers.length > 0 &&
                               marker.id !== startEndMarkers[0]?.id && 
                               marker.id !== startEndMarkers[1]?.id;
                    })
                    .map(function(marker) { return marker.id; });

                if (allRouteMarkerIds.length > 0) {
                    myMap.filterMarkers({ ids: allRouteMarkerIds, show: 0 });
                }

                // Show only the filtered markers
                if (markerIdsToShow.length > 0) {
                    myMap.filterMarkers({ ids: markerIdsToShow, show: 1 });
                }
            });
        }

        function updateRoute() {
            const urlModel = {
                did: decodedUrl.did,
                date: $("#date").val(),
                start_time: $("#start_time").val(),
                end_time: $("#end_time").val()
            };

            const encodedUrl = Base64Helper.encode(urlModel);
            window.location.href = `/vehicle-map/${encodedUrl}`;
        }

        function showSpeedAnalysis() {
            if (!routeData || routeData.length === 0) {
                showNotification('warning', __('No route data available'));
                return;
            }

            var speeds = routeData.map(function(point) {
                return parseFloat(point.speed) || 0;
            });

            var maxSpeed = Math.max(...speeds);
            var avgSpeed = speeds.reduce((a, b) => a + b, 0) / speeds.length;
            var speedViolations = speeds.filter(speed => speed > 80).length; // Assuming 80 km/h limit

            var message = `
                ${__('Speed Analysis')}:
                • ${__('Max Speed')}: ${maxSpeed.toFixed(1)} km/h
                • ${__('Avg Speed')}: ${avgSpeed.toFixed(1)} km/h
                • ${__('Speed Violations')}: ${speedViolations}
            `;

            showNotification('info', message);
        }

        // Generate real hourly data from route data
        function generateHourlyData(routeData) {
    
            if (!routeData || routeData.length === 0) {
                // Fallback to sample data if no route data
                return {
                    hourlyPoints: [12, 19, 13, 15, 12, 13, 17, 20, 18, 22, 19, 15, 14, 16, 18, 20, 22, 21, 19, 17, 15, 13, 12, 10],
                    hourlyDistance: [1.2, 1.9, 1.3, 1.5, 1.2, 1.3, 1.7, 2.0, 1.8, 2.2, 1.9, 1.5, 1.4, 1.6, 1.8, 2.0, 2.2, 2.1, 1.9, 1.7, 1.5, 1.3, 1.2, 1.0],
                    hourlyAvgSpeed: [32, 29, 33, 35, 32, 33, 37, 40, 38, 42, 39, 35, 34, 36, 38, 40, 42, 41, 39, 37, 35, 33, 32, 30],
                    hourlyDuration: [0.5, 0.8, 0.6, 0.7, 0.5, 0.6, 0.9, 1.0, 0.8, 1.1, 0.9, 0.7, 0.6, 0.7, 0.8, 1.0, 1.1, 1.0, 0.9, 0.8, 0.7, 0.6, 0.5, 0.4]
                };
            }

            // Initialize hourly arrays (24 hours)
            var hourlyPoints = new Array(24).fill(0);
            var hourlyDistance = new Array(24).fill(0);
            var hourlySpeed = new Array(24).fill(0);
            var hourlySpeedCount = new Array(24).fill(0);
            var hourlyDuration = new Array(24).fill(0);

            // Process each route point
            for (var i = 0; i < routeData.length; i++) {
                var point = routeData[i];
                var date = new Date(point.timestamp);
                var hour = date.getHours();

                // Count points per hour
                hourlyPoints[hour]++;

                if (i > 0) {
                    var distance = parseFloat(point.distance) || 0;
                    hourlyDistance[hour] += distance;
                }

                // Accumulate speed for average calculation
                var speed = parseFloat(point.speed) || 0;
                hourlySpeed[hour] += speed;
                hourlySpeedCount[hour]++;

                // Calculate duration (time between points)
                if (i > 0) {
                    var prevDate = new Date(routeData[i-1].timestamp);
                    var duration = (date - prevDate) / (1000 * 60 * 60); // hours
                    hourlyDuration[hour] += duration;
                }
            }

            // Calculate average speeds
            var hourlyAvgSpeed = hourlySpeed.map(function(speed, index) {
                return hourlySpeedCount[index] > 0 ? speed / hourlySpeedCount[index] : 0;
            });

            return {
                hourlyPoints: hourlyPoints,
                hourlyDistance: hourlyDistance,
                hourlyAvgSpeed: hourlyAvgSpeed,
                hourlyDuration: hourlyDuration
            };
        }

        function makeApexSparkline(divId, data, color, chartType, label) {

            $("#" + divId).html('');
            
            // Generate time labels for x-axis (00:00 to 23:00)
            var timeLabels = [];
            for (var i = 0; i < 24; i++) {
                timeLabels.push(i.toString().padStart(2, '0') + ':00');
            }
            
            var options = {
                chart: {
                    type: 'line',
                    height: 40,
                    sparkline: { enabled: true }
                },
                series: [{
                    name: label,
                    data: data
                }],
                stroke: { curve: 'smooth', width: 2 },
                colors: [color],
                xaxis: {
                    categories: timeLabels,
                    labels: {
                        show: false // Hide x-axis labels for sparkline
                    }
                },
                tooltip: {
                    enabled: true,
                    x: { 
                        show: true,
                        formatter: function(value) {
                            // Show time format in tooltip
                            return timeLabels[value] || value;
                        }
                    },
                    y: {
                        title: {
                            formatter: function() { return label; }
                        },
                        formatter: function(value) {
                            if (chartType === 'duration') {
                                // Format duration for display
                                if (value === 0) return '0m';
                                
                                var totalMinutes = Math.round(value * 60); // Convert hours to minutes
                                var hours = Math.floor(totalMinutes / 60);
                                var minutes = totalMinutes % 60;
                                
                                if (hours > 0) {
                                    return hours + __('h') + (minutes > 0 ? minutes + __('m') : '');
                                } else {
                                    return minutes + __('m');
                                }
                            } else if (chartType === 'distance') {
                                return value.toFixed(1) + ' ' + __(lengthUnit);
                            } else if (chartType === 'avg-speed') {
                                return value.toFixed(1) + ' ' + __(speedUnit);
                            } else {
                                return value;
                            }
                        }
                    }
                }
            };
            new ApexCharts(document.querySelector("#" + divId), options).render();
        }

        function initializeSparklines() {
            // Generate real data from route data
            var realData = generateHourlyData(routeData);
            var hourlyPoints = realData.hourlyPoints;
            var hourlyDistance = realData.hourlyDistance;
            var hourlyAvgSpeed = realData.hourlyAvgSpeed;
            var hourlyDuration = realData.hourlyDuration;

            makeApexSparkline('apex-total-points', hourlyPoints, '#206bc4', 'points', __('Points'));
            makeApexSparkline('apex-total-distance', hourlyDistance, '#22c55e', 'distance', __('Distance'));
            makeApexSparkline('apex-avg-speed', hourlyAvgSpeed, '#10b981', 'avg-speed', __('Avg Speed'));
            makeApexSparkline('apex-total-duration', hourlyDuration, '#f59e0b', 'duration', __('Duration'));
        }

        // Initialize additional charts
        function initializeAdditionalCharts() {
            createSpeedDistributionChart();
            createHourlyActivityChart();
            createRoutePerformanceChart();
            createStatusDistributionChart();
        }

        // Speed Distribution Chart
        function createSpeedDistributionChart() {
            if (!routeData || routeData.length === 0) {
                return;
            }

            // Clear loading content
            var chartContainer = document.querySelector("#speed-distribution-chart");
            if (!chartContainer) {
                console.warn('Speed distribution chart container not found');
                return;
            }
            chartContainer.innerHTML = '';

            var speeds = routeData.map(function(point) {
                return parseFloat(point.speed) || 0;
            }).filter(function(speed) {
                return speed > 0; // Filter out zero speeds
            });

            // Create speed ranges
            var speedRanges = [
                { min: 0, max: 10, label: '0-10 ' + __(speedUnit), count: 0 },
                { min: 10, max: 20, label: '10-20 ' + __(speedUnit), count: 0 },
                { min: 20, max: 30, label: '20-30 ' + __(speedUnit), count: 0 },
                { min: 30, max: 40, label: '30-40 ' + __(speedUnit), count: 0 },
                { min: 40, max: 50, label: '40-50 ' + __(speedUnit), count: 0 },
                { min: 50, max: 60, label: '50-60 ' + __(speedUnit), count: 0 },
                { min: 60, max: 70, label: '60-70 ' + __(speedUnit), count: 0 },
                { min: 70, max: 80, label: '70-80 ' + __(speedUnit), count: 0 },
                { min: 80, max: 90, label: '80-90 ' + __(speedUnit), count: 0 },
                { min: 90, max: 100, label: '90-100 ' + __(speedUnit), count: 0 },
                { min: 100, max: Infinity, label: '100+ ' + __(speedUnit), count: 0 }
            ];

            // Count speeds in each range
            speeds.forEach(function(speed) {
                for (var i = 0; i < speedRanges.length; i++) {
                    if (speed >= speedRanges[i].min && speed < speedRanges[i].max) {
                        speedRanges[i].count++;
                        break;
                    }
                }
            });

            // Check if we have any speed data
            var totalSpeedPoints = speedRanges.reduce(function(sum, range) { return sum + range.count; }, 0);
            if (totalSpeedPoints === 0) {
                console.warn('No speed data available for chart');
                chartContainer.innerHTML = '<div class="text-center py-4"><i class="ti ti-chart-bar-off text-muted" style="font-size: 3rem;"></i><p class="text-muted mt-2">' + __('No speed data available') + '</p></div>';
                return;
            }

            var options = {
                chart: {
                    type: 'bar',
                    height: 300,
                    toolbar: { show: false }
                },
                series: [{
                    name: __('Speed Points'),
                    data: speedRanges.map(function(range) { return range.count; })
                }],
                xaxis: {
                    categories: speedRanges.map(function(range) { return range.label; }),
                    labels: { rotate: -45, style: { fontSize: '10px' } }
                },
                yaxis: {
                    title: { text: __('Number of Points') }
                },
                colors: ['#206bc4'],
                plotOptions: {
                    bar: {
                        borderRadius: 4,
                        dataLabels: { position: 'top' }
                    }
                },
                dataLabels: {
                    enabled: true,
                    formatter: function(val) {
                        return val > 0 ? val : '';
                    }
                },
                tooltip: {
                    y: {
                        formatter: function(value) {
                            return value + ' ' + __('points');
                        }
                    }
                }
            };

            try {
                new ApexCharts(document.querySelector("#speed-distribution-chart"), options).render();
    
            } catch (error) {
                console.error('Error rendering speed distribution chart:', error);
            }
        }

        // Hourly Activity Chart
        function createHourlyActivityChart() {
            if (!routeData || routeData.length === 0) return;

            // Clear loading content
            var chartContainer = document.querySelector("#hourly-activity-chart");
            if (chartContainer) {
                chartContainer.innerHTML = '';
            }

            var realData = generateHourlyData(routeData);
            var hours = Array.from({length: 24}, (_, i) => i + ':00');

            var options = {
                chart: {
                    type: 'area',
                    height: 300,
                    toolbar: { show: false }
                },
                series: [
                    {
                        name: __('Points'),
                        data: realData.hourlyPoints
                    },
                    {
                        name: __('Distance'),
                        data: realData.hourlyDistance
                    }
                ],
                xaxis: {
                    categories: hours,
                    labels: { style: { fontSize: '10px' } }
                },
                yaxis: [
                    {
                        title: { text: __('Points') },
                        labels: { formatter: function(val) { return Math.round(val); } }
                    },
                    {
                        opposite: true,
                        title: { text: __('Distance') + ' (' + lengthUnit + ')' },
                        labels: { formatter: function(val) { return val.toFixed(2); } }
                    }
                ],
                colors: ['#206bc4', '#22c55e'],
                stroke: { curve: 'smooth', width: 2 },
                fill: {
                    type: 'gradient',
                    gradient: {
                        shadeIntensity: 1,
                        opacityFrom: 0.7,
                        opacityTo: 0.2,
                        stops: [0, 100]
                    }
                },
                tooltip: {
                    shared: true,
                    intersect: false,
                    y: {
                        formatter: function(value, { seriesIndex }) {
                            if (seriesIndex === 0) {
                                return value + ' ' + __('points');
                            } else {
                                return value.toFixed(2) + ' ' + __(lengthUnit);
                            }
                        }
                    }
                },
                dataLabels: {
                    enabled: true,
                    formatter: function(val, opts) {
                        // If it's the distance series (seriesIndex === 1), format to 2 decimals
                        if (opts.seriesIndex === 1) {
                            return val > 0 ? val.toFixed(2) : '';
                        }
                        // For points, show as integer
                        return val > 0 ? Math.round(val) : '';
                    }
                }
            };

            new ApexCharts(document.querySelector("#hourly-activity-chart"), options).render();
        }

        // Route Performance Chart
        function createRoutePerformanceChart() {
            if (!routeData || routeData.length === 0) return;

            // Clear loading content
            var chartContainer = document.querySelector("#route-performance-chart");
            if (chartContainer) {
                chartContainer.innerHTML = '';
            }

            // Calculate performance metrics over time
            var timeSegments = [];
            var speeds = [];
            var distances = [];
            var efficiencies = [];
            
            // Divide route into 20 segments for analysis
            var segmentSize = Math.floor(routeData.length / 20);
            
            for (var i = 0; i < 20; i++) {
                var startIdx = i * segmentSize;
                var endIdx = Math.min((i + 1) * segmentSize, routeData.length);
                var segment = routeData.slice(startIdx, endIdx);
                
                if (segment.length === 0) continue;
                
                // Calculate segment metrics
                var segmentDistance = 0;
                var segmentSpeed = 0;
                var validSpeeds = 0;
                
                for (var j = 1; j < segment.length; j++) {
                    var distance = segment[j].distance || 0;
                    segmentDistance += distance;
                    var speed = parseFloat(segment[j].speed) || 0;
                    if (speed > 0) {
                        segmentSpeed += speed;
                        validSpeeds++;
                    }
                }
                
                var avgSpeed = validSpeeds > 0 ? segmentSpeed / validSpeeds : 0;
                var efficiency = segmentDistance > 0 ? (avgSpeed / segmentDistance) * 100 : 0; // Efficiency score
                
                timeSegments.push('S' + (i + 1));
                speeds.push(avgSpeed);
                distances.push(segmentDistance);
                efficiencies.push(efficiency);
            }

            var options = {
                chart: {
                    type: 'line',
                    height: 250,
                    toolbar: { show: false }
                },
                series: [
                    {
                        name: __('Speed'),
                        data: speeds
                    },
                    {
                        name: __('Distance'),
                        data: distances
                    },
                    {
                        name: __('Efficiency'),
                        data: efficiencies
                    }
                ],
                xaxis: {
                    categories: timeSegments,
                    title: { text: __('Route Segments') }
                },
                yaxis: [
                    {
                        title: { text: __('Speed') + ' (' + speedUnit + ')' },
                        labels: { formatter: function(val) { return val.toFixed(1); } }
                    },
                    {
                        opposite: true,
                        title: { text: __('Distance') + ' (' + lengthUnit + ')' },
                        labels: { formatter: function(val) { return val.toFixed(2); } }
                    }
                ],
                colors: ['#206bc4', '#22c55e', '#f59e0b'],
                stroke: { curve: 'smooth', width: 2 },
                markers: { size: 4 },
                tooltip: {
                    shared: true,
                    intersect: false,
                    y: {
                        formatter: function(value, { seriesIndex }) {
                            if (seriesIndex === 0) {
                                return value.toFixed(1) + ' ' + __(speedUnit);
                            } else if (seriesIndex === 1) {
                                return value.toFixed(2) + ' ' + __(lengthUnit);
                            } else {
                                return value.toFixed(1) + '%';
                            }
                        }
                    }
                }
            };

            new ApexCharts(document.querySelector("#route-performance-chart"), options).render();
        }

        // Status Distribution Chart
        function createStatusDistributionChart() {
            if (!routeData || routeData.length === 0) return;

            // Clear loading content
            var chartContainer = document.querySelector("#status-distribution-chart");
            if (chartContainer) {
                chartContainer.innerHTML = '';
            }

            var statusCounts = {};
            routeData.forEach(function(point) {
                var status = point.status_name || 'Unknown';
                statusCounts[status] = (statusCounts[status] || 0) + 1;
            });

            var statusData = Object.keys(statusCounts).map(function(status) {
                return {
                    x: __(status),
                    y: statusCounts[status]
                };
            });

            var options = {
                chart: {
                    type: 'donut',
                    height: 250,
                    toolbar: { show: false }
                },
                series: statusData.map(function(item) { return item.y; }),
                labels: statusData.map(function(item) { return item.x; }),
                colors: ['#206bc4', '#22c55e', '#f59e0b', '#ef4444', '#8b5cf6'],
                plotOptions: {
                    pie: {
                        donut: {
                            size: '60%',
                            labels: {
                                show: true,
                                total: {
                                    show: true,
                                    label: __('Total'),
                                    formatter: function(w) {
                                        return w.globals.seriesTotals.reduce((a, b) => a + b, 0);
                                    }
                                }
                            }
                        }
                    }
                },
                dataLabels: {
                    enabled: true,
                    formatter: function(val, opts) {
                        return opts.w.globals.seriesTotals[opts.seriesIndex];
                    }
                },
                tooltip: {
                    y: {
                        formatter: function(value) {
                            return value + ' ' + __('points');
                        }
                    }
                }
            };

            new ApexCharts(document.querySelector("#status-distribution-chart"), options).render();
        }

        // Initialize Hour Range Slider after map and data load
        function initializeHourRangeSlider() {
            var range = document.getElementById('range-connect');
            if (!range || typeof noUiSlider === 'undefined') return;
            if (range.noUiSlider) return; // Prevent double init
            noUiSlider.create(range, {
                start: [0, 24],
                connect: true,
                step: 1/60,
                range: {
                    'min': 0,
                    'max': 24
                },
                tooltips: [true, true],
                format: {
                    to: function (value) {
                        return decimalToHourMin(value);
                    },
                    from: function (value) {
                        return Number(value.replace(':00', ''));
                    }
                }
            });
            range.noUiSlider.on('update', function(values, handle) {
                // Only filter if the slider has been moved from initial position
                if (values[0] !== 0 || values[1] !== 24) {
                    filterMarkersByHour(values[0], values[1]);
                }
            });
        }

        function decimalToHourMin(value) {
            var hour = Math.floor(value);
            var minute = Math.round((value - hour) * 60);
            if (minute === 60) {
                hour += 1;
                minute = 0;
            }
            return hour.toString().padStart(2, '0') + ':' + minute.toString().padStart(2, '0');
        }

        // Filter vehicle markers by hour range
        function filterMarkersByHour(minHour, maxHour) {
            if (!routeMarkers || !Array.isArray(routeMarkers)) return;
            
            var showIds = [];
            var hideIds = [];
            routeMarkers.forEach(function(marker) {
                if (!marker.timestamp) return;
                var hour = marker.timestamp.split(' ')[1];
                if (hour >= minHour && hour <= maxHour) {
                    showIds.push(marker.id);
                } else {
                    hideIds.push(marker.id);
                }
            });

            if (hideIds.length) myMap.filterMarkers({ ids: hideIds, show: 0 });
            if (showIds.length) myMap.filterMarkers({ ids: showIds, show: 1 });

            var showStartEndIds = startEndMarkers.map(m => m.id);
            if (showStartEndIds.length) myMap.filterMarkers({ ids: showStartEndIds, show: 1 });

            //change coordinates of start and end markers
            try {
                var newStartMarker = myMap.markersAll.find(m => m.group == "route" && m.id == showIds[0]).coord;
                var newEndMarker = myMap.markersAll.find(m => m.group == "route" && m.id == showIds[showIds.length - 1]).coord;
                
                //find start and end markers in markersCluster
                var findStartMarker = myMap.markersCluster.getLayers().find(function (m) {
                    return m.options.id === showStartEndIds[0];
                });
                var findEndMarker = myMap.markersCluster.getLayers().find(function (m) {
                    return m.options.id === showStartEndIds[showStartEndIds.length - 1];
                });

                findStartMarker.setLatLng(newStartMarker);
                findEndMarker.setLatLng(newEndMarker);

            } catch (e) {
                //console.log("Error", e);
            }           
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views/vehicle-map.blade.php ENDPATH**/ ?>