

<?php $__env->startSection('title', __('Places & Coordinates') ); ?>

<?php $__env->startSection('content'); ?>

<!-- Page header -->
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <div class="page-pretitle">
                    <a href="/dashboard" class="text-muted"><?php echo e(__('Dashboard')); ?></a> / <?php echo e(__('Geographic Management')); ?>

                </div>
                <h2 class="page-title">
                    <i class="ti ti-map-pin me-2 text-primary"></i>
                    <?php echo e(__('Places & Coordinates')); ?>

                </h2>
                <div class="page-subtitle">
                    <p class="text-muted mb-0">
                        <?php echo e(__('Places description')); ?>

                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Page body -->
<div class="page-body">
    <div class="container-xl">
        <!-- Quick Stats -->
        <div class="row row-deck row-cards mb-4">
            <div class="col-sm-6 col-lg-4">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="subheader"><?php echo e(__('Total Places')); ?></div>
                            <div class="ms-auto lh-1">
                                <div class="display-6 fw-bold" id="totalPlaces">0</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-4">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="subheader"><?php echo e(__('Active Places')); ?></div>
                            <div class="ms-auto lh-1">
                                <div class="display-6 fw-bold text-success" id="activePlaces">0</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-lg-4">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="subheader"><?php echo e(__('Passive Places')); ?></div>
                            <div class="ms-auto lh-1">
                                <div class="display-6 fw-bold text-secondary" id="passivePlaces">0</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row row-deck row-cards">
            <!-- Left Panel - Places List -->
            <div class="col-5">
                <div class="card h-100">
                    <div class="card-header">
                        <h3 class="card-title"><?php echo e(__('Places List')); ?></h3>
                        <div class="card-actions">
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <div id="placesList"></div>
                            <div id="placeForm"></div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Right Panel - Map & Coordinate Editor -->
            <div class="col-7">
                <div class="card h-100">
                    <div class="card-header">
                        <h3 class="card-title" id="mapTitle">
                            <i class="fas fa-map-marker-alt text-blue"></i>
                            <?php echo e(__('Select a place to edit coordinates')); ?>

                        </h3>
                        <div class="card-actions" id="mapActions" style="display: none;">
                            <div class="btn-group" role="group">
                                <button type="button" class="btn btn-sm btn-primary" id="setCoordinates">
                                    <i class="fas fa-map-pin"></i>
                                    <?php echo e(__('Set Coordinates')); ?>

                                </button>
                                <button type="button" class="btn btn-sm btn-success" id="saveCoordinates" disabled>
                                    <i class="fas fa-save"></i>
                                    <?php echo e(__('Save Changes')); ?>

                                </button>
                                <button type="button" class="btn btn-sm btn-danger" id="clearCoordinates">
                                    <i class="fas fa-trash"></i>
                                    <?php echo e(__('Clear All')); ?>

                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div id="mapPlace"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<style>
    #mapPlace {
        height: calc(100vh - 65px);
        width: 100%;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset(config('app.js_page'))); ?>/places.js"></script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views/places.blade.php ENDPATH**/ ?>