<?php
$alarm_form_id = 305; // Acceleration Deceleration alarm form ID
$acceleration_deceleration = $alarms->firstWhere('alarm_form_id', $alarm_form_id);
$j = [];
if($acceleration_deceleration && isset($acceleration_deceleration['settings_json']) &&
$acceleration_deceleration['settings_json']){
if(is_string($acceleration_deceleration['settings_json'])){
$j = json_decode($acceleration_deceleration['settings_json'], true) ?: [];
} else {
$j = $acceleration_deceleration['settings_json'];
}
}
?>
<form class="alarm-form" id="alarmForm_<?php echo e($alarm_form_id); ?>">
    <div class="row mb-3">
        <label class="form-selectgroup-item col-6">
            <input type="radio" name="status_id_<?php echo e($alarm_form_id); ?>" value="1" class="form-selectgroup-input" <?php echo e(isset($acceleration_deceleration['status_id']) && $acceleration_deceleration['status_id'] ? 'checked'
                : ''); ?>>
            <span class="form-selectgroup-label" onclick="saveAlarmSettings(<?php echo e($alarm_form_id); ?>)">
                <i class="icon vertical-center me-1 text-muted ti ti-bell-ringing"></i>
                <?php echo e(__('Alarm Open')); ?>

            </span>
        </label>
        <label class="form-selectgroup-item  col-6">
            <input type="radio" name="status_id_<?php echo e($alarm_form_id); ?>" value="0" class="form-selectgroup-input" <?php echo e(!isset($acceleration_deceleration['status_id']) || !$acceleration_deceleration['status_id'] ? 'checked'
                : ''); ?>>
            <span class="form-selectgroup-label" onclick="saveAlarmSettings(<?php echo e($alarm_form_id); ?>)">
                <i class="icon vertical-center me-1 text-muted ti ti-bell-x"></i>
                <?php echo e(__('Alarm Closed')); ?>

            </span>
        </label>
    </div>
    <div class="mb-3">
        <div class="row g-2">
            <div class="col-12">
                <div class="input-group mb-2">
                    <span class="input-group-text col-6"><?php echo e(__('Acceleration Limit')); ?></span>
                    <select class="form-select" name="p1" onchange="saveAlarmSettings(<?php echo e($alarm_form_id); ?>)">
                        <option value="0">0</option>
                        <option value="1">1</option>
                        <option value="2">2</option>
                        <option value="3">3</option>
                        <option value="4">4</option>
                        <option value="5">5 (Çok Hassas)</option>
                        <option value="6">6</option>
                        <option value="7">7</option>
                        <option value="8">8</option>
                        <option value="9">9</option>
                        <option value="10">10 (Orta Hassas)</option>
                        <option value="11">11</option>
                        <option value="12">12</option>
                        <option value="13">13</option>
                        <option value="14">14</option>
                        <option value="15" selected="">15 (Az Hassas)</option>
                        <option value="16">16</option>
                        <option value="17">17</option>
                        <option value="18">18</option>
                        <option value="19">19</option>
                        <option value="20">20</option>
                    </select>
                    <span class="m-2">km/s</span>
                </div>
            </div>
            <div class="col-12">
                <div class="input-group mb-2">
                    <span class="input-group-text col-6"><?php echo e(__('Deceleration Limit')); ?></span>
                    <select class="form-select" name="p2" onchange="saveAlarmSettings(<?php echo e($alarm_form_id); ?>)">
                        <option value="0">0</option>
                        <option value="1">1</option>
                        <option value="2">2</option>
                        <option value="3">3</option>
                        <option value="4">4</option>
                        <option value="5">5 (Çok Hassas)</option>
                        <option value="6">6</option>
                        <option value="7">7</option>
                        <option value="8">8</option>
                        <option value="9">9</option>
                        <option value="10">10 (Orta Hassas)</option>
                        <option value="11">11</option>
                        <option value="12">12</option>
                        <option value="13">13</option>
                        <option value="14">14</option>
                        <option value="15" selected="">15 (Az Hassas)</option>
                        <option value="16">16</option>
                        <option value="17">17</option>
                        <option value="18">18</option>
                        <option value="19">19</option>
                        <option value="20">20</option>
                    </select>
                    <span class="m-2">km/s</span>
                </div>
            </div>
        </div>
    </div>
</form>
<script>
    setTimeout(() => {
        // set value of p1 and p2
        $('select[name="p1"]').val("<?php echo e($j['p1'] ?? 15); ?>");
        $('select[name="p2"]').val("<?php echo e($j['p2'] ?? 15); ?>");
    }, 100);
</script>
<?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views\partials\forms\settings\acceleration_deceleration.blade.php ENDPATH**/ ?>