<div class="mb-3">
    <label class="form-label"><?php echo e(__("Device Name")); ?></label>
    <div class="input-icon mb-3">
        <span class="input-icon-addon">
            <i class="icon ti ti-id-badge-2"></i>
        </span>
        <input type="text" id="device-name" value="<?php echo e($vehicle['name']); ?>" class="form-control" placeholder="<?php echo e(__("
            Device Name")); ?>">
    </div>
</div>
<div class="mb-3">
    <label class="form-label"><?php echo e(__("Plate")); ?></label>
    <div class="input-icon mb-3">
        <span class="input-icon-addon">
            <i class="icon ti ti-car"></i>
        </span>
        <input type="text" id="plate" value="<?php echo e($vehicle['plate_number']); ?>" class="form-control" placeholder="<?php echo e(__("
            Plate")); ?>">
    </div>
</div>
<div class="mb-3">
    <label class="form-label"><?php echo e(__("Driver")); ?></label>
    <div class="input-icon mb-3">
        <span class="input-icon-addon">
            <i class="icon ti ti-user"></i>
        </span>
        <input type="text" id="driver" value="<?php echo e($vehicle['driver_name']); ?>" class="form-control" placeholder="<?php echo e(__("
            Driver")); ?>">
    </div>
</div>
<div class="mb-3">
    <label class="form-label"><?php echo e(__("How many liters of fuel does it burn per 100 km?")); ?></label>
    <div class="input-icon mb-3">
        <span class="input-icon-addon">
            <i class="icon ti ti-gas-station"></i>
        </span>
        <input type="text" id="fuel-consumption" value="<?php echo e($vehicle['fuel_consumption']); ?>" class="form-control"
            placeholder="<?php echo e(__(" How many liters of fuel does it burn per 100 km?")); ?>">
    </div>
</div>
<div class="mb-3">
    <label class="form-label"><?php echo e(__("Fuel Type")); ?></label>
    <div class="input-icon mb-3">
        <select id="fuel-type" class="form-select">
            <option value=""><?php echo e(__("Select Fuel Type")); ?></option>
            <option value="diesel" <?php echo e(($vehicle['fuel_type'] ?? '' )=='diesel' ? 'selected' : ''); ?>><?php echo e(__("Diesel")); ?>

            </option>
            <option value="gasoline" <?php echo e(($vehicle['fuel_type'] ?? '' )=='gasoline' ? 'selected' : ''); ?>><?php echo e(__("Gasoline")); ?></option>
            <option value="gas" <?php echo e(($vehicle['fuel_type'] ?? '' )=='gas' ? 'selected' : ''); ?>><?php echo e(__("Gas
                (LPG/CNG)")); ?>

            </option>
            <option value="hybrid" <?php echo e(($vehicle['fuel_type'] ?? '' )=='hybrid' ? 'selected' : ''); ?>><?php echo e(__("Hybrid")); ?>

            </option>
            <option value="electric" <?php echo e(($vehicle['fuel_type'] ?? '' )=='electric' ? 'selected' : ''); ?>><?php echo e(__("Electric")); ?></option>
        </select>
    </div>
</div>

<!-- Save Button -->
<div class="mb-3">
    <button type="button" id="save-vehicle-settings" class="btn btn-primary w-100">
        <i class="icon ti ti-device-floppy me-1"></i>
        <?php echo e(__("Save Vehicle Settings")); ?>

    </button>
</div>

<script>
    function initVehicleSettingsGeneral() {
        // Auto-save vehicle settings when form fields change
        let saveTimeout;
        
        function saveVehicleSettings() {
            const deviceId = $('#device_id').val();
            const deviceName = $('#device-name').val();
            const plate = $('#plate').val();
            const driver = $('#driver').val();
            const fuelConsumption = $('#fuel-consumption').val();
            const fuelType = $('#fuel-type').val();
            
            // Prepare data
            const formData = {
                device_id: deviceId,
                device_name: deviceName,
                plate: plate,
                driver: driver,
                fuel_consumption: fuelConsumption,
                fuel_type: fuelType
            };
            
            // Encode data with Base64Helper
            const postData = Base64Helper.encode(formData);
            
            http.post({
                url: "/vehicle-update-settings",
                data: {
                    data: postData
                }
            })
            .then(function(response) {
                if (response.success) {
                    showNotification("success", __(response.message));
                } else {
                    showNotification("error", __(response.message));
                }
            })
            .catch(function(error) {
                console.error("Vehicle settings update error:", error);
                showNotification("error", "<?php echo e(__('Error updating vehicle settings')); ?>");
            });
        }
        
        // Auto-save on input change with debounce
        $('#device-name, #plate, #driver, #fuel-consumption, #fuel-type').on('input change', function() {
            clearTimeout(saveTimeout);
            saveTimeout = setTimeout(saveVehicleSettings, 1000); // Save after 1 second of inactivity
        });
        
        // Manual save button
        $('#save-vehicle-settings').on('click', function() {
            // Clear any pending auto-save
            clearTimeout(saveTimeout);
            // Save immediately
            saveVehicleSettings();
        });
    }
</script><?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views/partials/forms/settings/general.blade.php ENDPATH**/ ?>