<?php
use App\Helpers\Base64Helper;

$get_data = null;
$did = $get_data != null ? $get_data['did'] : '';
$date = $get_data != null ? $get_data['date'] : date('Y-m-d');
$start_date = $get_data != null ? $get_data['date'] : date('Y-m-d', strtotime('-1 day'));
$end_date = $get_data != null ? $get_data['date'] : date('Y-m-d');
?>



<?php $__env->startSection('title', __('Visit Report') ); ?>

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <!-- Page header -->
    <div class="page-header d-print-none">
        <div class="container-xl">
            <div class="row g-2 align-items-center">
                <div class="col">
                    <div class="page-pretitle">
                        <a href="/reports" class="text-muted"><?php echo e(__('Reports')); ?></a> / <?php echo e(__('Operational Reports')); ?>

                    </div>
                    <h2 class="page-title">
                        <i class="ti ti-map-pin me-2"></i>
                        <?php echo e(__('Visit Report')); ?>

                    </h2>
                </div>
                <div class="col-auto ms-auto d-print-none">
                    <div class="btn-list">
                        <button class="btn btn-primary" onclick="printReport()">
                            <i class="ti ti-printer me-2"></i>
                            <?php echo e(__('Print')); ?>

                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Page body -->
    <div class="page-body">
        <div class="container-xl">
            <!-- Filters -->
            <div class="card mb-3">
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-2">
                            <label class="form-label"><?php echo e(__('Vehicle Selection')); ?></label>
                            <select class="form-select" id="vehicleSelect">
                                <option value=""><?php echo e(__('All Vehicles')); ?></option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label"><?php echo e(__('Start Date')); ?></label>
                            <input type="date" class="form-control" id="startDate" value="<?php echo e($start_date); ?>">
                        </div>
                        <div class="col-md-2">
                            <label class="form-label"><?php echo e(__('End Date')); ?></label>
                            <input type="date" class="form-control" id="endDate" value="<?php echo e($end_date); ?>">
                        </div>
                        <div class="col-md-2">
                            <label class="form-label"><?php echo e(__('Location Type')); ?></label>
                            <select class="form-select" id="locationType">
                                <option value="all"><?php echo e(__('All Locations')); ?></option>
                                <option value="places"><?php echo e(__('Places Only')); ?></option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label"><?php echo e(__('Event Type')); ?></label>
                            <select class="form-select" id="eventType">
                                <option value="all"><?php echo e(__('All Events')); ?></option>
                                <option value="entry"><?php echo e(__('Entry Only')); ?></option>
                                <option value="exit"><?php echo e(__('Exit Only')); ?></option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">&nbsp;</label>
                            <button class="btn btn-primary w-100" onclick="loadVisitData()">
                                <i class="ti ti-search me-2"></i>
                                <?php echo e(__('Update Report')); ?>

                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Summary Cards -->
            <div class="row row-cards mb-3">
                <div class="col-sm-6 col-lg-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="subheader"><?php echo e(__('Total Visits')); ?></div>
                            </div>
                            <div class="h1 mb-0" id="totalVisits">-</div>
                            <div class="text-muted" id="visitBreakdown">-</div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="subheader"><?php echo e(__('Entry Events')); ?></div>
                            </div>
                            <div class="h1 mb-0" id="entryVisits">-</div>
                            <div class="text-muted" id="entryTrend">-</div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="subheader"><?php echo e(__('Exit Events')); ?></div>
                            </div>
                            <div class="h1 mb-0" id="exitVisits">-</div>
                            <div class="text-muted" id="exitTrend">-</div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="subheader"><?php echo e(__('Avg. Duration')); ?></div>
                            </div>
                            <div class="h1 mb-0" id="avgDuration">-</div>
                            <div class="text-muted" id="durationTrend">-</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Visit Map -->
            <div class="card mb-3">
                <div class="card-header">
                    <h3 class="card-title"><?php echo e(__('Visit Locations')); ?></h3>
                    <div class="card-actions">
                        <div class="btn-list">
                            <button class="btn btn-sm" onclick="toggleVisitLayers()">
                                <i class="ti ti-layers"></i> <?php echo e(__('Layers')); ?>

                            </button>
                            <button class="btn btn-sm" onclick="toggleMapView()">
                                <i class="ti ti-maximize"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div id="visitMap" style="height: 500px;"></div>
                </div>
            </div>

            <!-- Charts Row -->
            <div class="row mb-3">
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title"><?php echo e(__('Visit Trends')); ?></h3>
                        </div>
                        <div class="card-body">
                            <div id="visitTrendChart"></div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title"><?php echo e(__('Most Visited Locations')); ?></h3>
                        </div>
                        <div class="card-body">
                            <div id="locationChart"></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Visit Details Table -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><?php echo e(__('Visit Details')); ?></h3>
                    <div class="card-actions">
                        <div class="btn-list">
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div id="visit-table"></div>
                </div>
            </div>

            <!-- No Data State -->
            <div class="text-center py-4 d-none" id="noDataState">
                <div class="empty">
                    <div class="empty-img">
                        <i class="ti ti-map-pin text-muted" style="font-size: 3rem;"></i>
                    </div>
                    <p class="empty-title"><?php echo e(__('No visit events found')); ?></p>
                    <p class="empty-subtitle text-muted">
                        <?php echo e(__('No visit events were detected for the selected period and criteria.')); ?>

                    </p>
                </div>
            </div>

            <!-- Loading State -->
            <div class="text-center py-4 d-none" id="loadingState">
                <div class="spinner-border text-primary" role="status">
                    <span class="visually-hidden"><?php echo e(__('Loading...')); ?></span>
                </div>
                <div class="mt-2"><?php echo e(__('Loading visit data...')); ?></div>
            </div>

            <!-- No Vehicle Selected State -->
            <div class="text-center py-4 d-none" id="noVehicleState">
                <div class="empty">
                    <div class="empty-img">
                        <i class="ti ti-car text-muted" style="font-size: 3rem;"></i>
                    </div>
                    <p class="empty-title"><?php echo e(__('No Vehicle Selected')); ?></p>
                    <p class="empty-subtitle text-muted">
                        <?php echo e(__('Please select a vehicle from the dropdown above to generate the visit analysis report.')); ?>

                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<style>
    #visitMap {
        height: 500px;
    }

    .visit-marker .map-icon-label {
        background-color: transparent !important;
        font-size: 15px !important;
        font-weight: 500 !important;
        color: #fff !important;
        padding: 0 !important;
        margin: 0 !important;
        border-radius: 0 !important;
        border: 0 !important;
    }

    .tabulator-cell[tabulator-field="duration_minutes"] {
        font-weight: 600;
    }

    .event-badge {
        padding: 2px 8px;
        border-radius: 12px;
        font-size: 11px;
        font-weight: 600;
    }

    .event-entry {
        background-color: #10b981;
        color: white;
    }

    .event-exit {
        background-color: #ef4444;
        color: white;
    }

    .location-place {
        background-color: #3b82f6;
        color: white;
    }

    .temp-location-marker {
        background: transparent !important;
        border: none !important;
    }

    .temp-location-marker i {
        text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5);
        animation: pulse 1s infinite;
    }

    @keyframes pulse {
        0% {
            transform: scale(1);
        }

        50% {
            transform: scale(1.2);
        }

        100% {
            transform: scale(1);
        }
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    // --- Unit Variables ---
    var speedUnit = "";
    var lengthUnit = "";
    var currency = "";
    
    let visitTable;
    let myMap;
    let visitTrendChart;
    let locationChart;

    onAppReady(function() {        
        // Show initial loading state
        showLoadingState();

        loadVehicles()
        .then(initializeMap)
        .then(initializeTable)
        .then(initializeCharts)
        .then(loadVisitData);
    });

    // Initialize map
    async function initializeMap() {
        myMap = new LeafletMap();
        myMap.initMap("visitMap", {
            
        });
    }

    // Initialize table
    async function initializeTable() {
        visitTable = createTabulator("#visit-table", {
            initialSort: [
                {column: "event_time", dir: "desc"}
            ],
            columns: [
                {title: "#", field: "id", hozAlign: "center", width: 50},
                {
                    title: "<?php echo e(__('Vehicle')); ?>", 
                    field: "vehicle_name",
                },
                {
                    title: "<?php echo e(__('Location')); ?>", 
                    field: "location_name"
                },
                {
                    title: "<?php echo e(__('Type')); ?>", 
                    field: "location_type", 
                    hozAlign: "center",
                    formatter: function(cell) {
                        const type = cell.getValue();
                        return `<span class="event-badge location-place"><?php echo e(__("Place")); ?></span>`;
                    }
                },
                {
                    title: "<?php echo e(__('Event')); ?>", 
                    field: "event_type", 
                    hozAlign: "center",
                    formatter: function(cell) {
                        const event = cell.getValue();
                        const badgeClass = event === 'entry' ? 'event-entry' : 'event-exit';
                        const text = event === 'entry' ? '<?php echo e(__("Entry")); ?>' : '<?php echo e(__("Exit")); ?>';
                        return `<span class="event-badge ${badgeClass}">${text}</span>`;
                    }
                },
                {
                    title: "<?php echo e(__('Event Time')); ?>", 
                    field: "event_time",
                    sorter: "string", // Changed from datetime to string to avoid luxon dependency
                    formatter: function(cell) {
                        const value = cell.getValue();
                        if (!value) return '-';
                        return dateTimeFormatter(value);
                    }
                },
                {
                    title: "<?php echo e(__('Visit Duration')); ?>", 
                    field: "duration_minutes", 
                    hozAlign: "center",
                    headerTooltip: "<?php echo e(__('Time spent inside the location. Shows duration for exit events only.')); ?>",
                    formatter: function(cell) {
                        const minutes = cell.getValue();
                        if (!minutes || minutes === 0) return '-';
                        return formatDuration(minutes);
                    }
                },
                {
                    title: "<?php echo e(__('Status')); ?>", 
                    field: "status", 
                    hozAlign: "center",
                    formatter: function(cell) {
                        const status = cell.getValue();
                        if (status === 'active') {
                            return `<span class="badge text-white bg-yellow"><?php echo e(__("Active")); ?></span>`;
                        } else {
                            return `<span class="badge text-white bg-green"><?php echo e(__("Completed")); ?></span>`;
                        }
                    }
                },
                {
                    title: "<?php echo e(__('Actions')); ?>", 
                    field: "actions", 
                    hozAlign: "center",
                    formatter: function(cell) {
                        const data = cell.getData();
                        let buttons = '';
                        
                        // Show on map button
                        if (data.lat && data.lng) {
                            buttons += `<button class="btn btn-sm btn-primary me-1" onclick="showLocationOnMap(${data.lat}, ${data.lng})" title="<?php echo e(__('Show on map')); ?>">
                                <i class="ti ti-map-pin"></i>
                                <span class="d-none d-md-inline"><?php echo e(__("Map")); ?></span>
                            </button>`;
                        } else {
                            buttons += `<button class="btn btn-sm btn-secondary me-1" disabled title="<?php echo e(__('No coordinates available')); ?>">
                                <i class="ti ti-map-pin"></i>
                                <span class="d-none d-md-inline"><?php echo e(__("Map")); ?></span>
                            </button>`;
                        }
                        
                        // Vehicle history button (if we have vehicle_id and event_time)
                        if (data.vehicle_id && data.event_time) {
                            const eventDate = new Date(data.event_time).toISOString().split('T')[0];
                            const urlEncoded = btoa(JSON.stringify({
                                did: data.vehicle_id,
                                date: eventDate,
                                start_time: "00:01",
                                end_time: "23:59"
                            }));
                            buttons += `<a href="/vehicle-map/${urlEncoded}" class="btn btn-sm btn-info me-1" title="<?php echo e(__('Vehicle History')); ?>">
                                <i class="ti ti-history"></i>
                                <span class="d-none d-md-inline"><?php echo e(__("History")); ?></span>
                            </a>`;
                        }
                        
                        return buttons;
                    }
                }
            ]
        });
    }

    // Initialize charts
    async function initializeCharts() {
        // Visit Trend Chart
        visitTrendChart = new ApexCharts(document.getElementById('visitTrendChart'), {
            chart: {
                type: 'line',
                height: 300,
                toolbar: {
                    show: false
                }
            },
            series: [
                {
                    name: '<?php echo e(__("Entry Events")); ?>',
                    data: []
                },
                {
                    name: '<?php echo e(__("Exit Events")); ?>',
                    data: []
                }
            ],
            xaxis: {
                categories: [],
                labels: {
                    rotate: -45,
                    rotateAlways: false
                }
            },
            yaxis: {
                title: {
                    text: '<?php echo e(__("Events")); ?>'
                },
                min: 0
            },
            colors: ['#10b981', '#ef4444'],
            stroke: {
                curve: 'smooth',
                width: 3
            },
            fill: {
                type: 'gradient',
                gradient: {
                    shadeIntensity: 1,
                    opacityFrom: 0.7,
                    opacityTo: 0.1,
                    stops: [0, 90, 100]
                }
            },
            dataLabels: {
                enabled: false
            },
            legend: {
                position: 'top'
            },
            tooltip: {
                shared: true,
                intersect: false
            }
        });
        
        visitTrendChart.render();

        // Location Chart
        locationChart = new ApexCharts(document.getElementById('locationChart'), {
            chart: {
                type: 'donut',
                height: 300,
                toolbar: {
                    show: false
                }
            },
            series: [],
            labels: [],
            colors: ['#3b82f6', '#8b5cf6', '#10b981', '#f59e0b', '#ef4444'],
            plotOptions: {
                pie: {
                    donut: {
                        size: '60%',
                        labels: {
                            show: true,
                            total: {
                                show: true,
                                label: '<?php echo e(__("Total")); ?>',
                                fontSize: '16px',
                                fontWeight: 600
                            }
                        }
                    }
                }
            },
            dataLabels: {
                enabled: true,
                formatter: function(val, opts) {
                    return opts.w.globals.seriesTotals[opts.seriesIndex];
                }
            },
            legend: {
                position: 'bottom'
            },
            tooltip: {
                y: {
                    formatter: function(value) {
                        return value + ' <?php echo e(__("visits")); ?>';
                    }
                }
            }
        });
        
        locationChart.render();
    }

    // Load vehicles
    async function loadVehicles() {
        http.post({
            url: '/api/vehicles/list',
        }).then(function(response) {
            if (response.success && response.data.vehicles) {
                const vehicleSelect = document.getElementById('vehicleSelect');
                vehicleSelect.innerHTML = '<option value=""><?php echo e(__("All Vehicles")); ?></option>';
                
                response.data.vehicles.forEach(vehicle => {
                    const option = document.createElement('option');
                    option.value = vehicle.did;
                    option.textContent = vehicle.name;
                    vehicleSelect.appendChild(option);
                });
            }
        }).catch(function(error) {
            console.error('<?php echo e(__("Error loading vehicles")); ?>:', error);
        });
    }

    // Load visit data
    async function loadVisitData() {
        const vehicleId = document.getElementById('vehicleSelect').value;
        const startDate = document.getElementById('startDate').value;
        const endDate = document.getElementById('endDate').value;
        const locationType = document.getElementById('locationType').value;
        const eventType = document.getElementById('eventType').value;

        // Show loading state
        showLoadingState();
    
        http.post({
            url: '/api/reports/visit-data',
            data: {
                vehicle: vehicleId,
                start_date: startDate,
                end_date: endDate,
                location_type: locationType
            },
            loading: false
        }).then(function(response) {
            // --- Set units after data is loaded ---
            speedUnit = __(sessionSettings?.speedUnit || 'km/h');
            lengthUnit = __(sessionSettings?.lengthUnit || 'km');
            currency = __(sessionSettings?.currency || 'TRY');
            // ---
            if (response.success) {

                //console.log('Response:', response.data);

                const rawData = response.data.raw_data || [];
                const placesList = response.data.places_list || [];
                const queryInfo = response.data.query_info || {};

                var message = __('#name# used #value# records').replace('#name#', __('Visit Report')).replace('#value#', rawData.length);
                showReportDataProcessingInfo(message);

                // console.log('Raw Data:', rawData);
                // console.log('Places List:', placesList);
                // console.log('Query Info:', queryInfo);
                
                // Process raw data in JavaScript
                processRawVisitData(rawData, placesList, eventType);
            } else {
                hideLoadingState();
                showConfirmDialog({
                    title: '<?php echo e(__("Error")); ?>',
                    message: '<?php echo e(__("Data not found")); ?>',
                    confirmText: '<?php echo e(__("OK")); ?>',
                    showCancelButton: false,
                    type: 'danger',
                    onConfirm: function() {},
                    onCancel: function() {}
                });
            }
        }).catch(function(error) {
            hideLoadingState();
            console.error('Error fetching data:', error);
            showConfirmDialog({
                title: '<?php echo e(__("Error")); ?>',
                message: '<?php echo e(__("Error fetching data")); ?>',
                confirmText: '<?php echo e(__("OK")); ?>',
                showCancelButton: false,
                type: 'danger',
                onConfirm: function() {},
                onCancel: function() {}
            });
        });
    }

    // Process raw data
    function processRawVisitData(rawData, placesList, eventType) {
        // Clear existing map elements
        myMap.removeMarkers();
        myMap.clearAllPolygons();
        myMap.removeCircles();
        
        // 1. Add places to map
        var placeMarkerColor = "gray";
        if (placesList && placesList.length > 0) {
            placesList.forEach(function(place) {
                if (place.latitude && place.longitude) {
                    var marker = [
                        {
                            id: place.id,
                            markerClassName: "place-marker",
                            device_id: 0,
                            label: place.name,
                            status: place.status_id,
                            popup: place.name,
                            coord: [
                                parseFloat(place.latitude),
                                parseFloat(place.longitude),
                            ],
                            icon: {
                                name: "fa-solid fa-location-dot",
                                color: placeMarkerColor,
                                direction: 0,
                                className: "",
                            },
                        },
                    ];
                    myMap.pinMarkers(marker); // add markers to the map
                    
                    // Add circle if radius is defined
                    if (place.radius && place.radius > 0) {
                        var circle = L.circle([place.latitude, place.longitude], {
                            radius: place.radius,
                            color: placeMarkerColor,
                            fillColor: placeMarkerColor,
                            fillOpacity: 0.2,
                        }).addTo(myMap.mapLet);
                    }
                }
            });
        }
        
        // 2. Process visit events
        const events = [];
        const currentVisits = {};
        let eventId = 1;
        
        if (rawData && rawData.length > 0) {
            rawData.forEach(record => {
                // Process place events
                if (record.visit_type && record.location_type === 'place') {
                    const vehicleId = record.did;
                    const visitKey = `place_${vehicleId}_${record.place_id}`;
                    
                    if (record.visit_type === 'entry' && !currentVisits[visitKey]) {
                        // Entry event
                        const event = {
                            id: eventId++,
                            vehicle_id: vehicleId,
                            vehicle_name: record.device_name,
                            location_id: record.place_id,
                            location_name: record.place_name,
                            location_type: 'place',
                            event_type: 'entry',
                            event_time: record.timestamp,
                            lat: parseFloat(record.latitude),
                            lng: parseFloat(record.longitude),
                            status: 'active',
                            radius: record.place_radius,
                            mobile_notification: record.MobilBildirim,
                            log_id: record.log_id
                        };
                        
                        events.push(event);
                        currentVisits[visitKey] = {
                            start_time: record.timestamp,
                            event_id: event.id
                        };
                        
                    } else if (record.visit_type === 'exit' && currentVisits[visitKey]) {
                        // Exit event
                        const visit = currentVisits[visitKey];
                        const duration = calculateDurationMinutes(visit.start_time, record.timestamp);
                        
                        const event = {
                            id: eventId++,
                            vehicle_id: vehicleId,
                            vehicle_name: record.device_name,
                            location_id: record.place_id,
                            location_name: record.place_name,
                            location_type: 'place',
                            event_type: 'exit',
                            event_time: record.timestamp,
                            lat: parseFloat(record.latitude),
                            lng: parseFloat(record.longitude),
                            duration_minutes: duration,
                            status: 'completed',
                            radius: record.place_radius,
                            mobile_notification: record.MobilBildirim,
                            log_id: record.log_id
                        };
                        
                        events.push(event);
                        delete currentVisits[visitKey];
                    }
                }
            });
        }
        
        // Filter events by event type
        const filteredEvents = filterEventsByType(events, eventType);
        
        // Add markers to map for filtered events only
        addEventMarkersToMap(filteredEvents);
        

        setTimeout(() => {
            // 4. Update table with events
            updateTable(filteredEvents);

        }, 500);
        
        // 5. Update charts
        updateCharts(filteredEvents);
        
        // 6. Update summary statistics
        updateSummaryFromEvents(filteredEvents);
        
        // 7. Fit map to show all markers
        myMap.refreshMap().then(() => {
            if (filteredEvents.length > 0) {
                myMap.fitBounds();
            }
        });
        
        // Show message if no events found
        if (filteredEvents.length === 0) {
            hideLoadingState();
            showNoDataState();
        } else {
            hideLoadingState();
            hideAllStates();
        }
    }

    // Refresh map function
    function refreshMap() {
        if (myMap && myMap.mapLet) {
            myMap.mapLet.invalidateSize();
        }
    }

    // Filter events by event type
    function filterEventsByType(events, eventType) {
        if (!eventType || eventType === 'all') {
            return events;
        }
        
        return events.filter(event => event.event_type === eventType);
    }

    // Add event markers to map
    function addEventMarkersToMap(events) {
        // Group events by vehicle and location to pair entry/exit
        const visitSessions = pairEntryExitSessions(events);
        
        // Generate distinct colors for different sessions
        const groupColors = generateDistinctColors(visitSessions.length);
        
        visitSessions.forEach((session, idx) => {
            // Entry marker
            if (session.entry) {
                const eventTime = dateTimeFormatter(session.entry.event_time);
                const popupText = `${session.entry.location_name}<br><?php echo e(__("Entry date")); ?>: ${eventTime}`;
                const label = session.entry.location_name +": "+ session.entry.vehicle_name;
                myMap.pinMarkers([{
                    id: `entry-${session.entry.id}`,
                    label: label,
                    coord: [session.entry.lat, session.entry.lng],
                    icon: { name: "fa-solid fa-sign-in-alt", color: "green", className: "entry-marker" },
                    popup: `${session.entry.vehicle_name}<br>${popupText}`
                }]);
            }
            
            // Exit marker
            if (session.exit) {
                const eventTime = dateTimeFormatter(session.exit.event_time);
                const popupText = `${session.exit.location_name} : ${session.exit.duration_minutes} <?php echo e(__("minutes")); ?><br><?php echo e(__("Exit date")); ?>: ${eventTime}`;
                const label = session.exit.location_name +": "+ session.exit.vehicle_name;
                myMap.pinMarkers([{
                    id: `exit-${session.exit.id}`,
                    label: label,
                    coord: [session.exit.lat, session.exit.lng],
                    icon: { name: "fa-solid fa-sign-out-alt", color: "red", className: "exit-marker" },
                    popup: `${session.exit.vehicle_name}<br>${popupText}`
                }]);
            }
            
            // Add polyline between entry and exit if both exist
            if (session.entry && session.exit) {
                const entryLat = parseFloat(session.entry.lat);
                const entryLng = parseFloat(session.entry.lng);
                const exitLat = parseFloat(session.exit.lat);
                const exitLng = parseFloat(session.exit.lng);
                
                if (!isNaN(entryLat) && !isNaN(entryLng) && !isNaN(exitLat) && !isNaN(exitLng)) {
                    myMap.addPolyline({
                        coords: [[entryLat, entryLng], [exitLat, exitLng]],
                        color: groupColors[idx],
                        weight: 5,
                        opacity: 0.7,
                        smoothFactor: 1,
                    });
                }
            }
        });
    }

    // Helper function to calculate duration in minutes
    function calculateDurationMinutes(startTime, endTime) {
        const start = new Date(startTime);
        const end = new Date(endTime);
        const diffMs = end - start;
        return Math.round(diffMs / (1000 * 60));
    }

    // Pair entry and exit sessions for visit events
    function pairEntryExitSessions(events) {
        // Group by vehicle and location
        const grouped = {};
        events.forEach(e => {
            const key = `${e.vehicle_id}_${e.location_id}`;
            if (!grouped[key]) grouped[key] = [];
            grouped[key].push(e);
        });
        
        const sessions = [];
        Object.values(grouped).forEach(eventList => {
            // Sort by event_time
            eventList.sort((a, b) => new Date(a.event_time) - new Date(b.event_time));
            let entry = null;
            
            eventList.forEach(e => {
                if (e.event_type === 'entry') {
                    entry = e;
                } else if (e.event_type === 'exit' && entry) {
                    // Pair found
                    sessions.push({
                        entry: entry,
                        exit: e,
                        vehicle: entry.vehicle_name,
                        location: entry.location_name,
                        duration: e.duration_minutes
                    });
                    entry = null; // Reset for next session
                }
            });
        });
        return sessions;
    }

    // Generate distinct colors for different groups
    function generateDistinctColors(count) {
        const colors = [
            '#FF6B6B', '#4ECDC4', '#45B7D1', '#96CEB4', '#FFEAA7',
            '#DDA0DD', '#98D8C8', '#F7DC6F', '#BB8FCE', '#85C1E9',
            '#F8C471', '#82E0AA', '#F1948A', '#85C1E9', '#D7BDE2',
            '#FAD7A0', '#ABEBC6', '#F9E79F', '#D5A6BD', '#A9CCE3'
        ];
        
        const result = [];
        for (let i = 0; i < count; i++) {
            result.push(colors[i % colors.length]);
        }
        return result;
    }

    // Update summary statistics
    function updateSummaryStats(summary) {
        $('#totalVisits').text(summary.total_visits);
        $('#entryVisits').text(summary.entry_visits);
        $('#exitVisits').text(summary.exit_visits);
        $('#avgDuration').text(formatDuration(summary.avg_duration));
        
        $('#visitBreakdown').text(`${summary.place_visits} <?php echo e(__("places")); ?>`);
        $('#entryTrend').text('<?php echo e(__("Total entries")); ?>');
        $('#exitTrend').text('<?php echo e(__("Total exits")); ?>');
        $('#durationTrend').text('<?php echo e(__("Average per visit")); ?>');
    }

    // Update summary from processed events
    function updateSummaryFromEvents(events) {
        if (!events || events.length === 0) {
            $('#totalVisits').text('0');
            $('#entryVisits').text('0');
            $('#exitVisits').text('0');
            $('#avgDuration').text('-');
            $('#visitBreakdown').text('0 <?php echo e(__("places")); ?>');
            $('#entryTrend').text('<?php echo e(__("Total entries")); ?>');
            $('#exitTrend').text('<?php echo e(__("Total exits")); ?>');
            $('#durationTrend').text('<?php echo e(__("Average per visit")); ?>');
            return;
        }
        
        const entryEvents = events.filter(e => e.event_type === 'entry');
        const exitEvents = events.filter(e => e.event_type === 'exit');
        const placeEvents = events.filter(e => e.location_type === 'place');
        
        const completedVisits = exitEvents.filter(e => e.duration_minutes > 0);
        const avgDuration = completedVisits.length > 0 
            ? Math.round(completedVisits.reduce((sum, e) => sum + e.duration_minutes, 0) / completedVisits.length)
            : 0;
        
        $('#totalVisits').text(events.length);
        $('#entryVisits').text(entryEvents.length);
        $('#exitVisits').text(exitEvents.length);
        $('#avgDuration').text(formatDuration(avgDuration));
        
        $('#visitBreakdown').text(`${placeEvents.length} <?php echo e(__("places")); ?>`);
        $('#entryTrend').text('<?php echo e(__("Total entries")); ?>');
        $('#exitTrend').text('<?php echo e(__("Total exits")); ?>');
        $('#durationTrend').text('<?php echo e(__("Average per visit")); ?>');
    }

    // Update map with visit data
    function updateMap(data) {
        myMap.removeMarkers();
        
        // Add places to map
        if (data.places) {
            data.places.forEach(place => {
                // Add place marker
                myMap.pinMarkers([{
                    id: `place-${place.id}`,
                    coord: [parseFloat(place.latitude), parseFloat(place.longitude)],
                    icon: {
                        name: "fa-solid fa-location-dot",
                        color: "blue",
                        className: "place-marker"
                    },
                    popup: `${place.name}<br><?php echo e(__("Radius")); ?>: ${place.radius}m`
                }]);

                // Add circle if radius is defined
                if (place.radius && place.radius > 0) {
                    var circle = L.circle([place.latitude, place.longitude], {
                        radius: place.radius,
                        color: "blue",
                        fillColor: "blue",
                        fillOpacity: 0.2,
                    }).addTo(myMap.mapLet);
                }
            });
        }

        // Add visit markers
        if (data.visits) {
            data.visits.forEach(visit => {
                const markerColor = visit.event_type === 'entry' ? 'green' : 'red';
                const iconName = visit.event_type === 'entry' ? 'ti ti-login' : 'ti ti-logout';
                
                myMap.pinMarkers([{
                    id: `visit-${visit.id}`,
                    coord: [visit.lat, visit.lng],
                    icon: {
                        name: iconName,
                        color: markerColor,
                        className: "visit-marker"
                    },
                    popup: `
                        <strong>${visit.vehicle_name}</strong><br>
                        ${visit.location_name}<br>
                        <?php echo e(__("Event")); ?>: ${visit.event_type === 'entry' ? '<?php echo e(__("Entry")); ?>' : '<?php echo e(__("Exit")); ?>'}<br>
                        <?php echo e(__("Time")); ?>: ${dateTimeFormatter(visit.event_time)}
                    `
                }]);
            });
        }

        setTimeout(() => {
            myMap.fitBounds();
            myMap.refreshMap();
        }, 1000);
    }

    // Update charts
    function updateCharts(events) {
        if (events && events.length > 0) {
            // Update visit trend chart
            const visitData = events.reduce((acc, event) => {
                const date = dateTimeFormatter(event.event_time);
                if (!acc[date]) {
                    acc[date] = { entry: 0, exit: 0 };
                }
                if (event.event_type === 'entry') {
                    acc[date].entry++;
                } else {
                    acc[date].exit++;
                }
                return acc;
            }, {});

            const dates = Object.keys(visitData).sort();
            const entryData = dates.map(date => visitData[date].entry);
            const exitData = dates.map(date => visitData[date].exit);

            visitTrendChart.updateOptions({
                xaxis: {
                    categories: dates
                }
            });
            
            visitTrendChart.updateSeries([
                {
                    name: '<?php echo e(__("Entry Events")); ?>',
                    data: entryData
                },
                {
                    name: '<?php echo e(__("Exit Events")); ?>',
                    data: exitData
                }
            ]);

            // Update location chart
            const locationData = events.reduce((acc, event) => {
                acc[event.location_name] = (acc[event.location_name] || 0) + 1;
                return acc;
            }, {});

            const topLocations = Object.entries(locationData)
                .sort(([,a], [,b]) => b - a)
                .slice(0, 5);

            locationChart.updateOptions({
                labels: topLocations.map(([name]) => name)
            });
            
            locationChart.updateSeries(topLocations.map(([,count]) => count));
        } else {
            // Clear charts if no data
            visitTrendChart.updateOptions({
                xaxis: {
                    categories: []
                }
            });
            
            visitTrendChart.updateSeries([
                { name: '<?php echo e(__("Entry Events")); ?>', data: [] },
                { name: '<?php echo e(__("Exit Events")); ?>', data: [] }
            ]);

            locationChart.updateOptions({
                labels: []
            });
            
            locationChart.updateSeries([]);
        }
    }

    // Update table
    function updateTable(visits) {
        if (visits && visits.length > 0) {
            visitTable.setData(visits);
        } else {
            visitTable.setData([]);
        }
    }

    // Helper functions
    function formatDuration(minutes) {
        if (minutes < 60) {
            return `${minutes} <?php echo e(__('min')); ?>`;
        } else {
            const hours = Math.floor(minutes / 60);
            const mins = minutes % 60;
            if (mins === 0) {
                return `${hours} <?php echo e(__('hour')); ?>`;
            } else {
                return `${hours} <?php echo e(__('hour')); ?> ${mins} <?php echo e(__('min')); ?>`;
            }
        }
    }

    function showLocationOnMap(lat, lng) {
        if (!lat || !lng || isNaN(lat) || isNaN(lng)) {
            showConfirmDialog({
                title: '<?php echo e(__("Warning")); ?>',
                message: '<?php echo e(__("Invalid coordinates")); ?>',
                confirmText: '<?php echo e(__("OK")); ?>',
                cancelText: '',
                type: 'warning',
                onConfirm: function() {},
                onCancel: function() {}
            });
            return;
        }
        
        // Center map on the location
        myMap.mapLet.setView([parseFloat(lat), parseFloat(lng)], 16);
        
        // Add a temporary marker to highlight the location
        const tempMarker = L.marker([lat, lng], {
            icon: L.divIcon({
                className: 'temp-location-marker',
                html: '<i class="fa-solid fa-crosshairs" style="color: red; font-size: 20px;"></i>',
                iconSize: [20, 20],
                iconAnchor: [10, 10]
            })
        }).addTo(myMap.mapLet);
        
        // Remove the temporary marker after 3 seconds
        setTimeout(() => {
            myMap.mapLet.removeLayer(tempMarker);
        }, 3000);
    }

    function toggleVisitLayers() {
        showConfirmDialog({
            title: '<?php echo e(__("Info")); ?>',
            message: '<?php echo e(__("Layer toggle feature will be added")); ?>',
            confirmText: '<?php echo e(__("OK")); ?>',
            cancelText: '',
            type: 'info',
            onConfirm: function() {},
            onCancel: function() {}
        });
    }

    function toggleMapView() {
        document.getElementById('visitMap').requestFullscreen();
    }

    function toggleColumns() {
        showConfirmDialog({
            title: '<?php echo e(__("Info")); ?>',
            message: '<?php echo e(__("Column selector feature will be added")); ?>',
            confirmText: '<?php echo e(__("OK")); ?>',
            cancelText: '',
            type: 'info',
            onConfirm: function() {},
            onCancel: function() {}
        });
    }

    function printReport() {
        window.print();
    }

    // State management functions
    function showNoDataState() {
        $('#noDataState').removeClass('d-none');
        $('#noVehicleState').addClass('d-none');
        $('#loadingState').addClass('d-none');
        $('#summaryCards').addClass('d-none');
        $('#visitMap').closest('.card').addClass('d-none');
        $('.row.mb-3').addClass('d-none'); // Charts row
        $('#visit-table').closest('.card').addClass('d-none');
    }

    function showNoVehicleState() {
        $('#noVehicleState').removeClass('d-none');
        $('#noDataState').addClass('d-none');
        $('#loadingState').addClass('d-none');
        $('#summaryCards').addClass('d-none');
        $('#visitMap').closest('.card').addClass('d-none');
        $('.row.mb-3').addClass('d-none'); // Charts row
        $('#visit-table').closest('.card').addClass('d-none');
    }

    function hideAllStates() {
        $('#noDataState').addClass('d-none');
        $('#noVehicleState').addClass('d-none');
        $('#loadingState').addClass('d-none');
        $('#summaryCards').removeClass('d-none');
        $('#visitMap').closest('.card').removeClass('d-none');
        $('.row.mb-3').removeClass('d-none'); // Charts row
        $('#visit-table').closest('.card').removeClass('d-none');
    }

    // Show loading state
    function showLoadingState() {
        $('#loadingState').removeClass('d-none');
        $('#noDataState').addClass('d-none');
        $('#noVehicleState').addClass('d-none');
        $('#summaryCards').addClass('d-none');
        $('#visitMap').closest('.card').addClass('d-none');
        $('.row.mb-3').addClass('d-none'); // Charts row
        $('#visit-table').closest('.card').addClass('d-none');
    }

    // Hide loading state
    function hideLoadingState() {
        $('#loadingState').addClass('d-none');
    }

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\aractakipv1\resources\views\reports\visit-report.blade.php ENDPATH**/ ?>