@php
$alarm_form_id = 306; // Mileage Maintenance alarm form ID
$mileage_maintenance = $alarms->firstWhere('alarm_form_id', $alarm_form_id);
$j = [];
if($mileage_maintenance && isset($mileage_maintenance['settings_json']) && $mileage_maintenance['settings_json']){
if(is_string($mileage_maintenance['settings_json'])){
$j = json_decode($mileage_maintenance['settings_json'], true) ?: [];
} else {
$j = $mileage_maintenance['settings_json'];
}
}
@endphp

<form class="alarm-form" id="alarmForm_{{ $alarm_form_id }}">
    <div class="row mb-3">
        <label class="form-selectgroup-item col-6">
            <input type="radio" name="status_id_{{$alarm_form_id}}" value="1" class="form-selectgroup-input" {{
                isset($mileage_maintenance['status_id']) && $mileage_maintenance['status_id'] ? 'checked' : '' }}>
            <span class="form-selectgroup-label" onclick="saveAlarmSettings({{ $alarm_form_id }})">
                <i class="icon vertical-center me-1 text-muted ti ti-bell-ringing"></i>
                {{ __('Alarm Open') }}
            </span>
        </label>

        <label class="form-selectgroup-item col-6">
            <input type="radio" name="status_id_{{$alarm_form_id}}" value="0" class="form-selectgroup-input" {{
                !isset($mileage_maintenance['status_id']) || !$mileage_maintenance['status_id'] ? 'checked' : '' }}>
            <span class="form-selectgroup-label" onclick="saveAlarmSettings({{ $alarm_form_id }})">
                <i class="icon vertical-center me-1 text-muted ti ti-bell-x"></i>
                {{ __('Alarm Closed') }}
            </span>
        </label>
    </div>

    <div class="mb-3">
        <div class="row g-2">
            <div class="col-12">
                <label class="form-label">{{ __('Maintenance Date') }}</label>
                <input type="date" name="maintenance_km_date" class="form-control"
                    value="{{ $j['maintenance_km_date'] ?? '' }}" onchange="saveAlarmSettings({{ $alarm_form_id }})">
            </div>
            <div class="col-12">
                <div class="input-group mb-2">
                    <span class="input-group-text col-6">{{ __('Maintenance Km') }}</span>
                    <input type="number" name="maintenance_km" min="0" class="form-control" autocomplete="off"
                        value="{{ $j['maintenance_km'] ?? '' }}" onchange="saveAlarmSettings({{ $alarm_form_id }})">
                    <span class="input-group-text">km</span>
                </div>
            </div>
        </div>
    </div>
    {{-- <fieldset class="form-fieldset">
        <div class="mb-3">
            <h3>{{ __('To whom will alarms be sent?') }}</h3>
        </div>
        <div class="mb-3">
            <label class="form-label">{{ __('Cell Phone') }}</label>
            <input type="text" name="input-mask" class="form-control" data-mask="(00) 0000-0000"
                data-mask-visible="true" placeholder="(00) 0000-0000" autocomplete="off">
        </div>
        <div class="mb-3">
            <label class="form-label">{{ __('E-mail') }}</label>
            <input type="email" class="form-control" aria-describedby="emailHelp" placeholder="{{ __('Enter email') }}">
        </div>
    </fieldset> --}}
</form>
{{--
Note:
<script>
    vehicle-settings.blade.php
    function saveAlarmSettings(alarm_form_id) {
</script>
--}}