<?php
/**
 * Step 3: Demo User Information
 */

$error = '';

// Handle form submission - just mark as completed and continue
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['continue'])) {
    $_SESSION['install']['completed_steps'][3] = true;
    
    // Redirect to next step
    header('Location: ?step=4');
    exit;
}
?>

<h2 class="card-title mb-4">
    <i class="ti ti-users me-2"></i> Demo User Accounts
</h2>

<p class="text-muted mb-4">
    The system comes with pre-configured demo users. Use these credentials to login after installation.
</p>

<div class="alert alert-info mb-4">
    <i class="ti ti-info-circle me-2"></i>
    <strong>Note:</strong> These are demo accounts that will be imported with the demo data. You can change passwords after first login.
</div>

<!-- Demo Users Table -->
<div class="card">
    <div class="table-responsive">
        <table class="table table-vcenter card-table">
            <thead>
                <tr>
                    <th>User Type</th>
                    <th>Email</th>
                    <th>Password</th>
                    <th>Permissions</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>
                        <div class="d-flex align-items-center">
                            <span class="avatar avatar-sm me-2 bg-primary text-white">
                                <i class="ti ti-shield-check"></i>
                            </span>
                            <strong>Administrator</strong>
                        </div>
                    </td>
                    <td>
                        <code class="user-select-all">admin@mail.com</code>
                    </td>
                    <td>
                        <code class="user-select-all">123456</code>
                    </td>
                    <td>
                        <span class="badge bg-success">Full Access</span>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<div class="alert alert-warning mt-4">
    <div class="d-flex">
        <div>
            <i class="ti ti-alert-triangle me-2"></i>
        </div>
        <div>
            <h4 class="alert-title">Security Reminder</h4>
            <div class="text-muted">
                <ul class="mb-0 ps-3">
                    <li>Change all passwords immediately after installation</li>
                    <li>Remove or disable demo accounts in production</li>
                    <li>Use strong passwords (minimum 8 characters with numbers and symbols)</li>
                    <li>Enable two-factor authentication if available</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<form method="POST">
    <div class="d-flex justify-content-between mt-4">
        <a href="?step=2" class="btn">
            <i class="ti ti-arrow-left me-2"></i> Back
        </a>
        <div>
            <button type="submit" name="continue" class="btn btn-primary">
                Continue
                <i class="ti ti-arrow-right ms-2"></i>
            </button>
        </div>
    </div>
</form>
