<?php

namespace App\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class Button extends Component
{
    public $type;
    public $size;
    public $outline;
    public $disabled;
    public $href;
    public $target;
    public $onclick;
    public $id;
    public $class;
    public $icon;
    public $iconPosition;
    
    /**
     * Create a new component instance.
     */
    public function __construct(
        $type = 'primary',
        $size = 'md',
        $outline = false,
        $disabled = false,
        $href = null,
        $target = null,
        $onclick = null,
        $id = null,
        $class = null,
        $icon = null,
        $iconPosition = 'left'
    ) {
        $this->type = $type;
        $this->size = $size;
        $this->outline = $outline;
        $this->disabled = $disabled;
        $this->href = $href;
        $this->target = $target;
        $this->onclick = $onclick;
        $this->id = $id;
        $this->class = $class;
        $this->icon = $icon;
        $this->iconPosition = $iconPosition;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.button');
    }
}