<?php

namespace App\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class Alert extends Component
{
    public $type;
    public $dismissible;
    public $icon;
    public $title;
    public $class;
    public $id;
    public $autoHide;
    public $delay;
    
    /**
     * Create a new component instance.
     */
    public function __construct(
        $type = 'info',
        $dismissible = true,
        $icon = null,
        $title = null,
        $class = null,
        $id = null,
        $autoHide = false,
        $delay = 5000
    ) {
        $this->type = $type;
        $this->dismissible = $dismissible;
        $this->icon = $icon;
        $this->title = $title;
        $this->class = $class;
        $this->id = $id;
        $this->autoHide = $autoHide;
        $this->delay = $delay;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.alert');
    }
}