<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\DeviceCoordinatesResource;
use App\Helpers\PublicHelper;
use Illuminate\Support\Facades\Log;


class DeviceResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request, $tokenModel = null): array
    {
        // Parse the JSON log data
        $logData = $this->log_data_json ? json_decode($this->log_data_json, true) : [];
        
        // Extract speed from log data (assuming it's stored in 'hiz' field)
        // sepeed no digit after comma
        $speed = number_format($logData['hiz'] ?? 0, 0);
        
        // Handle case when tokenModel is null (fallback to defaults)
        if ($tokenModel) {
            $mid = $tokenModel['owenerId'];
            $dateFormat = $tokenModel['dateFormat'];
            $timeFormat = $tokenModel['timeFormat'];
        } else {
            $mid = null;
            $dateFormat = 'd.m.y';
            $timeFormat = '24h_double';
        }

        $timeFormatMap = config('app.timeFormatMap', []);
        $phpTimeFormat = $timeFormatMap[$timeFormat] ?? 'H:i:s'; // default fallback

        $dateTimeFormat = $dateFormat . ' ' . $phpTimeFormat;
        

        $statusNameAndColor = $this->getStatusNameAndColor($logData['drx'] ?? 0);

        $deviceData = isset($this->extra_data_json) ? json_decode($this->extra_data_json, true) : null;

        return [
            //'id' => optional($this)->id,
            //'sid' => optional($this)->sid,
            //'mid' => optional($this)->mid,
            'did' => optional($this)->did,
            'gsm' => optional($this)->gsm,
            //'imei' => optional($this)->imei,
            'store_Status' => optional($this)->sts, // Status [0] Inactive in Warehouse [1] Active in Warehouse [2] Active at Customer [3] Inactive at Customer [4] Returned [5] Deleted
            'engine_block_status' => optional($this)->is_engine_blocked, // 0: off, 1: on
            'order' => optional($this)->ord,
            'name' => optional($this)->nm,
            'model' => optional($this)->typ, // brand, model
            'ownership_type' => optional($this)->own, // saled, rented, owned
            //'cats' => optional($this)->cats,
            //'usr' => optional($this)->usr,
            //'ga' => optional($this)->ga,
            //'sens' => optional($this)->sens,
            'device_data' => $deviceData,
            'plate_number' => $deviceData['plt'] ?? null,
            'driver_name' => $deviceData['drvr'] ?? null,
            'fuel_consumption' => $deviceData['lt'] ?? null,
            'fuel_type' => $deviceData['fuel_type'] ?? null,
            //'dt' => optional($this)->dt,
            //'icon' =>$logData['icon'] ?? null,
            //device log
            'status_name' => $statusNameAndColor[0],
            'status_id' => $logData['drx'] ?? null,
            'status_color' => $statusNameAndColor[1],
            'speed' => $speed,
            'direction' => $logData['yon'] ?? null,
            'timestamp' => $this->log_datetime ? date('Y-m-d H:i:s', strtotime($this->log_datetime)) : null,
            'timestamp_ui' => $this->log_datetime ? date($dateTimeFormat, strtotime($this->log_datetime)) : null,
            'latitude' => optional($this)->latitude,
            'longitude' => optional($this)->longitude,
            //'created_at' => $this->created_at ? date('Y-m-d H:i:s', strtotime($this->created_at)) : null,
            //'created_at_ui' => $this->created_at ? date($dateTimeFormat, strtotime($this->created_at)) : null,
            //'updated_at' => $this->updated_at ? date('Y-m-d H:i:s', strtotime($this->updated_at)) : null,
            //'updated_at_ui' => $this->updated_at ? date($dateTimeFormat, strtotime($this->updated_at)) : null,
            //'created_by' => $this->created_by ?? null,
            //'updated_by' => $this->updated_by ?? null,
            //Map coordinates
            //'coordinates' => !empty($this->resource->coordinates) ? VehicleCoordinatesResource::collection($this->resource->coordinates) : [],
            //'coordinates' => $this->coordinates?DeviceCoordinatesResource::collection($this->coordinates):[],
        ];
    }

    function getStatusNameAndColor($status){
        
        switch($status){
            case '0':
                return ['Stoping', 'red'];
            case '1':
                return ['Waiting', 'yellow'];
            case '2':
                return ['Moving', 'green'];
            case '3':
                return ['Pulling', 'black'];
            case '4':
                return ['No Signal!', 'black'];
            default:
                return ['Unknown', 'black'];
        }
    }
}
