<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Helpers\PublicHelper;

class DeviceLogResourse extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request, $tokenModel = null): array
    {
        // Parse the JSON log data
        //$logData = $this->log_data_json ? json_decode($this->log_data_json, true) : [];

        $logData = $this->log_data_json ?? [];
        
        // Extract speed from log data (assuming it's stored in 'hiz' field)
        $speed = $logData['hiz'] ?? 0;

        // Handle case when tokenModel is null (fallback to defaults)
        if ($tokenModel) {
            $mid = $tokenModel['owenerId'];
            $dateFormat = $tokenModel['dateFormat'];
            $timeFormat = $tokenModel['timeFormat'];
        } else {
            $mid = null;
            $dateFormat = 'd.m.y';
            $timeFormat = '24h_double';
        }

        $timeFormatMap = config('app.timeFormatMap', []);
        $phpTimeFormat = $timeFormatMap[$timeFormat] ?? 'H:i:s'; // default fallback

        $dateTimeFormat = $dateFormat . ' ' . $phpTimeFormat;

        $statusNameAndColor = $this->getStatusNameAndColor($logData['drx']);
        
        return [
            'id' => $this->id,
            'device_id' => $this->did,
            'ip' => $this->ip,
            'latitude' => $this->latitude,
            'longitude' => $this->longitude,
            //'coordinates' => $this->coord,
            'building' => $this->notification_sent,
            'delta_distance' => null, // dm column was deleted
            'log_data' => $logData,
            'speed' => $speed,
            'direction' => $logData['yon'] ?? null,
            'altitude' => $logData['yukseklik'] ?? null,
            'satellite_count' => $logData['uydu_sayisi'] ?? null,
            'signal_strength' => $logData['sinyal_gucu'] ?? null,
            'timestamp' => $this->dt?->format('Y-m-d H:i:s'), // Use dt (real time) instead of log_datetime (GPS time may be wrong)
            'timestamp_ui' => $this->dt?->format($dateTimeFormat),
            'created_at' => $this->dt?->format('Y-m-d H:i:s'),
            'created_at_ui' => $this->dt?->format($dateTimeFormat),
            'gps_timestamp' => $this->log_datetime?->format('Y-m-d H:i:s'), // GPS time for reference
            'status_name' => $statusNameAndColor[0],
            'status_color' => $statusNameAndColor[1],
            
            
            // Computed fields for speed violations
            'is_speed_violation' => false, // Will be set by the controller
            'speed_limit' => null, // Will be set by the controller
            'speed_excess' => 0, // Will be calculated by the controller
            
            // Device relationship (if loaded)
            'device' => $this->whenLoaded('device', function () {
                return [
                    'id' => $this->device->did,
                    'name' => $this->device->nm,
                    'plate' => $this->device->plaka ?? null,
                ];
            }),
        ];
    }

    function getStatusNameAndColor($status){
        
        switch($status){
            case '0':
                return ['Stoping', 'red'];
            case '1':
                return ['Waiting', 'yellow'];
            case '2':
                return ['Moving', 'green'];
            case '3':
                return ['Pulling', 'black'];
            case '4':
                return ['No Signal!', 'black'];
            default:
                return ['Stoping', 'red'];
        }
    }
}
