<?php

namespace App\Helpers;

/*
$model = [
    'did' => 'aebcc2b375a24f3f0',
    'date' => '20250525',
    'start_time' => '0000',
    'end_time' => '2359'
];

// Encode
$encoded = Base64Helper::encode($model);

// Decode
$decoded = Base64Helper::decode($encoded); // Varsayılan olarak array döner
*/

class Base64Helper
{
    /**
     * Verilen dizi veya obje verisini JSON'a çevirip Base64 formatına dönüştürür.
     *
     * @param mixed $data Array veya Object olabilir.
     * @return string|null Base64 string veya null
     */
    public static function encode($data): ?string
    {
        try {
            $json = json_encode($data, JSON_UNESCAPED_UNICODE);
            return base64_encode($json);
        } catch (\Exception $e) {
            \Log::error("Base64 encode error: " . $e->getMessage());
            return null;
        }
    }

    /**
     * Base64 olarak gelen veriyi çözüp JSON'dan PHP array veya obje'ye çevirir.
     *
     * @param string $base64
     * @param bool $assoc true → array, false → object
     * @return mixed|null Çözülmüş veri (array|object) veya null
     */
    public static function decode(string $base64 = null, bool $assoc = true)
    {
       
        if(!$base64 || $base64 == '' || $base64 == null){
            return [];
        }

        try {
            $json = base64_decode($base64);
            $data = json_decode($json, $assoc);

            if (json_last_error() !== JSON_ERROR_NONE) {
                \Log::error("JSON decode error: " . json_last_error_msg());
                return null;
            }

            return $data;
        } catch (\Exception $e) {
            \Log::error("Base64 decode error: " . $e->getMessage());
            return null;
        }
    }
}
