# 🚗 Fleet Tracker Pro - GPS Vehicle Tracking & Fleet Management System

A comprehensive, modern GPS tracking and fleet management solution built with Laravel 11, featuring real-time tracking, geofencing, comprehensive reports, and multi-tenant architecture.

---

## 🚀 Built for Developers

**Fleet Tracker Pro is a comprehensive development framework** designed specifically for developers who need a robust, customizable GPS tracking solution. Our clean architecture, extensive mapping libraries, and comprehensive reporting tools enable rapid development and easy integration into existing systems.

### 🗺️ Advanced Mapping Infrastructure

Built on **Leaflet.js** - the industry-leading open-source mapping library - with support for multiple map providers:

**Supported Map Providers:**

-   **OpenStreetMap** - Free, open-source maps
-   **Google Maps** - Streets, Satellite, Hybrid, Terrain (4 variants)
-   **Yandex Maps** - Map, Satellite, Hybrid, Traffic, Panorama (5 variants)
-   **2GIS** - Detailed city maps
-   **Stamen** - Artistic map styles
-   **Custom Tiles** - Easy integration of your own tile servers

### 🎨 Modern UI with Tabler Framework

Frontend built with **Tabler** - a premium open-source admin template based on Bootstrap 5:

-   ✅ Clean, modern, responsive design system
-   ✅ 2,100+ Tabler Icons for consistent iconography
-   ✅ Dark/Light theme support with automatic switching
-   ✅ Pre-built components ready for customization
-   ✅ Mobile-first approach for cross-device compatibility

### ⚡ Powerful Component Library

Battle-tested libraries included:

-   **Tabulator** - Advanced data tables with sorting, filtering, inline editing
-   **ApexCharts** - Interactive, responsive charts and visualizations
-   **Leaflet.draw** - Polygon drawing and geofence creation tools
-   **Marker Clustering** - Efficient handling of thousands of markers
-   **Custom Helpers** - Ready-to-use utilities for common tasks

### 🔧 Developer-Friendly Features

-   **MVC Architecture** - Clean separation of concerns (Laravel best practices)
-   **RESTful API** - JWT-authenticated endpoints for easy integration
-   **Modular Components** - Reusable JavaScript classes and functions
-   **Comprehensive Documentation** - Every function explained with working examples
-   **Well-Commented Code** - Easy to understand and customize
-   **No Framework Lock-in** - Use components independently
-   **Modern ES6+ JavaScript** - Clean, maintainable code

### 📚 Complete Documentation Included

Your development team can start immediately with:

-   Step-by-step installation guide
-   Complete JavaScript API reference
-   Backend API documentation
-   Component usage examples
-   Troubleshooting guides
-   Best practices and patterns

---

## 📸 Screenshots Gallery

Explore all features through **17 comprehensive screenshots** organized by category:

-   **Login & Authentication** - Secure login interface
-   **Maps & Tracking** - Multi-vehicle live tracking, single vehicle view, CCTV integration
-   **Vehicle Management** - Vehicle list with Tabulator, vehicle settings
-   **Geofencing** - Regions (polygons) and places (circles) management
-   **Reports** - Dashboard and detailed reports (parking, speed violations, etc.)
-   **System Settings** - Fuel, maintenance, alerts, system configuration
-   **User Management** - User profiles and role-based access control
-   **Customization** - Theme builder and UI customization

**View Gallery:** Browse `/public/documentation/gallery.html` or check `/public/documentation/images/` directory after installation.

---

## ✨ Key Features

### 🗺️ Real-Time Tracking

-   Live GPS tracking with Leaflet maps
-   Interactive vehicle markers with status indicators
-   Route replay and history
-   Speed and direction indicators
-   Multi-vehicle tracking on single map

### 📊 Comprehensive Reporting

-   **Parking Analysis** - Identify parking locations and durations
-   **Mileage Tracking** - Monitor vehicle kilometers and maintenance schedules
-   **Vehicle Health** - Track vehicle performance and maintenance needs
-   **Working Hours** - Business hours monitoring and compliance
-   **Visit Reports** - Customer location visits tracking
-   **Zone Violations** - Geofence breach detection and reporting
-   **Speed Violations** - Speeding incident tracking
-   **Fuel Consumption** - Fuel usage analysis and costs
-   **Route Efficiency** - Optimize routes and reduce costs
-   **After Hours Activity** - Monitor off-hours vehicle usage
-   **Inspection Schedule** - Maintenance and inspection tracking
-   **Driver Scoring** - Driver behavior analysis

### 🔐 Advanced Features

-   **Geofencing** - Define regions and places with automatic entry/exit detection
-   **Multi-Tenant Architecture** - Support multiple organizations
-   **Role-Based Access Control** - Granular permissions system
-   **Custom Alerts** - Configurable notifications for various events
-   **Multi-Language Support** - Currently supports English and Turkish
-   **Responsive Design** - Works on desktop, tablet, and mobile
-   **Export Capabilities** - Export reports to CSV/Excel
-   **Dark/Light Theme** - Modern UI with Tabler framework

## 🛠️ Tech Stack

-   **Backend**: Laravel 11.x
-   **Database**: MySQL 5.7+ / MariaDB
-   **Authentication**: JWT (JSON Web Tokens)
-   **Maps**: Leaflet.js with OpenStreetMap
-   **Charts**: Chart.js for data visualization
-   **Tables**: Tabulator for interactive data tables
-   **UI Framework**: Tabler (Bootstrap 5 based)
-   **Icons**: Tabler Icons
-   **Frontend**: Vanilla JavaScript, jQuery

## 📋 Requirements

-   PHP 8.1 or higher
-   MySQL 5.7+ or MariaDB 10.3+
-   Composer
-   Apache/Nginx web server
-   SSL Certificate (recommended for production)

### PHP Extensions Required

-   BCMath
-   Ctype
-   JSON
-   Mbstring
-   OpenSSL
-   PDO
-   Tokenizer
-   XML
-   cURL

## 🚀 Installation

### Method 1: Auto Installer (Recommended)

1. Upload all files to your web server
2. Navigate to `http://yourdomain.com/install`
3. Follow the step-by-step installation wizard:
    - System requirements check
    - Database configuration
    - Admin account creation
    - System settings
4. Complete installation and start using!

### Method 2: Manual Installation

1. **Clone or Upload Files**

    ```bash
    # Upload all files to your web server public directory
    ```

2. **Install Dependencies**

    ```bash
    composer install --optimize-autoloader --no-dev
    ```

3. **Configure Environment**

    ```bash
    cp env.example.txt .env
    # Edit .env with your database credentials
    ```

4. **Generate Application Key**

    ```bash
    php artisan key:generate
    ```

5. **Generate JWT Secret**

    ```bash
    php artisan jwt:secret
    ```

6. **Import Database**

    ```bash
    # Import vtc_database_table.sql using phpMyAdmin or command line
    mysql -u username -p database_name < vtc_database_table.sql
    ```

7. **Run Migrations**

    ```bash
    php artisan migrate
    ```

8. **Seed Demo Data** (Optional)

    ```bash
    php artisan db:seed --class=DemoDataSeeder
    ```

9. **Set Permissions**

    ```bash
    chmod -R 775 storage bootstrap/cache
    chown -R www-data:www-data storage bootstrap/cache
    ```

10. **Access Application**
    ```
    URL: http://yourdomain.com
    Demo Login: admin@demo.com
    Password: 123456
    ```

## 📖 Usage

### Adding Your First Vehicle

1. Navigate to "Vehicles" → "Vehicle List"
2. Click "Add Vehicle"
3. Enter device ID, name, and other details
4. Save and start tracking!

### Creating Geofences

1. Go to "Settings" → "Regions" or "Places"
2. Click "Add New"
3. Draw on map or enter coordinates
4. Assign vehicles to geofence
5. Configure alerts

### Generating Reports

1. Navigate to "Reports" menu
2. Select report type
3. Choose vehicle and date range
4. Click "Generate Report"
5. Export or print as needed

## 🔧 Configuration

### System Settings

Access via: Settings → General Settings

-   **Locale**: Language preference
-   **Timezone**: Your timezone
-   **Date/Time Format**: Display preferences
-   **Units**: Speed (km/h, mph), Distance (km, mi), Fuel (liter, gallon)
-   **Currency**: For cost calculations

### User Management

-   Create users with different role levels
-   Assign specific permissions per module
-   Control access to vehicles and features

### Alert Configuration

Configure alerts for:

-   Speed violations
-   Geofence breaches
-   After-hours activity
-   Maintenance due
-   Low fuel
-   Engine diagnostics

## 📁 Project Structure

```
fleet-tracker-pro/
├── app/
│   ├── Http/
│   │   ├── Controllers/    # Business logic
│   │   ├── Middleware/     # Authentication, permissions
│   │   └── Resources/      # API resources
│   ├── Models/             # Database models
│   ├── Helpers/            # Helper functions
│   └── Traits/             # Reusable traits
├── database/
│   ├── migrations/         # Database schema
│   └── seeders/            # Data seeders
├── public/                 # Web root
│   └── assets/             # CSS, JS, images
├── resources/
│   └── views/              # Blade templates
├── routes/
│   └── web.php             # Application routes
└── storage/                # Logs, uploads, cache
```

## 🔒 Security

-   CSRF protection on all forms
-   SQL injection prevention via Eloquent ORM
-   XSS protection via Blade templating
-   JWT token authentication
-   Password hashing
-   Role-based access control
-   Input validation and sanitization

## 🌍 Localization

Currently supports:

-   English (en)
-   Turkish (tr)

To add a new language:

1. Copy `lang/en.json` to `lang/xx.json`
2. Translate all strings
3. Add to language selector

## 📊 API Documentation

### Authentication

All API endpoints require JWT token in header:

```
Authorization: Bearer {jwt_token}
```

### Main Endpoints

-   `GET /api/vehicles/list` - Get all vehicles
-   `POST /vehicle-map` - Get vehicle route data
-   `POST /api/reports/*` - Various report endpoints
-   `GET /api/users/me` - Get current user profile
-   `PATCH /api/users/me` - Update profile

For complete API documentation, see `/documentation/api-reference.html`

## 🐛 Troubleshooting

### Installation Issues

**Database connection error:**

-   Verify database credentials in .env
-   Ensure MySQL service is running
-   Check database user permissions

**500 Internal Server Error:**

-   Check storage/ and bootstrap/cache/ are writable
-   Run: `php artisan config:clear`
-   Check Laravel logs in storage/logs/

**Blank page after installation:**

-   Verify APP_KEY is set in .env
-   Run: `php artisan key:generate`
-   Clear browser cache

### Common Issues

**Maps not loading:**

-   Check internet connection (maps use external tiles)
-   Verify JavaScript console for errors

**No vehicle data:**

-   Ensure device is sending GPS data
-   Check device_logs table for entries
-   Verify date range selection

## 📝 License

This software is licensed under the Envato Regular License / Extended License (depending on your purchase).

**Regular License includes:**

-   Use for single project
-   Modify source code
-   Use for one client

**Extended License includes:**

-   Use for multiple projects
-   Create SaaS product
-   Charge end users

See LICENSE.txt for complete terms.

## 🤝 Support

-   **Documentation**: /documentation/index.html
-   **Support Email**: support@yoursite.com
-   **Report Bugs**: Via CodeCanyon support tab
-   **Feature Requests**: Contact via support

## 📅 Changelog

### Version 1.0.0 (2025-10-08)

-   Initial release
-   12+ comprehensive reports
-   Real-time GPS tracking
-   Geofencing system
-   Multi-tenant architecture
-   Permission system
-   Multi-language support

See CHANGELOG.md for detailed version history.

## 🙏 Credits

-   **Framework**: Laravel 11
-   **Maps**: Leaflet.js
-   **UI**: Tabler
-   **Charts**: Chart.js
-   **Tables**: Tabulator
-   **Icons**: Tabler Icons

## ⚖️ Legal

© 2025 Your Company Name. All rights reserved.

This is a commercial product. Unauthorized distribution, resale, or sharing of source code is prohibited and will result in license termination and legal action.

---

**Made with ❤️ for Fleet Management**
